/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.Global;
import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.optional.ssh.SSHExec;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSHExecActionCodeI
extends AntActionCodeTypeI {
    SSHExec antSSHExecManager;
    String sshCommand = null;
    String sshCommandFile = null;
    String sshOutputFile = null;
    Boolean sshOutputFileAppend = false;
    String sshOutputProperty = null;
    String sshErrorProperty = null;
    Long sshTimeout = null;
    ISecretValue sshHostname = null;
    ISecretValue sshPort = null;
    ISecretValue sshUser = null;
    ISecretValue sshPassword = null;
    Boolean sshTrust = true;
    String sshKnownHosts = null;
    String sshKeyFile = null;
    ISecretValue sshPassPhrase = null;
    ISecretValue proxyPort = null;
    ISecretValue proxyHost = null;
    ISecretValue proxyUser = null;
    ISecretValue proxyPassword = null;
    String proxyProtocol = null;
    String additionalConnectionProperties = null;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public SSHExecActionCodeI() {
        this.actionCodeName = "SSH Exec Class";
        this.actionClassName = "SSHExecActionCodeI";
        this.bNullCodeAllowed = true;
        this.antSSHExecManager = new SSHExec();
        this.antSSHExecManager.setProject(this.project);
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.write(this.sessionName, this.actionClassName + "=>prepareSimpleExecuteCode", this.actionName + Messages.getString("SSHExecActionCodeI.0"), 3, this.actionLevel, "DEBUG");
        try {
            this.sshHostname = this.getLocalSecretBindedParameter(rSet, "SSH_HOST", null);
            this.sshUser = this.getLocalSecretBindedParameter(rSet, "SSH_USER", null);
        }
        catch (EngineExceptionI e) {
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>prepareSimpleExecuteCode, missing mandatory parameter : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        if (this.actionTxtCode != null && !this.actionTxtCode.equals("")) {
            this.sshCommand = this.getFinalBindedCode(rSet, this.actionTxtCode);
        } else {
            this.sshCommand = this.getLocalStringBindedParameter(rSet, "SSH_COMMAND", null);
            if (this.sshCommand == null) {
                try {
                    this.sshCommandFile = this.getLocalStringBindedParameter(rSet, "SSH_COMMAND_FILE");
                }
                catch (EngineExceptionI e) {
                    this.addVariableWithULog(Global.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("SSHExecActionCodeI.1") + e.getMessage(), "String", false);
                    throw new EngineExceptionI(Messages.getString("SSHExecActionCodeI.2"), (Throwable)e);
                }
            }
        }
        this.sshOutputFile = this.getLocalStringBindedParameter(rSet, "SSH_OUTPUT_FILE", null);
        this.sshOutputFileAppend = this.getLocalBooleanBindedParameter(rSet, "SSH_APPEND_OUTPUT_FILE", false);
        this.sshOutputProperty = this.getLocalStringBindedParameter(rSet, "SSH_OUTPUT_PROPERTY", null);
        this.sshErrorProperty = this.getLocalStringBindedParameter(rSet, "SSH_ERROR_OUTPUT_PROPERTY", null);
        this.sshPassword = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD", null));
        this.sshTimeout = this.getLocalLongBindedParameter(rSet, "SSH_TIMEOUT", null);
        this.sshPort = this.getLocalSecretBindedParameter(rSet, "SSH_PORT", null);
        this.sshTrust = this.getLocalBooleanBindedParameter(rSet, "SSH_TRUST_HOSTS", true);
        this.sshKnownHosts = this.getLocalStringBindedParameter(rSet, "SSH_KNOWN_HOSTS_FILE", null);
        this.sshKeyFile = this.getLocalStringBindedParameter(rSet, "SSH_PRIVATE_KEY_FILE", this.getLocalStringBindedParameter(rSet, "SSH_PUBLIC_KEY_FILE", null));
        this.sshPassPhrase = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD_PHRASE", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD_PHRASE", null));
        this.proxyHost = this.getLocalSecretBindedParameter(rSet, "PROXY_HOST", null);
        this.proxyPort = this.getLocalSecretBindedParameter(rSet, "PROXY_PORT", "-1");
        this.proxyProtocol = this.getLocalStringBindedParameter(rSet, "PROXY_PROTOCOL", null);
        this.proxyUser = this.getLocalSecretBindedParameter(rSet, "PROXY_USER", null);
        this.proxyPassword = this.getLocalSecretBindedParameter(rSet, "PROXY_PASSWORD", this.getLocalStringBindedParameter(rSet, "PROXY_UNCRYPTED_PASSWORD", ""));
        this.additionalConnectionProperties = this.getLocalStringBindedParameter(rSet, "SSH_ADDITIONAL_CONNECTION_PROPERTIES", null);
        this.write(this.sessionName, this.actionClassName + "=>prepareSimpleExecuteCode", this.actionName + " : Parameters OK", 3, this.actionLevel, "DEBUG");
        return ret;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        this.secret(context -> {
            this.antSSHExecManager.setHost(this.sshHostname.getString(context));
            this.antSSHExecManager.setUsername(this.sshUser.getString(context));
            if (this.sshTimeout != null) {
                this.antSSHExecManager.setTimeout(this.sshTimeout);
            }
            if (!this.sshPort.isNull()) {
                this.antSSHExecManager.setPort(Integer.parseInt(this.sshPort.getString(context)));
            }
            if (!this.sshPassword.isNull()) {
                this.antSSHExecManager.setPassword(this.sshPassword.decryptString(context));
            }
            return null;
        });
        if (this.sshCommand != null) {
            this.antSSHExecManager.setCommand(this.sshCommand);
        }
        if (this.sshCommandFile != null) {
            this.antSSHExecManager.setCommandResource(this.sshCommandFile);
        }
        if (this.sshOutputFile != null) {
            this.antSSHExecManager.setOutput(new File(this.sshOutputFile));
        }
        if (this.sshOutputFileAppend != null) {
            this.antSSHExecManager.setAppend(this.sshOutputFileAppend);
        }
        if (this.sshOutputProperty != null) {
            this.antSSHExecManager.setOutputproperty(this.sshOutputProperty);
        }
        this.antSSHExecManager.setTrust(this.sshTrust);
        if (this.sshKeyFile != null) {
            this.antSSHExecManager.setKeyfile(this.sshKeyFile);
        }
        if (this.sshKnownHosts != null) {
            this.antSSHExecManager.setKnownhosts(this.sshKnownHosts);
        }
        if (!this.sshPassPhrase.isNull()) {
            this.secret(context -> {
                this.antSSHExecManager.setPassphrase(this.sshPassPhrase.decryptString(context));
                return null;
            });
        }
        if (!this.proxyHost.isNull()) {
            this.secret(context -> {
                this.antSSHExecManager.setProxyHost(this.proxyHost.getString(context));
                if (this.proxyPort.getInteger(context) != -1) {
                    this.antSSHExecManager.setProxyPort(this.proxyPort.getInteger(context));
                }
                return null;
            });
            if (this.proxyProtocol != null) {
                if (this.proxyProtocol.equals("SOCKS5")) {
                    this.antSSHExecManager.setProxyProtocol(5);
                } else if (this.proxyProtocol.equals("SOCKS4")) {
                    this.antSSHExecManager.setProxyProtocol(4);
                } else if (this.proxyProtocol.equals("HTTP")) {
                    this.antSSHExecManager.setProxyProtocol(1);
                }
            }
            if (!this.proxyUser.isNull()) {
                this.secret(context -> {
                    this.antSSHExecManager.setProxyUser(this.proxyUser.getString(context));
                    this.antSSHExecManager.setProxyPassword(this.proxyPassword.decryptString(context));
                    return null;
                });
            }
        }
        if (this.additionalConnectionProperties != null && !this.additionalConnectionProperties.trim().isEmpty()) {
            Properties props = new Properties();
            try {
                props.load(new StringReader(this.additionalConnectionProperties));
            }
            catch (IOException e) {
                throw new EngineExceptionI(Messages.getString("SSHExecActionCodeI.3"));
            }
            this.antSSHExecManager.setAdditionalConnectionProperties(props);
        }
        this.secret(context -> {
            int index;
            String result;
            Exception executionException = null;
            try {
                this.antSSHExecManager.execute();
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
                executionException = e;
            }
            if (this.sshOutputProperty == null && !context.hasSecretValue()) {
                this.sshOutputProperty = "SSH_RET_MESS";
            }
            if (this.sshOutputProperty != null) {
                if (context.hasSecretValue()) {
                    throw new IExternalValueResolverPlugin.ExternalValueResolverException(Messages.getString("SSHExecActionCodeI.4"));
                }
                result = this.antSSHExecManager.getOutMessage();
                if (result != null) {
                    index = result.indexOf(" : ");
                    if (index > -1) {
                        result = result.substring(index + 3);
                    }
                    if ((result = result.trim()).length() > 0) {
                        this.publishVariable(this.sshOutputProperty, result);
                    }
                }
            }
            if (this.sshErrorProperty == null && !context.hasSecretValue()) {
                this.sshErrorProperty = "SSH_ERR_MESS";
            }
            if (this.sshErrorProperty != null) {
                if (context.hasSecretValue()) {
                    throw new IExternalValueResolverPlugin.ExternalValueResolverException(Messages.getString("SSHExecActionCodeI.5"));
                }
                result = this.antSSHExecManager.getErrMessage();
                if (result != null) {
                    index = result.indexOf(" : ");
                    if (index > -1) {
                        result = result.substring(index + 3);
                    }
                    if ((result = result.trim()).length() > 0) {
                        this.publishVariable(this.sshErrorProperty, result);
                    }
                }
            }
            if (executionException != null) {
                throw executionException;
            }
            return null;
        });
        return 0;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        this.prepare(sourceRSet);
        int ret = 0;
        this.executeSimpleCode();
        return ret;
    }
}

