/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.common.actioncodes.connection.JdbcConnectionManager;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.IVariable;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class VariableManagerActionCodeI
extends ActionCodeTypeI {
    String varName = null;
    String varType = null;
    String varDefault = null;
    String varIncrementValue = null;
    String varConf = null;
    String varValue = null;
    String strVarValue = null;
    String varOperation = null;
    String varRefreshSQL = null;
    JdbcConnectionManager varSaveConnection = null;
    JdbcConnectionManager varRefreshConnection = null;
    boolean varIsRefrehSet = false;
    boolean varIsSaveSet = false;
    boolean varDontSave = false;
    String varSaveType = null;
    long varSaveDateLimit = -1L;
    int varSaveNumberLimit = -1;

    public VariableManagerActionCodeI() {
        this.actionCodeName = "Variable Manager Class";
        this.actionClassName = "VariableManagerActionCodeI";
        this.bNullCodeAllowed = true;
    }

    void createTables() throws EngineExceptionI {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Statement dmlStatement = this.varSaveConnection.getJdbcConnection().createStatement();){
                this.debugLog("createTables", Messages.getString("VariableManagerActionCodeI.0"), 2, "DEBUG");
                String txtCode = "DROP TABLE " + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR";
                try {
                    dmlStatement.execute(txtCode);
                }
                catch (Exception e) {
                    this.logger.warn("unexpected", (Throwable)e);
                }
                this.debugLog("createTables", Messages.getString("VariableManagerActionCodeI.1"), 2, "DEBUG");
                if ("com.stambia.jdbc.bigquery.BigQueryConnection".equals(this.varSaveConnection.getJdbcConnection().getClass().getName())) {
                    String stringType = "String";
                    txtCode = "CREATE TABLE " + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR (\tVAR_NAME          \t\t" + stringType + ", VAR_TYPE          \t\t" + stringType + ", VAR_NO_LINE  \t\t\t" + this.numericType + ", VAR_VALUE    \t\t\t" + stringType + ", VAR_CONF    \t\t\t" + stringType + ", VAR_DATE  \t\t\t\t" + stringType + ", VAR_SESS_ID  \t\t" + stringType + " )";
                } else {
                    txtCode = "CREATE TABLE " + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR (\tVAR_NAME          \t\t" + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), VAR_TYPE          \t\t" + this.varcharType + "(10), VAR_NO_LINE  \t\t\t" + this.numericType + "(3) DEFAULT 1, VAR_VALUE    \t\t\t" + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), VAR_CONF    \t\t\t" + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), VAR_DATE  \t\t\t\t" + this.varcharType + "(25), VAR_SESS_ID  \t\t" + this.varcharType + "(50) )";
                }
                dmlStatement.execute(txtCode);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.debugLog("createTables", Messages.getString("VariableManagerActionCodeI.2") + e.getMessage(), 0, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>createTables : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        this.debugLog("createTables", Messages.getString("VariableManagerActionCodeI.3"), 2, "DEBUG");
    }

    boolean existsAllTables() throws EngineExceptionI {
        return this.existsTable(this.varSaveConnection.getJdbcConnection(), this.varSaveConnection.getSqlSchemaName(), "IND_SESSION_VARIABLE_VAR");
    }

    void purgeUntilDate(String untilDate) throws EngineExceptionI {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Statement sqlStatement = this.varSaveConnection.getJdbcConnection().createStatement();){
                this.debugLog("purgeUntilDate", Messages.getString("VariableManagerActionCodeI.4"), 3, "DEBUG");
                String txtCode = Messages.getString("VariableManagerActionCodeI.5") + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR where VAR_DATE < '" + untilDate + "' And VAR_NAME = '" + this.varName + "' And (VAR_CONF= '" + this.varConf + "' OR VAR_CONF IS NULL) ";
                sqlStatement.executeUpdate(txtCode);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.debugLog("purgeUntilDate", Messages.getString("VariableManagerActionCodeI.6") + this.varName + ", " + e.getMessage(), 0, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.7") + this.varName + ", " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
    }

    String getPurgeDateWithNumber() throws EngineExceptionI {
        String ret = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Statement sqlStatement = VariableManagerActionCodeI.createResultSetStatement((Connection)this.varSaveConnection.getJdbcConnection());){
                this.debugLog("getPurgeDateWithNumber", "Statement Created", 2, "DEBUG");
                String txtCode = "Select VAR_DATE, VAR_SESS_ID from " + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR Where VAR_NAME = '" + this.varName + "' And (VAR_CONF= '" + this.varConf + "' OR VAR_CONF IS NULL) Order by VAR_DATE Desc";
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (ResultSet sourceRSet = sqlStatement.executeQuery(txtCode);){
                    String prevSessId = "";
                    String prevDate = "";
                    String curSessId = null;
                    String curDate = null;
                    int nbValues = 0;
                    while (sourceRSet.next() && nbValues != this.varSaveNumberLimit) {
                        if (Thread.interrupted()) {
                            this.debugLog("getPurgeDateWithNumber", Messages.getString("VariableManagerActionCodeI.8"), 3, "DEBUG");
                            throw new InterruptedException(Messages.getString("VariableManagerActionCodeI.9"));
                        }
                        curSessId = sourceRSet.getString("VAR_SESS_ID");
                        curDate = sourceRSet.getString("VAR_DATE");
                        if (!prevSessId.equals(curSessId) || !prevDate.equals(curDate)) {
                            ++nbValues;
                        }
                        if (nbValues != this.varSaveNumberLimit) continue;
                        ret = curDate;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.debugLog("getPurgeDateWithNumber", Messages.getString("VariableManagerActionCodeI.10") + this.varName + ", " + e.getMessage(), 0, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.11") + this.varName + ", " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    void purgeHistory() throws EngineExceptionI {
        String purgeDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.runtimeContext.GLOBAL_DATE_FORMAT);
        if (this.varSaveNumberLimit != -1 && (purgeDate = this.getPurgeDateWithNumber()) != null) {
            this.purgeUntilDate(purgeDate);
        }
        if (this.varSaveDateLimit != -1L) {
            Date dt = new Date();
            try {
                long newdate = dt.getTime();
                dt.setTime(newdate -= this.varSaveDateLimit);
            }
            catch (Exception e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.12") + this.varName + ", " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
            this.purgeUntilDate(dateFormat.format(dt));
        }
    }

    void insertVariableInTable() throws EngineExceptionI {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.runtimeContext.GLOBAL_DATE_FORMAT);
        this.debugLog("insertVariableInTable", Messages.getString("VariableManagerActionCodeI.13"), 3, "DEBUG");
        if (this.varSaveType.equals("LastValue")) {
            this.purgeUntilDate(this.runtimeContext.GLOBAL_MAX_DATE);
            this.debugLog("insertVariableInTable", Messages.getString("VariableManagerActionCodeI.14"), 4, "DEBUG");
        }
        String txtCode = "INSERT into " + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR (VAR_NAME, VAR_TYPE, VAR_NO_LINE, VAR_VALUE, VAR_CONF, VAR_DATE, VAR_SESS_ID)  values (?,?,?,?,?,?,?) ";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement sqlStatement = this.varSaveConnection.getJdbcConnection().prepareStatement(txtCode);){
                this.debugLog("insertVariableInTable", Messages.getString("VariableManagerActionCodeI.15"), 3, "DEBUG");
                int endLig = 0;
                int posLig = 0;
                int noLig = 1;
                Date dtInsert = new Date();
                boolean justOneTime = this.strVarValue != null && this.strVarValue.isEmpty();
                while (posLig < this.strVarValue.length() || justOneTime) {
                    justOneTime = false;
                    if (Thread.interrupted()) {
                        this.debugLog("existsTable", Messages.getString("VariableManagerActionCodeI.16"), 3, "DEBUG");
                        throw new EngineExceptionI(Messages.getString("VariableManagerActionCodeI.17"));
                    }
                    endLig = posLig + (posLig + this.varcharSize > this.strVarValue.length() ? this.strVarValue.length() - posLig : this.varcharSize);
                    sqlStatement.setString(1, this.varName);
                    sqlStatement.setString(2, this.varType);
                    sqlStatement.setInt(3, noLig);
                    sqlStatement.setString(4, this.strVarValue.substring(posLig, endLig));
                    sqlStatement.setString(5, this.varConf);
                    sqlStatement.setString(6, dateFormat.format(dtInsert));
                    sqlStatement.setString(7, this.actionContext.getSessionId());
                    sqlStatement.executeUpdate();
                    posLig = endLig;
                    ++noLig;
                }
                this.debugLog("insertVariableInTable", "Insert OK", 3, "DEBUG");
                if (this.varSaveType.equals("AllValues")) {
                    this.purgeHistory();
                    this.debugLog("insertVariableInTable", "Purge OK ", 4, "DEBUG");
                }
                this.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + "->insertVariableInTable, error for " + this.varName + ", " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
    }

    protected void commit() throws SQLException {
        this.varSaveConnection.commit();
    }

    String getLastValue() throws EngineExceptionI {
        Object ret = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Statement dmlStatement = VariableManagerActionCodeI.createResultSetStatement((Connection)this.varSaveConnection.getJdbcConnection());){
                this.debugLog("getLastValue", "Statement Created", 2, "DEBUG");
                String txtCode = "Select VAR_VALUE, VAR_NO_LINE from " + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR V1\nWhere VAR_NAME = '" + this.varName + "'\nAnd (VAR_CONF= '" + this.varConf + "' OR VAR_CONF IS NULL)\nAnd V1.VAR_DATE in (Select MAX(V2.VAR_DATE)  from " + this.varSaveConnection.getSqlSchemaName() + "IND_SESSION_VARIABLE_VAR V2\nwhere V1.VAR_NAME=V2.VAR_NAME and V1.VAR_NO_LINE=V2.VAR_NO_LINE\nAnd (V2.VAR_CONF= '" + this.varConf + "' OR V2.VAR_CONF IS NULL)\n)";
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (ResultSet sourceRSet = dmlStatement.executeQuery(txtCode);){
                    String[] list = new String[]{};
                    while (sourceRSet.next()) {
                        String value;
                        if (Thread.interrupted()) {
                            this.debugLog("existsTable", Messages.getString("VariableManagerActionCodeI.18"), 3, "DEBUG");
                            throw new EngineExceptionI(Messages.getString("VariableManagerActionCodeI.19"));
                        }
                        int index = sourceRSet.getInt("VAR_NO_LINE");
                        if (index > list.length) {
                            list = Arrays.copyOf(list, index);
                        }
                        list[index - 1] = value = sourceRSet.getString("VAR_VALUE");
                    }
                    int i = 0;
                    while (i < list.length) {
                        ret = i == 0 ? list[i] : (String)ret + list[i];
                        ++i;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.debugLog("getLastValue", Messages.getString("VariableManagerActionCodeI.20") + this.varName + ", " + e.getMessage(), 0, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.21") + this.varName + ", " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    String incrementVariable() throws EngineExceptionI {
        Object ret;
        block19: {
            ret = null;
            try {
                if (this.varIncrementValue != null) {
                    if (this.varType.equals("Integer")) {
                        long intTempValue = 0L;
                        try {
                            intTempValue = Long.valueOf(this.strVarValue);
                            try {
                                long intIncrValue = 0L;
                                intIncrValue = Long.valueOf(this.varIncrementValue);
                                ret = String.valueOf(intTempValue += intIncrValue);
                                break block19;
                            }
                            catch (Exception e2) {
                                throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.22") + this.varType + Messages.getString("VariableManagerActionCodeI.24") + this.varName + "'", (Throwable)e2);
                            }
                        }
                        catch (Exception e2) {
                            throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.23") + this.varType + Messages.getString("VariableManagerActionCodeI.25") + this.varName + "'", (Throwable)e2);
                        }
                    }
                    if (this.varType.equals("Float")) {
                        double floatTempValue = 0.0;
                        try {
                            floatTempValue = Double.parseDouble(this.strVarValue);
                            try {
                                double floatIncrValue = 0.0;
                                floatIncrValue = Double.parseDouble(this.varIncrementValue);
                                ret = String.valueOf(floatTempValue += floatIncrValue);
                                break block19;
                            }
                            catch (Exception e2) {
                                throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.26") + this.varType + Messages.getString("VariableManagerActionCodeI.27") + this.varName + "'", (Throwable)e2);
                            }
                        }
                        catch (Exception e2) {
                            throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.28") + this.varType + Messages.getString("VariableManagerActionCodeI.29") + this.varName + "'", (Throwable)e2);
                        }
                    }
                    if (this.varType.equals("Boolean")) {
                        boolean boolTempValue = false;
                        try {
                            boolTempValue = Boolean.parseBoolean(this.strVarValue);
                            try {
                                boolean boolIncrValue = false;
                                boolIncrValue = Boolean.parseBoolean(this.varIncrementValue);
                                ret = String.valueOf(boolTempValue &= boolIncrValue);
                                break block19;
                            }
                            catch (Exception e2) {
                                throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.30") + this.varType + Messages.getString("VariableManagerActionCodeI.31") + this.varName + "'", (Throwable)e2);
                            }
                        }
                        catch (Exception e2) {
                            throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.32") + this.varType + Messages.getString("VariableManagerActionCodeI.33") + this.varName + "'", (Throwable)e2);
                        }
                    }
                    if (this.varType.equals("String")) {
                        ret = this.strVarValue + this.varIncrementValue;
                    }
                    break block19;
                }
                throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.34") + this.varName + "'");
            }
            catch (Exception e) {
                throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.35") + this.varName + "'", (Throwable)e);
            }
        }
        return ret;
    }

    String getRefreshValue(ResultSet rSet, int rSetCol, int colType) throws EngineExceptionI {
        String ret = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.runtimeContext.GLOBAL_DATE_FORMAT);
        try {
            switch (colType) {
                case -5: {
                    Long bint = rSet.getLong(rSetCol);
                    ret = bint.toString();
                    break;
                }
                case -7: {
                    Boolean bool = rSet.getBoolean(rSetCol);
                    ret = bool.toString();
                    break;
                }
                case 1: {
                    ret = rSet.getString(rSetCol);
                    break;
                }
                case -15: {
                    ret = rSet.getString(rSetCol);
                    break;
                }
                case 91: {
                    ret = dateFormat.format(rSet.getDate(rSetCol));
                    break;
                }
                case 3: {
                    ret = rSet.getBigDecimal(rSetCol).toString();
                    break;
                }
                case 8: {
                    ret = Double.toString(rSet.getDouble(rSetCol));
                    break;
                }
                case 6: {
                    ret = Double.toString(rSet.getDouble(rSetCol));
                    break;
                }
                case 4: {
                    ret = Integer.toString(rSet.getInt(rSetCol));
                    break;
                }
                case -1: {
                    ret = rSet.getString(rSetCol);
                    break;
                }
                case 2: {
                    ret = rSet.getBigDecimal(rSetCol).toString();
                    break;
                }
                case 7: {
                    ret = Float.toString(rSet.getFloat(rSetCol));
                    break;
                }
                case 5: {
                    ret = Short.toString(rSet.getShort(rSetCol));
                    break;
                }
                case 92: {
                    ret = rSet.getTime(rSetCol).toString();
                    break;
                }
                case 93: {
                    ret = rSet.getTimestamp(rSetCol).toString();
                    break;
                }
                case -6: {
                    ret = Byte.toString(rSet.getByte(rSetCol));
                    break;
                }
                case 12: {
                    ret = rSet.getString(rSetCol);
                    break;
                }
                case -9: {
                    ret = rSet.getNString(rSetCol);
                    break;
                }
                case -16: {
                    ret = rSet.getNString(rSetCol);
                    break;
                }
                default: {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.37") + colType + Messages.getString("VariableManagerActionCodeI.36"), "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.38") + colType + Messages.getString("VariableManagerActionCodeI.39"));
                }
            }
        }
        catch (SQLException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>getRefreshValue, SQLException : " + e.getMessage(), "String", false);
            throw new EngineExceptionI(this.actionClassName + "=>getRefreshValue, SQLException : " + e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            ret = null;
        }
        catch (Exception e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>getRefreshValue, Exception : " + e.getMessage(), "String", false);
            throw new EngineExceptionI(this.actionClassName + "=>getRefreshValue, Exception : " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    String refreshVariable() throws EngineExceptionI {
        String ret = null;
        this.debugLog("refreshVariable", Messages.getString("VariableManagerActionCodeI.40"), 4, "DEBUG");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Statement dmlStatement = VariableManagerActionCodeI.createResultSetStatement((Connection)this.varRefreshConnection.getJdbcConnection());){
                String txtCode = this.varRefreshSQL;
                Throwable throwable2 = null;
                Object var7_12 = null;
                try (ResultSet sourceRSet = dmlStatement.executeQuery(txtCode);){
                    ResultSetMetaData rsmd;
                    boolean hasResult = false;
                    if (sourceRSet.next() && (ret = this.getRefreshValue(sourceRSet, 1, (rsmd = sourceRSet.getMetaData()).getColumnType(1))) != null) {
                        hasResult = true;
                    }
                    if (!hasResult) {
                        this.debugLog("refreshVariable", Messages.getString("VariableManagerActionCodeI.41"), 4, "DEBUG");
                        ret = this.getDefaultValue(this.varType);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.debugLog("refreshVariable", Messages.getString("VariableManagerActionCodeI.42") + this.varName + ", SQLException : " + e.getMessage(), 0, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.43") + this.varName + ", SQLException : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        catch (Exception e) {
            this.debugLog("refreshVariable", Messages.getString("VariableManagerActionCodeI.44") + this.varName + ", Exception : " + e.getMessage(), 0, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.45") + this.varName + ", Exception : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    String getDefaultValue(String type) {
        String def = null;
        def = type.equals("Integer") ? "0" : (type.equals("Boolean") ? "false" : (type.equals("Float") ? "0" : (type.equals("String") ? "" : null)));
        return def;
    }

    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("VariableManagerActionCodeI.46"), 3, "DEBUG");
        String tmp = this.getLocalStringBindedParameter(sourceRSet, "VAR_NAME", "");
        this.varName = tmp.startsWith("/") ? tmp.substring(1) : tmp;
        this.varType = this.getLocalStringBindedParameter(sourceRSet, "VAR_TYPE", null);
        if (this.varName.equals("") || this.varType == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.47"), "String", true);
            throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.48"));
        }
        this.varSaveConnection = new JdbcConnectionManager("SAVE", "VAR_SAVE_", this.getActionContext(), this.getActionCodeLogger(), false);
        this.varSaveConnection.setTransactionNameParamName("VAR_SAVE_TRANSACTION_NAME");
        this.varSaveConnection.setTransactionTypeParamName("VAR_SAVE_TRANSACTION_TYPE");
        this.varSaveConnection.prepareConnection(sourceRSet, (ActionCodeTypeI)this);
        this.varSaveType = this.getLocalStringBindedParameter(sourceRSet, "VAR_SAVE_TYPE", "LastValue");
        this.varDontSave = this.getLocalBooleanBindedParameter(sourceRSet, "VAR_DONT_SAVE", false);
        this.varDefault = this.getLocalStringBindedParameter(sourceRSet, "VAR_DEFAULT_VALUE", "");
        this.varValue = this.getLocalStringBindedParameter(sourceRSet, "VAR_VALUE", null);
        this.varIncrementValue = this.getLocalStringBindedParameter(sourceRSet, "VAR_INCREMENT_VALUE", null);
        this.varOperation = this.getLocalStringBindedParameter(sourceRSet, "VAR_OPERATION", "Declare");
        if (this.varOperation != null && this.varOperation.equals("AutomaticValue")) {
            this.varOperation = "Declare";
        }
        this.varConf = this.actionContext.getSessionConfiguration();
        this.varRefreshConnection = new JdbcConnectionManager("REFRESH", "VAR_REFRESH_", this.getActionContext(), this.getActionCodeLogger(), true);
        this.varRefreshConnection.prepareConnection(sourceRSet, (ActionCodeTypeI)this);
        this.varRefreshConnection.setTransactionNameParamName("VAR_REFRESH_TRANSACTION");
        this.varRefreshConnection.setTransactionTypeParamName("VAR_REFRESH_TRANSACTION_TYPE");
        this.varRefreshSQL = this.getLocalStringBindedParameter(sourceRSet, "VAR_REFRESH_SQL", "");
        this.varSaveDateLimit = this.getLocalLongBindedParameter(sourceRSet, "VAR_SAVE_DATE_LIMIT", -1L);
        this.varSaveNumberLimit = this.getLocalIntegerBindedParameter(sourceRSet, "VAR_SAVE_NUMBER_LIMIT", -1);
        try {
            IVariable var = null;
            var = this.engineContext.getVariable(this.varName);
            this.strVarValue = this.actionContext.executeSubstitutionScript(this.engineContext.transformVariableExpression(this.actionName, var.getValue()), "e");
        }
        catch (EngineExceptionI e) {
            if (e.exceptionType != 7 || !this.actionContext.getAllowsScriptingErrors()) {
                throw e;
            }
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
        }
        this.debugLog("prepare", Messages.getString("VariableManagerActionCodeI.49"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeSimpleCode() throws EngineExceptionI {
        boolean disableSave;
        int ret;
        block43: {
            block41: {
                block42: {
                    ret = 0;
                    disableSave = false;
                    if (this.varSaveConnection.exists()) {
                        this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.50") + this.varSaveConnection.getConnectionName(), 3, "DEBUG");
                        this.varSaveConnection.setConnection();
                        if (!this.existsAllTables()) {
                            this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.51"), 3, "DEBUG");
                            this.createTables();
                        }
                        this.varIsSaveSet = true;
                        this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.52") + this.varSaveConnection.getConnectionName(), 3, "DEBUG");
                    }
                    if (!this.varOperation.equals("Declare")) break block41;
                    this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.53"), 3, "DEBUG");
                    if (this.strVarValue != null) break block42;
                    if (this.varValue != null) {
                        this.strVarValue = this.varValue;
                    }
                    if (this.strVarValue == null && this.varIsSaveSet) {
                        this.strVarValue = this.getLastValue();
                        disableSave = true;
                    }
                    if (this.strVarValue == null) {
                        disableSave = false;
                        if (this.varRefreshConnection.exists() && this.varRefreshSQL != null && !this.varRefreshSQL.isEmpty()) {
                            this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.54") + this.varRefreshConnection.getConnectionName(), 3, "DEBUG");
                            this.varRefreshConnection.setConnection();
                            this.varIsRefrehSet = true;
                            try {
                                this.strVarValue = this.refreshVariable();
                            }
                            catch (Exception e1) {
                                this.strVarValue = null;
                            }
                        }
                        if (this.strVarValue == null) {
                            if (this.varDefault == null) {
                                this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.55") + this.varName, "String", false);
                                throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.56") + this.varName);
                            }
                            this.strVarValue = this.varDefault;
                        }
                    }
                    break block43;
                }
                disableSave = true;
                break block43;
            }
            if (this.varOperation.equals("SetToSavedValue")) {
                disableSave = true;
                if (!this.varIsSaveSet) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.57") + this.varName + "'", "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.58") + this.varName + "'");
                }
                this.strVarValue = this.getLastValue();
            } else if (this.varOperation.equals("SetDefault") || this.varOperation.equals("SetToDefaultValue")) {
                this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.59"), 3, "DEBUG");
                if (this.varDefault == null) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.60") + this.varName, "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.61") + this.varName);
                }
                this.strVarValue = this.varDefault;
            } else if (this.varOperation.equals("Set") || this.varOperation.equals("SetValue")) {
                this.debugLog("executeSimpleCode", "Action is Set", 3, "DEBUG");
                if (this.varValue == null) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.62"), "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.63"));
                }
                this.strVarValue = this.varValue;
            } else if (this.varOperation.equals("Increment") || this.varOperation.equals("IncrementValue")) {
                this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.64"), 3, "DEBUG");
                if (this.strVarValue == null) {
                    if (this.varIsSaveSet) {
                        this.strVarValue = this.getLastValue();
                    }
                    if (this.strVarValue == null) {
                        if (this.varDefault == null) {
                            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.65") + this.varName, "String", false);
                            throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.66") + this.varName);
                        }
                        this.strVarValue = this.varDefault;
                    }
                }
                if (this.strVarValue == null) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.67") + this.varName + "'", "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.68") + this.varName + "'");
                }
                this.strVarValue = this.incrementVariable();
            } else if (this.varOperation.equals("Refresh") || this.varOperation.equals("RefreshValue")) {
                this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.69"), 3, "DEBUG");
                if (!this.varRefreshConnection.exists()) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.71") + this.varName + "'", "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.72") + this.varName + "'");
                }
                this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.70") + this.varRefreshConnection.getConnectionName(), 3, "DEBUG");
                this.varRefreshConnection.setConnection();
                this.varIsRefrehSet = true;
                this.strVarValue = this.refreshVariable();
            }
        }
        if (this.varOperation.equals("PurgeHistory")) {
            this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.82"), 3, "DEBUG");
            this.purgeHistory();
            return ret;
        }
        if (this.strVarValue == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.80") + this.varName + "'", "String", false);
            throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.81") + this.varName + "'");
        }
        if (this.varIsSaveSet) {
            if (this.varOperation.equals("SaveValue") || this.varOperation.equals("SaveCurrentValue")) {
                if (this.varDontSave) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.73") + this.varName, "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.74") + this.varName);
                }
                this.debugLog("executeSimpleCode", Messages.getString("VariableManagerActionCodeI.75"), 3, "DEBUG");
                if (this.strVarValue == null) {
                    if (this.varDefault == null) {
                        this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.76") + this.varName, "String", false);
                        throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.77") + this.varName);
                    }
                    this.strVarValue = this.varDefault;
                }
            }
            if (!this.varDontSave && !disableSave) {
                this.insertVariableInTable();
            }
        } else if (this.varOperation.equals("SaveValue") || this.varOperation.equals("SaveCurrentValue")) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("VariableManagerActionCodeI.78") + this.varName + "'", "String", false);
            throw new EngineExceptionI(this.actionClassName + Messages.getString("VariableManagerActionCodeI.79") + this.varName + "'");
        }
        IVariable v = null;
        try {
            v = this.engineContext.getVariable(this.varName);
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
        }
        if (v == null) {
            this.addVariableWithULog(this.varName, this.strVarValue, this.varType, false);
            return ret;
        }
        v.setName(this.varName);
        v.setValue(this.strVarValue);
        v.setType(this.varType);
        return ret;
    }

    public int finalizeRun() {
        int ret = 0;
        if (this.varIsSaveSet) {
            this.varSaveConnection.close();
        }
        if (this.varIsRefrehSet) {
            this.varRefreshConnection.close();
        }
        return ret;
    }

    public int finalizeDirectBindedFetch(int numRecord) throws EngineExceptionI {
        return this.finalizeRun();
    }

    public int finalizeSimpleExecuteCode() throws EngineExceptionI {
        return this.finalizeRun();
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

