/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.amqp;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPConnection;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class AMQPMessageSender {
    String channelName;
    String queueName = null;
    String routingKey = null;
    String exchangeName = null;
    boolean confirms;
    String contentType;
    String contentEncoding;
    Integer deliveryMode;
    Integer priority;
    java.sql.Date timestamp;
    String expirationPeriod;
    String appId;
    String replyTo;
    String messageId;
    Map<String, Object> header = new HashMap<String, Object>();

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setTimestamp(java.sql.Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setConfirms(boolean confirms) {
        this.confirms = confirms;
    }

    public void setHeader(String key, Object value) {
        this.header.put(key, value);
    }

    public synchronized void send(AMQPConnection connection, byte[] msg) throws IOException, TimeoutException, InterruptedException {
        AMQPUtils._assert(this.channelName != null, Messages.getString("AMQP.ERROR_016"));
        if (this.queueName != null && this.exchangeName != null) {
            throw new IOException(Messages.getString("AMQP.ERROR_011"));
        }
        if (this.routingKey != null && this.queueName != null) {
            throw new IOException(Messages.getString("AMQP.ERROR_012"));
        }
        if (this.queueName == null && this.exchangeName == null) {
            throw new IOException(Messages.getString("AMQP.ERROR_030"));
        }
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
        if (this.replyTo != null) {
            builder.replyTo(this.replyTo);
        }
        if (this.messageId != null) {
            builder.messageId(this.messageId);
        }
        if (this.appId != null) {
            builder.appId(this.appId);
        }
        if (this.contentEncoding != null) {
            builder.contentEncoding(this.contentEncoding);
        }
        if (this.contentType != null) {
            builder.contentType(this.contentType);
        }
        if (this.header.size() > 0) {
            builder.headers(this.header);
        }
        if (this.timestamp != null) {
            builder.timestamp((Date)this.timestamp);
        }
        if (this.expirationPeriod != null) {
            builder.expiration(this.expirationPeriod);
        }
        if (this.deliveryMode != null) {
            builder.deliveryMode(this.deliveryMode);
        }
        if (this.priority != null) {
            builder.priority(this.priority);
        }
        AMQP.BasicProperties prop = builder.build();
        Channel channel = connection.getChannel(this.channelName);
        if (this.confirms) {
            channel.confirmSelect();
        }
        if (this.queueName != null) {
            channel.basicPublish("", this.queueName, prop, msg);
        } else if (this.routingKey != null) {
            channel.basicPublish(this.exchangeName, this.routingKey, prop, msg);
        } else {
            channel.basicPublish(this.exchangeName, "", prop, msg);
        }
        if (this.confirms) {
            channel.waitForConfirmsOrDie();
        }
    }

    public void setExpirationPeriod(String expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public static enum TypeParameter {
        LONG,
        BOOLEAN,
        INT,
        OBJECT,
        STRING,
        DOUBLE,
        FLOAT,
        BYTE,
        SHORT;

    }
}

