/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.file.jdbc;

import com.indy.engine.actionCodes.SqlFileExportActionCodeI;
import com.indy.engine.core.RuntimeContext;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FileWriter {
    boolean booleanAsNumeric;
    String strTimestampFormat = null;
    DecimalFormat decimalFormat = null;
    boolean addRecordNumber = false;
    long currentLineSize = 0L;
    boolean getDateAsTimeStamp;
    private final Logger logger = LogManager.getLogger(this.getClass());
    int numRecord = 0;
    SqlFileExportActionCodeI.FieldInfo currentFieldInfo;
    DateTimeFormatter timestampFormat;
    String strDateFormat;
    DateTimeFormatter dateFormat;
    DateTimeFormatter timeFormat;
    String strTimeFormat;
    Thread thread;
    JdbcPreparedStatementToResultSet jdbcPreparedStatementToResultSet;

    public void setGetDateAsTimeStamp(boolean getDateAsTimeStamp) {
        this.getDateAsTimeStamp = getDateAsTimeStamp;
    }

    public long getCurrentLineSize() {
        return this.currentLineSize;
    }

    public SqlFileExportActionCodeI.FieldInfo getCurrentFieldInfo() {
        return this.currentFieldInfo;
    }

    protected FileWriter(RuntimeContext rc, boolean booleanAsNumeric, String strTimestampFormat, String strDateFormat, String strTimeFormat, DecimalFormat decimalFormat, boolean addRecordNumber) {
        this.booleanAsNumeric = booleanAsNumeric;
        this.strTimestampFormat = strTimestampFormat == null ? rc.GLOBAL_DATE_FORMAT : strTimestampFormat;
        this.strDateFormat = strDateFormat == null ? this.strTimestampFormat : strDateFormat;
        this.decimalFormat = decimalFormat;
        this.addRecordNumber = addRecordNumber;
        this.timestampFormat = DateTimeFormatter.ofPattern(strTimestampFormat);
        this.dateFormat = DateTimeFormatter.ofPattern(strDateFormat);
        if (strTimeFormat != null && !strTimeFormat.isEmpty()) {
            this.strTimeFormat = strTimeFormat;
            this.timeFormat = DateTimeFormatter.ofPattern(strTimeFormat);
        } else {
            this.timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
        }
    }

    public abstract void writeLine(Writer var1, ResultSet var2, SqlFileExportActionCodeI.FieldInfo[] var3) throws IOException, EngineExceptionI, SQLException;

    public PreparedStatement createPreparedStatement(final Writer writer, SqlFileExportActionCodeI.FieldInfo[] fieldInfos, String rowSep, String threadName, int queueSize, int batchSize, boolean rowSepOnLastRow) throws SQLException {
        this.jdbcPreparedStatementToResultSet = new JdbcPreparedStatementToResultSet(){

            public void close() throws SQLException {
                try {
                    this.end();
                    FileWriter.this.thread.join();
                    writer.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLException(e);
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                super.close();
            }
        };
        this.jdbcPreparedStatementToResultSet.setConsumers(false, new String[]{"id"});
        int i = 1;
        SqlFileExportActionCodeI.FieldInfo[] fieldInfoArray = fieldInfos;
        int n = fieldInfos.length;
        int n2 = 0;
        while (n2 < n) {
            SqlFileExportActionCodeI.FieldInfo fi = fieldInfoArray[n2];
            this.jdbcPreparedStatementToResultSet.setColumn(i, fi.name);
            this.jdbcPreparedStatementToResultSet.setColumnType(i, fi.colType);
            ++i;
            ++n2;
        }
        ResultSet sourceRSet = this.jdbcPreparedStatementToResultSet.getResultSet("id");
        this.thread = new Thread(() -> {
            try {
                boolean first = true;
                while (sourceRSet.next()) {
                    if (!first && rowSep != null) {
                        writer.write(rowSep);
                    }
                    first = false;
                    this.writeLine(writer, sourceRSet, fieldInfos);
                }
                if (rowSepOnLastRow) {
                    writer.write(rowSep);
                }
            }
            catch (EngineExceptionI | IOException | SQLException e) {
                this.logger.warn(e.getMessage(), e);
            }
        });
        if (threadName != null) {
            this.thread.setName(threadName);
        }
        this.thread.start();
        return this.jdbcPreparedStatementToResultSet;
    }

    public void closePreparedStatement() throws InterruptedException, SQLException {
        if (this.thread != null) {
            this.thread.join();
            this.jdbcPreparedStatementToResultSet.close();
        }
    }
}

