/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.codegen;

import java.lang.invoke.MethodType;
import java.util.Arrays;
import org.openjdk.nashorn.internal.codegen.types.Type;
import org.openjdk.nashorn.internal.ir.FunctionNode;
import org.openjdk.nashorn.internal.runtime.ScriptFunction;

public final class TypeMap {
    private final int functionNodeId;
    private final Type[] paramTypes;
    private final Type returnType;
    private final boolean needsCallee;

    public TypeMap(int functionNodeId, MethodType type, boolean needsCallee) {
        Type[] types = new Type[type.parameterCount()];
        int pos = 0;
        for (Class<?> p : type.parameterArray()) {
            types[pos++] = Type.typeFor(p);
        }
        this.functionNodeId = functionNodeId;
        this.paramTypes = types;
        this.returnType = Type.typeFor(type.returnType());
        this.needsCallee = needsCallee;
    }

    public Type[] getParameterTypes(int functionNodeId) {
        assert (this.functionNodeId == functionNodeId);
        return (Type[])this.paramTypes.clone();
    }

    MethodType getCallSiteType(FunctionNode functionNode) {
        assert (this.functionNodeId == functionNode.getId());
        MethodType mt = MethodType.methodType(this.returnType.getTypeClass());
        if (this.needsCallee) {
            mt = mt.appendParameterTypes(ScriptFunction.class);
        }
        mt = mt.appendParameterTypes(Object.class);
        for (Type type : this.paramTypes) {
            if (type == null) {
                return null;
            }
            mt = mt.appendParameterTypes(type.getTypeClass());
        }
        return mt;
    }

    public boolean needsCallee() {
        return this.needsCallee;
    }

    Type get(FunctionNode functionNode, int pos) {
        assert (this.functionNodeId == functionNode.getId());
        Object[] types = this.paramTypes;
        assert (types == null || pos < types.length) : "fn = " + functionNode.getId() + " types=" + Arrays.toString(types) + " || pos=" + pos + " >= length=" + types.length + " in " + String.valueOf(this);
        if (types != null && pos < types.length) {
            return types[pos];
        }
        return null;
    }

    Type getReturnType() {
        return this.returnType.isObject() ? Type.OBJECT : Type.UNKNOWN;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String prefix) {
        return prefix + "\tfunction " + this.functionNodeId + "\n" + prefix + "\t\tparamTypes=" + Arrays.toString(this.paramTypes) + "\n" + prefix + "\t\treturnType=" + String.valueOf(this.returnType == null ? "N/A" : this.returnType) + "\n";
    }
}

