/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping;

import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.ISerde;
import com.indy.map.Map;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.ref.RLogicalField;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.generation.mapping.internal.TemporaryFolderOutputURIConverter;
import com.semarchy.xdi.designer.generation.mapping.internal.Utils;
import com.stambia.md.Attribute;
import com.stambia.md.DocumentRoot;
import com.stambia.md.Element;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.util.MdFactoryHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class StageMdGenerator {
    private Logger logger = LogManager.getLogger(StageMdGenerator.class);
    private ResourceSet resourceSet;
    private static final String SCHEMA = "com.stambia.rdbms.schema";
    private static final String DATASTORE = "com.stambia.rdbms.datastore";
    private static final String COLUMN = "com.stambia.rdbms.column";

    public StageMdGenerator(ResourceSet rs) {
        this.resourceSet = rs;
    }

    public MdResources generateMdResources(Map map, boolean intoWorkspace) throws Exception {
        HashMap containersByConnections = new HashMap();
        HashMap uriMap = new HashMap();
        map.getContainer().stream().filter(c -> c instanceof Query || c instanceof ISerde).filter(this::isStageWithDataTypeDefined).forEach(container -> {
            EObject obj = container.getStagingArea();
            URI u = obj.eIsProxy() ? ((InternalEObject)obj).eProxyURI() : EcoreUtil.getURI((EObject)obj);
            EObject t = (EObject)uriMap.get(u);
            if (t == null) {
                uriMap.put(u, obj);
            } else {
                obj = t;
            }
            ArrayList<IContainer> c = (ArrayList<IContainer>)containersByConnections.get(obj);
            if (c == null) {
                if (obj.eIsProxy()) {
                    obj = map.eResource().getResourceSet().getEObject(((InternalEObject)obj).eProxyURI(), true);
                }
                c = new ArrayList<IContainer>();
                containersByConnections.put((MdNode)obj, c);
            }
            c.add((IContainer)container);
        });
        MdResources res = new MdResources();
        for (MdNode n : containersByConnections.keySet()) {
            Collection containers = (Collection)containersByConnections.get(n);
            String stagingAreaContainerLevelName = null;
            try {
                stagingAreaContainerLevelName = map.getAPI().getMdEvaluator().evaluateStageFieldContainerLevel((IContainer)containers.iterator().next());
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<IMetaData, MdNode> createdMd = null;
            createdMd = stagingAreaContainerLevelName == null || stagingAreaContainerLevelName.isEmpty() ? this._generateMdFileOldRDBMS(res, intoWorkspace, map, n, containers) : this.generateMdFile(res, map, n, containers, intoWorkspace);
            res.putAll(createdMd);
        }
        return res;
    }

    private boolean isStageWithDataTypeDefined(IContainer container) {
        for (ILogicalField f : container.getLogicalField()) {
            if (!(f instanceof QueryField) || ((QueryField)f).getMdNode() == null) continue;
            return true;
        }
        return false;
    }

    private HashMap<IMetaData, MdNode> generateMdFile(MdResources mdResources, Map map, MdNode stagingArea, Collection<IContainer> collection, boolean intoWorkspace) throws Exception {
        String stagingAreaContainerLevelName = null;
        try {
            stagingAreaContainerLevelName = map.getAPI().getMdEvaluator().evaluateStageFieldContainerLevel(collection.iterator().next());
        }
        catch (Exception exception) {
            // empty catch block
        }
        AtomicReference<String> stagingAreaFieldLevelName = new AtomicReference<String>();
        try {
            stagingAreaFieldLevelName.set(map.getAPI().getMdEvaluator().evaluateStageFieldLevel(collection.iterator().next()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stagingAreaFieldLevelName.get() == null) {
            throw new Exception("Missing xPath expression BUILD_STAGE_FIELD_LEVEL on the stageArea " + String.valueOf(EcoreUtil.getURI((EObject)stagingArea)));
        }
        MdNode subParent = map.getAPI().getMdEvaluator().toSubMdParent((EObject)stagingArea);
        if (subParent != null) {
            stagingArea = subParent;
        }
        String stagingAreaLevelDefType = map.getAPI().getMdEvaluator().getLevelDefType((IMetaData)collection.iterator().next());
        HashMap<IMetaData, MdNode> res = new HashMap<IMetaData, MdNode>();
        MdRootNode root = MdFactoryHelper.createMdRootNode((String)stagingAreaLevelDefType);
        root.setSubMd(true);
        root.setRef((EObject)stagingArea);
        root.setId(map.getId() + "-Stage-" + CacheHelper.extractEltID((EObject)stagingArea));
        root.setSubstituteContainer(stagingArea.eContainer());
        root.setName(CacheHelper.extractEltName((EObject)stagingArea));
        this.createAttribute((MdNode)root, "buildExpressionWithoutDelimiter", "true");
        for (IContainer q : collection) {
            MdNode store = MdFactoryHelper.createMdNode((String)stagingAreaContainerLevelName);
            root.getNode().add((Object)store);
            this.normalizeId((Element)store, q.getId());
            store.setName(q.getAlias().toString());
            res.put((IMetaData)q, store);
            AtomicReference<Integer> counter = new AtomicReference<Integer>(1);
            q.getLogicalField().stream().filter(f -> f instanceof QueryField).map(f -> (QueryField)f).forEach(f -> {
                MdNode mdNode2 = res.put((IMetaData)f, this.duplicateMdField((QueryField)f, store, (String)stagingAreaFieldLevelName.get(), counter));
            });
        }
        this.saveMd(mdResources, root, stagingArea, map, intoWorkspace);
        return res;
    }

    private void saveMd(MdResources mdResources, MdRootNode rootNode, MdNode stagingArea, Map map, boolean intoWorkspace) {
        mdResources.toBeSaved.add(() -> this.saveMd(rootNode, stagingArea, map, intoWorkspace));
    }

    private void saveMd(MdRootNode rootNode, MdNode stagingArea, Map map, boolean intoWorkspace) {
        URI mapURI = map.eResource().getURI();
        URI mdURI = null;
        if (!intoWorkspace) {
            mdURI = URI.createPlatformPluginURI((String)("com.indy.gmf.map/" + map.getId() + "-ref-" + stagingArea.getId() + ".md"), (boolean)true);
        } else {
            StringBuilder buf = new StringBuilder();
            int i = 1;
            while (i < mapURI.segmentCount() - 1) {
                buf.append("/");
                buf.append(URI.decode((String)mapURI.segment(i)));
                if (i == 1) {
                    buf.append("/indy.build");
                }
                ++i;
            }
            buf.append("/" + map.getName() + "-ref-" + stagingArea.getId() + ".md");
            mdURI = URI.createPlatformResourceURI((String)buf.toString(), (boolean)true);
        }
        if (!intoWorkspace) {
            this.resourceSet.setURIConverter((URIConverter)new TemporaryFolderOutputURIConverter(this.resourceSet.getURIConverter()));
        }
        Resource r = this.resourceSet.createResource(mdURI);
        DocumentRoot docRoot = MdFactory.eINSTANCE.createDocumentRoot();
        docRoot.setNode(rootNode);
        r.getContents().add((Object)docRoot);
        try {
            r.save(java.util.Map.of("ENCODING", StandardCharsets.UTF_8.name()));
        }
        catch (IOException e) {
            this.logger.error("Failed to serialize {}", (Object)mapURI);
        }
    }

    private MdNode duplicateMdField(QueryField f, MdNode store, String createdMdDefType, AtomicReference<Integer> counter) {
        MdNode n = f.getMdNode();
        MdNode field = MdFactoryHelper.createMdNode((String)createdMdDefType);
        String name = String.format("S%s_%s", counter.get(), f.getName().toString());
        counter.set(counter.get() + 1);
        field.setName(name);
        field.setDefType(createdMdDefType);
        this.normalizeId((Element)field, f.getId());
        if (n != null) {
            for (Attribute a : n.getAttribute()) {
                Attribute _a = MdFactory.eINSTANCE.createAttribute();
                _a.setValue(a.getValue());
                _a.getValues().addAll((Collection)a.getValues());
                _a.setRef(a.getRef());
                _a.getRefs().addAll((Collection)a.getRefs());
                _a.getValueEntry().putAll(_a.getValueEntry());
                _a.setDefType(createdMdDefType + "." + a.getTechProperty().getCode());
                this.normalizeId((Element)_a, field.getId() + "/" + _a.getDefType());
                field.getAttribute().add((Object)_a);
            }
        }
        store.getNode().add((Object)field);
        return field;
    }

    private MdNode createMdField(MdNode parentMdNode, QueryField f, AtomicReference<Integer> counter) {
        MdNode field = MdFactoryHelper.createMdNode((String)COLUMN);
        this.normalizeId((Element)field, f.getId());
        parentMdNode.getNode().add((Object)field);
        String name = Utils.truncation(String.format("S%s_%s", counter.get(), f.getName().toString()));
        counter.set(counter.get() + 1);
        field.setName(name);
        this.createAttribute(field, "name", name);
        if (f.getMdNode() != null) {
            this.createAttribute(field, "size", ((RLogicalField)f.getMapReference()).getPrecision());
            this.createAttribute(field, "digits", ((RLogicalField)f.getMapReference()).getSize());
            this.createAttribute(field, "type", ((RLogicalField)f.getMapReference()).getType());
        }
        this.createAttribute(field, "nullable", "false");
        this.createAttribute(field, "autoIncrement", "false");
        this.createAttribute(field, "autoGenerated", "false");
        return field;
    }

    private HashMap<IMetaData, MdNode> _generateMdFileOldRDBMS(MdResources mdResources, boolean intoWorkspace, Map map, MdNode stagingArea, Collection<IContainer> collection) {
        HashMap<IMetaData, MdNode> res = new HashMap<IMetaData, MdNode>();
        MdRootNode root = MdFactoryHelper.createMdRootNode((String)SCHEMA);
        MdNode subParent = map.getAPI().getMdEvaluator().toSubMdParent((EObject)stagingArea);
        if (subParent != null) {
            stagingArea = subParent;
        }
        root.setRef((EObject)stagingArea);
        root.setSubMd(true);
        root.setId(map.getId() + "-Stage-" + CacheHelper.extractEltID((EObject)stagingArea));
        root.setSubstituteContainer(stagingArea.eContainer());
        root.setName(CacheHelper.extractEltName((EObject)stagingArea));
        this.createAttribute((MdNode)root, "buildExpressionWithoutDelimiter", "true");
        for (IContainer q : collection) {
            MdNode store = MdFactoryHelper.createMdNode((String)DATASTORE);
            root.getNode().add((Object)store);
            this.normalizeId((Element)store, q.getId());
            store.setName(q.getAlias().toString());
            this.createAttribute(store, "name", q.getAlias().toString());
            this.createAttribute(store, "type", "TABLE");
            res.put((IMetaData)q, store);
            AtomicReference<Integer> counter = new AtomicReference<Integer>(1);
            q.getLogicalField().stream().filter(f -> f instanceof QueryField).map(f -> (QueryField)f).forEach(f -> {
                MdNode mdNode2 = res.put((IMetaData)f, this.createMdField(store, (QueryField)f, counter));
            });
        }
        this.saveMd(mdResources, root, stagingArea, map, intoWorkspace);
        return res;
    }

    private void createAttribute(MdNode n, String code, String value) {
        Attribute _a = MdFactory.eINSTANCE.createAttribute();
        _a.setDefType(n.getDefType() + "." + code);
        this.normalizeId((Element)_a, n.getId() + "/" + code);
        _a.setValue(value);
        n.getAttribute().add((Object)_a);
    }

    private void normalizeId(Element e, String baseId) {
        try {
            e.setId(UUID.nameUUIDFromBytes(baseId.getBytes("UTF-8")).toString());
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

    public static class MdResources
    extends HashMap<IMetaData, MdNode> {
        private static final long serialVersionUID = -6288273016442068239L;
        private transient List<Runnable> toBeSaved = new ArrayList<Runnable>();

        public void saveAll() {
            this.toBeSaved.forEach(Runnable::run);
        }
    }
}

