/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.ISerde;
import com.indy.map.MapLocation;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.SerdeField;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RUsage;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.Sequence;
import com.semarchy.xdi.designer.generation.mapping.internal.Utils;
import com.stambia.md.MdNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

class MdFieldFactory {
    private static final String NAME_PATTERN = "L%s_%s";
    private static final String SERDE_OUTPUT_NAME_PATTERN = "O%s_%s";
    Map<String, Map<Object, MdModel.MdField>> loadedFieldMapPerConnection = new HashMap<String, Map<Object, MdModel.MdField>>();
    private Map<ILogicalField, Integer> sequenceNumberPerFieldOnStage = new HashMap<ILogicalField, Integer>();
    private MdModelBuilder builder;
    private Logger logger = LogManager.getLogger(MdFieldFactory.class);

    public MdFieldFactory(MdModelBuilder builder) {
        this.builder = builder;
    }

    public MdModel.MdField getLoadedField(String connectionId, ILogicalField field) {
        return (MdModel.MdField)this.loadedFieldMapPerConnection.getOrDefault(connectionId, Collections.emptyMap()).get(field);
    }

    private void putLoadedField(String connectionId, Object createdFrom, MdModel.MdField loadedField) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}\n\t MdField:{}\n\tfrom:{}", (Object)connectionId, (Object)loadedField.name, (Object)(createdFrom instanceof ILogicalField ? ((ILogicalField)createdFrom).getFullPath() : ""));
        }
        this.loadedFieldMapPerConnection.computeIfAbsent(connectionId, k -> new HashMap()).put(createdFrom, loadedField);
    }

    private void normalize(MdModel.MdField f) {
        if (f.name != null) {
            f.name = Utils.truncation(f.name);
        }
        if (f.getWorkName() != null) {
            f.setWorkName(Utils.truncation(f.getWorkName()));
        }
    }

    public MdModel.MdField createLoadFieldOnSrc(String locationConnectionId, Sequence sequence, Expression expressionOnSrc, Collection<Field> extraStaticFields) {
        IMetaData md;
        ILogicalField trgField = (ILogicalField)expressionOnSrc.eContainer();
        MdModel.MdField f = MdModel.MdField.of(expressionOnSrc);
        f.tags = ((MapModelItem)trgField).getTag().stream().map(Object::toString).collect(Collectors.toList());
        if (trgField instanceof IMetaData && (md = (IMetaData)trgField).basicGetRef() != null) {
            EObject ref = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault(md, (MdNode)((IMetaData)trgField).getRef());
            f.underlyingMdNodeReference = this.builder.delegate(() -> ref);
        }
        f.number = sequence.getNext();
        f.name = String.format(NAME_PATTERN, Integer.toString(f.number), Utils.computeWorkName(trgField.getLabel()));
        f.setWorkName(Utils.truncation(f.name));
        if (Utils.isGeneratedAsDatastoreField(trgField) && trgField instanceof IMetaData) {
            IMetaData md2 = (IMetaData)trgField;
            EObject node = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault(md2, (MdNode)((IMetaData)trgField).getRef());
            f.setBaseMd(this.builder.delegate(() -> node));
            f.expression.location = MdModel.Location.SRC;
            f.expression.version = 2;
            f.aggregate = expressionOnSrc.isAggregate();
            f.setTargetMd(this.builder.delegate(() -> node));
        }
        if (extraStaticFields != null) {
            extraStaticFields.stream().map(x -> new MdModel.ExtraStaticFieldDefinition(this.builder.delegate(() -> ((Field)x).basicGetRef()), this.builder.delegate(() -> x.getParent().basicGetRef()))).forEach(x -> {
                boolean bl = mdField.extraStaticFieldRelations.add((MdModel.ExtraStaticFieldDefinition)x);
            });
        }
        this.putLoadedField(locationConnectionId, expressionOnSrc, f);
        this.normalize(f);
        return f;
    }

    public MdModel.MdField createLoadFieldOnWrk(String locationConnectionId, Sequence fieldSequence, ILogicalField field) {
        MdModel.MdField f = MdModel.MdField.of(field);
        f.tags = ((MapModelItem)field).getTag().stream().map(Object::toString).collect(Collectors.toList());
        if (field instanceof IMetaData && ((IMetaData)field).basicGetRef() != null) {
            EObject ref = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault((IMetaData)field, (MdNode)((IMetaData)field).getRef());
            f.underlyingMdNodeReference = this.builder.delegate(() -> ref);
        }
        f.number = fieldSequence.getNext();
        f.name = String.format(NAME_PATTERN, Integer.toString(f.number), Utils.computeWorkName(field.getLabel()));
        f.setWorkName(Utils.truncation(f.name));
        f.setBaseMd(this.builder.delegate(() -> mdField.underlyingMdNodeReference));
        f.expression.location = MdModel.Location.WRK;
        f.expression.version = 2;
        this.putLoadedField(locationConnectionId, field, f);
        this.normalize(f);
        return f;
    }

    public MdModel.MdField createIntegrationField(String locationConnectionId, boolean isNoLoad, Sequence sequence, Expression expression, Function<IReferencable<? extends RUsage>, String> sourceSetName, Collection<Field> extraStaticFields) {
        MdModel.MdField f = MdModel.MdField.of(expression);
        EObject ref = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault(expression.eContainer(), (MdNode)((IMetaData)expression.eContainer()).getRef());
        boolean refFromPhysicalizedStageField = ref != ((IMetaData)expression.eContainer()).getRef();
        f.underlyingMdNodeReference = ref;
        if (ref != null) {
            f.setBaseMd(this.builder.delegate(() -> ref));
            f.setTargetMd(this.builder.delegate(() -> ref));
        }
        ILogicalField field = (ILogicalField)expression.eContainer();
        boolean dataTypedQueryFields = Utils.isGeneratedAsQuery((IContainer)expression.eContainer().eContainer());
        String workName = null;
        String name = null;
        Integer fieldSequence = null;
        if (dataTypedQueryFields || isNoLoad || ((IContainer)expression.eContainer().eContainer()).hasStagingArea() || field.eContainer() instanceof ISerde) {
            fieldSequence = this.sequenceNumberPerFieldOnStage.computeIfAbsent(field, k -> sequence.getNext());
            workName = String.format(NAME_PATTERN, Integer.toString(fieldSequence), Utils.computeWorkName(field.getLabel()));
        }
        if (refFromPhysicalizedStageField && ref != null) {
            f.name = ((MdNode)ref).getName();
            f.setWorkName(Utils.truncation(f.name));
        } else {
            f.number = fieldSequence;
            name = Utils.isGeneratedAsDatastoreField(field) ? Utils.computeWorkName(field.getLabel()) : workName;
            f.name = name;
            f.setWorkName(workName);
            if (f.getWorkName() == null) {
                f.setWorkName(f.name);
            }
            this.normalize(f);
        }
        f.expression.sourceSetName = sourceSetName.apply((IReferencable<? extends RUsage>)expression);
        if (extraStaticFields != null) {
            extraStaticFields.stream().map(x -> new MdModel.ExtraStaticFieldDefinition(this.builder.delegate(() -> ((Field)x).basicGetRef()), this.builder.delegate(() -> x.getParent().basicGetRef()))).forEach(x -> {
                boolean bl = mdField.extraStaticFieldRelations.add((MdModel.ExtraStaticFieldDefinition)x);
            });
        }
        f.aggregate = expression.isAggregate();
        if (field.eContainingFeature() == MapPackage.eINSTANCE.getInliner_InputField()) {
            f.serdeInput = true;
        }
        this.addIntegrationCommonProperties(f, expression);
        this.putLoadedField(locationConnectionId, field, f);
        return f;
    }

    public MdModel.MdField createIntegrationSerdeField(String locationConnectionId, Sequence sequence, ILogicalField serdeOutputField) {
        EObject ref;
        MdModel.MdField f = MdModel.MdField.of(serdeOutputField);
        f.number = sequence.getNext();
        f.name = String.format(SERDE_OUTPUT_NAME_PATTERN, Integer.toString(f.number), Utils.computeWorkName(serdeOutputField.getLabel()));
        f.setWorkName(f.name);
        f.tags = ((MapModelItem)serdeOutputField).getTag().stream().map(Object::toString).collect(Collectors.toList());
        f.underlyingMdNodeReference = ref = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault((IMetaData)serdeOutputField, (MdNode)((IMetaData)serdeOutputField).getRef());
        if (f.underlyingMdNodeReference != null && (serdeOutputField.eContainingFeature() == MapPackage.eINSTANCE.getOutliner_OutputField() || serdeOutputField.eContainingFeature() == MapPackage.eINSTANCE.getInliner_OutputField())) {
            f.setBaseMd(this.builder.delegate(() -> mdField.underlyingMdNodeReference));
            f.setTargetMd(this.builder.delegate(() -> mdField.underlyingMdNodeReference));
        }
        f.serdeOutput = true;
        this.putLoadedField(locationConnectionId, serdeOutputField, f);
        this.normalize(f);
        return f;
    }

    private void addIntegrationCommonProperties(MdModel.MdField f, Expression expression) {
        f.expression.location = MdModel.Location.valueOf(expression.getLocation().getName());
        f.expression.version = 2;
        if (expression.getLocation() == MapLocation.TRG && ((RExpression)expression.getMapReference()).getRealSourceRef().stream().anyMatch(r -> r.getDataModel() instanceof ILogicalField)) {
            f.expression.version = 3;
        }
        f.tags = ((MapModelItem)expression.eContainer()).getTag().stream().map(Object::toString).collect(Collectors.toList());
        if (expression.eContainer() instanceof Field) {
            f.insert = ((Field)expression.eContainer()).isInsert();
            f.updateKey = ((Field)expression.eContainer()).isUpdateKey();
            f.update = ((Field)expression.eContainer()).isUpdate();
        }
        if (expression.eContainer() instanceof SerdeField) {
            f.insert = ((SerdeField)expression.eContainer()).isInsert();
            f.updateKey = ((SerdeField)expression.eContainer()).isUpdateKey();
            f.update = ((SerdeField)expression.eContainer()).isUpdate();
        }
        if (expression.eContainer().eContainingFeature() == MapPackage.eINSTANCE.getOutliner_InputField()) {
            f.serdeInput = true;
        }
        if (expression.eContainer().eContainingFeature() == MapPackage.eINSTANCE.getInliner_OutputField()) {
            f.serdeOutput = true;
        }
    }
}

