/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.IContainer;
import com.indy.map.JoinMode;
import com.indy.map.Template;
import com.indy.map.ref.RTemplate;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.MdNodeFactory;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;

class ModelToMdConverter {
    MdModelBuilder modelBuilder;
    Map<MdModel.MdStep, MdNode> mdNodePerStep = new HashMap<MdModel.MdStep, MdNode>();

    ModelToMdConverter() {
    }

    static ModelToMdConverter of(MdModelBuilder modelBuilder) {
        ModelToMdConverter converter = new ModelToMdConverter();
        converter.modelBuilder = modelBuilder;
        return converter;
    }

    public void appendStepsModel(MdNode main, Collection<MdModel.MdStep> steps) {
        for (MdModel.MdStep s : steps) {
            Template tpl = this.modelBuilder.stepsByTpl.get(s);
            boolean noLoad = ((RTemplate)tpl.getMapReference()).getTemplateType().isIntegration() && !((RTemplate)tpl.getMapReference()).hasLoad();
            MdNode stepNode = this.createStep(s);
            s.sources.stream().forEach(f -> {
                boolean bl = stepNode.getNode().add((Object)this.createSource((MdModel.MdSource)f));
            });
            s.fields.stream().forEach(f -> {
                boolean bl2 = stepNode.getNode().add((Object)this.createField((MdModel.MdField)f, noLoad));
            });
            s.joins.stream().forEach(f -> {
                boolean bl = stepNode.getNode().add((Object)this.createJoin((MdModel.MdJoin)f));
            });
            s.filters.stream().forEach(f -> {
                boolean bl = stepNode.getNode().add((Object)this.createFilter((MdModel.MdFilter)f));
            });
            s.constraints.stream().forEach(f -> {
                boolean bl = stepNode.getNode().add((Object)this.createConstraint((MdModel.MdConstraint)f));
            });
            main.getNode().add((Object)stepNode);
        }
        this.modelBuilder.mdLinkFactory.appendMdLinks(main);
    }

    private MdNode createSource(MdModel.MdSource s) {
        MdNode md = MdFactoryHelper.createMdNode((String)"com.stambia.flow.source");
        md.setName(s.name);
        if (s.getTargetMd() != null) {
            String mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName(s.getTargetMd());
            MdNodeFactory.addStringAttribute(md, "target", String.format("$%s", mdLink));
        }
        if (s.tags != null) {
            s.tags.forEach(t -> MdNodeFactory.addValueAttribute(md, "tag", t));
        }
        if (s.stepName != null) {
            MdNodeFactory.addStringAttribute(md, "stepName", s.stepName);
        }
        if (s.sourceSetName != null) {
            MdNodeFactory.addStringAttribute(md, "sourceSet", s.sourceSetName);
        }
        if (s.filteringSource != null) {
            MdNodeFactory.addStringAttribute(md, "filteringSource", Boolean.toString(s.filteringSource));
        }
        if (s.cdc) {
            MdNodeFactory.addStringAttribute(md, "cdc", Boolean.toString(s.cdc));
        }
        if (s.number != null) {
            MdNodeFactory.addStringAttribute(md, "number", Integer.toString(s.number));
        }
        return md;
    }

    private MdNode createConstraint(MdModel.MdConstraint f) {
        MdNode md = MdFactoryHelper.createMdNode((String)"com.stambia.flow.constraint");
        md.setName(f.name);
        MdNodeFactory.addStringAttribute(md, "type", f.type);
        if (f.getMdRef() != null) {
            String mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName(f.getMdRef());
            MdNodeFactory.addStringAttribute(md, "target", String.format("$%s", mdLink));
        }
        return md;
    }

    private MdNode createFilter(MdModel.MdFilter f) {
        MdNode md = MdFactoryHelper.createMdNode((String)"com.stambia.flow.filter");
        md.setId(f.id);
        if (f.expression.internalExpression != null) {
            MdNodeFactory.addStringAttribute(md, "expr", f.expression.internalExpression);
        }
        if (f.aggregate) {
            MdNodeFactory.addStringAttribute(md, "aggregate", Boolean.toString(f.aggregate));
        }
        if (f.qualify) {
            MdNodeFactory.addStringAttribute(md, "qualify", Boolean.toString(f.qualify));
        }
        f.tags.forEach(t -> MdNodeFactory.addValueAttribute(md, "tag", t));
        MdNodeFactory.addStringAttribute(md, "version", Integer.toString(f.expression.version));
        if (f.expression.sourceSetName != null) {
            MdNodeFactory.addStringAttribute(md, "sourceSet", f.expression.sourceSetName);
        }
        if (f.operator != null) {
            MdNodeFactory.addStringAttribute(md, "operator", f.operator);
        }
        if (f.expression.sourceContainer != null) {
            f.expression.sourceContainer.stream().forEach(s -> MdNodeFactory.addValueAttribute(md, "sourceContainer", s.name));
        }
        if (f.expression.getSource() != null) {
            f.expression.getSource().stream().forEach(s -> {
                String mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName((EObject)s);
                MdNodeFactory.addValueAttribute(md, "source", String.format("$%s", mdLink));
            });
        }
        if (f.expression.location == MdModel.Location.TRG) {
            MdNodeFactory.addStringAttribute(md, "location", f.expression.location.name());
        }
        f.expression.sourceNames.forEach(n -> MdNodeFactory.addValueAttribute(md, "sourceNames", n));
        return md;
    }

    private MdNode createJoin(MdModel.MdJoin f) {
        MdNode md = MdFactoryHelper.createMdNode((String)"com.stambia.flow.join");
        md.setId(f.id);
        if (f.expression.internalExpression != null) {
            MdNodeFactory.addStringAttribute(md, "expr", f.expression.internalExpression);
        }
        MdNodeFactory.addStringAttribute(md, "left", f.leftSource.name);
        MdNodeFactory.addStringAttribute(md, "right", f.rightSource.name);
        if (f.mode != JoinMode.DEFAULT) {
            MdNodeFactory.addStringAttribute(md, "mode", f.mode.getLiteral());
        }
        if (f.order != null) {
            MdNodeFactory.addStringAttribute(md, "order", Integer.toString(f.order));
        }
        f.tags.forEach(t -> MdNodeFactory.addValueAttribute(md, "tag", t));
        MdNodeFactory.addStringAttribute(md, "type", f.type.getLiteral());
        MdNodeFactory.addStringAttribute(md, "version", Integer.toString(f.expression.version));
        if (f.expression.sourceSetName != null) {
            MdNodeFactory.addStringAttribute(md, "sourceSet", f.expression.sourceSetName);
        }
        if (f.expression.sourceContainer != null) {
            f.expression.sourceContainer.stream().forEach(s -> MdNodeFactory.addValueAttribute(md, "sourceContainer", s.name));
        }
        if (f.expression.getSource() != null) {
            f.expression.getSource().stream().forEach(s -> {
                String mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName((EObject)s);
                MdNodeFactory.addValueAttribute(md, "source", String.format("$%s", mdLink));
            });
        }
        f.expression.sourceNames.forEach(n -> MdNodeFactory.addValueAttribute(md, "sourceNames", n));
        return md;
    }

    private String truncate(String name) {
        if (name.length() > 30) {
            return name.substring(0, 30);
        }
        return name;
    }

    private MdNode createField(MdModel.MdField f, boolean hasNoLoad) {
        String mdLink;
        MdNode md = MdFactoryHelper.createMdNode((String)"com.stambia.flow.field");
        md.setName(f.name);
        f.tags.forEach(t -> MdNodeFactory.addValueAttribute(md, "tag", t));
        if (f.aggregate != null) {
            MdNodeFactory.addStringAttribute(md, "aggregate", Boolean.toString(f.aggregate));
        }
        if (f.getBaseMd() != null) {
            mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName(f.getBaseMd());
            MdNodeFactory.addStringAttribute(md, "base", String.format("$%s", mdLink));
        }
        if (f.expression.location != null) {
            MdNodeFactory.addStringAttribute(md, "location", f.expression.location.name());
        }
        if (f.number != null) {
            MdNodeFactory.addStringAttribute(md, "number", Integer.toString(f.number));
        }
        if (f.expression.sourceContainer != null) {
            Function<MdModel.MdSource, String> srcContainerSupplier = src -> {
                MdModel.MdStep stp;
                if (hasNoLoad && src.stepName != null && src.sourceMode == MdModel.MdSourceMode.STEP && (stp = this.modelBuilder.stepsByName.get(src.stepName)) != null && stp.templateType == RTemplate.Type.STAGING) {
                    return ((IContainer)((RTemplate)this.modelBuilder.stepsByTpl.get(stp).getMapReference()).getTargetRef().get(0)).getAlias().toString();
                }
                return src.name;
            };
            f.expression.sourceContainer.stream().forEach(s -> MdNodeFactory.addValueAttribute(md, "sourceContainer", (String)srcContainerSupplier.apply((MdModel.MdSource)s)));
        }
        if (f.expression.getSource() != null) {
            f.expression.getSource().stream().forEach(s -> {
                String mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName((EObject)s);
                MdNodeFactory.addValueAttribute(md, "source", String.format("$%s", mdLink));
            });
        }
        if (f.getTargetMd() != null) {
            mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName(f.getTargetMd());
            MdNodeFactory.addStringAttribute(md, "target", String.format("$%s", mdLink));
        }
        if (f.underlyingMdNodeReference != null) {
            MdNodeFactory.addRefAttribute(md, "mdFieldRef", f.underlyingMdNodeReference);
        }
        if (f.expression.internalExpression != null) {
            MdNodeFactory.addStringAttribute(md, "expr", f.expression.internalExpression);
        }
        MdNodeFactory.addStringAttribute(md, "workname", f.getWorkName());
        if (f.expression.version != null) {
            MdNodeFactory.addStringAttribute(md, "version", Integer.toString(f.expression.version));
        }
        if (f.expression.sourceSetName != null) {
            MdNodeFactory.addStringAttribute(md, "sourceSet", f.expression.sourceSetName);
        }
        if (f.insert != null && f.insert.booleanValue()) {
            MdNodeFactory.addStringAttribute(md, "insert", Boolean.toString(f.insert));
        }
        if (f.update != null && f.update.booleanValue()) {
            MdNodeFactory.addStringAttribute(md, "update", Boolean.toString(f.update));
        }
        if (f.updateKey != null && f.updateKey.booleanValue()) {
            MdNodeFactory.addStringAttribute(md, "updatekey", Boolean.toString(f.updateKey));
        }
        if (f.serdeInput != null) {
            MdNodeFactory.addStringAttribute(md, "input", Boolean.toString(f.serdeInput));
        }
        if (f.serdeOutput != null) {
            MdNodeFactory.addStringAttribute(md, "output", Boolean.toString(f.serdeOutput));
        }
        f.expression.sourceNames.forEach(n -> MdNodeFactory.addValueAttribute(md, "sourceNames", n));
        for (MdModel.ExtraStaticFieldDefinition d : f.extraStaticFieldRelations) {
            MdNode relation = MdFactoryHelper.createMdNode((String)"com.stambia.flow.extrafield");
            md.getNode().add((Object)relation);
            MdNodeFactory.addStringAttribute(relation, "child", "$" + this.modelBuilder.mdLinkFactory.getMdLinkName(d.childRef));
            MdNodeFactory.addStringAttribute(relation, "parent", "$" + this.modelBuilder.mdLinkFactory.getMdLinkName(d.parentRef));
        }
        return md;
    }

    private MdNode createStep(MdModel.MdStep s) {
        String mdLink;
        MdNode node = MdFactoryHelper.createMdNode((String)"com.stambia.flow.step");
        this.mdNodePerStep.put(s, node);
        node.setId(UUID.nameUUIDFromBytes((this.modelBuilder.mapModel.getId() + "-" + s.name).getBytes()).toString());
        node.setName(s.name);
        MdNodeFactory.addStringAttribute(node, "number", Integer.toString(s.number));
        if (s.integrationSteps != null) {
            s.integrationSteps.forEach(is -> MdNodeFactory.addValueAttribute(node, "integrationStepName", is.name));
        }
        if (s.getIntegrationUpdateKeyRef() != null) {
            mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName(s.getIntegrationUpdateKeyRef());
            MdNodeFactory.addStringAttribute(node, "trgUpdateKeyProviderRef", String.format("$%s", mdLink));
        }
        if (s.getSerdeOutputFieldRef() != null) {
            MdNodeFactory.addRefAttribute(node, "outputStructureRef", s.getSerdeOutputFieldRef());
        }
        if (s.getSerdeInputFieldRef() != null) {
            MdNodeFactory.addRefAttribute(node, "inputStructureRef", s.getSerdeInputFieldRef());
        }
        if (s.getTargetMd() != null) {
            mdLink = this.modelBuilder.mdLinkFactory.getMdLinkName(s.getTargetMd());
            MdNodeFactory.addStringAttribute(node, "target", String.format("$%s", mdLink));
        }
        MdNodeFactory.addStringAttribute(node, "type", s.templateType.getStepMdTypeAttributeValue());
        if (s.stageSetDescriptorExpression != null && s.templateType == RTemplate.Type.STAGING && ((IContainer)((RTemplate)this.modelBuilder.stepsByTpl.get(s).getMapReference()).getTargetRef().get(0)).getSetDescriptor().size() > 1) {
            MdNodeFactory.addStringAttribute(node, "setExpression", s.stageSetDescriptorExpression);
        }
        return node;
    }
}

