/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.md;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

class MdXMLReorderer {
    List<XMLEvent> events;
    Map<XMLEvent, List<XMLEvent>> contentMap;
    XMLEventWriter writer;
    Set<XMLEvent> writen = new HashSet<XMLEvent>();
    Stack<Iterator<XMLEvent>> stack = new Stack();

    protected MdXMLReorderer(List<XMLEvent> events, Map<XMLEvent, List<XMLEvent>> contentMap, XMLEventWriter writer) {
        this.contentMap = contentMap;
        this.events = events;
        this.writer = writer;
    }

    public void write() throws XMLStreamException {
        for (XMLEvent ev : this.events) {
            this.write(ev);
        }
        this.writer.flush();
    }

    private void write(XMLEvent event) throws XMLStreamException {
        if (this.writen.contains(event)) {
            return;
        }
        this.writer.add(event);
        this.writen.add(event);
        List<XMLEvent> children = this.contentMap.get(event);
        if (children != null && !children.isEmpty()) {
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("node")) {
                this.reorder(children);
            }
            Iterator<XMLEvent> it = children.iterator();
            this.stack.push(it);
            while (it.hasNext()) {
                this.write(it.next());
            }
            this.stack.pop();
        }
        this.writer.flush();
    }

    private void reorder(List<XMLEvent> children) {
        ArrayList<XMLEvent> attributesStart = new ArrayList<XMLEvent>(children.size() / 2);
        ArrayList<XMLEvent> nodesStart = new ArrayList<XMLEvent>(children.size() / 2);
        ArrayList<XMLEvent> mdLinkStart = new ArrayList<XMLEvent>();
        int i = 0;
        while (i < children.size()) {
            XMLEvent ev = children.get(i);
            if (ev.isStartElement()) {
                StartElement s = ev.asStartElement();
                if (s.getName().getLocalPart().equals("attribute")) {
                    attributesStart.add(s);
                } else if (s.getName().getLocalPart().equals("node")) {
                    nodesStart.add(s);
                } else if (s.getName().getLocalPart().equals("metaDataLink")) {
                    mdLinkStart.add(s);
                }
                EndElement e = null;
                while (e == null && i < children.size()) {
                    if (!children.get(++i).isEndElement() || !children.get(i).asEndElement().getName().getLocalPart().equals(s.getName().getLocalPart())) continue;
                    e = children.get(i).asEndElement();
                    if (e.getName().getLocalPart().equals("attribute")) {
                        attributesStart.add(e);
                        break;
                    }
                    if (e.getName().getLocalPart().equals("node")) {
                        nodesStart.add(e);
                        break;
                    }
                    if (!e.getName().getLocalPart().equals("metaDataLink")) break;
                    mdLinkStart.add(e);
                    break;
                }
            }
            ++i;
        }
        children.clear();
        children.addAll(attributesStart);
        children.addAll(nodesStart);
        children.addAll(mdLinkStart);
    }
}

