/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process.internal;

import com.indy.a.PasswordManagerI;
import com.indy.engine.shared.passwordmanagement.IPasswordManagerDelegate;
import com.semarchy.xdi.designer.generation.xsl.gene.process.GenerationEventHandler;
import com.semarchy.xdi.designer.generation.xsl.gene.process.Graph;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.Messages;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.OneProcCompilation;
import com.semarchy.xdi.engine.common.DeliveryChecksumCertifier;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XSLProcGenerator {
    private XMLStreamWriter writer;
    private String processCompilationAltId;
    private OneProcCompilation.EscapingAttributeBufferedOutputStream escapedBufferOutputStream;
    private String defaultScriptingEngine;

    public XSLProcGenerator(XMLStreamWriter writer, String defaultScriptingEngine) {
        this.writer = writer;
        this.defaultScriptingEngine = defaultScriptingEngine;
    }

    public String generate(Graph graph, GenerationEventHandler.NodeInfo instanceGraph, OneProcCompilation.GenerationHelper mapCode, OneProcCompilation.EscapingAttributeBufferedOutputStream escapedOutputStream) throws XMLStreamException {
        this.escapedBufferOutputStream = escapedOutputStream;
        this.writer.writeStartDocument("1.0");
        GraphVisitor visitor = new GraphVisitor(mapCode);
        visitor.accept(instanceGraph);
        this.writer.writeEndDocument();
        this.writer.close();
        return this.processCompilationAltId;
    }

    class GraphVisitor {
        OneProcCompilation.GenerationHelper mapCode;
        HashMap<String, GenerationEventHandler.NodeInfo> writtenNodeInfoMap = new HashMap();

        GraphVisitor(OneProcCompilation.GenerationHelper mapCode) {
            this.mapCode = mapCode;
        }

        public void accept(GenerationEventHandler.NodeInfo root) throws XMLStreamException {
            this.visit(root);
        }

        void writeAttribute(String name, String value) throws XMLStreamException {
            XSLProcGenerator.this.escapedBufferOutputStream.setAttribute(true);
            XSLProcGenerator.this.writer.writeAttribute(name, value);
            XSLProcGenerator.this.escapedBufferOutputStream.setAttribute(false);
        }

        public void visit(GenerationEventHandler.NodeInfo n) throws XMLStreamException {
            String tagName = this.getTagName(n.getNode());
            if (tagName == null && n.getNode().getType() == Graph.Type.LINK) {
                return;
            }
            XSLProcGenerator.this.writer.writeStartElement(tagName);
            boolean isRoot = false;
            if (n.getNode().getParent() == null) {
                XSLProcGenerator.this.writer.writeNamespace("proc", "http://www.example.org/proc");
                isRoot = true;
            }
            XSLProcGenerator.this.writer.writeAttribute("id", n.getNormalizedId());
            GenerationEventHandler.NodeInfo existingNode = this.writtenNodeInfoMap.put(n.getNormalizedId(), n);
            if (existingNode != null) {
                StringBuffer buf = new StringBuffer(n.getNode().getDiagnosticPath());
                if (n.getNode() != existingNode.getNode()) {
                    buf.append("\n" + existingNode.getNode().getDiagnosticPath());
                }
                throw new XMLStreamException(String.format(Messages.XSLProcGenerator_0, existingNode.getName(), buf.toString()));
            }
            XSLProcGenerator.this.writer.writeAttribute("name", n.getName());
            XSLProcGenerator.this.writer.writeAttribute("isBeginAction", n.isBegin());
            if (n.getNode().getType() == Graph.Type.ACTION) {
                String module = this.mapCode.generatedCode.getCode(n.getId() + ".module");
                if (module != null && !module.trim().isEmpty()) {
                    XSLProcGenerator.this.writer.writeAttribute("module", module);
                } else if (((Graph.Action)n.getNode()).getModuleName() != null) {
                    XSLProcGenerator.this.writer.writeAttribute("module", ((Graph.Action)n.getNode()).getModuleName());
                }
            }
            this.writeAttributes(n, n.getNode().getModelInfo());
            if (isRoot) {
                this.writeXmlStuff(InjectionMode.METADATALINK);
            }
            for (GenerationEventHandler.NodeInfo o : n.getOutputSteps()) {
                Collection<Graph.ModelInfo> infos = n.getOutputInfo(o);
                if (infos != null && !infos.isEmpty()) {
                    for (Graph.ModelInfo i : infos) {
                        boolean isBind = false;
                        if (n.isOutputBind(o, i)) {
                            XSLProcGenerator.this.writer.writeStartElement("bindLink");
                            XSLProcGenerator.this.writer.writeAttribute("bindType", "DirectBind");
                            isBind = true;
                        } else {
                            XSLProcGenerator.this.writer.writeStartElement("link");
                        }
                        String cond = null;
                        XSLProcGenerator.this.writer.writeAttribute("targetId", o.getNormalizedId());
                        if (i != null) {
                            if (i.executionCondition != null) {
                                String linkNodeId;
                                GenerationEventHandler.NodeInfo linkNode = Graph.getNodeInfo(linkNodeId = n.getLinkNodeIdFromOutputId(o.getId(), i.srcId));
                                String linkNodeInput = linkNode == null || linkNode.getInputs().isEmpty() ? null : linkNode.getInputs().iterator().next().getId();
                                Object s = this.mapCode.generatedCode.getCode(linkNodeId + "|--" + linkNodeInput + ".executionCondition");
                                if (s == null) {
                                    s = i.executionCondition;
                                }
                                if (!isBind && !((String)s).trim().matches("(?s)%e\\([^\\)]+\\)\\{.*")) {
                                    s = "%e(" + XSLProcGenerator.this.defaultScriptingEngine + "){" + (String)s + "}e(" + XSLProcGenerator.this.defaultScriptingEngine + ")%";
                                }
                                cond = s;
                                this.writeAttribute("executionCondition", (String)s);
                            }
                            if (i.executionTrigger != null) {
                                XSLProcGenerator.this.writer.writeAttribute("mandatory", i.executionTrigger);
                            } else {
                                XSLProcGenerator.this.writer.writeAttribute("mandatory", "1");
                            }
                            if (i.executionType != null && !i.executionType.equals("OK")) {
                                XSLProcGenerator.this.writer.writeAttribute("executionType", i.executionType);
                            }
                        }
                        XSLProcGenerator.this.writer.writeAttribute("id", this.generateLinkNormalizedId(n, o, i, cond));
                        XSLProcGenerator.this.writer.writeEndElement();
                    }
                    continue;
                }
                if (n.isOutputBind(o, null)) {
                    XSLProcGenerator.this.writer.writeStartElement("bindLink");
                    XSLProcGenerator.this.writer.writeAttribute("bindType", "DirectBind");
                } else {
                    XSLProcGenerator.this.writer.writeStartElement("link");
                }
                XSLProcGenerator.this.writer.writeAttribute("id", this.generateLinkNormalizedId(n, o, null, null));
                XSLProcGenerator.this.writer.writeAttribute("targetId", o.getNormalizedId());
                XSLProcGenerator.this.writer.writeEndElement();
            }
            HashSet<String> handledParamKeys = new HashSet<String>();
            String baseKey = n.getId() + ".parameter.";
            for (Graph.Parameter p : n.getNode().getContext().getParameters()) {
                String val;
                String key = null;
                if (p.needGeneration()) {
                    key = baseKey + p.name;
                    v0 = this.mapCode.generatedCode.getCode(key);
                } else {
                    v0 = val = p.value;
                }
                if (val == null) continue;
                handledParamKeys.add(key);
                XSLProcGenerator.this.writer.writeStartElement("parameter");
                XSLProcGenerator.this.writer.writeAttribute("name", p.name);
                XSLProcGenerator.this.writer.writeAttribute("type", p.type);
                if (p.name.equals("CERTIFICATION_CHECKSUM") && n.getNode().getType() == Graph.Type.ACTION) {
                    String code = ((Graph.Action)n.getNode()).needParse() ? this.mapCode.generatedCode.getCode(n.getId() + ".code") : ((Graph.Action)n.getNode()).getActionCode();
                    code = code.replace("\r", "").replace("\n", "");
                    val = DeliveryChecksumCertifier.getChecksumHelper((IPasswordManagerDelegate)PasswordManagerI.b).generateCertifiedCheckSum(code, true);
                }
                this.writeAttribute("value", val);
                if (p.input != null) {
                    XSLProcGenerator.this.writer.writeAttribute("input", p.input);
                }
                if (p.output != null) {
                    XSLProcGenerator.this.writer.writeAttribute("output", p.output);
                }
                if (p.fault != null) {
                    XSLProcGenerator.this.writer.writeAttribute("fault", p.fault);
                }
                XSLProcGenerator.this.writer.writeEndElement();
            }
            if (n.getNode().getType() == Graph.Type.ACTION) {
                for (String s : this.mapCode.generatedCode.getStoredParameterKeys(n.getId(), handledParamKeys)) {
                    String val = this.mapCode.generatedCode.getCode(s);
                    String name = s.substring(s.lastIndexOf(".") + 1);
                    String type = "STRING";
                    if (val == null) continue;
                    XSLProcGenerator.this.writer.writeStartElement("parameter");
                    XSLProcGenerator.this.writer.writeAttribute("name", name);
                    XSLProcGenerator.this.writer.writeAttribute("type", type);
                    this.writeAttribute("value", val);
                    XSLProcGenerator.this.writer.writeEndElement();
                }
            }
            for (Graph.AltId a : n.getNode().getAltId()) {
                if (XSLProcGenerator.this.processCompilationAltId == null && a.origin.equals("compilation")) {
                    XSLProcGenerator.this.processCompilationAltId = a.value;
                }
                XSLProcGenerator.this.writer.writeStartElement("altId");
                XSLProcGenerator.this.writer.writeAttribute("value", a.value);
                XSLProcGenerator.this.writer.writeAttribute("origin", a.origin);
                XSLProcGenerator.this.writer.writeEndElement();
            }
            if (n.isInIteration()) {
                XSLProcGenerator.this.writer.writeStartElement("altId");
                XSLProcGenerator.this.writer.writeAttribute("value", n.getIterationGroup());
                XSLProcGenerator.this.writer.writeAttribute("origin", "iterationGroup");
                XSLProcGenerator.this.writer.writeEndElement();
                if (n.getNode().getRepetitionType() == null || n.getNode().getRepetitionType().equals("Sequential")) {
                    XSLProcGenerator.this.writer.writeStartElement("altId");
                    XSLProcGenerator.this.writer.writeAttribute("value", "Sequential");
                    XSLProcGenerator.this.writer.writeAttribute("origin", "iterationMode");
                    XSLProcGenerator.this.writer.writeEndElement();
                } else {
                    XSLProcGenerator.this.writer.writeStartElement("altId");
                    XSLProcGenerator.this.writer.writeAttribute("value", "Parallelize");
                    XSLProcGenerator.this.writer.writeAttribute("origin", "iterationMode");
                    XSLProcGenerator.this.writer.writeEndElement();
                }
            }
            if (n.getNode().getType() == Graph.Type.ACTION) {
                String code;
                String string = code = ((Graph.Action)n.getNode()).needParse() ? this.mapCode.generatedCode.getCode(n.getId() + ".code") : ((Graph.Action)n.getNode()).getActionCode();
                if (code != null && !code.trim().isEmpty()) {
                    XSLProcGenerator.this.writer.writeStartElement("resultCode");
                    XSLProcGenerator.this.writer.writeCData(code);
                    XSLProcGenerator.this.writer.writeEndElement();
                }
            }
            for (GenerationEventHandler.NodeInfo c : n.getChildren()) {
                this.visit(c);
            }
            if (isRoot) {
                this.writeXmlStuff(InjectionMode.CONNECTION);
            }
            XSLProcGenerator.this.writer.writeEndElement();
        }

        private String generateLinkNormalizedId(GenerationEventHandler.NodeInfo src, GenerationEventHandler.NodeInfo trg, Graph.ModelInfo i, String cond) {
            StringBuffer b = new StringBuffer();
            b.append(src.getNormalizedId());
            b.append("|");
            b.append(trg.getNormalizedId());
            b.append("|");
            if (src.isOutputBind(trg, i)) {
                b.append("bind");
                b.append("|");
            }
            if (i != null) {
                if (i.executionTrigger != null) {
                    b.append(i.executionTrigger);
                    b.append("|");
                }
                if (i.executionType != null) {
                    b.append(i.executionType);
                    b.append("|");
                }
            }
            if (cond != null) {
                b.append(cond);
            }
            String normalizedId = Graph.MD5(b.toString());
            return normalizedId;
        }

        private void writeXmlStuff(InjectionMode mode) throws XMLStreamException {
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                parserFactory.setFeature("http://xml.org/sax/features/validation", false);
                parserFactory.setNamespaceAware(true);
                SAXParser parser = parserFactory.newSAXParser();
                XMLReader saxReader = parser.getXMLReader();
                InjectionContentHandler handler = new InjectionContentHandler(mode);
                saxReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                saxReader.setContentHandler(handler);
                this.mapCode.mdStuffToInject.reset();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.mapCode.mdStuffToInject, "UTF-8"));
                InputSource source = new InputSource(reader);
                try {
                    saxReader.parse(source);
                }
                finally {
                    ((Reader)reader).close();
                    this.mapCode.mdStuffToInject.close();
                }
            }
            catch (Throwable t) {
                throw new XMLStreamException(Messages.XSLProcGenerator_1, t);
            }
        }

        private void writeAttributes(GenerationEventHandler.NodeInfo n, Graph.ModelInfo modelInfo) throws XMLStreamException {
            String semaphoreName;
            String dynName;
            String string = dynName = modelInfo.needParse4DynamicName() ? this.mapCode.generatedCode.getCode(n.getId() + ".dynamicName") : modelInfo.dynamicName;
            if (dynName != null && !dynName.isEmpty()) {
                this.writeAttribute("dynamicName", dynName);
            }
            String string2 = semaphoreName = modelInfo.needParse4SemaphoreName() ? this.mapCode.generatedCode.getCode(n.getId() + ".semaphoreName") : modelInfo.semaphoreName;
            if (semaphoreName != null && !semaphoreName.trim().isEmpty()) {
                this.writeAttribute("semaphoreName", semaphoreName);
            }
            if (modelInfo.encrypted != null && !modelInfo.encrypted.isEmpty()) {
                XSLProcGenerator.this.writer.writeAttribute("encrypted", modelInfo.encrypted);
            }
            if (modelInfo.metaInf != null && !modelInfo.metaInf.isEmpty()) {
                this.writeAttribute("metaInf", modelInfo.metaInf);
            }
            if (modelInfo.nbCycles != null && !modelInfo.nbCycles.isEmpty()) {
                XSLProcGenerator.this.writer.writeAttribute("nbCycles", modelInfo.nbCycles);
            }
            if (modelInfo.restartPoint != null && !modelInfo.restartPoint.isEmpty()) {
                XSLProcGenerator.this.writer.writeAttribute("restartPoint", modelInfo.restartPoint);
            }
            if (modelInfo.stopBindOnError != null && !modelInfo.stopBindOnError.isEmpty()) {
                XSLProcGenerator.this.writer.writeAttribute("stopBindOnError", modelInfo.stopBindOnError);
            }
            if (modelInfo.toleratedErrors != null && !modelInfo.toleratedErrors.isEmpty()) {
                XSLProcGenerator.this.writer.writeAttribute("toleratedError", modelInfo.toleratedErrors);
            }
            if (modelInfo.technologie != null && !modelInfo.technologie.isEmpty()) {
                XSLProcGenerator.this.writer.writeAttribute("technology", modelInfo.technologie);
            }
            if (modelInfo.repetitionPublishParameters != null && !modelInfo.repetitionPublishParameters.isEmpty()) {
                XSLProcGenerator.this.writer.writeAttribute("repetitionPublishParameters", modelInfo.repetitionPublishParameters);
            }
        }

        private String getTagName(Graph.Node node) {
            switch (node.getType()) {
                case ACTION: {
                    return "actionCode";
                }
                case PROCESS: {
                    if (node.getParent() == null) {
                        return "proc:process";
                    }
                    return "subProcess";
                }
            }
            return null;
        }
    }

    class InjectionContentHandler
    implements ContentHandler,
    LexicalHandler {
        boolean shouldWrite = false;
        InjectionMode mode;
        StringBuffer cDataBuffer = null;

        public InjectionContentHandler(InjectionMode mode) {
            this.mode = mode;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!this.shouldWrite) {
                if (this.mode == InjectionMode.CONNECTION && localName.equals("connection")) {
                    this.shouldWrite = true;
                } else if (this.mode == InjectionMode.METADATALINK && localName.equals("metaDataLink")) {
                    this.shouldWrite = true;
                }
            }
            if (this.shouldWrite) {
                try {
                    XSLProcGenerator.this.writer.writeStartElement(qName);
                    int i = 0;
                    while (i < atts.getLength()) {
                        XSLProcGenerator.this.escapedBufferOutputStream.setAttribute(true);
                        XSLProcGenerator.this.writer.writeAttribute(atts.getLocalName(i), atts.getValue(i));
                        XSLProcGenerator.this.escapedBufferOutputStream.setAttribute(false);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.shouldWrite) {
                try {
                    XSLProcGenerator.this.writer.writeEndElement();
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
                if (this.mode == InjectionMode.CONNECTION && localName.equals("connection")) {
                    this.shouldWrite = false;
                } else if (this.mode == InjectionMode.METADATALINK && localName.equals("metaDataLink")) {
                    this.shouldWrite = false;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.shouldWrite) {
                this.cDataBuffer.append(ch, start, length);
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.shouldWrite) {
                this.cDataBuffer = new StringBuffer();
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.shouldWrite) {
                try {
                    XSLProcGenerator.this.writer.writeCData(this.cDataBuffer.toString());
                }
                catch (XMLStreamException ex) {
                    throw new SAXException(ex);
                }
                this.cDataBuffer = null;
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }

    private static enum InjectionMode {
        CONNECTION,
        METADATALINK;

    }
}

