/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration;

import com.semarchy.xdi.designer.generation.model.xdg.DocumentRoot;
import com.semarchy.xdi.designer.generation.model.xdg.Item;
import com.semarchy.xdi.designer.generation.model.xdg.MetadataHint;
import com.semarchy.xdi.designer.generation.model.xdg.Model;
import com.semarchy.xdi.designer.generation.model.xdg.PhysicalStore;
import com.semarchy.xdi.designer.generation.model.xdg.Relation;
import com.semarchy.xdi.designer.generation.model.xdg.XdgFactory;
import com.semarchy.xdi.designer.generation.model.xdg.XdgPackage;
import com.semarchy.xdi.designer.generation.model.xdg.XdiResource;
import com.semarchy.xdi.designer.generation.model.xdg.internal.CustomXdgResourceFactory;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.XdgMdHintsHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.xml.sax.InputSource;

public class XDGAggregator {
    Model aggregatedModel = null;
    List<Path> xdgModels = new ArrayList<Path>();
    XdgMdHintsHandler hintsHandler = new XdgMdHintsHandler();
    Map<String, MetadataHint> addedHints = new HashMap<String, MetadataHint>();
    Transformer mdToEmfTransformer = null;
    Logger logger = LogManager.getLogger(XDGAggregator.class);
    ResourceSet rs = new ResourceSetImpl();
    PathResolver pathResolver;

    private static SAXSource createXSL() throws IOException {
        ByteArrayOutputStream evalOs = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream is = new BufferedInputStream(XDGAggregator.class.getResourceAsStream("xdg.convertToEmf.xsl"));){
            byte[] buf = new byte[2048];
            int sz = -1;
            while ((sz = ((InputStream)is).read(buf)) != -1) {
                evalOs.write(buf, 0, sz);
            }
            evalOs.flush();
            evalOs.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new SAXSource(new InputSource(new BufferedInputStream(new ByteArrayInputStream(evalOs.toByteArray()))));
    }

    public XDGAggregator(PathResolver pathResolver) {
        this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xdg", new CustomXdgResourceFactory());
        XdgPackage.eINSTANCE.eClass();
        this.pathResolver = pathResolver;
    }

    public void addXDGPath(Path mdModelPath) {
        try {
            if (this.mdToEmfTransformer == null) {
                TransformerFactory trFactory = TransformerFactory.newInstance("com.semarchy.xdi.designer.generation.xsl.TransformerFactoryImpl", null);
                trFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                trFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                SAXSource xslSource = XDGAggregator.createXSL();
                xslSource.setSystemId("file:foo1");
                this.mdToEmfTransformer = trFactory.newTransformer(xslSource);
                this.mdToEmfTransformer.setErrorListener(new ErrorListener(){

                    @Override
                    public void warning(TransformerException exception) throws TransformerException {
                        if (XDGAggregator.this.logger.isDebugEnabled()) {
                            XDGAggregator.this.logger.warn((Object)exception);
                        }
                    }

                    @Override
                    public void error(TransformerException exception) throws TransformerException {
                        if (XDGAggregator.this.logger.isDebugEnabled()) {
                            XDGAggregator.this.logger.error((Object)exception);
                        }
                    }

                    @Override
                    public void fatalError(TransformerException exception) throws TransformerException {
                        XDGAggregator.this.logger.error((Object)exception);
                    }
                });
            } else {
                this.mdToEmfTransformer.reset();
            }
            this.convertMdToXdgModel(mdModelPath);
        }
        catch (Exception e) {
            this.logger.error("Failed to handle {}", (Object)mdModelPath, (Object)e);
        }
    }

    private void convertMdToXdgModel(Path mdModelPath) throws TransformerException, IOException {
        StreamSource text = new StreamSource(this.pathResolver.getInputStream(mdModelPath));
        Path xdgModelPath = Path.of(mdModelPath.toString().replace(".xdg.md", ".xdg"), new String[0]);
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream bos = this.pathResolver.getOutputStream(xdgModelPath);){
            this.mdToEmfTransformer.setParameter("hintsHandler", this.hintsHandler);
            this.mdToEmfTransformer.transform(text, new StreamResult(bos));
            this.xdgModels.add(xdgModelPath);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.logger.debug("Converted {} into emf", (Object)mdModelPath);
    }

    private void aggregateModel(Model model) {
        if (this.aggregatedModel == null) {
            this.aggregatedModel = XdgFactory.eINSTANCE.createModel();
        }
        this.aggregatedModel.getDataStorePhysicalStorage().addAll(model.getDataStorePhysicalStorage());
        this.aggregatedModel.getDataStore().addAll(model.getDataStore());
        this.aggregatedModel.getFieldLineage().addAll(model.getFieldLineage());
        this.aggregatedModel.getMappingResource().addAll(model.getMappingResource());
        this.aggregatedModel.getMetaDataResource().addAll(model.getMetaDataResource());
        this.aggregatedModel.getResourceOwner().addAll(model.getResourceOwner());
        this.aggregatedModel.getStore().addAll(model.getStore());
        this.aggregatedModel.getSourceSet().addAll(model.getSourceSet());
        this.aggregatedModel.getSourceSetDatastoreFieldMapping().addAll(model.getSourceSetDatastoreFieldMapping());
        this.aggregatedModel.getSourceSetToTargetDatastore().addAll(model.getSourceSetToTargetDatastore());
        HashMap<MetadataHint, MetadataHint> replacements = new HashMap<MetadataHint, MetadataHint>();
        for (MetadataHint h : new ArrayList<MetadataHint>((Collection<MetadataHint>)model.getMetaDataHint())) {
            MetadataHint cur = this.addedHints.computeIfAbsent(h.getId(), k -> h);
            if (cur != h) {
                replacements.put(h, cur);
                continue;
            }
            this.aggregatedModel.getMetaDataHint().add((Object)cur);
        }
        for (Relation r : new ArrayList<Relation>((Collection<Relation>)model.getModelObjectMetadataHint())) {
            MetadataHint re = (MetadataHint)replacements.get(r.getTarget());
            if (re != null) {
                r.setTarget(re);
            }
            this.aggregatedModel.getModelObjectMetadataHint().add((Object)r);
        }
    }

    public Path createAggregatedFile(Path outputFolder) {
        try {
            return this.saveAggregatedModel(outputFolder);
        }
        catch (Exception e) {
            this.logger.error("Failed to create aggregated XDG model", (Throwable)e);
            return null;
        }
    }

    private Path saveAggregatedModel(Path outputFolder) throws IOException {
        for (Path p : this.xdgModels) {
            Resource r = this.rs.createResource(URI.createURI((String)"hints.xdg"));
            ((ResourceImpl)r).setIntrinsicIDToEObjectMap(new HashMap());
            try {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream is = this.pathResolver.getInputStream(p);){
                        HashMap<String, Object> loadOpts = new HashMap<String, Object>();
                        loadOpts.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                        loadOpts.put("PROCESS_DANGLING_HREF", "RECORD");
                        r.load(is, loadOpts);
                        Model m = ((DocumentRoot)r.getContents().get(0)).getModel();
                        this.aggregateModel(m);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Resource.IOWrappedException e) {
                    this.logger.error("unexpected", (Throwable)e);
                    r.unload();
                    this.rs.getResources().remove((Object)r);
                    continue;
                }
            }
            catch (Throwable throwable) {
                r.unload();
                this.rs.getResources().remove((Object)r);
                throw throwable;
            }
            r.unload();
            this.rs.getResources().remove((Object)r);
        }
        if (this.aggregatedModel == null) {
            return null;
        }
        this.removeDuplicates();
        Path xdgAggregatedModelPath = Path.of(outputFolder.toString(), "xdgModel.xdg");
        URI uri = URI.createFileURI((String)xdgAggregatedModelPath.toString());
        Resource xdgResource = this.rs.createResource(uri);
        ((ResourceImpl)xdgResource).setIntrinsicIDToEObjectMap(new HashMap());
        DocumentRoot root = XdgFactory.eINSTANCE.createDocumentRoot();
        root.setModel(this.aggregatedModel);
        xdgResource.getContents().add((Object)root);
        HashMap<String, String> saveOpts = new HashMap<String, String>();
        saveOpts.put("ENCODING", "UTF-8");
        try {
            xdgResource.save(this.pathResolver.getOutputStream(xdgAggregatedModelPath), saveOpts);
            Path path = xdgAggregatedModelPath;
            return path;
        }
        finally {
            xdgResource.unload();
            this.rs.getResources().remove((Object)xdgResource);
        }
    }

    private void removeDuplicates() {
        HashSet<String> mdModelIds = new HashSet<String>();
        HashSet<XdiResource> mdResourceToRemove = new HashSet<XdiResource>();
        for (XdiResource res : this.aggregatedModel.getMetaDataResource()) {
            if (mdModelIds.add(res.getModelId())) continue;
            mdResourceToRemove.add(res);
        }
        Set ownerRelationToRemove = this.aggregatedModel.getResourceOwner().stream().filter(r -> mdResourceToRemove.contains(r.getSource())).collect(Collectors.toSet());
        HashSet<PhysicalStore> storeToRemove = new HashSet<PhysicalStore>();
        HashSet storeOwnerRelationToRemove = new HashSet();
        HashSet<String> uniquePhysicalStoreId = new HashSet<String>();
        for (Relation r2 : ownerRelationToRemove) {
            PhysicalStore store = (PhysicalStore)r2.getTarget();
            if (uniquePhysicalStoreId.add(store.getModelId())) continue;
            storeToRemove.add(store);
            storeOwnerRelationToRemove.addAll(this.aggregatedModel.getResourceOwner().stream().filter(rel -> rel.getTarget() == store).collect(Collectors.toSet()));
        }
        HashMap<PhysicalStore, PhysicalStore> replacement = new HashMap<PhysicalStore, PhysicalStore>();
        for (PhysicalStore s : storeToRemove) {
            Optional<PhysicalStore> opt = this.aggregatedModel.getStore().stream().filter(c -> c.getModelId().equals(s.getModelId()) && !storeToRemove.contains(c)).findAny();
            if (opt.isEmpty()) {
                throw new IllegalArgumentException("Unexpected");
            }
            replacement.put(s, opt.get());
        }
        this.aggregatedModel.getMetaDataResource().removeAll(mdResourceToRemove);
        this.aggregatedModel.getResourceOwner().removeAll(ownerRelationToRemove);
        this.aggregatedModel.getResourceOwner().removeAll(storeOwnerRelationToRemove);
        this.aggregatedModel.getStore().removeAll(storeToRemove);
        for (Relation r3 : this.aggregatedModel.getDataStorePhysicalStorage()) {
            if (!storeToRemove.contains(r3.getTarget())) continue;
            r3.setTarget((Item)replacement.get(r3.getTarget()));
        }
    }

    public static interface PathResolver {
        public InputStream getInputStream(Path var1) throws IOException;

        public OutputStream getOutputStream(Path var1) throws IOException;
    }
}

