/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.global;

import com.indy.libraries.build.parser.xsl.XslParser;
import com.indy.libraries.build.utils.StringUtils;
import com.semarchy.xdi.designer.generation.xsl.global.Messages;
import com.semarchy.xdi.designer.generation.xsl.global.UnsupportedEscapingFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class Strings {
    private Strings() {
    }

    public static String[] split(String str, String regex) {
        return str.split(regex);
    }

    public static String replace(String str, String target, String replacement) {
        return str.replace(target, replacement);
    }

    public static String replaceAll(String str, String target, String replacement) {
        return StringUtils.replaceAll((String)str, (String)target, (String)replacement);
    }

    public static String replaceAll3(String src, String start, String newStart, String middle, String newMiddle, String end, String newEnd) {
        String[] regexp = new String[]{start, middle, end};
        String[] replacement = new String[]{newStart, newMiddle, newEnd};
        return Strings.replaceAll(src, regexp, replacement);
    }

    public static String replaceAll(String src, String[] regexp, String[] replacement) {
        return StringUtils.replaceAll((String)src, (String[])regexp, (String[])replacement);
    }

    public static String replaceAll2(String src, String regex1, String regex2, String replacement) {
        Object retour = "";
        Pattern pDeb = Pattern.compile(regex1);
        Matcher mDeb = pDeb.matcher(src);
        int lastFin = 0;
        while (mDeb.find()) {
            int iDeb = mDeb.start();
            int iFin = mDeb.end();
            retour = (String)retour + src.substring(lastFin, iDeb);
            String temp = src.substring(iDeb, iFin).replaceAll(regex2, replacement);
            retour = (String)retour + temp;
            lastFin = iFin;
        }
        retour = (String)retour + src.substring(lastFin, src.length());
        return retour;
    }

    public static String encodeHexString(String sourceText, boolean replaceSpecialChar) {
        return StringUtils.encodeHexString((String)sourceText, (boolean)replaceSpecialChar);
    }

    public static String encodeHexString(String sourceText) {
        return StringUtils.encodeHexString((String)sourceText, (boolean)true);
    }

    public static String decodeHexString(String hexa) {
        return StringUtils.decodeHexString((String)hexa, (boolean)true);
    }

    public static String escape(String textToEscape, String format) throws UnsupportedEscapingFormatException {
        String escapedText = "";
        switch (format = format.toUpperCase()) {
            case "CSV": {
                escapedText = StringEscapeUtils.escapeCsv((String)textToEscape);
                break;
            }
            case "ECMASCRIPT": {
                escapedText = StringEscapeUtils.escapeEcmaScript((String)textToEscape);
                break;
            }
            case "HTML3": {
                escapedText = StringEscapeUtils.escapeHtml3((String)textToEscape);
                break;
            }
            case "HTML4": {
                escapedText = StringEscapeUtils.escapeHtml4((String)textToEscape);
                break;
            }
            case "JAVA": {
                escapedText = StringEscapeUtils.escapeJava((String)textToEscape);
                break;
            }
            case "JSON": {
                escapedText = StringEscapeUtils.escapeJson((String)textToEscape);
                break;
            }
            case "XML10": {
                escapedText = StringEscapeUtils.escapeXml10((String)textToEscape);
                break;
            }
            case "XML11": {
                escapedText = StringEscapeUtils.escapeXml11((String)textToEscape);
                break;
            }
            case "XSI": {
                escapedText = StringEscapeUtils.unescapeXSI((String)textToEscape);
                break;
            }
            default: {
                throw new UnsupportedEscapingFormatException(String.format(Messages.Strings_0, format));
            }
        }
        return escapedText;
    }

    public static String decodeSpecialChar(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t").replaceAll("\\\\r", "\r").replaceAll("\\\\f", "\f");
    }

    public static String prepareToParse1(String str) throws XslParser.XSLParseException {
        return StringUtils.prepareToParse1((String)str);
    }

    public static String prepareToParse2(String str) {
        Object _code = Strings.restoreSpecialCharacter(str);
        String start = "<tmp xmlns:indyParse=\"http://www.stambia.com/indyParse\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"  xmlns:xslo=\"http://www.example.org/xslo\" xmlns:saxono=\"http://www.example.org/saxono\">";
        String end = "</tmp>";
        _code = start + (String)_code + end;
        return _code;
    }

    public static String restoreSpecialCharacter(String str) {
        String retour = str.replaceAll("\u00a4\u00a4\u00a3\u00a4\u00a4", "<").replaceAll("\u00a7\u00a7\u00a4\u00a7\u00a7", "&").replaceAll("\u00a3\u00a3\u00a4\u00a3\u00a3", "<>");
        return retour;
    }
}

