/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileMetadata;

import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataColumn;
import com.stambia.jdbc.driver.file.tools.BinaryNumber;
import java.math.BigDecimal;
import java.nio.charset.Charset;

public enum Dataypes {
    NUMERIC_BINARY_SIGNED("Numeric binary", 2, new NumericFixedBinaryConverter()),
    NUMERIC_BINARY_UNSIGNED("Numeric bynary unsigned", 2, new NumericFixedBinaryConverter()),
    NUMERIC_PACKED_SIGNED("Numeric packed", 2, new NumericPackedBinaryConverter()),
    NUMERIC_PACKED_UNSIGNED("Numeric packed unsigned", 2, new NumericPackedBinaryConverter());

    String name;
    int sqlType;
    private MetadataColumn.StringToNumberConverter converter;

    public MetadataColumn.StringToNumberConverter getConverter() {
        return this.converter;
    }

    private Dataypes(String name, int sqlType, MetadataColumn.StringToNumberConverter converter) {
        this.name = name;
        this.converter = converter;
        this.sqlType = sqlType;
    }

    public static Dataypes getType(String name) {
        Dataypes[] dataypesArray = Dataypes.values();
        int n = dataypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dataypes type = dataypesArray[n2];
            if (type.name.equalsIgnoreCase(name)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    static class NumericFixedBinaryConverter
    implements MetadataColumn.StringToNumberConverter {
        NumericFixedBinaryConverter() {
        }

        @Override
        public BigDecimal parse(String str, String encoding, IMetadataColumn col) throws Exception {
            if (str != null) {
                byte[] result = str.getBytes(Charset.forName(encoding));
                if (col.getScale() > 0) {
                    BigDecimal d = BinaryNumber.getBigDecimal(result, true, col.getByteOrder(), col.getScale(), false);
                    return d;
                }
                long l = BinaryNumber.getLong(result, true, col.getByteOrder());
                return new BigDecimal(l);
            }
            return null;
        }
    }

    static class NumericPackedBinaryConverter
    implements MetadataColumn.StringToNumberConverter {
        NumericPackedBinaryConverter() {
        }

        @Override
        public BigDecimal parse(String str, String encoding, IMetadataColumn col) throws Exception {
            if (str != null) {
                byte[] result = str.getBytes(Charset.forName(encoding));
                if (col.getScale() > 0) {
                    BigDecimal d = BinaryNumber.getBigDecimal(result, true, col.getByteOrder(), col.getScale(), true);
                    return d;
                }
                long l = BinaryNumber.getPackedLong(result, true);
                return new BigDecimal(l);
            }
            return null;
        }
    }
}

