/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common;

import java.sql.SQLException;

public class ColumnMetaData
implements Comparable<ColumnMetaData> {
    int position;
    String tableName = "";
    Integer scale = 0;
    Integer precision;
    String typeName;
    int type;
    String name;
    String label;
    Integer displaySize;
    String className;
    private String catalogName = "";

    public ColumnMetaData(String name) {
        this(name, null, 12, 255);
        this.displaySize = 255;
        this.className = String.class.getName();
    }

    public ColumnMetaData(String name, String label) {
        this(name, label, 12, 255);
    }

    public ColumnMetaData(String name, String label, int type) {
        this(name, label, type, -1);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ColumnMetaData(String name, String label, int type, Integer precision) {
        this.precision = precision;
        this.type = type;
        int _type = type;
        switch (_type) {
            case 3: {
                this.typeName = "DECIMAL";
                break;
            }
            case 2: {
                this.typeName = "NUMERIC";
                break;
            }
            case 4: {
                this.typeName = "INTEGER";
                break;
            }
            case 91: {
                this.typeName = "DATE";
                break;
            }
            case 93: {
                this.typeName = "TIMESTAMP";
                break;
            }
            default: {
                this.typeName = "VARCHAR";
            }
        }
        this.name = name;
        this.label = label != null ? label : name;
        this.displaySize = precision;
        this.className = String.class.getName();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCatalogName() throws SQLException {
        return this.catalogName;
    }

    public String getColumnClassName() throws SQLException {
        return this.className;
    }

    public int getColumnDisplaySize() throws SQLException {
        return this.displaySize;
    }

    public String getColumnLabel() throws SQLException {
        return this.label;
    }

    public String getColumnName() throws SQLException {
        return this.name;
    }

    public int getColumnType() throws SQLException {
        return this.type;
    }

    public String getColumnTypeName() throws SQLException {
        return this.typeName;
    }

    public int getPrecision() throws SQLException {
        return this.precision;
    }

    public int getScale() throws SQLException {
        return this.scale;
    }

    public String getSchemaName() throws SQLException {
        return "";
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public boolean isAutoIncrement() throws SQLException {
        return false;
    }

    public boolean isCaseSensitive() throws SQLException {
        return false;
    }

    public boolean isCurrency() throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable() throws SQLException {
        return false;
    }

    public int isNullable() throws SQLException {
        return 2;
    }

    public boolean isReadOnly() throws SQLException {
        return true;
    }

    public boolean isSearchable() throws SQLException {
        return false;
    }

    public boolean isSigned() throws SQLException {
        return false;
    }

    public boolean isWritable() throws SQLException {
        return false;
    }

    public void setCatalogName(String catalog) {
        this.catalogName = catalog;
    }

    @Override
    public int compareTo(ColumnMetaData arg0) {
        return Integer.valueOf(this.getPosition()).compareTo(arg0.getPosition());
    }
}

