/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common;

import com.stambia.jdbc.common.ColumnMetaData;
import com.stambia.jdbc.common.Messages;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnMetaDataSet {
    List<ColumnMetaData> cols = new ArrayList<ColumnMetaData>();
    private Map<String, Integer> positions = new HashMap<String, Integer>();

    public Collection<ColumnMetaData> getColumns() {
        return this.cols;
    }

    public ColumnMetaData getColumnMetaData(int position) {
        return this.cols.get(position);
    }

    public ColumnMetaDataSet(ResultSet rs, Collection<String> columns, Map<String, String> aliases, String catalogName, String tableName, Map<String, Integer> cellsIndex) throws SQLException {
        this.setUpColumnDataSet(rs, columns, aliases, catalogName, tableName);
        Map<String, Integer> formatCellIndex = this.formatNameBeforeComparison(cellsIndex);
        for (ColumnMetaData c : this.cols) {
            if (formatCellIndex.get(this.normalizeColumnName(c.getColumnName())) == null) continue;
            c.setPosition(formatCellIndex.get(this.normalizeColumnName(c.getColumnName())));
        }
    }

    private void setUpColumnDataSet(ResultSet rs, Collection<String> columns, Map<String, String> aliases, String catalogName, String tableName) throws SQLException {
        ColumnMetaData col;
        int k;
        ArrayList<String> listColumns;
        ArrayList<String> arrayList = listColumns = columns != null ? new ArrayList<String>(columns) : null;
        if (listColumns != null) {
            k = 1;
            for (String name : listColumns) {
                this.positions.put(name, k++);
            }
        }
        k = 1;
        ArrayList<ColumnMetaData> tmpCols = new ArrayList<ColumnMetaData>();
        HashMap<String, ColumnMetaData> map = new HashMap<String, ColumnMetaData>();
        while (rs.next()) {
            String name = rs.getString("COLUMN_NAME");
            int n = rs.getInt("DATA_TYPE");
            col = new ColumnMetaData(name, null, n);
            col.setTableName(tableName);
            col.setCatalogName(catalogName);
            col.setPosition(k++);
            tmpCols.add(col);
            map.put(name, col);
        }
        if (columns == null) {
            this.cols.clear();
            this.cols.addAll(tmpCols);
        } else {
            if (aliases == null) {
                aliases = new HashMap<String, String>();
                for (String string : columns) {
                    aliases.put(string, string);
                }
            }
            for (Map.Entry entry : aliases.entrySet()) {
                if (!((String)entry.getKey()).equals("row_count") && !((String)entry.getKey()).equals("row_number")) continue;
                col = new ColumnMetaData((String)entry.getKey());
                col.setTableName((String)entry.getKey());
                col.setCatalogName(catalogName);
                col.setPosition(k++);
                tmpCols.add(col);
                map.put((String)entry.getKey(), col);
            }
            for (String string : columns) {
                listColumns.remove(string);
                String tbname = null;
                for (String string2 : aliases.keySet()) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    tbname = aliases.get(string2);
                    break;
                }
                ColumnMetaData columnMetadata = null;
                for (String str3 : map.keySet()) {
                    if (!str3.equalsIgnoreCase(tbname)) continue;
                    columnMetadata = (ColumnMetaData)map.get(str3);
                    break;
                }
                if (columnMetadata == null) {
                    throw new SQLException(Messages.getString("ColumnMetaDataSet.0") + tbname);
                }
                ColumnMetaData columnMetaData = new ColumnMetaData(columnMetadata.getColumnName(), string, columnMetadata.getColumnType());
                columnMetaData.setTableName(columnMetaData.getTableName());
                columnMetaData.setCatalogName(columnMetaData.getCatalogName());
                columnMetaData.setPosition(columnMetadata.getPosition());
                this.cols.add(columnMetaData);
            }
        }
        if (listColumns != null && !listColumns.isEmpty()) {
            throw new SQLException(Messages.getString("ColumnMetaDataSet.0") + String.valueOf(this.cols));
        }
    }

    public Map<String, Integer> formatNameBeforeComparison(Map<String, Integer> cellsIndex) {
        HashMap<String, Integer> formatCellIndex = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> s : cellsIndex.entrySet()) {
            formatCellIndex.put(this.normalizeColumnName(s.getKey()), cellsIndex.get(s.getKey()));
        }
        return formatCellIndex;
    }

    private String normalizeColumnName(String baseColName) {
        return Normalizer.normalize(baseColName.toUpperCase(), Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "").replaceAll("[^a-zA-Z0-9]", "");
    }
}

