/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xls.internal;

import com.stambia.jdbc.common.ColumnMetaDataSet;
import com.stambia.jdbc.common.parser.IWhereVisitor;
import com.stambia.jdbc.driver.xls.internal.Messages;

public class Evaluator {
    private ColumnMetaDataSet cmd;
    private IWhereVisitor visitor;
    private Integer leftColumnIndex;
    private Integer rightColumnIndex;

    public Evaluator(ColumnMetaDataSet cmd, IWhereVisitor visitor) throws Exception {
        this.cmd = cmd;
        this.visitor = visitor;
        this.initIndexes();
    }

    private void initIndexes() throws Exception {
        for (int i = 0; i < this.cmd.getColumns().size(); ++i) {
            if (this.visitor.isLeftCol() && this.cmd.getColumnMetaData(i).getColumnName().equals(this.visitor.getLeftExpression())) {
                this.leftColumnIndex = i;
                continue;
            }
            if (!this.visitor.isRightCol() || !this.cmd.getColumnMetaData(i).getColumnName().equals(this.visitor.getRightExpression())) continue;
            this.rightColumnIndex = i;
        }
        if (this.visitor.isLeftCol() && this.leftColumnIndex == null) {
            throw new Exception(Messages.getString("Evaluator.0") + this.visitor.getLeftExpression());
        }
        if (this.visitor.isRightCol() && this.rightColumnIndex == null) {
            throw new Exception(Messages.getString("Evaluator.1") + this.visitor.getRightExpression());
        }
    }

    private String buildEvalLeft(String[] datas) {
        if (this.visitor.isLeftCol()) {
            return datas[this.leftColumnIndex];
        }
        return this.visitor.getLeftExpression();
    }

    private String buildEvalRight(String[] datas) {
        if (this.visitor.isRightCol()) {
            return datas[this.rightColumnIndex];
        }
        return this.visitor.getRightExpression();
    }

    public boolean isValid(String[] datas) {
        String left = this.buildEvalLeft(datas);
        String right = this.buildEvalRight(datas);
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return left == null;
        }
        return left.equals(right);
    }
}

