/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xls.xls;

import com.stambia.jdbc.common.ColumnMetaData;
import com.stambia.jdbc.common.ColumnMetaDataSet;
import com.stambia.jdbc.common.CommonResultSet;
import com.stambia.jdbc.common.CommonResultSetMetaData;
import com.stambia.jdbc.common.CreateMetaData;
import com.stambia.jdbc.common.RowData;
import com.stambia.jdbc.common.TableMetaData;
import com.stambia.jdbc.common.ValueMetaData;
import com.stambia.jdbc.common.parser.IWhereVisitor;
import com.stambia.jdbc.common.parser.InsertMetaData;
import com.stambia.jdbc.common.parser.Parser;
import com.stambia.jdbc.common.parser.SelectMetaData;
import com.stambia.jdbc.common.parser.XLSXWhereVisitor;
import com.stambia.jdbc.common.tools.ColumnNameGeneratorUtil;
import com.stambia.jdbc.driver.xls.internal.Evaluator;
import com.stambia.jdbc.driver.xls.internal.IWorkbookControler;
import com.stambia.jdbc.driver.xls.xls.Messages;
import com.stambia.jdbc.driver.xls.xls.NoSheetException;
import com.stambia.jdbc.driver.xls.xls.XlsConnection;
import com.stambia.jdbc.driver.xls.xls.XlsDatabaseMetaData;
import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xls.xls.XlsxRowComparator;
import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.part.Sheet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XlsStatement
implements Statement {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private XlsConnection connection;
    private CommonResultSet resultSet;
    private boolean isClosed = false;
    private int fetchSize = 1;
    private final SimpleDateFormat timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");

    public XlsStatement(XlsConnection connection) {
        this.connection = connection;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Parser sqlParser = new Parser(sql);
        SelectMetaData parser = sqlParser.getSelectMetaData(new XLSXWhereVisitor());
        if (parser == null) {
            throw new XlsException(Messages.getString("XlsStatement.1"));
        }
        return this.executeQuery(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResultSet executeQuery(SelectMetaData parser) throws SQLException {
        IWorkbookControler connectionControler = this.connection.getControler();
        connectionControler.lock();
        try {
            List<TableMetaData> tables = parser.getTableFrom();
            if (tables.isEmpty()) {
                throw new XlsException(Messages.getString("XlsStatement.2"));
            }
            if (tables.size() > 1) {
                throw new XlsException(Messages.getString("XlsStatement.3"));
            }
            TableMetaData table = tables.get(0);
            String tableName = table.getTableName();
            List<String> columnList = parser.isAllColumns() ? null : parser.getLstStringColumns();
            Map<String, String> aliases = parser.isAllColumns() ? null : parser.getAliasesColumn();
            DatabaseMetaData dmd = this.connection.getMetaData();
            ResultSet rs = dmd.getTables(this.connection.getCatalog(), table.getSchemaName(), tableName, null);
            if (!rs.next()) {
                throw new XlsException(Messages.getString("XlsStatement.4") + table.getWholeTableName());
            }
            rs = dmd.getColumns(this.connection.getCatalog(), null, tableName, null);
            ColumnMetaDataSet cds = new ColumnMetaDataSet(rs, columnList, aliases, this.connection.getCatalog(), tableName, connectionControler.getColumnsPosition(tableName));
            Collection<ColumnMetaData> columnsCollection = cds.getColumns();
            for (ColumnMetaData columnMetaData : columnsCollection) {
                for (ColumnMetaData parserColumnMetaData : parser.getSelectedColumns()) {
                    if (!columnMetaData.getColumnName().equalsIgnoreCase(parserColumnMetaData.getColumnName())) continue;
                    columnMetaData.setType(parserColumnMetaData.getColumnType());
                }
            }
            CommonResultSet crs = new CommonResultSet();
            crs.setMetaData(new CommonResultSetMetaData(columnsCollection.toArray(new ColumnMetaData[columnsCollection.size()])));
            ArrayList<RowData> datas = new ArrayList<RowData>();
            IWhereVisitor whereVisitor = parser.getWhereVisitor();
            Integer[] tableArea = connectionControler.getTableDelimiter(tableName, true);
            int startRow = tableArea[1];
            int endRow = tableArea[3];
            int startCol = tableArea[0];
            int endCol = tableArea[2];
            HashMap<Integer, Integer> columns = new HashMap<Integer, Integer>();
            ArrayList<Integer> columnsOrder = new ArrayList<Integer>();
            for (int i = 0; i < (columnList != null ? columnList.size() : columnsCollection.size()); ++i) {
                columnsOrder.add(i);
            }
            ColumnMetaDataSet columnMetadata = cds;
            Collections.sort(columnsOrder, (o1, o2) -> Integer.compare(columnMetadata.getColumnMetaData((int)o1).getPosition(), columnMetadata.getColumnMetaData((int)o2).getPosition()));
            for (ColumnMetaData col : columnsCollection) {
                columns.put(col.getPosition(), col.getColumnType());
            }
            int columnsNumber = columns.size();
            Map<Integer, Integer> propertyFieldIndices = this.computePropertyFieldsIndices(columnsCollection.iterator(), columnsNumber);
            Evaluator evaluator = null;
            if (whereVisitor != null) {
                try {
                    evaluator = new Evaluator(cds, whereVisitor);
                }
                catch (Exception e1) {
                    throw new XlsException(e1);
                }
            }
            int propertyFieldIndex = connectionControler.getPropertyFieldIndex(tableName);
            for (int currentRowIdx = ++startRow; currentRowIdx <= endRow; ++currentRowIdx) {
                String[] colData = new String[columnsNumber];
                int k = 0;
                for (int j = startCol; j <= endCol; ++j) {
                    if (!columns.containsKey(j)) continue;
                    String value = connectionControler.evaluateCellValue(tableName, currentRowIdx, j);
                    if (value != null) {
                        if ((Integer)columns.get(j) == 93) {
                            if (value.isEmpty()) {
                                value = null;
                            } else {
                                try {
                                    numberOfDay = Double.valueOf(value);
                                    result = XlsxUtils.xlsxDateToJavaDate(connectionControler.is1904DateSystem(), numberOfDay);
                                    value = this.timestamp.format(result);
                                }
                                catch (Exception e) {
                                    throw new XlsException(Messages.getString("XlsStatement.5") + value + Messages.getString("XlsStatement.6"));
                                }
                            }
                        } else if ((Integer)columns.get(j) == 91) {
                            if (value.isEmpty()) {
                                value = null;
                            } else {
                                try {
                                    numberOfDay = Double.valueOf(value);
                                    result = XlsxUtils.xlsxDateToJavaDate(connectionControler.is1904DateSystem(), numberOfDay);
                                    value = this.date.format(result);
                                }
                                catch (Exception e) {
                                    throw new XlsException(Messages.getString("XlsStatement.7") + value + Messages.getString("XlsStatement.8"));
                                }
                            }
                        } else if ((Integer)columns.get(j) == 92) {
                            if (value.isEmpty()) {
                                value = null;
                            } else {
                                try {
                                    numberOfDay = Double.valueOf(value);
                                    result = XlsxUtils.xlsxDateToJavaDate(connectionControler.is1904DateSystem(), numberOfDay);
                                    value = this.time.format(result);
                                }
                                catch (Exception e) {
                                    throw new XlsException(Messages.getString("XlsStatement.9") + value + Messages.getString("XlsStatement.10"));
                                }
                            }
                        } else if ((Integer)columns.get(j) == 16) {
                            if (value.isEmpty()) {
                                value = null;
                            } else if (value.equals("0")) {
                                value = "false";
                            } else {
                                if (!value.equals("1")) throw new XlsException(Messages.getString("XlsStatement.11") + value + Messages.getString("XlsStatement.12"));
                                value = "true";
                            }
                        } else if ((Integer)columns.get(j) == 2) {
                            if (value.isEmpty()) {
                                value = null;
                            } else {
                                try {
                                    new BigDecimal(value);
                                }
                                catch (NumberFormatException e) {
                                    throw new XlsException(Messages.getString("XlsStatement.13") + value + Messages.getString("XlsStatement.14"));
                                }
                            }
                        }
                    }
                    colData[((Integer)columnsOrder.get((int)k++)).intValue()] = value;
                }
                Map<Integer, String> propertyFields = connectionControler.evaluatePropertyFieldsValues(tableName, columns.keySet(), currentRowIdx, propertyFieldIndex);
                for (Map.Entry<Integer, Integer> entry : propertyFieldIndices.entrySet()) {
                    String propertyFieldValue;
                    int propertyFieldColumnIndex = entry.getValue();
                    colData[entry.getKey().intValue()] = propertyFieldValue = propertyFields.get(propertyFieldColumnIndex);
                }
                if (evaluator != null && !evaluator.isValid(colData)) continue;
                datas.add(new RowData(colData));
            }
            RowData[] rowDatas = datas.toArray(new RowData[datas.size()]);
            if (!parser.getOrderByElements().isEmpty()) {
                try {
                    Arrays.sort(rowDatas, new XlsxRowComparator(columnMetadata, parser, connectionControler.is1904DateSystem()));
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            crs.setData(rowDatas);
            this.resultSet = crs;
            CommonResultSet commonResultSet = crs;
            return commonResultSet;
        }
        finally {
            connectionControler.unLock();
            connectionControler.releaseConnectionIfNeeded();
        }
    }

    private Map<Integer, Integer> computePropertyFieldsIndices(Iterator<ColumnMetaData> columnMetaDataIterator, int columnsNumber) throws SQLException {
        LinkedHashMap<Integer, Integer> propertyFieldIndices = new LinkedHashMap<Integer, Integer>();
        for (int colOrder = 0; columnMetaDataIterator.hasNext() && colOrder < columnsNumber; ++colOrder) {
            ColumnMetaData cmd = columnMetaDataIterator.next();
            String name = cmd.getColumnName();
            if (!Sheet.PROPERTY_FIELDS_NAMES.contains(name)) continue;
            int propertyFieldIndex = cmd.getPosition();
            propertyFieldIndices.put(colOrder, propertyFieldIndex);
        }
        return propertyFieldIndices;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 1;
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.resultSet = null;
        this.connection = null;
        this.clearBatch();
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return -1;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return -1;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            CreateMetaData createParser;
            InsertMetaData insertParser;
            TableMetaData deleteTable;
            TableMetaData truncateTable;
            boolean ret = false;
            if (sql.trim().toLowerCase().matches("commit\\s*;*")) {
                this.getConnection().commit();
                return false;
            }
            Parser parser = new Parser(sql);
            SelectMetaData select = parser.getSelectMetaData(new XLSXWhereVisitor());
            if (select != null) {
                this.executeQuery(select);
                ret = true;
            }
            if ((truncateTable = parser.getTruncateParser()) != null) {
                this.executeTruncate(truncateTable);
                ret = false;
            }
            if ((deleteTable = parser.getDeleteParser()) != null) {
                this.executeDelete(deleteTable);
                ret = false;
            }
            if ((insertParser = parser.getInsertMetaData()) != null) {
                InsertStatement is = new InsertStatement(insertParser);
                is.executeImmediately();
                ret = false;
            }
            if ((createParser = parser.getCreateMetaData()) != null) {
                this.executeCreateTable(createParser);
            }
            if (!ret && this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            return ret;
        }
        catch (SQLException ex) {
            this.logger.warn("Unexpected", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.warn("Unexpected", (Throwable)ex);
            throw new XlsException(ex.getMessage(), ex);
        }
    }

    private void executeCreateTable(CreateMetaData createParser) throws XlsException {
        this.connection.getControler().createTable(createParser.getTableMetaData().getTableName(), createParser.getColumnsMetaData());
    }

    private void executeTruncate(TableMetaData truncateTable) throws SQLException {
        this.connection.getControler().lock();
        this.connection.getControler().changeCatalog(truncateTable.getSchemaName());
        this.connection.getControler().truncateSheet(truncateTable.getSchemaName(), truncateTable.getTableName());
        this.connection.getControler().unLock();
        this.connection.getControler().releaseConnectionIfNeeded();
    }

    private void executeDelete(TableMetaData deleteTable) throws SQLException {
        this.executeTruncate(deleteTable);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return -1;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return -1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    class InsertStatement {
        InsertMetaData insertParser;
        ColumnMetaDataSet cds;
        ValueMetaData[] statementLstValues;
        ColumnMetaData[] metaData;
        int parameterNumber = 0;
        private String catalog;
        private String tableName;
        protected List<String[]> valuesBuffer = null;

        InsertStatement(InsertMetaData insertParser) {
            this.insertParser = insertParser;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getTableName() {
            return this.tableName;
        }

        void prepare() throws SQLException {
            block8: {
                List<ValueMetaData> lstValue = this.insertParser.getLstValue();
                this.catalog = this.insertParser.getTableMetaData().getSchemaName();
                if (XlsStatement.this.connection.getControler().getPathType() == IWorkbookControler.PATH_TYPE.FOLDER) {
                    XlsStatement.this.connection.setCatalog(this.catalog);
                }
                XlsStatement.this.connection.getControler().changeCatalog(this.catalog);
                this.tableName = this.insertParser.getTableMetaData().getTableName();
                if (this.insertParser.getColumnsNumber() > 0 && lstValue.size() != this.insertParser.getColumnsNumber()) {
                    throw new XlsException(Messages.getString("XlsStatement.0"));
                }
                this.statementLstValues = new ValueMetaData[this.insertParser.getLstValue().size()];
                Iterator<ValueMetaData> it = lstValue.iterator();
                int i = 0;
                while (it.hasNext()) {
                    ValueMetaData o;
                    this.statementLstValues[i] = o = it.next();
                    if (o.getValue() == null) {
                        ++this.parameterNumber;
                    }
                    ++i;
                }
                XMLInputFactory inFactory = XMLInputFactory.newInstance();
                XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
                XlsStatement.this.connection.getControler().createHeaderIfNeeded(inFactory, outFactory, this.catalog, this.tableName, this.insertParser.getColumnNames());
                ResultSet rs = XlsStatement.this.connection.getMetaData().getColumns(this.catalog, null, this.tableName, null);
                List<String> columnNames = this.insertParser.getColumnNames();
                try {
                    ColumnMetaDataSet columnMetadata = new ColumnMetaDataSet(rs, columnNames != null && !columnNames.isEmpty() ? columnNames : null, null, this.catalog, this.tableName, XlsStatement.this.connection.getControler().getColumnsPosition(this.tableName));
                    this.metaData = new ColumnMetaData[this.statementLstValues.length];
                    for (int i2 = 0; i2 < this.statementLstValues.length; ++i2) {
                        ColumnMetaData cmd;
                        this.metaData[i2] = cmd = columnMetadata.getColumnMetaData(i2);
                    }
                }
                catch (NoSheetException ex) {
                    ArrayList<String> l = new ArrayList<String>();
                    for (String s : columnNames) {
                        l.add(ColumnNameGeneratorUtil.unformatColumnName(XlsStatement.this.connection.getControler().getColumnNamingStyle(), s));
                    }
                    if (!XlsStatement.this.connection.getControler().createSheet(XlsDatabaseMetaData.unformatTableName(this.tableName), l.toArray(new String[l.size()]))) break block8;
                    this.prepare();
                }
            }
        }

        Object[] initNewRow() {
            return new Object[this.parameterNumber];
        }

        void executeImmediately() throws SQLException {
            this.prepare();
            Object[] row = this.initNewRow();
            this.insert(row);
        }

        int[] insert(List<Object[]> rows) throws SQLException {
            int[] ret = new int[rows.size()];
            LinkedList<HashMap<Integer, Object>> rowsValues = new LinkedList<HashMap<Integer, Object>>();
            LinkedList<HashMap<Integer, Integer>> rowsDataTypes = new LinkedList<HashMap<Integer, Integer>>();
            for (int i = 0; i < rows.size(); ++i) {
                int k = 0;
                HashMap<Integer, Object> values = new HashMap<Integer, Object>();
                HashMap<Integer, Integer> dataTypes = new HashMap<Integer, Integer>();
                for (int j = 0; j < this.statementLstValues.length; ++j) {
                    ColumnMetaData cmd = this.metaData[j];
                    ValueMetaData vmd = this.statementLstValues[j];
                    Object value = vmd.isParameter() ? rows.get(i)[k++] : vmd.getValue();
                    if (value instanceof Date) {
                        dataTypes.put(cmd.getPosition(), 91);
                    } else if (value instanceof Time) {
                        dataTypes.put(cmd.getPosition(), 92);
                    } else if (value instanceof Timestamp) {
                        dataTypes.put(cmd.getPosition(), 93);
                    } else if (value instanceof Boolean) {
                        dataTypes.put(cmd.getPosition(), 16);
                    } else if (value instanceof String) {
                        dataTypes.put(cmd.getPosition(), 12);
                    } else if (value instanceof BigInteger || value instanceof Long) {
                        dataTypes.put(cmd.getPosition(), -5);
                    } else if (value instanceof BigDecimal) {
                        dataTypes.put(cmd.getPosition(), 3);
                    } else if (value instanceof Double) {
                        dataTypes.put(cmd.getPosition(), 8);
                    } else if (value instanceof Float) {
                        dataTypes.put(cmd.getPosition(), 6);
                    } else if (value instanceof Integer) {
                        dataTypes.put(cmd.getPosition(), 4);
                    } else if (value instanceof Number) {
                        dataTypes.put(cmd.getPosition(), -5);
                    }
                    values.put(cmd.getPosition(), value);
                }
                rowsValues.add(values);
                rowsDataTypes.add(dataTypes);
                ret[i] = 1;
            }
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
            XlsStatement.this.connection.getControler().lock();
            XlsStatement.this.connection.getControler().changeCatalog(this.catalog);
            XlsStatement.this.connection.getControler().insertRows(inFactory, outFactory, this.getCatalog(), this.tableName, rowsValues, rowsDataTypes);
            XlsStatement.this.connection.getControler().unLock();
            return ret;
        }

        void insert(Object[] row) throws SQLException {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            rows.add(row);
            this.insert(rows);
        }
    }
}

