/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.cell;

import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.cell.BooleanCell;
import com.stambia.jdbc.driver.xlsx.cell.Cell;
import com.stambia.jdbc.driver.xlsx.cell.DateCell;
import com.stambia.jdbc.driver.xlsx.cell.ErrorCell;
import com.stambia.jdbc.driver.xlsx.cell.FormulaCell;
import com.stambia.jdbc.driver.xlsx.cell.InlineStrCell;
import com.stambia.jdbc.driver.xlsx.cell.Messages;
import com.stambia.jdbc.driver.xlsx.cell.NumberCell;
import com.stambia.jdbc.driver.xlsx.cell.SharedStringCell;
import com.stambia.jdbc.driver.xlsx.cell.UntypedCell;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import com.stambia.jdbc.jdbc.drive.xlsx.parser.FunctionReferenceUpdater;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CellFactory {
    public static Cell createCellFromXml(WorkBook workbook, XMLStreamReader reader, String refRow, Integer style, String t) {
        Cell cell = null;
        if (t == null) {
            cell = new UntypedCell(workbook, reader, refRow, style);
        } else if (t.equals(Constant.CELL_TYPE.SHARED_STRING.getCellTag())) {
            cell = new SharedStringCell(workbook, reader, refRow, style);
        } else if (t.equals(Constant.CELL_TYPE.BOOLEAN.getCellTag())) {
            cell = new BooleanCell(workbook, reader, refRow, style);
        } else if (t.equals(Constant.CELL_TYPE.DATE.getCellTag())) {
            cell = new DateCell(workbook, reader, refRow, style);
        } else if (t.equals(Constant.CELL_TYPE.ERROR.getCellTag())) {
            cell = new ErrorCell(workbook, reader, refRow, style);
        } else if (t.equals(Constant.CELL_TYPE.FORMULA.getCellTag())) {
            cell = new FormulaCell(workbook, reader, refRow, style);
        } else if (t.equals(Constant.CELL_TYPE.INLINE_STR.getCellTag())) {
            cell = new InlineStrCell(workbook, reader, refRow, style);
        } else if (t.equals(Constant.CELL_TYPE.NUMBER.getCellTag())) {
            cell = new NumberCell(workbook, reader, refRow, style);
        }
        return cell;
    }

    public static List<XMLEvent> createFormulaCell(XMLEventFactory eventFactory, Integer style, String refCell, Object value, List<FunctionReferenceUpdater.Bloc> list) throws XMLStreamException {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        StartElement newCell = eventFactory.createStartElement(new QName("c"), null, null);
        events.add(newCell);
        events.add(eventFactory.createAttribute(new QName("r"), refCell));
        if (style != null) {
            events.add(eventFactory.createAttribute(new QName("s"), String.valueOf(style)));
        }
        events.add(eventFactory.createStartElement(new QName("f"), null, null));
        Object formula = "";
        for (FunctionReferenceUpdater.Bloc bloc : list) {
            formula = (String)formula + bloc.toString(Integer.parseInt(refCell.replaceAll("\\D", "")));
        }
        events.add(eventFactory.createCharacters((String)formula));
        events.add(eventFactory.createEndElement(new QName("f"), null));
        events.add(eventFactory.createStartElement(new QName("v"), null, null));
        events.add(eventFactory.createCharacters("0"));
        events.add(eventFactory.createEndElement(new QName("v"), null));
        events.add(eventFactory.createEndElement(new QName("c"), null));
        return events;
    }

    public static List<XMLEvent> createCell(XMLEventFactory eventFactory, Integer dataType, Integer style, String refCell, Object value, boolean is1904DateSystem) throws XMLStreamException {
        ArrayList<XMLEvent> events;
        block30: {
            String cellType;
            String booleanValue;
            block32: {
                block31: {
                    events = new ArrayList<XMLEvent>();
                    StartElement newCell = eventFactory.createStartElement(new QName("c"), null, null);
                    events.add(newCell);
                    events.add(eventFactory.createAttribute(new QName("r"), refCell));
                    if (style != null) {
                        events.add(eventFactory.createAttribute(new QName("s"), String.valueOf(style)));
                    }
                    if (value == null) break block30;
                    booleanValue = "";
                    cellType = null;
                    if (dataType == null) break block31;
                    switch (dataType) {
                        case 16: {
                            cellType = "b";
                            if (value instanceof String) {
                                if (((String)value).equalsIgnoreCase("true")) {
                                    value = "1";
                                    booleanValue = "TRUE";
                                } else if (((String)value).equalsIgnoreCase("false")) {
                                    value = "0";
                                    booleanValue = "FALSE";
                                }
                            } else if (value instanceof Boolean) {
                                booleanValue = (Boolean)value != false ? "TRUE" : "FALSE";
                                value = (Boolean)value != false ? "1" : "0";
                            }
                            break block32;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            cellType = "s";
                            break block32;
                        }
                        case 91: {
                            value = XlsxUtils.getExcelDateFromSqlDate(value, is1904DateSystem);
                            break block32;
                        }
                        case 92: {
                            value = XlsxUtils.getExcelDateFromSqlDate(value, is1904DateSystem);
                            break block32;
                        }
                        case 93: {
                            value = XlsxUtils.getExcelDateFromSqlDate(value, is1904DateSystem);
                            break block32;
                        }
                        case -5: {
                            cellType = "n";
                            value = String.valueOf(value);
                            break block32;
                        }
                        case 3: {
                            cellType = "n";
                            if (value instanceof BigDecimal) {
                                value = ((BigDecimal)value).toPlainString();
                            }
                            break block32;
                        }
                        case 8: {
                            cellType = "n";
                            value = String.valueOf(value);
                            break block32;
                        }
                        case 6: {
                            cellType = "n";
                            value = String.valueOf(value);
                            break block32;
                        }
                        case 4: {
                            cellType = "n";
                            value = String.valueOf(value);
                            break block32;
                        }
                        case 2: {
                            cellType = "n";
                            if (value instanceof BigDecimal) {
                                value = ((BigDecimal)value).toPlainString();
                            }
                            break block32;
                        }
                        case 7: {
                            cellType = "n";
                            value = String.valueOf(value);
                            break block32;
                        }
                        case 5: {
                            cellType = "n";
                            value = String.valueOf(value);
                            break block32;
                        }
                        case -6: {
                            cellType = "n";
                            value = String.valueOf(value);
                            break block32;
                        }
                        default: {
                            throw new RuntimeException(Messages.getString("CellFactory.0"));
                        }
                    }
                }
                cellType = "inlineStr";
            }
            if (cellType != null) {
                events.add(eventFactory.createAttribute(new QName("t"), cellType));
            }
            if (cellType != null && cellType.equals("inlineStr")) {
                events.add(eventFactory.createStartElement(new QName("is"), null, null));
                events.add(eventFactory.createStartElement(new QName("t"), null, null));
                events.add(eventFactory.createCharacters(String.valueOf(value)));
                events.add(eventFactory.createEndElement(new QName("t"), null));
                events.add(eventFactory.createEndElement(new QName("is"), null));
            } else if (cellType != null && cellType.equals("b")) {
                events.add(eventFactory.createStartElement(new QName("f"), null, null));
                events.add(eventFactory.createCharacters(String.valueOf(booleanValue)));
                events.add(eventFactory.createEndElement(new QName("f"), null));
                events.add(eventFactory.createStartElement(new QName("v"), null, null));
                events.add(eventFactory.createCharacters(String.valueOf(value)));
                events.add(eventFactory.createEndElement(new QName("v"), null));
            } else {
                events.add(eventFactory.createStartElement(new QName("v"), null, null));
                events.add(eventFactory.createCharacters(String.valueOf(value)));
                events.add(eventFactory.createEndElement(new QName("v"), null));
            }
        }
        events.add(eventFactory.createEndElement(new QName("c"), null));
        return events;
    }
}

