/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.controler;

import com.stambia.jdbc.common.ColumnMetaData;
import com.stambia.jdbc.common.tools.ColumnNameGeneratorUtil;
import com.stambia.jdbc.driver.xls.internal.IWorkbookControler;
import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.cell.Cell;
import com.stambia.jdbc.driver.xlsx.controler.Messages;
import com.stambia.jdbc.driver.xlsx.part.DefinedName;
import com.stambia.jdbc.driver.xlsx.part.DefinedTable;
import com.stambia.jdbc.driver.xlsx.part.Package;
import com.stambia.jdbc.driver.xlsx.part.Row;
import com.stambia.jdbc.driver.xlsx.part.Sheet;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import com.stambia.jdbc.driver.xlsx.part.XlsFileHelper;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XLSXControler
implements IWorkbookControler {
    private Package xlsxPackage;
    private XlsFileHelper xlsFileHelper;
    private ColumnNameGeneratorUtil.Style nameGenerationStyle;
    private ColumnNameGeneratorUtil.Case forceColumnCase;
    private File catalogsFolder;
    private boolean lock;
    private boolean lockUntilConnectionIsClose;
    private String catalog;
    private Map<String, Map<String, DefinedName>> definedNames;
    private Integer columnSize;
    private IWorkbookControler.PATH_TYPE pathType;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private Map<String, Sheet> sheets = new HashMap<String, Sheet>();

    public XLSXControler(String catalog, File catalogsFolder, ColumnNameGeneratorUtil.Style nameGenerationStyle, ColumnNameGeneratorUtil.Case forceColumnCase, Integer columnSize, boolean lockUntilConnectionIsClose, Map<String, Map<String, DefinedName>> definedNames, IWorkbookControler.PATH_TYPE pathType) throws XlsException {
        this.lockUntilConnectionIsClose = lockUntilConnectionIsClose;
        this.catalog = catalog;
        this.catalogsFolder = catalogsFolder;
        this.definedNames = definedNames;
        this.forceColumnCase = forceColumnCase;
        this.columnSize = columnSize;
        this.pathType = pathType;
        if (this.catalogsFolder == null || !catalogsFolder.exists()) {
            throw new XlsException(Messages.getString("XLSXControler.0"));
        }
        this.nameGenerationStyle = nameGenerationStyle == null ? ColumnNameGeneratorUtil.Style.PRESERVE : nameGenerationStyle;
        if (lockUntilConnectionIsClose) {
            try {
                this.initFiles();
            }
            catch (Exception ex) {
                throw new XlsException(Messages.getString("XLSXControler.1"), ex);
            }
        }
    }

    @Override
    public IWorkbookControler.PATH_TYPE getPathType() {
        return this.pathType;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) throws XlsException {
        this.catalog = catalog;
        this.initFiles();
    }

    @Override
    public List<String> getCatalogs() {
        ArrayList<String> results = new ArrayList<String>();
        if (this.pathType != null) {
            switch (this.pathType) {
                case FILE: {
                    results.add(this.catalog.replace(".xlsx", ""));
                    break;
                }
                case FOLDER: 
                case LEGACY: {
                    for (File fileEntry : this.catalogsFolder.listFiles()) {
                        if (!fileEntry.getName().endsWith(".xlsx")) continue;
                        results.add(fileEntry.getName().replace(".xlsx", ""));
                    }
                    break;
                }
            }
        }
        return results;
    }

    @Override
    public void lock() {
        this.lock = true;
    }

    @Override
    public void unLock() {
        this.lock = false;
    }

    private WorkBook getWorkBook() throws XlsException {
        if (this.xlsxPackage == null) {
            try {
                this.initFiles();
            }
            catch (Exception ex) {
                throw new XlsException(Messages.getString("XLSXControler.2"), ex);
            }
        }
        return this.xlsxPackage.getWorkBook();
    }

    private void initFiles() throws XlsException {
        File xlsxFile = new File(this.catalog);
        if (!xlsxFile.exists()) {
            xlsxFile = new File(this.catalogsFolder, this.catalog);
        }
        if (!xlsxFile.exists() || !xlsxFile.isFile()) {
            throw new XlsException(String.format(Messages.getString("XLSXControler.3"), xlsxFile.getAbsolutePath()));
        }
        try {
            this.xlsFileHelper = new XlsFileHelper(xlsxFile);
            this.xlsxPackage = new Package(this.xlsFileHelper, this.catalog, this.definedNames);
        }
        catch (Exception ex) {
            throw new XlsException(String.format(Messages.getString("XLSXControler.4"), xlsxFile.getAbsolutePath()), ex);
        }
    }

    @Override
    public void changeCatalog(String newCatalog) throws XlsException {
        File xlsxFile;
        Object curCatalog;
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format(Messages.getString("XLSXControler.5"), newCatalog));
        }
        Object newCatalogWithExt = newCatalog;
        if (!newCatalog.endsWith(".xlsx")) {
            newCatalogWithExt = (String)newCatalogWithExt + ".xlsx";
        }
        if ((curCatalog = this.catalog) != null && !((String)curCatalog).endsWith(".xlsx")) {
            curCatalog = (String)curCatalog + ".xlsx";
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("curCatalog %s", curCatalog));
            this.logger.info(String.format("newCatalogWithExt %s", newCatalogWithExt));
            this.logger.info(String.format("catalogsFolder %s", this.catalogsFolder));
        }
        if (!((String)newCatalogWithExt).equals(curCatalog) || this.xlsFileHelper == null) {
            xlsxFile = new File((String)newCatalogWithExt);
            if (!xlsxFile.exists()) {
                xlsxFile = new File(this.catalogsFolder, (String)newCatalogWithExt);
            }
            try {
                this.xlsFileHelper = new XlsFileHelper(xlsxFile);
            }
            catch (Exception ex) {
                throw new XlsException(String.format(Messages.getString("XLSXControler.6"), xlsxFile), xlsxFile.getAbsolutePath(), ex);
            }
        }
        if (null == this.catalog) {
            this.catalog = newCatalogWithExt;
        }
        if (this.catalog.endsWith(".xlsx") && !((String)newCatalogWithExt).equals(this.catalog) || !this.catalog.equals(((String)newCatalogWithExt).substring(0, ((String)newCatalogWithExt).length() - 5))) {
            xlsxFile = new File((String)newCatalogWithExt);
            if (!xlsxFile.exists()) {
                xlsxFile = new File(this.catalogsFolder, (String)newCatalogWithExt);
            }
            if (!xlsxFile.exists() || !xlsxFile.isFile()) {
                throw new XlsException(String.format(Messages.getString("XLSXControler.7"), xlsxFile.getAbsolutePath()));
            }
            try {
                this.xlsxPackage = new Package(this.xlsFileHelper, (String)newCatalogWithExt, this.definedNames);
            }
            catch (Exception ex) {
                throw new XlsException(String.format(Messages.getString("XLSXControler.8"), xlsxFile), xlsxFile.getAbsolutePath(), ex);
            }
        }
    }

    @Override
    public void releaseConnectionIfNeeded() {
        if (this.lockUntilConnectionIsClose || !this.lock) {
            // empty if block
        }
    }

    @Override
    public void truncateSheet(String catalog, String tableName) throws XlsException {
        Sheet sheet = null;
        sheet = this.getSheetFromTableName(tableName, true);
        if (sheet != null) {
            Integer[] tableArea = this.getTableDelimiter(tableName, false);
            try {
                sheet.deleteRows(tableArea[1], tableArea[0], tableArea[2], tableArea[3]);
            }
            catch (Exception e) {
                throw new XlsException(e);
            }
        }
    }

    @Override
    public List<String> getSheetNames() throws XlsException {
        WorkBook workBook = this.getWorkBook();
        return workBook.getSheetNames();
    }

    @Override
    public Set<String> getDefinedNames() throws XlsException {
        return this.getWorkBook().getDefinedNames();
    }

    @Override
    public Set<String> getDefinedTableNames() throws XlsException {
        Map<String, DefinedTable> definedTables;
        Set<String> definedTableNames = Collections.emptySet();
        if (null != this.xlsxPackage && null != (definedTables = this.getWorkBook().getDefinedTables())) {
            definedTableNames = definedTables.keySet();
        }
        return definedTableNames;
    }

    @Override
    public List<String> getColumnNamesFromSheet(String sheetName, String delimiter) throws XlsException {
        ColumnNameGeneratorUtil nameGenerator = new ColumnNameGeneratorUtil(this.nameGenerationStyle, this.forceColumnCase);
        ArrayList<String> columnNames = new ArrayList();
        if (delimiter != null && !delimiter.isEmpty()) {
            columnNames = this.getColumnNamesFromDelimiter(sheetName, XlsxUtils.getRowStartFromTableDelimiter(delimiter), XlsxUtils.getColumnStartFromTableDelimiter(delimiter), XlsxUtils.getColumnEndFromTableDelimiter(delimiter));
        } else {
            Sheet sheet = this.getWorkBook().getSheet(sheetName);
            sheet.parseSheet(true, false, true);
            Row firstRow = sheet.getFirstRowWithData();
            if (firstRow != null) {
                int offSet;
                int nbCells = firstRow.getNbCells();
                for (int i = offSet = firstRow.getFirstCell().getColumnIndex() - 1; i < nbCells + offSet; ++i) {
                    String columnName;
                    Cell cell = firstRow.getCell(i + 1);
                    if (cell == null || (columnName = cell.getCellValue()) == null) continue;
                    columnNames.add(nameGenerator.addColumnName(columnName));
                }
            }
        }
        return columnNames;
    }

    @Override
    public List<String> getColumnNamesFromDefinedTable(String tableName) throws SQLException {
        DefinedTable definedTable;
        Map<String, DefinedTable> definedTables;
        List<String> columnNames = Collections.emptyList();
        if (null != this.xlsxPackage && null != (definedTables = this.getWorkBook().getDefinedTables()) && null != (definedTable = definedTables.get(tableName))) {
            columnNames = definedTable.getColumnNames();
        }
        return columnNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> getColumnNamesFromDelimiter(String sheetName, Integer rowStart, Integer columnStart, Integer columnEnd) throws XlsException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ColumnNameGeneratorUtil nameGenerator = new ColumnNameGeneratorUtil(this.nameGenerationStyle, this.forceColumnCase);
        Sheet sheet = this.getWorkBook().getSheet(sheetName);
        if (sheet == null) throw new XlsException(Messages.getString("XLSXControler.14") + sheetName + Messages.getString("XLSXControler.15"));
        sheet.parseSheet(true, false, false, rowStart, columnStart, columnEnd, true);
        Row row = sheet.getRow(rowStart);
        if (row == null) throw new XlsException(Messages.getString("XLSXControler.12") + rowStart + Messages.getString("XLSXControler.13"));
        for (int columnIdx = columnStart.intValue(); columnIdx <= columnEnd; ++columnIdx) {
            Cell cell = row.getCell(columnIdx);
            if (cell == null) throw new XlsException(Messages.getString("XLSXControler.9") + columnIdx + Messages.getString("XLSXControler.10") + rowStart + Messages.getString("XLSXControler.11"));
            String columnName = cell.getCellValue();
            if (columnName == null) continue;
            columnNames.add(nameGenerator.addColumnName(columnName));
        }
        return columnNames;
    }

    @Override
    public List<String> getColumnNamesFromDefinedName(String definedName, String delimiter) throws XlsException {
        DefinedName localDefinedName = this.getWorkBook().getDefinedName(definedName);
        if (delimiter != null && !delimiter.isEmpty()) {
            return this.getColumnNamesFromDelimiter(localDefinedName.getSheetName(), XlsxUtils.getRowStartFromTableDelimiter(delimiter), XlsxUtils.getColumnStartFromTableDelimiter(delimiter), XlsxUtils.getColumnEndFromTableDelimiter(delimiter));
        }
        return this.getColumnNamesFromDelimiter(localDefinedName.getSheetName(), localDefinedName.getRowStart(), localDefinedName.getColumnStart(), localDefinedName.getColumnEnd());
    }

    @Override
    public int insertRow(XMLInputFactory inFactory, XMLOutputFactory outFactory, String tableName, HashMap<Integer, Object> values, HashMap<Integer, Integer> sqlTypes) throws XlsException {
        Sheet sheet = null;
        int offset = 0;
        if (this.sheets.containsKey(tableName)) {
            sheet = this.sheets.get(tableName);
        } else {
            sheet = this.getSheetFromTableName(tableName, true);
            this.sheets.put(tableName, sheet);
        }
        if (sheet != null) {
            Integer[] tableArea = this.getTableDelimiter(tableName, true);
            try {
                offset = sheet.insertRow(inFactory, outFactory, values, sqlTypes, tableArea[1] + 1, tableArea[0], tableArea[2], tableArea[3]);
            }
            catch (Exception e) {
                throw new XlsException(e);
            }
            if (!tableName.endsWith("$")) {
                try {
                    this.getWorkBook().incrementeDefinedName(inFactory, outFactory, tableName, offset);
                }
                catch (Exception e) {
                    throw new XlsException(e);
                }
            }
        }
        return offset;
    }

    @Override
    public void insertRows(XMLInputFactory inFactory, XMLOutputFactory outFactory, String catalog, String tableName, LinkedList<HashMap<Integer, Object>> rowsValues, LinkedList<HashMap<Integer, Integer>> rowsDataTypes) throws XlsException {
        Sheet sheet = null;
        int offset = 0;
        sheet = this.getSheetFromTableName(tableName, true);
        if (sheet != null) {
            Integer[] tableArea = this.getTableDelimiter(tableName, false);
            try {
                offset = sheet.insertRows(inFactory, outFactory, rowsValues, rowsDataTypes, tableArea[1] + 1, tableArea[0], tableArea[2], tableArea[3]);
            }
            catch (Exception e) {
                throw new XlsException(e);
            }
            if (!tableName.endsWith("$") && offset > 0) {
                try {
                    WorkBook workBook = this.getWorkBook();
                    DefinedName definedName = workBook.getDefinedName(tableName);
                    DefinedTable definedTable = workBook.getDefinedTable(tableName);
                    if (null != definedName) {
                        workBook.incrementeDefinedName(inFactory, outFactory, tableName, offset);
                    } else if (null != definedTable) {
                        definedTable.increment(offset);
                    }
                }
                catch (Exception e) {
                    throw new XlsException(e);
                }
            }
        }
    }

    @Override
    public String evaluateCellValue(String sheetNameOrDefinedName, int rowNumber, int colNumber) throws XlsException {
        Sheet sheet = this.getSheetFromTableName(sheetNameOrDefinedName, false);
        if (sheet != null) {
            Cell cell = sheet.getCell(rowNumber, colNumber);
            if (cell == null) {
                return null;
            }
            return cell.getCellValue();
        }
        return null;
    }

    @Override
    public Map<Integer, String> evaluatePropertyFieldsValues(String sheetNameOrDefinedName, Set<Integer> columnsIndexFilter, int rowIndex, int propertyFieldIndex) throws XlsException {
        HashMap<Integer, String> propertyFieldsValues = new HashMap<Integer, String>();
        for (Map.Entry<String, Integer> propertyField : Sheet.PROPERTY_FIELDS.entrySet()) {
            String propertyFieldName = propertyField.getKey();
            if (null != propertyFieldName && columnsIndexFilter.contains(propertyFieldIndex)) {
                String propertyFieldValue = null;
                switch (propertyFieldName) {
                    case "row_number": {
                        propertyFieldValue = String.valueOf(rowIndex);
                        break;
                    }
                    case "row_count": {
                        int rowCount = this.evaluateRowCount(sheetNameOrDefinedName);
                        propertyFieldValue = String.valueOf(rowCount);
                        break;
                    }
                }
                propertyFieldsValues.put(propertyFieldIndex, propertyFieldValue);
            }
            ++propertyFieldIndex;
        }
        return propertyFieldsValues;
    }

    @Override
    public int getPropertyFieldIndex(String sheetNameOrDefinedName) throws XlsException {
        WorkBook workBook = this.getWorkBook();
        String unformattedTableName = XlsxUtils.unformatTableName(sheetNameOrDefinedName);
        int propertyFieldIndex = -1;
        if (sheetNameOrDefinedName.endsWith("$")) {
            Sheet sheet = this.getSheetFromTableName(sheetNameOrDefinedName, false);
            if (sheet != null) {
                propertyFieldIndex = sheet.getFirstRow().getNbCells() + 1;
            }
        } else {
            DefinedName definedName = workBook.getDefinedName(unformattedTableName);
            DefinedTable definedTable = workBook.getDefinedTable(unformattedTableName);
            if (null != definedName) {
                propertyFieldIndex = definedName.getColumnEnd();
            } else if (null != definedTable) {
                propertyFieldIndex = definedTable.getColumnEnd();
            }
            ++propertyFieldIndex;
        }
        return propertyFieldIndex;
    }

    private int evaluateRowCount(String tableName) throws XlsException {
        int rowNumber = -1;
        WorkBook workBook = this.getWorkBook();
        String unformattedTableName = XlsxUtils.unformatTableName(tableName);
        if (tableName.endsWith("$")) {
            Sheet sheet = workBook.getSheet(unformattedTableName);
            rowNumber = sheet.getRowCount();
        } else {
            DefinedName definedName = workBook.getDefinedName(unformattedTableName);
            DefinedTable definedTable = workBook.getDefinedTable(unformattedTableName);
            Integer rawStart = null;
            Integer rawEnd = null;
            if (definedName != null) {
                rawStart = definedName.getRowStart();
                rawEnd = definedName.getRowEnd();
            } else if (definedTable != null) {
                rawStart = definedTable.getRowStart();
                rawEnd = definedTable.getRowEnd();
            }
            if (null != rawStart && null != rawEnd) {
                rowNumber = 1 + rawEnd - rawStart;
            }
        }
        return rowNumber;
    }

    public HashMap<String, Integer> getColumnsPosition(String sheetNameOrDefinedName) throws XlsException {
        String delimiter;
        ColumnNameGeneratorUtil util = new ColumnNameGeneratorUtil(this.nameGenerationStyle, this.forceColumnCase);
        HashMap<String, Integer> cellsIndex = new HashMap<String, Integer>();
        String string = delimiter = sheetNameOrDefinedName.matches(".*![a-zA-Z]+\\d+:[a-zA-Z]+\\d+") ? sheetNameOrDefinedName.substring(sheetNameOrDefinedName.replaceAll("![a-zA-Z]+\\d+:[a-zA-Z]+\\d+", "").length() + 1) : null;
        if (delimiter != null) {
            int colStart = XlsxUtils.getColumnStartFromTableDelimiter(delimiter);
            int colEnd = XlsxUtils.getColumnEndFromTableDelimiter(delimiter);
            List<String> colNames = this.getColumnNamesFromSheet(XlsxUtils.unformatTableName(XlsxUtils.removeTableDelimiter(sheetNameOrDefinedName)), delimiter);
            for (int i = 0; i <= colEnd - colStart; ++i) {
                cellsIndex.put(colNames.get(i), i + colStart);
            }
            return cellsIndex;
        }
        if (sheetNameOrDefinedName.endsWith("$")) {
            Row row;
            Sheet sheet = this.getSheetFromTableName(sheetNameOrDefinedName, true);
            if (sheet != null && (row = sheet.getFirstRowWithData()) != null) {
                for (Cell c : row.getCells()) {
                    if (c.getCellValue() == null) continue;
                    String name = util.addColumnName(c.getCellValue());
                    cellsIndex.put(name, c.getColumnIndex());
                }
            }
        } else {
            WorkBook workBook = this.getWorkBook();
            DefinedName definedName = workBook.getDefinedName(sheetNameOrDefinedName);
            DefinedTable definedTable = workBook.getDefinedTable(sheetNameOrDefinedName);
            if (null != definedName) {
                String sheetName = definedName.getSheetName();
                Sheet sheet = workBook.getSheet(sheetName);
                int rowStart = definedName.getRowStart();
                Row row = sheet.getRow(rowStart);
                int columnStart = definedName.getColumnStart();
                int columnEnd = definedName.getColumnEnd();
                for (int columnIndex = columnStart; columnIndex <= columnEnd; ++columnIndex) {
                    Cell cell = row.getCell(columnIndex);
                    String columnName = cell.getCellValue();
                    cellsIndex.put(columnName, columnIndex);
                }
            } else if (null != definedTable) {
                List<String> columnNames = definedTable.getColumnNames();
                int columnStart = definedTable.getColumnStart();
                int columnEnd = definedTable.getColumnEnd();
                for (int columnIndex = columnStart; columnIndex <= columnEnd; ++columnIndex) {
                    int columnNameIndex = columnIndex - columnStart;
                    String columnName = columnNames.get(columnNameIndex);
                    cellsIndex.put(columnName, columnIndex);
                }
            }
        }
        int index = (Integer)Collections.max(cellsIndex.values());
        for (String name : Sheet.PROPERTY_FIELDS_NAMES) {
            cellsIndex.put(name, ++index);
        }
        return cellsIndex;
    }

    private Sheet getSheetFromTableName(String tableName, boolean parseSheet) throws XlsException {
        WorkBook workBook = this.getWorkBook();
        tableName = XlsxUtils.removeTableDelimiter(tableName);
        String unformattedTableName = XlsxUtils.unformatTableName(tableName);
        Sheet sheet = null;
        if (tableName.endsWith("$")) {
            sheet = workBook.getSheet(unformattedTableName);
            if (parseSheet) {
                sheet.parseSheet(true, true, true);
            }
        } else {
            DefinedTable definedTable = workBook.getDefinedTable(unformattedTableName);
            if (definedTable != null) {
                sheet = definedTable.getSheet();
                if (parseSheet) {
                    sheet.parseSheet(true, true, false, definedTable.getRowStart(), definedTable.getColumnStart(), definedTable.getColumnEnd(), true);
                }
            } else {
                DefinedName definedName = workBook.getDefinedName(unformattedTableName);
                if (definedName != null) {
                    sheet = workBook.getSheet(definedName.getSheetName());
                    if (parseSheet) {
                        sheet.parseSheet(true, true, false, definedName.getRowStart(), definedName.getColumnStart(), definedName.getColumnEnd(), true);
                    }
                }
            }
        }
        return sheet;
    }

    @Override
    public void saveWorkbook() throws XlsException {
        try {
            WorkBook workBook = this.getWorkBook();
            XlsFileHelper fileHelper = workBook.getPackage().getFileHelper();
            workBook.getSharedString().write(fileHelper);
            Collection<DefinedTable> definedTables = workBook.getDefinedTables().values();
            for (DefinedTable definedTable : definedTables) {
                definedTable.write(fileHelper);
            }
            fileHelper.saveZip();
        }
        catch (Exception ex) {
            throw new XlsException(Messages.getString("XLSXControler.16"), ex);
        }
        this.releaseConnectionIfNeeded();
    }

    @Override
    public String getCatalogsFolderAbsolutePath() {
        return this.catalogsFolder.getAbsolutePath();
    }

    @Override
    public boolean supportSaveMOreThanOnce() throws XlsException {
        return false;
    }

    @Override
    public void dispose() {
        if (this.xlsFileHelper != null) {
            this.xlsFileHelper.dispose();
        }
    }

    @Override
    public boolean createSheet(String unformatTableName, String[] columnNames) throws XlsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnNameGeneratorUtil.Style getColumnNamingStyle() {
        return this.nameGenerationStyle;
    }

    @Override
    public boolean is1904DateSystem() throws XlsException {
        return this.getWorkBook().is1904DateSystem();
    }

    @Override
    public IWorkbookControler.ColumnType getColumnType(String sheetName, String columnName) throws XlsException {
        return IWorkbookControler.ColumnType.DEFAULT;
    }

    @Override
    public void createTable(String tableName, List<ColumnMetaData> columnsMetaData) throws XlsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer[] getTableDelimiter(String tableName, boolean loadRow) throws XlsException {
        Sheet sheet = null;
        Integer[] area = new Integer[4];
        WorkBook workBook = this.getWorkBook();
        if (tableName.matches(".*![a-zA-Z]+\\d+:[a-zA-Z]+\\d+")) {
            String delimiter = tableName.matches(".*![a-zA-Z]+\\d+:[a-zA-Z]+\\d+") ? tableName.substring(tableName.replaceAll("![a-zA-Z]+\\d+:[a-zA-Z]+\\d+", "").length() + 1) : null;
            area[0] = XlsxUtils.getColumnStartFromTableDelimiter(delimiter);
            area[1] = XlsxUtils.getRowStartFromTableDelimiter(delimiter);
            area[2] = XlsxUtils.getColumnEndFromTableDelimiter(delimiter);
            area[3] = XlsxUtils.getRowEndFromTableDelimiter(delimiter);
            sheet = workBook.getSheet(XlsxUtils.unformatTableName(XlsxUtils.removeTableDelimiter(tableName)));
            sheet.parseSheet(false, true, loadRow);
            if (area[1].equals(area[3]) && sheet.getCachedLastRowIndex() != null) {
                area[3] = sheet.getCachedLastRowIndex();
            }
        }
        if (tableName.endsWith("$")) {
            sheet = workBook.getSheet(XlsxUtils.unformatTableName(tableName));
            sheet.parseSheet(false, true, loadRow);
            if (sheet.getFirstRowWithData() != null) {
                area[0] = sheet.getFirstRowWithData().getFirstCell().getColumnIndex();
                area[1] = sheet.getFirstRowWithData().getRowIndex();
                area[2] = sheet.getFirstRowWithData().getNbCells();
                area[3] = sheet.getCachedLastRowIndex();
            } else {
                area[2] = area[3] = Integer.valueOf(0);
                area[1] = area[3];
                area[0] = area[3];
            }
        } else {
            DefinedName definedName = workBook.getDefinedName(XlsxUtils.unformatTableName(tableName));
            DefinedTable definedTable = workBook.getDefinedTable(tableName);
            if (definedName != null) {
                sheet = workBook.getSheet(definedName.getSheetName());
                if (definedName.getRowStart() == definedName.getRowEnd()) {
                    sheet.parseSheet(false, true, true, definedName.getRowStart(), definedName.getColumnStart(), definedName.getColumnEnd(), loadRow);
                    area[3] = sheet.getCachedLastRowIndex();
                } else {
                    sheet.parseSheet(false, true, false, definedName.getRowStart(), definedName.getColumnStart(), definedName.getColumnEnd(), loadRow);
                    area[3] = definedName.getRowEnd();
                }
                area[0] = definedName.getColumnStart();
                area[1] = definedName.getRowStart();
                area[2] = definedName.getColumnEnd();
            } else if (definedTable != null) {
                sheet = definedTable.getSheet();
                if (definedTable.getRowStart().equals(definedTable.getRowEnd())) {
                    sheet.parseSheet(false, true, true, definedTable.getRowStart(), definedTable.getColumnStart(), definedTable.getColumnEnd(), loadRow);
                    area[3] = sheet.getCachedLastRowIndex();
                } else {
                    sheet.parseSheet(false, true, false, definedTable.getRowStart(), definedTable.getColumnStart(), definedTable.getColumnEnd(), loadRow);
                    area[3] = definedTable.getRowEnd();
                }
                area[0] = definedTable.getColumnStart();
                area[1] = definedTable.getRowStart();
                area[2] = definedTable.getColumnEnd();
            }
        }
        return area;
    }

    @Override
    public String getColumnSize() {
        return this.columnSize != null ? this.columnSize.toString() : null;
    }

    @Override
    public void createHeaderIfNeeded(XMLInputFactory inFactory, XMLOutputFactory outFactory, String catalog, String tableName, List<String> columnNames) throws XlsException {
        if (columnNames != null && !columnNames.isEmpty()) {
            ColumnNameGeneratorUtil nameGenerator = new ColumnNameGeneratorUtil(this.nameGenerationStyle, this.forceColumnCase);
            ArrayList<String> formatedColumnName = new ArrayList<String>();
            for (String column : columnNames) {
                formatedColumnName.add(nameGenerator.addColumnName(column));
            }
            Sheet sheet = this.getSheetFromTableName((String)tableName, false);
            if (sheet != null) {
                sheet.parseSheet(true, false, true);
                if (sheet.getFirstRowWithData() == null) {
                    String delimiter;
                    int rowStart = 0;
                    int colStart = 1;
                    String string = delimiter = ((String)tableName).matches(".*![a-zA-Z]+\\d+:[a-zA-Z]+\\d+") ? ((String)tableName).substring(((String)tableName).replaceAll("![a-zA-Z]+\\d+:[a-zA-Z]+\\d+", "").length() + 1) : null;
                    if (delimiter != null) {
                        rowStart = XlsxUtils.getRowStartFromTableDelimiter(delimiter) - 1;
                        colStart = XlsxUtils.getColumnStartFromTableDelimiter(delimiter);
                        tableName = ((String)tableName).replace("!" + delimiter, "");
                    }
                    tableName = (String)tableName + "!" + XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(rowStart, colStart) + ":" + XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(rowStart, colStart + columnNames.size());
                    HashMap<Integer, String> rowValue = new HashMap<Integer, String>();
                    HashMap<Integer, Integer> rowDataType = new HashMap<Integer, Integer>();
                    for (String columnName : formatedColumnName) {
                        rowValue.put(colStart, columnName);
                        rowDataType.put(colStart, 12);
                        ++colStart;
                    }
                    LinkedList<HashMap<Integer, Object>> rowsValues = new LinkedList<HashMap<Integer, Object>>();
                    rowsValues.add(rowValue);
                    LinkedList<HashMap<Integer, Integer>> rowsDataTypes = new LinkedList<HashMap<Integer, Integer>>();
                    rowsDataTypes.add(rowDataType);
                    try {
                        this.insertRows(inFactory, outFactory, catalog, (String)tableName, rowsValues, rowsDataTypes);
                    }
                    catch (XlsException e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                }
            }
        }
    }
}

