/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.part.Package;
import com.stambia.jdbc.driver.xlsx.part.Sheet;
import com.stambia.jdbc.driver.xlsx.part.XlsFileHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefinedTable {
    public static final String XL_FOLDER = "xl";
    public static final String TABLE_FOLDER = "xl/tables/";
    public static final String RELATION_FOLDER = "xl/worksheets/_rels/";
    public static final String XML_EXTENSION = ".xml";
    public static final String REL_EXTENSION = ".xml.rels";
    private static final String TABLE_MARKUP = "table";
    private static final String NAME_MARKUP = "name";
    private static final String DISPLAY_NAME_MARKUP = "displayName";
    private static final String TABLE_COLUMN_MARKUP = "tableColumn";
    private static final String TABLE_COLUMNS_MARKUP = "tableColumns";
    public static final String RELATION_MARKUP = "Relationship";
    public static final String TARGET_MARKUP = "Target";
    public static final String REF_MARKUP = "ref";
    public static final String ID_MARKUP = "id";
    public static final String STYLE_MARKUP = "tableStyleInfo";
    public static final String ROW_STRIPE_MARKUP = "showRowStripes";
    public static final String COLUMN_STRIPE_MARKUP = "showColumnStripes";
    private static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newInstance();
    private static final XMLEventFactory EVENT_FACTORY = XMLEventFactory.newInstance();
    private static final Namespace NAMESPACE = EVENT_FACTORY.createNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
    private static final QName TABLE_QNAME = new QName("table");
    private static final StartElement TABLE_START = EVENT_FACTORY.createStartElement(TABLE_QNAME, null, null);
    private static final EndElement TABLE_END = EVENT_FACTORY.createEndElement(TABLE_QNAME, null);
    private static final QName TABLE_COLUMNS_QNAME = new QName("tableColumns");
    private static final StartElement TABLE_COLUMNS_START = EVENT_FACTORY.createStartElement(TABLE_COLUMNS_QNAME, null, null);
    private static final EndElement TABLE_COLUMNS_END = EVENT_FACTORY.createEndElement(TABLE_COLUMNS_QNAME, null);
    private static final QName TABLE_COLUMN_QNAME = new QName("tableColumn");
    private static final StartElement TABLE_COLUMN_START = EVENT_FACTORY.createStartElement(TABLE_COLUMN_QNAME, null, null);
    private static final EndElement TABLE_COLUMN_END = EVENT_FACTORY.createEndElement(TABLE_COLUMN_QNAME, null);
    private static final QName STYLE_QNAME = new QName("tableStyleInfo");
    private static final StartElement STYLE_START = EVENT_FACTORY.createStartElement(STYLE_QNAME, null, null);
    private static final EndElement STYLE_END = EVENT_FACTORY.createEndElement(STYLE_QNAME, null);
    private String name;
    private String displayName;
    private String fileName;
    private List<String> columnNames = new ArrayList<String>();
    private Sheet sheet;
    private Integer rowStart;
    private Integer rowEnd;
    private Integer columnStart;
    private Integer columnEnd;
    private String id;
    private String style;
    private String rowStripe;
    private String columnStripe;
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinedTable(Package zipPackage, String fileName) throws Exception {
        this.fileName = fileName;
        if (null != zipPackage) {
            XMLStreamReader reader = null;
            InputStream stream = null;
            try {
                stream = zipPackage.getFileHelper().getInputStreamFromZipStream(fileName);
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.supportDTD", false);
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                reader = factory.createXMLStreamReader(stream);
                block43: while (reader.hasNext()) {
                    int event = reader.next();
                    if (1 != event) continue;
                    String markup = reader.getLocalName();
                    int attributesNumber = reader.getAttributeCount();
                    if (null == markup) continue;
                    block10 : switch (markup) {
                        case "table": {
                            String attributeName;
                            int index;
                            block44: for (index = 0; index < attributesNumber; ++index) {
                                attributeName = reader.getAttributeLocalName(index);
                                if (null == attributeName) continue;
                                switch (attributeName) {
                                    case "name": {
                                        this.name = reader.getAttributeValue(index);
                                        continue block44;
                                    }
                                    case "displayName": {
                                        this.displayName = reader.getAttributeValue(index);
                                        continue block44;
                                    }
                                    case "ref": {
                                        String ref = reader.getAttributeValue(index);
                                        this.columnStart = XlsxUtils.getColumnStartFromTableDelimiter(ref);
                                        this.columnEnd = XlsxUtils.getColumnEndFromTableDelimiter(ref);
                                        this.rowStart = XlsxUtils.getRowStartFromTableDelimiter(ref);
                                        this.rowEnd = XlsxUtils.getRowEndFromTableDelimiter(ref);
                                        continue block44;
                                    }
                                    case "id": {
                                        this.id = reader.getAttributeValue(index);
                                        continue block44;
                                    }
                                }
                            }
                            continue block43;
                        }
                        case "tableColumn": {
                            String attributeName;
                            int index;
                            for (index = 0; index < attributesNumber; ++index) {
                                attributeName = reader.getAttributeLocalName(index);
                                if (!NAME_MARKUP.equals(attributeName)) continue;
                                String columnName = reader.getAttributeValue(index);
                                this.columnNames.add(columnName);
                                break block10;
                            }
                            continue block43;
                        }
                        case "tableStyleInfo": {
                            String attributeName;
                            int index;
                            block46: for (index = 0; index < attributesNumber; ++index) {
                                attributeName = reader.getAttributeLocalName(index);
                                if (null == attributeName) continue;
                                switch (attributeName) {
                                    case "name": {
                                        this.style = reader.getAttributeValue(index);
                                        continue block46;
                                    }
                                    case "showRowStripes": {
                                        this.rowStripe = reader.getAttributeValue(index);
                                        continue block46;
                                    }
                                    case "showColumnStripes": {
                                        this.columnStripe = reader.getAttributeValue(index);
                                        continue block46;
                                    }
                                }
                            }
                            continue block43;
                        }
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(XlsFileHelper fileHelper) throws XlsException {
        try (XlsFileHelper.TemporaryOutputStream outStream = fileHelper.getEntryTemporaryOutputStream(this.fileName);){
            XMLEventWriter writer = XML_FACTORY.createXMLEventWriter(outStream);
            try {
                writer.add(TABLE_START);
                writer.add(NAMESPACE);
                writer.add(EVENT_FACTORY.createAttribute(ID_MARKUP, this.id));
                writer.add(EVENT_FACTORY.createAttribute(NAME_MARKUP, this.name));
                writer.add(EVENT_FACTORY.createAttribute(DISPLAY_NAME_MARKUP, this.displayName));
                String cellStart = XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(this.rowStart, this.columnStart);
                String cellEnd = XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(this.rowEnd, this.columnEnd);
                writer.add(EVENT_FACTORY.createAttribute(REF_MARKUP, cellStart + ":" + cellEnd));
                writer.add(TABLE_COLUMNS_START);
                for (int idMarkup = 0; idMarkup < this.columnNames.size(); ++idMarkup) {
                    writer.add(TABLE_COLUMN_START);
                    writer.add(EVENT_FACTORY.createAttribute(ID_MARKUP, String.valueOf(idMarkup + 1)));
                    writer.add(EVENT_FACTORY.createAttribute(NAME_MARKUP, this.columnNames.get(idMarkup)));
                    writer.add(TABLE_COLUMN_END);
                }
                writer.add(TABLE_COLUMNS_END);
                writer.add(STYLE_START);
                writer.add(EVENT_FACTORY.createAttribute(NAME_MARKUP, this.style));
                writer.add(EVENT_FACTORY.createAttribute(ROW_STRIPE_MARKUP, this.rowStripe));
                writer.add(EVENT_FACTORY.createAttribute(COLUMN_STRIPE_MARKUP, this.columnStripe));
                writer.add(STYLE_END);
                writer.add(TABLE_END);
            }
            finally {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            throw new XlsException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Integer getColumnEnd() {
        return this.columnEnd;
    }

    public Integer getColumnStart() {
        return this.columnStart;
    }

    public Integer getRowEnd() {
        return this.rowEnd;
    }

    public Integer getRowStart() {
        return this.rowStart;
    }

    public void increment(int offset) {
        this.rowEnd = this.rowEnd + offset;
    }
}

