/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPProcessingException;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.axiom.AxiomSoapFault;
import org.springframework.ws.soap.axiom.AxiomSoapFaultException;
import org.springframework.ws.soap.axiom.support.AxiomUtils;
import org.springframework.ws.soap.soap12.Soap12Fault;

class AxiomSoap12Fault
extends AxiomSoapFault
implements Soap12Fault {
    AxiomSoap12Fault(SOAPFault axiomFault, SOAPFactory axiomFactory) {
        super(axiomFault, axiomFactory);
    }

    @Override
    public QName getFaultCode() {
        return this.getAxiomFault().getCode().getValue().getTextAsQName();
    }

    @Override
    public Iterator<QName> getFaultSubcodes() {
        ArrayList<QName> subcodes = new ArrayList<QName>();
        for (SOAPFaultSubCode subcode = this.getAxiomFault().getCode().getSubCode(); subcode != null; subcode = subcode.getSubCode()) {
            subcodes.add(subcode.getValue().getTextAsQName());
        }
        return subcodes.iterator();
    }

    @Override
    public void addFaultSubcode(QName subcode) {
        SOAPFaultCode faultCode = this.getAxiomFault().getCode();
        SOAPFaultSubCode faultSubCode = null;
        if (faultCode.getSubCode() == null) {
            faultSubCode = this.getAxiomFactory().createSOAPFaultSubCode(faultCode);
        } else {
            faultSubCode = faultCode.getSubCode();
            while (faultSubCode.getSubCode() != null) {
                faultSubCode = faultSubCode.getSubCode();
            }
            faultSubCode = this.getAxiomFactory().createSOAPFaultSubCode(faultSubCode);
        }
        SOAPFaultValue faultValue = this.getAxiomFactory().createSOAPFaultValue(faultSubCode);
        this.setValueText(subcode, faultValue);
    }

    private void setValueText(QName code, SOAPFaultValue faultValue) {
        String prefix = code.getPrefix();
        if (StringUtils.hasLength((String)code.getNamespaceURI()) && StringUtils.hasLength((String)prefix)) {
            OMNamespace namespace = this.getAxiomFault().findNamespaceURI(prefix);
            if (namespace == null) {
                this.getAxiomFault().declareNamespace(code.getNamespaceURI(), prefix);
            }
        } else if (StringUtils.hasLength((String)code.getNamespaceURI())) {
            OMNamespace namespace = this.getAxiomFault().findNamespace(code.getNamespaceURI(), null);
            if (namespace == null) {
                throw new IllegalArgumentException("Could not resolve namespace of code [" + String.valueOf(code) + "]");
            }
            code = new QName(code.getNamespaceURI(), code.getLocalPart(), namespace.getPrefix());
        }
        faultValue.setText(prefix + ":" + code.getLocalPart());
    }

    @Override
    public String getFaultNode() {
        SOAPFaultNode faultNode = this.getAxiomFault().getNode();
        if (faultNode == null) {
            return null;
        }
        return faultNode.getFaultNodeValue();
    }

    @Override
    public void setFaultNode(String uri) {
        try {
            SOAPFaultNode faultNode = this.getAxiomFactory().createSOAPFaultNode(this.getAxiomFault());
            faultNode.setFaultNodeValue(uri);
            this.getAxiomFault().setNode(faultNode);
        }
        catch (SOAPProcessingException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }

    @Override
    public String getFaultStringOrReason() {
        return this.getFaultReasonText(Locale.getDefault());
    }

    @Override
    public String getFaultReasonText(Locale locale) {
        String language;
        SOAPFaultReason faultReason = this.getAxiomFault().getReason();
        SOAPFaultText faultText = faultReason.getSOAPFaultText(language = AxiomUtils.toLanguage(locale));
        return faultText != null ? faultText.getText() : null;
    }

    @Override
    public void setFaultReasonText(Locale locale, String text) {
        SOAPFaultReason faultReason = this.getAxiomFault().getReason();
        String language = AxiomUtils.toLanguage(locale);
        try {
            SOAPFaultText faultText = this.getAxiomFactory().createSOAPFaultText(faultReason);
            faultText.setLang(language);
            faultText.setText(text);
        }
        catch (SOAPProcessingException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }
}

