/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.springframework.util.StringUtils;
import org.springframework.xml.DocumentBuilderFactoryUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AxiomUtils {
    private static final OMOutputFormat DEFAULT_OUTPUT_FORMAT = new OMOutputFormat();

    public static OMNamespace toNamespace(QName qName, OMElement resolveElement) throws OMException {
        String prefix = qName.getPrefix();
        if (StringUtils.hasLength((String)qName.getNamespaceURI()) && StringUtils.hasLength((String)prefix)) {
            return resolveElement.declareNamespace(qName.getNamespaceURI(), prefix);
        }
        if (StringUtils.hasLength((String)qName.getNamespaceURI())) {
            return resolveElement.declareNamespace(qName.getNamespaceURI(), "");
        }
        throw new IllegalArgumentException("qName [" + String.valueOf(qName) + "] does not contain a namespace");
    }

    public static String toLanguage(Locale locale) {
        return locale.toString().replace('_', '-');
    }

    public static Locale toLocale(String language) {
        language = language.replace('-', '_');
        return StringUtils.parseLocaleString((String)language);
    }

    public static void removeContents(OMContainer container) {
        Iterator iterator = container.getChildren();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static Document toDocument(SOAPEnvelope envelope) {
        try {
            if (envelope instanceof Element) {
                return ((Element)envelope).getOwnerDocument();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            envelope.build();
            envelope.serialize((OutputStream)bos, DEFAULT_OUTPUT_FORMAT, true);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactoryUtils.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder().parse(bis);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error in converting SOAP Envelope to Document", ex);
        }
    }

    public static SOAPEnvelope toEnvelope(Document document) {
        return OMXMLBuilderFactory.createSOAPModelBuilder((Source)new DOMSource(document)).getSOAPEnvelope();
    }
}

