/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoap12Fault;
import org.springframework.ws.soap.saaj.SaajSoapBody;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;
import org.springframework.ws.soap.soap12.Soap12Body;
import org.springframework.ws.soap.soap12.Soap12Fault;

class SaajSoap12Body
extends SaajSoapBody
implements Soap12Body {
    SaajSoap12Body(SOAPBody body) {
        super(body);
    }

    @Override
    public Soap12Fault getFault() {
        SOAPFault fault = this.getSaajBody().getFault();
        return fault != null ? new SaajSoap12Fault(fault) : null;
    }

    @Override
    public Soap12Fault addClientOrSenderFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getClientOrSenderFaultName(), faultString, locale);
    }

    @Override
    public Soap12Fault addMustUnderstandFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getMustUnderstandFaultName(), faultString, locale);
    }

    @Override
    public Soap12Fault addServerOrReceiverFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getServerOrReceiverFaultName(), faultString, locale);
    }

    @Override
    public Soap12Fault addVersionMismatchFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getVersionMismatchFaultName(), faultString, locale);
    }

    @Override
    public Soap12Fault addDataEncodingUnknownFault(QName[] subcodes, String reason, Locale locale) {
        QName name = new QName(SoapVersion.SOAP_12.getEnvelopeNamespaceUri(), "DataEncodingUnknown");
        Soap12Fault fault = this.addFault(name, reason, locale);
        for (QName subcode : subcodes) {
            fault.addFaultSubcode(subcode);
        }
        return fault;
    }

    protected Soap12Fault addFault(QName faultCode, String faultString, Locale faultStringLocale) {
        Assert.notNull((Object)faultCode, (String)"No faultCode given");
        Assert.hasLength((String)faultString, (String)"faultString cannot be empty");
        Assert.hasLength((String)faultCode.getLocalPart(), (String)"faultCode's localPart cannot be empty");
        Assert.hasLength((String)faultCode.getNamespaceURI(), (String)"faultCode's namespaceUri cannot be empty");
        try {
            this.getSaajBody().removeContents();
            SOAPBody body = this.getSaajBody();
            SOAPFault result = faultStringLocale == null ? body.addFault(faultCode, faultString) : body.addFault(faultCode, faultString, faultStringLocale);
            SOAPFault saajFault = result;
            return new SaajSoap12Fault(saajFault);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }
}

