/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.adapter.method;

import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;

public class SoapMethodArgumentResolver
implements MethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class parameterType = parameter.getParameterType();
        return SoapMessage.class.equals((Object)parameterType) || SoapBody.class.equals((Object)parameterType) || SoapEnvelope.class.equals((Object)parameterType) || SoapHeader.class.equals((Object)parameterType);
    }

    @Override
    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) {
        Assert.isInstanceOf(SoapMessage.class, (Object)messageContext.getRequest());
        SoapMessage request = (SoapMessage)messageContext.getRequest();
        Class parameterType = parameter.getParameterType();
        if (SoapMessage.class.equals((Object)parameterType)) {
            return request;
        }
        if (SoapBody.class.equals((Object)parameterType)) {
            return request.getSoapBody();
        }
        if (SoapEnvelope.class.equals((Object)parameterType)) {
            return request.getEnvelope();
        }
        if (SoapHeader.class.equals((Object)parameterType)) {
            return request.getSoapHeader();
        }
        throw new UnsupportedOperationException();
    }
}

