/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.support;

import jakarta.activation.DataHandler;
import java.io.IOException;
import javax.xml.transform.Source;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.mime.MimeContainer;
import org.springframework.oxm.mime.MimeMarshaller;
import org.springframework.oxm.mime.MimeUnmarshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.MimeMessage;

public abstract class MarshallingUtils {
    private MarshallingUtils() {
    }

    public static Object unmarshal(Unmarshaller unmarshaller, WebServiceMessage message) throws IOException {
        Source payload = message.getPayloadSource();
        if (payload == null) {
            return null;
        }
        if (unmarshaller instanceof MimeUnmarshaller) {
            MimeUnmarshaller mimeUnmarshaller = (MimeUnmarshaller)unmarshaller;
            if (message instanceof MimeMessage) {
                MimeMessageContainer container = new MimeMessageContainer((MimeMessage)message);
                return mimeUnmarshaller.unmarshal(payload, (MimeContainer)container);
            }
        }
        return unmarshaller.unmarshal(payload);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void marshal(Marshaller marshaller, Object graph, WebServiceMessage message) throws IOException {
        if (marshaller instanceof MimeMarshaller) {
            MimeMarshaller mimeMarshaller = (MimeMarshaller)marshaller;
            if (message instanceof MimeMessage) {
                MimeMessageContainer container = new MimeMessageContainer((MimeMessage)message);
                mimeMarshaller.marshal(graph, message.getPayloadResult(), (MimeContainer)container);
                return;
            }
        }
        marshaller.marshal(graph, message.getPayloadResult());
    }

    private static final class MimeMessageContainer
    implements MimeContainer {
        private final MimeMessage mimeMessage;

        MimeMessageContainer(MimeMessage mimeMessage) {
            this.mimeMessage = mimeMessage;
        }

        public boolean isXopPackage() {
            return this.mimeMessage.isXopPackage();
        }

        public boolean convertToXopPackage() {
            return this.mimeMessage.convertToXopPackage();
        }

        public void addAttachment(String contentId, DataHandler dataHandler) {
            this.mimeMessage.addAttachment(contentId, dataHandler);
        }

        public DataHandler getAttachment(String contentId) {
            Attachment attachment = this.mimeMessage.getAttachment(contentId);
            return attachment != null ? attachment.getDataHandler() : null;
        }
    }
}

