/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponents5Connection;

public abstract class AbstractHttpComponents5MessageSender
extends AbstractHttpWebServiceMessageSender
implements DisposableBean {
    public abstract HttpClient getHttpClient();

    @Override
    public WebServiceConnection createConnection(URI uri) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.isAcceptGzipEncoding()) {
            httpPost.addHeader("Accept-Encoding", (Object)"gzip");
        }
        HttpHost httpHost = HttpHost.create((URI)uri);
        HttpContext httpContext = this.createContext(uri);
        return new HttpComponents5Connection(this.getHttpClient(), httpHost, httpPost, httpContext);
    }

    public void destroy() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient instanceof CloseableHttpClient) {
            CloseableHttpClient client = (CloseableHttpClient)httpClient;
            client.close();
        }
    }

    protected HttpContext createContext(URI uri) {
        return null;
    }
}

