/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.http.AbstractHttpSenderConnection;

public class ClientHttpRequestConnection
extends AbstractHttpSenderConnection {
    private final ClientHttpRequest request;
    private ClientHttpResponse response;

    public ClientHttpRequestConnection(ClientHttpRequest request) {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        this.request = request;
    }

    public ClientHttpRequest getClientHttpRequest() {
        return this.request;
    }

    public ClientHttpResponse getClientHttpResponse() {
        return this.response;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return this.request.getURI();
    }

    @Override
    public void addRequestHeader(String name, String value) throws IOException {
        this.request.getHeaders().add(name, value);
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        return this.request.getBody();
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.response = this.request.execute();
    }

    @Override
    protected long getResponseContentLength() throws IOException {
        return this.response.getHeaders().getContentLength();
    }

    @Override
    public Iterator<String> getResponseHeaderNames() throws IOException {
        return this.response.getHeaders().keySet().iterator();
    }

    @Override
    public Iterator<String> getResponseHeaders(String name) throws IOException {
        List headers = this.response.getHeaders().get((Object)name);
        return headers != null ? headers.iterator() : Collections.emptyIterator();
    }

    @Override
    protected int getResponseCode() throws IOException {
        return this.response.getStatusCode().value();
    }

    @Override
    protected String getResponseMessage() throws IOException {
        return this.response.getStatusText();
    }

    @Override
    protected InputStream getRawResponseInputStream() throws IOException {
        return this.response.getBody();
    }

    @Override
    protected void onClose() throws IOException {
        if (this.response != null) {
            this.response.close();
        }
    }
}

