/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.FactoryBean;

public class HttpComponents5ClientFactory
implements FactoryBean<CloseableHttpClient> {
    public static final AuthScope ANY = new AuthScope(null, null, -1, null, null);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(60L);
    private final List<HttpClientBuilderCustomizer> clientBuilderCustomizers = new ArrayList<HttpClientBuilderCustomizer>();
    private final List<PoolingHttpClientConnectionManagerBuilderCustomizer> connectionManagerBuilderCustomizers = new ArrayList<PoolingHttpClientConnectionManagerBuilderCustomizer>();
    private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private Duration readTimeout = DEFAULT_READ_TIMEOUT;
    private int maxTotalConnections = -1;
    private AuthScope authScope = ANY;
    private Credentials credentials = null;
    private Map<String, String> maxConnectionsPerHost = Map.of();
    private PoolingHttpClientConnectionManager connectionManager;

    public static HttpComponents5ClientFactory withDefaults() {
        HttpComponents5ClientFactory factory = new HttpComponents5ClientFactory();
        factory.addClientBuilderCustomizer(httpClientBuilder -> httpClientBuilder.addRequestInterceptorFirst((HttpRequestInterceptor)new RemoveSoapHeadersInterceptor()));
        return factory;
    }

    public void addClientBuilderCustomizer(HttpClientBuilderCustomizer clientBuilderCustomizer) {
        this.clientBuilderCustomizers.add(clientBuilderCustomizer);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public void setClientBuilderCustomizer(HttpClientBuilderCustomizer clientBuilderCustomizer) {
        this.addClientBuilderCustomizer(clientBuilderCustomizer);
    }

    public void addConnectionManagerBuilderCustomizer(PoolingHttpClientConnectionManagerBuilderCustomizer connectionManagerBuilderCustomizer) {
        this.connectionManagerBuilderCustomizers.add(connectionManagerBuilderCustomizer);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public void setConnectionManagerBuilderCustomizer(PoolingHttpClientConnectionManagerBuilderCustomizer connectionManagerBuilderCustomizer) {
        this.addConnectionManagerBuilderCustomizer(connectionManagerBuilderCustomizer);
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public void setConnectionTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.connectionTimeout = timeout;
    }

    public void setReadTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.readTimeout = timeout;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        if (maxTotalConnections <= 0) {
            throw new IllegalArgumentException("maxTotalConnections must be a positive value");
        }
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setMaxConnectionsPerHost(Map<String, String> maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    PoolingHttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public CloseableHttpClient build() {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        if (this.maxTotalConnections != -1) {
            connectionManagerBuilder.setMaxConnTotal(this.maxTotalConnections);
        }
        this.connectionManagerBuilderCustomizers.forEach(customizer -> customizer.customize(connectionManagerBuilder));
        this.connectionManager = connectionManagerBuilder.build();
        this.applyMaxConnectionsPerHost(this.connectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(Timeout.of((Duration)this.connectionTimeout)).setResponseTimeout(Timeout.of((Duration)this.readTimeout));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.credentials != null && this.authScope != null) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(this.authScope, this.credentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        this.clientBuilderCustomizers.forEach(customizer -> customizer.customize(httpClientBuilder));
        return httpClientBuilder.build();
    }

    void applyMaxConnectionsPerHost(PoolingHttpClientConnectionManager connectionManager) {
        for (Map.Entry<String, String> entry : this.maxConnectionsPerHost.entrySet()) {
            URI uri = URI.create(entry.getKey());
            HttpHost host = new HttpHost(uri.getScheme(), uri.getHost(), HttpComponents5ClientFactory.getPort(uri));
            HttpRoute route = uri.getScheme().equals("https") ? new HttpRoute(host, null, true) : new HttpRoute(host);
            int max = Integer.parseInt(entry.getValue());
            connectionManager.setMaxPerRoute(route, max);
        }
    }

    static int getPort(URI uri) {
        if (uri.getPort() == -1) {
            if ("https".equalsIgnoreCase(uri.getScheme())) {
                return 443;
            }
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                return 80;
            }
        }
        return uri.getPort();
    }

    public boolean isSingleton() {
        return true;
    }

    public CloseableHttpClient getObject() throws Exception {
        return this.build();
    }

    public Class<?> getObjectType() {
        return CloseableHttpClient.class;
    }

    @FunctionalInterface
    public static interface HttpClientBuilderCustomizer {
        public void customize(HttpClientBuilder var1);
    }

    @FunctionalInterface
    public static interface PoolingHttpClientConnectionManagerBuilderCustomizer {
        public void customize(PoolingHttpClientConnectionManagerBuilder var1);
    }

    public static class RemoveSoapHeadersInterceptor
    implements HttpRequestInterceptor {
        public void process(HttpRequest request, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
            if (request.containsHeader("Transfer-Encoding")) {
                request.removeHeaders("Transfer-Encoding");
            }
            if (request.containsHeader("Content-Length")) {
                request.removeHeaders("Content-Length");
            }
        }
    }
}

