/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.time.Duration;
import java.util.Map;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.transport.http.AbstractHttpComponents5MessageSender;
import org.springframework.ws.transport.http.HttpComponents5ClientFactory;

public class HttpComponents5MessageSender
extends AbstractHttpComponents5MessageSender
implements InitializingBean {
    private static final String HTTP_CLIENT_ALREADY_SET = "httpClient already set";
    private final HttpComponents5ClientFactory clientFactory = HttpComponents5ClientFactory.withDefaults();
    private HttpClient httpClient;

    public HttpComponents5MessageSender() {
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public HttpComponents5MessageSender(HttpClient httpClient) {
        this();
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        this.httpClient = httpClient;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setAuthScope(AuthScope authScope) {
        if (this.httpClient != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setAuthScope(authScope);
    }

    public void setCredentials(Credentials credentials) {
        if (this.httpClient != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setCredentials(credentials);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setConnectionTimeout(Duration timeout) {
        if (this.httpClient != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setConnectionTimeout(timeout);
    }

    public void setReadTimeout(Duration timeout) {
        if (this.httpClient != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setReadTimeout(timeout);
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        if (this.httpClient != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setMaxTotalConnections(maxTotalConnections);
    }

    public void setMaxConnectionsPerHost(Map<String, String> maxConnectionsPerHost) {
        if (this.httpClient != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setMaxConnectionsPerHost(maxConnectionsPerHost);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.httpClient == null) {
            this.httpClient = this.clientFactory.getObject();
        }
    }
}

