/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.http.AbstractHttpSenderConnection;

public class HttpComponentsConnection
extends AbstractHttpSenderConnection {
    private final HttpClient httpClient;
    private final HttpPost httpPost;
    private final HttpContext httpContext;
    private HttpResponse httpResponse;
    private ByteArrayOutputStream requestBuffer;

    protected HttpComponentsConnection(HttpClient httpClient, HttpPost httpPost, HttpContext httpContext) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        Assert.notNull((Object)httpPost, (String)"httpPost must not be null");
        this.httpClient = httpClient;
        this.httpPost = httpPost;
        this.httpContext = httpContext;
    }

    public HttpPost getHttpPost() {
        return this.httpPost;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public void onClose() throws IOException {
        if (this.httpResponse != null && this.httpResponse.getEntity() != null) {
            EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
        }
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return new URI(this.httpPost.getURI().toString());
    }

    @Override
    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        this.requestBuffer = new ByteArrayOutputStream();
    }

    @Override
    public void addRequestHeader(String name, String value) throws IOException {
        this.httpPost.addHeader(name, value);
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        return this.requestBuffer;
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.httpPost.setEntity((HttpEntity)new ByteArrayEntity(this.requestBuffer.toByteArray()));
        this.requestBuffer = null;
        this.httpResponse = this.httpContext != null ? this.httpClient.execute((HttpUriRequest)this.httpPost, this.httpContext) : this.httpClient.execute((HttpUriRequest)this.httpPost);
    }

    @Override
    protected int getResponseCode() throws IOException {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    protected String getResponseMessage() throws IOException {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    protected long getResponseContentLength() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity != null) {
            return entity.getContentLength();
        }
        return 0L;
    }

    @Override
    protected InputStream getRawResponseInputStream() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity != null) {
            return entity.getContent();
        }
        throw new IllegalStateException("Response has no enclosing response entity, cannot create input stream");
    }

    @Override
    public Iterator<String> getResponseHeaderNames() throws IOException {
        Header[] headers = this.httpResponse.getAllHeaders();
        String[] names = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            names[i] = headers[i].getName();
        }
        return Arrays.asList(names).iterator();
    }

    @Override
    public Iterator<String> getResponseHeaders(String name) throws IOException {
        Header[] headers = this.httpResponse.getHeaders(name);
        String[] values = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            values[i] = headers[i].getValue();
        }
        return Arrays.asList(values).iterator();
    }
}

