/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryProperties;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryResourceAttributes;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={OpenTelemetrySdk.class})
@EnableConfigurationProperties(value={OpenTelemetryProperties.class})
public class OpenTelemetryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    OpenTelemetrySdk openTelemetry(ObjectProvider<SdkTracerProvider> tracerProvider, ObjectProvider<ContextPropagators> propagators, ObjectProvider<SdkLoggerProvider> loggerProvider, ObjectProvider<SdkMeterProvider> meterProvider) {
        OpenTelemetrySdkBuilder builder = OpenTelemetrySdk.builder();
        tracerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setTracerProvider(arg_0));
        propagators.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setPropagators(arg_0));
        loggerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setLoggerProvider(arg_0));
        meterProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setMeterProvider(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    Resource openTelemetryResource(Environment environment, OpenTelemetryProperties properties) {
        Resource resource = Resource.getDefault();
        return resource.merge(this.toResource(environment, properties));
    }

    private Resource toResource(Environment environment, OpenTelemetryProperties properties) {
        ResourceBuilder builder = Resource.builder();
        new OpenTelemetryResourceAttributes(environment, properties.getResourceAttributes()).applyTo((arg_0, arg_1) -> ((ResourceBuilder)builder).put(arg_0, arg_1));
        return builder.build();
    }
}

