<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:wbi="java:com.semarchy.xdi.designer.generation.xsl.global.WorkbenchInvocation" 
xmlns:proc="http://www.example.org/proc" xmlns:common="http://exslt.org/common" xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions" xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables" xmlns:mds="java:com.semarchy.xdi.designer.generation.xsl.global.Strings" xmlns:mdg="java:com.semarchy.xdi.designer.generation.xsl.global.GraphUtil" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:saxon="http://saxon.sf.net/" exclude-result-prefixes="fn mdj saxon xsl common" xmlns:UUID="java.util.UUID" >
	<!--Cree un seul proc en allant chercher toute les references
Supprime les etapes et les liens qui sont désactivés par les generationCondition
Les altId sont récupérés
Il faut virer les conditions generation-->
	<xsl:variable name="mapDirectory" select="'/indy.build/map/'"/>
	<xsl:param name="mode">normal</xsl:param>
	<xsl:param name="workspace"/>
	<xsl:param name="metaDataLinks">REF:</xsl:param>
	<xsl:param name="parameters"/>
	<!-- the prefix to use in %{<prefix>VarName}% for eclipseVariable usage -->
	<xsl:param name="pEnvironmentVariablePrefix" />
	<xsl:variable name="vEnvironmentVariablePrefix" select="concat('%{', $pEnvironmentVariablePrefix)" />
	<xsl:variable name="environmentVariableRegex" select="concat('(%\{', $pEnvironmentVariablePrefix , ':([^}]+)\}%)')" />	

	<xsl:variable name="procName" select="substring-before(mdj:getFileInfo(base-uri(),'name'),'.proc')"/>
	<xsl:variable name="firstId" select="/proc:process/@id"/>
	<xsl:variable name="metaDataLinksList">
		<xsl:for-each select="mds:split(string($metaDataLinks),',')">
			<m>
				<xsl:for-each select="mds:split(string(.),':')">
					<xsl:attribute name="{if (position()=1) then 'name' else 'target'}" select="."/>
				</xsl:for-each>
			</m>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="parametersList">
		<xsl:for-each select="mds:split(string($parameters),',')">
			<p>
				<xsl:for-each select="mds:split(string(.),':')">
					<xsl:attribute name="{if (position()=1) then 'name' else 'value'}" select="."/>
				</xsl:for-each>
			</p>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="root" select="/"/>
	<xsl:variable name="currentID" select="*/@id"/>
	<xsl:output method="xml" encoding="UTF-8"/>
	<xsl:preserve-space elements="*"/>
	<xsl:template match="/">
		<xsl:variable name="root">
			<!--Relie les process entre eux pour produire un seul process
Cree de nouveaux id et met l'ancien dans oldId-->
			<xsl:apply-templates mode="addRef"/>
		</xsl:variable>
		<xsl:variable name="root1">
			<!--Determine les actions de debut
Positionne les link vers les nouveaux ids-->
			<xsl:apply-templates select="$root" mode="link"/>
		</xsl:variable>
		<xsl:variable name="root2">
			<!--Determine les actions de debut
Positionne les link vers les nouveaux ids-->
			<xsl:apply-templates select="$root1" mode="order"/>
		</xsl:variable>
		<xsl:if test="$mode!='debug'">
			<xsl:copy-of select="$root2"/>
		</xsl:if>
		<xsl:if test="$mode='debug'">
			<proc>
				<root>
					<xsl:copy-of select="$root"/>
				</root>
				<root2>
					<xsl:copy-of select="$root2"/>
				</root2>
			</proc>
		</xsl:if>
	</xsl:template>
	<!--#### ADDREF & Include###"-->
	<xsl:template match="code" mode="addRef">
		<xsl:element name="{name()}">
			<xsl:choose>
				<xsl:when test="contains(.,'%include{')">
					<xsl:call-template name="split">
						<xsl:with-param name="string" select="proc:replaceEnvironmentVariable(.)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="proc:replaceEnvironmentVariable(.)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template name="split">
		<xsl:param name="string"/>
		<xsl:choose>
			<xsl:when test="contains($string,'%include{')">
				<xsl:value-of select="substring-before($string,'%include{')"/>
				<xsl:value-of select="mdj:includeFile(substring-after(substring-before($string,'}%'),'%include{'),mdj:addFileScheme($workspace))"/>
				<xsl:call-template name="split">
					<xsl:with-param name="string">
						<xsl:value-of select="substring-after($string,'}%')"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="actionProcessRef" mode="addRef">
		<xsl:variable name="refName" select="@name"/>
		<xsl:variable name="file">
			<xsl:value-of select="substring-before(@targetName,'#')"/>
		</xsl:variable>
		<xsl:variable name="this" select="."/>
		<xsl:variable name="refId">
			<xsl:value-of select="substring-after(@targetName,'#')"/>
		</xsl:variable>
		<xsl:variable name="parameter">
			<xsl:copy-of select="parameter"/>
		</xsl:variable>
		<xsl:variable name="metaDataLink">
			<xsl:copy-of select="metaDataLink"/>
		</xsl:variable>
		<xsl:variable name="link">
			<xsl:copy-of select="link | bindLink"/>
		</xsl:variable>
		<xsl:variable name="attributes" select="@*[name()!='targetName' and name()!='processMap']"/>
		<xsl:variable name="type" select="proc:getType($refId)"/>
		<xsl:variable name="eltId" select="if ($type='map') then concat(proc:getEltId($refId),'-proc') else proc:getEltId($refId)"/>
		<xsl:variable name="refId" select="if ($type='map')  then concat(proc:getFileId($refId),'-proc') else proc:getFileId($refId)"/>
		<xsl:variable name="_uri" select="proc:findURI($refId)"/>
		<xsl:variable name="name" select="mdj:getFileInfo($_uri,'name')"/>
		<xsl:variable name="parent" select="mdj:getFileInfo($_uri,'parent')"/>
		<xsl:variable name="uri" select="replace(replace($_uri,' ','%20'),'\\','/')"/>
		<xsl:variable name="base-uri" select="base-uri()"/>
		<xsl:for-each select="document(mdj:addFileScheme($uri))//*[@id=$eltId]">
			<!--document(resolve-uri($file,base-uri(.)))//*[@id=$refId]-->
			<!--ca fonctionne pourtant les chemins sont en platform:/ !!!-->
			<subProcess>
				<xsl:apply-templates mode="addRef" select="@*[name()!='id' and name()!='isBeginAction']"/>
				<xsl:apply-templates mode="addRef" select="$attributes"/>
				<xsl:attribute name="processMap" select="exists(altId[@origin='mapping'])"/>
				<xsl:apply-templates mode="addRef" select="$link"/>
				<xsl:apply-templates mode="addRef" select="metaDataLink[not(@name=$metaDataLink/*/@name)] ">
					<!--on prend comme base d'URI l'URI du process distant-->
					<xsl:with-param name="base-uri" select="base-uri()"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="addRef" select="$metaDataLink/*">
					<!--on prend comme base d'URI l'URI du process courant-->
					<xsl:with-param name="base-uri" select="$base-uri"/>
				</xsl:apply-templates>
				<!--Copie des parametres qui ne sont pas redéfini-->
				<xsl:apply-templates mode="addRef" select="parameter[not(@name=$parameter/*/@name)] "/>
				<xsl:variable name="parameter2" select="parameter"/>
				<xsl:variable name="parameter3" select="../parameter"/>
				<!--Copie des parametres qui sont redéfini-->
				<xsl:for-each select="$parameter/*">
					<xsl:apply-templates mode="addRef" select=".">
						<xsl:with-param name="oldId" select="$parameter2[@name=current()/@name]/@id"/>
						<xsl:with-param name="oldIdold" select="$parameter3[@name=current()/@name]/@id"/>
						<xsl:with-param name="overrided" select="$parameter2[@name=current()/@name]"/>
					</xsl:apply-templates>
				</xsl:for-each>
				<xsl:apply-templates mode="addRef" select="* [name()!='parameter' and name()!='metaDataLink' and name()!='link' and name()!='bindLink']"/>
				<altId value="{@id}" origin="processRef"/>
				<xsl:copy-of select="$this/altId" copy-namespaces="no"/>
			</subProcess>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="proc:process" mode="addRef">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*" mode="addRef"/>
			<xsl:if test="@name=''">
				<xsl:attribute name="name" select="substring-before(mdj:getFileInfo(base-uri(),'name'),'.proc')"/>
			</xsl:if>
			<xsl:attribute name="toleratedError">false</xsl:attribute>
			<xsl:apply-templates select="node()" mode="addRef"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="addRef">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*|node()" mode="addRef"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="link/@targetId | bindLink/@targetId" mode="addRef">
		<xsl:attribute name="targetId" select="proc:getEltId(.)"/>
	</xsl:template>
	<xsl:template match="*">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	
	<xsl:template match="parameter/@value">
		<xsl:attribute name="value" select="proc:replaceEnvironmentVariable(.)"/>
	</xsl:template>
	
	<xsl:template match="xslVariable/@code" mode="addRef">
		<xsl:attribute name="code" select="proc:replaceEnvironmentVariable(.)"/>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="@*" mode="addRef">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="@id" mode="addRef">
		<xsl:attribute name="id" select="concat('_',UUID:randomUUID())"/>
		<xsl:attribute name="oldId" select="."/>
	</xsl:template>
	<xsl:template match="proc:process/parameter/@value" mode="addRef">
		<!--paramètres du process père overridé-->
		<xsl:variable select="../@name" name="name"/>
		<xsl:variable select="$parametersList/p[@name=current()/../@name]/@value" name="value"/>
		<xsl:variable select="$parametersList/p[@name=$name]" name="override"/>
		<xsl:attribute name="value"><xsl:choose><xsl:when test="$override"><xsl:value-of select="proc:replaceEnvironmentVariable($override/@value)"/></xsl:when><xsl:otherwise><xsl:value-of select="proc:replaceEnvironmentVariable(.)"/></xsl:otherwise></xsl:choose></xsl:attribute>
	</xsl:template>
	
		
	<xsl:function name="proc:replaceEnvironmentVariable">
		<xsl:param name="value"/>
		<xsl:choose>
			<xsl:when test="contains($value, $vEnvironmentVariablePrefix)">
				<xsl:message select="concat($value,'+++', $environmentVariableRegex, '->', replace($value,$environmentVariableRegex, '\${$2}'))"/>
				<xsl:value-of select="wbi:resolveEclipseVariable(replace($value,$environmentVariableRegex, '\${$2}'))" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$value" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	
	<xsl:template match="metaDataLink" mode="addRef">
		<xsl:variable name="target" select="if (@name=$metaDataLinksList/m/@name and not(ancestor::metaDataLink[@name=current()/@name])) then $metaDataLinksList/m[@name=current()/@name]/@target else @target"/>
		<xsl:if test="$target!=''">
			<xsl:variable name="refId" select="proc:getFileId($target)"/>
			<xsl:variable name="uri" select="proc:findURI($refId)"/>
			<!--<xsl:variable name="newTarget" select="concat(mdj:relativizeURI(base-uri($root),$uri),'#',substring-after($target,'#'))"/>-->
			<xsl:variable name="newTarget2" select="concat(proc:relativizeByFileId($currentID,proc:getFileId(@target)),'#',substring-after($target,'#'))"/>
			
			<metaDataLink target="{if ($uri!='') then mdj:formatUriPreservingFragment($newTarget2) else mdj:formatUriPreservingFragment($target)}" id="{concat('_',UUID:randomUUID())}">
				<xsl:apply-templates select="@*[not(name()='target' or name()='id')]"/>
			</metaDataLink>
		</xsl:if>
		<!--Va chercher d'autres metaDataLinks, il faudrait ajouter un ctrl sur le nom des métaDataLink cette fonction est désactivée pour le moment, il ne semble plus que ce soit utile-->
		<!--		<xsl:param name="base-uri"/>
		<xsl:variable name="tmp_file">
			<xsl:value-of select="substring-before(@target,'#')"/>
		</xsl:variable>
		<xsl:variable name="path">
			<xsl:choose>
				<xsl:when test="contains(@target,'#//')">
				
					<xsl:variable name="prefixe" select="substring-after($file,'.')"/>
					<xsl:value-of select="translate(
translate(
substring-after(@target,'#//@'),
'.','['),
'/@',concat(']/',$prefixe,':'))"/>
				</xsl:when>
				<xsl:otherwise>
			
					<xsl:value-of select="substring-after(@target,'#')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="file">
			<xsl:value-of select="resolve-uri($tmp_file,$base-uri)"/>
		</xsl:variable>
		<xsl:apply-templates mode="addRef" select="document(resolve-uri($uri,base-uri($root)))//*[@id=$path]/metaDataLink"/>
		-->
	</xsl:template>
	<xsl:template match="parameter[../name()!='proc:process']" mode="addRef">
		<xsl:param name="oldId"/>
		<xsl:param name="oldIdold"/>
		<xsl:param name="overrided" select="None"/>
		<xsl:variable name="parameter">
			<xsl:element name="{name()}">
				<xsl:apply-templates select="@*"/>
				<xsl:if test="$overrided/@metaInf!='' and not(@metaInf!='')">
					<xsl:attribute name="metaInf" select="$overrided/@metaInf"/>
				</xsl:if>
				<xsl:attribute name="oldId" select="if ($oldId!='') then $oldId else @id"/>
				<xsl:if test="$oldIdold!=''">
					<xsl:attribute name="oldoldId" select="$oldIdold"/>
				</xsl:if>
				<xsl:apply-templates select="node()"/>
			</xsl:element>
		</xsl:variable>
		<xsl:copy-of select="$parameter"/>
	</xsl:template>
	<!--#### LINK ###"-->
	<xsl:template match="@oldId | @oldoldId" mode="link"/>
	<xsl:template match="@*" mode="link">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="parameter/@value[.='__SRC__' or .='__TRG__' or .='__DFT__']" mode="link_depracated">
		<xsl:choose>
			<xsl:when test=".='__DFT__'">
				<xsl:attribute name="value"><xsl:choose><xsl:when test="ancestor::*/metaDataLink[@name='__TRG__']"><xsl:value-of select="ancestor::*/metaDataLink[@name='__TRG__'][1]/substring-before(@target,'.rdbms.md')"/></xsl:when><xsl:when test="ancestor::*/metaDataLink[@name='REF']"><xsl:value-of select="ancestor::*/metaDataLink[@name='REF'][1]/substring-before(@target,'.rdbms.md')"/></xsl:when></xsl:choose></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value" select="ancestor::*/metaDataLink[@name=current()][1]/substring-before(@target,'.rdbms.md')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="metaDataLink" mode="link.bak">
		<xsl:choose>
			<!--Test si le metaDatLink n'a pas été passé en paramètre auquel cas il sera remplacé, normalement seul le premier metadatalink de ce nom est remplacé-->
			<xsl:when test="@name=$metaDataLinksList/m/@name and not(ancestor::metaDataLink[@name=current()/@name])">
				<xsl:element name="{name()}">
					<xsl:apply-templates select="@*"/>
					<xsl:attribute name="target" select="$metaDataLinksList/m[@name=current()/@name]/@target"/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*" mode="link">
		<xsl:element name="{name()}">
			<xsl:apply-templates mode="link" select="@*"/>
			<xsl:apply-templates select="node()" mode="link"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="link | bindLink" mode="link">
		<xsl:if test="@targetId!=''">
			<xsl:element name="{name()}">
				<xsl:attribute name="id" select="concat('_',UUID:randomUUID())"/>
				<xsl:apply-templates mode="link" select="@*"/>
				<xsl:variable name="targetId" select="ancestor::*[not(name()='link') and not(name()='bindLink')][1]/..//*[@oldId=current()/@targetId][1]/@id"/>
				<xsl:attribute name="targetId" select="if ($targetId!='') then $targetId else @targetId"/>
				<xsl:value-of select="mdg:addRelation(../@id,proc:getEltId(if ($targetId!='') then $targetId else @targetId))"/>
				<xsl:apply-templates select="link" mode="link"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="actionCode | subProcess | proc:process" mode="link">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*" mode="link"/>
			<xsl:if test="not(@name) or @name=''">
				<xsl:attribute name="name" select="if (name()='proc:process') then $procName else @id"/>
			</xsl:if>
			<xsl:if test="not(..//link[@targetId=current()/@oldId or @targetId=current()/@id]) and not (..//bindLink[@targetId=current()/@id or @targetId=current()/@oldId])">
				<xsl:attribute name="isBeginAction">true</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="parameter | metaDataLink | link | bindLink | altId" mode="link"/>
			<altId value="{@oldId}" origin="compilation"/>
			<xsl:apply-templates select="code  | actionCode | subProcess | xslVariable" mode="link"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="parameter" mode="link">
		<xsl:if test="@value or @ref">
			<xsl:variable name="parameter"/>
			<xsl:copy-of select="$parameter"/>
		</xsl:if>
		<xsl:variable name="value">
			<xsl:choose>
				<xsl:when test="@ref!=''">
					<xsl:apply-templates select="@ref" mode="parameterRef"/>
				</xsl:when>
				<xsl:when test="@value!=''">
					<xsl:value-of select="@value"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$value!='' or contains(@metaInf,'&lt;xslVariableName>') or @input='true'  or @fault='true'  or @output='true'">
			<xsl:element name="{name()}">
				<xsl:apply-templates select="@*[not(name()='value')]" mode="link"/>
				<xsl:attribute name="value" select="$value"/>
				<xsl:apply-templates select="node()" mode="link"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@ref" mode="parameterRef">
		<xsl:variable select="../ancestor::*/parameter[concat('#',@oldId)=current() or concat('#',@oldoldId)=current()]" name="ref"/>
		<xsl:choose>
			<xsl:when test="$ref/@ref and $ref/@ref!=''">
				<xsl:apply-templates select="$ref/@ref" mode="parameterRef"/>
			</xsl:when>
			<xsl:when test="$ref/@value!=''">
				<xsl:value-of select="$ref/@value"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="parameter/@id" mode="link">
		<xsl:if test="@value or @ref">
			<xsl:variable name="parameter">
				<xsl:element name="{name()}">
					<xsl:apply-templates select="@*" mode="link"/>
					<xsl:apply-templates select="@ref" mode="parameterRef"/>
					<xsl:apply-templates select="node()" mode="link"/>
				</xsl:element>
			</xsl:variable>
			<xsl:copy-of select="$parameter"/>
		</xsl:if>
		<xsl:attribute name="id" select="concat('_',UUID:randomUUID())"/>
	</xsl:template>
	<!--#### ORDER ###"-->
	<xsl:template match="actionCode/@id | subProcess/@id" mode="order">
		<xsl:copy/>
		<xsl:attribute name="generationOrder" select="mdg:getOrder(.)"/>
	</xsl:template>
	<xsl:template match="*" mode="order">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*|node()" mode="order"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*" mode="order">
		<xsl:copy/>
	</xsl:template>
	<!--#### FUNCTION ###"-->
	<xsl:function name="proc:relativizeByFileId">
		<xsl:param name="id1"/>
		<xsl:param name="id2"/>
		<xsl:value-of select="mdj:relativizeURI(concat('file:/',proc:findRelativeURI($id1)),concat('file:/',proc:findRelativeURI($id2)))"/>
	</xsl:function>
	<xsl:function name="proc:findRelativeURI">
		<xsl:param name="id"/>
		<xsl:value-of select="mdj:findURIByFileId($id,false())"/>
	</xsl:function>
	<xsl:function name="proc:findURI">
		<xsl:param name="id"/>
		<xsl:value-of select="mdj:findURIByFileId($id)"/>
	</xsl:function>
	<xsl:function name="proc:getEltId">
		<xsl:param name="ref"/>
		<xsl:value-of select="if (contains($ref,'?')) then substring-before($ref,'?')  else $ref"/>
	</xsl:function>
	<xsl:function name="proc:getType">
		<xsl:param name="var"/>
		<xsl:variable select="substring-after($var,'type=')" name="tmp"/>
		<xsl:value-of select="if (contains($tmp,'$')) then substring-before($tmp,'$') else substring-before($tmp,'?') "/>
	</xsl:function>
	<xsl:function name="proc:getFileId">
		<xsl:param name="var"/>
		<xsl:variable select="substring-after($var,'fileId=')" name="tmp"/>
		<xsl:value-of select="if (contains($tmp,'$')) then substring-before($tmp,'$') else substring-before($tmp,'?') "/>
	</xsl:function>
</xsl:stylesheet>
