#!/bin/bash
#
# Copyright (c) Semarchy.  All rights reserved.
#
# PRODUCT Semarchy xDI Runtime
#   
#	This script allows to start a Runtime.
#
#	The Runtime will be started using the default configuration files and VM properties if no parameters are specified.
#	You can have a look at the initvariables.sh script to find these default properties if required.
#
#	Note:
#	To have an overview of the possible parameters, use the -usage parameter
#	
#	Examples:
#	startengine.sh -usage
#	startengine.sh -port 42200
#

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

PRGDIR=`dirname "$PRG"`

. "$PRGDIR"/initvariables.sh

# Determine whether the runtime is being started inside a container.    
if [ -z "$XDI_RUNNING_ENVIRONMENT"  ]; then
    "$RUNJAVA" $ADD_OPEN_OPTIONS $XDI_RUNTIME_OPTS -classpath "$XDI_RUNTIME_CLASSPATH" "${XDI_RUNTIME_VM_PROPERTIES[@]}" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.EngineStartI -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@" 
else
    exec "$RUNJAVA" $ADD_OPEN_OPTIONS $XDI_RUNTIME_OPTS -classpath "$XDI_RUNTIME_CLASSPATH" "${XDI_RUNTIME_VM_PROPERTIES[@]}" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.EngineStartI -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@"
fi