<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:tech="http://www.stambia.com/tech"
	xmlns:md="http://www.stambia.com/md"
	xmlns:xdghints="java:com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.XdgMdHintsHandler"
	exclude-result-prefixes="tech">
    <xsl:output indent="yes"/>
    <xsl:strip-space elements="*"/>
    <xsl:param name="hintsHandler"/>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="@hints">
    	<xsl:copy-of select="xdghints:storeHints($hintsHandler, string(.))"/>
    	
    </xsl:template>

    <xsl:template match="*" >
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*|node()"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="md" >
    	<xsl:apply-templates select="node()"/>
    </xsl:template>
    
     <xsl:template match="sourceSetToTargetDatastore|fieldLineage|dataStorePhysicalStorage|resourceOwner|sourceSetDatastoreFieldMapping" priority="1">
    	
    	 <xsl:element name="{name()}" >
    		<xsl:attribute name="source" select="@sourceRef"/>
    		<xsl:attribute name="target" select="@targetRef"/>
    	 </xsl:element>
    </xsl:template>
     
     <xsl:template match="model" priority="1">
        <xsl:element name="xdg:{name()}" namespace="http://www.semarchy.com/xdi/xdg">
            <xsl:namespace name="xdg" select="'http://www.semarchy.com/xdi/xdg'"/>
            <xsl:apply-templates select="@*|node()"/>
            <xsl:copy-of select="xdghints:hintsToElements($hintsHandler)"/>
           
            
        </xsl:element>
    </xsl:template>
	<xsl:template match="tech:tech | @defType" priority="1">
	</xsl:template>

</xsl:stylesheet>