<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:md="http://www.stambia.com/md" xmlns:mds="java:com.semarchy.xdi.designer.generation.xsl.global.Strings" xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions" xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables" xmlns:mdc="java:com.semarchy.xdi.designer.generation.xsl.global.XpathCache" xmlns:deliv="http://www.stambia.com/deliv" xmlns:ref="http://www.stambia.com/ref" xmlns:tech="http://www.stambia.com/tech" xmlns:map="http://www.stambia.com/map" xmlns:saxon="http://saxon.sf.net/" xmlns:rdbms="http://www.stambia.com/rdbms" xmlns:UUID="java.util.UUID" extension-element-prefixes="saxon" exclude-result-prefixes="xsl proc fn md mds mdj mdv mdc deliv ref tech map saxon rdbms">
	<!--Pour pas que l'utilisation de this plante à la compilation-->
	<xsl:variable name="mdRoot" select="/"/>
	<xsl:variable name="__mdConversion" select="document('../xml/conversion.xml') | document('../xml/userConversion.xml')"/>
	<xsl:key name="ref" match="md" use="id"/>
	<xsl:function name="md:xpathMapper">
		<xsl:sequence select="document('../xml/mapper.xml')"/>
	</xsl:function>
	<!--PhysicalName-->
	<xsl:function name="md:remotePath">
		<xsl:param name="context"/>
		<xsl:param name="localPath"/>
		<xsl:if test="$localPath!=''">
			<xsl:if test="exists($context)">
				<xsl:variable name="result">
					<xsl:variable select="mdj:xpath($context,'REMOTE_MASK')" name="remoteMask"/>
					<xsl:variable select="replace($remoteMask,'\[OBJECT\]',$localPath)" name="remoteMask2"/>
					<xsl:value-of select="$context/mdj:pattern($remoteMask2)"/>
				</xsl:variable>
				<xsl:value-of select="$result"/>
			</xsl:if>
		</xsl:if>
	</xsl:function>
	<xsl:function name="md:objectPath">
		<xsl:param name="context"/>
		<xsl:variable name="actual" select="md:physicalPath($context)"/>
		<xsl:value-of select="$actual"/>
	</xsl:function>
	<xsl:function name="md:objectPath">
		<xsl:param name="context"/>
		<xsl:param name="objectName"/>
		<xsl:variable name="actual" select="md:physicalPath($context)"/>
		<xsl:value-of select="if ($actual!='') then concat($actual,'.',$objectName) else $objectName"/>
	</xsl:function>
	<xsl:function name="md:objectPath">
		<xsl:param name="context"/>
		<xsl:param name="objectName"/>
		<xsl:param name="xPathCode"/>
		<xsl:variable name="actual" select="if ($xPathCode!='') then md:physicalPath($context,$xPathCode) else md:physicalPath($context)"/>
		<xsl:value-of select="if ($actual!='') then concat($actual,'.',$objectName) else $objectName"/>
	</xsl:function>
	<xsl:function name="md:objectPath">
		<xsl:param name="context"/>
		<xsl:param name="objectName"/>
		<xsl:param name="xPathCode"/>
		<xsl:param name="parentName"/>
		<xsl:variable name="newContext" select="$context/../*[@defType=$context/@defType and @name=$parentName][1]"/>
		<xsl:value-of select="md:objectPath($newContext,$objectName,$xPathCode)"/>
	</xsl:function>
	<xsl:function name="md:objectPathPN">
		<xsl:param name="context"/>
		<xsl:param name="objectName"/>
		<xsl:param name="xPathParentCode"/>
		<xsl:param name="parentPath"/>
		<xsl:variable name="current" select="$objectName"/>
		<xsl:variable name="sep" select="md:ifEmpty($context/tech:parentSeparator(),'.')"/>
		<xsl:variable name="parent">
			<xsl:if test="$parentPath">
				<xsl:value-of select="md:physicalName($parentPath,$xPathParentCode)"/>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="result">
			<xsl:if test="$parent!=''">
				<xsl:value-of select="$parent"/>
				<xsl:value-of select="$sep"/>
			</xsl:if>
			<!--A voir comment paramètrer le séparateur-->
			<xsl:value-of select="$current"/>
		</xsl:variable>
		<xsl:value-of select="$result"/>
	</xsl:function>
	<xsl:function name="md:physicalName">
		<xsl:param name="context"/>
		<xsl:value-of select="md:physicalName($context,'DEFAULT')"/>
	</xsl:function>
	<xsl:function name="md:physicalName">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:value-of select="md:physicalName($context,$xPathCode,'')"/>
	</xsl:function>
	<xsl:function name="md:physicalName">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:param name="xPathParentCode"/>
		<xsl:value-of select="md:physicalName($context,$xPathCode,$xPathParentCode,'')"/>
	</xsl:function>
	<xsl:function name="md:physicalName">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:param name="xPathParentCode"/>
		<xsl:param name="xPathParentRef"/>
		<xsl:value-of select="mdc:addCatchVariable('defaultParentKind')"/>
		<xsl:value-of select="mdc:addCatchVariable('defaultParentRef')"/>
		<xsl:variable name="current" select="mdj:xpath($context,$xPathCode)"/>
		<xsl:value-of select="md:instantEvaluation($current)"/>
		<xsl:variable name="xPathParentCode2">
			<xsl:value-of select="mdc:getCatchVariable('defaultParentKind')"/>
		</xsl:variable>
		<xsl:variable name="xPathParentCode" select="if ($xPathParentCode!='') then $xPathParentCode else if ($xPathParentCode2!='') then $xPathParentCode2 else $xPathCode"/>
		<xsl:variable name="xPathParentRef2" select="mdc:getCatchVariable('defaultParentRef')"/>
		<xsl:variable name="xPathParentRef" select="if ($xPathParentRef!='') then mdj:xpath($context,$xPathParentRef) else if ($xPathParentRef2) then $xPathParentRef2 else mdj:xpath($context,'PARENT_REF')"/>
		<xsl:variable name="result" select="md:objectPathPN($context,$current,$xPathParentCode,$xPathParentRef)"/>
		<xsl:value-of select="$result"/>
		<xsl:value-of select="mdc:resetCatchVariable()">
			<!--Important de mettre le remove à la fin car la valeur sera exploitée que lors de lalecture de la variable-->
		</xsl:value-of>
	</xsl:function>
	<xsl:function name="md:physicalPath">
		<xsl:param name="context"/>
		<xsl:value-of select="md:physicalName($context,'DEFAULT')"/>
	</xsl:function>
	<xsl:function name="md:physicalPath">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:value-of select="md:physicalName($context,$xPathCode,'')"/>
	</xsl:function>
	<xsl:function name="md:physicalPath">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:param name="xPathParentCode"/>
		<xsl:value-of select="md:physicalName($context,$xPathCode,$xPathParentCode,'')"/>
	</xsl:function>
	<xsl:function name="md:physicalPath">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:param name="xPathParentCode"/>
		<xsl:param name="xPathParentRef"/>
		<xsl:value-of select="md:physicalName($context,$xPathCode,$xPathParentCode,$xPathParentRef)"/>
	</xsl:function>
	<!--Liste-->
	<xsl:function name="md:sortedList">
		<xsl:param name="context"/>
		<xsl:sequence select="md:sortedList($context,'ascending')"/>
	</xsl:function>
	<xsl:function name="md:sortedList">
		<xsl:param name="context"/>
		<xsl:param name="order"/>
		<xsl:choose>
			<xsl:when test="$order='descending'">
				<xsl:for-each select="$context">
					<xsl:sort data-type="number" order="descending" select="tokenize(.,' ')[1]"/>
					<xsl:sequence select="substring-after(.,' ')"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="$context">
					<xsl:sort data-type="number" select="tokenize(.,' ')[1]"/>
					<xsl:sequence select="substring-after(.,' ')"/>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="md:list">
		<xsl:param name="context"/>
		<xsl:value-of select="md:list($context,'','','')"/>
	</xsl:function>
	<xsl:function name="md:list">
		<xsl:param name="context"/>
		<xsl:param name="separator"/>
		<xsl:value-of select="md:list($context,$separator,'')"/>
	</xsl:function>
	<xsl:function name="md:list">
		<xsl:param name="context"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:value-of select="md:list($context,$separator,$start,'')"/>
	</xsl:function>
	<xsl:function name="md:list">
		<xsl:param name="context"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:value-of select="md:list($context,$separator,$start,$end,'')"/>
	</xsl:function>
	<xsl:function name="md:list">
		<xsl:param name="context"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:param name="replacment"/>
		<xsl:value-of select="md:list($context,$separator,$start,$end,$replacment, true())"/>
	</xsl:function>
	
	<xsl:function name="md:list">
		<xsl:param name="context"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:param name="replacment"/>
		<!-- boolean to specify if we want the '\n\t\r' be replaced by XML chars 
			see bug 3383 for explanations
		-->
		<xsl:param name="replaceCharSpe"/>
		<xsl:variable name="return">
			<xsl:for-each select="$context">
				<xsl:if test="position()=1">
					<xsl:value-of select="$start"/>
				</xsl:if>
				<xsl:value-of select="."/>
				<xsl:choose>
					<xsl:when test="last()>position()">
						<xsl:value-of select="$separator"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$end"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$replaceCharSpe=true()">
				<xsl:choose>
					<xsl:when test="$return!=''">
						<xsl:value-of select="md:charSpe(string($return))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="md:charSpe(string($replacment))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$return!=''">
						<xsl:value-of select="string($return)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="string($replacment)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
			
	</xsl:function>
	
	<xsl:function name="md:patternList">
		<xsl:param name="context"/>
		<xsl:param name="pattern"/>
		<xsl:value-of select="md:patternList($context,$pattern,'','','','','1=1')"/>
	</xsl:function>
	<xsl:function name="md:patternList">
		<xsl:param name="context"/>
		<xsl:param name="pattern"/>
		<xsl:param name="separator"/>
		<xsl:value-of select="md:patternList($context,$pattern,$separator,'','','','1=1')"/>
	</xsl:function>
	<xsl:function name="md:patternList">
		<xsl:param name="context"/>
		<xsl:param name="pattern"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:value-of select="md:patternList($context,$pattern,$separator,$start,'','','1=1')"/>
	</xsl:function>
	<xsl:function name="md:patternList">
		<xsl:param name="context"/>
		<xsl:param name="pattern"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:value-of select="md:patternList($context,$pattern,$separator,$start,$end,'','1=1')"/>
	</xsl:function>
	<xsl:function name="md:patternList">
		<xsl:param name="context"/>
		<xsl:param name="pattern"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:param name="replacment"/>
		<xsl:value-of select="md:patternList($context,$pattern,$separator,$start,$end,$replacment,'1=1')"/>
	</xsl:function>
	<xsl:function name="md:patternList">
		<xsl:param name="context"/>
		<xsl:param name="pattern"/>
		<xsl:param name="separator"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:param name="replacment"/>
		<xsl:param name="filter"/>
		<xsl:variable name="filter" select="if ($filter='') then '1=1' else $filter"/>
		<xsl:variable name="formatted">
			<xsl:for-each select="$context[mdj:evaluate(.,$filter)]">
				<xsl:sort select="@position" data-type="number"/>
				<elt>
					<xsl:value-of select="mdj:pattern(md:charSpe($pattern))"/>
				</elt>
			</xsl:for-each>
		</xsl:variable>
		<xsl:value-of select="md:list($formatted/elt,md:charSpe($separator),md:charSpe($start),md:charSpe($end),md:charSpe($replacment), false())"/>
	</xsl:function>
	<!-- see bug DI-1194 -->
	<xsl:function name="md:patternHierarchy">
		<xsl:param name="context"/>
		<xsl:param name="nextLevelXPathExpression"/>
		<xsl:param name="prefixPattern"/>
		<xsl:param name="suffixPattern"/>
		<xsl:param name="separatorPattern"/>
		<xsl:value-of select="md:patternHierarchy($context,$nextLevelXPathExpression,$prefixPattern,$suffixPattern,$separatorPattern,'descending')"/>
	</xsl:function>
	<xsl:function name="md:patternHierarchy">
		<xsl:param name="context"/>
		<xsl:param name="nextLevelXPathExpression"/>
		<xsl:param name="prefixPattern"/>
		<xsl:param name="suffixPattern"/>
		<xsl:param name="separatorPattern"/>
		<xsl:param name="type"/>
		<xsl:value-of select="md:patternHierarchy($context,$nextLevelXPathExpression,$prefixPattern,$suffixPattern,$separatorPattern,$type,1)"/>
	</xsl:function>
	<xsl:function name="md:patternHierarchy">
		<xsl:param name="context"/>
		<xsl:param name="nextLevelXPathExpression"/>
		<xsl:param name="prefixPattern"/>
		<xsl:param name="suffixPattern"/>
		<xsl:param name="separatorPattern"/>
		<xsl:param name="type"/>
		<xsl:param name="currentDepth"/>
		<xsl:variable name="formatted">
			<xsl:choose>
				<xsl:when test="$type='ascending-ids'">
					<xsl:variable name="nextDepth" select="number($currentDepth)+1" />
					<xsl:variable name="parent" select="$context/mdj:evaluate(.,$nextLevelXPathExpression)" />
					<xsl:variable name="parentNodesPattern" select="md:patternHierarchy($parent,$nextLevelXPathExpression,$prefixPattern,$suffixPattern,$separatorPattern,$type,$nextDepth)" />
					<xsl:for-each select="$context">
						<xsl:variable name="currentNode" select="." />
						<ids>
							<xsl:value-of select="concat(md:encloseIfNotEmpty($parentNodesPattern,'', ' '),$currentNode/@id)"/>
						</ids>
					</xsl:for-each> 
				</xsl:when>
				<xsl:when test="$type='ascending-root-ids'">
					<xsl:variable name="nextDepth" select="number($currentDepth)+1" />
					<xsl:variable name="parent" select="$context/mdj:evaluate(.,$nextLevelXPathExpression)" />
					<xsl:choose>
						<xsl:when test="exists($parent)">
							<xsl:variable name="parentNodesPattern" select="md:patternHierarchy($parent,$nextLevelXPathExpression,$prefixPattern,$suffixPattern,$separatorPattern,$type,$nextDepth)" />
								<ids>
									<xsl:value-of select="$parentNodesPattern"/>
								</ids>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="$context">
								<xsl:variable name="currentNode" select="." />
								<ids>
									<xsl:value-of select="$currentNode/@id"/>
								</ids>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="$type='ascending'">
					<xsl:variable name="rootNodes" select="$context/ancestor-or-self::*[last()]"/>
					<xsl:variable name="startIds" select="tokenize(md:patternHierarchy($context,$nextLevelXPathExpression,$prefixPattern,$suffixPattern,$separatorPattern,'ascending-root-ids',0), ' ')"/>
					<xsl:variable name="startNodes" select="$rootNodes/descendant-or-self::*[@id=$startIds]"/>
					<xsl:variable name="selectionIds" select="md:patternHierarchy($context,$nextLevelXPathExpression,$prefixPattern,$suffixPattern,$separatorPattern,'ascending-ids',0)"/>
					<xsl:variable name="formattedSelectionIds">
						<xsl:for-each select="tokenize($selectionIds, ' ')">
							<xsl:value-of select="concat('''',.,''' ')"/>
						</xsl:for-each>
					</xsl:variable>
					<elt>
					   <xsl:value-of select="md:patternHierarchy($startNodes,concat('*[count(index-of(tokenize(''',$selectionIds,''', '' ''), @id))>0]'),$prefixPattern,$suffixPattern,$separatorPattern,'descending',0)"/>
					</elt>
				</xsl:when>
				<xsl:otherwise>
				   <xsl:for-each select="$context">
				   <xsl:variable name="currentNode" select="." />
				   <xsl:variable name="currentPrefix" select="mdj:pattern(md:charSpe($prefixPattern))" />
				   <xsl:variable name="currentSuffix" select="mdj:pattern(md:charSpe($suffixPattern))" />
				   <xsl:variable name="currentSeparator" select="if(position()=last()) then '' else mdj:pattern(md:charSpe($separatorPattern))" />
				   <xsl:variable name="nextDepth" select="number($currentDepth)+1" />
				   <xsl:variable name="children" select="mdj:evaluate($currentNode,$nextLevelXPathExpression)" />
				   <xsl:variable name="childrenPattern" select="md:patternHierarchy($children,$nextLevelXPathExpression,$prefixPattern,$suffixPattern,$separatorPattern,$type,$nextDepth)" />
				   <elt>
					   <xsl:value-of select="concat($currentPrefix,$childrenPattern,$currentSuffix,$currentSeparator)"/>
				   </elt>
				   </xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$type='ascending-ids' or $type='ascending-root-ids'">
				<xsl:value-of select="md:list(distinct-values(tokenize(md:list($formatted/ids,' '), ' ')), ' ')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="md:list($formatted/elt,'')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<!-- see bug DI-1198 -->
	<xsl:function name="md:repeatString">
		<xsl:param name="repeatCount"/>
		<xsl:param name="stringToRepeat"/>
		<xsl:value-of select="md:repeatString($repeatCount,$stringToRepeat,'')"/>
	</xsl:function>
	<xsl:function name="md:repeatString">
		<xsl:param name="repeatCount"/>
		<xsl:param name="stringToRepeat"/>
		<xsl:param name="separator"/>
		<xsl:variable name="formatted" xmlns:xs="http://www.w3.org/2001/XMLSchema">
			<xsl:for-each select="1 to xs:integer($repeatCount)">
				<str>
					<xsl:value-of select="$stringToRepeat"/>
				</str>
			</xsl:for-each> 
		</xsl:variable>
		<xsl:value-of select="md:list($formatted/str,$separator)"/>
	</xsl:function>
	<!--DataType-->
	<xsl:function name="md:convertDataType">
		<!--source-->
		<!--target-->
		<!--TODO : Voir si possible de rendre cette fonction générique pour fichier xml java etc... peut être en passant par super-->
		<!--TODO
Recup techno code : RDBMS
Recup produc code : MYSQL
Recup dataTypeCode
Recherche si règle particulière, sinon-->
		<xsl:param name="source"/>
		<xsl:param name="target"/>
		<xsl:value-of select="md:convertDataType($source,$target,'create')"/>
	</xsl:function>
	<xsl:function name="md:convertDataType">
		<!--source-->
		<!--target-->
		<!--TODO : Voir si possible de rendre cette fonction générique pour fichier xml java etc... peut être en passant par super-->
		<!--TODO
Recup techno code : RDBMS
Recup produc code : MYSQL
Recup dataTypeCode
Recherche si règle particulière, sinon-->
		<xsl:param name="source"/>
		<xsl:param name="target"/>
		<xsl:param name="mode"/>
		<xsl:value-of select="md:convertDataType($source,$target,$mode,md:ifEmpty($source/tech:type(),$source/ref:defaultDataType()/@name))"/>
	</xsl:function>
	<xsl:function name="md:convertDataType">
		<!--source-->
		<!--target-->
		<!--TODO : Voir si possible de rendre cette fonction générique pour fichier xml java etc... peut être en passant par super-->
		<!--TODO
Recup techno code : RDBMS
Recup produc code : MYSQL
Recup dataTypeCode
Recherche si règle particulière, sinon-->
		<xsl:param name="source"/>
		<xsl:param name="target"/>
		<xsl:param name="mode">
			<!--name ou mask-->
		</xsl:param>
		<xsl:param name="dataType"/>
		<xsl:variable name="productTargetRef" select="$target/ref:product()"/>
		<xsl:variable name="productSourceRef" select="$source/ref:product()"/>
		<xsl:variable name="id" select="concat('DATA_TYPE:',$productSourceRef/@id,$productTargetRef/@id,$dataType)"/>
		<xsl:variable name="value" select="$target/mdc:getValue($id)"/>
		<xsl:choose>
			<xsl:when test="$value">
				<!--on ne fait rien -->
			</xsl:when>
			<xsl:when test="$productSourceRef/@id = $productTargetRef/@id">
				<xsl:variable name="dt" select="$source/ref:dataType($dataType)"/>
				<xsl:variable name="sourceDataTypeRef">
					<type source="{$dt/tech:superTypeName()}" id="{$dt/@id}" name="{$dt/@name}" creationMask="{$dt/tech:creationMask()}" writingMask="{$dt/tech:writingMask()}"/>
				</xsl:variable>
				<xsl:call-template name="md:instantEvaluation">
					<xsl:with-param name="context" select="$target/mdc:putValue($id,$sourceDataTypeRef/type)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="targetTechCode" select="$target/md:ifEmpty(tech:datatypeTechCode(),tech:techCode())"/>
				<xsl:variable name="sourceTechCode" select="$source/md:ifEmpty(tech:datatypeTechCode(),tech:techCode())"/>
				<!--Il faut ajouter la recherc par le super type-->
				<xsl:variable name="dataType" select="upper-case($dataType)"/>
				<xsl:variable name="sourceDataTypeRef" select="$source/ref:dataType($dataType)"/>
				<xsl:variable name="sourceSuperCode" select="$sourceDataTypeRef/tech:superTypeName()"/>
				<xsl:variable name="superTypeRef1" select="$__mdConversion/*/type[@tech=$sourceTechCode and super=$sourceSuperCode and  (@product=$productSourceRef/md:ifEmpty(tech:datatypeProductCode(),tech:productCode()) or (not(@product!='') and to[@product!='']))]/to[@tech=$targetTechCode and ((not(@product!='') and ..[@product!='']) or @product=$productTargetRef/md:ifEmpty(tech:datatypeProductCode(),tech:productCode()))]"/>
				<xsl:variable name="superTypeRef2" select="$__mdConversion/*/type[@tech=$sourceTechCode and super=$sourceSuperCode and not(@product!='')]/to[@tech=$targetTechCode and not(@product!='')]"/>
				<xsl:variable name="superTypeRef" select="if ($superTypeRef1) then $superTypeRef1 else $superTypeRef2"/>
				<xsl:variable name="compatibleType" exclude-result-prefixes="tech ref mdc fn mds mdj mdv saxon xsl proc md rdbms deliv">
					<xsl:for-each select="$superTypeRef">
						<xsl:variable name="dt" select="$target/ref:product()/datatype[(@default='true' or tech:isDefault()) and tech:superTypeName()=current()/@super][1]"/>
						<xsl:if test="$dt">
							<type source="{.}" id="{$dt/@id}" name="{$dt/@name}" creationMask="{$dt/tech:creationMask()}" writingMask="{$dt/tech:writingMask()}"/>
						</xsl:if>
					</xsl:for-each>
					<!--On prend éventuellement le datatype qui n'aurait ne serait pas par défault mais qui aurait le même nom-->
					<xsl:variable name="dt" select="$target/ref:product()/datatype[not((@default='true' or tech:isDefault())) and @name=$dataType and tech:superTypeName()=$sourceSuperCode][1]"/>
					<xsl:if test="$dt">
						<type source="{$sourceSuperCode}" id="{$dt/@id}" name="{$dt/@name}" creationMask="{$dt/tech:creationMask()}" writingMask="{$dt/tech:writingMask()}"/>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="targetDataTypeRef" select="$compatibleType/type[1]"/>
				<xsl:call-template name="md:instantEvaluation">
					<xsl:with-param name="context" select="$target/mdc:putValue($id,$targetDataTypeRef)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:variable name="value" select="$target/mdc:getValue($id)"/>
		<xsl:choose>
			<xsl:when test="$mode='create'">
				<xsl:value-of select="$source/mdj:pattern($value/@creationMask,$target)"/>
			</xsl:when>
			<xsl:when test="$mode='write'">
				<xsl:value-of select="$source/mdj:pattern($value/@writingMask,$target)"/>
			</xsl:when>
			<xsl:when test="$mode='writeMask'">
				<xsl:value-of select="$value/@writingMask"/>
			</xsl:when>
			<xsl:when test="$mode='id'">
				<xsl:value-of select="$value/@id"/>
			</xsl:when>
			<xsl:when test="$mode='createMask'">
				<xsl:value-of select="$value/@createMask"/>
			</xsl:when>
			<xsl:when test="starts-with($mode,'dynamic:')">
				<xsl:variable name="id" select="$value/@id"/>
				<xsl:variable name="dt" select="$target/ref:product()/datatype[@id=$id]"/>
				<xsl:value-of select="$source/mdj:pattern($dt/saxon:evaluate(replace($mode,'dynamic:','tech:')),$target)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$value[1]/saxon:evaluate(concat('@',$mode))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="md:ifEmptyDataType">
		<xsl:param name="name"/>
		<xsl:param name="p1"/>
		<xsl:value-of select="$name"/>
		<xsl:if test="$p1!=''">
			<xsl:value-of select="concat('(',$p1,')')"/>
		</xsl:if>
	</xsl:function>
	<xsl:function name="md:ifEmptyDataType">
		<xsl:param name="name"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:value-of select="$name"/>
		<xsl:if test="$p1!='' and $p2!=''">
			<xsl:value-of select="concat('(',$p1,',',$p2,')')"/>
		</xsl:if>
	</xsl:function>
	<!--Special-->
	<xsl:function name="md:charSpe">
		<xsl:param name="string"/>
		<xsl:variable name="return" select="replace(replace(
replace($string,
'\\n','&#xA;'),
'\\t','&#x9;'),'\\r','&#xD;')"/>
		<xsl:value-of select="$return"/>
	</xsl:function>
	<xsl:template name="md:seqToTree">
		<xsl:param name="context" tunnel="yes"/>
		<xsl:param name="position"/>
		<xsl:variable name="_position" select="if (number($position)>0) then $position else 1"/>
		<xsl:variable name="current" select="$context/*[$_position]"/>
		<xsl:if test="$current">
			<xsl:element name="{$current/name()}">
				<xsl:copy-of select="$current/(@*|*)" copy-namespaces="no"/>
				<xsl:call-template name="md:seqToTree">
					<xsl:with-param name="position" select="$_position+1"/>
				</xsl:call-template>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:function name="md:getEltId">
		<xsl:param name="ref"/>
		<xsl:value-of select="if (contains($ref,'?')) then substring-before($ref,'?')  else $ref"/>
	</xsl:function>
	<xsl:function name="md:decryptPassword">
		<xsl:param name="encryptPassword"/>
		<xsl:value-of select="concat('%s(rhino){ __ctx__.decryptPassword(''',$encryptPassword,''');}s(rhino)%')"/>
	</xsl:function>
	<xsl:function name="md:password">
		<xsl:param name="encryptPassword"/>
		<xsl:value-of select="concat('%s(rhino){ __ctx__.password(''',$encryptPassword,''');}s(rhino)%')"/>
	</xsl:function>
	<xsl:function name="md:formatDate">
		<xsl:variable name="res">
			<xsl:text>%e(rhino){importPackage(java.text);
var now = new Date();
format = new SimpleDateFormat();
format.format(now);}e(rhino)%</xsl:text>
		</xsl:variable>
		<xsl:value-of select="$res/text()"/>
	</xsl:function>
	<xsl:function name="md:formatDate">
		<xsl:param name="format"/>
		<xsl:variable name="res">
			<xsl:text>%e(rhino){importPackage(java.text);
var now = new Date();
format = new SimpleDateFormat("</xsl:text><xsl:value-of select="$format"/><xsl:text>");
format.format(now);}e(rhino)%</xsl:text>
		</xsl:variable>
		<xsl:value-of select="$res/text()"/>
	</xsl:function>
	<xsl:function name="md:formatDate">
		<xsl:param name="format"/>
		<xsl:param name="offset"/>
		<xsl:variable name="res">
			<xsl:text>%e(rhino){importPackage(java.text);
var dte= new Date(java.lang.System.currentTimeMillis()+</xsl:text><xsl:value-of select="$offset"/><xsl:text>*1000*60*60*24);
format = new SimpleDateFormat("</xsl:text><xsl:value-of select="$format"/><xsl:text>");
format.format(dte);}e(rhino)%</xsl:text>
		</xsl:variable>
		<xsl:value-of select="$res/text()"/>
	</xsl:function>
	<!--Param-->
	<xsl:function name="md:paramValue">
		<xsl:param name="context"/>
		<xsl:param name="paramName"/>
		<xsl:param name="position"/>
		<xsl:value-of select="$context/ancestor-or-self::*[$position]/parameter[@name=$paramName]/@value"/>
	</xsl:function>
	<xsl:function name="md:paramValue">
		<xsl:param name="context"/>
		<xsl:param name="paramName"/>
		<xsl:variable select="($context/ancestor-or-self::*/parameter[@name=$paramName and @value!=''])" name="param"/>
		<xsl:choose>
			<xsl:when test="count($param)>0">
				<xsl:value-of select="$param[last()]/@value"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="''"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="md:getParamValue">
		<xsl:param name="context"/>
		<xsl:param name="paramName"/>
		<xsl:value-of select="$context/ancestor-or-self::*/parameter[@name=$paramName]/@value"/>
	</xsl:function>
	<!--Test-->
	<xsl:function name="md:translateToMdjXpath">
		<xsl:param name="expression"/>
		<xsl:value-of select="mds:replaceAll3($expression, '\[','mdj:xpath(.,''','[^\]]*','md:nullValue','\]',''')')"/>
	</xsl:function>
	<xsl:function name="md:xmlToText">
		<xsl:param name="context"/>
		<xsl:value-of select="md:xmlToText($context,'','1=2',true())"/>
	</xsl:function>
	<xsl:function name="md:xmlToXsd">
		<xsl:param name="context"/>
		<xsl:apply-templates select="$context" mode="mdXmlToXsd"/>
	</xsl:function>
	<xsl:function name="md:xmlToText">
		<xsl:param name="context"/>
		<xsl:param name="id"/>
		<xsl:value-of select="md:xmlToText($context,$id,'1=2',true())"/>
	</xsl:function>
	<xsl:function name="md:xmlToText">
		<xsl:param name="context"/>
		<xsl:param name="id"/>
		<xsl:param name="filters"/>
		<xsl:value-of select="md:xmlToText($context,$id,$filters,true())"/>
	</xsl:function>
	<xsl:function name="md:xmlToText">
		<xsl:param name="context"/>
		<xsl:param name="id"/>
		<xsl:param name="filters"/>
		<xsl:param name="indent"/>
		<xsl:apply-templates select="$context" mode="xmlToText">
			<xsl:with-param select="if ($indent) then ' ' else ''" name="indent"/>
			<xsl:with-param name="id" select="$id"/>
			<xsl:with-param name="filters" select="$filters" tunnel="yes"/>
		</xsl:apply-templates>
	</xsl:function>
	<xsl:template match="text()" mode="xmlToText">
		<xsl:choose>
			<xsl:when test="contains(.,'%e(rhino){')">
				<xsl:value-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="md:xmlToTextReplaceReservedChar(.)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*" mode="xmlToText">
		<xsl:param name="indent" tunnel="yes"/>
		<xsl:param name="id"/>
		<xsl:param name="parentId"/>
		<xsl:param name="filters" tunnel="yes"/>
		<xsl:param name="useXmlForm" tunnel="yes" select="false()"/>
		<xsl:param name="allExtraFields" tunnel="yes" select="None"/>
		<xsl:param name="extraFields" tunnel="yes" select="None"/>
		<xsl:variable select="if ($id=@id) then '' else $id" name="id"/>
		<xsl:variable select="if($useXmlForm) then tech:xmlStaticPart() else ''" name="staticPart">
			<!--to prevent exception during md:xmlToText(md:mdToXsd(ref:xsd())) call during xml metadata input or output-->
		</xsl:variable>
		<xsl:variable name="children" select="if ($useXmlForm and tech:xmlChildrenEnable())then tech:xmlChildren() else *"/>
		<xsl:variable name="current" select="."/>
		<xsl:variable name="name" select="if($useXmlForm) then md:ifEmpty(tech:xmlForm(),name()) else name()"/>
		<xsl:variable name="childrenIds" select="if ($extraFields) then $extraFields[tech:parentId()=$current/@id]/tech:childId() else None"/>

		<xsl:variable name="addChildren" select="if ($childrenIds) then $allExtraFields[@id=$childrenIds] else None"/>

		<xsl:variable name="children" select="$children "/>
		<xsl:variable name="result">
			<xsl:choose>
				<xsl:when test="$indent!=''">
					<xsl:text>
</xsl:text>
					<xsl:value-of select="$indent"/>
					<xsl:value-of select="concat('&lt;',$name)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('&lt;',$name)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates mode="xmlToText" select="@*">
				<xsl:with-param name="parentId" select=" $parentId "/>

			</xsl:apply-templates> 
			<xsl:if test="$useXmlForm">
				<xsl:if test="not(@type!='') and tech:xmlType()!=''  and tech:xmlType()!='json:object' and tech:xmlType()!='json:array' ">
					<!--When no @type xmlType() was never writed-->
					<xsl:value-of select="concat(' ','type','=&quot;',replace(tech:xmlType(),'&amp;','&amp;amp;'),'&quot;')"/>
				</xsl:if>
				<xsl:if test="not(@name!='') and tech:xmlName()!=''">
					<!--When no @name xmlName() was never writed-->
					<xsl:value-of select="concat(' ','name','=&quot;',replace(tech:xmlName(),'&amp;','&amp;amp;'),'&quot;')"/>
				</xsl:if>
			</xsl:if>
		
		
			<xsl:choose>
				<xsl:when test="exists($children|text()|$addChildren) or $staticPart!=''">
					<xsl:choose>
						<xsl:when test="$indent!=''">><xsl:value-of select="$indent"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'>'"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="$staticPart!=''">
						<xsl:value-of select="concat(' ' ,$staticPart,' ')"/>
					</xsl:if>
					<xsl:apply-templates mode="xmlToText" select="$addChildren">
						<xsl:with-param name="id" select="$id"/>
						<xsl:with-param name="parentId" select="@id"/>
						<xsl:with-param name="indent" select="if ($indent!='') then concat($indent,' ') else $indent"/>
					</xsl:apply-templates>
					<xsl:apply-templates mode="xmlToText" select="$children|text()">
						<xsl:with-param name="id" select="$id"/>
					
						<xsl:with-param name="indent" select="if ($indent!='') then concat($indent,' ') else $indent"/>
					</xsl:apply-templates>
					
					<xsl:choose>
						<xsl:when test="$indent!=''">
							<xsl:text>
</xsl:text>
							<xsl:value-of select="$indent"/>&lt;/<xsl:value-of select="$name"/>></xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('&lt;/',$name,'>')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$indent!=''">/> <xsl:value-of select="$indent"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'/>'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test=".[if ($id!='') then exists(.//*[@id=$id]) else true()]">
			<xsl:variable name="filterTmp" select="if ($filters!='') then $filters else 'false()'"/>
			<xsl:if test="not(saxon:evaluate($filterTmp))">
				<xsl:value-of select="$result"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@*" mode="xmlToText">
		<xsl:param name="filters" tunnel="yes"/>
		<xsl:param name="parentId" />
		<xsl:param name="indent" tunnel="yes"/>
		<xsl:param name="useXmlForm" tunnel="yes" select="false()"/>
		<xsl:variable name="filterTmp" select="if ($filters!='') then $filters else 'false()'"/>
		<xsl:variable name="value" select="if ($parentId!='' and name()='id') then concat($parentId,'_',.) else ."/>
		<xsl:if test="not(saxon:evaluate($filterTmp))">
			<xsl:choose>
				<xsl:when test="$useXmlForm and name()='type'">
					<xsl:value-of select="concat(' ',name(),'=&quot;',replace(md:ifEmpty(../tech:xmlType(),$value),'&amp;','&amp;amp;'),'&quot;')"/>
				</xsl:when>
				<xsl:when test="$useXmlForm and name()='name'">
					<xsl:value-of select="concat(' ',name(),'=&quot;',replace(md:ifEmpty(../tech:xmlName(),$value),'&amp;','&amp;amp;'),'&quot;')"/>
				</xsl:when>
				<xsl:when test="$useXmlForm and name()='defType'">
					<xsl:value-of select="concat(' ',name(),'=&quot;',replace(md:ifEmpty(../tech:xmlDefType(),$value),'&amp;','&amp;amp;'),'&quot;')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="contains($value,'%e(rhino){')">
							<xsl:value-of select="concat(' ',name(),'=&quot;',$value,'&quot;')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat(' ',name(),'=&quot;',md:xmlToTextReplaceReservedChar($value),'&quot;')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:function name="md:xmlToTextReplaceReservedChar">
		<xsl:param name="val"/>
		<xsl:value-of select="replace(replace(replace($val,'&amp;','&amp;amp;'),'&quot;','&amp;quot;'),'&lt;','&amp;lt;')"/>
	</xsl:function>
	<xsl:variable name="useByInstantEvaluation" saxon:assignable="yes"/>
	<xsl:function name="md:instantEvaluation">
		<xsl:param name="context"/>
		<saxon:assign name="useByInstantEvaluation" select="$context"/>
		<!--attention surtout ne pas mettre extension-element-prefixes="saxon"-->
	</xsl:function>
	<xsl:function name="md:ifEmpty">
		<xsl:param name="value"/>
		<xsl:value-of select="if ($value!='') then $value else ''"/>
	</xsl:function>
	<xsl:function name="md:ifEmpty">
		<xsl:param name="value"/>
		<xsl:param name="replacement"/>
		<xsl:value-of select="if ($value!='') then $value else $replacement"/>
	</xsl:function>
	<xsl:function name="md:ifEmpty">
		<xsl:param name="value1"/>
		<xsl:param name="value2"/>
		<xsl:param name="value3"/>
		<xsl:value-of select="md:ifEmpty(md:ifEmpty($value1,$value2),$value3)"/>
	</xsl:function>
	<xsl:function name="md:ifEmpty">
		<xsl:param name="value1"/>
		<xsl:param name="value2"/>
		<xsl:param name="value3"/>
		<xsl:param name="value4"/>
		<xsl:value-of select="md:ifEmpty(md:ifEmpty(md:ifEmpty($value1,$value2),$value3),$value4)"/>
	</xsl:function>
	<xsl:function name="md:ifEmpty">
		<xsl:param name="value1"/>
		<xsl:param name="value2"/>
		<xsl:param name="value3"/>
		<xsl:param name="value4"/>
		<xsl:param name="value5"/>
		<xsl:value-of select="md:ifEmpty(md:ifEmpty(md:ifEmpty(md:ifEmpty($value1,$value2),$value3),$value4),$value5)"/>
	</xsl:function>
	<xsl:function name="md:encloseIfNotEmpty">
		<xsl:param name="value"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:if test="$value!=''">
			<xsl:value-of select="concat($start,$value,$end)"/>
		</xsl:if>
	</xsl:function>
	<xsl:function name="md:encloseIfNotEmpty">
		<xsl:param name="value"/>
		<xsl:param name="start"/>
		<xsl:param name="end"/>
		<xsl:param name="replacement"/>
		<xsl:if test="$value!=''">
			<xsl:value-of select="concat($start,$value,$end)"/>
		</xsl:if>
		<xsl:if test="not($value!='')">
			<xsl:value-of select="$replacement"/>
		</xsl:if>
	</xsl:function>
	<xsl:template name="md:instantEvaluation">
		<xsl:param name="context"/>
		<saxon:assign name="useByInstantEvaluation" select="$context"/>
	</xsl:template>
	<xsl:function name="md:mdToXsd">
		<xsl:param name="context"/>
		<xsl:apply-templates select="$context" mode="mdXmlToXsd"/>
	</xsl:function>
	<xsl:function name="md:mdToJsonSchema">
		<xsl:param name="context"/>
		<xsl:apply-templates select="$context" mode="jsonMdXmlToJsonSchema"/>
	</xsl:function>
	<!-- return a string representation of a file metadata requested by the file driver
		its supposed to be called only on file level
	-->
	<xsl:function name="md:fileToDriverSchema">
		<xsl:param name="context"/>
		<xsl:param name="attributeFilter"/>
		<xsl:apply-templates select="$context" mode="fileMdXmlToFileSchema">
			<xsl:with-param name="isMain" select="true()"/>
			<xsl:with-param name="attributeFilterExpression" select="$attributeFilter" tunnel="yes"/>
		</xsl:apply-templates>
	</xsl:function>
	
	<!--old (To delete ?)-->
	<xsl:function name="md:superTypeToDataType">
		<xsl:param name="superType"/>
		<xsl:param name="targetRef"/>
		<!--choper les ids, puis ajouter dans le cache-->
		<xsl:variable name="compatibleType">
			<type name="{$superType/@name}"/>
			<xsl:for-each select="$superType/compatibleType">
				<type name="{.}"/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="targetDataTypeRef" select="$targetRef/ref:product()/datatype[@default='true'][@superType=$compatibleType/type/@name][1]"/>
		<xsl:value-of select="$targetDataTypeRef/@name"/>
	</xsl:function>
	<xsl:function name="md:creDT">
		<xsl:param name="context"/>
		<xsl:variable name="TYPE_MASK" select="mdj:xpath($context,'TYPE_MASK')"/>
		<xsl:variable name="SIZE" select="mdj:xpath($context,'SIZE')"/>
		<xsl:variable name="DECIMAL" select="mdj:xpath($context,'DECIMAL')"/>
		<xsl:value-of select="md:creDT($TYPE_MASK,$SIZE,$DECIMAL)"/>
	</xsl:function>
	<xsl:function name="md:creDT">
		<xsl:param name="DT_MASK"/>
		<xsl:param name="SIZE"/>
		<xsl:param name="DECIMAL"/>
		<xsl:if test="$DT_MASK">
			<xsl:choose>
				<xsl:when test="$SIZE and $DECIMAL">
					<xsl:value-of select="replace(replace($DT_MASK,'%L',$SIZE),'%P',$DECIMAL)"/>
				</xsl:when>
				<xsl:when test="$SIZE">
					<xsl:value-of select="replace(replace($DT_MASK,'%L',$SIZE),'%P','0')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="contains($DT_MASK,'%L') or contains($DT_MASK,'%P') ">
							<xsl:value-of select="concat($DT_MASK,' ERROR Size or Decimal property isn''t defined')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$DT_MASK"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:function>
	<xsl:function name="md:dataTypeDDL">
		<xsl:param name="context"/>
		<xsl:param name="pDataTypeName"/>
		<xsl:param name="pDataTypeLength"/>
		<xsl:param name="pDataTypePrecision"/>
		<xsl:variable name="temp" select="mdj:xpath($context,'TARGET_REF')"/>
		<xsl:variable name="node" select="if (exists($temp)) then $temp else $context "/>
		<xsl:variable name="src" select="mdj:xpath($context,'SOURCE_REF')"/>
		<xsl:variable name="srcNode" select="if (exists($src)) then $src else $context "/>
		<xsl:choose>
			<xsl:when test="$pDataTypeName='DEST_VARCHAR'">
				<xsl:variable name="dt" select="$node/ancestor::*/datatype[@superType='VARCHAR'][1]/@mask"/>
				<xsl:value-of select="replace(replace($dt,'%L',$pDataTypeLength),'%P',$pDataTypePrecision)"/>
			</xsl:when>
			<xsl:when test="$pDataTypeName='DEST_NUMERIC'">
				<xsl:variable name="dt" select="$node/ancestor::*/datatype[@superType='NUMERIC'][1]/@mask"/>
				<xsl:value-of select="replace(replace($dt,'%L',$pDataTypeLength),'%P',$pDataTypePrecision)"/>
			</xsl:when>
			<xsl:when test="$pDataTypeName='DEST_DATE'">
				<xsl:variable name="dt" select="$node/ancestor::*/datatype[@superType='DATE'][1]/@mask"/>
				<xsl:value-of select="replace(replace($dt,'%L',$pDataTypeLength),'%P',$pDataTypePrecision)"/>
			</xsl:when>
			<xsl:when test="$pDataTypeName='SRC_VARCHAR'">
				<xsl:variable name="dt" select="$srcNode/ancestor::*/datatype[@superType='VARCHAR'][1]/@mask"/>
				<xsl:value-of select="replace(replace($dt,'%L',$pDataTypeLength),'%P',$pDataTypePrecision)"/>
			</xsl:when>
			<xsl:when test="$pDataTypeName='SRC_NUMERIC'">
				<xsl:variable name="dt" select="$srcNode/ancestor::*/datatype[@superType='NUMERIC'][1]/@mask"/>
				<xsl:value-of select="replace(replace($dt,'%L',$pDataTypeLength),'%P',$pDataTypePrecision)"/>
			</xsl:when>
			<xsl:when test="$pDataTypeName='SRC_DATE'">
				<xsl:variable name="dt" select="$srcNode/ancestor::*/datatype[@superType='DATE'][1]/@mask"/>
				<xsl:value-of select="replace(replace($dt,'%L',$pDataTypeLength),'%P',$pDataTypePrecision)"/>
			</xsl:when>
		</xsl:choose>
	</xsl:function>
	<xsl:variable name="empty"/>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$empty,$empty, $empty,$empty,$empty,$empty,$empty,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$empty, $empty,$empty,$empty,$empty,$empty,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $empty,$empty,$empty,$empty,$empty,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $p3,$empty,$empty,$empty,$empty,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:param name="p4"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $p3,$p4,$empty,$empty,$empty,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:param name="p4"/>
		<xsl:param name="p5"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $p3,$p4,$p5,$empty,$empty,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:param name="p4"/>
		<xsl:param name="p5"/>
		<xsl:param name="p6"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $p3,$p4,$p5,$p6,$empty,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:param name="p4"/>
		<xsl:param name="p5"/>
		<xsl:param name="p6"/>
		<xsl:param name="p7"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $p3,$p4,$p5,$p6,$p7,$empty,$empty)"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:param name="p4"/>
		<xsl:param name="p5"/>
		<xsl:param name="p6"/>
		<xsl:param name="p7"/>
		<xsl:param name="p8"/>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $p3,$p4,$p5,$p6,$p7,$p8,$empty)"/>
	</xsl:function>
	<!--<xsl:template name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="objectNameModifierMask" select="NONE"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:param name="p4"/>
		<xsl:param name="p5"/>
		<xsl:param name="p6"/>
		<xsl:param name="p7"/>
		<xsl:param name="p8"/>
		<xsl:param name="p9"/>
		<xsl:for-each select="$objectNameModifierMask/*">
			<xsl:value-of select="mdv:putMapValue('object.name.modifier.mask',@code,text())"/>
		</xsl:for-each>
		<xsl:value-of select="md:applyMask($source,$maskName,$target,$p1,$p2, $p3,$p4,$p5,$p6,$p7,$p8,$p9)"/>
		<xsl:for-each select="$objectNameModifierMask/*">
			<xsl:value-of select="mdv:putMapValue('object.name.modifier.mask',@code,'')"/>
		</xsl:for-each>
	</xsl:template>
	%xsl {
<xsl:variable name="create">
<xsl:choose> 
<xsl:when test="number(system-property('xpath.build.engine.version'))>=1" use-when="system-property('xpath.build.engine.version')!=''">
<xsl:call-template name="md:applyMask">
	<xsl:with-param name="source" select="$SOURCE"/>
	<xsl:with-param name="maskName" select="'TABLE_CREATION_DDL'"/>
	<xsl:with-param name="target" select="$TARGET"/>
	<xsl:with-param name="masks">
		<mask code="com.stambia.rdbms.datastore">PRE_[NAME]_SUF</mask>
	</xsl:with-param>
	<xsl:with-param name="p4" select="md:paramValue($this,'normalizeColumnNames')='true'"/>
	<xsl:with-param name="p5" select="$columnMapper"/>
</xsl:call-template>
</xsl:when>
<xsl:when test="string-length(system-property('xpath.build.engine.version'))=0">
%x{md:applyMask($SOURCE,'TABLE_CREATION_DDL', $TARGET,false(),false(),false(),md:paramValue($this,'normalizeColumnNames')='true',$columnMapper,
md:paramValue($this,'forceTableCase'),md:paramValue($this,'forceColumnCase'),md:paramValue($this,'forceConstraintCase'),md:paramValue($this,'forceConstraintCase')
)}x%
</xsl:when>
</xsl:choose> 
</xsl:variable>
%x{md:paramValue($this,'createTableSyntax')}x% %x{substring-after($create,'Create table ')}x%
}xsl%

	
	
	-->
	<xsl:function name="md:addObjectNameMask">
			<xsl:param name="defType"/>
		<xsl:param name="mask"/>
		<xsl:value-of select="mdv:putMapValue('object.name.modifier.mask',$defType,$mask)"/>
		<xsl:value-of select="mdc:resetCache()"/>

	</xsl:function>
	<xsl:function name="md:removeObjectNameMask">
			<xsl:param name="defType"/>
			<xsl:value-of select="mdv:putMapValue('object.name.modifier.mask',$defType,'')"/>
			<xsl:value-of select="mdc:resetCache()"/>

	</xsl:function>
	<xsl:function name="md:applyObjectNameMask">
		<xsl:param name="defType"/>
		<xsl:param name="name"/>
		<xsl:variable name="mask" select="mdv:getMapValue('object.name.modifier.mask',$defType)"/>
		<xsl:value-of select="if ($mask!='') then replace($mask,'\[NAME\]',$name) else $name"/>
	</xsl:function>
	<xsl:function name="md:applyMask">
		<xsl:param name="source"/>
		<xsl:param name="maskName"/>
		<xsl:param name="target"/>
		<xsl:param name="p1"/>
		<xsl:param name="p2"/>
		<xsl:param name="p3"/>
		<xsl:param name="p4"/>
		<xsl:param name="p5"/>
		<xsl:param name="p6"/>
		<xsl:param name="p7"/>
		<xsl:param name="p8"/>
		<xsl:param name="p9"/>
		<xsl:if test="$p1">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p1"/>
			</xsl:call-template>
			<!--Pour que la variable soit ajoutée au stackFrame-->
		</xsl:if>
		<xsl:if test="$p2">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p2"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$p3">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p3"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$p4">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p4"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$p5">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p5"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$p6">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p6"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$p7">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p7"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$p8">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p8"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$p9">
			<xsl:call-template name="md:instantEvaluation">
				<xsl:with-param name="context" select="$p9"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="mask" select="$target/ancestor-or-self::*[exists(mask[@name=$maskName])][1]/mask[@name=$maskName]/@value"/>
		<xsl:value-of select="$source/mdj:pattern($mask)"/>
	</xsl:function>
	<!--Map à mettre dans map.xsl ?-->
	<xsl:function name="map:sourceFields">
		<xsl:param name="context"/>
		<xsl:param name="sourceFields"/>
		<xsl:param name="pattern"/>
		<xsl:sequence select="map:sourceFields($context,$sourceFields,$pattern,'1=1')"/>
	</xsl:function>
	<xsl:function name="map:sourceFields">
		<xsl:param name="context"/>
		<xsl:param name="sourceFields"/>
		<xsl:param name="pattern"/>
		<xsl:param name="filter"/>
		<xsl:variable name="filter" select="if ($filter='') then '1=1' else $filter"/>
		<xsl:variable name="mapFields" select="$context/ref:fields()"/>
		<xsl:variable name="formatted">
			<xsl:for-each select="$sourceFields">
				<xsl:sort select="@position" data-type="number"/>
				<xsl:variable name="mapField" select="$mapFields[ref:sources()/@id=current()/@id]"/>
				<xsl:value-of select="mdv:addVariableToStackFrame('mapField',$mapField)"/>
				<xsl:if test="mdj:evaluate(.,$filter)">
					<elt>
						<xsl:value-of select="./mdj:pattern($pattern)"/>
					</elt>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:sequence select="$formatted/*"/>
	</xsl:function>
	<xsl:function name="md:schemaRef">
		<xsl:param name="context"/>
		<xsl:param name="name"/>
		<xsl:sequence select="$context/ref:container()/ref:schema($name)"/>
	</xsl:function>
	<xsl:function name="md:schemaRef">
		<xsl:param name="context"/>
		<xsl:param name="name"/>
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='WORK'">
				<xsl:sequence select="$context/ref:container()/ref:schema($name)/ref:work()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:sequence select="$context/ref:container()/ref:schema($name)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="md:schemaName">
		<xsl:param name="context"/>
		<xsl:param name="name"/>
		<xsl:value-of select="md:schemaRef($context,$name,'DEFAULT')/tech:schemaName()"/>
	</xsl:function>
	<xsl:function name="md:schemaName">
		<xsl:param name="context"/>
		<xsl:param name="name"/>
		<xsl:param name="type"/>
		<xsl:value-of select="md:schemaRef($context,$name,$type)/tech:schemaName()"/>
	</xsl:function>
	<xsl:function name="md:catalogName">
		<xsl:param name="context"/>
		<xsl:param name="name"/>
		<xsl:value-of select="md:schemaRef($context,$name,'DEFAULT')/tech:catalogName()"/>
	</xsl:function>
	<xsl:function name="md:catalogName">
		<xsl:param name="context"/>
		<xsl:param name="name"/>
		<xsl:param name="type"/>
		<xsl:value-of select="md:schemaRef($context,$name,$type)/tech:catalogName()"/>
	</xsl:function>
	<xsl:function name="md:resolveSetExpression">
		<xsl:param name="sets"/>
		<xsl:param name="expression"/>
		<xsl:choose>
			<xsl:when test="count($sets)=1 or not($expression!='')">
				<xsl:value-of select="$sets[1]"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:analyze-string select="$expression" regex="\[([^\]]*)\]">
					<xsl:matching-substring>
						<xsl:variable select="regex-group(1)" name="name"/>
						<xsl:variable name="set" select="$sets[@name=$name]"/>
						<xsl:choose>
							<xsl:when test="$set!=''">
								<xsl:value-of select="$set"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:matching-substring>
					<xsl:non-matching-substring>
						<xsl:value-of select="."/>
					</xsl:non-matching-substring>
				</xsl:analyze-string>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="md:setStagingPoint">
		<xsl:param name="id"/>
		<xsl:param name="query"/>
		<xsl:param name="type"/>
		<xsl:value-of select="mdv:putMapValue('registerStagingPoint',$id,$query)"/>
		<xsl:value-of select="mdv:putMapValue('registerStagingPointType',$id,$type)"/>
	</xsl:function>
	<xsl:function name="md:getStagingPoint">
		<xsl:param name="id"/>
		<xsl:value-of select="mdv:getMapValue('registerStagingPoint',$id)"/>
	</xsl:function>
	<xsl:function name="md:getStagingPointType">
		<xsl:param name="id"/>
		<xsl:value-of select="mdv:getMapValue('registerStagingPointType',$id)"/>
	</xsl:function>
	<xsl:function name="md:reduceUUID">
		<xsl:param name="uuid"/>
		<xsl:value-of select="mdj:reduceUUID($uuid)"/>
	</xsl:function>
	
	<!-- 
		from an item coming from an xdg harvest md
		generate an attribute value containing metaDataHint values
	 -->
	<xsl:function name="md:xdgInjectHints">
		<xsl:param name="xdgRefMd"/>
		<xsl:param name="xdgNodeId"/>

		<xsl:variable name="metaDataHints">
			<xsl:for-each select="$xdgRefMd/tech:internalXdgHarvestingHintSourceRefs()" >
				 <xsl:apply-templates select="." mode="xdg">
					<xsl:with-param name="sourceId" select="$xdgNodeId/string()"/>
				 </xsl:apply-templates>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:variable name="hints">
			<xsl:for-each select="$metaDataHints/metaDataHint">
				<xsl:copy-of select="md:xmlToText(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$metaDataHints/modelObjectMetadataHint">
				<xsl:copy-of select="md:xmlToText(.)"/>
			</xsl:for-each>
		</xsl:variable>

		<xsl:value-of select="$hints"/>
		
	</xsl:function>
	
	<xsl:template match="node()" mode="xdg">
		<xsl:param name="sourceId"/>
		<xsl:variable name="currNode" select="."/>
		<xsl:variable name="currentDefType" select="./@defType" />
		<xsl:variable name="propertiesFilter" select="./root()/md/tech:tech/level[@code=$currentDefType]/xdgHarvestedProperty/@name/string()" />


		<xsl:variable name="metaDataHintId" select="concat('hintFrom-',./@id)" />
		
		<xsl:element name="metaDataHint">
			<xsl:attribute name="id" select="$metaDataHintId"/>
			<xsl:attribute name="mdModelId" select="./@id"/>
			<xsl:for-each select="$propertiesFilter" >
				<xsl:variable name="attValue" select="mdj:evaluate($currNode, concat('@', .))" />
				<xsl:if test="exists($attValue)">
					<xsl:variable name="attName" select="replace(replace(concat($currentDefType, '.', .), 'com.stambia.', 'com.semarchy.'), 'com.indy.', 'com.semarchy.')"/>
					<xsl:element name="hint">
						<xsl:attribute name="key">
							<xsl:value-of select="$attName" />				
						</xsl:attribute>	
						<xsl:attribute name="value">
							<xsl:value-of select="$attValue" />				
						</xsl:attribute>	
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
		</xsl:element>
		<xsl:element name="modelObjectMetadataHint">
			<xsl:attribute name="source" select="$sourceId"/>
			<xsl:attribute name="target" select="$metaDataHintId"/>
		</xsl:element>

	</xsl:template>
	
	
</xsl:stylesheet>
