# Requirements

```
node >= 20
```

# Installation

```
npm install -g @semarchy/sem-design@latest
```

# Usage

## Get Help

```
sem-design --help
sem-design dm --help
sem-design data-location --help
...
```

## Build DM

### Info

```
Usage: semarchy dm model build [options]

Merge your seml files into a single json file to send to the Runtime

Options:
  -V, --version               output the version number
  --root-folder <rootFolder>  Full path of the model’s root folder
  -h, --help                  display help for command
```

### Example

```
sem-design dm model build --root-folder ./CustomerB2C
```

## Deploy DM

### Info

```
Usage: semarchy dm data-location deploy [options]

Deploy the workspace into an xDM instance

Options:
  -V, --version                    output the version number
  --root-folder <root-folder>      Full path of the model’s root folder
  --instance-url <instance-url>    Root URL of the Semarchy instance (default: "http://localhost")
  --api-key [api-key]              api key from xDM
  --data-source <data-source>       Datasource name. The datasource is needed when you first run the deploy command, to create the data location. 
          It is not needed for subsequent runs.
  --data-location <data-location>  Data location name
  -h, --help                       display help for command
```

### Example

```
sem-design dm data-location deploy
    --root-folder ./CustomerB2C
    --instance-url "semarchy_url"
    --data-source "data_source"
    --data-location "data_location"
    --api-key "api-key"
```
