#!/usr/bin/env node
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/.pnpm/vscode-languageserver-types@3.17.5/node_modules/vscode-languageserver-types/lib/umd/main.js
var require_main = __commonJS({
  "../../node_modules/.pnpm/vscode-languageserver-types@3.17.5/node_modules/vscode-languageserver-types/lib/umd/main.js"(exports2, module2) {
    "use strict";
    (function(factory) {
      if (typeof module2 === "object" && typeof module2.exports === "object") {
        var v = factory(require, exports2);
        if (v !== void 0) module2.exports = v;
      } else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
      }
    })(function(require2, exports3) {
      "use strict";
      Object.defineProperty(exports3, "__esModule", { value: true });
      exports3.TextDocument = exports3.EOL = exports3.WorkspaceFolder = exports3.InlineCompletionContext = exports3.SelectedCompletionInfo = exports3.InlineCompletionTriggerKind = exports3.InlineCompletionList = exports3.InlineCompletionItem = exports3.StringValue = exports3.InlayHint = exports3.InlayHintLabelPart = exports3.InlayHintKind = exports3.InlineValueContext = exports3.InlineValueEvaluatableExpression = exports3.InlineValueVariableLookup = exports3.InlineValueText = exports3.SemanticTokens = exports3.SemanticTokenModifiers = exports3.SemanticTokenTypes = exports3.SelectionRange = exports3.DocumentLink = exports3.FormattingOptions = exports3.CodeLens = exports3.CodeAction = exports3.CodeActionContext = exports3.CodeActionTriggerKind = exports3.CodeActionKind = exports3.DocumentSymbol = exports3.WorkspaceSymbol = exports3.SymbolInformation = exports3.SymbolTag = exports3.SymbolKind = exports3.DocumentHighlight = exports3.DocumentHighlightKind = exports3.SignatureInformation = exports3.ParameterInformation = exports3.Hover = exports3.MarkedString = exports3.CompletionList = exports3.CompletionItem = exports3.CompletionItemLabelDetails = exports3.InsertTextMode = exports3.InsertReplaceEdit = exports3.CompletionItemTag = exports3.InsertTextFormat = exports3.CompletionItemKind = exports3.MarkupContent = exports3.MarkupKind = exports3.TextDocumentItem = exports3.OptionalVersionedTextDocumentIdentifier = exports3.VersionedTextDocumentIdentifier = exports3.TextDocumentIdentifier = exports3.WorkspaceChange = exports3.WorkspaceEdit = exports3.DeleteFile = exports3.RenameFile = exports3.CreateFile = exports3.TextDocumentEdit = exports3.AnnotatedTextEdit = exports3.ChangeAnnotationIdentifier = exports3.ChangeAnnotation = exports3.TextEdit = exports3.Command = exports3.Diagnostic = exports3.CodeDescription = exports3.DiagnosticTag = exports3.DiagnosticSeverity = exports3.DiagnosticRelatedInformation = exports3.FoldingRange = exports3.FoldingRangeKind = exports3.ColorPresentation = exports3.ColorInformation = exports3.Color = exports3.LocationLink = exports3.Location = exports3.Range = exports3.Position = exports3.uinteger = exports3.integer = exports3.URI = exports3.DocumentUri = void 0;
      var DocumentUri;
      (function(DocumentUri2) {
        function is(value) {
          return typeof value === "string";
        }
        DocumentUri2.is = is;
      })(DocumentUri || (exports3.DocumentUri = DocumentUri = {}));
      var URI;
      (function(URI2) {
        function is(value) {
          return typeof value === "string";
        }
        URI2.is = is;
      })(URI || (exports3.URI = URI = {}));
      var integer;
      (function(integer2) {
        integer2.MIN_VALUE = -2147483648;
        integer2.MAX_VALUE = 2147483647;
        function is(value) {
          return typeof value === "number" && integer2.MIN_VALUE <= value && value <= integer2.MAX_VALUE;
        }
        integer2.is = is;
      })(integer || (exports3.integer = integer = {}));
      var uinteger;
      (function(uinteger2) {
        uinteger2.MIN_VALUE = 0;
        uinteger2.MAX_VALUE = 2147483647;
        function is(value) {
          return typeof value === "number" && uinteger2.MIN_VALUE <= value && value <= uinteger2.MAX_VALUE;
        }
        uinteger2.is = is;
      })(uinteger || (exports3.uinteger = uinteger = {}));
      var Position;
      (function(Position2) {
        function create(line, character) {
          if (line === Number.MAX_VALUE) {
            line = uinteger.MAX_VALUE;
          }
          if (character === Number.MAX_VALUE) {
            character = uinteger.MAX_VALUE;
          }
          return { line, character };
        }
        Position2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.uinteger(candidate.line) && Is.uinteger(candidate.character);
        }
        Position2.is = is;
      })(Position || (exports3.Position = Position = {}));
      var Range;
      (function(Range2) {
        function create(one, two, three, four) {
          if (Is.uinteger(one) && Is.uinteger(two) && Is.uinteger(three) && Is.uinteger(four)) {
            return { start: Position.create(one, two), end: Position.create(three, four) };
          } else if (Position.is(one) && Position.is(two)) {
            return { start: one, end: two };
          } else {
            throw new Error("Range#create called with invalid arguments[".concat(one, ", ").concat(two, ", ").concat(three, ", ").concat(four, "]"));
          }
        }
        Range2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
        }
        Range2.is = is;
      })(Range || (exports3.Range = Range = {}));
      var Location;
      (function(Location2) {
        function create(uri, range) {
          return { uri, range };
        }
        Location2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
        }
        Location2.is = is;
      })(Location || (exports3.Location = Location = {}));
      var LocationLink;
      (function(LocationLink2) {
        function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
          return { targetUri, targetRange, targetSelectionRange, originSelectionRange };
        }
        LocationLink2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri) && Range.is(candidate.targetSelectionRange) && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
        }
        LocationLink2.is = is;
      })(LocationLink || (exports3.LocationLink = LocationLink = {}));
      var Color;
      (function(Color2) {
        function create(red, green, blue, alpha) {
          return {
            red,
            green,
            blue,
            alpha
          };
        }
        Color2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.numberRange(candidate.red, 0, 1) && Is.numberRange(candidate.green, 0, 1) && Is.numberRange(candidate.blue, 0, 1) && Is.numberRange(candidate.alpha, 0, 1);
        }
        Color2.is = is;
      })(Color || (exports3.Color = Color = {}));
      var ColorInformation;
      (function(ColorInformation2) {
        function create(range, color) {
          return {
            range,
            color
          };
        }
        ColorInformation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Range.is(candidate.range) && Color.is(candidate.color);
        }
        ColorInformation2.is = is;
      })(ColorInformation || (exports3.ColorInformation = ColorInformation = {}));
      var ColorPresentation;
      (function(ColorPresentation2) {
        function create(label, textEdit, additionalTextEdits) {
          return {
            label,
            textEdit,
            additionalTextEdits
          };
        }
        ColorPresentation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate)) && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
        }
        ColorPresentation2.is = is;
      })(ColorPresentation || (exports3.ColorPresentation = ColorPresentation = {}));
      var FoldingRangeKind;
      (function(FoldingRangeKind2) {
        FoldingRangeKind2.Comment = "comment";
        FoldingRangeKind2.Imports = "imports";
        FoldingRangeKind2.Region = "region";
      })(FoldingRangeKind || (exports3.FoldingRangeKind = FoldingRangeKind = {}));
      var FoldingRange;
      (function(FoldingRange2) {
        function create(startLine, endLine, startCharacter, endCharacter, kind, collapsedText) {
          var result = {
            startLine,
            endLine
          };
          if (Is.defined(startCharacter)) {
            result.startCharacter = startCharacter;
          }
          if (Is.defined(endCharacter)) {
            result.endCharacter = endCharacter;
          }
          if (Is.defined(kind)) {
            result.kind = kind;
          }
          if (Is.defined(collapsedText)) {
            result.collapsedText = collapsedText;
          }
          return result;
        }
        FoldingRange2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.uinteger(candidate.startLine) && Is.uinteger(candidate.startLine) && (Is.undefined(candidate.startCharacter) || Is.uinteger(candidate.startCharacter)) && (Is.undefined(candidate.endCharacter) || Is.uinteger(candidate.endCharacter)) && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
        }
        FoldingRange2.is = is;
      })(FoldingRange || (exports3.FoldingRange = FoldingRange = {}));
      var DiagnosticRelatedInformation;
      (function(DiagnosticRelatedInformation2) {
        function create(location, message) {
          return {
            location,
            message
          };
        }
        DiagnosticRelatedInformation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
        }
        DiagnosticRelatedInformation2.is = is;
      })(DiagnosticRelatedInformation || (exports3.DiagnosticRelatedInformation = DiagnosticRelatedInformation = {}));
      var DiagnosticSeverity;
      (function(DiagnosticSeverity2) {
        DiagnosticSeverity2.Error = 1;
        DiagnosticSeverity2.Warning = 2;
        DiagnosticSeverity2.Information = 3;
        DiagnosticSeverity2.Hint = 4;
      })(DiagnosticSeverity || (exports3.DiagnosticSeverity = DiagnosticSeverity = {}));
      var DiagnosticTag;
      (function(DiagnosticTag2) {
        DiagnosticTag2.Unnecessary = 1;
        DiagnosticTag2.Deprecated = 2;
      })(DiagnosticTag || (exports3.DiagnosticTag = DiagnosticTag = {}));
      var CodeDescription;
      (function(CodeDescription2) {
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.string(candidate.href);
        }
        CodeDescription2.is = is;
      })(CodeDescription || (exports3.CodeDescription = CodeDescription = {}));
      var Diagnostic;
      (function(Diagnostic2) {
        function create(range, message, severity, code, source, relatedInformation) {
          var result = { range, message };
          if (Is.defined(severity)) {
            result.severity = severity;
          }
          if (Is.defined(code)) {
            result.code = code;
          }
          if (Is.defined(source)) {
            result.source = source;
          }
          if (Is.defined(relatedInformation)) {
            result.relatedInformation = relatedInformation;
          }
          return result;
        }
        Diagnostic2.create = create;
        function is(value) {
          var _a;
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && Is.string(candidate.message) && (Is.number(candidate.severity) || Is.undefined(candidate.severity)) && (Is.integer(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code)) && (Is.undefined(candidate.codeDescription) || Is.string((_a = candidate.codeDescription) === null || _a === void 0 ? void 0 : _a.href)) && (Is.string(candidate.source) || Is.undefined(candidate.source)) && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
        }
        Diagnostic2.is = is;
      })(Diagnostic || (exports3.Diagnostic = Diagnostic = {}));
      var Command3;
      (function(Command4) {
        function create(title, command) {
          var args = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
          }
          var result = { title, command };
          if (Is.defined(args) && args.length > 0) {
            result.arguments = args;
          }
          return result;
        }
        Command4.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
        }
        Command4.is = is;
      })(Command3 || (exports3.Command = Command3 = {}));
      var TextEdit;
      (function(TextEdit2) {
        function replace(range, newText) {
          return { range, newText };
        }
        TextEdit2.replace = replace;
        function insert(position, newText) {
          return { range: { start: position, end: position }, newText };
        }
        TextEdit2.insert = insert;
        function del(range) {
          return { range, newText: "" };
        }
        TextEdit2.del = del;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.string(candidate.newText) && Range.is(candidate.range);
        }
        TextEdit2.is = is;
      })(TextEdit || (exports3.TextEdit = TextEdit = {}));
      var ChangeAnnotation;
      (function(ChangeAnnotation2) {
        function create(label, needsConfirmation, description) {
          var result = { label };
          if (needsConfirmation !== void 0) {
            result.needsConfirmation = needsConfirmation;
          }
          if (description !== void 0) {
            result.description = description;
          }
          return result;
        }
        ChangeAnnotation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
        }
        ChangeAnnotation2.is = is;
      })(ChangeAnnotation || (exports3.ChangeAnnotation = ChangeAnnotation = {}));
      var ChangeAnnotationIdentifier;
      (function(ChangeAnnotationIdentifier2) {
        function is(value) {
          var candidate = value;
          return Is.string(candidate);
        }
        ChangeAnnotationIdentifier2.is = is;
      })(ChangeAnnotationIdentifier || (exports3.ChangeAnnotationIdentifier = ChangeAnnotationIdentifier = {}));
      var AnnotatedTextEdit;
      (function(AnnotatedTextEdit2) {
        function replace(range, newText, annotation) {
          return { range, newText, annotationId: annotation };
        }
        AnnotatedTextEdit2.replace = replace;
        function insert(position, newText, annotation) {
          return { range: { start: position, end: position }, newText, annotationId: annotation };
        }
        AnnotatedTextEdit2.insert = insert;
        function del(range, annotation) {
          return { range, newText: "", annotationId: annotation };
        }
        AnnotatedTextEdit2.del = del;
        function is(value) {
          var candidate = value;
          return TextEdit.is(candidate) && (ChangeAnnotation.is(candidate.annotationId) || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        AnnotatedTextEdit2.is = is;
      })(AnnotatedTextEdit || (exports3.AnnotatedTextEdit = AnnotatedTextEdit = {}));
      var TextDocumentEdit;
      (function(TextDocumentEdit2) {
        function create(textDocument, edits) {
          return { textDocument, edits };
        }
        TextDocumentEdit2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && OptionalVersionedTextDocumentIdentifier.is(candidate.textDocument) && Array.isArray(candidate.edits);
        }
        TextDocumentEdit2.is = is;
      })(TextDocumentEdit || (exports3.TextDocumentEdit = TextDocumentEdit = {}));
      var CreateFile;
      (function(CreateFile2) {
        function create(uri, options, annotation) {
          var result = {
            kind: "create",
            uri
          };
          if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        CreateFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "create" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        CreateFile2.is = is;
      })(CreateFile || (exports3.CreateFile = CreateFile = {}));
      var RenameFile;
      (function(RenameFile2) {
        function create(oldUri, newUri, options, annotation) {
          var result = {
            kind: "rename",
            oldUri,
            newUri
          };
          if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        RenameFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "rename" && Is.string(candidate.oldUri) && Is.string(candidate.newUri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        RenameFile2.is = is;
      })(RenameFile || (exports3.RenameFile = RenameFile = {}));
      var DeleteFile;
      (function(DeleteFile2) {
        function create(uri, options, annotation) {
          var result = {
            kind: "delete",
            uri
          };
          if (options !== void 0 && (options.recursive !== void 0 || options.ignoreIfNotExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        DeleteFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "delete" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.recursive === void 0 || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is.boolean(candidate.options.ignoreIfNotExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        DeleteFile2.is = is;
      })(DeleteFile || (exports3.DeleteFile = DeleteFile = {}));
      var WorkspaceEdit;
      (function(WorkspaceEdit2) {
        function is(value) {
          var candidate = value;
          return candidate && (candidate.changes !== void 0 || candidate.documentChanges !== void 0) && (candidate.documentChanges === void 0 || candidate.documentChanges.every(function(change) {
            if (Is.string(change.kind)) {
              return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
            } else {
              return TextDocumentEdit.is(change);
            }
          }));
        }
        WorkspaceEdit2.is = is;
      })(WorkspaceEdit || (exports3.WorkspaceEdit = WorkspaceEdit = {}));
      var TextEditChangeImpl = (
        /** @class */
        function() {
          function TextEditChangeImpl2(edits, changeAnnotations) {
            this.edits = edits;
            this.changeAnnotations = changeAnnotations;
          }
          TextEditChangeImpl2.prototype.insert = function(position, newText, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit.insert(position, newText);
            } else if (ChangeAnnotationIdentifier.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit.insert(position, newText, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit.insert(position, newText, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.replace = function(range, newText, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit.replace(range, newText);
            } else if (ChangeAnnotationIdentifier.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit.replace(range, newText, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit.replace(range, newText, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.delete = function(range, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit.del(range);
            } else if (ChangeAnnotationIdentifier.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit.del(range, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit.del(range, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.add = function(edit) {
            this.edits.push(edit);
          };
          TextEditChangeImpl2.prototype.all = function() {
            return this.edits;
          };
          TextEditChangeImpl2.prototype.clear = function() {
            this.edits.splice(0, this.edits.length);
          };
          TextEditChangeImpl2.prototype.assertChangeAnnotations = function(value) {
            if (value === void 0) {
              throw new Error("Text edit change is not configured to manage change annotations.");
            }
          };
          return TextEditChangeImpl2;
        }()
      );
      var ChangeAnnotations = (
        /** @class */
        function() {
          function ChangeAnnotations2(annotations) {
            this._annotations = annotations === void 0 ? /* @__PURE__ */ Object.create(null) : annotations;
            this._counter = 0;
            this._size = 0;
          }
          ChangeAnnotations2.prototype.all = function() {
            return this._annotations;
          };
          Object.defineProperty(ChangeAnnotations2.prototype, "size", {
            get: function() {
              return this._size;
            },
            enumerable: false,
            configurable: true
          });
          ChangeAnnotations2.prototype.manage = function(idOrAnnotation, annotation) {
            var id;
            if (ChangeAnnotationIdentifier.is(idOrAnnotation)) {
              id = idOrAnnotation;
            } else {
              id = this.nextId();
              annotation = idOrAnnotation;
            }
            if (this._annotations[id] !== void 0) {
              throw new Error("Id ".concat(id, " is already in use."));
            }
            if (annotation === void 0) {
              throw new Error("No annotation provided for id ".concat(id));
            }
            this._annotations[id] = annotation;
            this._size++;
            return id;
          };
          ChangeAnnotations2.prototype.nextId = function() {
            this._counter++;
            return this._counter.toString();
          };
          return ChangeAnnotations2;
        }()
      );
      var WorkspaceChange = (
        /** @class */
        function() {
          function WorkspaceChange2(workspaceEdit) {
            var _this = this;
            this._textEditChanges = /* @__PURE__ */ Object.create(null);
            if (workspaceEdit !== void 0) {
              this._workspaceEdit = workspaceEdit;
              if (workspaceEdit.documentChanges) {
                this._changeAnnotations = new ChangeAnnotations(workspaceEdit.changeAnnotations);
                workspaceEdit.changeAnnotations = this._changeAnnotations.all();
                workspaceEdit.documentChanges.forEach(function(change) {
                  if (TextDocumentEdit.is(change)) {
                    var textEditChange = new TextEditChangeImpl(change.edits, _this._changeAnnotations);
                    _this._textEditChanges[change.textDocument.uri] = textEditChange;
                  }
                });
              } else if (workspaceEdit.changes) {
                Object.keys(workspaceEdit.changes).forEach(function(key) {
                  var textEditChange = new TextEditChangeImpl(workspaceEdit.changes[key]);
                  _this._textEditChanges[key] = textEditChange;
                });
              }
            } else {
              this._workspaceEdit = {};
            }
          }
          Object.defineProperty(WorkspaceChange2.prototype, "edit", {
            /**
             * Returns the underlying {@link WorkspaceEdit} literal
             * use to be returned from a workspace edit operation like rename.
             */
            get: function() {
              this.initDocumentChanges();
              if (this._changeAnnotations !== void 0) {
                if (this._changeAnnotations.size === 0) {
                  this._workspaceEdit.changeAnnotations = void 0;
                } else {
                  this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
                }
              }
              return this._workspaceEdit;
            },
            enumerable: false,
            configurable: true
          });
          WorkspaceChange2.prototype.getTextEditChange = function(key) {
            if (OptionalVersionedTextDocumentIdentifier.is(key)) {
              this.initDocumentChanges();
              if (this._workspaceEdit.documentChanges === void 0) {
                throw new Error("Workspace edit is not configured for document changes.");
              }
              var textDocument = { uri: key.uri, version: key.version };
              var result = this._textEditChanges[textDocument.uri];
              if (!result) {
                var edits = [];
                var textDocumentEdit = {
                  textDocument,
                  edits
                };
                this._workspaceEdit.documentChanges.push(textDocumentEdit);
                result = new TextEditChangeImpl(edits, this._changeAnnotations);
                this._textEditChanges[textDocument.uri] = result;
              }
              return result;
            } else {
              this.initChanges();
              if (this._workspaceEdit.changes === void 0) {
                throw new Error("Workspace edit is not configured for normal text edit changes.");
              }
              var result = this._textEditChanges[key];
              if (!result) {
                var edits = [];
                this._workspaceEdit.changes[key] = edits;
                result = new TextEditChangeImpl(edits);
                this._textEditChanges[key] = result;
              }
              return result;
            }
          };
          WorkspaceChange2.prototype.initDocumentChanges = function() {
            if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
              this._changeAnnotations = new ChangeAnnotations();
              this._workspaceEdit.documentChanges = [];
              this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
            }
          };
          WorkspaceChange2.prototype.initChanges = function() {
            if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
              this._workspaceEdit.changes = /* @__PURE__ */ Object.create(null);
            }
          };
          WorkspaceChange2.prototype.createFile = function(uri, optionsOrAnnotation, options) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = CreateFile.create(uri, options);
            } else {
              id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = CreateFile.create(uri, options, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          WorkspaceChange2.prototype.renameFile = function(oldUri, newUri, optionsOrAnnotation, options) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = RenameFile.create(oldUri, newUri, options);
            } else {
              id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = RenameFile.create(oldUri, newUri, options, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          WorkspaceChange2.prototype.deleteFile = function(uri, optionsOrAnnotation, options) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = DeleteFile.create(uri, options);
            } else {
              id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = DeleteFile.create(uri, options, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          return WorkspaceChange2;
        }()
      );
      exports3.WorkspaceChange = WorkspaceChange;
      var TextDocumentIdentifier;
      (function(TextDocumentIdentifier2) {
        function create(uri) {
          return { uri };
        }
        TextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri);
        }
        TextDocumentIdentifier2.is = is;
      })(TextDocumentIdentifier || (exports3.TextDocumentIdentifier = TextDocumentIdentifier = {}));
      var VersionedTextDocumentIdentifier;
      (function(VersionedTextDocumentIdentifier2) {
        function create(uri, version) {
          return { uri, version };
        }
        VersionedTextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && Is.integer(candidate.version);
        }
        VersionedTextDocumentIdentifier2.is = is;
      })(VersionedTextDocumentIdentifier || (exports3.VersionedTextDocumentIdentifier = VersionedTextDocumentIdentifier = {}));
      var OptionalVersionedTextDocumentIdentifier;
      (function(OptionalVersionedTextDocumentIdentifier2) {
        function create(uri, version) {
          return { uri, version };
        }
        OptionalVersionedTextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.integer(candidate.version));
        }
        OptionalVersionedTextDocumentIdentifier2.is = is;
      })(OptionalVersionedTextDocumentIdentifier || (exports3.OptionalVersionedTextDocumentIdentifier = OptionalVersionedTextDocumentIdentifier = {}));
      var TextDocumentItem;
      (function(TextDocumentItem2) {
        function create(uri, languageId, version, text) {
          return { uri, languageId, version, text };
        }
        TextDocumentItem2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.integer(candidate.version) && Is.string(candidate.text);
        }
        TextDocumentItem2.is = is;
      })(TextDocumentItem || (exports3.TextDocumentItem = TextDocumentItem = {}));
      var MarkupKind;
      (function(MarkupKind2) {
        MarkupKind2.PlainText = "plaintext";
        MarkupKind2.Markdown = "markdown";
        function is(value) {
          var candidate = value;
          return candidate === MarkupKind2.PlainText || candidate === MarkupKind2.Markdown;
        }
        MarkupKind2.is = is;
      })(MarkupKind || (exports3.MarkupKind = MarkupKind = {}));
      var MarkupContent;
      (function(MarkupContent2) {
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
        }
        MarkupContent2.is = is;
      })(MarkupContent || (exports3.MarkupContent = MarkupContent = {}));
      var CompletionItemKind;
      (function(CompletionItemKind2) {
        CompletionItemKind2.Text = 1;
        CompletionItemKind2.Method = 2;
        CompletionItemKind2.Function = 3;
        CompletionItemKind2.Constructor = 4;
        CompletionItemKind2.Field = 5;
        CompletionItemKind2.Variable = 6;
        CompletionItemKind2.Class = 7;
        CompletionItemKind2.Interface = 8;
        CompletionItemKind2.Module = 9;
        CompletionItemKind2.Property = 10;
        CompletionItemKind2.Unit = 11;
        CompletionItemKind2.Value = 12;
        CompletionItemKind2.Enum = 13;
        CompletionItemKind2.Keyword = 14;
        CompletionItemKind2.Snippet = 15;
        CompletionItemKind2.Color = 16;
        CompletionItemKind2.File = 17;
        CompletionItemKind2.Reference = 18;
        CompletionItemKind2.Folder = 19;
        CompletionItemKind2.EnumMember = 20;
        CompletionItemKind2.Constant = 21;
        CompletionItemKind2.Struct = 22;
        CompletionItemKind2.Event = 23;
        CompletionItemKind2.Operator = 24;
        CompletionItemKind2.TypeParameter = 25;
      })(CompletionItemKind || (exports3.CompletionItemKind = CompletionItemKind = {}));
      var InsertTextFormat;
      (function(InsertTextFormat2) {
        InsertTextFormat2.PlainText = 1;
        InsertTextFormat2.Snippet = 2;
      })(InsertTextFormat || (exports3.InsertTextFormat = InsertTextFormat = {}));
      var CompletionItemTag;
      (function(CompletionItemTag2) {
        CompletionItemTag2.Deprecated = 1;
      })(CompletionItemTag || (exports3.CompletionItemTag = CompletionItemTag = {}));
      var InsertReplaceEdit;
      (function(InsertReplaceEdit2) {
        function create(newText, insert, replace) {
          return { newText, insert, replace };
        }
        InsertReplaceEdit2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.newText) && Range.is(candidate.insert) && Range.is(candidate.replace);
        }
        InsertReplaceEdit2.is = is;
      })(InsertReplaceEdit || (exports3.InsertReplaceEdit = InsertReplaceEdit = {}));
      var InsertTextMode;
      (function(InsertTextMode2) {
        InsertTextMode2.asIs = 1;
        InsertTextMode2.adjustIndentation = 2;
      })(InsertTextMode || (exports3.InsertTextMode = InsertTextMode = {}));
      var CompletionItemLabelDetails;
      (function(CompletionItemLabelDetails2) {
        function is(value) {
          var candidate = value;
          return candidate && (Is.string(candidate.detail) || candidate.detail === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
        }
        CompletionItemLabelDetails2.is = is;
      })(CompletionItemLabelDetails || (exports3.CompletionItemLabelDetails = CompletionItemLabelDetails = {}));
      var CompletionItem;
      (function(CompletionItem2) {
        function create(label) {
          return { label };
        }
        CompletionItem2.create = create;
      })(CompletionItem || (exports3.CompletionItem = CompletionItem = {}));
      var CompletionList;
      (function(CompletionList2) {
        function create(items, isIncomplete) {
          return { items: items ? items : [], isIncomplete: !!isIncomplete };
        }
        CompletionList2.create = create;
      })(CompletionList || (exports3.CompletionList = CompletionList = {}));
      var MarkedString;
      (function(MarkedString2) {
        function fromPlainText(plainText) {
          return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, "\\$&");
        }
        MarkedString2.fromPlainText = fromPlainText;
        function is(value) {
          var candidate = value;
          return Is.string(candidate) || Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value);
        }
        MarkedString2.is = is;
      })(MarkedString || (exports3.MarkedString = MarkedString = {}));
      var Hover;
      (function(Hover2) {
        function is(value) {
          var candidate = value;
          return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) || MarkedString.is(candidate.contents) || Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === void 0 || Range.is(value.range));
        }
        Hover2.is = is;
      })(Hover || (exports3.Hover = Hover = {}));
      var ParameterInformation;
      (function(ParameterInformation2) {
        function create(label, documentation) {
          return documentation ? { label, documentation } : { label };
        }
        ParameterInformation2.create = create;
      })(ParameterInformation || (exports3.ParameterInformation = ParameterInformation = {}));
      var SignatureInformation;
      (function(SignatureInformation2) {
        function create(label, documentation) {
          var parameters = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            parameters[_i - 2] = arguments[_i];
          }
          var result = { label };
          if (Is.defined(documentation)) {
            result.documentation = documentation;
          }
          if (Is.defined(parameters)) {
            result.parameters = parameters;
          } else {
            result.parameters = [];
          }
          return result;
        }
        SignatureInformation2.create = create;
      })(SignatureInformation || (exports3.SignatureInformation = SignatureInformation = {}));
      var DocumentHighlightKind;
      (function(DocumentHighlightKind2) {
        DocumentHighlightKind2.Text = 1;
        DocumentHighlightKind2.Read = 2;
        DocumentHighlightKind2.Write = 3;
      })(DocumentHighlightKind || (exports3.DocumentHighlightKind = DocumentHighlightKind = {}));
      var DocumentHighlight;
      (function(DocumentHighlight2) {
        function create(range, kind) {
          var result = { range };
          if (Is.number(kind)) {
            result.kind = kind;
          }
          return result;
        }
        DocumentHighlight2.create = create;
      })(DocumentHighlight || (exports3.DocumentHighlight = DocumentHighlight = {}));
      var SymbolKind;
      (function(SymbolKind2) {
        SymbolKind2.File = 1;
        SymbolKind2.Module = 2;
        SymbolKind2.Namespace = 3;
        SymbolKind2.Package = 4;
        SymbolKind2.Class = 5;
        SymbolKind2.Method = 6;
        SymbolKind2.Property = 7;
        SymbolKind2.Field = 8;
        SymbolKind2.Constructor = 9;
        SymbolKind2.Enum = 10;
        SymbolKind2.Interface = 11;
        SymbolKind2.Function = 12;
        SymbolKind2.Variable = 13;
        SymbolKind2.Constant = 14;
        SymbolKind2.String = 15;
        SymbolKind2.Number = 16;
        SymbolKind2.Boolean = 17;
        SymbolKind2.Array = 18;
        SymbolKind2.Object = 19;
        SymbolKind2.Key = 20;
        SymbolKind2.Null = 21;
        SymbolKind2.EnumMember = 22;
        SymbolKind2.Struct = 23;
        SymbolKind2.Event = 24;
        SymbolKind2.Operator = 25;
        SymbolKind2.TypeParameter = 26;
      })(SymbolKind || (exports3.SymbolKind = SymbolKind = {}));
      var SymbolTag;
      (function(SymbolTag2) {
        SymbolTag2.Deprecated = 1;
      })(SymbolTag || (exports3.SymbolTag = SymbolTag = {}));
      var SymbolInformation;
      (function(SymbolInformation2) {
        function create(name, kind, range, uri, containerName) {
          var result = {
            name,
            kind,
            location: { uri, range }
          };
          if (containerName) {
            result.containerName = containerName;
          }
          return result;
        }
        SymbolInformation2.create = create;
      })(SymbolInformation || (exports3.SymbolInformation = SymbolInformation = {}));
      var WorkspaceSymbol;
      (function(WorkspaceSymbol2) {
        function create(name, kind, uri, range) {
          return range !== void 0 ? { name, kind, location: { uri, range } } : { name, kind, location: { uri } };
        }
        WorkspaceSymbol2.create = create;
      })(WorkspaceSymbol || (exports3.WorkspaceSymbol = WorkspaceSymbol = {}));
      var DocumentSymbol;
      (function(DocumentSymbol2) {
        function create(name, detail, kind, range, selectionRange, children) {
          var result = {
            name,
            detail,
            kind,
            range,
            selectionRange
          };
          if (children !== void 0) {
            result.children = children;
          }
          return result;
        }
        DocumentSymbol2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.name) && Is.number(candidate.kind) && Range.is(candidate.range) && Range.is(candidate.selectionRange) && (candidate.detail === void 0 || Is.string(candidate.detail)) && (candidate.deprecated === void 0 || Is.boolean(candidate.deprecated)) && (candidate.children === void 0 || Array.isArray(candidate.children)) && (candidate.tags === void 0 || Array.isArray(candidate.tags));
        }
        DocumentSymbol2.is = is;
      })(DocumentSymbol || (exports3.DocumentSymbol = DocumentSymbol = {}));
      var CodeActionKind;
      (function(CodeActionKind2) {
        CodeActionKind2.Empty = "";
        CodeActionKind2.QuickFix = "quickfix";
        CodeActionKind2.Refactor = "refactor";
        CodeActionKind2.RefactorExtract = "refactor.extract";
        CodeActionKind2.RefactorInline = "refactor.inline";
        CodeActionKind2.RefactorRewrite = "refactor.rewrite";
        CodeActionKind2.Source = "source";
        CodeActionKind2.SourceOrganizeImports = "source.organizeImports";
        CodeActionKind2.SourceFixAll = "source.fixAll";
      })(CodeActionKind || (exports3.CodeActionKind = CodeActionKind = {}));
      var CodeActionTriggerKind;
      (function(CodeActionTriggerKind2) {
        CodeActionTriggerKind2.Invoked = 1;
        CodeActionTriggerKind2.Automatic = 2;
      })(CodeActionTriggerKind || (exports3.CodeActionTriggerKind = CodeActionTriggerKind = {}));
      var CodeActionContext;
      (function(CodeActionContext2) {
        function create(diagnostics, only, triggerKind) {
          var result = { diagnostics };
          if (only !== void 0 && only !== null) {
            result.only = only;
          }
          if (triggerKind !== void 0 && triggerKind !== null) {
            result.triggerKind = triggerKind;
          }
          return result;
        }
        CodeActionContext2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is) && (candidate.only === void 0 || Is.typedArray(candidate.only, Is.string)) && (candidate.triggerKind === void 0 || candidate.triggerKind === CodeActionTriggerKind.Invoked || candidate.triggerKind === CodeActionTriggerKind.Automatic);
        }
        CodeActionContext2.is = is;
      })(CodeActionContext || (exports3.CodeActionContext = CodeActionContext = {}));
      var CodeAction;
      (function(CodeAction2) {
        function create(title, kindOrCommandOrEdit, kind) {
          var result = { title };
          var checkKind = true;
          if (typeof kindOrCommandOrEdit === "string") {
            checkKind = false;
            result.kind = kindOrCommandOrEdit;
          } else if (Command3.is(kindOrCommandOrEdit)) {
            result.command = kindOrCommandOrEdit;
          } else {
            result.edit = kindOrCommandOrEdit;
          }
          if (checkKind && kind !== void 0) {
            result.kind = kind;
          }
          return result;
        }
        CodeAction2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.title) && (candidate.diagnostics === void 0 || Is.typedArray(candidate.diagnostics, Diagnostic.is)) && (candidate.kind === void 0 || Is.string(candidate.kind)) && (candidate.edit !== void 0 || candidate.command !== void 0) && (candidate.command === void 0 || Command3.is(candidate.command)) && (candidate.isPreferred === void 0 || Is.boolean(candidate.isPreferred)) && (candidate.edit === void 0 || WorkspaceEdit.is(candidate.edit));
        }
        CodeAction2.is = is;
      })(CodeAction || (exports3.CodeAction = CodeAction = {}));
      var CodeLens;
      (function(CodeLens2) {
        function create(range, data) {
          var result = { range };
          if (Is.defined(data)) {
            result.data = data;
          }
          return result;
        }
        CodeLens2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command3.is(candidate.command));
        }
        CodeLens2.is = is;
      })(CodeLens || (exports3.CodeLens = CodeLens = {}));
      var FormattingOptions;
      (function(FormattingOptions2) {
        function create(tabSize, insertSpaces) {
          return { tabSize, insertSpaces };
        }
        FormattingOptions2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.uinteger(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
        }
        FormattingOptions2.is = is;
      })(FormattingOptions || (exports3.FormattingOptions = FormattingOptions = {}));
      var DocumentLink;
      (function(DocumentLink2) {
        function create(range, target, data) {
          return { range, target, data };
        }
        DocumentLink2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
        }
        DocumentLink2.is = is;
      })(DocumentLink || (exports3.DocumentLink = DocumentLink = {}));
      var SelectionRange;
      (function(SelectionRange2) {
        function create(range, parent) {
          return { range, parent };
        }
        SelectionRange2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Range.is(candidate.range) && (candidate.parent === void 0 || SelectionRange2.is(candidate.parent));
        }
        SelectionRange2.is = is;
      })(SelectionRange || (exports3.SelectionRange = SelectionRange = {}));
      var SemanticTokenTypes;
      (function(SemanticTokenTypes2) {
        SemanticTokenTypes2["namespace"] = "namespace";
        SemanticTokenTypes2["type"] = "type";
        SemanticTokenTypes2["class"] = "class";
        SemanticTokenTypes2["enum"] = "enum";
        SemanticTokenTypes2["interface"] = "interface";
        SemanticTokenTypes2["struct"] = "struct";
        SemanticTokenTypes2["typeParameter"] = "typeParameter";
        SemanticTokenTypes2["parameter"] = "parameter";
        SemanticTokenTypes2["variable"] = "variable";
        SemanticTokenTypes2["property"] = "property";
        SemanticTokenTypes2["enumMember"] = "enumMember";
        SemanticTokenTypes2["event"] = "event";
        SemanticTokenTypes2["function"] = "function";
        SemanticTokenTypes2["method"] = "method";
        SemanticTokenTypes2["macro"] = "macro";
        SemanticTokenTypes2["keyword"] = "keyword";
        SemanticTokenTypes2["modifier"] = "modifier";
        SemanticTokenTypes2["comment"] = "comment";
        SemanticTokenTypes2["string"] = "string";
        SemanticTokenTypes2["number"] = "number";
        SemanticTokenTypes2["regexp"] = "regexp";
        SemanticTokenTypes2["operator"] = "operator";
        SemanticTokenTypes2["decorator"] = "decorator";
      })(SemanticTokenTypes || (exports3.SemanticTokenTypes = SemanticTokenTypes = {}));
      var SemanticTokenModifiers;
      (function(SemanticTokenModifiers2) {
        SemanticTokenModifiers2["declaration"] = "declaration";
        SemanticTokenModifiers2["definition"] = "definition";
        SemanticTokenModifiers2["readonly"] = "readonly";
        SemanticTokenModifiers2["static"] = "static";
        SemanticTokenModifiers2["deprecated"] = "deprecated";
        SemanticTokenModifiers2["abstract"] = "abstract";
        SemanticTokenModifiers2["async"] = "async";
        SemanticTokenModifiers2["modification"] = "modification";
        SemanticTokenModifiers2["documentation"] = "documentation";
        SemanticTokenModifiers2["defaultLibrary"] = "defaultLibrary";
      })(SemanticTokenModifiers || (exports3.SemanticTokenModifiers = SemanticTokenModifiers = {}));
      var SemanticTokens;
      (function(SemanticTokens2) {
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && (candidate.resultId === void 0 || typeof candidate.resultId === "string") && Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === "number");
        }
        SemanticTokens2.is = is;
      })(SemanticTokens || (exports3.SemanticTokens = SemanticTokens = {}));
      var InlineValueText;
      (function(InlineValueText2) {
        function create(range, text) {
          return { range, text };
        }
        InlineValueText2.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && Is.string(candidate.text);
        }
        InlineValueText2.is = is;
      })(InlineValueText || (exports3.InlineValueText = InlineValueText = {}));
      var InlineValueVariableLookup;
      (function(InlineValueVariableLookup2) {
        function create(range, variableName, caseSensitiveLookup) {
          return { range, variableName, caseSensitiveLookup };
        }
        InlineValueVariableLookup2.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && Is.boolean(candidate.caseSensitiveLookup) && (Is.string(candidate.variableName) || candidate.variableName === void 0);
        }
        InlineValueVariableLookup2.is = is;
      })(InlineValueVariableLookup || (exports3.InlineValueVariableLookup = InlineValueVariableLookup = {}));
      var InlineValueEvaluatableExpression;
      (function(InlineValueEvaluatableExpression2) {
        function create(range, expression) {
          return { range, expression };
        }
        InlineValueEvaluatableExpression2.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && (Is.string(candidate.expression) || candidate.expression === void 0);
        }
        InlineValueEvaluatableExpression2.is = is;
      })(InlineValueEvaluatableExpression || (exports3.InlineValueEvaluatableExpression = InlineValueEvaluatableExpression = {}));
      var InlineValueContext;
      (function(InlineValueContext2) {
        function create(frameId, stoppedLocation) {
          return { frameId, stoppedLocation };
        }
        InlineValueContext2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(value.stoppedLocation);
        }
        InlineValueContext2.is = is;
      })(InlineValueContext || (exports3.InlineValueContext = InlineValueContext = {}));
      var InlayHintKind;
      (function(InlayHintKind2) {
        InlayHintKind2.Type = 1;
        InlayHintKind2.Parameter = 2;
        function is(value) {
          return value === 1 || value === 2;
        }
        InlayHintKind2.is = is;
      })(InlayHintKind || (exports3.InlayHintKind = InlayHintKind = {}));
      var InlayHintLabelPart;
      (function(InlayHintLabelPart2) {
        function create(value) {
          return { value };
        }
        InlayHintLabelPart2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && (candidate.tooltip === void 0 || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip)) && (candidate.location === void 0 || Location.is(candidate.location)) && (candidate.command === void 0 || Command3.is(candidate.command));
        }
        InlayHintLabelPart2.is = is;
      })(InlayHintLabelPart || (exports3.InlayHintLabelPart = InlayHintLabelPart = {}));
      var InlayHint;
      (function(InlayHint2) {
        function create(position, label, kind) {
          var result = { position, label };
          if (kind !== void 0) {
            result.kind = kind;
          }
          return result;
        }
        InlayHint2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Position.is(candidate.position) && (Is.string(candidate.label) || Is.typedArray(candidate.label, InlayHintLabelPart.is)) && (candidate.kind === void 0 || InlayHintKind.is(candidate.kind)) && candidate.textEdits === void 0 || Is.typedArray(candidate.textEdits, TextEdit.is) && (candidate.tooltip === void 0 || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip)) && (candidate.paddingLeft === void 0 || Is.boolean(candidate.paddingLeft)) && (candidate.paddingRight === void 0 || Is.boolean(candidate.paddingRight));
        }
        InlayHint2.is = is;
      })(InlayHint || (exports3.InlayHint = InlayHint = {}));
      var StringValue;
      (function(StringValue2) {
        function createSnippet(value) {
          return { kind: "snippet", value };
        }
        StringValue2.createSnippet = createSnippet;
      })(StringValue || (exports3.StringValue = StringValue = {}));
      var InlineCompletionItem;
      (function(InlineCompletionItem2) {
        function create(insertText, filterText, range, command) {
          return { insertText, filterText, range, command };
        }
        InlineCompletionItem2.create = create;
      })(InlineCompletionItem || (exports3.InlineCompletionItem = InlineCompletionItem = {}));
      var InlineCompletionList;
      (function(InlineCompletionList2) {
        function create(items) {
          return { items };
        }
        InlineCompletionList2.create = create;
      })(InlineCompletionList || (exports3.InlineCompletionList = InlineCompletionList = {}));
      var InlineCompletionTriggerKind;
      (function(InlineCompletionTriggerKind2) {
        InlineCompletionTriggerKind2.Invoked = 0;
        InlineCompletionTriggerKind2.Automatic = 1;
      })(InlineCompletionTriggerKind || (exports3.InlineCompletionTriggerKind = InlineCompletionTriggerKind = {}));
      var SelectedCompletionInfo;
      (function(SelectedCompletionInfo2) {
        function create(range, text) {
          return { range, text };
        }
        SelectedCompletionInfo2.create = create;
      })(SelectedCompletionInfo || (exports3.SelectedCompletionInfo = SelectedCompletionInfo = {}));
      var InlineCompletionContext;
      (function(InlineCompletionContext2) {
        function create(triggerKind, selectedCompletionInfo) {
          return { triggerKind, selectedCompletionInfo };
        }
        InlineCompletionContext2.create = create;
      })(InlineCompletionContext || (exports3.InlineCompletionContext = InlineCompletionContext = {}));
      var WorkspaceFolder;
      (function(WorkspaceFolder2) {
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && URI.is(candidate.uri) && Is.string(candidate.name);
        }
        WorkspaceFolder2.is = is;
      })(WorkspaceFolder || (exports3.WorkspaceFolder = WorkspaceFolder = {}));
      exports3.EOL = ["\n", "\r\n", "\r"];
      var TextDocument2;
      (function(TextDocument3) {
        function create(uri, languageId, version, content) {
          return new FullTextDocument2(uri, languageId, version, content);
        }
        TextDocument3.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.uinteger(candidate.lineCount) && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
        }
        TextDocument3.is = is;
        function applyEdits(document2, edits) {
          var text = document2.getText();
          var sortedEdits = mergeSort2(edits, function(a, b) {
            var diff = a.range.start.line - b.range.start.line;
            if (diff === 0) {
              return a.range.start.character - b.range.start.character;
            }
            return diff;
          });
          var lastModifiedOffset = text.length;
          for (var i = sortedEdits.length - 1; i >= 0; i--) {
            var e = sortedEdits[i];
            var startOffset = document2.offsetAt(e.range.start);
            var endOffset = document2.offsetAt(e.range.end);
            if (endOffset <= lastModifiedOffset) {
              text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
            } else {
              throw new Error("Overlapping edit");
            }
            lastModifiedOffset = startOffset;
          }
          return text;
        }
        TextDocument3.applyEdits = applyEdits;
        function mergeSort2(data, compare) {
          if (data.length <= 1) {
            return data;
          }
          var p = data.length / 2 | 0;
          var left = data.slice(0, p);
          var right = data.slice(p);
          mergeSort2(left, compare);
          mergeSort2(right, compare);
          var leftIdx = 0;
          var rightIdx = 0;
          var i = 0;
          while (leftIdx < left.length && rightIdx < right.length) {
            var ret = compare(left[leftIdx], right[rightIdx]);
            if (ret <= 0) {
              data[i++] = left[leftIdx++];
            } else {
              data[i++] = right[rightIdx++];
            }
          }
          while (leftIdx < left.length) {
            data[i++] = left[leftIdx++];
          }
          while (rightIdx < right.length) {
            data[i++] = right[rightIdx++];
          }
          return data;
        }
      })(TextDocument2 || (exports3.TextDocument = TextDocument2 = {}));
      var FullTextDocument2 = (
        /** @class */
        function() {
          function FullTextDocument3(uri, languageId, version, content) {
            this._uri = uri;
            this._languageId = languageId;
            this._version = version;
            this._content = content;
            this._lineOffsets = void 0;
          }
          Object.defineProperty(FullTextDocument3.prototype, "uri", {
            get: function() {
              return this._uri;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument3.prototype, "languageId", {
            get: function() {
              return this._languageId;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument3.prototype, "version", {
            get: function() {
              return this._version;
            },
            enumerable: false,
            configurable: true
          });
          FullTextDocument3.prototype.getText = function(range) {
            if (range) {
              var start = this.offsetAt(range.start);
              var end = this.offsetAt(range.end);
              return this._content.substring(start, end);
            }
            return this._content;
          };
          FullTextDocument3.prototype.update = function(event, version) {
            this._content = event.text;
            this._version = version;
            this._lineOffsets = void 0;
          };
          FullTextDocument3.prototype.getLineOffsets = function() {
            if (this._lineOffsets === void 0) {
              var lineOffsets = [];
              var text = this._content;
              var isLineStart = true;
              for (var i = 0; i < text.length; i++) {
                if (isLineStart) {
                  lineOffsets.push(i);
                  isLineStart = false;
                }
                var ch = text.charAt(i);
                isLineStart = ch === "\r" || ch === "\n";
                if (ch === "\r" && i + 1 < text.length && text.charAt(i + 1) === "\n") {
                  i++;
                }
              }
              if (isLineStart && text.length > 0) {
                lineOffsets.push(text.length);
              }
              this._lineOffsets = lineOffsets;
            }
            return this._lineOffsets;
          };
          FullTextDocument3.prototype.positionAt = function(offset) {
            offset = Math.max(Math.min(offset, this._content.length), 0);
            var lineOffsets = this.getLineOffsets();
            var low = 0, high = lineOffsets.length;
            if (high === 0) {
              return Position.create(0, offset);
            }
            while (low < high) {
              var mid = Math.floor((low + high) / 2);
              if (lineOffsets[mid] > offset) {
                high = mid;
              } else {
                low = mid + 1;
              }
            }
            var line = low - 1;
            return Position.create(line, offset - lineOffsets[line]);
          };
          FullTextDocument3.prototype.offsetAt = function(position) {
            var lineOffsets = this.getLineOffsets();
            if (position.line >= lineOffsets.length) {
              return this._content.length;
            } else if (position.line < 0) {
              return 0;
            }
            var lineOffset = lineOffsets[position.line];
            var nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
            return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
          };
          Object.defineProperty(FullTextDocument3.prototype, "lineCount", {
            get: function() {
              return this.getLineOffsets().length;
            },
            enumerable: false,
            configurable: true
          });
          return FullTextDocument3;
        }()
      );
      var Is;
      (function(Is2) {
        var toString = Object.prototype.toString;
        function defined(value) {
          return typeof value !== "undefined";
        }
        Is2.defined = defined;
        function undefined2(value) {
          return typeof value === "undefined";
        }
        Is2.undefined = undefined2;
        function boolean(value) {
          return value === true || value === false;
        }
        Is2.boolean = boolean;
        function string(value) {
          return toString.call(value) === "[object String]";
        }
        Is2.string = string;
        function number(value) {
          return toString.call(value) === "[object Number]";
        }
        Is2.number = number;
        function numberRange(value, min, max) {
          return toString.call(value) === "[object Number]" && min <= value && value <= max;
        }
        Is2.numberRange = numberRange;
        function integer2(value) {
          return toString.call(value) === "[object Number]" && -2147483648 <= value && value <= 2147483647;
        }
        Is2.integer = integer2;
        function uinteger2(value) {
          return toString.call(value) === "[object Number]" && 0 <= value && value <= 2147483647;
        }
        Is2.uinteger = uinteger2;
        function func(value) {
          return toString.call(value) === "[object Function]";
        }
        Is2.func = func;
        function objectLiteral(value) {
          return value !== null && typeof value === "object";
        }
        Is2.objectLiteral = objectLiteral;
        function typedArray(value, check) {
          return Array.isArray(value) && value.every(check);
        }
        Is2.typedArray = typedArray;
      })(Is || (Is = {}));
    });
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/range.js
var require_range = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/range.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromNodeToRange = fromNodeToRange;
    exports2.fromPathToRange = fromPathToRange;
    function fromBlockNodeToRange(document2, node, nodeType, source, queryRange) {
      const initialLine = document2.positionAt(node.offset).line;
      const nodeOffset = nodeType === "PLAIN" ? 0 : 2;
      let firstPosition = document2.positionAt(node.offset + nodeOffset);
      if (nodeType !== "PLAIN" && firstPosition.line === initialLine) {
        firstPosition = document2.positionAt(node.offset + nodeOffset + 1);
      }
      const firstPositionCharacter = nodeType === "PLAIN" ? firstPosition.character : source.search(/\S|$/);
      const lines = source.trim().replaceAll("\r\n", "\n").split("\n");
      const sanitizedTrimmedSource = lines.map((line2) => {
        if (nodeType === "PLAIN") {
          return line2.trim();
        } else {
          return line2.trimStart();
        }
      }).join(" ");
      const queryString = sanitizedTrimmedSource.substring(queryRange.start, queryRange.end);
      const line = lines.findIndex((l) => l.includes(queryString));
      const leadingSpaces = line === 0 ? firstPositionCharacter : 0;
      return {
        range: {
          start: {
            line: firstPosition.line + line,
            character: leadingSpaces + lines[line].indexOf(queryString)
          },
          end: {
            line: firstPosition.line + line,
            character: leadingSpaces + lines[line].indexOf(queryString) + queryString.length
          }
        }
      };
    }
    function fromNodeToRange(document2, node, queryRange) {
      if (node.length === 0 && node.parent) {
        return fromNodeToRange(document2, node.parent, queryRange);
      }
      if (queryRange) {
        if (node.type === "string" && "type" in node.internalNode && node.internalNode.srcToken && "source" in node.internalNode.srcToken && (node.internalNode.type === "BLOCK_LITERAL" || node.internalNode.type === "BLOCK_FOLDED" || node.internalNode.type === "PLAIN")) {
          return fromBlockNodeToRange(document2, node, node.internalNode.type, node.internalNode.srcToken.source, queryRange);
        }
        return {
          range: {
            start: document2.positionAt(node.offset + queryRange.start),
            end: document2.positionAt(node.offset + queryRange.end)
          }
        };
      }
      return {
        range: {
          start: document2.positionAt(node.offset),
          end: document2.positionAt(node.offset + node.length)
        }
      };
    }
    function fromPathToRange(document2, yamlDoc, path4, queryRange) {
      if (!path4) {
        return {
          range: {
            start: document2.positionAt(0),
            end: document2.positionAt(1)
          }
        };
      }
      const node = yamlDoc.query(path4);
      if (node) {
        return fromNodeToRange(document2, node, queryRange);
      }
      const lastDot = path4.lastIndexOf(".");
      const lastIndex = path4.lastIndexOf("[");
      const lastSegment = Math.max(lastDot, lastIndex);
      if (lastSegment > -1) {
        return fromPathToRange(document2, yamlDoc, path4.substring(0, lastSegment), queryRange);
      }
      return {
        range: {
          start: document2.positionAt(0),
          end: document2.positionAt(1)
        }
      };
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/arrUtils.js
var require_arrUtils = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/arrUtils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.filterInvalidCustomTags = filterInvalidCustomTags;
    exports2.isArrayEqual = isArrayEqual;
    function filterInvalidCustomTags(customTags) {
      const validCustomTags = ["mapping", "scalar", "sequence"];
      if (!customTags) {
        return [];
      }
      return customTags.filter((tag) => {
        if (typeof tag === "string") {
          const typeInfo = tag.split(" ");
          const type = typeInfo[1] && typeInfo[1].toLowerCase() || "scalar";
          if (type === "map") {
            return false;
          }
          return validCustomTags.indexOf(type) !== -1;
        }
        return false;
      });
    }
    function isArrayEqual(fst, snd) {
      if (!snd || !fst) {
        return false;
      }
      if (snd.length !== fst.length) {
        return false;
      }
      for (let index = fst.length - 1; index >= 0; index--) {
        if (fst[index] !== snd[index]) {
          return false;
        }
      }
      return true;
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/astUtils.js
var require_astUtils = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/astUtils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getParent = getParent;
    var yaml_1 = require("yaml");
    function getParent(doc, nodeToFind) {
      let parentNode;
      (0, yaml_1.visit)(doc, (_, node, path4) => {
        if (node === nodeToFind) {
          parentNode = path4[path4.length - 1];
          return yaml_1.visit.BREAK;
        }
      });
      if ((0, yaml_1.isDocument)(parentNode)) {
        return void 0;
      }
      return parentNode;
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/charCode.js
var require_charCode = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/charCode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../node_modules/.pnpm/lodash@4.17.21/node_modules/lodash/lodash.js
var require_lodash = __commonJS({
  "../../node_modules/.pnpm/lodash@4.17.21/node_modules/lodash/lodash.js"(exports2, module2) {
    "use strict";
    (function() {
      var undefined2;
      var VERSION = "4.17.21";
      var LARGE_ARRAY_SIZE = 200;
      var CORE_ERROR_TEXT = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", FUNC_ERROR_TEXT = "Expected a function", INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
      var HASH_UNDEFINED = "__lodash_hash_undefined__";
      var MAX_MEMOIZE_SIZE = 500;
      var PLACEHOLDER = "__lodash_placeholder__";
      var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
      var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
      var WRAP_BIND_FLAG = 1, WRAP_BIND_KEY_FLAG = 2, WRAP_CURRY_BOUND_FLAG = 4, WRAP_CURRY_FLAG = 8, WRAP_CURRY_RIGHT_FLAG = 16, WRAP_PARTIAL_FLAG = 32, WRAP_PARTIAL_RIGHT_FLAG = 64, WRAP_ARY_FLAG = 128, WRAP_REARG_FLAG = 256, WRAP_FLIP_FLAG = 512;
      var DEFAULT_TRUNC_LENGTH = 30, DEFAULT_TRUNC_OMISSION = "...";
      var HOT_COUNT = 800, HOT_SPAN = 16;
      var LAZY_FILTER_FLAG = 1, LAZY_MAP_FLAG = 2, LAZY_WHILE_FLAG = 3;
      var INFINITY = 1 / 0, MAX_SAFE_INTEGER = 9007199254740991, MAX_INTEGER = 17976931348623157e292, NAN = 0 / 0;
      var MAX_ARRAY_LENGTH = 4294967295, MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1, HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;
      var wrapFlags = [
        ["ary", WRAP_ARY_FLAG],
        ["bind", WRAP_BIND_FLAG],
        ["bindKey", WRAP_BIND_KEY_FLAG],
        ["curry", WRAP_CURRY_FLAG],
        ["curryRight", WRAP_CURRY_RIGHT_FLAG],
        ["flip", WRAP_FLIP_FLAG],
        ["partial", WRAP_PARTIAL_FLAG],
        ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
        ["rearg", WRAP_REARG_FLAG]
      ];
      var argsTag = "[object Arguments]", arrayTag = "[object Array]", asyncTag = "[object AsyncFunction]", boolTag = "[object Boolean]", dateTag = "[object Date]", domExcTag = "[object DOMException]", errorTag = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag = "[object Map]", numberTag = "[object Number]", nullTag = "[object Null]", objectTag = "[object Object]", promiseTag = "[object Promise]", proxyTag = "[object Proxy]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]", undefinedTag = "[object Undefined]", weakMapTag = "[object WeakMap]", weakSetTag = "[object WeakSet]";
      var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
      var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
      var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g, reUnescapedHtml = /[&<>"']/g, reHasEscapedHtml = RegExp(reEscapedHtml.source), reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
      var reEscape = /<%-([\s\S]+?)%>/g, reEvaluate = /<%([\s\S]+?)%>/g, reInterpolate = /<%=([\s\S]+?)%>/g;
      var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/, rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
      var reRegExpChar = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar.source);
      var reTrimStart = /^\s+/;
      var reWhitespace = /\s/;
      var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/, reSplitDetails = /,? & /;
      var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
      var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
      var reEscapeChar = /\\(\\)?/g;
      var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
      var reFlags = /\w*$/;
      var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
      var reIsBinary = /^0b[01]+$/i;
      var reIsHostCtor = /^\[object .+?Constructor\]$/;
      var reIsOctal = /^0o[0-7]+$/i;
      var reIsUint = /^(?:0|[1-9]\d*)$/;
      var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
      var reNoMatch = /($^)/;
      var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
      var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
      var rsApos = "['\u2019]", rsAstral = "[" + rsAstralRange + "]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
      var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq, rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
      var reApos = RegExp(rsApos, "g");
      var reComboMark = RegExp(rsCombo, "g");
      var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
      var reUnicodeWord = RegExp([
        rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
        rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
        rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
        rsUpper + "+" + rsOptContrUpper,
        rsOrdUpper,
        rsOrdLower,
        rsDigits,
        rsEmoji
      ].join("|"), "g");
      var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
      var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
      var contextProps = [
        "Array",
        "Buffer",
        "DataView",
        "Date",
        "Error",
        "Float32Array",
        "Float64Array",
        "Function",
        "Int8Array",
        "Int16Array",
        "Int32Array",
        "Map",
        "Math",
        "Object",
        "Promise",
        "RegExp",
        "Set",
        "String",
        "Symbol",
        "TypeError",
        "Uint8Array",
        "Uint8ClampedArray",
        "Uint16Array",
        "Uint32Array",
        "WeakMap",
        "_",
        "clearTimeout",
        "isFinite",
        "parseInt",
        "setTimeout"
      ];
      var templateCounter = -1;
      var typedArrayTags = {};
      typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
      typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
      var cloneableTags = {};
      cloneableTags[argsTag] = cloneableTags[arrayTag] = cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] = cloneableTags[boolTag] = cloneableTags[dateTag] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag] = cloneableTags[numberTag] = cloneableTags[objectTag] = cloneableTags[regexpTag] = cloneableTags[setTag] = cloneableTags[stringTag] = cloneableTags[symbolTag] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
      cloneableTags[errorTag] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
      var deburredLetters = {
        // Latin-1 Supplement block.
        "\xC0": "A",
        "\xC1": "A",
        "\xC2": "A",
        "\xC3": "A",
        "\xC4": "A",
        "\xC5": "A",
        "\xE0": "a",
        "\xE1": "a",
        "\xE2": "a",
        "\xE3": "a",
        "\xE4": "a",
        "\xE5": "a",
        "\xC7": "C",
        "\xE7": "c",
        "\xD0": "D",
        "\xF0": "d",
        "\xC8": "E",
        "\xC9": "E",
        "\xCA": "E",
        "\xCB": "E",
        "\xE8": "e",
        "\xE9": "e",
        "\xEA": "e",
        "\xEB": "e",
        "\xCC": "I",
        "\xCD": "I",
        "\xCE": "I",
        "\xCF": "I",
        "\xEC": "i",
        "\xED": "i",
        "\xEE": "i",
        "\xEF": "i",
        "\xD1": "N",
        "\xF1": "n",
        "\xD2": "O",
        "\xD3": "O",
        "\xD4": "O",
        "\xD5": "O",
        "\xD6": "O",
        "\xD8": "O",
        "\xF2": "o",
        "\xF3": "o",
        "\xF4": "o",
        "\xF5": "o",
        "\xF6": "o",
        "\xF8": "o",
        "\xD9": "U",
        "\xDA": "U",
        "\xDB": "U",
        "\xDC": "U",
        "\xF9": "u",
        "\xFA": "u",
        "\xFB": "u",
        "\xFC": "u",
        "\xDD": "Y",
        "\xFD": "y",
        "\xFF": "y",
        "\xC6": "Ae",
        "\xE6": "ae",
        "\xDE": "Th",
        "\xFE": "th",
        "\xDF": "ss",
        // Latin Extended-A block.
        "\u0100": "A",
        "\u0102": "A",
        "\u0104": "A",
        "\u0101": "a",
        "\u0103": "a",
        "\u0105": "a",
        "\u0106": "C",
        "\u0108": "C",
        "\u010A": "C",
        "\u010C": "C",
        "\u0107": "c",
        "\u0109": "c",
        "\u010B": "c",
        "\u010D": "c",
        "\u010E": "D",
        "\u0110": "D",
        "\u010F": "d",
        "\u0111": "d",
        "\u0112": "E",
        "\u0114": "E",
        "\u0116": "E",
        "\u0118": "E",
        "\u011A": "E",
        "\u0113": "e",
        "\u0115": "e",
        "\u0117": "e",
        "\u0119": "e",
        "\u011B": "e",
        "\u011C": "G",
        "\u011E": "G",
        "\u0120": "G",
        "\u0122": "G",
        "\u011D": "g",
        "\u011F": "g",
        "\u0121": "g",
        "\u0123": "g",
        "\u0124": "H",
        "\u0126": "H",
        "\u0125": "h",
        "\u0127": "h",
        "\u0128": "I",
        "\u012A": "I",
        "\u012C": "I",
        "\u012E": "I",
        "\u0130": "I",
        "\u0129": "i",
        "\u012B": "i",
        "\u012D": "i",
        "\u012F": "i",
        "\u0131": "i",
        "\u0134": "J",
        "\u0135": "j",
        "\u0136": "K",
        "\u0137": "k",
        "\u0138": "k",
        "\u0139": "L",
        "\u013B": "L",
        "\u013D": "L",
        "\u013F": "L",
        "\u0141": "L",
        "\u013A": "l",
        "\u013C": "l",
        "\u013E": "l",
        "\u0140": "l",
        "\u0142": "l",
        "\u0143": "N",
        "\u0145": "N",
        "\u0147": "N",
        "\u014A": "N",
        "\u0144": "n",
        "\u0146": "n",
        "\u0148": "n",
        "\u014B": "n",
        "\u014C": "O",
        "\u014E": "O",
        "\u0150": "O",
        "\u014D": "o",
        "\u014F": "o",
        "\u0151": "o",
        "\u0154": "R",
        "\u0156": "R",
        "\u0158": "R",
        "\u0155": "r",
        "\u0157": "r",
        "\u0159": "r",
        "\u015A": "S",
        "\u015C": "S",
        "\u015E": "S",
        "\u0160": "S",
        "\u015B": "s",
        "\u015D": "s",
        "\u015F": "s",
        "\u0161": "s",
        "\u0162": "T",
        "\u0164": "T",
        "\u0166": "T",
        "\u0163": "t",
        "\u0165": "t",
        "\u0167": "t",
        "\u0168": "U",
        "\u016A": "U",
        "\u016C": "U",
        "\u016E": "U",
        "\u0170": "U",
        "\u0172": "U",
        "\u0169": "u",
        "\u016B": "u",
        "\u016D": "u",
        "\u016F": "u",
        "\u0171": "u",
        "\u0173": "u",
        "\u0174": "W",
        "\u0175": "w",
        "\u0176": "Y",
        "\u0177": "y",
        "\u0178": "Y",
        "\u0179": "Z",
        "\u017B": "Z",
        "\u017D": "Z",
        "\u017A": "z",
        "\u017C": "z",
        "\u017E": "z",
        "\u0132": "IJ",
        "\u0133": "ij",
        "\u0152": "Oe",
        "\u0153": "oe",
        "\u0149": "'n",
        "\u017F": "s"
      };
      var htmlEscapes = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#39;"
      };
      var htmlUnescapes = {
        "&amp;": "&",
        "&lt;": "<",
        "&gt;": ">",
        "&quot;": '"',
        "&#39;": "'"
      };
      var stringEscapes = {
        "\\": "\\",
        "'": "'",
        "\n": "n",
        "\r": "r",
        "\u2028": "u2028",
        "\u2029": "u2029"
      };
      var freeParseFloat = parseFloat, freeParseInt = parseInt;
      var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
      var freeSelf = typeof self == "object" && self && self.Object === Object && self;
      var root = freeGlobal || freeSelf || Function("return this")();
      var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
      var freeModule = freeExports && typeof module2 == "object" && module2 && !module2.nodeType && module2;
      var moduleExports = freeModule && freeModule.exports === freeExports;
      var freeProcess = moduleExports && freeGlobal.process;
      var nodeUtil = function() {
        try {
          var types = freeModule && freeModule.require && freeModule.require("util").types;
          if (types) {
            return types;
          }
          return freeProcess && freeProcess.binding && freeProcess.binding("util");
        } catch (e) {
        }
      }();
      var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer, nodeIsDate = nodeUtil && nodeUtil.isDate, nodeIsMap = nodeUtil && nodeUtil.isMap, nodeIsRegExp = nodeUtil && nodeUtil.isRegExp, nodeIsSet = nodeUtil && nodeUtil.isSet, nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
      function apply(func, thisArg, args) {
        switch (args.length) {
          case 0:
            return func.call(thisArg);
          case 1:
            return func.call(thisArg, args[0]);
          case 2:
            return func.call(thisArg, args[0], args[1]);
          case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
        }
        return func.apply(thisArg, args);
      }
      function arrayAggregator(array, setter, iteratee, accumulator) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          var value = array[index];
          setter(accumulator, value, iteratee(value), array);
        }
        return accumulator;
      }
      function arrayEach(array, iteratee) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (iteratee(array[index], index, array) === false) {
            break;
          }
        }
        return array;
      }
      function arrayEachRight(array, iteratee) {
        var length = array == null ? 0 : array.length;
        while (length--) {
          if (iteratee(array[length], length, array) === false) {
            break;
          }
        }
        return array;
      }
      function arrayEvery(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (!predicate(array[index], index, array)) {
            return false;
          }
        }
        return true;
      }
      function arrayFilter(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
        while (++index < length) {
          var value = array[index];
          if (predicate(value, index, array)) {
            result[resIndex++] = value;
          }
        }
        return result;
      }
      function arrayIncludes(array, value) {
        var length = array == null ? 0 : array.length;
        return !!length && baseIndexOf(array, value, 0) > -1;
      }
      function arrayIncludesWith(array, value, comparator) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (comparator(value, array[index])) {
            return true;
          }
        }
        return false;
      }
      function arrayMap(array, iteratee) {
        var index = -1, length = array == null ? 0 : array.length, result = Array(length);
        while (++index < length) {
          result[index] = iteratee(array[index], index, array);
        }
        return result;
      }
      function arrayPush(array, values) {
        var index = -1, length = values.length, offset = array.length;
        while (++index < length) {
          array[offset + index] = values[index];
        }
        return array;
      }
      function arrayReduce(array, iteratee, accumulator, initAccum) {
        var index = -1, length = array == null ? 0 : array.length;
        if (initAccum && length) {
          accumulator = array[++index];
        }
        while (++index < length) {
          accumulator = iteratee(accumulator, array[index], index, array);
        }
        return accumulator;
      }
      function arrayReduceRight(array, iteratee, accumulator, initAccum) {
        var length = array == null ? 0 : array.length;
        if (initAccum && length) {
          accumulator = array[--length];
        }
        while (length--) {
          accumulator = iteratee(accumulator, array[length], length, array);
        }
        return accumulator;
      }
      function arraySome(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (predicate(array[index], index, array)) {
            return true;
          }
        }
        return false;
      }
      var asciiSize = baseProperty("length");
      function asciiToArray(string) {
        return string.split("");
      }
      function asciiWords(string) {
        return string.match(reAsciiWord) || [];
      }
      function baseFindKey(collection, predicate, eachFunc) {
        var result;
        eachFunc(collection, function(value, key, collection2) {
          if (predicate(value, key, collection2)) {
            result = key;
            return false;
          }
        });
        return result;
      }
      function baseFindIndex(array, predicate, fromIndex, fromRight) {
        var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
        while (fromRight ? index-- : ++index < length) {
          if (predicate(array[index], index, array)) {
            return index;
          }
        }
        return -1;
      }
      function baseIndexOf(array, value, fromIndex) {
        return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
      }
      function baseIndexOfWith(array, value, fromIndex, comparator) {
        var index = fromIndex - 1, length = array.length;
        while (++index < length) {
          if (comparator(array[index], value)) {
            return index;
          }
        }
        return -1;
      }
      function baseIsNaN(value) {
        return value !== value;
      }
      function baseMean(array, iteratee) {
        var length = array == null ? 0 : array.length;
        return length ? baseSum(array, iteratee) / length : NAN;
      }
      function baseProperty(key) {
        return function(object) {
          return object == null ? undefined2 : object[key];
        };
      }
      function basePropertyOf(object) {
        return function(key) {
          return object == null ? undefined2 : object[key];
        };
      }
      function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
        eachFunc(collection, function(value, index, collection2) {
          accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index, collection2);
        });
        return accumulator;
      }
      function baseSortBy(array, comparer) {
        var length = array.length;
        array.sort(comparer);
        while (length--) {
          array[length] = array[length].value;
        }
        return array;
      }
      function baseSum(array, iteratee) {
        var result, index = -1, length = array.length;
        while (++index < length) {
          var current = iteratee(array[index]);
          if (current !== undefined2) {
            result = result === undefined2 ? current : result + current;
          }
        }
        return result;
      }
      function baseTimes(n, iteratee) {
        var index = -1, result = Array(n);
        while (++index < n) {
          result[index] = iteratee(index);
        }
        return result;
      }
      function baseToPairs(object, props) {
        return arrayMap(props, function(key) {
          return [key, object[key]];
        });
      }
      function baseTrim(string) {
        return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
      }
      function baseUnary(func) {
        return function(value) {
          return func(value);
        };
      }
      function baseValues(object, props) {
        return arrayMap(props, function(key) {
          return object[key];
        });
      }
      function cacheHas(cache, key) {
        return cache.has(key);
      }
      function charsStartIndex(strSymbols, chrSymbols) {
        var index = -1, length = strSymbols.length;
        while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {
        }
        return index;
      }
      function charsEndIndex(strSymbols, chrSymbols) {
        var index = strSymbols.length;
        while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {
        }
        return index;
      }
      function countHolders(array, placeholder) {
        var length = array.length, result = 0;
        while (length--) {
          if (array[length] === placeholder) {
            ++result;
          }
        }
        return result;
      }
      var deburrLetter = basePropertyOf(deburredLetters);
      var escapeHtmlChar = basePropertyOf(htmlEscapes);
      function escapeStringChar(chr) {
        return "\\" + stringEscapes[chr];
      }
      function getValue(object, key) {
        return object == null ? undefined2 : object[key];
      }
      function hasUnicode(string) {
        return reHasUnicode.test(string);
      }
      function hasUnicodeWord(string) {
        return reHasUnicodeWord.test(string);
      }
      function iteratorToArray(iterator) {
        var data, result = [];
        while (!(data = iterator.next()).done) {
          result.push(data.value);
        }
        return result;
      }
      function mapToArray(map) {
        var index = -1, result = Array(map.size);
        map.forEach(function(value, key) {
          result[++index] = [key, value];
        });
        return result;
      }
      function overArg(func, transform) {
        return function(arg) {
          return func(transform(arg));
        };
      }
      function replaceHolders(array, placeholder) {
        var index = -1, length = array.length, resIndex = 0, result = [];
        while (++index < length) {
          var value = array[index];
          if (value === placeholder || value === PLACEHOLDER) {
            array[index] = PLACEHOLDER;
            result[resIndex++] = index;
          }
        }
        return result;
      }
      function setToArray(set) {
        var index = -1, result = Array(set.size);
        set.forEach(function(value) {
          result[++index] = value;
        });
        return result;
      }
      function setToPairs(set) {
        var index = -1, result = Array(set.size);
        set.forEach(function(value) {
          result[++index] = [value, value];
        });
        return result;
      }
      function strictIndexOf(array, value, fromIndex) {
        var index = fromIndex - 1, length = array.length;
        while (++index < length) {
          if (array[index] === value) {
            return index;
          }
        }
        return -1;
      }
      function strictLastIndexOf(array, value, fromIndex) {
        var index = fromIndex + 1;
        while (index--) {
          if (array[index] === value) {
            return index;
          }
        }
        return index;
      }
      function stringSize(string) {
        return hasUnicode(string) ? unicodeSize(string) : asciiSize(string);
      }
      function stringToArray(string) {
        return hasUnicode(string) ? unicodeToArray(string) : asciiToArray(string);
      }
      function trimmedEndIndex(string) {
        var index = string.length;
        while (index-- && reWhitespace.test(string.charAt(index))) {
        }
        return index;
      }
      var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
      function unicodeSize(string) {
        var result = reUnicode.lastIndex = 0;
        while (reUnicode.test(string)) {
          ++result;
        }
        return result;
      }
      function unicodeToArray(string) {
        return string.match(reUnicode) || [];
      }
      function unicodeWords(string) {
        return string.match(reUnicodeWord) || [];
      }
      var runInContext = function runInContext2(context) {
        context = context == null ? root : _.defaults(root.Object(), context, _.pick(root, contextProps));
        var Array2 = context.Array, Date2 = context.Date, Error2 = context.Error, Function2 = context.Function, Math2 = context.Math, Object2 = context.Object, RegExp2 = context.RegExp, String2 = context.String, TypeError2 = context.TypeError;
        var arrayProto = Array2.prototype, funcProto = Function2.prototype, objectProto = Object2.prototype;
        var coreJsData = context["__core-js_shared__"];
        var funcToString = funcProto.toString;
        var hasOwnProperty = objectProto.hasOwnProperty;
        var idCounter = 0;
        var maskSrcKey = function() {
          var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
          return uid ? "Symbol(src)_1." + uid : "";
        }();
        var nativeObjectToString = objectProto.toString;
        var objectCtorString = funcToString.call(Object2);
        var oldDash = root._;
        var reIsNative = RegExp2(
          "^" + funcToString.call(hasOwnProperty).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
        );
        var Buffer2 = moduleExports ? context.Buffer : undefined2, Symbol2 = context.Symbol, Uint8Array2 = context.Uint8Array, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined2, getPrototype = overArg(Object2.getPrototypeOf, Object2), objectCreate = Object2.create, propertyIsEnumerable = objectProto.propertyIsEnumerable, splice = arrayProto.splice, spreadableSymbol = Symbol2 ? Symbol2.isConcatSpreadable : undefined2, symIterator = Symbol2 ? Symbol2.iterator : undefined2, symToStringTag = Symbol2 ? Symbol2.toStringTag : undefined2;
        var defineProperty = function() {
          try {
            var func = getNative(Object2, "defineProperty");
            func({}, "", {});
            return func;
          } catch (e) {
          }
        }();
        var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout, ctxNow = Date2 && Date2.now !== root.Date.now && Date2.now, ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;
        var nativeCeil = Math2.ceil, nativeFloor = Math2.floor, nativeGetSymbols = Object2.getOwnPropertySymbols, nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined2, nativeIsFinite = context.isFinite, nativeJoin = arrayProto.join, nativeKeys = overArg(Object2.keys, Object2), nativeMax = Math2.max, nativeMin = Math2.min, nativeNow = Date2.now, nativeParseInt = context.parseInt, nativeRandom = Math2.random, nativeReverse = arrayProto.reverse;
        var DataView2 = getNative(context, "DataView"), Map2 = getNative(context, "Map"), Promise2 = getNative(context, "Promise"), Set2 = getNative(context, "Set"), WeakMap = getNative(context, "WeakMap"), nativeCreate = getNative(Object2, "create");
        var metaMap = WeakMap && new WeakMap();
        var realNames = {};
        var dataViewCtorString = toSource(DataView2), mapCtorString = toSource(Map2), promiseCtorString = toSource(Promise2), setCtorString = toSource(Set2), weakMapCtorString = toSource(WeakMap);
        var symbolProto = Symbol2 ? Symbol2.prototype : undefined2, symbolValueOf = symbolProto ? symbolProto.valueOf : undefined2, symbolToString = symbolProto ? symbolProto.toString : undefined2;
        function lodash(value) {
          if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
            if (value instanceof LodashWrapper) {
              return value;
            }
            if (hasOwnProperty.call(value, "__wrapped__")) {
              return wrapperClone(value);
            }
          }
          return new LodashWrapper(value);
        }
        var baseCreate = /* @__PURE__ */ function() {
          function object() {
          }
          return function(proto) {
            if (!isObject(proto)) {
              return {};
            }
            if (objectCreate) {
              return objectCreate(proto);
            }
            object.prototype = proto;
            var result2 = new object();
            object.prototype = undefined2;
            return result2;
          };
        }();
        function baseLodash() {
        }
        function LodashWrapper(value, chainAll) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__chain__ = !!chainAll;
          this.__index__ = 0;
          this.__values__ = undefined2;
        }
        lodash.templateSettings = {
          /**
           * Used to detect `data` property values to be HTML-escaped.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "escape": reEscape,
          /**
           * Used to detect code to be evaluated.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "evaluate": reEvaluate,
          /**
           * Used to detect `data` property values to inject.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "interpolate": reInterpolate,
          /**
           * Used to reference the data object in the template text.
           *
           * @memberOf _.templateSettings
           * @type {string}
           */
          "variable": "",
          /**
           * Used to import variables into the compiled template.
           *
           * @memberOf _.templateSettings
           * @type {Object}
           */
          "imports": {
            /**
             * A reference to the `lodash` function.
             *
             * @memberOf _.templateSettings.imports
             * @type {Function}
             */
            "_": lodash
          }
        };
        lodash.prototype = baseLodash.prototype;
        lodash.prototype.constructor = lodash;
        LodashWrapper.prototype = baseCreate(baseLodash.prototype);
        LodashWrapper.prototype.constructor = LodashWrapper;
        function LazyWrapper(value) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__dir__ = 1;
          this.__filtered__ = false;
          this.__iteratees__ = [];
          this.__takeCount__ = MAX_ARRAY_LENGTH;
          this.__views__ = [];
        }
        function lazyClone() {
          var result2 = new LazyWrapper(this.__wrapped__);
          result2.__actions__ = copyArray(this.__actions__);
          result2.__dir__ = this.__dir__;
          result2.__filtered__ = this.__filtered__;
          result2.__iteratees__ = copyArray(this.__iteratees__);
          result2.__takeCount__ = this.__takeCount__;
          result2.__views__ = copyArray(this.__views__);
          return result2;
        }
        function lazyReverse() {
          if (this.__filtered__) {
            var result2 = new LazyWrapper(this);
            result2.__dir__ = -1;
            result2.__filtered__ = true;
          } else {
            result2 = this.clone();
            result2.__dir__ *= -1;
          }
          return result2;
        }
        function lazyValue() {
          var array = this.__wrapped__.value(), dir = this.__dir__, isArr = isArray(array), isRight = dir < 0, arrLength = isArr ? array.length : 0, view = getView(0, arrLength, this.__views__), start = view.start, end = view.end, length = end - start, index = isRight ? end : start - 1, iteratees = this.__iteratees__, iterLength = iteratees.length, resIndex = 0, takeCount = nativeMin(length, this.__takeCount__);
          if (!isArr || !isRight && arrLength == length && takeCount == length) {
            return baseWrapperValue(array, this.__actions__);
          }
          var result2 = [];
          outer:
            while (length-- && resIndex < takeCount) {
              index += dir;
              var iterIndex = -1, value = array[index];
              while (++iterIndex < iterLength) {
                var data = iteratees[iterIndex], iteratee2 = data.iteratee, type = data.type, computed = iteratee2(value);
                if (type == LAZY_MAP_FLAG) {
                  value = computed;
                } else if (!computed) {
                  if (type == LAZY_FILTER_FLAG) {
                    continue outer;
                  } else {
                    break outer;
                  }
                }
              }
              result2[resIndex++] = value;
            }
          return result2;
        }
        LazyWrapper.prototype = baseCreate(baseLodash.prototype);
        LazyWrapper.prototype.constructor = LazyWrapper;
        function Hash(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function hashClear() {
          this.__data__ = nativeCreate ? nativeCreate(null) : {};
          this.size = 0;
        }
        function hashDelete(key) {
          var result2 = this.has(key) && delete this.__data__[key];
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function hashGet(key) {
          var data = this.__data__;
          if (nativeCreate) {
            var result2 = data[key];
            return result2 === HASH_UNDEFINED ? undefined2 : result2;
          }
          return hasOwnProperty.call(data, key) ? data[key] : undefined2;
        }
        function hashHas(key) {
          var data = this.__data__;
          return nativeCreate ? data[key] !== undefined2 : hasOwnProperty.call(data, key);
        }
        function hashSet(key, value) {
          var data = this.__data__;
          this.size += this.has(key) ? 0 : 1;
          data[key] = nativeCreate && value === undefined2 ? HASH_UNDEFINED : value;
          return this;
        }
        Hash.prototype.clear = hashClear;
        Hash.prototype["delete"] = hashDelete;
        Hash.prototype.get = hashGet;
        Hash.prototype.has = hashHas;
        Hash.prototype.set = hashSet;
        function ListCache(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function listCacheClear() {
          this.__data__ = [];
          this.size = 0;
        }
        function listCacheDelete(key) {
          var data = this.__data__, index = assocIndexOf(data, key);
          if (index < 0) {
            return false;
          }
          var lastIndex = data.length - 1;
          if (index == lastIndex) {
            data.pop();
          } else {
            splice.call(data, index, 1);
          }
          --this.size;
          return true;
        }
        function listCacheGet(key) {
          var data = this.__data__, index = assocIndexOf(data, key);
          return index < 0 ? undefined2 : data[index][1];
        }
        function listCacheHas(key) {
          return assocIndexOf(this.__data__, key) > -1;
        }
        function listCacheSet(key, value) {
          var data = this.__data__, index = assocIndexOf(data, key);
          if (index < 0) {
            ++this.size;
            data.push([key, value]);
          } else {
            data[index][1] = value;
          }
          return this;
        }
        ListCache.prototype.clear = listCacheClear;
        ListCache.prototype["delete"] = listCacheDelete;
        ListCache.prototype.get = listCacheGet;
        ListCache.prototype.has = listCacheHas;
        ListCache.prototype.set = listCacheSet;
        function MapCache(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function mapCacheClear() {
          this.size = 0;
          this.__data__ = {
            "hash": new Hash(),
            "map": new (Map2 || ListCache)(),
            "string": new Hash()
          };
        }
        function mapCacheDelete(key) {
          var result2 = getMapData(this, key)["delete"](key);
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function mapCacheGet(key) {
          return getMapData(this, key).get(key);
        }
        function mapCacheHas(key) {
          return getMapData(this, key).has(key);
        }
        function mapCacheSet(key, value) {
          var data = getMapData(this, key), size2 = data.size;
          data.set(key, value);
          this.size += data.size == size2 ? 0 : 1;
          return this;
        }
        MapCache.prototype.clear = mapCacheClear;
        MapCache.prototype["delete"] = mapCacheDelete;
        MapCache.prototype.get = mapCacheGet;
        MapCache.prototype.has = mapCacheHas;
        MapCache.prototype.set = mapCacheSet;
        function SetCache(values2) {
          var index = -1, length = values2 == null ? 0 : values2.length;
          this.__data__ = new MapCache();
          while (++index < length) {
            this.add(values2[index]);
          }
        }
        function setCacheAdd(value) {
          this.__data__.set(value, HASH_UNDEFINED);
          return this;
        }
        function setCacheHas(value) {
          return this.__data__.has(value);
        }
        SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
        SetCache.prototype.has = setCacheHas;
        function Stack(entries) {
          var data = this.__data__ = new ListCache(entries);
          this.size = data.size;
        }
        function stackClear() {
          this.__data__ = new ListCache();
          this.size = 0;
        }
        function stackDelete(key) {
          var data = this.__data__, result2 = data["delete"](key);
          this.size = data.size;
          return result2;
        }
        function stackGet(key) {
          return this.__data__.get(key);
        }
        function stackHas(key) {
          return this.__data__.has(key);
        }
        function stackSet(key, value) {
          var data = this.__data__;
          if (data instanceof ListCache) {
            var pairs = data.__data__;
            if (!Map2 || pairs.length < LARGE_ARRAY_SIZE - 1) {
              pairs.push([key, value]);
              this.size = ++data.size;
              return this;
            }
            data = this.__data__ = new MapCache(pairs);
          }
          data.set(key, value);
          this.size = data.size;
          return this;
        }
        Stack.prototype.clear = stackClear;
        Stack.prototype["delete"] = stackDelete;
        Stack.prototype.get = stackGet;
        Stack.prototype.has = stackHas;
        Stack.prototype.set = stackSet;
        function arrayLikeKeys(value, inherited) {
          var isArr = isArray(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result2 = skipIndexes ? baseTimes(value.length, String2) : [], length = result2.length;
          for (var key in value) {
            if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
            (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
            isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
            isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
            isIndex(key, length)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function arraySample(array) {
          var length = array.length;
          return length ? array[baseRandom(0, length - 1)] : undefined2;
        }
        function arraySampleSize(array, n) {
          return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
        }
        function arrayShuffle(array) {
          return shuffleSelf(copyArray(array));
        }
        function assignMergeValue(object, key, value) {
          if (value !== undefined2 && !eq(object[key], value) || value === undefined2 && !(key in object)) {
            baseAssignValue(object, key, value);
          }
        }
        function assignValue(object, key, value) {
          var objValue = object[key];
          if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) || value === undefined2 && !(key in object)) {
            baseAssignValue(object, key, value);
          }
        }
        function assocIndexOf(array, key) {
          var length = array.length;
          while (length--) {
            if (eq(array[length][0], key)) {
              return length;
            }
          }
          return -1;
        }
        function baseAggregator(collection, setter, iteratee2, accumulator) {
          baseEach(collection, function(value, key, collection2) {
            setter(accumulator, value, iteratee2(value), collection2);
          });
          return accumulator;
        }
        function baseAssign(object, source) {
          return object && copyObject(source, keys(source), object);
        }
        function baseAssignIn(object, source) {
          return object && copyObject(source, keysIn(source), object);
        }
        function baseAssignValue(object, key, value) {
          if (key == "__proto__" && defineProperty) {
            defineProperty(object, key, {
              "configurable": true,
              "enumerable": true,
              "value": value,
              "writable": true
            });
          } else {
            object[key] = value;
          }
        }
        function baseAt(object, paths) {
          var index = -1, length = paths.length, result2 = Array2(length), skip = object == null;
          while (++index < length) {
            result2[index] = skip ? undefined2 : get(object, paths[index]);
          }
          return result2;
        }
        function baseClamp(number, lower, upper) {
          if (number === number) {
            if (upper !== undefined2) {
              number = number <= upper ? number : upper;
            }
            if (lower !== undefined2) {
              number = number >= lower ? number : lower;
            }
          }
          return number;
        }
        function baseClone(value, bitmask, customizer, key, object, stack) {
          var result2, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
          if (customizer) {
            result2 = object ? customizer(value, key, object, stack) : customizer(value);
          }
          if (result2 !== undefined2) {
            return result2;
          }
          if (!isObject(value)) {
            return value;
          }
          var isArr = isArray(value);
          if (isArr) {
            result2 = initCloneArray(value);
            if (!isDeep) {
              return copyArray(value, result2);
            }
          } else {
            var tag = getTag(value), isFunc = tag == funcTag || tag == genTag;
            if (isBuffer(value)) {
              return cloneBuffer(value, isDeep);
            }
            if (tag == objectTag || tag == argsTag || isFunc && !object) {
              result2 = isFlat || isFunc ? {} : initCloneObject(value);
              if (!isDeep) {
                return isFlat ? copySymbolsIn(value, baseAssignIn(result2, value)) : copySymbols(value, baseAssign(result2, value));
              }
            } else {
              if (!cloneableTags[tag]) {
                return object ? value : {};
              }
              result2 = initCloneByTag(value, tag, isDeep);
            }
          }
          stack || (stack = new Stack());
          var stacked = stack.get(value);
          if (stacked) {
            return stacked;
          }
          stack.set(value, result2);
          if (isSet(value)) {
            value.forEach(function(subValue) {
              result2.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
            });
          } else if (isMap(value)) {
            value.forEach(function(subValue, key2) {
              result2.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
            });
          }
          var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys;
          var props = isArr ? undefined2 : keysFunc(value);
          arrayEach(props || value, function(subValue, key2) {
            if (props) {
              key2 = subValue;
              subValue = value[key2];
            }
            assignValue(result2, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
          });
          return result2;
        }
        function baseConforms(source) {
          var props = keys(source);
          return function(object) {
            return baseConformsTo(object, source, props);
          };
        }
        function baseConformsTo(object, source, props) {
          var length = props.length;
          if (object == null) {
            return !length;
          }
          object = Object2(object);
          while (length--) {
            var key = props[length], predicate = source[key], value = object[key];
            if (value === undefined2 && !(key in object) || !predicate(value)) {
              return false;
            }
          }
          return true;
        }
        function baseDelay(func, wait, args) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          return setTimeout2(function() {
            func.apply(undefined2, args);
          }, wait);
        }
        function baseDifference(array, values2, iteratee2, comparator) {
          var index = -1, includes2 = arrayIncludes, isCommon = true, length = array.length, result2 = [], valuesLength = values2.length;
          if (!length) {
            return result2;
          }
          if (iteratee2) {
            values2 = arrayMap(values2, baseUnary(iteratee2));
          }
          if (comparator) {
            includes2 = arrayIncludesWith;
            isCommon = false;
          } else if (values2.length >= LARGE_ARRAY_SIZE) {
            includes2 = cacheHas;
            isCommon = false;
            values2 = new SetCache(values2);
          }
          outer:
            while (++index < length) {
              var value = array[index], computed = iteratee2 == null ? value : iteratee2(value);
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var valuesIndex = valuesLength;
                while (valuesIndex--) {
                  if (values2[valuesIndex] === computed) {
                    continue outer;
                  }
                }
                result2.push(value);
              } else if (!includes2(values2, computed, comparator)) {
                result2.push(value);
              }
            }
          return result2;
        }
        var baseEach = createBaseEach(baseForOwn);
        var baseEachRight = createBaseEach(baseForOwnRight, true);
        function baseEvery(collection, predicate) {
          var result2 = true;
          baseEach(collection, function(value, index, collection2) {
            result2 = !!predicate(value, index, collection2);
            return result2;
          });
          return result2;
        }
        function baseExtremum(array, iteratee2, comparator) {
          var index = -1, length = array.length;
          while (++index < length) {
            var value = array[index], current = iteratee2(value);
            if (current != null && (computed === undefined2 ? current === current && !isSymbol(current) : comparator(current, computed))) {
              var computed = current, result2 = value;
            }
          }
          return result2;
        }
        function baseFill(array, value, start, end) {
          var length = array.length;
          start = toInteger(start);
          if (start < 0) {
            start = -start > length ? 0 : length + start;
          }
          end = end === undefined2 || end > length ? length : toInteger(end);
          if (end < 0) {
            end += length;
          }
          end = start > end ? 0 : toLength(end);
          while (start < end) {
            array[start++] = value;
          }
          return array;
        }
        function baseFilter(collection, predicate) {
          var result2 = [];
          baseEach(collection, function(value, index, collection2) {
            if (predicate(value, index, collection2)) {
              result2.push(value);
            }
          });
          return result2;
        }
        function baseFlatten(array, depth, predicate, isStrict, result2) {
          var index = -1, length = array.length;
          predicate || (predicate = isFlattenable);
          result2 || (result2 = []);
          while (++index < length) {
            var value = array[index];
            if (depth > 0 && predicate(value)) {
              if (depth > 1) {
                baseFlatten(value, depth - 1, predicate, isStrict, result2);
              } else {
                arrayPush(result2, value);
              }
            } else if (!isStrict) {
              result2[result2.length] = value;
            }
          }
          return result2;
        }
        var baseFor = createBaseFor();
        var baseForRight = createBaseFor(true);
        function baseForOwn(object, iteratee2) {
          return object && baseFor(object, iteratee2, keys);
        }
        function baseForOwnRight(object, iteratee2) {
          return object && baseForRight(object, iteratee2, keys);
        }
        function baseFunctions(object, props) {
          return arrayFilter(props, function(key) {
            return isFunction(object[key]);
          });
        }
        function baseGet(object, path4) {
          path4 = castPath(path4, object);
          var index = 0, length = path4.length;
          while (object != null && index < length) {
            object = object[toKey(path4[index++])];
          }
          return index && index == length ? object : undefined2;
        }
        function baseGetAllKeys(object, keysFunc, symbolsFunc) {
          var result2 = keysFunc(object);
          return isArray(object) ? result2 : arrayPush(result2, symbolsFunc(object));
        }
        function baseGetTag(value) {
          if (value == null) {
            return value === undefined2 ? undefinedTag : nullTag;
          }
          return symToStringTag && symToStringTag in Object2(value) ? getRawTag(value) : objectToString(value);
        }
        function baseGt(value, other) {
          return value > other;
        }
        function baseHas(object, key) {
          return object != null && hasOwnProperty.call(object, key);
        }
        function baseHasIn(object, key) {
          return object != null && key in Object2(object);
        }
        function baseInRange(number, start, end) {
          return number >= nativeMin(start, end) && number < nativeMax(start, end);
        }
        function baseIntersection(arrays, iteratee2, comparator) {
          var includes2 = comparator ? arrayIncludesWith : arrayIncludes, length = arrays[0].length, othLength = arrays.length, othIndex = othLength, caches = Array2(othLength), maxLength = Infinity, result2 = [];
          while (othIndex--) {
            var array = arrays[othIndex];
            if (othIndex && iteratee2) {
              array = arrayMap(array, baseUnary(iteratee2));
            }
            maxLength = nativeMin(array.length, maxLength);
            caches[othIndex] = !comparator && (iteratee2 || length >= 120 && array.length >= 120) ? new SetCache(othIndex && array) : undefined2;
          }
          array = arrays[0];
          var index = -1, seen = caches[0];
          outer:
            while (++index < length && result2.length < maxLength) {
              var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (!(seen ? cacheHas(seen, computed) : includes2(result2, computed, comparator))) {
                othIndex = othLength;
                while (--othIndex) {
                  var cache = caches[othIndex];
                  if (!(cache ? cacheHas(cache, computed) : includes2(arrays[othIndex], computed, comparator))) {
                    continue outer;
                  }
                }
                if (seen) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseInverter(object, setter, iteratee2, accumulator) {
          baseForOwn(object, function(value, key, object2) {
            setter(accumulator, iteratee2(value), key, object2);
          });
          return accumulator;
        }
        function baseInvoke(object, path4, args) {
          path4 = castPath(path4, object);
          object = parent(object, path4);
          var func = object == null ? object : object[toKey(last(path4))];
          return func == null ? undefined2 : apply(func, object, args);
        }
        function baseIsArguments(value) {
          return isObjectLike(value) && baseGetTag(value) == argsTag;
        }
        function baseIsArrayBuffer(value) {
          return isObjectLike(value) && baseGetTag(value) == arrayBufferTag;
        }
        function baseIsDate(value) {
          return isObjectLike(value) && baseGetTag(value) == dateTag;
        }
        function baseIsEqual(value, other, bitmask, customizer, stack) {
          if (value === other) {
            return true;
          }
          if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
            return value !== value && other !== other;
          }
          return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
        }
        function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
          var objIsArr = isArray(object), othIsArr = isArray(other), objTag = objIsArr ? arrayTag : getTag(object), othTag = othIsArr ? arrayTag : getTag(other);
          objTag = objTag == argsTag ? objectTag : objTag;
          othTag = othTag == argsTag ? objectTag : othTag;
          var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
          if (isSameTag && isBuffer(object)) {
            if (!isBuffer(other)) {
              return false;
            }
            objIsArr = true;
            objIsObj = false;
          }
          if (isSameTag && !objIsObj) {
            stack || (stack = new Stack());
            return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
          }
          if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
            var objIsWrapped = objIsObj && hasOwnProperty.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty.call(other, "__wrapped__");
            if (objIsWrapped || othIsWrapped) {
              var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
              stack || (stack = new Stack());
              return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
            }
          }
          if (!isSameTag) {
            return false;
          }
          stack || (stack = new Stack());
          return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
        }
        function baseIsMap(value) {
          return isObjectLike(value) && getTag(value) == mapTag;
        }
        function baseIsMatch(object, source, matchData, customizer) {
          var index = matchData.length, length = index, noCustomizer = !customizer;
          if (object == null) {
            return !length;
          }
          object = Object2(object);
          while (index--) {
            var data = matchData[index];
            if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
              return false;
            }
          }
          while (++index < length) {
            data = matchData[index];
            var key = data[0], objValue = object[key], srcValue = data[1];
            if (noCustomizer && data[2]) {
              if (objValue === undefined2 && !(key in object)) {
                return false;
              }
            } else {
              var stack = new Stack();
              if (customizer) {
                var result2 = customizer(objValue, srcValue, key, object, source, stack);
              }
              if (!(result2 === undefined2 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack) : result2)) {
                return false;
              }
            }
          }
          return true;
        }
        function baseIsNative(value) {
          if (!isObject(value) || isMasked(value)) {
            return false;
          }
          var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
          return pattern.test(toSource(value));
        }
        function baseIsRegExp(value) {
          return isObjectLike(value) && baseGetTag(value) == regexpTag;
        }
        function baseIsSet(value) {
          return isObjectLike(value) && getTag(value) == setTag;
        }
        function baseIsTypedArray(value) {
          return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
        }
        function baseIteratee(value) {
          if (typeof value == "function") {
            return value;
          }
          if (value == null) {
            return identity;
          }
          if (typeof value == "object") {
            return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
          }
          return property(value);
        }
        function baseKeys(object) {
          if (!isPrototype(object)) {
            return nativeKeys(object);
          }
          var result2 = [];
          for (var key in Object2(object)) {
            if (hasOwnProperty.call(object, key) && key != "constructor") {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseKeysIn(object) {
          if (!isObject(object)) {
            return nativeKeysIn(object);
          }
          var isProto = isPrototype(object), result2 = [];
          for (var key in object) {
            if (!(key == "constructor" && (isProto || !hasOwnProperty.call(object, key)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseLt(value, other) {
          return value < other;
        }
        function baseMap(collection, iteratee2) {
          var index = -1, result2 = isArrayLike(collection) ? Array2(collection.length) : [];
          baseEach(collection, function(value, key, collection2) {
            result2[++index] = iteratee2(value, key, collection2);
          });
          return result2;
        }
        function baseMatches(source) {
          var matchData = getMatchData(source);
          if (matchData.length == 1 && matchData[0][2]) {
            return matchesStrictComparable(matchData[0][0], matchData[0][1]);
          }
          return function(object) {
            return object === source || baseIsMatch(object, source, matchData);
          };
        }
        function baseMatchesProperty(path4, srcValue) {
          if (isKey(path4) && isStrictComparable(srcValue)) {
            return matchesStrictComparable(toKey(path4), srcValue);
          }
          return function(object) {
            var objValue = get(object, path4);
            return objValue === undefined2 && objValue === srcValue ? hasIn(object, path4) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
          };
        }
        function baseMerge(object, source, srcIndex, customizer, stack) {
          if (object === source) {
            return;
          }
          baseFor(source, function(srcValue, key) {
            stack || (stack = new Stack());
            if (isObject(srcValue)) {
              baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
            } else {
              var newValue = customizer ? customizer(safeGet(object, key), srcValue, key + "", object, source, stack) : undefined2;
              if (newValue === undefined2) {
                newValue = srcValue;
              }
              assignMergeValue(object, key, newValue);
            }
          }, keysIn);
        }
        function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
          var objValue = safeGet(object, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
          if (stacked) {
            assignMergeValue(object, key, stacked);
            return;
          }
          var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack) : undefined2;
          var isCommon = newValue === undefined2;
          if (isCommon) {
            var isArr = isArray(srcValue), isBuff = !isArr && isBuffer(srcValue), isTyped = !isArr && !isBuff && isTypedArray(srcValue);
            newValue = srcValue;
            if (isArr || isBuff || isTyped) {
              if (isArray(objValue)) {
                newValue = objValue;
              } else if (isArrayLikeObject(objValue)) {
                newValue = copyArray(objValue);
              } else if (isBuff) {
                isCommon = false;
                newValue = cloneBuffer(srcValue, true);
              } else if (isTyped) {
                isCommon = false;
                newValue = cloneTypedArray(srcValue, true);
              } else {
                newValue = [];
              }
            } else if (isPlainObject(srcValue) || isArguments(srcValue)) {
              newValue = objValue;
              if (isArguments(objValue)) {
                newValue = toPlainObject(objValue);
              } else if (!isObject(objValue) || isFunction(objValue)) {
                newValue = initCloneObject(srcValue);
              }
            } else {
              isCommon = false;
            }
          }
          if (isCommon) {
            stack.set(srcValue, newValue);
            mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
            stack["delete"](srcValue);
          }
          assignMergeValue(object, key, newValue);
        }
        function baseNth(array, n) {
          var length = array.length;
          if (!length) {
            return;
          }
          n += n < 0 ? length : 0;
          return isIndex(n, length) ? array[n] : undefined2;
        }
        function baseOrderBy(collection, iteratees, orders) {
          if (iteratees.length) {
            iteratees = arrayMap(iteratees, function(iteratee2) {
              if (isArray(iteratee2)) {
                return function(value) {
                  return baseGet(value, iteratee2.length === 1 ? iteratee2[0] : iteratee2);
                };
              }
              return iteratee2;
            });
          } else {
            iteratees = [identity];
          }
          var index = -1;
          iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
          var result2 = baseMap(collection, function(value, key, collection2) {
            var criteria = arrayMap(iteratees, function(iteratee2) {
              return iteratee2(value);
            });
            return { "criteria": criteria, "index": ++index, "value": value };
          });
          return baseSortBy(result2, function(object, other) {
            return compareMultiple(object, other, orders);
          });
        }
        function basePick(object, paths) {
          return basePickBy(object, paths, function(value, path4) {
            return hasIn(object, path4);
          });
        }
        function basePickBy(object, paths, predicate) {
          var index = -1, length = paths.length, result2 = {};
          while (++index < length) {
            var path4 = paths[index], value = baseGet(object, path4);
            if (predicate(value, path4)) {
              baseSet(result2, castPath(path4, object), value);
            }
          }
          return result2;
        }
        function basePropertyDeep(path4) {
          return function(object) {
            return baseGet(object, path4);
          };
        }
        function basePullAll(array, values2, iteratee2, comparator) {
          var indexOf2 = comparator ? baseIndexOfWith : baseIndexOf, index = -1, length = values2.length, seen = array;
          if (array === values2) {
            values2 = copyArray(values2);
          }
          if (iteratee2) {
            seen = arrayMap(array, baseUnary(iteratee2));
          }
          while (++index < length) {
            var fromIndex = 0, value = values2[index], computed = iteratee2 ? iteratee2(value) : value;
            while ((fromIndex = indexOf2(seen, computed, fromIndex, comparator)) > -1) {
              if (seen !== array) {
                splice.call(seen, fromIndex, 1);
              }
              splice.call(array, fromIndex, 1);
            }
          }
          return array;
        }
        function basePullAt(array, indexes) {
          var length = array ? indexes.length : 0, lastIndex = length - 1;
          while (length--) {
            var index = indexes[length];
            if (length == lastIndex || index !== previous) {
              var previous = index;
              if (isIndex(index)) {
                splice.call(array, index, 1);
              } else {
                baseUnset(array, index);
              }
            }
          }
          return array;
        }
        function baseRandom(lower, upper) {
          return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
        }
        function baseRange(start, end, step, fromRight) {
          var index = -1, length = nativeMax(nativeCeil((end - start) / (step || 1)), 0), result2 = Array2(length);
          while (length--) {
            result2[fromRight ? length : ++index] = start;
            start += step;
          }
          return result2;
        }
        function baseRepeat(string, n) {
          var result2 = "";
          if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
            return result2;
          }
          do {
            if (n % 2) {
              result2 += string;
            }
            n = nativeFloor(n / 2);
            if (n) {
              string += string;
            }
          } while (n);
          return result2;
        }
        function baseRest(func, start) {
          return setToString(overRest(func, start, identity), func + "");
        }
        function baseSample(collection) {
          return arraySample(values(collection));
        }
        function baseSampleSize(collection, n) {
          var array = values(collection);
          return shuffleSelf(array, baseClamp(n, 0, array.length));
        }
        function baseSet(object, path4, value, customizer) {
          if (!isObject(object)) {
            return object;
          }
          path4 = castPath(path4, object);
          var index = -1, length = path4.length, lastIndex = length - 1, nested = object;
          while (nested != null && ++index < length) {
            var key = toKey(path4[index]), newValue = value;
            if (key === "__proto__" || key === "constructor" || key === "prototype") {
              return object;
            }
            if (index != lastIndex) {
              var objValue = nested[key];
              newValue = customizer ? customizer(objValue, key, nested) : undefined2;
              if (newValue === undefined2) {
                newValue = isObject(objValue) ? objValue : isIndex(path4[index + 1]) ? [] : {};
              }
            }
            assignValue(nested, key, newValue);
            nested = nested[key];
          }
          return object;
        }
        var baseSetData = !metaMap ? identity : function(func, data) {
          metaMap.set(func, data);
          return func;
        };
        var baseSetToString = !defineProperty ? identity : function(func, string) {
          return defineProperty(func, "toString", {
            "configurable": true,
            "enumerable": false,
            "value": constant(string),
            "writable": true
          });
        };
        function baseShuffle(collection) {
          return shuffleSelf(values(collection));
        }
        function baseSlice(array, start, end) {
          var index = -1, length = array.length;
          if (start < 0) {
            start = -start > length ? 0 : length + start;
          }
          end = end > length ? length : end;
          if (end < 0) {
            end += length;
          }
          length = start > end ? 0 : end - start >>> 0;
          start >>>= 0;
          var result2 = Array2(length);
          while (++index < length) {
            result2[index] = array[index + start];
          }
          return result2;
        }
        function baseSome(collection, predicate) {
          var result2;
          baseEach(collection, function(value, index, collection2) {
            result2 = predicate(value, index, collection2);
            return !result2;
          });
          return !!result2;
        }
        function baseSortedIndex(array, value, retHighest) {
          var low = 0, high = array == null ? low : array.length;
          if (typeof value == "number" && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
            while (low < high) {
              var mid = low + high >>> 1, computed = array[mid];
              if (computed !== null && !isSymbol(computed) && (retHighest ? computed <= value : computed < value)) {
                low = mid + 1;
              } else {
                high = mid;
              }
            }
            return high;
          }
          return baseSortedIndexBy(array, value, identity, retHighest);
        }
        function baseSortedIndexBy(array, value, iteratee2, retHighest) {
          var low = 0, high = array == null ? 0 : array.length;
          if (high === 0) {
            return 0;
          }
          value = iteratee2(value);
          var valIsNaN = value !== value, valIsNull = value === null, valIsSymbol = isSymbol(value), valIsUndefined = value === undefined2;
          while (low < high) {
            var mid = nativeFloor((low + high) / 2), computed = iteratee2(array[mid]), othIsDefined = computed !== undefined2, othIsNull = computed === null, othIsReflexive = computed === computed, othIsSymbol = isSymbol(computed);
            if (valIsNaN) {
              var setLow = retHighest || othIsReflexive;
            } else if (valIsUndefined) {
              setLow = othIsReflexive && (retHighest || othIsDefined);
            } else if (valIsNull) {
              setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
            } else if (valIsSymbol) {
              setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
            } else if (othIsNull || othIsSymbol) {
              setLow = false;
            } else {
              setLow = retHighest ? computed <= value : computed < value;
            }
            if (setLow) {
              low = mid + 1;
            } else {
              high = mid;
            }
          }
          return nativeMin(high, MAX_ARRAY_INDEX);
        }
        function baseSortedUniq(array, iteratee2) {
          var index = -1, length = array.length, resIndex = 0, result2 = [];
          while (++index < length) {
            var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
            if (!index || !eq(computed, seen)) {
              var seen = computed;
              result2[resIndex++] = value === 0 ? 0 : value;
            }
          }
          return result2;
        }
        function baseToNumber(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol(value)) {
            return NAN;
          }
          return +value;
        }
        function baseToString(value) {
          if (typeof value == "string") {
            return value;
          }
          if (isArray(value)) {
            return arrayMap(value, baseToString) + "";
          }
          if (isSymbol(value)) {
            return symbolToString ? symbolToString.call(value) : "";
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
        }
        function baseUniq(array, iteratee2, comparator) {
          var index = -1, includes2 = arrayIncludes, length = array.length, isCommon = true, result2 = [], seen = result2;
          if (comparator) {
            isCommon = false;
            includes2 = arrayIncludesWith;
          } else if (length >= LARGE_ARRAY_SIZE) {
            var set2 = iteratee2 ? null : createSet(array);
            if (set2) {
              return setToArray(set2);
            }
            isCommon = false;
            includes2 = cacheHas;
            seen = new SetCache();
          } else {
            seen = iteratee2 ? [] : result2;
          }
          outer:
            while (++index < length) {
              var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var seenIndex = seen.length;
                while (seenIndex--) {
                  if (seen[seenIndex] === computed) {
                    continue outer;
                  }
                }
                if (iteratee2) {
                  seen.push(computed);
                }
                result2.push(value);
              } else if (!includes2(seen, computed, comparator)) {
                if (seen !== result2) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseUnset(object, path4) {
          path4 = castPath(path4, object);
          object = parent(object, path4);
          return object == null || delete object[toKey(last(path4))];
        }
        function baseUpdate(object, path4, updater, customizer) {
          return baseSet(object, path4, updater(baseGet(object, path4)), customizer);
        }
        function baseWhile(array, predicate, isDrop, fromRight) {
          var length = array.length, index = fromRight ? length : -1;
          while ((fromRight ? index-- : ++index < length) && predicate(array[index], index, array)) {
          }
          return isDrop ? baseSlice(array, fromRight ? 0 : index, fromRight ? index + 1 : length) : baseSlice(array, fromRight ? index + 1 : 0, fromRight ? length : index);
        }
        function baseWrapperValue(value, actions) {
          var result2 = value;
          if (result2 instanceof LazyWrapper) {
            result2 = result2.value();
          }
          return arrayReduce(actions, function(result3, action) {
            return action.func.apply(action.thisArg, arrayPush([result3], action.args));
          }, result2);
        }
        function baseXor(arrays, iteratee2, comparator) {
          var length = arrays.length;
          if (length < 2) {
            return length ? baseUniq(arrays[0]) : [];
          }
          var index = -1, result2 = Array2(length);
          while (++index < length) {
            var array = arrays[index], othIndex = -1;
            while (++othIndex < length) {
              if (othIndex != index) {
                result2[index] = baseDifference(result2[index] || array, arrays[othIndex], iteratee2, comparator);
              }
            }
          }
          return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
        }
        function baseZipObject(props, values2, assignFunc) {
          var index = -1, length = props.length, valsLength = values2.length, result2 = {};
          while (++index < length) {
            var value = index < valsLength ? values2[index] : undefined2;
            assignFunc(result2, props[index], value);
          }
          return result2;
        }
        function castArrayLikeObject(value) {
          return isArrayLikeObject(value) ? value : [];
        }
        function castFunction(value) {
          return typeof value == "function" ? value : identity;
        }
        function castPath(value, object) {
          if (isArray(value)) {
            return value;
          }
          return isKey(value, object) ? [value] : stringToPath(toString(value));
        }
        var castRest = baseRest;
        function castSlice(array, start, end) {
          var length = array.length;
          end = end === undefined2 ? length : end;
          return !start && end >= length ? array : baseSlice(array, start, end);
        }
        var clearTimeout2 = ctxClearTimeout || function(id) {
          return root.clearTimeout(id);
        };
        function cloneBuffer(buffer, isDeep) {
          if (isDeep) {
            return buffer.slice();
          }
          var length = buffer.length, result2 = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
          buffer.copy(result2);
          return result2;
        }
        function cloneArrayBuffer(arrayBuffer) {
          var result2 = new arrayBuffer.constructor(arrayBuffer.byteLength);
          new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
          return result2;
        }
        function cloneDataView(dataView, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
          return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
        }
        function cloneRegExp(regexp) {
          var result2 = new regexp.constructor(regexp.source, reFlags.exec(regexp));
          result2.lastIndex = regexp.lastIndex;
          return result2;
        }
        function cloneSymbol(symbol) {
          return symbolValueOf ? Object2(symbolValueOf.call(symbol)) : {};
        }
        function cloneTypedArray(typedArray, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
          return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
        }
        function compareAscending(value, other) {
          if (value !== other) {
            var valIsDefined = value !== undefined2, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol(value);
            var othIsDefined = other !== undefined2, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol(other);
            if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
              return 1;
            }
            if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
              return -1;
            }
          }
          return 0;
        }
        function compareMultiple(object, other, orders) {
          var index = -1, objCriteria = object.criteria, othCriteria = other.criteria, length = objCriteria.length, ordersLength = orders.length;
          while (++index < length) {
            var result2 = compareAscending(objCriteria[index], othCriteria[index]);
            if (result2) {
              if (index >= ordersLength) {
                return result2;
              }
              var order = orders[index];
              return result2 * (order == "desc" ? -1 : 1);
            }
          }
          return object.index - other.index;
        }
        function composeArgs(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersLength = holders.length, leftIndex = -1, leftLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(leftLength + rangeLength), isUncurried = !isCurried;
          while (++leftIndex < leftLength) {
            result2[leftIndex] = partials[leftIndex];
          }
          while (++argsIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[holders[argsIndex]] = args[argsIndex];
            }
          }
          while (rangeLength--) {
            result2[leftIndex++] = args[argsIndex++];
          }
          return result2;
        }
        function composeArgsRight(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersIndex = -1, holdersLength = holders.length, rightIndex = -1, rightLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(rangeLength + rightLength), isUncurried = !isCurried;
          while (++argsIndex < rangeLength) {
            result2[argsIndex] = args[argsIndex];
          }
          var offset = argsIndex;
          while (++rightIndex < rightLength) {
            result2[offset + rightIndex] = partials[rightIndex];
          }
          while (++holdersIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[offset + holders[holdersIndex]] = args[argsIndex++];
            }
          }
          return result2;
        }
        function copyArray(source, array) {
          var index = -1, length = source.length;
          array || (array = Array2(length));
          while (++index < length) {
            array[index] = source[index];
          }
          return array;
        }
        function copyObject(source, props, object, customizer) {
          var isNew = !object;
          object || (object = {});
          var index = -1, length = props.length;
          while (++index < length) {
            var key = props[index];
            var newValue = customizer ? customizer(object[key], source[key], key, object, source) : undefined2;
            if (newValue === undefined2) {
              newValue = source[key];
            }
            if (isNew) {
              baseAssignValue(object, key, newValue);
            } else {
              assignValue(object, key, newValue);
            }
          }
          return object;
        }
        function copySymbols(source, object) {
          return copyObject(source, getSymbols(source), object);
        }
        function copySymbolsIn(source, object) {
          return copyObject(source, getSymbolsIn(source), object);
        }
        function createAggregator(setter, initializer) {
          return function(collection, iteratee2) {
            var func = isArray(collection) ? arrayAggregator : baseAggregator, accumulator = initializer ? initializer() : {};
            return func(collection, setter, getIteratee(iteratee2, 2), accumulator);
          };
        }
        function createAssigner(assigner) {
          return baseRest(function(object, sources) {
            var index = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : undefined2, guard = length > 2 ? sources[2] : undefined2;
            customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : undefined2;
            if (guard && isIterateeCall(sources[0], sources[1], guard)) {
              customizer = length < 3 ? undefined2 : customizer;
              length = 1;
            }
            object = Object2(object);
            while (++index < length) {
              var source = sources[index];
              if (source) {
                assigner(object, source, index, customizer);
              }
            }
            return object;
          });
        }
        function createBaseEach(eachFunc, fromRight) {
          return function(collection, iteratee2) {
            if (collection == null) {
              return collection;
            }
            if (!isArrayLike(collection)) {
              return eachFunc(collection, iteratee2);
            }
            var length = collection.length, index = fromRight ? length : -1, iterable = Object2(collection);
            while (fromRight ? index-- : ++index < length) {
              if (iteratee2(iterable[index], index, iterable) === false) {
                break;
              }
            }
            return collection;
          };
        }
        function createBaseFor(fromRight) {
          return function(object, iteratee2, keysFunc) {
            var index = -1, iterable = Object2(object), props = keysFunc(object), length = props.length;
            while (length--) {
              var key = props[fromRight ? length : ++index];
              if (iteratee2(iterable[key], key, iterable) === false) {
                break;
              }
            }
            return object;
          };
        }
        function createBind(func, bitmask, thisArg) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            return fn.apply(isBind ? thisArg : this, arguments);
          }
          return wrapper;
        }
        function createCaseFirst(methodName) {
          return function(string) {
            string = toString(string);
            var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined2;
            var chr = strSymbols ? strSymbols[0] : string.charAt(0);
            var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string.slice(1);
            return chr[methodName]() + trailing;
          };
        }
        function createCompounder(callback) {
          return function(string) {
            return arrayReduce(words(deburr(string).replace(reApos, "")), callback, "");
          };
        }
        function createCtor(Ctor) {
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return new Ctor();
              case 1:
                return new Ctor(args[0]);
              case 2:
                return new Ctor(args[0], args[1]);
              case 3:
                return new Ctor(args[0], args[1], args[2]);
              case 4:
                return new Ctor(args[0], args[1], args[2], args[3]);
              case 5:
                return new Ctor(args[0], args[1], args[2], args[3], args[4]);
              case 6:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
              case 7:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            var thisBinding = baseCreate(Ctor.prototype), result2 = Ctor.apply(thisBinding, args);
            return isObject(result2) ? result2 : thisBinding;
          };
        }
        function createCurry(func, bitmask, arity) {
          var Ctor = createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index = length, placeholder = getHolder(wrapper);
            while (index--) {
              args[index] = arguments[index];
            }
            var holders = length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder ? [] : replaceHolders(args, placeholder);
            length -= holders.length;
            if (length < arity) {
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                undefined2,
                args,
                holders,
                undefined2,
                undefined2,
                arity - length
              );
            }
            var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            return apply(fn, this, args);
          }
          return wrapper;
        }
        function createFind(findIndexFunc) {
          return function(collection, predicate, fromIndex) {
            var iterable = Object2(collection);
            if (!isArrayLike(collection)) {
              var iteratee2 = getIteratee(predicate, 3);
              collection = keys(collection);
              predicate = function(key) {
                return iteratee2(iterable[key], key, iterable);
              };
            }
            var index = findIndexFunc(collection, predicate, fromIndex);
            return index > -1 ? iterable[iteratee2 ? collection[index] : index] : undefined2;
          };
        }
        function createFlow(fromRight) {
          return flatRest(function(funcs) {
            var length = funcs.length, index = length, prereq = LodashWrapper.prototype.thru;
            if (fromRight) {
              funcs.reverse();
            }
            while (index--) {
              var func = funcs[index];
              if (typeof func != "function") {
                throw new TypeError2(FUNC_ERROR_TEXT);
              }
              if (prereq && !wrapper && getFuncName(func) == "wrapper") {
                var wrapper = new LodashWrapper([], true);
              }
            }
            index = wrapper ? index : length;
            while (++index < length) {
              func = funcs[index];
              var funcName = getFuncName(func), data = funcName == "wrapper" ? getData(func) : undefined2;
              if (data && isLaziable(data[0]) && data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) && !data[4].length && data[9] == 1) {
                wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
              } else {
                wrapper = func.length == 1 && isLaziable(func) ? wrapper[funcName]() : wrapper.thru(func);
              }
            }
            return function() {
              var args = arguments, value = args[0];
              if (wrapper && args.length == 1 && isArray(value)) {
                return wrapper.plant(value).value();
              }
              var index2 = 0, result2 = length ? funcs[index2].apply(this, args) : value;
              while (++index2 < length) {
                result2 = funcs[index2].call(this, result2);
              }
              return result2;
            };
          });
        }
        function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary2, arity) {
          var isAry = bitmask & WRAP_ARY_FLAG, isBind = bitmask & WRAP_BIND_FLAG, isBindKey = bitmask & WRAP_BIND_KEY_FLAG, isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG), isFlip = bitmask & WRAP_FLIP_FLAG, Ctor = isBindKey ? undefined2 : createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index = length;
            while (index--) {
              args[index] = arguments[index];
            }
            if (isCurried) {
              var placeholder = getHolder(wrapper), holdersCount = countHolders(args, placeholder);
            }
            if (partials) {
              args = composeArgs(args, partials, holders, isCurried);
            }
            if (partialsRight) {
              args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
            }
            length -= holdersCount;
            if (isCurried && length < arity) {
              var newHolders = replaceHolders(args, placeholder);
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                thisArg,
                args,
                newHolders,
                argPos,
                ary2,
                arity - length
              );
            }
            var thisBinding = isBind ? thisArg : this, fn = isBindKey ? thisBinding[func] : func;
            length = args.length;
            if (argPos) {
              args = reorder(args, argPos);
            } else if (isFlip && length > 1) {
              args.reverse();
            }
            if (isAry && ary2 < length) {
              args.length = ary2;
            }
            if (this && this !== root && this instanceof wrapper) {
              fn = Ctor || createCtor(fn);
            }
            return fn.apply(thisBinding, args);
          }
          return wrapper;
        }
        function createInverter(setter, toIteratee) {
          return function(object, iteratee2) {
            return baseInverter(object, setter, toIteratee(iteratee2), {});
          };
        }
        function createMathOperation(operator, defaultValue) {
          return function(value, other) {
            var result2;
            if (value === undefined2 && other === undefined2) {
              return defaultValue;
            }
            if (value !== undefined2) {
              result2 = value;
            }
            if (other !== undefined2) {
              if (result2 === undefined2) {
                return other;
              }
              if (typeof value == "string" || typeof other == "string") {
                value = baseToString(value);
                other = baseToString(other);
              } else {
                value = baseToNumber(value);
                other = baseToNumber(other);
              }
              result2 = operator(value, other);
            }
            return result2;
          };
        }
        function createOver(arrayFunc) {
          return flatRest(function(iteratees) {
            iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
            return baseRest(function(args) {
              var thisArg = this;
              return arrayFunc(iteratees, function(iteratee2) {
                return apply(iteratee2, thisArg, args);
              });
            });
          });
        }
        function createPadding(length, chars) {
          chars = chars === undefined2 ? " " : baseToString(chars);
          var charsLength = chars.length;
          if (charsLength < 2) {
            return charsLength ? baseRepeat(chars, length) : chars;
          }
          var result2 = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
          return hasUnicode(chars) ? castSlice(stringToArray(result2), 0, length).join("") : result2.slice(0, length);
        }
        function createPartial(func, bitmask, thisArg, partials) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var argsIndex = -1, argsLength = arguments.length, leftIndex = -1, leftLength = partials.length, args = Array2(leftLength + argsLength), fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            while (++leftIndex < leftLength) {
              args[leftIndex] = partials[leftIndex];
            }
            while (argsLength--) {
              args[leftIndex++] = arguments[++argsIndex];
            }
            return apply(fn, isBind ? thisArg : this, args);
          }
          return wrapper;
        }
        function createRange(fromRight) {
          return function(start, end, step) {
            if (step && typeof step != "number" && isIterateeCall(start, end, step)) {
              end = step = undefined2;
            }
            start = toFinite(start);
            if (end === undefined2) {
              end = start;
              start = 0;
            } else {
              end = toFinite(end);
            }
            step = step === undefined2 ? start < end ? 1 : -1 : toFinite(step);
            return baseRange(start, end, step, fromRight);
          };
        }
        function createRelationalOperation(operator) {
          return function(value, other) {
            if (!(typeof value == "string" && typeof other == "string")) {
              value = toNumber(value);
              other = toNumber(other);
            }
            return operator(value, other);
          };
        }
        function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary2, arity) {
          var isCurry = bitmask & WRAP_CURRY_FLAG, newHolders = isCurry ? holders : undefined2, newHoldersRight = isCurry ? undefined2 : holders, newPartials = isCurry ? partials : undefined2, newPartialsRight = isCurry ? undefined2 : partials;
          bitmask |= isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG;
          bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
          if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
            bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
          }
          var newData = [
            func,
            bitmask,
            thisArg,
            newPartials,
            newHolders,
            newPartialsRight,
            newHoldersRight,
            argPos,
            ary2,
            arity
          ];
          var result2 = wrapFunc.apply(undefined2, newData);
          if (isLaziable(func)) {
            setData(result2, newData);
          }
          result2.placeholder = placeholder;
          return setWrapToString(result2, func, bitmask);
        }
        function createRound(methodName) {
          var func = Math2[methodName];
          return function(number, precision) {
            number = toNumber(number);
            precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
            if (precision && nativeIsFinite(number)) {
              var pair = (toString(number) + "e").split("e"), value = func(pair[0] + "e" + (+pair[1] + precision));
              pair = (toString(value) + "e").split("e");
              return +(pair[0] + "e" + (+pair[1] - precision));
            }
            return func(number);
          };
        }
        var createSet = !(Set2 && 1 / setToArray(new Set2([, -0]))[1] == INFINITY) ? noop : function(values2) {
          return new Set2(values2);
        };
        function createToPairs(keysFunc) {
          return function(object) {
            var tag = getTag(object);
            if (tag == mapTag) {
              return mapToArray(object);
            }
            if (tag == setTag) {
              return setToPairs(object);
            }
            return baseToPairs(object, keysFunc(object));
          };
        }
        function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary2, arity) {
          var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
          if (!isBindKey && typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          var length = partials ? partials.length : 0;
          if (!length) {
            bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
            partials = holders = undefined2;
          }
          ary2 = ary2 === undefined2 ? ary2 : nativeMax(toInteger(ary2), 0);
          arity = arity === undefined2 ? arity : toInteger(arity);
          length -= holders ? holders.length : 0;
          if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
            var partialsRight = partials, holdersRight = holders;
            partials = holders = undefined2;
          }
          var data = isBindKey ? undefined2 : getData(func);
          var newData = [
            func,
            bitmask,
            thisArg,
            partials,
            holders,
            partialsRight,
            holdersRight,
            argPos,
            ary2,
            arity
          ];
          if (data) {
            mergeData(newData, data);
          }
          func = newData[0];
          bitmask = newData[1];
          thisArg = newData[2];
          partials = newData[3];
          holders = newData[4];
          arity = newData[9] = newData[9] === undefined2 ? isBindKey ? 0 : func.length : nativeMax(newData[9] - length, 0);
          if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
            bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
          }
          if (!bitmask || bitmask == WRAP_BIND_FLAG) {
            var result2 = createBind(func, bitmask, thisArg);
          } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
            result2 = createCurry(func, bitmask, arity);
          } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
            result2 = createPartial(func, bitmask, thisArg, partials);
          } else {
            result2 = createHybrid.apply(undefined2, newData);
          }
          var setter = data ? baseSetData : setData;
          return setWrapToString(setter(result2, newData), func, bitmask);
        }
        function customDefaultsAssignIn(objValue, srcValue, key, object) {
          if (objValue === undefined2 || eq(objValue, objectProto[key]) && !hasOwnProperty.call(object, key)) {
            return srcValue;
          }
          return objValue;
        }
        function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
          if (isObject(objValue) && isObject(srcValue)) {
            stack.set(srcValue, objValue);
            baseMerge(objValue, srcValue, undefined2, customDefaultsMerge, stack);
            stack["delete"](srcValue);
          }
          return objValue;
        }
        function customOmitClone(value) {
          return isPlainObject(value) ? undefined2 : value;
        }
        function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
          if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
            return false;
          }
          var arrStacked = stack.get(array);
          var othStacked = stack.get(other);
          if (arrStacked && othStacked) {
            return arrStacked == other && othStacked == array;
          }
          var index = -1, result2 = true, seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : undefined2;
          stack.set(array, other);
          stack.set(other, array);
          while (++index < arrLength) {
            var arrValue = array[index], othValue = other[index];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
            }
            if (compared !== undefined2) {
              if (compared) {
                continue;
              }
              result2 = false;
              break;
            }
            if (seen) {
              if (!arraySome(other, function(othValue2, othIndex) {
                if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                  return seen.push(othIndex);
                }
              })) {
                result2 = false;
                break;
              }
            } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              result2 = false;
              break;
            }
          }
          stack["delete"](array);
          stack["delete"](other);
          return result2;
        }
        function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
          switch (tag) {
            case dataViewTag:
              if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
                return false;
              }
              object = object.buffer;
              other = other.buffer;
            case arrayBufferTag:
              if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object), new Uint8Array2(other))) {
                return false;
              }
              return true;
            case boolTag:
            case dateTag:
            case numberTag:
              return eq(+object, +other);
            case errorTag:
              return object.name == other.name && object.message == other.message;
            case regexpTag:
            case stringTag:
              return object == other + "";
            case mapTag:
              var convert = mapToArray;
            case setTag:
              var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
              convert || (convert = setToArray);
              if (object.size != other.size && !isPartial) {
                return false;
              }
              var stacked = stack.get(object);
              if (stacked) {
                return stacked == other;
              }
              bitmask |= COMPARE_UNORDERED_FLAG;
              stack.set(object, other);
              var result2 = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
              stack["delete"](object);
              return result2;
            case symbolTag:
              if (symbolValueOf) {
                return symbolValueOf.call(object) == symbolValueOf.call(other);
              }
          }
          return false;
        }
        function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
          if (objLength != othLength && !isPartial) {
            return false;
          }
          var index = objLength;
          while (index--) {
            var key = objProps[index];
            if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
              return false;
            }
          }
          var objStacked = stack.get(object);
          var othStacked = stack.get(other);
          if (objStacked && othStacked) {
            return objStacked == other && othStacked == object;
          }
          var result2 = true;
          stack.set(object, other);
          stack.set(other, object);
          var skipCtor = isPartial;
          while (++index < objLength) {
            key = objProps[index];
            var objValue = object[key], othValue = other[key];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
            }
            if (!(compared === undefined2 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
              result2 = false;
              break;
            }
            skipCtor || (skipCtor = key == "constructor");
          }
          if (result2 && !skipCtor) {
            var objCtor = object.constructor, othCtor = other.constructor;
            if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
              result2 = false;
            }
          }
          stack["delete"](object);
          stack["delete"](other);
          return result2;
        }
        function flatRest(func) {
          return setToString(overRest(func, undefined2, flatten), func + "");
        }
        function getAllKeys(object) {
          return baseGetAllKeys(object, keys, getSymbols);
        }
        function getAllKeysIn(object) {
          return baseGetAllKeys(object, keysIn, getSymbolsIn);
        }
        var getData = !metaMap ? noop : function(func) {
          return metaMap.get(func);
        };
        function getFuncName(func) {
          var result2 = func.name + "", array = realNames[result2], length = hasOwnProperty.call(realNames, result2) ? array.length : 0;
          while (length--) {
            var data = array[length], otherFunc = data.func;
            if (otherFunc == null || otherFunc == func) {
              return data.name;
            }
          }
          return result2;
        }
        function getHolder(func) {
          var object = hasOwnProperty.call(lodash, "placeholder") ? lodash : func;
          return object.placeholder;
        }
        function getIteratee() {
          var result2 = lodash.iteratee || iteratee;
          result2 = result2 === iteratee ? baseIteratee : result2;
          return arguments.length ? result2(arguments[0], arguments[1]) : result2;
        }
        function getMapData(map2, key) {
          var data = map2.__data__;
          return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
        }
        function getMatchData(object) {
          var result2 = keys(object), length = result2.length;
          while (length--) {
            var key = result2[length], value = object[key];
            result2[length] = [key, value, isStrictComparable(value)];
          }
          return result2;
        }
        function getNative(object, key) {
          var value = getValue(object, key);
          return baseIsNative(value) ? value : undefined2;
        }
        function getRawTag(value) {
          var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
          try {
            value[symToStringTag] = undefined2;
            var unmasked = true;
          } catch (e) {
          }
          var result2 = nativeObjectToString.call(value);
          if (unmasked) {
            if (isOwn) {
              value[symToStringTag] = tag;
            } else {
              delete value[symToStringTag];
            }
          }
          return result2;
        }
        var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
          if (object == null) {
            return [];
          }
          object = Object2(object);
          return arrayFilter(nativeGetSymbols(object), function(symbol) {
            return propertyIsEnumerable.call(object, symbol);
          });
        };
        var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
          var result2 = [];
          while (object) {
            arrayPush(result2, getSymbols(object));
            object = getPrototype(object);
          }
          return result2;
        };
        var getTag = baseGetTag;
        if (DataView2 && getTag(new DataView2(new ArrayBuffer(1))) != dataViewTag || Map2 && getTag(new Map2()) != mapTag || Promise2 && getTag(Promise2.resolve()) != promiseTag || Set2 && getTag(new Set2()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
          getTag = function(value) {
            var result2 = baseGetTag(value), Ctor = result2 == objectTag ? value.constructor : undefined2, ctorString = Ctor ? toSource(Ctor) : "";
            if (ctorString) {
              switch (ctorString) {
                case dataViewCtorString:
                  return dataViewTag;
                case mapCtorString:
                  return mapTag;
                case promiseCtorString:
                  return promiseTag;
                case setCtorString:
                  return setTag;
                case weakMapCtorString:
                  return weakMapTag;
              }
            }
            return result2;
          };
        }
        function getView(start, end, transforms) {
          var index = -1, length = transforms.length;
          while (++index < length) {
            var data = transforms[index], size2 = data.size;
            switch (data.type) {
              case "drop":
                start += size2;
                break;
              case "dropRight":
                end -= size2;
                break;
              case "take":
                end = nativeMin(end, start + size2);
                break;
              case "takeRight":
                start = nativeMax(start, end - size2);
                break;
            }
          }
          return { "start": start, "end": end };
        }
        function getWrapDetails(source) {
          var match = source.match(reWrapDetails);
          return match ? match[1].split(reSplitDetails) : [];
        }
        function hasPath(object, path4, hasFunc) {
          path4 = castPath(path4, object);
          var index = -1, length = path4.length, result2 = false;
          while (++index < length) {
            var key = toKey(path4[index]);
            if (!(result2 = object != null && hasFunc(object, key))) {
              break;
            }
            object = object[key];
          }
          if (result2 || ++index != length) {
            return result2;
          }
          length = object == null ? 0 : object.length;
          return !!length && isLength(length) && isIndex(key, length) && (isArray(object) || isArguments(object));
        }
        function initCloneArray(array) {
          var length = array.length, result2 = new array.constructor(length);
          if (length && typeof array[0] == "string" && hasOwnProperty.call(array, "index")) {
            result2.index = array.index;
            result2.input = array.input;
          }
          return result2;
        }
        function initCloneObject(object) {
          return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate(getPrototype(object)) : {};
        }
        function initCloneByTag(object, tag, isDeep) {
          var Ctor = object.constructor;
          switch (tag) {
            case arrayBufferTag:
              return cloneArrayBuffer(object);
            case boolTag:
            case dateTag:
              return new Ctor(+object);
            case dataViewTag:
              return cloneDataView(object, isDeep);
            case float32Tag:
            case float64Tag:
            case int8Tag:
            case int16Tag:
            case int32Tag:
            case uint8Tag:
            case uint8ClampedTag:
            case uint16Tag:
            case uint32Tag:
              return cloneTypedArray(object, isDeep);
            case mapTag:
              return new Ctor();
            case numberTag:
            case stringTag:
              return new Ctor(object);
            case regexpTag:
              return cloneRegExp(object);
            case setTag:
              return new Ctor();
            case symbolTag:
              return cloneSymbol(object);
          }
        }
        function insertWrapDetails(source, details) {
          var length = details.length;
          if (!length) {
            return source;
          }
          var lastIndex = length - 1;
          details[lastIndex] = (length > 1 ? "& " : "") + details[lastIndex];
          details = details.join(length > 2 ? ", " : " ");
          return source.replace(reWrapComment, "{\n/* [wrapped with " + details + "] */\n");
        }
        function isFlattenable(value) {
          return isArray(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
        }
        function isIndex(value, length) {
          var type = typeof value;
          length = length == null ? MAX_SAFE_INTEGER : length;
          return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
        }
        function isIterateeCall(value, index, object) {
          if (!isObject(object)) {
            return false;
          }
          var type = typeof index;
          if (type == "number" ? isArrayLike(object) && isIndex(index, object.length) : type == "string" && index in object) {
            return eq(object[index], value);
          }
          return false;
        }
        function isKey(value, object) {
          if (isArray(value)) {
            return false;
          }
          var type = typeof value;
          if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol(value)) {
            return true;
          }
          return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object2(object);
        }
        function isKeyable(value) {
          var type = typeof value;
          return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
        }
        function isLaziable(func) {
          var funcName = getFuncName(func), other = lodash[funcName];
          if (typeof other != "function" || !(funcName in LazyWrapper.prototype)) {
            return false;
          }
          if (func === other) {
            return true;
          }
          var data = getData(other);
          return !!data && func === data[0];
        }
        function isMasked(func) {
          return !!maskSrcKey && maskSrcKey in func;
        }
        var isMaskable = coreJsData ? isFunction : stubFalse;
        function isPrototype(value) {
          var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
          return value === proto;
        }
        function isStrictComparable(value) {
          return value === value && !isObject(value);
        }
        function matchesStrictComparable(key, srcValue) {
          return function(object) {
            if (object == null) {
              return false;
            }
            return object[key] === srcValue && (srcValue !== undefined2 || key in Object2(object));
          };
        }
        function memoizeCapped(func) {
          var result2 = memoize(func, function(key) {
            if (cache.size === MAX_MEMOIZE_SIZE) {
              cache.clear();
            }
            return key;
          });
          var cache = result2.cache;
          return result2;
        }
        function mergeData(data, source) {
          var bitmask = data[1], srcBitmask = source[1], newBitmask = bitmask | srcBitmask, isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
          var isCombo = srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_CURRY_FLAG || srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_REARG_FLAG && data[7].length <= source[8] || srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) && source[7].length <= source[8] && bitmask == WRAP_CURRY_FLAG;
          if (!(isCommon || isCombo)) {
            return data;
          }
          if (srcBitmask & WRAP_BIND_FLAG) {
            data[2] = source[2];
            newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
          }
          var value = source[3];
          if (value) {
            var partials = data[3];
            data[3] = partials ? composeArgs(partials, value, source[4]) : value;
            data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
          }
          value = source[5];
          if (value) {
            partials = data[5];
            data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
            data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
          }
          value = source[7];
          if (value) {
            data[7] = value;
          }
          if (srcBitmask & WRAP_ARY_FLAG) {
            data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
          }
          if (data[9] == null) {
            data[9] = source[9];
          }
          data[0] = source[0];
          data[1] = newBitmask;
          return data;
        }
        function nativeKeysIn(object) {
          var result2 = [];
          if (object != null) {
            for (var key in Object2(object)) {
              result2.push(key);
            }
          }
          return result2;
        }
        function objectToString(value) {
          return nativeObjectToString.call(value);
        }
        function overRest(func, start, transform2) {
          start = nativeMax(start === undefined2 ? func.length - 1 : start, 0);
          return function() {
            var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array2(length);
            while (++index < length) {
              array[index] = args[start + index];
            }
            index = -1;
            var otherArgs = Array2(start + 1);
            while (++index < start) {
              otherArgs[index] = args[index];
            }
            otherArgs[start] = transform2(array);
            return apply(func, this, otherArgs);
          };
        }
        function parent(object, path4) {
          return path4.length < 2 ? object : baseGet(object, baseSlice(path4, 0, -1));
        }
        function reorder(array, indexes) {
          var arrLength = array.length, length = nativeMin(indexes.length, arrLength), oldArray = copyArray(array);
          while (length--) {
            var index = indexes[length];
            array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined2;
          }
          return array;
        }
        function safeGet(object, key) {
          if (key === "constructor" && typeof object[key] === "function") {
            return;
          }
          if (key == "__proto__") {
            return;
          }
          return object[key];
        }
        var setData = shortOut(baseSetData);
        var setTimeout2 = ctxSetTimeout || function(func, wait) {
          return root.setTimeout(func, wait);
        };
        var setToString = shortOut(baseSetToString);
        function setWrapToString(wrapper, reference, bitmask) {
          var source = reference + "";
          return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
        }
        function shortOut(func) {
          var count = 0, lastCalled = 0;
          return function() {
            var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
            lastCalled = stamp;
            if (remaining > 0) {
              if (++count >= HOT_COUNT) {
                return arguments[0];
              }
            } else {
              count = 0;
            }
            return func.apply(undefined2, arguments);
          };
        }
        function shuffleSelf(array, size2) {
          var index = -1, length = array.length, lastIndex = length - 1;
          size2 = size2 === undefined2 ? length : size2;
          while (++index < size2) {
            var rand = baseRandom(index, lastIndex), value = array[rand];
            array[rand] = array[index];
            array[index] = value;
          }
          array.length = size2;
          return array;
        }
        var stringToPath = memoizeCapped(function(string) {
          var result2 = [];
          if (string.charCodeAt(0) === 46) {
            result2.push("");
          }
          string.replace(rePropName, function(match, number, quote, subString) {
            result2.push(quote ? subString.replace(reEscapeChar, "$1") : number || match);
          });
          return result2;
        });
        function toKey(value) {
          if (typeof value == "string" || isSymbol(value)) {
            return value;
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
        }
        function toSource(func) {
          if (func != null) {
            try {
              return funcToString.call(func);
            } catch (e) {
            }
            try {
              return func + "";
            } catch (e) {
            }
          }
          return "";
        }
        function updateWrapDetails(details, bitmask) {
          arrayEach(wrapFlags, function(pair) {
            var value = "_." + pair[0];
            if (bitmask & pair[1] && !arrayIncludes(details, value)) {
              details.push(value);
            }
          });
          return details.sort();
        }
        function wrapperClone(wrapper) {
          if (wrapper instanceof LazyWrapper) {
            return wrapper.clone();
          }
          var result2 = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
          result2.__actions__ = copyArray(wrapper.__actions__);
          result2.__index__ = wrapper.__index__;
          result2.__values__ = wrapper.__values__;
          return result2;
        }
        function chunk(array, size2, guard) {
          if (guard ? isIterateeCall(array, size2, guard) : size2 === undefined2) {
            size2 = 1;
          } else {
            size2 = nativeMax(toInteger(size2), 0);
          }
          var length = array == null ? 0 : array.length;
          if (!length || size2 < 1) {
            return [];
          }
          var index = 0, resIndex = 0, result2 = Array2(nativeCeil(length / size2));
          while (index < length) {
            result2[resIndex++] = baseSlice(array, index, index += size2);
          }
          return result2;
        }
        function compact(array) {
          var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result2 = [];
          while (++index < length) {
            var value = array[index];
            if (value) {
              result2[resIndex++] = value;
            }
          }
          return result2;
        }
        function concat() {
          var length = arguments.length;
          if (!length) {
            return [];
          }
          var args = Array2(length - 1), array = arguments[0], index = length;
          while (index--) {
            args[index - 1] = arguments[index];
          }
          return arrayPush(isArray(array) ? copyArray(array) : [array], baseFlatten(args, 1));
        }
        var difference = baseRest(function(array, values2) {
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true)) : [];
        });
        var differenceBy = baseRest(function(array, values2) {
          var iteratee2 = last(values2);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2)) : [];
        });
        var differenceWith = baseRest(function(array, values2) {
          var comparator = last(values2);
          if (isArrayLikeObject(comparator)) {
            comparator = undefined2;
          }
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), undefined2, comparator) : [];
        });
        function drop(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          return baseSlice(array, n < 0 ? 0 : n, length);
        }
        function dropRight(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          n = length - n;
          return baseSlice(array, 0, n < 0 ? 0 : n);
        }
        function dropRightWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true, true) : [];
        }
        function dropWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true) : [];
        }
        function fill(array, value, start, end) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          if (start && typeof start != "number" && isIterateeCall(array, value, start)) {
            start = 0;
            end = length;
          }
          return baseFill(array, value, start, end);
        }
        function findIndex(array, predicate, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = fromIndex == null ? 0 : toInteger(fromIndex);
          if (index < 0) {
            index = nativeMax(length + index, 0);
          }
          return baseFindIndex(array, getIteratee(predicate, 3), index);
        }
        function findLastIndex(array, predicate, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = length - 1;
          if (fromIndex !== undefined2) {
            index = toInteger(fromIndex);
            index = fromIndex < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
          }
          return baseFindIndex(array, getIteratee(predicate, 3), index, true);
        }
        function flatten(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseFlatten(array, 1) : [];
        }
        function flattenDeep(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseFlatten(array, INFINITY) : [];
        }
        function flattenDepth(array, depth) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          depth = depth === undefined2 ? 1 : toInteger(depth);
          return baseFlatten(array, depth);
        }
        function fromPairs(pairs) {
          var index = -1, length = pairs == null ? 0 : pairs.length, result2 = {};
          while (++index < length) {
            var pair = pairs[index];
            result2[pair[0]] = pair[1];
          }
          return result2;
        }
        function head(array) {
          return array && array.length ? array[0] : undefined2;
        }
        function indexOf(array, value, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = fromIndex == null ? 0 : toInteger(fromIndex);
          if (index < 0) {
            index = nativeMax(length + index, 0);
          }
          return baseIndexOf(array, value, index);
        }
        function initial(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseSlice(array, 0, -1) : [];
        }
        var intersection = baseRest(function(arrays) {
          var mapped = arrayMap(arrays, castArrayLikeObject);
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped) : [];
        });
        var intersectionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays), mapped = arrayMap(arrays, castArrayLikeObject);
          if (iteratee2 === last(mapped)) {
            iteratee2 = undefined2;
          } else {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, getIteratee(iteratee2, 2)) : [];
        });
        var intersectionWith = baseRest(function(arrays) {
          var comparator = last(arrays), mapped = arrayMap(arrays, castArrayLikeObject);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          if (comparator) {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, undefined2, comparator) : [];
        });
        function join2(array, separator) {
          return array == null ? "" : nativeJoin.call(array, separator);
        }
        function last(array) {
          var length = array == null ? 0 : array.length;
          return length ? array[length - 1] : undefined2;
        }
        function lastIndexOf(array, value, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = length;
          if (fromIndex !== undefined2) {
            index = toInteger(fromIndex);
            index = index < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
          }
          return value === value ? strictLastIndexOf(array, value, index) : baseFindIndex(array, baseIsNaN, index, true);
        }
        function nth(array, n) {
          return array && array.length ? baseNth(array, toInteger(n)) : undefined2;
        }
        var pull = baseRest(pullAll);
        function pullAll(array, values2) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2) : array;
        }
        function pullAllBy(array, values2, iteratee2) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2, getIteratee(iteratee2, 2)) : array;
        }
        function pullAllWith(array, values2, comparator) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2, undefined2, comparator) : array;
        }
        var pullAt = flatRest(function(array, indexes) {
          var length = array == null ? 0 : array.length, result2 = baseAt(array, indexes);
          basePullAt(array, arrayMap(indexes, function(index) {
            return isIndex(index, length) ? +index : index;
          }).sort(compareAscending));
          return result2;
        });
        function remove(array, predicate) {
          var result2 = [];
          if (!(array && array.length)) {
            return result2;
          }
          var index = -1, indexes = [], length = array.length;
          predicate = getIteratee(predicate, 3);
          while (++index < length) {
            var value = array[index];
            if (predicate(value, index, array)) {
              result2.push(value);
              indexes.push(index);
            }
          }
          basePullAt(array, indexes);
          return result2;
        }
        function reverse(array) {
          return array == null ? array : nativeReverse.call(array);
        }
        function slice(array, start, end) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          if (end && typeof end != "number" && isIterateeCall(array, start, end)) {
            start = 0;
            end = length;
          } else {
            start = start == null ? 0 : toInteger(start);
            end = end === undefined2 ? length : toInteger(end);
          }
          return baseSlice(array, start, end);
        }
        function sortedIndex(array, value) {
          return baseSortedIndex(array, value);
        }
        function sortedIndexBy(array, value, iteratee2) {
          return baseSortedIndexBy(array, value, getIteratee(iteratee2, 2));
        }
        function sortedIndexOf(array, value) {
          var length = array == null ? 0 : array.length;
          if (length) {
            var index = baseSortedIndex(array, value);
            if (index < length && eq(array[index], value)) {
              return index;
            }
          }
          return -1;
        }
        function sortedLastIndex(array, value) {
          return baseSortedIndex(array, value, true);
        }
        function sortedLastIndexBy(array, value, iteratee2) {
          return baseSortedIndexBy(array, value, getIteratee(iteratee2, 2), true);
        }
        function sortedLastIndexOf(array, value) {
          var length = array == null ? 0 : array.length;
          if (length) {
            var index = baseSortedIndex(array, value, true) - 1;
            if (eq(array[index], value)) {
              return index;
            }
          }
          return -1;
        }
        function sortedUniq(array) {
          return array && array.length ? baseSortedUniq(array) : [];
        }
        function sortedUniqBy(array, iteratee2) {
          return array && array.length ? baseSortedUniq(array, getIteratee(iteratee2, 2)) : [];
        }
        function tail(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseSlice(array, 1, length) : [];
        }
        function take(array, n, guard) {
          if (!(array && array.length)) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          return baseSlice(array, 0, n < 0 ? 0 : n);
        }
        function takeRight(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          n = length - n;
          return baseSlice(array, n < 0 ? 0 : n, length);
        }
        function takeRightWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), false, true) : [];
        }
        function takeWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3)) : [];
        }
        var union = baseRest(function(arrays) {
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
        });
        var unionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2));
        });
        var unionWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined2, comparator);
        });
        function uniq(array) {
          return array && array.length ? baseUniq(array) : [];
        }
        function uniqBy(array, iteratee2) {
          return array && array.length ? baseUniq(array, getIteratee(iteratee2, 2)) : [];
        }
        function uniqWith(array, comparator) {
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return array && array.length ? baseUniq(array, undefined2, comparator) : [];
        }
        function unzip(array) {
          if (!(array && array.length)) {
            return [];
          }
          var length = 0;
          array = arrayFilter(array, function(group) {
            if (isArrayLikeObject(group)) {
              length = nativeMax(group.length, length);
              return true;
            }
          });
          return baseTimes(length, function(index) {
            return arrayMap(array, baseProperty(index));
          });
        }
        function unzipWith(array, iteratee2) {
          if (!(array && array.length)) {
            return [];
          }
          var result2 = unzip(array);
          if (iteratee2 == null) {
            return result2;
          }
          return arrayMap(result2, function(group) {
            return apply(iteratee2, undefined2, group);
          });
        }
        var without = baseRest(function(array, values2) {
          return isArrayLikeObject(array) ? baseDifference(array, values2) : [];
        });
        var xor = baseRest(function(arrays) {
          return baseXor(arrayFilter(arrays, isArrayLikeObject));
        });
        var xorBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return baseXor(arrayFilter(arrays, isArrayLikeObject), getIteratee(iteratee2, 2));
        });
        var xorWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined2, comparator);
        });
        var zip = baseRest(unzip);
        function zipObject(props, values2) {
          return baseZipObject(props || [], values2 || [], assignValue);
        }
        function zipObjectDeep(props, values2) {
          return baseZipObject(props || [], values2 || [], baseSet);
        }
        var zipWith = baseRest(function(arrays) {
          var length = arrays.length, iteratee2 = length > 1 ? arrays[length - 1] : undefined2;
          iteratee2 = typeof iteratee2 == "function" ? (arrays.pop(), iteratee2) : undefined2;
          return unzipWith(arrays, iteratee2);
        });
        function chain(value) {
          var result2 = lodash(value);
          result2.__chain__ = true;
          return result2;
        }
        function tap(value, interceptor) {
          interceptor(value);
          return value;
        }
        function thru(value, interceptor) {
          return interceptor(value);
        }
        var wrapperAt = flatRest(function(paths) {
          var length = paths.length, start = length ? paths[0] : 0, value = this.__wrapped__, interceptor = function(object) {
            return baseAt(object, paths);
          };
          if (length > 1 || this.__actions__.length || !(value instanceof LazyWrapper) || !isIndex(start)) {
            return this.thru(interceptor);
          }
          value = value.slice(start, +start + (length ? 1 : 0));
          value.__actions__.push({
            "func": thru,
            "args": [interceptor],
            "thisArg": undefined2
          });
          return new LodashWrapper(value, this.__chain__).thru(function(array) {
            if (length && !array.length) {
              array.push(undefined2);
            }
            return array;
          });
        });
        function wrapperChain() {
          return chain(this);
        }
        function wrapperCommit() {
          return new LodashWrapper(this.value(), this.__chain__);
        }
        function wrapperNext() {
          if (this.__values__ === undefined2) {
            this.__values__ = toArray(this.value());
          }
          var done = this.__index__ >= this.__values__.length, value = done ? undefined2 : this.__values__[this.__index__++];
          return { "done": done, "value": value };
        }
        function wrapperToIterator() {
          return this;
        }
        function wrapperPlant(value) {
          var result2, parent2 = this;
          while (parent2 instanceof baseLodash) {
            var clone2 = wrapperClone(parent2);
            clone2.__index__ = 0;
            clone2.__values__ = undefined2;
            if (result2) {
              previous.__wrapped__ = clone2;
            } else {
              result2 = clone2;
            }
            var previous = clone2;
            parent2 = parent2.__wrapped__;
          }
          previous.__wrapped__ = value;
          return result2;
        }
        function wrapperReverse() {
          var value = this.__wrapped__;
          if (value instanceof LazyWrapper) {
            var wrapped = value;
            if (this.__actions__.length) {
              wrapped = new LazyWrapper(this);
            }
            wrapped = wrapped.reverse();
            wrapped.__actions__.push({
              "func": thru,
              "args": [reverse],
              "thisArg": undefined2
            });
            return new LodashWrapper(wrapped, this.__chain__);
          }
          return this.thru(reverse);
        }
        function wrapperValue() {
          return baseWrapperValue(this.__wrapped__, this.__actions__);
        }
        var countBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty.call(result2, key)) {
            ++result2[key];
          } else {
            baseAssignValue(result2, key, 1);
          }
        });
        function every(collection, predicate, guard) {
          var func = isArray(collection) ? arrayEvery : baseEvery;
          if (guard && isIterateeCall(collection, predicate, guard)) {
            predicate = undefined2;
          }
          return func(collection, getIteratee(predicate, 3));
        }
        function filter(collection, predicate) {
          var func = isArray(collection) ? arrayFilter : baseFilter;
          return func(collection, getIteratee(predicate, 3));
        }
        var find = createFind(findIndex);
        var findLast = createFind(findLastIndex);
        function flatMap(collection, iteratee2) {
          return baseFlatten(map(collection, iteratee2), 1);
        }
        function flatMapDeep(collection, iteratee2) {
          return baseFlatten(map(collection, iteratee2), INFINITY);
        }
        function flatMapDepth(collection, iteratee2, depth) {
          depth = depth === undefined2 ? 1 : toInteger(depth);
          return baseFlatten(map(collection, iteratee2), depth);
        }
        function forEach(collection, iteratee2) {
          var func = isArray(collection) ? arrayEach : baseEach;
          return func(collection, getIteratee(iteratee2, 3));
        }
        function forEachRight(collection, iteratee2) {
          var func = isArray(collection) ? arrayEachRight : baseEachRight;
          return func(collection, getIteratee(iteratee2, 3));
        }
        var groupBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty.call(result2, key)) {
            result2[key].push(value);
          } else {
            baseAssignValue(result2, key, [value]);
          }
        });
        function includes(collection, value, fromIndex, guard) {
          collection = isArrayLike(collection) ? collection : values(collection);
          fromIndex = fromIndex && !guard ? toInteger(fromIndex) : 0;
          var length = collection.length;
          if (fromIndex < 0) {
            fromIndex = nativeMax(length + fromIndex, 0);
          }
          return isString(collection) ? fromIndex <= length && collection.indexOf(value, fromIndex) > -1 : !!length && baseIndexOf(collection, value, fromIndex) > -1;
        }
        var invokeMap = baseRest(function(collection, path4, args) {
          var index = -1, isFunc = typeof path4 == "function", result2 = isArrayLike(collection) ? Array2(collection.length) : [];
          baseEach(collection, function(value) {
            result2[++index] = isFunc ? apply(path4, value, args) : baseInvoke(value, path4, args);
          });
          return result2;
        });
        var keyBy = createAggregator(function(result2, value, key) {
          baseAssignValue(result2, key, value);
        });
        function map(collection, iteratee2) {
          var func = isArray(collection) ? arrayMap : baseMap;
          return func(collection, getIteratee(iteratee2, 3));
        }
        function orderBy(collection, iteratees, orders, guard) {
          if (collection == null) {
            return [];
          }
          if (!isArray(iteratees)) {
            iteratees = iteratees == null ? [] : [iteratees];
          }
          orders = guard ? undefined2 : orders;
          if (!isArray(orders)) {
            orders = orders == null ? [] : [orders];
          }
          return baseOrderBy(collection, iteratees, orders);
        }
        var partition = createAggregator(function(result2, value, key) {
          result2[key ? 0 : 1].push(value);
        }, function() {
          return [[], []];
        });
        function reduce(collection, iteratee2, accumulator) {
          var func = isArray(collection) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
          return func(collection, getIteratee(iteratee2, 4), accumulator, initAccum, baseEach);
        }
        function reduceRight(collection, iteratee2, accumulator) {
          var func = isArray(collection) ? arrayReduceRight : baseReduce, initAccum = arguments.length < 3;
          return func(collection, getIteratee(iteratee2, 4), accumulator, initAccum, baseEachRight);
        }
        function reject(collection, predicate) {
          var func = isArray(collection) ? arrayFilter : baseFilter;
          return func(collection, negate(getIteratee(predicate, 3)));
        }
        function sample(collection) {
          var func = isArray(collection) ? arraySample : baseSample;
          return func(collection);
        }
        function sampleSize(collection, n, guard) {
          if (guard ? isIterateeCall(collection, n, guard) : n === undefined2) {
            n = 1;
          } else {
            n = toInteger(n);
          }
          var func = isArray(collection) ? arraySampleSize : baseSampleSize;
          return func(collection, n);
        }
        function shuffle(collection) {
          var func = isArray(collection) ? arrayShuffle : baseShuffle;
          return func(collection);
        }
        function size(collection) {
          if (collection == null) {
            return 0;
          }
          if (isArrayLike(collection)) {
            return isString(collection) ? stringSize(collection) : collection.length;
          }
          var tag = getTag(collection);
          if (tag == mapTag || tag == setTag) {
            return collection.size;
          }
          return baseKeys(collection).length;
        }
        function some(collection, predicate, guard) {
          var func = isArray(collection) ? arraySome : baseSome;
          if (guard && isIterateeCall(collection, predicate, guard)) {
            predicate = undefined2;
          }
          return func(collection, getIteratee(predicate, 3));
        }
        var sortBy = baseRest(function(collection, iteratees) {
          if (collection == null) {
            return [];
          }
          var length = iteratees.length;
          if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
            iteratees = [];
          } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
            iteratees = [iteratees[0]];
          }
          return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
        });
        var now = ctxNow || function() {
          return root.Date.now();
        };
        function after(n, func) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          n = toInteger(n);
          return function() {
            if (--n < 1) {
              return func.apply(this, arguments);
            }
          };
        }
        function ary(func, n, guard) {
          n = guard ? undefined2 : n;
          n = func && n == null ? func.length : n;
          return createWrap(func, WRAP_ARY_FLAG, undefined2, undefined2, undefined2, undefined2, n);
        }
        function before(n, func) {
          var result2;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          n = toInteger(n);
          return function() {
            if (--n > 0) {
              result2 = func.apply(this, arguments);
            }
            if (n <= 1) {
              func = undefined2;
            }
            return result2;
          };
        }
        var bind = baseRest(function(func, thisArg, partials) {
          var bitmask = WRAP_BIND_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bind));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(func, bitmask, thisArg, partials, holders);
        });
        var bindKey = baseRest(function(object, key, partials) {
          var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bindKey));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(key, bitmask, object, partials, holders);
        });
        function curry(func, arity, guard) {
          arity = guard ? undefined2 : arity;
          var result2 = createWrap(func, WRAP_CURRY_FLAG, undefined2, undefined2, undefined2, undefined2, undefined2, arity);
          result2.placeholder = curry.placeholder;
          return result2;
        }
        function curryRight(func, arity, guard) {
          arity = guard ? undefined2 : arity;
          var result2 = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined2, undefined2, undefined2, undefined2, undefined2, arity);
          result2.placeholder = curryRight.placeholder;
          return result2;
        }
        function debounce(func, wait, options) {
          var lastArgs, lastThis, maxWait, result2, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          wait = toNumber(wait) || 0;
          if (isObject(options)) {
            leading = !!options.leading;
            maxing = "maxWait" in options;
            maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          function invokeFunc(time) {
            var args = lastArgs, thisArg = lastThis;
            lastArgs = lastThis = undefined2;
            lastInvokeTime = time;
            result2 = func.apply(thisArg, args);
            return result2;
          }
          function leadingEdge(time) {
            lastInvokeTime = time;
            timerId = setTimeout2(timerExpired, wait);
            return leading ? invokeFunc(time) : result2;
          }
          function remainingWait(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
            return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
          }
          function shouldInvoke(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
            return lastCallTime === undefined2 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
          }
          function timerExpired() {
            var time = now();
            if (shouldInvoke(time)) {
              return trailingEdge(time);
            }
            timerId = setTimeout2(timerExpired, remainingWait(time));
          }
          function trailingEdge(time) {
            timerId = undefined2;
            if (trailing && lastArgs) {
              return invokeFunc(time);
            }
            lastArgs = lastThis = undefined2;
            return result2;
          }
          function cancel() {
            if (timerId !== undefined2) {
              clearTimeout2(timerId);
            }
            lastInvokeTime = 0;
            lastArgs = lastCallTime = lastThis = timerId = undefined2;
          }
          function flush() {
            return timerId === undefined2 ? result2 : trailingEdge(now());
          }
          function debounced() {
            var time = now(), isInvoking = shouldInvoke(time);
            lastArgs = arguments;
            lastThis = this;
            lastCallTime = time;
            if (isInvoking) {
              if (timerId === undefined2) {
                return leadingEdge(lastCallTime);
              }
              if (maxing) {
                clearTimeout2(timerId);
                timerId = setTimeout2(timerExpired, wait);
                return invokeFunc(lastCallTime);
              }
            }
            if (timerId === undefined2) {
              timerId = setTimeout2(timerExpired, wait);
            }
            return result2;
          }
          debounced.cancel = cancel;
          debounced.flush = flush;
          return debounced;
        }
        var defer = baseRest(function(func, args) {
          return baseDelay(func, 1, args);
        });
        var delay = baseRest(function(func, wait, args) {
          return baseDelay(func, toNumber(wait) || 0, args);
        });
        function flip(func) {
          return createWrap(func, WRAP_FLIP_FLAG);
        }
        function memoize(func, resolver) {
          if (typeof func != "function" || resolver != null && typeof resolver != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          var memoized = function() {
            var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
            if (cache.has(key)) {
              return cache.get(key);
            }
            var result2 = func.apply(this, args);
            memoized.cache = cache.set(key, result2) || cache;
            return result2;
          };
          memoized.cache = new (memoize.Cache || MapCache)();
          return memoized;
        }
        memoize.Cache = MapCache;
        function negate(predicate) {
          if (typeof predicate != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return !predicate.call(this);
              case 1:
                return !predicate.call(this, args[0]);
              case 2:
                return !predicate.call(this, args[0], args[1]);
              case 3:
                return !predicate.call(this, args[0], args[1], args[2]);
            }
            return !predicate.apply(this, args);
          };
        }
        function once(func) {
          return before(2, func);
        }
        var overArgs = castRest(function(func, transforms) {
          transforms = transforms.length == 1 && isArray(transforms[0]) ? arrayMap(transforms[0], baseUnary(getIteratee())) : arrayMap(baseFlatten(transforms, 1), baseUnary(getIteratee()));
          var funcsLength = transforms.length;
          return baseRest(function(args) {
            var index = -1, length = nativeMin(args.length, funcsLength);
            while (++index < length) {
              args[index] = transforms[index].call(this, args[index]);
            }
            return apply(func, this, args);
          });
        });
        var partial = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partial));
          return createWrap(func, WRAP_PARTIAL_FLAG, undefined2, partials, holders);
        });
        var partialRight = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partialRight));
          return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined2, partials, holders);
        });
        var rearg = flatRest(function(func, indexes) {
          return createWrap(func, WRAP_REARG_FLAG, undefined2, undefined2, undefined2, indexes);
        });
        function rest(func, start) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          start = start === undefined2 ? start : toInteger(start);
          return baseRest(func, start);
        }
        function spread(func, start) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          start = start == null ? 0 : nativeMax(toInteger(start), 0);
          return baseRest(function(args) {
            var array = args[start], otherArgs = castSlice(args, 0, start);
            if (array) {
              arrayPush(otherArgs, array);
            }
            return apply(func, this, otherArgs);
          });
        }
        function throttle(func, wait, options) {
          var leading = true, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          if (isObject(options)) {
            leading = "leading" in options ? !!options.leading : leading;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          return debounce(func, wait, {
            "leading": leading,
            "maxWait": wait,
            "trailing": trailing
          });
        }
        function unary(func) {
          return ary(func, 1);
        }
        function wrap(value, wrapper) {
          return partial(castFunction(wrapper), value);
        }
        function castArray() {
          if (!arguments.length) {
            return [];
          }
          var value = arguments[0];
          return isArray(value) ? value : [value];
        }
        function clone(value) {
          return baseClone(value, CLONE_SYMBOLS_FLAG);
        }
        function cloneWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return baseClone(value, CLONE_SYMBOLS_FLAG, customizer);
        }
        function cloneDeep(value) {
          return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
        }
        function cloneDeepWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG, customizer);
        }
        function conformsTo(object, source) {
          return source == null || baseConformsTo(object, source, keys(source));
        }
        function eq(value, other) {
          return value === other || value !== value && other !== other;
        }
        var gt = createRelationalOperation(baseGt);
        var gte = createRelationalOperation(function(value, other) {
          return value >= other;
        });
        var isArguments = baseIsArguments(/* @__PURE__ */ function() {
          return arguments;
        }()) ? baseIsArguments : function(value) {
          return isObjectLike(value) && hasOwnProperty.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
        };
        var isArray = Array2.isArray;
        var isArrayBuffer = nodeIsArrayBuffer ? baseUnary(nodeIsArrayBuffer) : baseIsArrayBuffer;
        function isArrayLike(value) {
          return value != null && isLength(value.length) && !isFunction(value);
        }
        function isArrayLikeObject(value) {
          return isObjectLike(value) && isArrayLike(value);
        }
        function isBoolean(value) {
          return value === true || value === false || isObjectLike(value) && baseGetTag(value) == boolTag;
        }
        var isBuffer = nativeIsBuffer || stubFalse;
        var isDate = nodeIsDate ? baseUnary(nodeIsDate) : baseIsDate;
        function isElement(value) {
          return isObjectLike(value) && value.nodeType === 1 && !isPlainObject(value);
        }
        function isEmpty(value) {
          if (value == null) {
            return true;
          }
          if (isArrayLike(value) && (isArray(value) || typeof value == "string" || typeof value.splice == "function" || isBuffer(value) || isTypedArray(value) || isArguments(value))) {
            return !value.length;
          }
          var tag = getTag(value);
          if (tag == mapTag || tag == setTag) {
            return !value.size;
          }
          if (isPrototype(value)) {
            return !baseKeys(value).length;
          }
          for (var key in value) {
            if (hasOwnProperty.call(value, key)) {
              return false;
            }
          }
          return true;
        }
        function isEqual(value, other) {
          return baseIsEqual(value, other);
        }
        function isEqualWith(value, other, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          var result2 = customizer ? customizer(value, other) : undefined2;
          return result2 === undefined2 ? baseIsEqual(value, other, undefined2, customizer) : !!result2;
        }
        function isError(value) {
          if (!isObjectLike(value)) {
            return false;
          }
          var tag = baseGetTag(value);
          return tag == errorTag || tag == domExcTag || typeof value.message == "string" && typeof value.name == "string" && !isPlainObject(value);
        }
        function isFinite2(value) {
          return typeof value == "number" && nativeIsFinite(value);
        }
        function isFunction(value) {
          if (!isObject(value)) {
            return false;
          }
          var tag = baseGetTag(value);
          return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
        }
        function isInteger(value) {
          return typeof value == "number" && value == toInteger(value);
        }
        function isLength(value) {
          return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
        }
        function isObject(value) {
          var type = typeof value;
          return value != null && (type == "object" || type == "function");
        }
        function isObjectLike(value) {
          return value != null && typeof value == "object";
        }
        var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
        function isMatch(object, source) {
          return object === source || baseIsMatch(object, source, getMatchData(source));
        }
        function isMatchWith(object, source, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return baseIsMatch(object, source, getMatchData(source), customizer);
        }
        function isNaN2(value) {
          return isNumber(value) && value != +value;
        }
        function isNative(value) {
          if (isMaskable(value)) {
            throw new Error2(CORE_ERROR_TEXT);
          }
          return baseIsNative(value);
        }
        function isNull(value) {
          return value === null;
        }
        function isNil(value) {
          return value == null;
        }
        function isNumber(value) {
          return typeof value == "number" || isObjectLike(value) && baseGetTag(value) == numberTag;
        }
        function isPlainObject(value) {
          if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
            return false;
          }
          var proto = getPrototype(value);
          if (proto === null) {
            return true;
          }
          var Ctor = hasOwnProperty.call(proto, "constructor") && proto.constructor;
          return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
        }
        var isRegExp = nodeIsRegExp ? baseUnary(nodeIsRegExp) : baseIsRegExp;
        function isSafeInteger(value) {
          return isInteger(value) && value >= -MAX_SAFE_INTEGER && value <= MAX_SAFE_INTEGER;
        }
        var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
        function isString(value) {
          return typeof value == "string" || !isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag;
        }
        function isSymbol(value) {
          return typeof value == "symbol" || isObjectLike(value) && baseGetTag(value) == symbolTag;
        }
        var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
        function isUndefined(value) {
          return value === undefined2;
        }
        function isWeakMap(value) {
          return isObjectLike(value) && getTag(value) == weakMapTag;
        }
        function isWeakSet(value) {
          return isObjectLike(value) && baseGetTag(value) == weakSetTag;
        }
        var lt = createRelationalOperation(baseLt);
        var lte = createRelationalOperation(function(value, other) {
          return value <= other;
        });
        function toArray(value) {
          if (!value) {
            return [];
          }
          if (isArrayLike(value)) {
            return isString(value) ? stringToArray(value) : copyArray(value);
          }
          if (symIterator && value[symIterator]) {
            return iteratorToArray(value[symIterator]());
          }
          var tag = getTag(value), func = tag == mapTag ? mapToArray : tag == setTag ? setToArray : values;
          return func(value);
        }
        function toFinite(value) {
          if (!value) {
            return value === 0 ? value : 0;
          }
          value = toNumber(value);
          if (value === INFINITY || value === -INFINITY) {
            var sign = value < 0 ? -1 : 1;
            return sign * MAX_INTEGER;
          }
          return value === value ? value : 0;
        }
        function toInteger(value) {
          var result2 = toFinite(value), remainder = result2 % 1;
          return result2 === result2 ? remainder ? result2 - remainder : result2 : 0;
        }
        function toLength(value) {
          return value ? baseClamp(toInteger(value), 0, MAX_ARRAY_LENGTH) : 0;
        }
        function toNumber(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol(value)) {
            return NAN;
          }
          if (isObject(value)) {
            var other = typeof value.valueOf == "function" ? value.valueOf() : value;
            value = isObject(other) ? other + "" : other;
          }
          if (typeof value != "string") {
            return value === 0 ? value : +value;
          }
          value = baseTrim(value);
          var isBinary = reIsBinary.test(value);
          return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
        }
        function toPlainObject(value) {
          return copyObject(value, keysIn(value));
        }
        function toSafeInteger(value) {
          return value ? baseClamp(toInteger(value), -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER) : value === 0 ? value : 0;
        }
        function toString(value) {
          return value == null ? "" : baseToString(value);
        }
        var assign = createAssigner(function(object, source) {
          if (isPrototype(source) || isArrayLike(source)) {
            copyObject(source, keys(source), object);
            return;
          }
          for (var key in source) {
            if (hasOwnProperty.call(source, key)) {
              assignValue(object, key, source[key]);
            }
          }
        });
        var assignIn = createAssigner(function(object, source) {
          copyObject(source, keysIn(source), object);
        });
        var assignInWith = createAssigner(function(object, source, srcIndex, customizer) {
          copyObject(source, keysIn(source), object, customizer);
        });
        var assignWith = createAssigner(function(object, source, srcIndex, customizer) {
          copyObject(source, keys(source), object, customizer);
        });
        var at = flatRest(baseAt);
        function create(prototype, properties) {
          var result2 = baseCreate(prototype);
          return properties == null ? result2 : baseAssign(result2, properties);
        }
        var defaults = baseRest(function(object, sources) {
          object = Object2(object);
          var index = -1;
          var length = sources.length;
          var guard = length > 2 ? sources[2] : undefined2;
          if (guard && isIterateeCall(sources[0], sources[1], guard)) {
            length = 1;
          }
          while (++index < length) {
            var source = sources[index];
            var props = keysIn(source);
            var propsIndex = -1;
            var propsLength = props.length;
            while (++propsIndex < propsLength) {
              var key = props[propsIndex];
              var value = object[key];
              if (value === undefined2 || eq(value, objectProto[key]) && !hasOwnProperty.call(object, key)) {
                object[key] = source[key];
              }
            }
          }
          return object;
        });
        var defaultsDeep = baseRest(function(args) {
          args.push(undefined2, customDefaultsMerge);
          return apply(mergeWith, undefined2, args);
        });
        function findKey(object, predicate) {
          return baseFindKey(object, getIteratee(predicate, 3), baseForOwn);
        }
        function findLastKey(object, predicate) {
          return baseFindKey(object, getIteratee(predicate, 3), baseForOwnRight);
        }
        function forIn(object, iteratee2) {
          return object == null ? object : baseFor(object, getIteratee(iteratee2, 3), keysIn);
        }
        function forInRight(object, iteratee2) {
          return object == null ? object : baseForRight(object, getIteratee(iteratee2, 3), keysIn);
        }
        function forOwn(object, iteratee2) {
          return object && baseForOwn(object, getIteratee(iteratee2, 3));
        }
        function forOwnRight(object, iteratee2) {
          return object && baseForOwnRight(object, getIteratee(iteratee2, 3));
        }
        function functions(object) {
          return object == null ? [] : baseFunctions(object, keys(object));
        }
        function functionsIn(object) {
          return object == null ? [] : baseFunctions(object, keysIn(object));
        }
        function get(object, path4, defaultValue) {
          var result2 = object == null ? undefined2 : baseGet(object, path4);
          return result2 === undefined2 ? defaultValue : result2;
        }
        function has(object, path4) {
          return object != null && hasPath(object, path4, baseHas);
        }
        function hasIn(object, path4) {
          return object != null && hasPath(object, path4, baseHasIn);
        }
        var invert = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString.call(value);
          }
          result2[value] = key;
        }, constant(identity));
        var invertBy = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString.call(value);
          }
          if (hasOwnProperty.call(result2, value)) {
            result2[value].push(key);
          } else {
            result2[value] = [key];
          }
        }, getIteratee);
        var invoke = baseRest(baseInvoke);
        function keys(object) {
          return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
        }
        function keysIn(object) {
          return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
        }
        function mapKeys(object, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object, function(value, key, object2) {
            baseAssignValue(result2, iteratee2(value, key, object2), value);
          });
          return result2;
        }
        function mapValues(object, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object, function(value, key, object2) {
            baseAssignValue(result2, key, iteratee2(value, key, object2));
          });
          return result2;
        }
        var merge = createAssigner(function(object, source, srcIndex) {
          baseMerge(object, source, srcIndex);
        });
        var mergeWith = createAssigner(function(object, source, srcIndex, customizer) {
          baseMerge(object, source, srcIndex, customizer);
        });
        var omit = flatRest(function(object, paths) {
          var result2 = {};
          if (object == null) {
            return result2;
          }
          var isDeep = false;
          paths = arrayMap(paths, function(path4) {
            path4 = castPath(path4, object);
            isDeep || (isDeep = path4.length > 1);
            return path4;
          });
          copyObject(object, getAllKeysIn(object), result2);
          if (isDeep) {
            result2 = baseClone(result2, CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG, customOmitClone);
          }
          var length = paths.length;
          while (length--) {
            baseUnset(result2, paths[length]);
          }
          return result2;
        });
        function omitBy(object, predicate) {
          return pickBy(object, negate(getIteratee(predicate)));
        }
        var pick = flatRest(function(object, paths) {
          return object == null ? {} : basePick(object, paths);
        });
        function pickBy(object, predicate) {
          if (object == null) {
            return {};
          }
          var props = arrayMap(getAllKeysIn(object), function(prop) {
            return [prop];
          });
          predicate = getIteratee(predicate);
          return basePickBy(object, props, function(value, path4) {
            return predicate(value, path4[0]);
          });
        }
        function result(object, path4, defaultValue) {
          path4 = castPath(path4, object);
          var index = -1, length = path4.length;
          if (!length) {
            length = 1;
            object = undefined2;
          }
          while (++index < length) {
            var value = object == null ? undefined2 : object[toKey(path4[index])];
            if (value === undefined2) {
              index = length;
              value = defaultValue;
            }
            object = isFunction(value) ? value.call(object) : value;
          }
          return object;
        }
        function set(object, path4, value) {
          return object == null ? object : baseSet(object, path4, value);
        }
        function setWith(object, path4, value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return object == null ? object : baseSet(object, path4, value, customizer);
        }
        var toPairs = createToPairs(keys);
        var toPairsIn = createToPairs(keysIn);
        function transform(object, iteratee2, accumulator) {
          var isArr = isArray(object), isArrLike = isArr || isBuffer(object) || isTypedArray(object);
          iteratee2 = getIteratee(iteratee2, 4);
          if (accumulator == null) {
            var Ctor = object && object.constructor;
            if (isArrLike) {
              accumulator = isArr ? new Ctor() : [];
            } else if (isObject(object)) {
              accumulator = isFunction(Ctor) ? baseCreate(getPrototype(object)) : {};
            } else {
              accumulator = {};
            }
          }
          (isArrLike ? arrayEach : baseForOwn)(object, function(value, index, object2) {
            return iteratee2(accumulator, value, index, object2);
          });
          return accumulator;
        }
        function unset(object, path4) {
          return object == null ? true : baseUnset(object, path4);
        }
        function update(object, path4, updater) {
          return object == null ? object : baseUpdate(object, path4, castFunction(updater));
        }
        function updateWith(object, path4, updater, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return object == null ? object : baseUpdate(object, path4, castFunction(updater), customizer);
        }
        function values(object) {
          return object == null ? [] : baseValues(object, keys(object));
        }
        function valuesIn(object) {
          return object == null ? [] : baseValues(object, keysIn(object));
        }
        function clamp(number, lower, upper) {
          if (upper === undefined2) {
            upper = lower;
            lower = undefined2;
          }
          if (upper !== undefined2) {
            upper = toNumber(upper);
            upper = upper === upper ? upper : 0;
          }
          if (lower !== undefined2) {
            lower = toNumber(lower);
            lower = lower === lower ? lower : 0;
          }
          return baseClamp(toNumber(number), lower, upper);
        }
        function inRange(number, start, end) {
          start = toFinite(start);
          if (end === undefined2) {
            end = start;
            start = 0;
          } else {
            end = toFinite(end);
          }
          number = toNumber(number);
          return baseInRange(number, start, end);
        }
        function random(lower, upper, floating) {
          if (floating && typeof floating != "boolean" && isIterateeCall(lower, upper, floating)) {
            upper = floating = undefined2;
          }
          if (floating === undefined2) {
            if (typeof upper == "boolean") {
              floating = upper;
              upper = undefined2;
            } else if (typeof lower == "boolean") {
              floating = lower;
              lower = undefined2;
            }
          }
          if (lower === undefined2 && upper === undefined2) {
            lower = 0;
            upper = 1;
          } else {
            lower = toFinite(lower);
            if (upper === undefined2) {
              upper = lower;
              lower = 0;
            } else {
              upper = toFinite(upper);
            }
          }
          if (lower > upper) {
            var temp = lower;
            lower = upper;
            upper = temp;
          }
          if (floating || lower % 1 || upper % 1) {
            var rand = nativeRandom();
            return nativeMin(lower + rand * (upper - lower + freeParseFloat("1e-" + ((rand + "").length - 1))), upper);
          }
          return baseRandom(lower, upper);
        }
        var camelCase = createCompounder(function(result2, word, index) {
          word = word.toLowerCase();
          return result2 + (index ? capitalize(word) : word);
        });
        function capitalize(string) {
          return upperFirst(toString(string).toLowerCase());
        }
        function deburr(string) {
          string = toString(string);
          return string && string.replace(reLatin, deburrLetter).replace(reComboMark, "");
        }
        function endsWith(string, target, position) {
          string = toString(string);
          target = baseToString(target);
          var length = string.length;
          position = position === undefined2 ? length : baseClamp(toInteger(position), 0, length);
          var end = position;
          position -= target.length;
          return position >= 0 && string.slice(position, end) == target;
        }
        function escape2(string) {
          string = toString(string);
          return string && reHasUnescapedHtml.test(string) ? string.replace(reUnescapedHtml, escapeHtmlChar) : string;
        }
        function escapeRegExp(string) {
          string = toString(string);
          return string && reHasRegExpChar.test(string) ? string.replace(reRegExpChar, "\\$&") : string;
        }
        var kebabCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? "-" : "") + word.toLowerCase();
        });
        var lowerCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? " " : "") + word.toLowerCase();
        });
        var lowerFirst = createCaseFirst("toLowerCase");
        function pad(string, length, chars) {
          string = toString(string);
          length = toInteger(length);
          var strLength = length ? stringSize(string) : 0;
          if (!length || strLength >= length) {
            return string;
          }
          var mid = (length - strLength) / 2;
          return createPadding(nativeFloor(mid), chars) + string + createPadding(nativeCeil(mid), chars);
        }
        function padEnd(string, length, chars) {
          string = toString(string);
          length = toInteger(length);
          var strLength = length ? stringSize(string) : 0;
          return length && strLength < length ? string + createPadding(length - strLength, chars) : string;
        }
        function padStart(string, length, chars) {
          string = toString(string);
          length = toInteger(length);
          var strLength = length ? stringSize(string) : 0;
          return length && strLength < length ? createPadding(length - strLength, chars) + string : string;
        }
        function parseInt2(string, radix, guard) {
          if (guard || radix == null) {
            radix = 0;
          } else if (radix) {
            radix = +radix;
          }
          return nativeParseInt(toString(string).replace(reTrimStart, ""), radix || 0);
        }
        function repeat(string, n, guard) {
          if (guard ? isIterateeCall(string, n, guard) : n === undefined2) {
            n = 1;
          } else {
            n = toInteger(n);
          }
          return baseRepeat(toString(string), n);
        }
        function replace() {
          var args = arguments, string = toString(args[0]);
          return args.length < 3 ? string : string.replace(args[1], args[2]);
        }
        var snakeCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? "_" : "") + word.toLowerCase();
        });
        function split(string, separator, limit) {
          if (limit && typeof limit != "number" && isIterateeCall(string, separator, limit)) {
            separator = limit = undefined2;
          }
          limit = limit === undefined2 ? MAX_ARRAY_LENGTH : limit >>> 0;
          if (!limit) {
            return [];
          }
          string = toString(string);
          if (string && (typeof separator == "string" || separator != null && !isRegExp(separator))) {
            separator = baseToString(separator);
            if (!separator && hasUnicode(string)) {
              return castSlice(stringToArray(string), 0, limit);
            }
          }
          return string.split(separator, limit);
        }
        var startCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? " " : "") + upperFirst(word);
        });
        function startsWith(string, target, position) {
          string = toString(string);
          position = position == null ? 0 : baseClamp(toInteger(position), 0, string.length);
          target = baseToString(target);
          return string.slice(position, position + target.length) == target;
        }
        function template(string, options, guard) {
          var settings = lodash.templateSettings;
          if (guard && isIterateeCall(string, options, guard)) {
            options = undefined2;
          }
          string = toString(string);
          options = assignInWith({}, options, settings, customDefaultsAssignIn);
          var imports = assignInWith({}, options.imports, settings.imports, customDefaultsAssignIn), importsKeys = keys(imports), importsValues = baseValues(imports, importsKeys);
          var isEscaping, isEvaluating, index = 0, interpolate = options.interpolate || reNoMatch, source = "__p += '";
          var reDelimiters = RegExp2(
            (options.escape || reNoMatch).source + "|" + interpolate.source + "|" + (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + "|" + (options.evaluate || reNoMatch).source + "|$",
            "g"
          );
          var sourceURL = "//# sourceURL=" + (hasOwnProperty.call(options, "sourceURL") ? (options.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++templateCounter + "]") + "\n";
          string.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
            interpolateValue || (interpolateValue = esTemplateValue);
            source += string.slice(index, offset).replace(reUnescapedString, escapeStringChar);
            if (escapeValue) {
              isEscaping = true;
              source += "' +\n__e(" + escapeValue + ") +\n'";
            }
            if (evaluateValue) {
              isEvaluating = true;
              source += "';\n" + evaluateValue + ";\n__p += '";
            }
            if (interpolateValue) {
              source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
            }
            index = offset + match.length;
            return match;
          });
          source += "';\n";
          var variable = hasOwnProperty.call(options, "variable") && options.variable;
          if (!variable) {
            source = "with (obj) {\n" + source + "\n}\n";
          } else if (reForbiddenIdentifierChars.test(variable)) {
            throw new Error2(INVALID_TEMPL_VAR_ERROR_TEXT);
          }
          source = (isEvaluating ? source.replace(reEmptyStringLeading, "") : source).replace(reEmptyStringMiddle, "$1").replace(reEmptyStringTrailing, "$1;");
          source = "function(" + (variable || "obj") + ") {\n" + (variable ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (isEscaping ? ", __e = _.escape" : "") + (isEvaluating ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + source + "return __p\n}";
          var result2 = attempt(function() {
            return Function2(importsKeys, sourceURL + "return " + source).apply(undefined2, importsValues);
          });
          result2.source = source;
          if (isError(result2)) {
            throw result2;
          }
          return result2;
        }
        function toLower(value) {
          return toString(value).toLowerCase();
        }
        function toUpper(value) {
          return toString(value).toUpperCase();
        }
        function trim(string, chars, guard) {
          string = toString(string);
          if (string && (guard || chars === undefined2)) {
            return baseTrim(string);
          }
          if (!string || !(chars = baseToString(chars))) {
            return string;
          }
          var strSymbols = stringToArray(string), chrSymbols = stringToArray(chars), start = charsStartIndex(strSymbols, chrSymbols), end = charsEndIndex(strSymbols, chrSymbols) + 1;
          return castSlice(strSymbols, start, end).join("");
        }
        function trimEnd(string, chars, guard) {
          string = toString(string);
          if (string && (guard || chars === undefined2)) {
            return string.slice(0, trimmedEndIndex(string) + 1);
          }
          if (!string || !(chars = baseToString(chars))) {
            return string;
          }
          var strSymbols = stringToArray(string), end = charsEndIndex(strSymbols, stringToArray(chars)) + 1;
          return castSlice(strSymbols, 0, end).join("");
        }
        function trimStart(string, chars, guard) {
          string = toString(string);
          if (string && (guard || chars === undefined2)) {
            return string.replace(reTrimStart, "");
          }
          if (!string || !(chars = baseToString(chars))) {
            return string;
          }
          var strSymbols = stringToArray(string), start = charsStartIndex(strSymbols, stringToArray(chars));
          return castSlice(strSymbols, start).join("");
        }
        function truncate(string, options) {
          var length = DEFAULT_TRUNC_LENGTH, omission = DEFAULT_TRUNC_OMISSION;
          if (isObject(options)) {
            var separator = "separator" in options ? options.separator : separator;
            length = "length" in options ? toInteger(options.length) : length;
            omission = "omission" in options ? baseToString(options.omission) : omission;
          }
          string = toString(string);
          var strLength = string.length;
          if (hasUnicode(string)) {
            var strSymbols = stringToArray(string);
            strLength = strSymbols.length;
          }
          if (length >= strLength) {
            return string;
          }
          var end = length - stringSize(omission);
          if (end < 1) {
            return omission;
          }
          var result2 = strSymbols ? castSlice(strSymbols, 0, end).join("") : string.slice(0, end);
          if (separator === undefined2) {
            return result2 + omission;
          }
          if (strSymbols) {
            end += result2.length - end;
          }
          if (isRegExp(separator)) {
            if (string.slice(end).search(separator)) {
              var match, substring = result2;
              if (!separator.global) {
                separator = RegExp2(separator.source, toString(reFlags.exec(separator)) + "g");
              }
              separator.lastIndex = 0;
              while (match = separator.exec(substring)) {
                var newEnd = match.index;
              }
              result2 = result2.slice(0, newEnd === undefined2 ? end : newEnd);
            }
          } else if (string.indexOf(baseToString(separator), end) != end) {
            var index = result2.lastIndexOf(separator);
            if (index > -1) {
              result2 = result2.slice(0, index);
            }
          }
          return result2 + omission;
        }
        function unescape2(string) {
          string = toString(string);
          return string && reHasEscapedHtml.test(string) ? string.replace(reEscapedHtml, unescapeHtmlChar) : string;
        }
        var upperCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? " " : "") + word.toUpperCase();
        });
        var upperFirst = createCaseFirst("toUpperCase");
        function words(string, pattern, guard) {
          string = toString(string);
          pattern = guard ? undefined2 : pattern;
          if (pattern === undefined2) {
            return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
          }
          return string.match(pattern) || [];
        }
        var attempt = baseRest(function(func, args) {
          try {
            return apply(func, undefined2, args);
          } catch (e) {
            return isError(e) ? e : new Error2(e);
          }
        });
        var bindAll = flatRest(function(object, methodNames) {
          arrayEach(methodNames, function(key) {
            key = toKey(key);
            baseAssignValue(object, key, bind(object[key], object));
          });
          return object;
        });
        function cond(pairs) {
          var length = pairs == null ? 0 : pairs.length, toIteratee = getIteratee();
          pairs = !length ? [] : arrayMap(pairs, function(pair) {
            if (typeof pair[1] != "function") {
              throw new TypeError2(FUNC_ERROR_TEXT);
            }
            return [toIteratee(pair[0]), pair[1]];
          });
          return baseRest(function(args) {
            var index = -1;
            while (++index < length) {
              var pair = pairs[index];
              if (apply(pair[0], this, args)) {
                return apply(pair[1], this, args);
              }
            }
          });
        }
        function conforms(source) {
          return baseConforms(baseClone(source, CLONE_DEEP_FLAG));
        }
        function constant(value) {
          return function() {
            return value;
          };
        }
        function defaultTo(value, defaultValue) {
          return value == null || value !== value ? defaultValue : value;
        }
        var flow = createFlow();
        var flowRight = createFlow(true);
        function identity(value) {
          return value;
        }
        function iteratee(func) {
          return baseIteratee(typeof func == "function" ? func : baseClone(func, CLONE_DEEP_FLAG));
        }
        function matches(source) {
          return baseMatches(baseClone(source, CLONE_DEEP_FLAG));
        }
        function matchesProperty(path4, srcValue) {
          return baseMatchesProperty(path4, baseClone(srcValue, CLONE_DEEP_FLAG));
        }
        var method = baseRest(function(path4, args) {
          return function(object) {
            return baseInvoke(object, path4, args);
          };
        });
        var methodOf = baseRest(function(object, args) {
          return function(path4) {
            return baseInvoke(object, path4, args);
          };
        });
        function mixin(object, source, options) {
          var props = keys(source), methodNames = baseFunctions(source, props);
          if (options == null && !(isObject(source) && (methodNames.length || !props.length))) {
            options = source;
            source = object;
            object = this;
            methodNames = baseFunctions(source, keys(source));
          }
          var chain2 = !(isObject(options) && "chain" in options) || !!options.chain, isFunc = isFunction(object);
          arrayEach(methodNames, function(methodName) {
            var func = source[methodName];
            object[methodName] = func;
            if (isFunc) {
              object.prototype[methodName] = function() {
                var chainAll = this.__chain__;
                if (chain2 || chainAll) {
                  var result2 = object(this.__wrapped__), actions = result2.__actions__ = copyArray(this.__actions__);
                  actions.push({ "func": func, "args": arguments, "thisArg": object });
                  result2.__chain__ = chainAll;
                  return result2;
                }
                return func.apply(object, arrayPush([this.value()], arguments));
              };
            }
          });
          return object;
        }
        function noConflict() {
          if (root._ === this) {
            root._ = oldDash;
          }
          return this;
        }
        function noop() {
        }
        function nthArg(n) {
          n = toInteger(n);
          return baseRest(function(args) {
            return baseNth(args, n);
          });
        }
        var over = createOver(arrayMap);
        var overEvery = createOver(arrayEvery);
        var overSome = createOver(arraySome);
        function property(path4) {
          return isKey(path4) ? baseProperty(toKey(path4)) : basePropertyDeep(path4);
        }
        function propertyOf(object) {
          return function(path4) {
            return object == null ? undefined2 : baseGet(object, path4);
          };
        }
        var range = createRange();
        var rangeRight = createRange(true);
        function stubArray() {
          return [];
        }
        function stubFalse() {
          return false;
        }
        function stubObject() {
          return {};
        }
        function stubString() {
          return "";
        }
        function stubTrue() {
          return true;
        }
        function times(n, iteratee2) {
          n = toInteger(n);
          if (n < 1 || n > MAX_SAFE_INTEGER) {
            return [];
          }
          var index = MAX_ARRAY_LENGTH, length = nativeMin(n, MAX_ARRAY_LENGTH);
          iteratee2 = getIteratee(iteratee2);
          n -= MAX_ARRAY_LENGTH;
          var result2 = baseTimes(length, iteratee2);
          while (++index < n) {
            iteratee2(index);
          }
          return result2;
        }
        function toPath(value) {
          if (isArray(value)) {
            return arrayMap(value, toKey);
          }
          return isSymbol(value) ? [value] : copyArray(stringToPath(toString(value)));
        }
        function uniqueId(prefix) {
          var id = ++idCounter;
          return toString(prefix) + id;
        }
        var add = createMathOperation(function(augend, addend) {
          return augend + addend;
        }, 0);
        var ceil = createRound("ceil");
        var divide = createMathOperation(function(dividend, divisor) {
          return dividend / divisor;
        }, 1);
        var floor = createRound("floor");
        function max(array) {
          return array && array.length ? baseExtremum(array, identity, baseGt) : undefined2;
        }
        function maxBy(array, iteratee2) {
          return array && array.length ? baseExtremum(array, getIteratee(iteratee2, 2), baseGt) : undefined2;
        }
        function mean(array) {
          return baseMean(array, identity);
        }
        function meanBy(array, iteratee2) {
          return baseMean(array, getIteratee(iteratee2, 2));
        }
        function min(array) {
          return array && array.length ? baseExtremum(array, identity, baseLt) : undefined2;
        }
        function minBy(array, iteratee2) {
          return array && array.length ? baseExtremum(array, getIteratee(iteratee2, 2), baseLt) : undefined2;
        }
        var multiply = createMathOperation(function(multiplier, multiplicand) {
          return multiplier * multiplicand;
        }, 1);
        var round = createRound("round");
        var subtract = createMathOperation(function(minuend, subtrahend) {
          return minuend - subtrahend;
        }, 0);
        function sum(array) {
          return array && array.length ? baseSum(array, identity) : 0;
        }
        function sumBy(array, iteratee2) {
          return array && array.length ? baseSum(array, getIteratee(iteratee2, 2)) : 0;
        }
        lodash.after = after;
        lodash.ary = ary;
        lodash.assign = assign;
        lodash.assignIn = assignIn;
        lodash.assignInWith = assignInWith;
        lodash.assignWith = assignWith;
        lodash.at = at;
        lodash.before = before;
        lodash.bind = bind;
        lodash.bindAll = bindAll;
        lodash.bindKey = bindKey;
        lodash.castArray = castArray;
        lodash.chain = chain;
        lodash.chunk = chunk;
        lodash.compact = compact;
        lodash.concat = concat;
        lodash.cond = cond;
        lodash.conforms = conforms;
        lodash.constant = constant;
        lodash.countBy = countBy;
        lodash.create = create;
        lodash.curry = curry;
        lodash.curryRight = curryRight;
        lodash.debounce = debounce;
        lodash.defaults = defaults;
        lodash.defaultsDeep = defaultsDeep;
        lodash.defer = defer;
        lodash.delay = delay;
        lodash.difference = difference;
        lodash.differenceBy = differenceBy;
        lodash.differenceWith = differenceWith;
        lodash.drop = drop;
        lodash.dropRight = dropRight;
        lodash.dropRightWhile = dropRightWhile;
        lodash.dropWhile = dropWhile;
        lodash.fill = fill;
        lodash.filter = filter;
        lodash.flatMap = flatMap;
        lodash.flatMapDeep = flatMapDeep;
        lodash.flatMapDepth = flatMapDepth;
        lodash.flatten = flatten;
        lodash.flattenDeep = flattenDeep;
        lodash.flattenDepth = flattenDepth;
        lodash.flip = flip;
        lodash.flow = flow;
        lodash.flowRight = flowRight;
        lodash.fromPairs = fromPairs;
        lodash.functions = functions;
        lodash.functionsIn = functionsIn;
        lodash.groupBy = groupBy;
        lodash.initial = initial;
        lodash.intersection = intersection;
        lodash.intersectionBy = intersectionBy;
        lodash.intersectionWith = intersectionWith;
        lodash.invert = invert;
        lodash.invertBy = invertBy;
        lodash.invokeMap = invokeMap;
        lodash.iteratee = iteratee;
        lodash.keyBy = keyBy;
        lodash.keys = keys;
        lodash.keysIn = keysIn;
        lodash.map = map;
        lodash.mapKeys = mapKeys;
        lodash.mapValues = mapValues;
        lodash.matches = matches;
        lodash.matchesProperty = matchesProperty;
        lodash.memoize = memoize;
        lodash.merge = merge;
        lodash.mergeWith = mergeWith;
        lodash.method = method;
        lodash.methodOf = methodOf;
        lodash.mixin = mixin;
        lodash.negate = negate;
        lodash.nthArg = nthArg;
        lodash.omit = omit;
        lodash.omitBy = omitBy;
        lodash.once = once;
        lodash.orderBy = orderBy;
        lodash.over = over;
        lodash.overArgs = overArgs;
        lodash.overEvery = overEvery;
        lodash.overSome = overSome;
        lodash.partial = partial;
        lodash.partialRight = partialRight;
        lodash.partition = partition;
        lodash.pick = pick;
        lodash.pickBy = pickBy;
        lodash.property = property;
        lodash.propertyOf = propertyOf;
        lodash.pull = pull;
        lodash.pullAll = pullAll;
        lodash.pullAllBy = pullAllBy;
        lodash.pullAllWith = pullAllWith;
        lodash.pullAt = pullAt;
        lodash.range = range;
        lodash.rangeRight = rangeRight;
        lodash.rearg = rearg;
        lodash.reject = reject;
        lodash.remove = remove;
        lodash.rest = rest;
        lodash.reverse = reverse;
        lodash.sampleSize = sampleSize;
        lodash.set = set;
        lodash.setWith = setWith;
        lodash.shuffle = shuffle;
        lodash.slice = slice;
        lodash.sortBy = sortBy;
        lodash.sortedUniq = sortedUniq;
        lodash.sortedUniqBy = sortedUniqBy;
        lodash.split = split;
        lodash.spread = spread;
        lodash.tail = tail;
        lodash.take = take;
        lodash.takeRight = takeRight;
        lodash.takeRightWhile = takeRightWhile;
        lodash.takeWhile = takeWhile;
        lodash.tap = tap;
        lodash.throttle = throttle;
        lodash.thru = thru;
        lodash.toArray = toArray;
        lodash.toPairs = toPairs;
        lodash.toPairsIn = toPairsIn;
        lodash.toPath = toPath;
        lodash.toPlainObject = toPlainObject;
        lodash.transform = transform;
        lodash.unary = unary;
        lodash.union = union;
        lodash.unionBy = unionBy;
        lodash.unionWith = unionWith;
        lodash.uniq = uniq;
        lodash.uniqBy = uniqBy;
        lodash.uniqWith = uniqWith;
        lodash.unset = unset;
        lodash.unzip = unzip;
        lodash.unzipWith = unzipWith;
        lodash.update = update;
        lodash.updateWith = updateWith;
        lodash.values = values;
        lodash.valuesIn = valuesIn;
        lodash.without = without;
        lodash.words = words;
        lodash.wrap = wrap;
        lodash.xor = xor;
        lodash.xorBy = xorBy;
        lodash.xorWith = xorWith;
        lodash.zip = zip;
        lodash.zipObject = zipObject;
        lodash.zipObjectDeep = zipObjectDeep;
        lodash.zipWith = zipWith;
        lodash.entries = toPairs;
        lodash.entriesIn = toPairsIn;
        lodash.extend = assignIn;
        lodash.extendWith = assignInWith;
        mixin(lodash, lodash);
        lodash.add = add;
        lodash.attempt = attempt;
        lodash.camelCase = camelCase;
        lodash.capitalize = capitalize;
        lodash.ceil = ceil;
        lodash.clamp = clamp;
        lodash.clone = clone;
        lodash.cloneDeep = cloneDeep;
        lodash.cloneDeepWith = cloneDeepWith;
        lodash.cloneWith = cloneWith;
        lodash.conformsTo = conformsTo;
        lodash.deburr = deburr;
        lodash.defaultTo = defaultTo;
        lodash.divide = divide;
        lodash.endsWith = endsWith;
        lodash.eq = eq;
        lodash.escape = escape2;
        lodash.escapeRegExp = escapeRegExp;
        lodash.every = every;
        lodash.find = find;
        lodash.findIndex = findIndex;
        lodash.findKey = findKey;
        lodash.findLast = findLast;
        lodash.findLastIndex = findLastIndex;
        lodash.findLastKey = findLastKey;
        lodash.floor = floor;
        lodash.forEach = forEach;
        lodash.forEachRight = forEachRight;
        lodash.forIn = forIn;
        lodash.forInRight = forInRight;
        lodash.forOwn = forOwn;
        lodash.forOwnRight = forOwnRight;
        lodash.get = get;
        lodash.gt = gt;
        lodash.gte = gte;
        lodash.has = has;
        lodash.hasIn = hasIn;
        lodash.head = head;
        lodash.identity = identity;
        lodash.includes = includes;
        lodash.indexOf = indexOf;
        lodash.inRange = inRange;
        lodash.invoke = invoke;
        lodash.isArguments = isArguments;
        lodash.isArray = isArray;
        lodash.isArrayBuffer = isArrayBuffer;
        lodash.isArrayLike = isArrayLike;
        lodash.isArrayLikeObject = isArrayLikeObject;
        lodash.isBoolean = isBoolean;
        lodash.isBuffer = isBuffer;
        lodash.isDate = isDate;
        lodash.isElement = isElement;
        lodash.isEmpty = isEmpty;
        lodash.isEqual = isEqual;
        lodash.isEqualWith = isEqualWith;
        lodash.isError = isError;
        lodash.isFinite = isFinite2;
        lodash.isFunction = isFunction;
        lodash.isInteger = isInteger;
        lodash.isLength = isLength;
        lodash.isMap = isMap;
        lodash.isMatch = isMatch;
        lodash.isMatchWith = isMatchWith;
        lodash.isNaN = isNaN2;
        lodash.isNative = isNative;
        lodash.isNil = isNil;
        lodash.isNull = isNull;
        lodash.isNumber = isNumber;
        lodash.isObject = isObject;
        lodash.isObjectLike = isObjectLike;
        lodash.isPlainObject = isPlainObject;
        lodash.isRegExp = isRegExp;
        lodash.isSafeInteger = isSafeInteger;
        lodash.isSet = isSet;
        lodash.isString = isString;
        lodash.isSymbol = isSymbol;
        lodash.isTypedArray = isTypedArray;
        lodash.isUndefined = isUndefined;
        lodash.isWeakMap = isWeakMap;
        lodash.isWeakSet = isWeakSet;
        lodash.join = join2;
        lodash.kebabCase = kebabCase;
        lodash.last = last;
        lodash.lastIndexOf = lastIndexOf;
        lodash.lowerCase = lowerCase;
        lodash.lowerFirst = lowerFirst;
        lodash.lt = lt;
        lodash.lte = lte;
        lodash.max = max;
        lodash.maxBy = maxBy;
        lodash.mean = mean;
        lodash.meanBy = meanBy;
        lodash.min = min;
        lodash.minBy = minBy;
        lodash.stubArray = stubArray;
        lodash.stubFalse = stubFalse;
        lodash.stubObject = stubObject;
        lodash.stubString = stubString;
        lodash.stubTrue = stubTrue;
        lodash.multiply = multiply;
        lodash.nth = nth;
        lodash.noConflict = noConflict;
        lodash.noop = noop;
        lodash.now = now;
        lodash.pad = pad;
        lodash.padEnd = padEnd;
        lodash.padStart = padStart;
        lodash.parseInt = parseInt2;
        lodash.random = random;
        lodash.reduce = reduce;
        lodash.reduceRight = reduceRight;
        lodash.repeat = repeat;
        lodash.replace = replace;
        lodash.result = result;
        lodash.round = round;
        lodash.runInContext = runInContext2;
        lodash.sample = sample;
        lodash.size = size;
        lodash.snakeCase = snakeCase;
        lodash.some = some;
        lodash.sortedIndex = sortedIndex;
        lodash.sortedIndexBy = sortedIndexBy;
        lodash.sortedIndexOf = sortedIndexOf;
        lodash.sortedLastIndex = sortedLastIndex;
        lodash.sortedLastIndexBy = sortedLastIndexBy;
        lodash.sortedLastIndexOf = sortedLastIndexOf;
        lodash.startCase = startCase;
        lodash.startsWith = startsWith;
        lodash.subtract = subtract;
        lodash.sum = sum;
        lodash.sumBy = sumBy;
        lodash.template = template;
        lodash.times = times;
        lodash.toFinite = toFinite;
        lodash.toInteger = toInteger;
        lodash.toLength = toLength;
        lodash.toLower = toLower;
        lodash.toNumber = toNumber;
        lodash.toSafeInteger = toSafeInteger;
        lodash.toString = toString;
        lodash.toUpper = toUpper;
        lodash.trim = trim;
        lodash.trimEnd = trimEnd;
        lodash.trimStart = trimStart;
        lodash.truncate = truncate;
        lodash.unescape = unescape2;
        lodash.uniqueId = uniqueId;
        lodash.upperCase = upperCase;
        lodash.upperFirst = upperFirst;
        lodash.each = forEach;
        lodash.eachRight = forEachRight;
        lodash.first = head;
        mixin(lodash, function() {
          var source = {};
          baseForOwn(lodash, function(func, methodName) {
            if (!hasOwnProperty.call(lodash.prototype, methodName)) {
              source[methodName] = func;
            }
          });
          return source;
        }(), { "chain": false });
        lodash.VERSION = VERSION;
        arrayEach(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function(methodName) {
          lodash[methodName].placeholder = lodash;
        });
        arrayEach(["drop", "take"], function(methodName, index) {
          LazyWrapper.prototype[methodName] = function(n) {
            n = n === undefined2 ? 1 : nativeMax(toInteger(n), 0);
            var result2 = this.__filtered__ && !index ? new LazyWrapper(this) : this.clone();
            if (result2.__filtered__) {
              result2.__takeCount__ = nativeMin(n, result2.__takeCount__);
            } else {
              result2.__views__.push({
                "size": nativeMin(n, MAX_ARRAY_LENGTH),
                "type": methodName + (result2.__dir__ < 0 ? "Right" : "")
              });
            }
            return result2;
          };
          LazyWrapper.prototype[methodName + "Right"] = function(n) {
            return this.reverse()[methodName](n).reverse();
          };
        });
        arrayEach(["filter", "map", "takeWhile"], function(methodName, index) {
          var type = index + 1, isFilter = type == LAZY_FILTER_FLAG || type == LAZY_WHILE_FLAG;
          LazyWrapper.prototype[methodName] = function(iteratee2) {
            var result2 = this.clone();
            result2.__iteratees__.push({
              "iteratee": getIteratee(iteratee2, 3),
              "type": type
            });
            result2.__filtered__ = result2.__filtered__ || isFilter;
            return result2;
          };
        });
        arrayEach(["head", "last"], function(methodName, index) {
          var takeName = "take" + (index ? "Right" : "");
          LazyWrapper.prototype[methodName] = function() {
            return this[takeName](1).value()[0];
          };
        });
        arrayEach(["initial", "tail"], function(methodName, index) {
          var dropName = "drop" + (index ? "" : "Right");
          LazyWrapper.prototype[methodName] = function() {
            return this.__filtered__ ? new LazyWrapper(this) : this[dropName](1);
          };
        });
        LazyWrapper.prototype.compact = function() {
          return this.filter(identity);
        };
        LazyWrapper.prototype.find = function(predicate) {
          return this.filter(predicate).head();
        };
        LazyWrapper.prototype.findLast = function(predicate) {
          return this.reverse().find(predicate);
        };
        LazyWrapper.prototype.invokeMap = baseRest(function(path4, args) {
          if (typeof path4 == "function") {
            return new LazyWrapper(this);
          }
          return this.map(function(value) {
            return baseInvoke(value, path4, args);
          });
        });
        LazyWrapper.prototype.reject = function(predicate) {
          return this.filter(negate(getIteratee(predicate)));
        };
        LazyWrapper.prototype.slice = function(start, end) {
          start = toInteger(start);
          var result2 = this;
          if (result2.__filtered__ && (start > 0 || end < 0)) {
            return new LazyWrapper(result2);
          }
          if (start < 0) {
            result2 = result2.takeRight(-start);
          } else if (start) {
            result2 = result2.drop(start);
          }
          if (end !== undefined2) {
            end = toInteger(end);
            result2 = end < 0 ? result2.dropRight(-end) : result2.take(end - start);
          }
          return result2;
        };
        LazyWrapper.prototype.takeRightWhile = function(predicate) {
          return this.reverse().takeWhile(predicate).reverse();
        };
        LazyWrapper.prototype.toArray = function() {
          return this.take(MAX_ARRAY_LENGTH);
        };
        baseForOwn(LazyWrapper.prototype, function(func, methodName) {
          var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(methodName), isTaker = /^(?:head|last)$/.test(methodName), lodashFunc = lodash[isTaker ? "take" + (methodName == "last" ? "Right" : "") : methodName], retUnwrapped = isTaker || /^find/.test(methodName);
          if (!lodashFunc) {
            return;
          }
          lodash.prototype[methodName] = function() {
            var value = this.__wrapped__, args = isTaker ? [1] : arguments, isLazy = value instanceof LazyWrapper, iteratee2 = args[0], useLazy = isLazy || isArray(value);
            var interceptor = function(value2) {
              var result3 = lodashFunc.apply(lodash, arrayPush([value2], args));
              return isTaker && chainAll ? result3[0] : result3;
            };
            if (useLazy && checkIteratee && typeof iteratee2 == "function" && iteratee2.length != 1) {
              isLazy = useLazy = false;
            }
            var chainAll = this.__chain__, isHybrid = !!this.__actions__.length, isUnwrapped = retUnwrapped && !chainAll, onlyLazy = isLazy && !isHybrid;
            if (!retUnwrapped && useLazy) {
              value = onlyLazy ? value : new LazyWrapper(this);
              var result2 = func.apply(value, args);
              result2.__actions__.push({ "func": thru, "args": [interceptor], "thisArg": undefined2 });
              return new LodashWrapper(result2, chainAll);
            }
            if (isUnwrapped && onlyLazy) {
              return func.apply(this, args);
            }
            result2 = this.thru(interceptor);
            return isUnwrapped ? isTaker ? result2.value()[0] : result2.value() : result2;
          };
        });
        arrayEach(["pop", "push", "shift", "sort", "splice", "unshift"], function(methodName) {
          var func = arrayProto[methodName], chainName = /^(?:push|sort|unshift)$/.test(methodName) ? "tap" : "thru", retUnwrapped = /^(?:pop|shift)$/.test(methodName);
          lodash.prototype[methodName] = function() {
            var args = arguments;
            if (retUnwrapped && !this.__chain__) {
              var value = this.value();
              return func.apply(isArray(value) ? value : [], args);
            }
            return this[chainName](function(value2) {
              return func.apply(isArray(value2) ? value2 : [], args);
            });
          };
        });
        baseForOwn(LazyWrapper.prototype, function(func, methodName) {
          var lodashFunc = lodash[methodName];
          if (lodashFunc) {
            var key = lodashFunc.name + "";
            if (!hasOwnProperty.call(realNames, key)) {
              realNames[key] = [];
            }
            realNames[key].push({ "name": methodName, "func": lodashFunc });
          }
        });
        realNames[createHybrid(undefined2, WRAP_BIND_KEY_FLAG).name] = [{
          "name": "wrapper",
          "func": undefined2
        }];
        LazyWrapper.prototype.clone = lazyClone;
        LazyWrapper.prototype.reverse = lazyReverse;
        LazyWrapper.prototype.value = lazyValue;
        lodash.prototype.at = wrapperAt;
        lodash.prototype.chain = wrapperChain;
        lodash.prototype.commit = wrapperCommit;
        lodash.prototype.next = wrapperNext;
        lodash.prototype.plant = wrapperPlant;
        lodash.prototype.reverse = wrapperReverse;
        lodash.prototype.toJSON = lodash.prototype.valueOf = lodash.prototype.value = wrapperValue;
        lodash.prototype.first = lodash.prototype.head;
        if (symIterator) {
          lodash.prototype[symIterator] = wrapperToIterator;
        }
        return lodash;
      };
      var _ = runInContext();
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        root._ = _;
        define(function() {
          return _;
        });
      } else if (freeModule) {
        (freeModule.exports = _)._ = _;
        freeExports._ = _;
      } else {
        root._ = _;
      }
    }).call(exports2);
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/objects.js
var require_objects = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/objects.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.equals = equals;
    exports2.isNumber = isNumber;
    exports2.isDefined = isDefined;
    exports2.isBoolean = isBoolean;
    exports2.isString = isString;
    exports2.isIterable = isIterable;
    exports2.convertErrorToTelemetryMsg = convertErrorToTelemetryMsg;
    var lodash_1 = require_lodash();
    function equals(one, other) {
      return (0, lodash_1.isEqual)(one, other);
    }
    function isNumber(val) {
      return typeof val === "number";
    }
    function isDefined(val) {
      return typeof val !== "undefined";
    }
    function isBoolean(val) {
      return typeof val === "boolean";
    }
    function isString(val) {
      return typeof val === "string";
    }
    function isIterable(val) {
      return Symbol.iterator in Object(val);
    }
    function convertErrorToTelemetryMsg(err) {
      if (!err)
        return "null";
      if (err instanceof Error) {
        return err.stack ?? err.toString();
      }
      if (typeof err === "object" || Array.isArray(err)) {
        return JSON.stringify(err);
      }
      if (typeof err === "function") {
        return convertErrorToTelemetryMsg(err());
      }
      return err.toString();
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/parseUtils.js
var require_parseUtils = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/parseUtils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DUPLICATE_KEY_REASON = void 0;
    exports2.DUPLICATE_KEY_REASON = "duplicate key";
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/stringifiable.js
var require_stringifiable = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/stringifiable.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/strings.js
var require_strings = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/strings.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getIndentation = getIndentation;
    exports2.convertSimple2RegExp = convertSimple2RegExp;
    exports2.convertSimple2RegExpPattern = convertSimple2RegExpPattern;
    exports2.safeCreateUnicodeRegExp = safeCreateUnicodeRegExp;
    function getIndentation(lineContent, position) {
      if (lineContent.length < position) {
        return 0;
      }
      for (let i = 0; i < position; i++) {
        const char = lineContent.charCodeAt(i);
        if (char !== 32 && char !== 9) {
          return i;
        }
      }
      return position;
    }
    function convertSimple2RegExp(pattern) {
      const match = pattern.match(new RegExp("^/(.*?)/([gimy]*)$"));
      return match ? convertRegexString2RegExp(match[1], match[2]) : convertGlobalPattern2RegExp(pattern);
    }
    function convertGlobalPattern2RegExp(pattern) {
      return new RegExp(pattern.replace(/[-\\{}+?|^$.,[\]()#\s]/g, "\\$&").replace(/[*]/g, ".*") + "$");
    }
    function convertRegexString2RegExp(pattern, flag) {
      return new RegExp(pattern, flag);
    }
    function convertSimple2RegExpPattern(pattern) {
      return pattern.replace(/[-\\{}+?|^$.,[\]()#\s]/g, "\\$&").replace(/[*]/g, ".*");
    }
    function safeCreateUnicodeRegExp(pattern) {
      try {
        return new RegExp(pattern, "u");
      } catch (ignore) {
        return new RegExp(pattern);
      }
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/textBuffer.js
var require_textBuffer = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/textBuffer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TextBuffer = void 0;
    var vscode_languageserver_types_1 = require_main();
    var TextBuffer = class {
      doc;
      constructor(doc) {
        this.doc = doc;
      }
      getLineCount() {
        return this.doc.lineCount;
      }
      getLineLength(lineNumber) {
        const lineOffsets = this.doc.getLineOffsets();
        if (lineNumber >= lineOffsets.length) {
          return this.doc.getText().length;
        } else if (lineNumber < 0) {
          return 0;
        }
        const nextLineOffset = lineNumber + 1 < lineOffsets.length ? lineOffsets[lineNumber + 1] : this.doc.getText().length;
        return nextLineOffset - lineOffsets[lineNumber];
      }
      getLineContent(lineNumber) {
        const lineOffsets = this.doc.getLineOffsets();
        if (lineNumber >= lineOffsets.length) {
          return this.doc.getText();
        } else if (lineNumber < 0) {
          return "";
        }
        const nextLineOffset = lineNumber + 1 < lineOffsets.length ? lineOffsets[lineNumber + 1] : this.doc.getText().length;
        return this.doc.getText().substring(lineOffsets[lineNumber], nextLineOffset);
      }
      getLineCharCode(lineNumber, index) {
        return this.doc.getText(vscode_languageserver_types_1.Range.create(lineNumber - 1, index, lineNumber - 1, index + 1)).charCodeAt(0);
      }
      getText(range) {
        return this.doc.getText(range);
      }
      getPosition(offest) {
        return this.doc.positionAt(offest);
      }
    };
    exports2.TextBuffer = TextBuffer;
  }
});

// ../../packages/seml-parser/out/src/languageservice/utils/index.js
var require_utils = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/utils/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar2(require_arrUtils(), exports2);
    __exportStar2(require_astUtils(), exports2);
    __exportStar2(require_charCode(), exports2);
    __exportStar2(require_objects(), exports2);
    __exportStar2(require_parseUtils(), exports2);
    __exportStar2(require_stringifiable(), exports2);
    __exportStar2(require_strings(), exports2);
    __exportStar2(require_textBuffer(), exports2);
  }
});

// ../../packages/seml-parser/out/src/languageservice/editor/yaml-editor.js
var require_yaml_editor = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/editor/yaml-editor.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.YamlEditor = void 0;
    var vscode_languageserver_types_1 = require_main();
    var range_1 = require_range();
    var utils_1 = require_utils();
    var YamlEditor = class {
      indentation;
      constructor(indentation = () => "  ") {
        this.indentation = indentation;
      }
      toTextEdit(textDocument, yamlDocument, quickfix, jsonQuery) {
        const location = yamlDocument.query(jsonQuery);
        if (!location) {
          console.error(`QuickFix path error: '${jsonQuery}' is not a valid path for ${textDocument.uri}`);
          return;
        }
        switch (quickfix.action) {
          case "addArray": {
            const text = this.formatArray(quickfix.key, quickfix.items);
            return this.toAppendTextEdit(textDocument, yamlDocument, location, text, jsonQuery);
          }
          case "addScalar":
            return this.toAppendTextEdit(textDocument, yamlDocument, location, `${quickfix["key"]}: ${quickfix.value}`, jsonQuery);
          case "changeScalar":
            return this.toReplaceTextEdit(textDocument, yamlDocument, location, quickfix.value, jsonQuery);
          case "clearArray":
            return this.toClearArrayEdit(textDocument, location, jsonQuery);
          case "delete":
            return this.toDelTextEdit(textDocument, yamlDocument, location, jsonQuery);
          case "pushArrayItems": {
            const text = this.formatArrayItems(quickfix.items);
            if (text) {
              if (quickfix.replace) {
                return this.toReplaceInArrayTextEdit(textDocument, location, text, jsonQuery);
              }
              return this.toAppendInArrayTextEdit(textDocument, location, text, jsonQuery);
            }
          }
        }
      }
      toDelTextEdit(textDocument, _yamlDocument, location, jsonQuery) {
        const isScalar = location.type === "boolean" || location.type === "number" || location.type === "string";
        const node = isScalar ? location.parent : location;
        if (node && (node.type === "property" || node.type === "array" || node.type === "object")) {
          let end;
          const startPosition = textDocument.positionAt(node.offset);
          const start = {
            line: startPosition.line,
            character: 0
          };
          const parent = node.parent;
          if (parent && parent.children) {
            const indexOfNode = parent.children.findIndex((e) => e === node);
            if (indexOfNode === -1) {
              console.debug("AST navigation error when computing del text edit (code-actions/dm.ts)");
            } else if (indexOfNode !== parent.children.length - 1) {
              const nextSiblingOffset = parent.children[indexOfNode + 1].offset;
              const nextNodeAt = textDocument.positionAt(nextSiblingOffset);
              end = {
                line: nextNodeAt.line,
                character: 0
              };
            }
          }
          if (!end) {
            const nodeEndsAt = textDocument.positionAt(node.offset + node.length);
            if (nodeEndsAt.character === 0) {
              end = nodeEndsAt;
            } else {
              end = {
                line: nodeEndsAt.line + 1,
                character: 0
              };
            }
          }
          return vscode_languageserver_types_1.TextEdit.del({
            start,
            end
          });
        }
        console.error(`Unsupported operation: delete is not allowed at path: ${jsonQuery}, type: ${location.type}`);
        return void 0;
      }
      toReplaceTextEdit(textDocument, yamlDocument, location, text, jsonQuery) {
        if (location.type === "string" || location.type === "number" || location.type === "boolean") {
          return vscode_languageserver_types_1.TextEdit.replace((0, range_1.fromPathToRange)(textDocument, yamlDocument, jsonQuery).range, `${text}`);
        }
        console.error(`Unsupported operation: replace is not allowed at path: ${jsonQuery}, type: ${location.type}`);
        return;
      }
      toAppendTextEdit(textDocument, yamlDocument, location, text, jsonQuery) {
        if (location.type === "string" || location.type === "boolean" || location.type === "number") {
          if (location.parent) {
            return this.toAppendTextEdit(textDocument, yamlDocument, location.parent, text, jsonQuery);
          }
          return;
        }
        const isUsingWindowsEol = this.isUsingWindowsEol(textDocument);
        const build2 = (indent, position) => vscode_languageserver_types_1.TextEdit.insert(position, `${this.newline(isUsingWindowsEol)}${this.indent(text, indent, isUsingWindowsEol)}`);
        if (location.type === "property") {
          const indent = textDocument.positionAt(location.offset).character;
          const position = textDocument.positionAt(location.offset + location.length);
          return build2(indent, position);
        } else if (location.type === "object") {
          const lastChild = location.children.at(-1);
          if (!lastChild) {
            console.debug(`toAppendTextEdit - appending text in empty object is not supported`);
            return;
          }
          const indent = textDocument.positionAt(lastChild.offset).character;
          const position = textDocument.positionAt(lastChild.offset + lastChild.length);
          return build2(indent, position);
        } else if (location.type === "null") {
          const indent = location.parent?.offset ? textDocument.positionAt(location.parent.offset).character + 2 : 2;
          const position = textDocument.positionAt(location.offset);
          return build2(indent, position);
        } else if (location.type === "array") {
          console.debug(`toAppendTextEdit - appending text in array is not supported, use toAppendInArrayTextEdit instead`);
          return;
        }
      }
      toAppendInArrayTextEdit(textDocument, location, text, jsonQuery) {
        const parent = location.parent;
        let arrayElement;
        if (location.type === "array") {
          arrayElement = location;
        } else if (parent?.type === "array") {
          arrayElement = parent;
        } else {
          console.debug(`toAppendInArrayTextEdit - appending outside an array is not supported, use toAppendTextEdit instead`);
          return;
        }
        const isUsingWindowsEol = this.isUsingWindowsEol(textDocument);
        const parentOfArray = arrayElement.parent;
        if (!parentOfArray || parentOfArray.type !== "property") {
          console.error(`Unsupported operation: array has no parent property at path: ${jsonQuery}${parentOfArray?.type ? `, type: ${parentOfArray.type}` : ""}`);
          return;
        }
        const singleLine = arrayElement.items.length === 0 || textDocument.positionAt(arrayElement.offset).line === textDocument.positionAt(arrayElement.offset + arrayElement.length).line;
        const indent = textDocument.positionAt(parentOfArray.offset).character;
        let position;
        if (singleLine) {
          let inserted = false;
          const items = [];
          for (const item of arrayElement.items) {
            items.push(`${this.indentation()}- ${item.value}`);
            if (item === location) {
              items.push(text);
              inserted = true;
            }
          }
          if (!inserted) {
            items.push(text);
          }
          return vscode_languageserver_types_1.TextEdit.replace({
            start: textDocument.positionAt(arrayElement.offset),
            end: textDocument.positionAt(arrayElement.offset + arrayElement.length)
          }, `${this.newline(isUsingWindowsEol)}${this.indent(`${items.join("\n")}`, indent, isUsingWindowsEol)}`);
        }
        if (location.type === "array") {
          const lastChild = arrayElement.items.at(-1);
          if (!lastChild) {
            console.debug(`toAppendInArrayTextEdit - no last child found for a multiline array`);
            return;
          }
          position = textDocument.positionAt(lastChild.offset + lastChild.length);
        } else {
          position = textDocument.positionAt(location.offset + location.length);
        }
        return vscode_languageserver_types_1.TextEdit.insert(position, `${this.indent(`${text}`, indent, isUsingWindowsEol)}${this.newline(isUsingWindowsEol)}`);
      }
      toReplaceInArrayTextEdit(textDocument, location, text, jsonQuery) {
        let arrayElement;
        if (location.type === "array") {
          arrayElement = location;
        } else {
          console.debug(`toReplaceInArrayTextEdit - replacing an array requires to target the array with the jsonQuery`);
          return;
        }
        const isUsingWindowsEol = this.isUsingWindowsEol(textDocument);
        const parentOfArray = arrayElement.parent;
        if (!parentOfArray || parentOfArray.type !== "property") {
          console.error(`Unsupported operation: array has no parent property at path: ${jsonQuery}${parentOfArray?.type ? `, type: ${parentOfArray.type}` : ""}`);
          return;
        }
        const singleLine = arrayElement.items.length === 0 || textDocument.positionAt(arrayElement.offset).line === textDocument.positionAt(arrayElement.offset + arrayElement.length).line;
        const indent = textDocument.positionAt(parentOfArray.offset).character;
        if (singleLine) {
          let inserted = false;
          const items = [];
          for (const item of arrayElement.items) {
            items.push(`${this.indentation()}- ${item.value}`);
            if (item === location) {
              items.push(text);
              inserted = true;
            }
          }
          if (!inserted) {
            items.push(text);
          }
          return vscode_languageserver_types_1.TextEdit.replace({
            start: textDocument.positionAt(arrayElement.offset),
            end: textDocument.positionAt(arrayElement.offset + arrayElement.length)
          }, `${this.newline(isUsingWindowsEol)}${this.indent(`${items.join("\n")}`, indent, isUsingWindowsEol)}`);
        }
        const start = textDocument.positionAt(arrayElement.offset);
        const end = textDocument.positionAt(arrayElement.offset + arrayElement.length);
        return vscode_languageserver_types_1.TextEdit.replace({
          start: {
            line: start.line,
            character: 0
          },
          end
        }, `${this.indent(`${text}`, indent, isUsingWindowsEol)}${this.newline(isUsingWindowsEol)}`);
      }
      formatArray(key, items) {
        const formattedItems = this.formatArrayItems(items);
        if (!formattedItems) {
          return `${key}: []`;
        }
        return `${key}:
${formattedItems}`;
      }
      formatArrayItems(items) {
        if (!Array.isArray(items)) {
          return this.formatArrayItems([items]);
        }
        if (items.length === 0) {
          return;
        }
        return items.map((e) => {
          if (this.isPrimitive(e)) {
            return `${this.indentation()}- ${e}`;
          }
          if (typeof e === "object" && !!e) {
            const accumulator = [];
            this.formatObject(e, 1, accumulator, true);
            return accumulator.join("\n");
          }
        }).join("\n");
      }
      formatObject(e, indent, accumulator, isArrayItem = false) {
        const prefix = this.indentation().repeat(indent);
        let firstLinePrefix = prefix;
        let subsequentPrefix = prefix;
        let isFirstLine = true;
        if (isArrayItem) {
          firstLinePrefix = `${prefix}- `;
          subsequentPrefix = `${prefix}${this.indentation()}`;
        }
        for (const [k, v] of Object.entries(e)) {
          const p = isFirstLine ? firstLinePrefix : subsequentPrefix;
          if (this.isPrimitive(v)) {
            accumulator.push(`${p}${k}: ${v}`);
          } else {
            accumulator.push(`${p}${k}:`);
            this.formatObject(v, indent + 1, accumulator);
          }
          isFirstLine = false;
        }
      }
      isPrimitive(e) {
        return (0, utils_1.isString)(e) || (0, utils_1.isNumber)(e) || (0, utils_1.isBoolean)(e);
      }
      toClearArrayEdit(textDocument, location, jsonQuery) {
        if (location.type !== "array") {
          console.error(`Unsupported operation: emptyArray is not allowed at path: ${jsonQuery}, type: ${location.type}`);
          return;
        }
        if (location.items.length === 0) {
          return;
        }
        const parent = location.parent;
        if (!parent || parent.type !== "property") {
          console.error(`Unsupported operation: array has no parent property at path: ${jsonQuery}${parent?.type ? `, type: ${parent.type}` : ""}`);
          return;
        }
        return vscode_languageserver_types_1.TextEdit.replace({
          start: textDocument.positionAt(parent.keyNode.offset + parent.keyNode.length),
          end: textDocument.positionAt(location.offset + location.length)
        }, `: []${this.eol(textDocument)}`);
      }
      eol(textDocument) {
        if (this.isUsingWindowsEol(textDocument)) {
          return "\r\n";
        }
        return "\n";
      }
      isUsingWindowsEol(textDocument) {
        const firstLine = textDocument.getText({
          start: { line: 0, character: 0 },
          end: { line: 1, character: 0 }
        });
        if (firstLine.length < 1) {
          return false;
        }
        return firstLine.substring(firstLine.length - 2) === "\r\n";
      }
      indent(snippet, indent, isUsingWindowsEol, skipFirstLine = false) {
        const indentStr = " ".repeat(indent);
        if (typeof snippet !== "string") {
          return `${indentStr}${snippet}`;
        }
        let result = "";
        let needIndent = !skipFirstLine;
        for (const ch of snippet) {
          if (needIndent) {
            result += indentStr;
            needIndent = false;
          }
          if (ch === "\n") {
            result += this.newline(isUsingWindowsEol);
            needIndent = true;
          } else {
            result += ch;
          }
        }
        return result;
      }
      newline(win) {
        return win ? "\r\n" : "\n";
      }
    };
    exports2.YamlEditor = YamlEditor;
  }
});

// ../../packages/seml-parser/out/src/languageservice/editor/yaml-edition-types.js
var require_yaml_edition_types = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/editor/yaml-edition-types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isArrayItems = isArrayItems;
    exports2.isScalarModification = isScalarModification;
    exports2.isDeletion = isDeletion;
    exports2.isScalarCreation = isScalarCreation;
    exports2.isArrayCreation = isArrayCreation;
    exports2.isArrayContentAddition = isArrayContentAddition;
    exports2.isArrayContentRemoval = isArrayContentRemoval;
    function isObjectWith(x, action) {
      if (typeof x !== "object" || !x) {
        return false;
      }
      if (!("action" in x) || x.action !== action) {
        return false;
      }
      return true;
    }
    function isArrayItems(x) {
      if (!Array.isArray(x)) {
        return false;
      }
      let type;
      for (const item of x) {
        if (type && typeof item !== type) {
          return false;
        }
        type = typeof item;
        if (type !== "string" && type !== "number" && type !== "boolean" && type !== "object") {
          return false;
        }
      }
      return true;
    }
    function isScalarModification(x) {
      if (!isObjectWith(x, "changeScalar")) {
        return false;
      }
      return "value" in x && (typeof x.value === "string" || typeof x.value === "number" || typeof x.value === "boolean");
    }
    function isDeletion(x) {
      return isObjectWith(x, "delete");
    }
    function isScalarCreation(x) {
      if (!isObjectWith(x, "addScalar")) {
        return false;
      }
      return "value" in x && (typeof x.value === "string" || typeof x.value === "number" || typeof x.value === "boolean");
    }
    function isArrayCreation(x) {
      if (!isObjectWith(x, "addArray")) {
        return false;
      }
      if (!("key" in x) || typeof x.key !== "string") {
        return false;
      }
      if (!("items" in x) || !isArrayItems(x.items)) {
        return false;
      }
      return true;
    }
    function isArrayContentAddition(x) {
      if (!isObjectWith(x, "pushArrayItems")) {
        return false;
      }
      if (!("items" in x) || !isArrayItems(x.items)) {
        return false;
      }
      return "replace" in x && typeof x.replace === "boolean";
    }
    function isArrayContentRemoval(x) {
      return isObjectWith(x, "clearArray");
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/editor/index.js
var require_editor = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/editor/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar2(require_yaml_editor(), exports2);
    __exportStar2(require_yaml_edition_types(), exports2);
  }
});

// ../../packages/seml-parser/out/src/languageservice/ast-impl.js
var require_ast_impl = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/ast-impl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ObjectAstNodeImpl = exports2.PropertyAstNodeImpl = exports2.StringAstNodeImpl = exports2.NumberAstNodeImpl = exports2.ArrayAstNodeImpl = exports2.BooleanAstNodeImpl = exports2.NullAstNodeImpl = exports2.BaseAstNodeImpl = void 0;
    function doGetNodeFromOffsetEndInclusive(startingFrom, offset) {
      const collector = [];
      const findNode = (node) => {
        if (offset >= node.offset && offset <= node.offset + node.length) {
          const children = node.children;
          if (children) {
            for (let i = 0; i < children.length && children[i].offset <= offset; i++) {
              const item = findNode(children[i]);
              if (item) {
                collector.push(item);
              }
            }
          }
          return node;
        }
        return void 0;
      };
      const foundNode = findNode(startingFrom);
      let currMinDist = Number.MAX_VALUE;
      let currMinNode;
      for (const currNode of collector) {
        const minDist = currNode.length + currNode.offset - offset + (offset - currNode.offset);
        if (minDist < currMinDist) {
          currMinNode = currNode;
          currMinDist = minDist;
        }
      }
      return currMinNode || foundNode;
    }
    var BaseAstNodeImpl = class {
      internalNode;
      offset;
      length;
      parent;
      constructor(internalNode, offset, length, parent) {
        this.internalNode = internalNode;
        this.offset = offset;
        this.length = length;
        this.parent = parent;
      }
      get children() {
        return [];
      }
      toString() {
        return "type: " + this.type + " (" + this.offset + "/" + this.length + ")" + (this.parent ? " parent: {" + this.parent.toString() + "}" : "");
      }
    };
    exports2.BaseAstNodeImpl = BaseAstNodeImpl;
    var NullAstNodeImpl = class extends BaseAstNodeImpl {
      type = "null";
      value = null;
      constructor(internalNode, offset, length, parent) {
        super(internalNode, offset, length, parent);
      }
      getNodeFromOffsetEndInclusive(offset) {
        return doGetNodeFromOffsetEndInclusive(this, offset);
      }
    };
    exports2.NullAstNodeImpl = NullAstNodeImpl;
    var BooleanAstNodeImpl = class extends BaseAstNodeImpl {
      type = "boolean";
      value;
      constructor(internalNode, boolValue, offset, length, parent) {
        super(internalNode, offset, length, parent);
        this.value = boolValue;
      }
      getNodeFromOffsetEndInclusive(offset) {
        return doGetNodeFromOffsetEndInclusive(this, offset);
      }
    };
    exports2.BooleanAstNodeImpl = BooleanAstNodeImpl;
    var ArrayAstNodeImpl = class extends BaseAstNodeImpl {
      type = "array";
      items;
      constructor(internalNode, offset, length, parent) {
        super(internalNode, offset, length, parent);
        this.items = [];
      }
      get children() {
        return this.items;
      }
      getNodeFromOffsetEndInclusive(offset) {
        return doGetNodeFromOffsetEndInclusive(this, offset);
      }
    };
    exports2.ArrayAstNodeImpl = ArrayAstNodeImpl;
    var NumberAstNodeImpl = class extends BaseAstNodeImpl {
      type = "number";
      isInteger;
      value;
      constructor(internalNode, offset, length, parent) {
        super(internalNode, offset, length, parent);
        this.isInteger = true;
        this.value = Number.NaN;
      }
      getNodeFromOffsetEndInclusive(offset) {
        return doGetNodeFromOffsetEndInclusive(this, offset);
      }
    };
    exports2.NumberAstNodeImpl = NumberAstNodeImpl;
    var StringAstNodeImpl = class extends BaseAstNodeImpl {
      type = "string";
      value;
      constructor(internalNode, offset, length, parent) {
        super(internalNode, offset, length, parent);
        this.value = "";
      }
      getNodeFromOffsetEndInclusive(offset) {
        return doGetNodeFromOffsetEndInclusive(this, offset);
      }
    };
    exports2.StringAstNodeImpl = StringAstNodeImpl;
    var PropertyAstNodeImpl = class extends BaseAstNodeImpl {
      type = "property";
      futureKeyNode;
      futureValueNode;
      constructor(internalNode, offset, length, parent) {
        super(internalNode, offset, length, parent);
      }
      get children() {
        return [this.keyNode, this.valueNode];
      }
      getNodeFromOffsetEndInclusive(offset) {
        return doGetNodeFromOffsetEndInclusive(this, offset);
      }
      get keyNode() {
        if (!this.futureKeyNode) {
          throw new Error(`Access to keyNode of unitialized PropertyAstNodeImpl is not allowed`);
        }
        return this.futureKeyNode;
      }
      get valueNode() {
        if (!this.futureValueNode) {
          throw new Error(`Access to valueNode of unitialized PropertyAstNodeImpl is not allowed`);
        }
        return this.futureValueNode;
      }
    };
    exports2.PropertyAstNodeImpl = PropertyAstNodeImpl;
    var ObjectAstNodeImpl = class extends BaseAstNodeImpl {
      type = "object";
      properties;
      constructor(internalNode, offset, length, parent) {
        super(internalNode, offset, length, parent);
        this.properties = [];
      }
      get children() {
        return this.properties;
      }
      getNodeFromOffsetEndInclusive(offset) {
        return doGetNodeFromOffsetEndInclusive(this, offset);
      }
    };
    exports2.ObjectAstNodeImpl = ObjectAstNodeImpl;
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/ast-converter.js
var require_ast_converter = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/ast-converter.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildAst = buildAst;
    exports2.toOffsetLength = toOffsetLength;
    var yaml_1 = require("yaml");
    var ast_impl_1 = require_ast_impl();
    var maxRefCount = 1e3;
    var refDepth = 0;
    var seenAlias = /* @__PURE__ */ new Set();
    function buildAst(doc, lineCounter) {
      refDepth = 0;
      return convertAst(doc.contents, doc, lineCounter);
    }
    function convertAst(node, doc, lineCounter, parent) {
      if (!parent) {
        refDepth = 0;
      }
      if ((0, yaml_1.isMap)(node)) {
        return convertMap(node, doc, lineCounter, parent);
      }
      if ((0, yaml_1.isPair)(node)) {
        return convertPair(node, doc, lineCounter, parent);
      }
      if ((0, yaml_1.isSeq)(node)) {
        return convertSeq(node, doc, lineCounter, parent);
      }
      if ((0, yaml_1.isScalar)(node)) {
        return convertScalar(node, parent);
      }
      if ((0, yaml_1.isAlias)(node) && !seenAlias.has(node) && refDepth < maxRefCount) {
        seenAlias.add(node);
        const converted = convertAlias(node, doc, lineCounter, parent);
        seenAlias.delete(node);
        return converted;
      }
      return;
    }
    function convertMap(node, doc, lineCounter, parent) {
      let range;
      if (node.flow && !node.range) {
        range = collectFlowMapRange(node);
      } else {
        range = getRange(node);
      }
      const result = new ast_impl_1.ObjectAstNodeImpl(node, ...toFixedOffsetLength(range, lineCounter), parent);
      for (const it of node.items) {
        if ((0, yaml_1.isPair)(it)) {
          result.properties.push(convertPair(it, doc, lineCounter, result));
        }
      }
      return result;
    }
    function convertPair(node, doc, lineCounter, parent) {
      const keyNode = node.key;
      const valueNode = node.value;
      const keyRange = getRange(keyNode);
      const rangeStart = keyRange[0];
      let rangeEnd = keyRange[1];
      let nodeEnd = keyRange[2];
      if (valueNode) {
        const valueRange = getRange(valueNode);
        rangeEnd = valueRange[1];
        nodeEnd = valueRange[2];
      }
      const result = new ast_impl_1.PropertyAstNodeImpl(node, ...toFixedOffsetLength([rangeStart, rangeEnd, nodeEnd], lineCounter), parent);
      if ((0, yaml_1.isAlias)(keyNode)) {
        const keyAlias = new ast_impl_1.StringAstNodeImpl(keyNode, ...toOffsetLength(keyRange), parent);
        keyAlias.value = keyNode.source;
        result.futureKeyNode = keyAlias;
      } else {
        result.futureKeyNode = convertAst(keyNode, doc, lineCounter, result);
      }
      result.futureValueNode = convertAst(valueNode, doc, lineCounter, result) ?? new ast_impl_1.NullAstNodeImpl(keyNode, ...toOffsetLength(keyRange), result);
      return result;
    }
    function convertSeq(node, doc, lineCounter, parent) {
      const range = getRange(node);
      const result = new ast_impl_1.ArrayAstNodeImpl(node, ...toOffsetLength(range), parent);
      for (const it of node.items) {
        if ((0, yaml_1.isNode)(it)) {
          const convertedNode = convertAst(it, doc, lineCounter, result);
          if (convertedNode) {
            result.children.push(convertedNode);
          }
        }
      }
      return result;
    }
    function convertScalar(node, parent) {
      const range = getRange(node);
      if (node.value === null) {
        return new ast_impl_1.NullAstNodeImpl(node, ...toOffsetLength(range), parent);
      }
      switch (typeof node.value) {
        case "string": {
          const result = new ast_impl_1.StringAstNodeImpl(node, ...toOffsetLength(range), parent);
          result.value = node.value;
          return result;
        }
        case "boolean":
          return new ast_impl_1.BooleanAstNodeImpl(node, node.value, ...toOffsetLength(range), parent);
        case "number": {
          const result = new ast_impl_1.NumberAstNodeImpl(node, ...toOffsetLength(range), parent);
          result.value = node.value;
          result.isInteger = Number.isInteger(result.value);
          return result;
        }
        default: {
          const range2 = getRange(node);
          const result = new ast_impl_1.StringAstNodeImpl(node, ...toOffsetLength(range2), parent);
          result.value = node.source ?? "";
          return result;
        }
      }
    }
    function convertAlias(node, doc, lineCounter, parent) {
      refDepth++;
      const resolvedNode = node.resolve(doc);
      if (resolvedNode) {
        return convertAst(resolvedNode, doc, lineCounter, parent);
      }
      const range = getRange(node);
      const resultNode = new ast_impl_1.StringAstNodeImpl(node, ...toOffsetLength(range), parent);
      resultNode.value = node.source;
      return resultNode;
    }
    function toOffsetLength(range) {
      return [range[0], range[1] - range[0]];
    }
    function toFixedOffsetLength(range, lineCounter) {
      const start = lineCounter.linePos(range[0]);
      const end = lineCounter.linePos(range[1]);
      const result = [range[0], range[1] - range[0]];
      if (start.line !== end.line && (lineCounter.lineStarts.length !== end.line || end.col === 1)) {
        result[1]--;
      }
      return result;
    }
    function collectFlowMapRange(node) {
      let start = Number.MAX_SAFE_INTEGER;
      let end = 0;
      for (const it of node.items) {
        if ((0, yaml_1.isPair)(it)) {
          if ((0, yaml_1.isNode)(it.key)) {
            if (it.key.range && it.key.range[0] <= start) {
              start = it.key.range[0];
            }
          }
          if ((0, yaml_1.isNode)(it.value)) {
            if (it.value.range && it.value.range[2] >= end) {
              end = it.value.range[2];
            }
          }
        }
      }
      return [start, end, end];
    }
    function getRange(node) {
      if (!node.range) {
        throw new Error(`node with no range: ${node.toJSON()}`);
      }
      return node.range;
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/cloneable.js
var require_cloneable = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/cloneable.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/custom-tag-provider.js
var require_custom_tag_provider = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/custom-tag-provider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getCustomTags = getCustomTags;
    var yaml_1 = require("yaml");
    var arrUtils_1 = require_arrUtils();
    var CommonTagImpl = class {
      tag;
      type;
      constructor(tag, type) {
        this.tag = tag;
        this.type = type;
      }
      get collection() {
        if (this.type === "mapping") {
          return "map";
        }
        if (this.type === "sequence") {
          return "seq";
        }
        return void 0;
      }
      identify;
      resolve(value) {
        if ((0, yaml_1.isMap)(value) && this.type === "mapping") {
          return value;
        }
        if ((0, yaml_1.isSeq)(value) && this.type === "sequence") {
          return value;
        }
        if (typeof value === "string" && this.type === "scalar") {
          return value;
        }
        return;
      }
    };
    var IncludeTag = class {
      tag = "!include";
      type = "scalar";
      identify;
      resolve(value, onError) {
        if (value && value.length > 0 && value.trim()) {
          return value;
        }
        onError("!include without value");
        return;
      }
    };
    function getCustomTags(customTags) {
      const tags = [];
      const filteredTags = (0, arrUtils_1.filterInvalidCustomTags)(customTags);
      for (const tag of filteredTags) {
        const typeInfo = tag.split(" ");
        const tagName = typeInfo[0];
        const tagType = typeInfo[1] && typeInfo[1].toLowerCase() || "scalar";
        tags.push(new CommonTagImpl(tagName, tagType));
      }
      tags.push(new IncludeTag());
      return tags;
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/json-ast-representation.js
var require_json_ast_representation = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/json-ast-representation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FullJsonAstViewImpl = exports2.EnumMatch = exports2.YAML_SOURCE = void 0;
    exports2.newJsonAstView = newJsonAstView;
    exports2.getNodeValue = getNodeValue;
    exports2.contains = contains;
    exports2.findNodeAtOffset = findNodeAtOffset;
    exports2.YAML_SOURCE = "YAML";
    var EnumMatch;
    (function(EnumMatch2) {
      EnumMatch2[EnumMatch2["Key"] = 0] = "Key";
      EnumMatch2[EnumMatch2["Enum"] = 1] = "Enum";
    })(EnumMatch || (exports2.EnumMatch = EnumMatch = {}));
    function newJsonAstView(root, diagnostics = []) {
      return new FullJsonAstViewImpl(root, diagnostics, []);
    }
    function getNodeValue(node) {
      switch (node.type) {
        case "array":
          return node.children.map(getNodeValue);
        case "object": {
          const obj = /* @__PURE__ */ Object.create(null);
          for (let _i = 0, _a = node.children; _i < _a.length; _i++) {
            const prop = _a[_i];
            if (prop.children) {
              const valueNode = prop.children[1];
              if (valueNode) {
                obj[prop.children[0].value] = getNodeValue(valueNode);
              }
            }
          }
          return obj;
        }
        case "null":
        case "string":
        case "number":
        case "boolean":
          return node.value;
        default:
          return void 0;
      }
    }
    function contains(node, offset, includeRightBound = false) {
      return offset >= node.offset && offset <= node.offset + node.length || includeRightBound && offset === node.offset + node.length;
    }
    function findNodeAtOffset(node, offset, includeRightBound) {
      if (includeRightBound === void 0) {
        includeRightBound = false;
      }
      if (contains(node, offset, includeRightBound)) {
        const children = node.children;
        if (Array.isArray(children)) {
          for (let i = 0; i < children.length && children[i].offset <= offset; i++) {
            const item = findNodeAtOffset(children[i], offset, includeRightBound);
            if (item) {
              return item;
            }
          }
        }
        return node;
      }
      return void 0;
    }
    var FullJsonAstViewImpl = class _FullJsonAstViewImpl {
      root;
      syntaxErrors;
      comments;
      constructor(root, syntaxErrors = [], comments = []) {
        this.root = root;
        this.syntaxErrors = syntaxErrors;
        this.comments = comments;
      }
      clone() {
        return new _FullJsonAstViewImpl(this.root, this.syntaxErrors, this.comments);
      }
      getNodeFromOffset(offset, includeRightBound = false) {
        if (this.root) {
          return findNodeAtOffset(this.root, offset, includeRightBound);
        }
        return void 0;
      }
      getNodeFromOffsetEndInclusive(offset) {
        return this.root && this.root.getNodeFromOffsetEndInclusive(offset);
      }
      visit(visitor) {
        if (this.root) {
          const doVisit = (node) => {
            let ctn = visitor(node);
            const children = node.children;
            if (Array.isArray(children)) {
              for (let i = 0; i < children.length && ctn; i++) {
                ctn = doVisit(children[i]);
              }
            }
            return ctn;
          };
          doVisit(this.root);
        }
      }
      /**
       * Query a child node through a json path like.
       *
       * Only a subset of json path features are supported.
       * <ul>
       *   <li>the dot notation to access a child by its key name;
       *   <li>the brackets notation to access a child by its position in an array.
       * </ul>
       * @param query the json path like query to follow
       * @returns an AstNode or undefined if the path leads to nowhere.
       */
      query(query, startingNode) {
        const from = startingNode ?? this.root;
        if (!from) {
          return;
        }
        return this.queryFrom(query.trim(), from);
      }
      queryFrom(query, currentNode) {
        const subQuery = query.charAt(0) === "." ? query.substring(1) : query;
        const resumeSearch = (selectedNode, nextSegmentBeginAt) => {
          if (selectedNode === void 0) {
            return selectedNode;
          }
          return this.queryFrom(subQuery.substring(nextSegmentBeginAt), selectedNode);
        };
        const findPropertyNode = (owner, keyValue) => owner.children?.find((n) => n.type === "property" && n.keyNode.value === keyValue);
        const findNextNodeInProperties = (indexOfDot2) => {
          const nodeName = subQuery.substring(0, indexOfDot2);
          const nextNode = findPropertyNode(currentNode, nodeName);
          return resumeSearch(nextNode?.valueNode, indexOfDot2 + 1);
        };
        const findNextNodeInArray = (indexOfOpeningBracket2) => {
          const indexOfClosingBracket = subQuery.indexOf("]");
          if (indexOfClosingBracket !== subQuery.length - 1 && subQuery.charAt(indexOfClosingBracket + 1) !== ".") {
            return void 0;
          }
          const nodeIndex = +subQuery.substring(indexOfOpeningBracket2 + 1, indexOfClosingBracket);
          if (isNaN(nodeIndex) || nodeIndex < 0) {
            return void 0;
          }
          const nodeName = subQuery.substring(0, indexOfOpeningBracket2);
          const arrayNode = findPropertyNode(currentNode, nodeName)?.valueNode;
          if (arrayNode?.type !== "array" || nodeIndex >= arrayNode.items.length) {
            return void 0;
          }
          const nextNode = arrayNode.items[nodeIndex];
          return resumeSearch(nextNode, indexOfClosingBracket + 1);
        };
        if (subQuery.length === 0) {
          if (currentNode.type === "property") {
            return currentNode.valueNode;
          }
          return currentNode;
        }
        const indexOfDot = subQuery.indexOf(".");
        if (indexOfDot === 0) {
          return this.queryFrom(subQuery.substring(1), currentNode);
        }
        const indexOfOpeningBracket = subQuery.indexOf("[");
        if (indexOfOpeningBracket === -1 && indexOfDot === -1) {
          return findPropertyNode(currentNode, subQuery)?.valueNode;
        }
        if (indexOfOpeningBracket === -1) {
          return findNextNodeInProperties(indexOfDot);
        }
        if (indexOfDot === -1) {
          return findNextNodeInArray(indexOfOpeningBracket);
        }
        if (indexOfDot < indexOfOpeningBracket) {
          return findNextNodeInProperties(indexOfDot);
        }
        return findNextNodeInArray(indexOfOpeningBracket);
      }
    };
    exports2.FullJsonAstViewImpl = FullJsonAstViewImpl;
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/scalar-type.js
var require_scalar_type = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/scalar-type.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseYamlBoolean = parseYamlBoolean;
    function parseYamlBoolean(input) {
      if ([
        "true",
        "True",
        "TRUE",
        "y",
        "Y",
        "yes",
        "Yes",
        "YES",
        "on",
        "On",
        "ON"
      ].lastIndexOf(input) >= 0) {
        return true;
      } else if ([
        "false",
        "False",
        "FALSE",
        "n",
        "N",
        "no",
        "No",
        "NO",
        "off",
        "Off",
        "OFF"
      ].lastIndexOf(input) >= 0) {
        return false;
      }
      throw `Invalid boolean "${input}"`;
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/yaml-ast-representation.js
var require_yaml_ast_representation = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/yaml-ast-representation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/yamlParser07.js
var require_yamlParser07 = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/yamlParser07.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultOptions = void 0;
    exports2.parse = parse2;
    var yaml_1 = require("yaml");
    var textBuffer_1 = require_textBuffer();
    var custom_tag_provider_1 = require_custom_tag_provider();
    var yaml_ast_representation_impl_1 = require_yaml_ast_representation_impl();
    exports2.defaultOptions = {
      customTags: [],
      yamlVersion: "1.2"
    };
    function parse2(text, parserOptions = exports2.defaultOptions, document2) {
      const options = {
        strict: false,
        customTags: (0, custom_tag_provider_1.getCustomTags)(parserOptions.customTags),
        version: parserOptions.yamlVersion ?? exports2.defaultOptions.yamlVersion,
        keepSourceTokens: true
      };
      const composer = new yaml_1.Composer(options);
      const lineCounter = new yaml_1.LineCounter();
      let isLastLineEmpty = false;
      if (document2) {
        const textBuffer = new textBuffer_1.TextBuffer(document2);
        const position = textBuffer.getPosition(text.length);
        const lineContent = textBuffer.getLineContent(position.line);
        isLastLineEmpty = lineContent.trim().length === 0;
      }
      const parser = isLastLineEmpty ? new yaml_1.Parser() : new yaml_1.Parser(lineCounter.addNewLine);
      const tokens = parser.parse(text);
      const tokensArr = Array.from(tokens);
      const docs = composer.compose(tokensArr, true, text.length);
      const yamlDocs = Array.from(docs, (doc) => parsedDocToSingleYAMLDocument(doc, lineCounter));
      if (yamlDocs.length > 1) {
        throw new Error("Multiple documents are not supported");
      }
      if (yamlDocs.length === 0) {
        return new yaml_ast_representation_impl_1.YamlDocumentImpl((0, yaml_ast_representation_impl_1.newYamlAstView)(), tokensArr);
      }
      return new yaml_ast_representation_impl_1.YamlDocumentImpl(yamlDocs[0], tokensArr);
    }
    function parsedDocToSingleYAMLDocument(parsedDoc, lineCounter) {
      const syd = (0, yaml_ast_representation_impl_1.newYamlAstView)(lineCounter);
      syd.internalDocument = parsedDoc;
      return syd;
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/yaml-ast-representation-impl.js
var require_yaml_ast_representation_impl = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/yaml-ast-representation-impl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.YamlDocumentImpl = exports2.yamlDocumentsCache = void 0;
    exports2.createCacheForTests = createCacheForTests;
    exports2.newYamlAstView = newYamlAstView;
    var vscode_json_languageservice_1 = require("vscode-json-languageservice");
    var yaml_1 = require("yaml");
    var arrUtils_1 = require_arrUtils();
    var astUtils_1 = require_astUtils();
    var strings_1 = require_strings();
    var ast_converter_1 = require_ast_converter();
    var json_ast_representation_1 = require_json_ast_representation();
    var yamlParser07_1 = require_yamlParser07();
    var FullYamlAstViewImpl = class _FullYamlAstViewImpl extends json_ast_representation_1.FullJsonAstViewImpl {
      lineCounter;
      _internalDocument;
      currentDocIndex = 0;
      _lineComments;
      constructor(lineCounter) {
        super(void 0, []);
        this.lineCounter = lineCounter;
        this._internalDocument = new yaml_1.Document();
      }
      /**
       * Create a deep copy of this document if there is an internal document bound to it, self otherwise
       */
      clone() {
        const copy = new _FullYamlAstViewImpl(this.lineCounter);
        copy.currentDocIndex = this.currentDocIndex;
        copy._lineComments = this.lineComments.slice();
        copy.internalDocument = this._internalDocument.clone();
        return copy;
      }
      collectLineComments() {
        const lineComments = [];
        if (this._internalDocument?.commentBefore) {
          const comments = this._internalDocument.commentBefore.split("\n");
          comments.forEach((comment) => lineComments.push(`#${comment}`));
        }
        (0, yaml_1.visit)(this._internalDocument, (_key, node) => {
          if (node?.commentBefore) {
            const comments = node?.commentBefore.split("\n");
            comments.forEach((comment) => lineComments.push(`#${comment}`));
          }
          if (node?.comment) {
            lineComments.push(`#${node.comment}`);
          }
        });
        if (this._internalDocument?.comment) {
          lineComments.push(`#${this._internalDocument.comment}`);
        }
        return lineComments;
      }
      /**
       * Updates the internal AST tree of the object
       * from the internal node. This is call whenever the
       * internalDocument is set but also can be called to
       * reflect any changes on the underlying document
       * without setting the internalDocument explicitly.
       */
      updateFromInternalDocument() {
        if (this._internalDocument) {
          this.root = (0, ast_converter_1.buildAst)(this._internalDocument, this.lineCounter);
        }
      }
      set internalDocument(document2) {
        this._internalDocument = document2;
        this.updateFromInternalDocument();
      }
      get internalDocument() {
        return this._internalDocument;
      }
      get lineComments() {
        if (!this._lineComments) {
          const lineComments = this.collectLineComments();
          this._lineComments = lineComments;
          return lineComments;
        }
        return this._lineComments;
      }
      set lineComments(val) {
        this._lineComments = val;
      }
      get errors() {
        return this._internalDocument?.errors.map(yamlErrorToYamlDocDiagnostics) ?? [];
      }
      get warnings() {
        return this._internalDocument?.warnings.map(yamlErrorToYamlDocDiagnostics) ?? [];
      }
      getNodeFromPosition(positionOffset, textBuffer, configuredIndentation) {
        const position = textBuffer.getPosition(positionOffset);
        const lineContent = textBuffer.getLineContent(position.line);
        if (lineContent.trim().length === 0) {
          return [
            this.findClosestNode(positionOffset, textBuffer, configuredIndentation),
            true
          ];
        }
        const textAfterPosition = lineContent.substring(position.character);
        const spacesAfterPositionMatch = textAfterPosition.match(/^([ ]+)\n?$/);
        const areOnlySpacesAfterPosition = !!spacesAfterPositionMatch;
        const countOfSpacesAfterPosition = spacesAfterPositionMatch?.[1].length ?? 0;
        let closestNode;
        (0, yaml_1.visit)(this.internalDocument, (_key, node) => {
          if (!node) {
            return;
          }
          const range = node.range;
          if (!range) {
            return;
          }
          const isNullNodeOnTheLine = () => areOnlySpacesAfterPosition && positionOffset + countOfSpacesAfterPosition === range[2] && (0, yaml_1.isScalar)(node) && node.value === null;
          if (range[0] <= positionOffset && range[1] >= positionOffset || isNullNodeOnTheLine()) {
            closestNode = node;
          } else {
            return yaml_1.visit.SKIP;
          }
        });
        return [closestNode, false];
      }
      findClosestNode(offset, textBuffer, configuredIndentation) {
        if (!this.internalDocument.range) {
          throw new Error(`findClosestNode cannot access internal document range`);
        }
        let offsetDiff = this.internalDocument.range[2];
        let maxOffset = this.internalDocument.range[0];
        let closestNode;
        (0, yaml_1.visit)(this.internalDocument, (_key, node) => {
          if (!node) {
            return;
          }
          const range = node.range;
          if (!range) {
            return;
          }
          const diff = range[1] - offset;
          if (maxOffset <= range[0] && diff <= 0 && Math.abs(diff) <= offsetDiff) {
            offsetDiff = Math.abs(diff);
            maxOffset = range[0];
            closestNode = node;
          }
        });
        const position = textBuffer.getPosition(offset);
        const lineContent = textBuffer.getLineContent(position.line);
        const indentation = (0, strings_1.getIndentation)(lineContent, position.character);
        if ((0, yaml_1.isScalar)(closestNode) && closestNode.value === null) {
          return closestNode;
        }
        if (indentation === position.character) {
          closestNode = this.getProperParentByIndentation(indentation, closestNode, textBuffer, "", configuredIndentation);
        }
        return closestNode;
      }
      getProperParentByIndentation(indentation, node, textBuffer, currentLine, configuredIndentation, rootParent) {
        if (!node) {
          return this.internalDocument.contents;
        }
        configuredIndentation = !configuredIndentation ? 2 : configuredIndentation;
        if ((0, yaml_1.isNode)(node) && node.range) {
          const position = textBuffer.getPosition(node.range[0]);
          const lineContent = textBuffer.getLineContent(position.line);
          currentLine = currentLine === "" ? lineContent.trim() : currentLine;
          if (currentLine.startsWith("-") && indentation === configuredIndentation && currentLine === lineContent.trim()) {
            position.character += indentation;
          }
          if (position.character > indentation && position.character > 0) {
            const parent = this.getParent(node);
            if (parent) {
              return this.getProperParentByIndentation(indentation, parent, textBuffer, currentLine, configuredIndentation, rootParent);
            }
          } else if (position.character < indentation) {
            const parent = this.getParent(node);
            if ((0, yaml_1.isPair)(parent) && (0, yaml_1.isNode)(parent.value)) {
              return parent.value;
            } else if ((0, yaml_1.isPair)(rootParent) && (0, yaml_1.isNode)(rootParent.value)) {
              return rootParent.value;
            }
          } else {
            return node;
          }
        } else if ((0, yaml_1.isPair)(node)) {
          rootParent = node;
          const parent = this.getParent(node);
          if (!parent) {
            throw new Error(`getProperParentByIndentation - pair has no parent: ${node.toJSON()}`);
          }
          return this.getProperParentByIndentation(indentation, parent, textBuffer, currentLine, configuredIndentation, rootParent);
        }
        return node;
      }
      getParent(node) {
        return (0, astUtils_1.getParent)(this.internalDocument, node);
      }
      /**
       * Computes the path from the root to the current node in a json path like.
       *
       * Only a subset of json path features are supported.
       * <ul>
       *   <li>the dot notation to access a child by its key name;
       *   <li>the brackets notation to access a child by its position in an array.
       * </ul>
       * @param node the AstNode to reach from the root.
       * @returns a json path like value.
       * @throws an Error in case the computation fails.
       */
      toQuery(node) {
        const root = this._internalDocument.contents;
        const segments = [];
        const initialKey = this.getKeyValue(node);
        if (initialKey) {
          segments.push(initialKey);
        }
        let previousNode = node;
        let currentNode = this.getParent(node);
        while (currentNode && currentNode !== root) {
          if ((0, yaml_1.isSeq)(currentNode)) {
            const idx = currentNode.items.indexOf(previousNode);
            if (idx === -1) {
              const itemsStr = currentNode.items.map((n) => JSON.stringify(n.toJSON()));
              const nodeStr = JSON.stringify(previousNode.toJSON());
              throw new Error(`Unable to find node ${nodeStr} in array ${itemsStr}`);
            }
            const parentOfArray = this.getParent(currentNode);
            if (!parentOfArray) {
              throw new Error(`Unsupported case: array must have a parent`);
            }
            const keyOfParent = this.getKeyValueOrFail(parentOfArray, `Unsupported case: array must be an pair value`);
            segments.push(`${keyOfParent}[${idx}]`);
            previousNode = parentOfArray;
            currentNode = this.getParent(parentOfArray);
            continue;
          }
          if ((0, yaml_1.isMap)(currentNode)) {
            previousNode = currentNode;
            currentNode = this.getParent(currentNode);
            continue;
          }
          const propertyKey = this.getKeyValue(currentNode);
          if (propertyKey) {
            segments.push(propertyKey);
            previousNode = currentNode;
            currentNode = this.getParent(currentNode);
            continue;
          }
          throw new Error(`Illegal node type: ${JSON.stringify(currentNode.toJSON())}`);
        }
        return segments.reverse().join(".");
      }
      getKeyValue(node) {
        if ((0, yaml_1.isPair)(node)) {
          if ((0, yaml_1.isScalar)(node.key) && !!node.key.value) {
            return node.key.value.toString();
          } else {
            throw new Error(`Unsupported key value for property ${JSON.stringify(node.toJSON())}`);
          }
        }
      }
      getKeyValueOrFail(node, error) {
        const key = this.getKeyValue(node);
        if (!key) {
          throw new Error(error);
        }
        return key;
      }
    };
    var YamlDocumentsCacheImpl = class {
      // a mapping of URIs to cached documents
      cache = /* @__PURE__ */ new Map();
      /**
       * Get cached YAMLDocument
       * @param document TextDocument to parse
       * @param parserOptions YAML parserOptions
       * @param addRootObject if true and document is empty add empty object {} to force schema usage
       * @returns the YAMLDocument
       */
      getYamlDocument(document2, parserOptions, addRootObject = false) {
        const cached = this.ensureCache(document2, parserOptions ?? yamlParser07_1.defaultOptions, addRootObject);
        return cached.document;
      }
      /**
       * For test purpose only!
       */
      clear() {
        this.cache.clear();
      }
      ensureCache(document2, parserOptions, addRootObject) {
        const key = document2.uri;
        if (!this.cache.has(key)) {
          this.cache.set(key, {
            version: Number.MIN_SAFE_INTEGER,
            document: new YamlDocumentImpl(newYamlAstView(), []),
            parserOptions: yamlParser07_1.defaultOptions
          });
        }
        const cacheEntry = this.cache.get(key);
        if (cacheEntry.version !== document2.version || parserOptions.customTags && !(0, arrUtils_1.isArrayEqual)(cacheEntry.parserOptions.customTags, parserOptions.customTags)) {
          let text = document2.getText();
          if (addRootObject && !/\S/.test(text)) {
            text = `{${text}}`;
          }
          const doc = (0, yamlParser07_1.parse)(text, parserOptions, document2);
          cacheEntry.document = doc;
          cacheEntry.version = document2.version;
          cacheEntry.parserOptions = parserOptions;
        }
        return cacheEntry;
      }
    };
    function yamlErrorToYamlDocDiagnostics(error) {
      return {
        message: error.message,
        location: {
          start: error.pos[0],
          end: error.pos[1],
          toLineEnd: true
        },
        severity: 1,
        code: vscode_json_languageservice_1.ErrorCode.Undefined
      };
    }
    exports2.yamlDocumentsCache = new YamlDocumentsCacheImpl();
    function createCacheForTests() {
      return new YamlDocumentsCacheImpl();
    }
    function newYamlAstView(lineCounter = new yaml_1.LineCounter()) {
      return new FullYamlAstViewImpl(lineCounter);
    }
    var YamlDocumentImpl = class {
      document;
      tokens;
      constructor(document2, tokens = []) {
        this.document = document2;
        this.tokens = tokens;
      }
    };
    exports2.YamlDocumentImpl = YamlDocumentImpl;
  }
});

// ../../packages/seml-parser/out/src/languageservice/parser/index.js
var require_parser = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/parser/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.yamlDocumentsCache = exports2.newYamlAstView = void 0;
    __exportStar2(require_ast_converter(), exports2);
    __exportStar2(require_cloneable(), exports2);
    __exportStar2(require_custom_tag_provider(), exports2);
    __exportStar2(require_json_ast_representation(), exports2);
    __exportStar2(require_range(), exports2);
    __exportStar2(require_scalar_type(), exports2);
    __exportStar2(require_yaml_ast_representation(), exports2);
    var yaml_ast_representation_impl_1 = require_yaml_ast_representation_impl();
    Object.defineProperty(exports2, "newYamlAstView", { enumerable: true, get: function() {
      return yaml_ast_representation_impl_1.newYamlAstView;
    } });
    Object.defineProperty(exports2, "yamlDocumentsCache", { enumerable: true, get: function() {
      return yaml_ast_representation_impl_1.yamlDocumentsCache;
    } });
    __exportStar2(require_yamlParser07(), exports2);
  }
});

// ../../packages/seml-parser/out/src/languageservice/ast.js
var require_ast = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/ast.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/json-schema.js
var require_json_schema = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/json-schema.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSchemaTypeName = getSchemaTypeName;
    exports2.getSchemaRefTypeTitle = getSchemaRefTypeTitle;
    exports2.isPrimitiveType = isPrimitiveType;
    exports2.isAnyOfAllOfOneOfType = isAnyOfAllOfOneOfType;
    function getSchemaTypeName(schema) {
      if (schema.title) {
        return schema.title;
      }
      if (schema.$id) {
        return getSchemaRefTypeTitle(schema.$id);
      }
      const ref = schema.$ref || schema._$ref;
      if (ref) {
        return getSchemaRefTypeTitle(ref);
      }
      if (Array.isArray(schema.type)) {
        return schema.type.join(" | ");
      }
      if (schema.type && schema.closestTitle) {
        return schema.type.concat("(", schema.closestTitle, ")");
      }
      return (schema.type || schema.closestTitle) ?? "";
    }
    function getSchemaRefTypeTitle($ref) {
      const match = $ref.match(/^(?:.*\/)?(.*?)(?:\.schema\.json)?$/);
      let type = !!match && match[1];
      if (!type) {
        type = "typeNotFound";
        console.error(`$ref (${$ref}) not parsed properly`);
      }
      return type;
    }
    function isPrimitiveType(schema) {
      return schema.type !== "object" && !isAnyOfAllOfOneOfType(schema);
    }
    function isAnyOfAllOfOneOfType(schema) {
      return !!(schema.anyOf || schema.allOf || schema.oneOf);
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/modeline-service.js
var require_modeline_service = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/modeline-service.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/modeline-service-impl.js
var require_modeline_service_impl = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/modeline-service-impl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.modelineService = void 0;
    var ModelineServiceImpl = class {
      getSchemaFromModeline(doc) {
        const yamlLanguageServerModeline = doc.lineComments.find((lineComment) => {
          return this.isModeline(lineComment);
        });
        if (yamlLanguageServerModeline != void 0) {
          const schemaMatchs = yamlLanguageServerModeline.match(/\$schema=\S+/g);
          if (schemaMatchs !== null && schemaMatchs.length >= 1) {
            if (schemaMatchs.length >= 2) {
              console.log("Several $schema attributes have been found on the yaml-language-server modeline. The first one will be picked.");
            }
            return schemaMatchs[0].substring("$schema=".length);
          }
        }
        return;
      }
      isModeline(lineText) {
        const matchModeline = lineText.match(/^#\s+yaml-language-server\s*:/g);
        return matchModeline !== null && matchModeline.length === 1;
      }
    };
    exports2.modelineService = new ModelineServiceImpl();
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-priority.js
var require_schema_priority = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-priority.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SchemaPriority = void 0;
    var SchemaPriority;
    (function(SchemaPriority2) {
      SchemaPriority2[SchemaPriority2["SchemaStore"] = 1] = "SchemaStore";
      SchemaPriority2[SchemaPriority2["SchemaAssociation"] = 2] = "SchemaAssociation";
      SchemaPriority2[SchemaPriority2["Settings"] = 3] = "Settings";
    })(SchemaPriority || (exports2.SchemaPriority = SchemaPriority = {}));
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-query-service.js
var require_schema_query_service = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-query-service.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../node_modules/.pnpm/vscode-uri@3.0.8/node_modules/vscode-uri/lib/umd/index.js
var require_umd = __commonJS({
  "../../node_modules/.pnpm/vscode-uri@3.0.8/node_modules/vscode-uri/lib/umd/index.js"(exports2, module2) {
    "use strict";
    !function(t, e) {
      if ("object" == typeof exports2 && "object" == typeof module2) module2.exports = e();
      else if ("function" == typeof define && define.amd) define([], e);
      else {
        var r = e();
        for (var n in r) ("object" == typeof exports2 ? exports2 : t)[n] = r[n];
      }
    }(exports2, () => (() => {
      "use strict";
      var t = { 470: (t2) => {
        function e2(t3) {
          if ("string" != typeof t3) throw new TypeError("Path must be a string. Received " + JSON.stringify(t3));
        }
        function r2(t3, e3) {
          for (var r3, n3 = "", i = 0, o = -1, s = 0, a = 0; a <= t3.length; ++a) {
            if (a < t3.length) r3 = t3.charCodeAt(a);
            else {
              if (47 === r3) break;
              r3 = 47;
            }
            if (47 === r3) {
              if (o === a - 1 || 1 === s) ;
              else if (o !== a - 1 && 2 === s) {
                if (n3.length < 2 || 2 !== i || 46 !== n3.charCodeAt(n3.length - 1) || 46 !== n3.charCodeAt(n3.length - 2)) {
                  if (n3.length > 2) {
                    var h = n3.lastIndexOf("/");
                    if (h !== n3.length - 1) {
                      -1 === h ? (n3 = "", i = 0) : i = (n3 = n3.slice(0, h)).length - 1 - n3.lastIndexOf("/"), o = a, s = 0;
                      continue;
                    }
                  } else if (2 === n3.length || 1 === n3.length) {
                    n3 = "", i = 0, o = a, s = 0;
                    continue;
                  }
                }
                e3 && (n3.length > 0 ? n3 += "/.." : n3 = "..", i = 2);
              } else n3.length > 0 ? n3 += "/" + t3.slice(o + 1, a) : n3 = t3.slice(o + 1, a), i = a - o - 1;
              o = a, s = 0;
            } else 46 === r3 && -1 !== s ? ++s : s = -1;
          }
          return n3;
        }
        var n2 = { resolve: function() {
          for (var t3, n3 = "", i = false, o = arguments.length - 1; o >= -1 && !i; o--) {
            var s;
            o >= 0 ? s = arguments[o] : (void 0 === t3 && (t3 = process.cwd()), s = t3), e2(s), 0 !== s.length && (n3 = s + "/" + n3, i = 47 === s.charCodeAt(0));
          }
          return n3 = r2(n3, !i), i ? n3.length > 0 ? "/" + n3 : "/" : n3.length > 0 ? n3 : ".";
        }, normalize: function(t3) {
          if (e2(t3), 0 === t3.length) return ".";
          var n3 = 47 === t3.charCodeAt(0), i = 47 === t3.charCodeAt(t3.length - 1);
          return 0 !== (t3 = r2(t3, !n3)).length || n3 || (t3 = "."), t3.length > 0 && i && (t3 += "/"), n3 ? "/" + t3 : t3;
        }, isAbsolute: function(t3) {
          return e2(t3), t3.length > 0 && 47 === t3.charCodeAt(0);
        }, join: function() {
          if (0 === arguments.length) return ".";
          for (var t3, r3 = 0; r3 < arguments.length; ++r3) {
            var i = arguments[r3];
            e2(i), i.length > 0 && (void 0 === t3 ? t3 = i : t3 += "/" + i);
          }
          return void 0 === t3 ? "." : n2.normalize(t3);
        }, relative: function(t3, r3) {
          if (e2(t3), e2(r3), t3 === r3) return "";
          if ((t3 = n2.resolve(t3)) === (r3 = n2.resolve(r3))) return "";
          for (var i = 1; i < t3.length && 47 === t3.charCodeAt(i); ++i) ;
          for (var o = t3.length, s = o - i, a = 1; a < r3.length && 47 === r3.charCodeAt(a); ++a) ;
          for (var h = r3.length - a, c = s < h ? s : h, f = -1, u = 0; u <= c; ++u) {
            if (u === c) {
              if (h > c) {
                if (47 === r3.charCodeAt(a + u)) return r3.slice(a + u + 1);
                if (0 === u) return r3.slice(a + u);
              } else s > c && (47 === t3.charCodeAt(i + u) ? f = u : 0 === u && (f = 0));
              break;
            }
            var l = t3.charCodeAt(i + u);
            if (l !== r3.charCodeAt(a + u)) break;
            47 === l && (f = u);
          }
          var d = "";
          for (u = i + f + 1; u <= o; ++u) u !== o && 47 !== t3.charCodeAt(u) || (0 === d.length ? d += ".." : d += "/..");
          return d.length > 0 ? d + r3.slice(a + f) : (a += f, 47 === r3.charCodeAt(a) && ++a, r3.slice(a));
        }, _makeLong: function(t3) {
          return t3;
        }, dirname: function(t3) {
          if (e2(t3), 0 === t3.length) return ".";
          for (var r3 = t3.charCodeAt(0), n3 = 47 === r3, i = -1, o = true, s = t3.length - 1; s >= 1; --s) if (47 === (r3 = t3.charCodeAt(s))) {
            if (!o) {
              i = s;
              break;
            }
          } else o = false;
          return -1 === i ? n3 ? "/" : "." : n3 && 1 === i ? "//" : t3.slice(0, i);
        }, basename: function(t3, r3) {
          if (void 0 !== r3 && "string" != typeof r3) throw new TypeError('"ext" argument must be a string');
          e2(t3);
          var n3, i = 0, o = -1, s = true;
          if (void 0 !== r3 && r3.length > 0 && r3.length <= t3.length) {
            if (r3.length === t3.length && r3 === t3) return "";
            var a = r3.length - 1, h = -1;
            for (n3 = t3.length - 1; n3 >= 0; --n3) {
              var c = t3.charCodeAt(n3);
              if (47 === c) {
                if (!s) {
                  i = n3 + 1;
                  break;
                }
              } else -1 === h && (s = false, h = n3 + 1), a >= 0 && (c === r3.charCodeAt(a) ? -1 == --a && (o = n3) : (a = -1, o = h));
            }
            return i === o ? o = h : -1 === o && (o = t3.length), t3.slice(i, o);
          }
          for (n3 = t3.length - 1; n3 >= 0; --n3) if (47 === t3.charCodeAt(n3)) {
            if (!s) {
              i = n3 + 1;
              break;
            }
          } else -1 === o && (s = false, o = n3 + 1);
          return -1 === o ? "" : t3.slice(i, o);
        }, extname: function(t3) {
          e2(t3);
          for (var r3 = -1, n3 = 0, i = -1, o = true, s = 0, a = t3.length - 1; a >= 0; --a) {
            var h = t3.charCodeAt(a);
            if (47 !== h) -1 === i && (o = false, i = a + 1), 46 === h ? -1 === r3 ? r3 = a : 1 !== s && (s = 1) : -1 !== r3 && (s = -1);
            else if (!o) {
              n3 = a + 1;
              break;
            }
          }
          return -1 === r3 || -1 === i || 0 === s || 1 === s && r3 === i - 1 && r3 === n3 + 1 ? "" : t3.slice(r3, i);
        }, format: function(t3) {
          if (null === t3 || "object" != typeof t3) throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof t3);
          return function(t4, e3) {
            var r3 = e3.dir || e3.root, n3 = e3.base || (e3.name || "") + (e3.ext || "");
            return r3 ? r3 === e3.root ? r3 + n3 : r3 + "/" + n3 : n3;
          }(0, t3);
        }, parse: function(t3) {
          e2(t3);
          var r3 = { root: "", dir: "", base: "", ext: "", name: "" };
          if (0 === t3.length) return r3;
          var n3, i = t3.charCodeAt(0), o = 47 === i;
          o ? (r3.root = "/", n3 = 1) : n3 = 0;
          for (var s = -1, a = 0, h = -1, c = true, f = t3.length - 1, u = 0; f >= n3; --f) if (47 !== (i = t3.charCodeAt(f))) -1 === h && (c = false, h = f + 1), 46 === i ? -1 === s ? s = f : 1 !== u && (u = 1) : -1 !== s && (u = -1);
          else if (!c) {
            a = f + 1;
            break;
          }
          return -1 === s || -1 === h || 0 === u || 1 === u && s === h - 1 && s === a + 1 ? -1 !== h && (r3.base = r3.name = 0 === a && o ? t3.slice(1, h) : t3.slice(a, h)) : (0 === a && o ? (r3.name = t3.slice(1, s), r3.base = t3.slice(1, h)) : (r3.name = t3.slice(a, s), r3.base = t3.slice(a, h)), r3.ext = t3.slice(s, h)), a > 0 ? r3.dir = t3.slice(0, a - 1) : o && (r3.dir = "/"), r3;
        }, sep: "/", delimiter: ":", win32: null, posix: null };
        n2.posix = n2, t2.exports = n2;
      }, 674: (t2, e2) => {
        if (Object.defineProperty(e2, "__esModule", { value: true }), e2.isWindows = void 0, "object" == typeof process) e2.isWindows = "win32" === process.platform;
        else if ("object" == typeof navigator) {
          let t3 = navigator.userAgent;
          e2.isWindows = t3.indexOf("Windows") >= 0;
        }
      }, 796: (t2, e2, r2) => {
        Object.defineProperty(e2, "__esModule", { value: true }), e2.uriToFsPath = e2.URI = void 0;
        const n2 = r2(674), i = /^\w[\w\d+.-]*$/, o = /^\//, s = /^\/\//;
        function a(t3, e3) {
          if (!t3.scheme && e3) throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${t3.authority}", path: "${t3.path}", query: "${t3.query}", fragment: "${t3.fragment}"}`);
          if (t3.scheme && !i.test(t3.scheme)) throw new Error("[UriError]: Scheme contains illegal characters.");
          if (t3.path) {
            if (t3.authority) {
              if (!o.test(t3.path)) throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
            } else if (s.test(t3.path)) throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
          }
        }
        const h = "", c = "/", f = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
        class u {
          static isUri(t3) {
            return t3 instanceof u || !!t3 && "string" == typeof t3.authority && "string" == typeof t3.fragment && "string" == typeof t3.path && "string" == typeof t3.query && "string" == typeof t3.scheme && "string" == typeof t3.fsPath && "function" == typeof t3.with && "function" == typeof t3.toString;
          }
          scheme;
          authority;
          path;
          query;
          fragment;
          constructor(t3, e3, r3, n3, i2, o2 = false) {
            "object" == typeof t3 ? (this.scheme = t3.scheme || h, this.authority = t3.authority || h, this.path = t3.path || h, this.query = t3.query || h, this.fragment = t3.fragment || h) : (this.scheme = /* @__PURE__ */ function(t4, e4) {
              return t4 || e4 ? t4 : "file";
            }(t3, o2), this.authority = e3 || h, this.path = function(t4, e4) {
              switch (t4) {
                case "https":
                case "http":
                case "file":
                  e4 ? e4[0] !== c && (e4 = c + e4) : e4 = c;
              }
              return e4;
            }(this.scheme, r3 || h), this.query = n3 || h, this.fragment = i2 || h, a(this, o2));
          }
          get fsPath() {
            return v(this, false);
          }
          with(t3) {
            if (!t3) return this;
            let { scheme: e3, authority: r3, path: n3, query: i2, fragment: o2 } = t3;
            return void 0 === e3 ? e3 = this.scheme : null === e3 && (e3 = h), void 0 === r3 ? r3 = this.authority : null === r3 && (r3 = h), void 0 === n3 ? n3 = this.path : null === n3 && (n3 = h), void 0 === i2 ? i2 = this.query : null === i2 && (i2 = h), void 0 === o2 ? o2 = this.fragment : null === o2 && (o2 = h), e3 === this.scheme && r3 === this.authority && n3 === this.path && i2 === this.query && o2 === this.fragment ? this : new d(e3, r3, n3, i2, o2);
          }
          static parse(t3, e3 = false) {
            const r3 = f.exec(t3);
            return r3 ? new d(r3[2] || h, w(r3[4] || h), w(r3[5] || h), w(r3[7] || h), w(r3[9] || h), e3) : new d(h, h, h, h, h);
          }
          static file(t3) {
            let e3 = h;
            if (n2.isWindows && (t3 = t3.replace(/\\/g, c)), t3[0] === c && t3[1] === c) {
              const r3 = t3.indexOf(c, 2);
              -1 === r3 ? (e3 = t3.substring(2), t3 = c) : (e3 = t3.substring(2, r3), t3 = t3.substring(r3) || c);
            }
            return new d("file", e3, t3, h, h);
          }
          static from(t3) {
            const e3 = new d(t3.scheme, t3.authority, t3.path, t3.query, t3.fragment);
            return a(e3, true), e3;
          }
          toString(t3 = false) {
            return y(this, t3);
          }
          toJSON() {
            return this;
          }
          static revive(t3) {
            if (t3) {
              if (t3 instanceof u) return t3;
              {
                const e3 = new d(t3);
                return e3._formatted = t3.external, e3._fsPath = t3._sep === l ? t3.fsPath : null, e3;
              }
            }
            return t3;
          }
        }
        e2.URI = u;
        const l = n2.isWindows ? 1 : void 0;
        class d extends u {
          _formatted = null;
          _fsPath = null;
          get fsPath() {
            return this._fsPath || (this._fsPath = v(this, false)), this._fsPath;
          }
          toString(t3 = false) {
            return t3 ? y(this, true) : (this._formatted || (this._formatted = y(this, false)), this._formatted);
          }
          toJSON() {
            const t3 = { $mid: 1 };
            return this._fsPath && (t3.fsPath = this._fsPath, t3._sep = l), this._formatted && (t3.external = this._formatted), this.path && (t3.path = this.path), this.scheme && (t3.scheme = this.scheme), this.authority && (t3.authority = this.authority), this.query && (t3.query = this.query), this.fragment && (t3.fragment = this.fragment), t3;
          }
        }
        const p = { 58: "%3A", 47: "%2F", 63: "%3F", 35: "%23", 91: "%5B", 93: "%5D", 64: "%40", 33: "%21", 36: "%24", 38: "%26", 39: "%27", 40: "%28", 41: "%29", 42: "%2A", 43: "%2B", 44: "%2C", 59: "%3B", 61: "%3D", 32: "%20" };
        function g(t3, e3, r3) {
          let n3, i2 = -1;
          for (let o2 = 0; o2 < t3.length; o2++) {
            const s2 = t3.charCodeAt(o2);
            if (s2 >= 97 && s2 <= 122 || s2 >= 65 && s2 <= 90 || s2 >= 48 && s2 <= 57 || 45 === s2 || 46 === s2 || 95 === s2 || 126 === s2 || e3 && 47 === s2 || r3 && 91 === s2 || r3 && 93 === s2 || r3 && 58 === s2) -1 !== i2 && (n3 += encodeURIComponent(t3.substring(i2, o2)), i2 = -1), void 0 !== n3 && (n3 += t3.charAt(o2));
            else {
              void 0 === n3 && (n3 = t3.substr(0, o2));
              const e4 = p[s2];
              void 0 !== e4 ? (-1 !== i2 && (n3 += encodeURIComponent(t3.substring(i2, o2)), i2 = -1), n3 += e4) : -1 === i2 && (i2 = o2);
            }
          }
          return -1 !== i2 && (n3 += encodeURIComponent(t3.substring(i2))), void 0 !== n3 ? n3 : t3;
        }
        function m(t3) {
          let e3;
          for (let r3 = 0; r3 < t3.length; r3++) {
            const n3 = t3.charCodeAt(r3);
            35 === n3 || 63 === n3 ? (void 0 === e3 && (e3 = t3.substr(0, r3)), e3 += p[n3]) : void 0 !== e3 && (e3 += t3[r3]);
          }
          return void 0 !== e3 ? e3 : t3;
        }
        function v(t3, e3) {
          let r3;
          return r3 = t3.authority && t3.path.length > 1 && "file" === t3.scheme ? `//${t3.authority}${t3.path}` : 47 === t3.path.charCodeAt(0) && (t3.path.charCodeAt(1) >= 65 && t3.path.charCodeAt(1) <= 90 || t3.path.charCodeAt(1) >= 97 && t3.path.charCodeAt(1) <= 122) && 58 === t3.path.charCodeAt(2) ? e3 ? t3.path.substr(1) : t3.path[1].toLowerCase() + t3.path.substr(2) : t3.path, n2.isWindows && (r3 = r3.replace(/\//g, "\\")), r3;
        }
        function y(t3, e3) {
          const r3 = e3 ? m : g;
          let n3 = "", { scheme: i2, authority: o2, path: s2, query: a2, fragment: h2 } = t3;
          if (i2 && (n3 += i2, n3 += ":"), (o2 || "file" === i2) && (n3 += c, n3 += c), o2) {
            let t4 = o2.indexOf("@");
            if (-1 !== t4) {
              const e4 = o2.substr(0, t4);
              o2 = o2.substr(t4 + 1), t4 = e4.lastIndexOf(":"), -1 === t4 ? n3 += r3(e4, false, false) : (n3 += r3(e4.substr(0, t4), false, false), n3 += ":", n3 += r3(e4.substr(t4 + 1), false, true)), n3 += "@";
            }
            o2 = o2.toLowerCase(), t4 = o2.lastIndexOf(":"), -1 === t4 ? n3 += r3(o2, false, true) : (n3 += r3(o2.substr(0, t4), false, true), n3 += o2.substr(t4));
          }
          if (s2) {
            if (s2.length >= 3 && 47 === s2.charCodeAt(0) && 58 === s2.charCodeAt(2)) {
              const t4 = s2.charCodeAt(1);
              t4 >= 65 && t4 <= 90 && (s2 = `/${String.fromCharCode(t4 + 32)}:${s2.substr(3)}`);
            } else if (s2.length >= 2 && 58 === s2.charCodeAt(1)) {
              const t4 = s2.charCodeAt(0);
              t4 >= 65 && t4 <= 90 && (s2 = `${String.fromCharCode(t4 + 32)}:${s2.substr(2)}`);
            }
            n3 += r3(s2, true, false);
          }
          return a2 && (n3 += "?", n3 += r3(a2, false, false)), h2 && (n3 += "#", n3 += e3 ? h2 : g(h2, false, false)), n3;
        }
        function b(t3) {
          try {
            return decodeURIComponent(t3);
          } catch {
            return t3.length > 3 ? t3.substr(0, 3) + b(t3.substr(3)) : t3;
          }
        }
        e2.uriToFsPath = v;
        const C = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
        function w(t3) {
          return t3.match(C) ? t3.replace(C, (t4) => b(t4)) : t3;
        }
      }, 679: function(t2, e2, r2) {
        var n2 = this && this.__createBinding || (Object.create ? function(t3, e3, r3, n3) {
          void 0 === n3 && (n3 = r3);
          var i2 = Object.getOwnPropertyDescriptor(e3, r3);
          i2 && !("get" in i2 ? !e3.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
            return e3[r3];
          } }), Object.defineProperty(t3, n3, i2);
        } : function(t3, e3, r3, n3) {
          void 0 === n3 && (n3 = r3), t3[n3] = e3[r3];
        }), i = this && this.__setModuleDefault || (Object.create ? function(t3, e3) {
          Object.defineProperty(t3, "default", { enumerable: true, value: e3 });
        } : function(t3, e3) {
          t3.default = e3;
        }), o = this && this.__importStar || function(t3) {
          if (t3 && t3.__esModule) return t3;
          var e3 = {};
          if (null != t3) for (var r3 in t3) "default" !== r3 && Object.prototype.hasOwnProperty.call(t3, r3) && n2(e3, t3, r3);
          return i(e3, t3), e3;
        };
        Object.defineProperty(e2, "__esModule", { value: true }), e2.Utils = void 0;
        const s = o(r2(470)), a = s.posix || s, h = "/";
        var c;
        !function(t3) {
          t3.joinPath = function(t4, ...e3) {
            return t4.with({ path: a.join(t4.path, ...e3) });
          }, t3.resolvePath = function(t4, ...e3) {
            let r3 = t4.path, n3 = false;
            r3[0] !== h && (r3 = h + r3, n3 = true);
            let i2 = a.resolve(r3, ...e3);
            return n3 && i2[0] === h && !t4.authority && (i2 = i2.substring(1)), t4.with({ path: i2 });
          }, t3.dirname = function(t4) {
            if (0 === t4.path.length || t4.path === h) return t4;
            let e3 = a.dirname(t4.path);
            return 1 === e3.length && 46 === e3.charCodeAt(0) && (e3 = ""), t4.with({ path: e3 });
          }, t3.basename = function(t4) {
            return a.basename(t4.path);
          }, t3.extname = function(t4) {
            return a.extname(t4.path);
          };
        }(c || (e2.Utils = c = {}));
      } }, e = {};
      function r(n2) {
        var i = e[n2];
        if (void 0 !== i) return i.exports;
        var o = e[n2] = { exports: {} };
        return t[n2].call(o.exports, o, o.exports, r), o.exports;
      }
      var n = {};
      return (() => {
        var t2 = n;
        Object.defineProperty(t2, "__esModule", { value: true }), t2.Utils = t2.URI = void 0;
        const e2 = r(796);
        Object.defineProperty(t2, "URI", { enumerable: true, get: function() {
          return e2.URI;
        } });
        const i = r(679);
        Object.defineProperty(t2, "Utils", { enumerable: true, get: function() {
          return i.Utils;
        } });
      })(), n;
    })());
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-query-service-impl.js
var require_schema_query_service_impl = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-query-service-impl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createSchemaQueryService = createSchemaQueryService;
    var vscode_uri_1 = require_umd();
    var SchemaQueryServiceImpl = class {
      path;
      constructor(path4) {
        this.path = path4;
      }
      getSchemaTitle(schema, url) {
        const uri = vscode_uri_1.URI.parse(url);
        let baseName = this.path.basename(uri.fsPath);
        if (!this.path.extname(uri.fsPath)) {
          baseName += ".json";
        }
        const schemaNameProperty = Object.getOwnPropertyDescriptor(schema, "name");
        if (schemaNameProperty) {
          return schemaNameProperty.value + ` (${baseName})`;
        } else if (schema.title) {
          return schema.description ? schema.title + " - " + schema.description + ` (${baseName})` : schema.title + ` (${baseName})`;
        }
        return baseName;
      }
    };
    function createSchemaQueryService(path4) {
      return new SchemaQueryServiceImpl(path4);
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-request-service.js
var require_schema_request_service = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-request-service.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-services-provider.js
var require_schema_services_provider = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-services-provider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-store-actions.js
var require_schema_store_actions = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-store-actions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MODIFICATION_ACTIONS = void 0;
    var MODIFICATION_ACTIONS;
    (function(MODIFICATION_ACTIONS2) {
      MODIFICATION_ACTIONS2[MODIFICATION_ACTIONS2["delete"] = 0] = "delete";
      MODIFICATION_ACTIONS2[MODIFICATION_ACTIONS2["add"] = 1] = "add";
      MODIFICATION_ACTIONS2[MODIFICATION_ACTIONS2["deleteAll"] = 2] = "deleteAll";
    })(MODIFICATION_ACTIONS || (exports2.MODIFICATION_ACTIONS = MODIFICATION_ACTIONS = {}));
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-store-service.js
var require_schema_store_service = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-store-service.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/schema-validation-service.js
var require_schema_validation_service = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/schema-validation-service.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../node_modules/.pnpm/vscode-nls@5.2.0/node_modules/vscode-nls/lib/common/ral.js
var require_ral = __commonJS({
  "../../node_modules/.pnpm/vscode-nls@5.2.0/node_modules/vscode-nls/lib/common/ral.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var _ral;
    function RAL() {
      if (_ral === void 0) {
        throw new Error("No runtime abstraction layer installed");
      }
      return _ral;
    }
    (function(RAL2) {
      function install(ral) {
        if (ral === void 0) {
          throw new Error("No runtime abstraction layer provided");
        }
        _ral = ral;
      }
      RAL2.install = install;
    })(RAL || (RAL = {}));
    exports2.default = RAL;
  }
});

// ../../node_modules/.pnpm/vscode-nls@5.2.0/node_modules/vscode-nls/lib/common/common.js
var require_common = __commonJS({
  "../../node_modules/.pnpm/vscode-nls@5.2.0/node_modules/vscode-nls/lib/common/common.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.config = exports2.loadMessageBundle = exports2.localize = exports2.format = exports2.setPseudo = exports2.isPseudo = exports2.isDefined = exports2.BundleFormat = exports2.MessageFormat = void 0;
    var ral_1 = require_ral();
    var MessageFormat;
    (function(MessageFormat2) {
      MessageFormat2["file"] = "file";
      MessageFormat2["bundle"] = "bundle";
      MessageFormat2["both"] = "both";
    })(MessageFormat = exports2.MessageFormat || (exports2.MessageFormat = {}));
    var BundleFormat;
    (function(BundleFormat2) {
      BundleFormat2["standalone"] = "standalone";
      BundleFormat2["languagePack"] = "languagePack";
    })(BundleFormat = exports2.BundleFormat || (exports2.BundleFormat = {}));
    var LocalizeInfo;
    (function(LocalizeInfo2) {
      function is(value) {
        var candidate = value;
        return candidate && isDefined(candidate.key) && isDefined(candidate.comment);
      }
      LocalizeInfo2.is = is;
    })(LocalizeInfo || (LocalizeInfo = {}));
    function isDefined(value) {
      return typeof value !== "undefined";
    }
    exports2.isDefined = isDefined;
    exports2.isPseudo = false;
    function setPseudo(pseudo) {
      exports2.isPseudo = pseudo;
    }
    exports2.setPseudo = setPseudo;
    function format(message, args) {
      var result;
      if (exports2.isPseudo) {
        message = "\uFF3B" + message.replace(/[aouei]/g, "$&$&") + "\uFF3D";
      }
      if (args.length === 0) {
        result = message;
      } else {
        result = message.replace(/\{(\d+)\}/g, function(match, rest) {
          var index = rest[0];
          var arg = args[index];
          var replacement = match;
          if (typeof arg === "string") {
            replacement = arg;
          } else if (typeof arg === "number" || typeof arg === "boolean" || arg === void 0 || arg === null) {
            replacement = String(arg);
          }
          return replacement;
        });
      }
      return result;
    }
    exports2.format = format;
    function localize(_key, message) {
      var args = [];
      for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
      }
      return format(message, args);
    }
    exports2.localize = localize;
    function loadMessageBundle(file) {
      return (0, ral_1.default)().loadMessageBundle(file);
    }
    exports2.loadMessageBundle = loadMessageBundle;
    function config(opts) {
      return (0, ral_1.default)().config(opts);
    }
    exports2.config = config;
  }
});

// ../../node_modules/.pnpm/vscode-nls@5.2.0/node_modules/vscode-nls/lib/node/main.js
var require_main2 = __commonJS({
  "../../node_modules/.pnpm/vscode-nls@5.2.0/node_modules/vscode-nls/lib/node/main.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.config = exports2.loadMessageBundle = exports2.BundleFormat = exports2.MessageFormat = void 0;
    var path4 = require("path");
    var fs4 = require("fs");
    var ral_1 = require_ral();
    var common_1 = require_common();
    var common_2 = require_common();
    Object.defineProperty(exports2, "MessageFormat", { enumerable: true, get: function() {
      return common_2.MessageFormat;
    } });
    Object.defineProperty(exports2, "BundleFormat", { enumerable: true, get: function() {
      return common_2.BundleFormat;
    } });
    var toString = Object.prototype.toString;
    function isNumber(value) {
      return toString.call(value) === "[object Number]";
    }
    function isString(value) {
      return toString.call(value) === "[object String]";
    }
    function isBoolean(value) {
      return value === true || value === false;
    }
    function readJsonFileSync(filename) {
      return JSON.parse(fs4.readFileSync(filename, "utf8"));
    }
    var resolvedBundles;
    var options;
    function initializeSettings() {
      options = { locale: void 0, language: void 0, languagePackSupport: false, cacheLanguageResolution: true, messageFormat: common_1.MessageFormat.bundle };
      if (isString(process.env.VSCODE_NLS_CONFIG)) {
        try {
          var vscodeOptions_1 = JSON.parse(process.env.VSCODE_NLS_CONFIG);
          var language = void 0;
          if (vscodeOptions_1.availableLanguages) {
            var value = vscodeOptions_1.availableLanguages["*"];
            if (isString(value)) {
              language = value;
            }
          }
          if (isString(vscodeOptions_1.locale)) {
            options.locale = vscodeOptions_1.locale.toLowerCase();
          }
          if (language === void 0) {
            options.language = options.locale;
          } else if (language !== "en") {
            options.language = language;
          }
          if (isBoolean(vscodeOptions_1._languagePackSupport)) {
            options.languagePackSupport = vscodeOptions_1._languagePackSupport;
          }
          if (isString(vscodeOptions_1._cacheRoot)) {
            options.cacheRoot = vscodeOptions_1._cacheRoot;
          }
          if (isString(vscodeOptions_1._languagePackId)) {
            options.languagePackId = vscodeOptions_1._languagePackId;
          }
          if (isString(vscodeOptions_1._translationsConfigFile)) {
            options.translationsConfigFile = vscodeOptions_1._translationsConfigFile;
            try {
              options.translationsConfig = readJsonFileSync(options.translationsConfigFile);
            } catch (error) {
              if (vscodeOptions_1._corruptedFile) {
                var dirname2 = path4.dirname(vscodeOptions_1._corruptedFile);
                fs4.exists(dirname2, function(exists) {
                  if (exists) {
                    fs4.writeFile(vscodeOptions_1._corruptedFile, "corrupted", "utf8", function(err) {
                      console.error(err);
                    });
                  }
                });
              }
            }
          }
        } catch (_a) {
        }
      }
      (0, common_1.setPseudo)(options.locale === "pseudo");
      resolvedBundles = /* @__PURE__ */ Object.create(null);
    }
    initializeSettings();
    function supportsLanguagePack() {
      return options.languagePackSupport === true && options.cacheRoot !== void 0 && options.languagePackId !== void 0 && options.translationsConfigFile !== void 0 && options.translationsConfig !== void 0;
    }
    function createScopedLocalizeFunction(messages) {
      return function(key, message) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
          args[_i - 2] = arguments[_i];
        }
        if (isNumber(key)) {
          if (key >= messages.length) {
            console.error("Broken localize call found. Index out of bounds. Stacktrace is\n: ".concat(new Error("").stack));
            return;
          }
          return (0, common_1.format)(messages[key], args);
        } else {
          if (isString(message)) {
            console.warn("Message ".concat(message, " didn't get externalized correctly."));
            return (0, common_1.format)(message, args);
          } else {
            console.error("Broken localize call found. Stacktrace is\n: ".concat(new Error("").stack));
          }
        }
      };
    }
    function resolveLanguage(file) {
      var resolvedLanguage;
      if (options.cacheLanguageResolution && resolvedLanguage) {
        resolvedLanguage = resolvedLanguage;
      } else {
        if (common_1.isPseudo || !options.language) {
          resolvedLanguage = ".nls.json";
        } else {
          var locale = options.language;
          while (locale) {
            var candidate = ".nls." + locale + ".json";
            if (fs4.existsSync(file + candidate)) {
              resolvedLanguage = candidate;
              break;
            } else {
              var index = locale.lastIndexOf("-");
              if (index > 0) {
                locale = locale.substring(0, index);
              } else {
                resolvedLanguage = ".nls.json";
                locale = null;
              }
            }
          }
        }
        if (options.cacheLanguageResolution) {
          resolvedLanguage = resolvedLanguage;
        }
      }
      return file + resolvedLanguage;
    }
    function findInTheBoxBundle(root) {
      var language = options.language;
      while (language) {
        var candidate = path4.join(root, "nls.bundle.".concat(language, ".json"));
        if (fs4.existsSync(candidate)) {
          return candidate;
        } else {
          var index = language.lastIndexOf("-");
          if (index > 0) {
            language = language.substring(0, index);
          } else {
            language = void 0;
          }
        }
      }
      if (language === void 0) {
        var candidate = path4.join(root, "nls.bundle.json");
        if (fs4.existsSync(candidate)) {
          return candidate;
        }
      }
      return void 0;
    }
    function createDefaultNlsBundle(folder) {
      var metaData = readJsonFileSync(path4.join(folder, "nls.metadata.json"));
      var result = /* @__PURE__ */ Object.create(null);
      for (var module_1 in metaData) {
        var entry = metaData[module_1];
        result[module_1] = entry.messages;
      }
      return result;
    }
    function createNLSBundle(header, metaDataPath) {
      var languagePackLocation = options.translationsConfig[header.id];
      if (!languagePackLocation) {
        return void 0;
      }
      var languagePack = readJsonFileSync(languagePackLocation).contents;
      var metaData = readJsonFileSync(path4.join(metaDataPath, "nls.metadata.json"));
      var result = /* @__PURE__ */ Object.create(null);
      for (var module_2 in metaData) {
        var entry = metaData[module_2];
        var translations = languagePack["".concat(header.outDir, "/").concat(module_2)];
        if (translations) {
          var resultMessages = [];
          for (var i = 0; i < entry.keys.length; i++) {
            var messageKey = entry.keys[i];
            var key = isString(messageKey) ? messageKey : messageKey.key;
            var translatedMessage = translations[key];
            if (translatedMessage === void 0) {
              translatedMessage = entry.messages[i];
            }
            resultMessages.push(translatedMessage);
          }
          result[module_2] = resultMessages;
        } else {
          result[module_2] = entry.messages;
        }
      }
      return result;
    }
    function touch(file) {
      var d = /* @__PURE__ */ new Date();
      fs4.utimes(file, d, d, function() {
      });
    }
    function cacheBundle(key, bundle) {
      resolvedBundles[key] = bundle;
      return bundle;
    }
    function loadNlsBundleOrCreateFromI18n(header, bundlePath) {
      var result;
      var bundle = path4.join(options.cacheRoot, "".concat(header.id, "-").concat(header.hash, ".json"));
      var useMemoryOnly = false;
      var writeBundle = false;
      try {
        result = JSON.parse(fs4.readFileSync(bundle, { encoding: "utf8", flag: "r" }));
        touch(bundle);
        return result;
      } catch (err) {
        if (err.code === "ENOENT") {
          writeBundle = true;
        } else if (err instanceof SyntaxError) {
          console.log("Syntax error parsing message bundle: ".concat(err.message, "."));
          fs4.unlink(bundle, function(err2) {
            if (err2) {
              console.error("Deleting corrupted bundle ".concat(bundle, " failed."));
            }
          });
          useMemoryOnly = true;
        } else {
          throw err;
        }
      }
      result = createNLSBundle(header, bundlePath);
      if (!result || useMemoryOnly) {
        return result;
      }
      if (writeBundle) {
        try {
          fs4.writeFileSync(bundle, JSON.stringify(result), { encoding: "utf8", flag: "wx" });
        } catch (err) {
          if (err.code === "EEXIST") {
            return result;
          }
          throw err;
        }
      }
      return result;
    }
    function loadDefaultNlsBundle(bundlePath) {
      try {
        return createDefaultNlsBundle(bundlePath);
      } catch (err) {
        console.log("Generating default bundle from meta data failed.", err);
        return void 0;
      }
    }
    function loadNlsBundle(header, bundlePath) {
      var result;
      if (supportsLanguagePack()) {
        try {
          result = loadNlsBundleOrCreateFromI18n(header, bundlePath);
        } catch (err) {
          console.log("Load or create bundle failed ", err);
        }
      }
      if (!result) {
        if (options.languagePackSupport) {
          return loadDefaultNlsBundle(bundlePath);
        }
        var candidate = findInTheBoxBundle(bundlePath);
        if (candidate) {
          try {
            return readJsonFileSync(candidate);
          } catch (err) {
            console.log("Loading in the box message bundle failed.", err);
          }
        }
        result = loadDefaultNlsBundle(bundlePath);
      }
      return result;
    }
    function tryFindMetaDataHeaderFile(file) {
      var result;
      var dirname2 = path4.dirname(file);
      while (true) {
        result = path4.join(dirname2, "nls.metadata.header.json");
        if (fs4.existsSync(result)) {
          break;
        }
        var parent = path4.dirname(dirname2);
        if (parent === dirname2) {
          result = void 0;
          break;
        } else {
          dirname2 = parent;
        }
      }
      return result;
    }
    function loadMessageBundle(file) {
      if (!file) {
        return common_1.localize;
      }
      var ext = path4.extname(file);
      if (ext) {
        file = file.substr(0, file.length - ext.length);
      }
      if (options.messageFormat === common_1.MessageFormat.both || options.messageFormat === common_1.MessageFormat.bundle) {
        var headerFile = tryFindMetaDataHeaderFile(file);
        if (headerFile) {
          var bundlePath = path4.dirname(headerFile);
          var bundle = resolvedBundles[bundlePath];
          if (bundle === void 0) {
            try {
              var header = JSON.parse(fs4.readFileSync(headerFile, "utf8"));
              try {
                var nlsBundle = loadNlsBundle(header, bundlePath);
                bundle = cacheBundle(bundlePath, nlsBundle ? { header, nlsBundle } : null);
              } catch (err) {
                console.error("Failed to load nls bundle", err);
                bundle = cacheBundle(bundlePath, null);
              }
            } catch (err) {
              console.error("Failed to read header file", err);
              bundle = cacheBundle(bundlePath, null);
            }
          }
          if (bundle) {
            var module_3 = file.substr(bundlePath.length + 1).replace(/\\/g, "/");
            var messages = bundle.nlsBundle[module_3];
            if (messages === void 0) {
              console.error("Messages for file ".concat(file, " not found. See console for details."));
              return function() {
                return "Messages not found.";
              };
            }
            return createScopedLocalizeFunction(messages);
          }
        }
      }
      if (options.messageFormat === common_1.MessageFormat.both || options.messageFormat === common_1.MessageFormat.file) {
        try {
          var json = readJsonFileSync(resolveLanguage(file));
          if (Array.isArray(json)) {
            return createScopedLocalizeFunction(json);
          } else {
            if ((0, common_1.isDefined)(json.messages) && (0, common_1.isDefined)(json.keys)) {
              return createScopedLocalizeFunction(json.messages);
            } else {
              console.error("String bundle '".concat(file, "' uses an unsupported format."));
              return function() {
                return "File bundle has unsupported format. See console for details";
              };
            }
          }
        } catch (err) {
          if (err.code !== "ENOENT") {
            console.error("Failed to load single file bundle", err);
          }
        }
      }
      console.error("Failed to load message bundle for file ".concat(file));
      return function() {
        return "Failed to load message bundle. See console for details.";
      };
    }
    exports2.loadMessageBundle = loadMessageBundle;
    function config(opts) {
      if (opts) {
        if (isString(opts.locale)) {
          options.locale = opts.locale.toLowerCase();
          options.language = options.locale;
          resolvedBundles = /* @__PURE__ */ Object.create(null);
        }
        if (opts.messageFormat !== void 0) {
          options.messageFormat = opts.messageFormat;
        }
        if (opts.bundleFormat === common_1.BundleFormat.standalone && options.languagePackSupport === true) {
          options.languagePackSupport = false;
        }
      }
      (0, common_1.setPseudo)(options.locale === "pseudo");
      return loadMessageBundle;
    }
    exports2.config = config;
    ral_1.default.install(Object.freeze({
      loadMessageBundle,
      config
    }));
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/file-pattern-association.js
var require_file_pattern_association = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/file-pattern-association.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FilePatternAssociation = void 0;
    var utils_1 = require_utils();
    var FilePatternAssociation = class {
      schemas;
      patternRegExp;
      constructor(pattern) {
        try {
          this.patternRegExp = new RegExp((0, utils_1.convertSimple2RegExpPattern)(pattern) + "$");
        } catch (e) {
          this.patternRegExp = void 0;
        }
        this.schemas = [];
      }
      addSchema(id) {
        this.schemas.push(id);
      }
      matchesPattern(fileName) {
        return !!this.patternRegExp && this.patternRegExp.test(fileName);
      }
      getSchemas() {
        return this.schemas;
      }
    };
    exports2.FilePatternAssociation = FilePatternAssociation;
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/yaml-ast-with-schema-impl.js
var require_yaml_ast_with_schema_impl = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/yaml-ast-with-schema-impl.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault2 = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar2 = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding2(result, mod, k);
      }
      __setModuleDefault2(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.YamlAstViewWithSchema = exports2.ValidationResult = exports2.EnumMatch = exports2.ProblemTypeMessages = exports2.ProblemType = exports2.YAML_SOURCE = exports2.formats = void 0;
    exports2.asSchema = asSchema;
    exports2.getNodeValue = getNodeValue;
    exports2.contains = contains;
    exports2.findNodeAtOffset = findNodeAtOffset;
    var vscode_json_languageservice_1 = require("vscode-json-languageservice");
    var vscode_languageserver_types_1 = require_main();
    var nls = __importStar2(require_main2());
    var vscode_uri_1 = require_umd();
    var utils_1 = require_utils();
    var objects_1 = require_objects();
    var strings_1 = require_strings();
    var file_pattern_association_1 = require_file_pattern_association();
    var json_schema_1 = require_json_schema();
    var localize = nls.loadMessageBundle();
    var MSG_PROPERTY_NOT_ALLOWED = "Property {0} is not allowed.";
    exports2.formats = {
      "color-hex": {
        errorMessage: localize("colorHexFormatWarning", "Invalid color format. Use #RGB, #RGBA, #RRGGBB or #RRGGBBAA."),
        pattern: /^#([0-9A-Fa-f]{3,4}|([0-9A-Fa-f]{2}){3,4})$/
      },
      "date-time": {
        errorMessage: localize("dateTimeFormatWarning", "String is not a RFC3339 date-time."),
        pattern: /^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]|60)(\.[0-9]+)?(Z|(\+|-)([01][0-9]|2[0-3]):([0-5][0-9]))$/i
      },
      date: {
        errorMessage: localize("dateFormatWarning", "String is not a RFC3339 date."),
        pattern: /^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])$/i
      },
      time: {
        errorMessage: localize("timeFormatWarning", "String is not a RFC3339 time."),
        pattern: /^([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]|60)(\.[0-9]+)?(Z|(\+|-)([01][0-9]|2[0-3]):([0-5][0-9]))$/i
      },
      email: {
        errorMessage: localize("emailFormatWarning", "String is not an e-mail address."),
        pattern: /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
      },
      ipv4: {
        errorMessage: localize("ipv4FormatWarning", "String does not match IPv4 format."),
        pattern: /^((25[0-5]|(2[0-4]|1\d|[1-9]|)\d)\.?\b){4}$/
      },
      ipv6: {
        errorMessage: localize("ipv6FormatWarning", "String does not match IPv6 format."),
        pattern: /^([0-9a-f]|:){1,4}(:([0-9a-f]{0,4})*){1,7}$/i
      }
    };
    exports2.YAML_SOURCE = "YAML";
    var YAML_SCHEMA_PREFIX = "yaml-schema: ";
    var ProblemType;
    (function(ProblemType2) {
      ProblemType2["missingRequiredPropWarning"] = "missingRequiredPropWarning";
      ProblemType2["typeMismatchWarning"] = "typeMismatchWarning";
      ProblemType2["constWarning"] = "constWarning";
    })(ProblemType || (exports2.ProblemType = ProblemType = {}));
    exports2.ProblemTypeMessages = {
      [ProblemType.missingRequiredPropWarning]: 'Missing property "{0}".',
      [ProblemType.typeMismatchWarning]: 'Incorrect type. Expected "{0}".',
      [ProblemType.constWarning]: "Value must be {0}."
    };
    function asSchema(schema) {
      if ((0, objects_1.isBoolean)(schema)) {
        return schema ? {} : { not: {} };
      }
      if (typeof schema !== "object") {
        console.warn(`Wrong schema: ${JSON.stringify(schema)}, it MUST be an Object or Boolean`);
        schema = {
          type: schema
        };
      }
      return schema;
    }
    var EnumMatch;
    (function(EnumMatch2) {
      EnumMatch2[EnumMatch2["Key"] = 0] = "Key";
      EnumMatch2[EnumMatch2["Enum"] = 1] = "Enum";
    })(EnumMatch || (exports2.EnumMatch = EnumMatch = {}));
    var SchemaCollector = class _SchemaCollector {
      focusOffset;
      exclude;
      schemas = [];
      constructor(focusOffset = -1, exclude) {
        this.focusOffset = focusOffset;
        this.exclude = exclude;
      }
      add(schema) {
        this.schemas.push(schema);
      }
      merge(other) {
        this.schemas.push(...other.schemas);
      }
      include(node) {
        return (this.focusOffset === -1 || contains(node, this.focusOffset)) && node !== this.exclude;
      }
      newSub() {
        return new _SchemaCollector(-1, this.exclude);
      }
    };
    var NoOpSchemaCollector = class _NoOpSchemaCollector {
      constructor() {
      }
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      get schemas() {
        return [];
      }
      add() {
      }
      merge() {
      }
      include() {
        return true;
      }
      newSub() {
        return this;
      }
      static instance = new _NoOpSchemaCollector();
    };
    var ValidationResult = class {
      problems;
      propertiesMatches;
      propertiesValueMatches;
      primaryValueMatches;
      enumValueMatch;
      enumValues;
      constructor() {
        this.problems = [];
        this.propertiesMatches = 0;
        this.propertiesValueMatches = 0;
        this.primaryValueMatches = 0;
        this.enumValueMatch = false;
      }
      hasProblems() {
        return !!this.problems.length;
      }
      mergeAll(validationResults) {
        for (const validationResult of validationResults) {
          this.merge(validationResult);
        }
      }
      merge(validationResult) {
        this.problems = this.problems.concat(validationResult.problems);
      }
      mergeEnumValues(validationResult) {
        if (!this.enumValueMatch && !validationResult.enumValueMatch && this.enumValues && validationResult.enumValues) {
          this.enumValues = this.enumValues.concat(validationResult.enumValues);
          for (const error of this.problems) {
            if (error.code === vscode_json_languageservice_1.ErrorCode.EnumValueMismatch) {
              error.message = localize("enumWarning", "Value is not accepted. Valid values: {0}.", [...new Set(this.enumValues)].map((v) => {
                return JSON.stringify(v);
              }).join(", "));
            }
          }
        }
      }
      /**
       * Merge multiple warnings with same problemType together
       * @param subValidationResult another possible result
       */
      mergeWarningGeneric(subValidationResult, problemTypesToMerge) {
        if (!this.problems || this.problems.length === 0) {
          return;
        }
        for (const problemType of problemTypesToMerge) {
          const bestResults = this.problems.filter((p) => p.problemType === problemType);
          for (const bestResult of bestResults) {
            const mergingResult = subValidationResult.problems?.find(
              (p) => p.problemType === problemType && bestResult.location.offset === p.location.offset && (problemType !== ProblemType.missingRequiredPropWarning || (0, utils_1.isArrayEqual)(p.problemArgs, bestResult.problemArgs))
              // missingProp is merged only with same problemArg
            );
            if (mergingResult) {
              if (mergingResult.problemArgs?.length) {
                mergingResult.problemArgs.filter((p) => !bestResult.problemArgs?.includes(p)).forEach((p) => bestResult.problemArgs?.push(p));
                bestResult.message = getWarningMessage(bestResult.problemType, bestResult.problemArgs);
              }
              this.mergeSources(mergingResult, bestResult);
            }
          }
        }
      }
      mergePropertyMatch(propertyValidationResult) {
        this.merge(propertyValidationResult);
        this.propertiesMatches++;
        if (propertyValidationResult.enumValueMatch || !propertyValidationResult.hasProblems() && propertyValidationResult.propertiesMatches) {
          this.propertiesValueMatches++;
        }
        if (propertyValidationResult.enumValueMatch && propertyValidationResult.enumValues) {
          this.primaryValueMatches++;
        }
      }
      mergeSources(mergingResult, bestResult) {
        const mergingSource = mergingResult.source?.replace(YAML_SCHEMA_PREFIX, "");
        if (mergingSource && !bestResult.source?.includes(mergingSource)) {
          bestResult.source = bestResult.source + " | " + mergingSource;
        }
        if (bestResult.schemaUri?.length && mergingResult.schemaUri?.length) {
          if (!bestResult.schemaUri.includes(mergingResult.schemaUri[0])) {
            bestResult.schemaUri = bestResult.schemaUri.concat(mergingResult.schemaUri);
          }
        }
      }
      compareGeneric(other) {
        const hasProblems = this.hasProblems();
        if (hasProblems !== other.hasProblems()) {
          return hasProblems ? -1 : 1;
        }
        if (this.enumValueMatch !== other.enumValueMatch) {
          return other.enumValueMatch ? -1 : 1;
        }
        if (this.propertiesValueMatches !== other.propertiesValueMatches) {
          return this.propertiesValueMatches - other.propertiesValueMatches;
        }
        if (this.primaryValueMatches !== other.primaryValueMatches) {
          return this.primaryValueMatches - other.primaryValueMatches;
        }
        return this.propertiesMatches - other.propertiesMatches;
      }
    };
    exports2.ValidationResult = ValidationResult;
    function getNodeValue(node) {
      switch (node.type) {
        case "array":
          return node.children.map(getNodeValue);
        case "object": {
          const obj = /* @__PURE__ */ Object.create(null);
          for (let _i = 0, _a = node.children; _i < _a.length; _i++) {
            const prop = _a[_i];
            if (prop.children) {
              const valueNode = prop.children[1];
              if (valueNode) {
                obj[prop.children[0].value] = getNodeValue(valueNode);
              }
            }
          }
          return obj;
        }
        case "null":
        case "string":
        case "number":
        case "boolean":
          return node.value;
        default:
          return void 0;
      }
    }
    function contains(node, offset, includeRightBound = false) {
      return offset >= node.offset && offset <= node.offset + node.length || includeRightBound && offset === node.offset + node.length;
    }
    function findNodeAtOffset(node, offset, includeRightBound) {
      if (includeRightBound === void 0) {
        includeRightBound = false;
      }
      if (contains(node, offset, includeRightBound)) {
        const children = node.children;
        if (Array.isArray(children)) {
          for (let i = 0; i < children.length && children[i].offset <= offset; i++) {
            const item = findNodeAtOffset(children[i], offset, includeRightBound);
            if (item) {
              return item;
            }
          }
        }
        return node;
      }
      return void 0;
    }
    var YamlAstViewWithSchema = class _YamlAstViewWithSchema {
      yamlDocument;
      disableAdditionalProperties;
      uri;
      constructor(yamlDocument) {
        this.yamlDocument = yamlDocument;
      }
      updateFromInternalDocument() {
        this.yamlDocument.updateFromInternalDocument();
      }
      set currentDocIndex(i) {
        this.yamlDocument.currentDocIndex = i;
      }
      get currentDocIndex() {
        return this.yamlDocument.currentDocIndex;
      }
      set internalDocument(document2) {
        this.yamlDocument.internalDocument = document2;
      }
      get internalDocument() {
        return this.yamlDocument.internalDocument;
      }
      get lineComments() {
        return this.yamlDocument.lineComments;
      }
      set lineComments(val) {
        this.yamlDocument.lineComments = val;
      }
      get errors() {
        return this.yamlDocument.errors;
      }
      get warnings() {
        return this.yamlDocument.warnings;
      }
      clone() {
        const copy = new _YamlAstViewWithSchema(this.yamlDocument.clone());
        copy.disableAdditionalProperties = this.disableAdditionalProperties;
        copy.uri = this.uri;
        return copy;
      }
      get root() {
        return this.yamlDocument.root;
      }
      get syntaxErrors() {
        return this.yamlDocument.syntaxErrors;
      }
      get comments() {
        return this.yamlDocument.comments;
      }
      getNodeFromOffset(offset, includeRightBound = false) {
        return this.yamlDocument.getNodeFromOffset(offset, includeRightBound);
      }
      getNodeFromOffsetEndInclusive(offset) {
        return this.yamlDocument.getNodeFromOffsetEndInclusive(offset);
      }
      visit(visitor) {
        this.yamlDocument.visit(visitor);
      }
      /**
       * Query a child node through a json path like.
       *
       * Only a subset of json path features are supported.
       * <ul>
       *   <li>the dot notation to access a child by its key name;
       *   <li>the brackets notation to access a child by its position in an array.
       * </ul>
       * @param query the json path like query to follow
       * @returns an AstNode or undefined if the path leads to nowhere.
       */
      query(query, startingNode) {
        return this.yamlDocument.query(query, startingNode);
      }
      getNodeFromPosition(positionOffset, textBuffer, configuredIndentation) {
        return this.yamlDocument.getNodeFromPosition(positionOffset, textBuffer, configuredIndentation);
      }
      findClosestNode(offset, textBuffer, configuredIndentation) {
        return this.yamlDocument.findClosestNode(offset, textBuffer, configuredIndentation);
      }
      getParent(node) {
        return this.yamlDocument.getParent(node);
      }
      /**
       * Computes the path from the root to the current node in a json path like.
       *
       * Only a subset of json path features are supported.
       * <ul>
       *   <li>the dot notation to access a child by its key name;
       *   <li>the brackets notation to access a child by its position in an array.
       * </ul>
       * @param node the AstNode to reach from the root.
       * @returns a json path like value.
       * @throws an Error in case the computation fails.
       */
      toQuery(node) {
        return this.yamlDocument.toQuery(node);
      }
      validate(textDocument, schema) {
        const root = this.root;
        if (root && schema) {
          const validationResult = new ValidationResult();
          validate(root, schema, { schema, node: root }, validationResult, NoOpSchemaCollector.instance, {
            disableAdditionalProperties: this.disableAdditionalProperties,
            uri: this.uri
          });
          return validationResult.problems.map((p) => {
            const range = vscode_languageserver_types_1.Range.create(textDocument.positionAt(p.location.offset), textDocument.positionAt(p.location.offset + p.location.length));
            const diagnostic = vscode_languageserver_types_1.Diagnostic.create(range, p.message, p.severity, p.code ? p.code : vscode_json_languageservice_1.ErrorCode.Undefined, p.source);
            diagnostic.data = { schemaUri: p.schemaUri, ...p.data };
            return diagnostic;
          });
        }
        return [];
      }
      /**
       * This method returns the list of applicable schemas
       *
       * currently used @param didCallFromAutoComplete flag to differentiate the method call, when it is from auto complete
       * then user still types something and skip the validation for timebeing untill completed.
       * On https://github.com/redhat-developer/yaml-language-server/pull/719 the auto completes need to populate the list of enum string which matches to the enum
       * and on https://github.com/redhat-developer/vscode-yaml/issues/803 the validation should throw the error based on the enum string.
       *
       * @param schema schema
       * @param focusOffset  offsetValue
       * @param exclude excluded Node
       * @param didCallFromAutoComplete true if method called from AutoComplete
       * @returns array of applicable schemas
       */
      getMatchingSchemas(schema, focusOffset = -1, exclude, didCallFromAutoComplete) {
        const matchingSchemas = new SchemaCollector(focusOffset, exclude);
        const root = this.root;
        if (root && schema) {
          validate(root, schema, { schema, node: root }, new ValidationResult(), matchingSchemas, {
            disableAdditionalProperties: this.disableAdditionalProperties,
            uri: this.uri,
            callFromAutoComplete: didCallFromAutoComplete
          });
        }
        return matchingSchemas.schemas;
      }
    };
    exports2.YamlAstViewWithSchema = YamlAstViewWithSchema;
    function validate(node, schema, originalSchema, validationResult, matchingSchemas, options) {
      const { callFromAutoComplete } = options;
      if (!node) {
        return;
      }
      if (typeof schema !== "object") {
        return;
      }
      if (!schema.url) {
        schema.url = originalSchema.schema.url;
      }
      schema.closestTitle = schema.title || originalSchema.schema.closestTitle;
      switch (node.type) {
        case "object":
          _validateObjectNode(node, schema, validationResult, matchingSchemas);
          break;
        case "array":
          _validateArrayNode(node, schema, validationResult, matchingSchemas);
          break;
        case "string":
          _validateStringNode(node, schema, validationResult);
          break;
        case "number":
          _validateNumberNode(node, schema, validationResult);
          break;
        case "property": {
          if (node.valueNode) {
            return validate(node.valueNode, schema, {
              schema,
              node
            }, validationResult, matchingSchemas, options);
          }
        }
      }
      _validateNode();
      matchingSchemas.add({
        node,
        schema,
        parentSchema: originalSchema
      });
      function _validateNode() {
        function matchesType(type) {
          return node.type === type || type === "integer" && node.type === "number" && node.isInteger;
        }
        if (Array.isArray(schema.type)) {
          if (!schema.type.some(matchesType)) {
            validationResult.problems.push({
              location: { offset: node.offset, length: node.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: schema.errorMessage || localize("typeArrayMismatchWarning", "Incorrect type. Expected one of {0}.", schema.type.join(", ")),
              source: getSchemaSource(schema, originalSchema.schema),
              schemaUri: getSchemaUri(schema, originalSchema.schema)
            });
          }
        } else if (schema.type) {
          if (!matchesType(schema.type)) {
            const schemaType = schema.type === "object" ? (0, json_schema_1.getSchemaTypeName)(schema) : schema.type;
            validationResult.problems.push({
              location: { offset: node.offset, length: node.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: schema.errorMessage || getWarningMessage(ProblemType.typeMismatchWarning, [schemaType]),
              source: getSchemaSource(schema, originalSchema.schema),
              schemaUri: getSchemaUri(schema, originalSchema.schema),
              problemType: ProblemType.typeMismatchWarning,
              problemArgs: [schemaType]
            });
          }
        }
        if (Array.isArray(schema.allOf)) {
          for (const subSchemaRef of schema.allOf) {
            validate(node, asSchema(subSchemaRef), { schema, node }, validationResult, matchingSchemas, options);
          }
        }
        if (schema.not) {
          const notSchema = asSchema(schema.not);
          const subValidationResult = new ValidationResult();
          const subMatchingSchemas = matchingSchemas.newSub();
          validate(node, notSchema, { schema, node }, subValidationResult, subMatchingSchemas, options);
          if (!subValidationResult.hasProblems()) {
            validationResult.problems.push({
              location: { offset: node.offset, length: node.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: localize("notSchemaWarning", "Matches a schema that is not allowed."),
              source: getSchemaSource(schema, originalSchema.schema),
              schemaUri: getSchemaUri(schema, originalSchema.schema)
            });
          }
          for (const ms of subMatchingSchemas.schemas) {
            ms.inverted = !ms.inverted;
            matchingSchemas.add(ms);
          }
        }
        const testAlternatives = (alternatives, maxOneMatch) => {
          const matches = [];
          const subMatches = [];
          const noPropertyMatches = [];
          let bestMatch;
          for (const subSchemaRef of alternatives) {
            const subSchema = { ...asSchema(subSchemaRef) };
            const subValidationResult = new ValidationResult();
            const subMatchingSchemas = matchingSchemas.newSub();
            validate(node, subSchema, { schema, node }, subValidationResult, subMatchingSchemas, options);
            if (!subValidationResult.hasProblems() || callFromAutoComplete) {
              matches.push(subSchema);
              subMatches.push(subSchema);
              if (subValidationResult.propertiesMatches === 0) {
                noPropertyMatches.push(subSchema);
              }
              if (subSchema.format) {
                subMatches.pop();
              }
            }
            if (!bestMatch) {
              bestMatch = {
                schema: subSchema,
                validationResult: subValidationResult,
                matchingSchemas: subMatchingSchemas
              };
            } else {
              bestMatch = genericComparison(node, maxOneMatch, subValidationResult, bestMatch, subSchema, subMatchingSchemas);
            }
          }
          if (subMatches.length > 1 && (subMatches.length > 1 || noPropertyMatches.length === 0) && maxOneMatch) {
            validationResult.problems.push({
              location: { offset: node.offset, length: 1 },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: localize("oneOfWarning", "Matches multiple schemas when only one must validate."),
              source: getSchemaSource(schema, originalSchema.schema),
              schemaUri: getSchemaUri(schema, originalSchema.schema)
            });
          }
          if (bestMatch) {
            validationResult.merge(bestMatch.validationResult);
            validationResult.propertiesMatches += bestMatch.validationResult.propertiesMatches;
            validationResult.propertiesValueMatches += bestMatch.validationResult.propertiesValueMatches;
            validationResult.enumValueMatch = validationResult.enumValueMatch || bestMatch.validationResult.enumValueMatch;
            if (bestMatch.validationResult.enumValues?.length) {
              validationResult.enumValues = (validationResult.enumValues || []).concat(bestMatch.validationResult.enumValues);
            }
            matchingSchemas.merge(bestMatch.matchingSchemas);
          }
          return matches.length;
        };
        if (Array.isArray(schema.anyOf)) {
          testAlternatives(schema.anyOf, false);
        }
        if (Array.isArray(schema.oneOf)) {
          testAlternatives(schema.oneOf, true);
        }
        const testBranch = (schema2, originalSchema2) => {
          const subValidationResult = new ValidationResult();
          const subMatchingSchemas = matchingSchemas.newSub();
          validate(node, asSchema(schema2), { schema: originalSchema2, node }, subValidationResult, subMatchingSchemas, options);
          validationResult.merge(subValidationResult);
          validationResult.propertiesMatches += subValidationResult.propertiesMatches;
          validationResult.propertiesValueMatches += subValidationResult.propertiesValueMatches;
          matchingSchemas.merge(subMatchingSchemas);
        };
        const testCondition = (ifSchema, originalSchema2, thenSchema, elseSchema) => {
          const subSchema = asSchema(ifSchema);
          const subValidationResult = new ValidationResult();
          const subMatchingSchemas = matchingSchemas.newSub();
          validate(node, subSchema, { schema: originalSchema2, node }, subValidationResult, subMatchingSchemas, options);
          matchingSchemas.merge(subMatchingSchemas);
          const { filePatternAssociation } = subSchema;
          if (filePatternAssociation) {
            const association = new file_pattern_association_1.FilePatternAssociation(filePatternAssociation);
            if (options.uri && !association.matchesPattern(options.uri)) {
              subValidationResult.problems.push({
                location: { offset: node.offset, length: node.length },
                severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                message: localize("ifFilePatternAssociation", `filePatternAssociation '${filePatternAssociation}' does not match with doc uri '${options.uri}'.`),
                source: getSchemaSource(schema, originalSchema2),
                schemaUri: getSchemaUri(schema, originalSchema2)
              });
            }
          }
          if (!subValidationResult.hasProblems()) {
            if (thenSchema) {
              testBranch(asSchema(thenSchema), originalSchema2);
            }
          } else if (elseSchema) {
            testBranch(asSchema(elseSchema), originalSchema2);
          }
        };
        if (schema.if) {
          const ifSchema = asSchema(schema.if);
          testCondition(ifSchema, schema, schema.then, schema.else);
        }
        if (Array.isArray(schema.enum)) {
          const val = getNodeValue(node);
          let enumValueMatch = false;
          for (const e of schema.enum) {
            if ((0, objects_1.equals)(val, e) || callFromAutoComplete && (0, objects_1.isString)(val) && (0, objects_1.isString)(e) && val && e.startsWith(val)) {
              enumValueMatch = true;
              break;
            }
          }
          validationResult.enumValues = schema.enum;
          validationResult.enumValueMatch = enumValueMatch;
          if (!enumValueMatch) {
            validationResult.problems.push({
              location: { offset: node.offset, length: node.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              code: vscode_json_languageservice_1.ErrorCode.EnumValueMismatch,
              message: schema.errorMessage || localize("enumWarning", "Value is not accepted. Valid values: {0}.", schema.enum.map((v) => {
                return JSON.stringify(v);
              }).join(", ")),
              source: getSchemaSource(schema, originalSchema.schema),
              schemaUri: getSchemaUri(schema, originalSchema.schema)
            });
          }
        }
        if ((0, objects_1.isDefined)(schema.const)) {
          const val = getNodeValue(node);
          if (!(0, objects_1.equals)(val, schema.const) && !(callFromAutoComplete && (0, objects_1.isString)(val) && (0, objects_1.isString)(schema.const) && schema.const.startsWith(val))) {
            validationResult.problems.push({
              location: { offset: node.offset, length: node.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              code: vscode_json_languageservice_1.ErrorCode.EnumValueMismatch,
              problemType: ProblemType.constWarning,
              message: schema.errorMessage || getWarningMessage(ProblemType.constWarning, [
                JSON.stringify(schema.const)
              ]),
              source: getSchemaSource(schema, originalSchema.schema),
              schemaUri: getSchemaUri(schema, originalSchema.schema),
              problemArgs: [JSON.stringify(schema.const)]
            });
            validationResult.enumValueMatch = false;
          } else {
            validationResult.enumValueMatch = true;
          }
          validationResult.enumValues = [schema.const];
        }
        if (schema.deprecationMessage && node.parent) {
          validationResult.problems.push({
            location: { offset: node.parent.offset, length: node.parent.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: schema.deprecationMessage,
            source: getSchemaSource(schema, originalSchema.schema),
            schemaUri: getSchemaUri(schema, originalSchema.schema)
          });
        }
      }
      function _validateNumberNode(node2, schema2, validationResult2) {
        const val = node2.value;
        if ((0, objects_1.isNumber)(schema2.multipleOf)) {
          if (val % schema2.multipleOf !== 0) {
            validationResult2.problems.push({
              location: { offset: node2.offset, length: node2.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: localize("multipleOfWarning", "Value is not divisible by {0}.", schema2.multipleOf),
              source: getSchemaSource(schema2, originalSchema.schema),
              schemaUri: getSchemaUri(schema2, originalSchema.schema)
            });
          }
        }
        function getExclusiveLimit(limit, exclusive) {
          if ((0, objects_1.isNumber)(exclusive)) {
            return exclusive;
          }
          if ((0, objects_1.isBoolean)(exclusive) && exclusive) {
            return limit;
          }
          return void 0;
        }
        function getLimit(limit, exclusive) {
          if (!(0, objects_1.isBoolean)(exclusive) || !exclusive) {
            return limit;
          }
          return void 0;
        }
        const exclusiveMinimum = getExclusiveLimit(schema2.minimum, schema2.exclusiveMinimum);
        if ((0, objects_1.isNumber)(exclusiveMinimum) && val <= exclusiveMinimum) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("exclusiveMinimumWarning", "Value is below the exclusive minimum of {0}.", exclusiveMinimum),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
        const exclusiveMaximum = getExclusiveLimit(schema2.maximum, schema2.exclusiveMaximum);
        if ((0, objects_1.isNumber)(exclusiveMaximum) && val >= exclusiveMaximum) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("exclusiveMaximumWarning", "Value is above the exclusive maximum of {0}.", exclusiveMaximum),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
        const minimum = getLimit(schema2.minimum, schema2.exclusiveMinimum);
        if ((0, objects_1.isNumber)(minimum) && val < minimum) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("minimumWarning", "Value is below the minimum of {0}.", minimum),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
        const maximum = getLimit(schema2.maximum, schema2.exclusiveMaximum);
        if ((0, objects_1.isNumber)(maximum) && val > maximum) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("maximumWarning", "Value is above the maximum of {0}.", maximum),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
      }
      function _validateStringNode(node2, schema2, validationResult2) {
        if ((0, objects_1.isNumber)(schema2.minLength) && node2.value.length < schema2.minLength) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("minLengthWarning", "String is shorter than the minimum length of {0}.", schema2.minLength),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
        if ((0, objects_1.isNumber)(schema2.maxLength) && node2.value.length > schema2.maxLength) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("maxLengthWarning", "String is longer than the maximum length of {0}.", schema2.maxLength),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
        if ((0, objects_1.isString)(schema2.pattern)) {
          const regex = (0, strings_1.safeCreateUnicodeRegExp)(schema2.pattern);
          if (!regex.test(node2.value)) {
            validationResult2.problems.push({
              location: { offset: node2.offset, length: node2.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: schema2.patternErrorMessage || schema2.errorMessage || localize("patternWarning", 'String does not match the pattern of "{0}".', schema2.pattern),
              source: getSchemaSource(schema2, originalSchema.schema),
              schemaUri: getSchemaUri(schema2, originalSchema.schema)
            });
          }
        }
        if (schema2.format) {
          switch (schema2.format) {
            case "uri":
            case "uri-reference":
              {
                let errorMessage;
                if (!node2.value) {
                  errorMessage = localize("uriEmpty", "URI expected.");
                } else {
                  try {
                    const uri = vscode_uri_1.URI.parse(node2.value);
                    if (!uri.scheme && schema2.format === "uri") {
                      errorMessage = localize("uriSchemeMissing", "URI with a scheme is expected.");
                    }
                  } catch (e) {
                    errorMessage = typeof e === "object" && !!e && "message" in e && typeof e.message === "string" ? e.message : void 0;
                  }
                }
                if (errorMessage) {
                  validationResult2.problems.push({
                    location: { offset: node2.offset, length: node2.length },
                    severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                    message: schema2.patternErrorMessage || schema2.errorMessage || localize("uriFormatWarning", "String is not a URI: {0}", errorMessage),
                    source: getSchemaSource(schema2, originalSchema.schema),
                    schemaUri: getSchemaUri(schema2, originalSchema.schema)
                  });
                }
              }
              break;
            case "color-hex":
            case "date-time":
            case "date":
            case "time":
            case "email":
            case "ipv4":
            case "ipv6":
              {
                const format = exports2.formats[schema2.format];
                if (!node2.value || !format.pattern.test(node2.value)) {
                  validationResult2.problems.push({
                    location: { offset: node2.offset, length: node2.length },
                    severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                    message: schema2.patternErrorMessage || schema2.errorMessage || format.errorMessage,
                    source: getSchemaSource(schema2, originalSchema.schema),
                    schemaUri: getSchemaUri(schema2, originalSchema.schema)
                  });
                }
              }
              break;
            default:
          }
        }
      }
      function _validateArrayNode(node2, schema2, validationResult2, matchingSchemas2) {
        if (Array.isArray(schema2.items)) {
          const subSchemas = schema2.items;
          for (let index = 0; index < subSchemas.length; index++) {
            const subSchemaRef = subSchemas[index];
            const subSchema = asSchema(subSchemaRef);
            const itemValidationResult = new ValidationResult();
            const item = node2.items[index];
            if (item) {
              validate(item, subSchema, { schema: schema2, node: node2 }, itemValidationResult, matchingSchemas2, options);
              validationResult2.mergePropertyMatch(itemValidationResult);
              validationResult2.mergeEnumValues(itemValidationResult);
            } else if (node2.items.length >= subSchemas.length) {
              validationResult2.propertiesValueMatches++;
            }
          }
          if (node2.items.length > subSchemas.length) {
            if (typeof schema2.additionalItems === "object") {
              for (let i = subSchemas.length; i < node2.items.length; i++) {
                const itemValidationResult = new ValidationResult();
                validate(
                  node2.items[i],
                  // eslint-disable-next-line @typescript-eslint/no-explicit-any
                  schema2.additionalItems,
                  { schema: schema2, node: node2 },
                  itemValidationResult,
                  matchingSchemas2,
                  options
                );
                validationResult2.mergePropertyMatch(itemValidationResult);
                validationResult2.mergeEnumValues(itemValidationResult);
              }
            } else if (schema2.additionalItems === false) {
              validationResult2.problems.push({
                location: { offset: node2.offset, length: node2.length },
                severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                message: localize("additionalItemsWarning", "Array has too many items according to schema. Expected {0} or fewer.", subSchemas.length),
                source: getSchemaSource(schema2, originalSchema.schema),
                schemaUri: getSchemaUri(schema2, originalSchema.schema)
              });
            }
          }
        } else if (schema2.items) {
          const itemSchema = asSchema(schema2.items);
          const itemValidationResult = new ValidationResult();
          node2.items.forEach((item) => {
            if (itemSchema.oneOf && itemSchema.oneOf.length === 1) {
              const subSchemaRef = itemSchema.oneOf[0];
              const subSchema = { ...asSchema(subSchemaRef) };
              subSchema.title = schema2.title;
              subSchema.closestTitle = schema2.closestTitle;
              validate(item, subSchema, { schema: schema2, node: node2 }, itemValidationResult, matchingSchemas2, options);
              validationResult2.mergePropertyMatch(itemValidationResult);
              validationResult2.mergeEnumValues(itemValidationResult);
            } else {
              validate(item, itemSchema, { schema: schema2, node: node2 }, itemValidationResult, matchingSchemas2, options);
              validationResult2.mergePropertyMatch(itemValidationResult);
              validationResult2.mergeEnumValues(itemValidationResult);
            }
          });
        }
        if (schema2.contains && "items" in node2) {
          const containsSchema = asSchema(schema2.contains);
          const doesContain = node2.items.some((item) => {
            const itemValidationResult = new ValidationResult();
            validate(item, containsSchema, { schema: schema2, node: node2 }, itemValidationResult, NoOpSchemaCollector.instance, options);
            return !itemValidationResult.hasProblems();
          });
          if (!doesContain) {
            validationResult2.problems.push({
              location: { offset: node2.offset, length: node2.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: schema2.errorMessage || localize("requiredItemMissingWarning", "Array does not contain required item."),
              source: getSchemaSource(schema2, originalSchema.schema),
              schemaUri: getSchemaUri(schema2, originalSchema.schema)
            });
          }
        }
        if ((0, objects_1.isNumber)(schema2.minItems) && "items" in node2 && node2.items.length < schema2.minItems) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("minItemsWarning", "Array has too few items. Expected {0} or more.", schema2.minItems),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
        if ((0, objects_1.isNumber)(schema2.maxItems) && "items" in node2 && node2.items.length > schema2.maxItems) {
          validationResult2.problems.push({
            location: { offset: node2.offset, length: node2.length },
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            message: localize("maxItemsWarning", "Array has too many items. Expected {0} or fewer.", schema2.maxItems),
            source: getSchemaSource(schema2, originalSchema.schema),
            schemaUri: getSchemaUri(schema2, originalSchema.schema)
          });
        }
        if (schema2.uniqueItems === true) {
          const values = getNodeValue(node2);
          if (Array.isArray(values)) {
            const duplicates = values.some((value, index) => {
              return index !== values.lastIndexOf(value);
            });
            if (duplicates) {
              validationResult2.problems.push({
                location: { offset: node2.offset, length: node2.length },
                severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                message: localize("uniqueItemsWarning", "Array has duplicate items."),
                source: getSchemaSource(schema2, originalSchema.schema),
                schemaUri: getSchemaUri(schema2, originalSchema.schema)
              });
            }
          }
        }
      }
      function _validateObjectNode(node2, schema2, validationResult2, matchingSchemas2) {
        const seenKeys = /* @__PURE__ */ Object.create(null);
        const unprocessedProperties = [];
        const unprocessedNodes = [...node2.properties];
        let propertyNode = unprocessedNodes.pop();
        while (propertyNode) {
          const key = propertyNode.keyNode.value;
          if (key === "<<" && propertyNode.valueNode) {
            switch (propertyNode.valueNode.type) {
              case "object": {
                unprocessedNodes.push(...propertyNode.valueNode["properties"]);
                break;
              }
              case "array": {
                propertyNode.valueNode["items"].forEach((sequenceNode) => {
                  if (sequenceNode && "properties" in sequenceNode) {
                    unprocessedNodes.push(...sequenceNode["properties"]);
                  }
                });
                break;
              }
              default: {
                break;
              }
            }
          } else {
            seenKeys[key] = propertyNode.valueNode;
            unprocessedProperties.push(key);
          }
          propertyNode = unprocessedNodes.pop();
        }
        if (Array.isArray(schema2.required)) {
          for (const propertyName of schema2.required) {
            if (seenKeys[propertyName] === void 0) {
              const keyNode = node2.parent && node2.parent.type === "property" && node2.parent.keyNode;
              const location = keyNode ? { offset: keyNode.offset, length: keyNode.length } : { offset: node2.offset, length: 1 };
              validationResult2.problems.push({
                location,
                severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                message: getWarningMessage(ProblemType.missingRequiredPropWarning, [
                  propertyName
                ]),
                source: getSchemaSource(schema2, originalSchema.schema),
                schemaUri: getSchemaUri(schema2, originalSchema.schema),
                problemArgs: [propertyName],
                problemType: ProblemType.missingRequiredPropWarning
              });
            }
          }
        }
        const propertyProcessed = (prop) => {
          let index = unprocessedProperties.indexOf(prop);
          while (index >= 0) {
            unprocessedProperties.splice(index, 1);
            index = unprocessedProperties.indexOf(prop);
          }
        };
        if (schema2.properties) {
          for (const propertyName of Object.keys(schema2.properties)) {
            propertyProcessed(propertyName);
            const propertySchema = schema2.properties[propertyName];
            const child = seenKeys[propertyName];
            if (child) {
              if ((0, objects_1.isBoolean)(propertySchema)) {
                if (!propertySchema) {
                  const propertyNode2 = child.parent;
                  validationResult2.problems.push({
                    location: {
                      offset: propertyNode2.keyNode.offset,
                      length: propertyNode2.keyNode.length
                    },
                    severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                    message: schema2.errorMessage || localize("DisallowedExtraPropWarning", MSG_PROPERTY_NOT_ALLOWED, propertyName),
                    source: getSchemaSource(schema2, originalSchema.schema),
                    schemaUri: getSchemaUri(schema2, originalSchema.schema)
                  });
                } else {
                  validationResult2.propertiesMatches++;
                  validationResult2.propertiesValueMatches++;
                }
              } else {
                propertySchema.url = schema2.url ?? originalSchema.schema.url;
                const propertyValidationResult = new ValidationResult();
                validate(child, propertySchema, { schema: schema2, node: node2 }, propertyValidationResult, matchingSchemas2, options);
                validationResult2.mergePropertyMatch(propertyValidationResult);
                validationResult2.mergeEnumValues(propertyValidationResult);
              }
            }
          }
        }
        if (schema2.patternProperties) {
          for (const propertyPattern of Object.keys(schema2.patternProperties)) {
            const regex = (0, strings_1.safeCreateUnicodeRegExp)(propertyPattern);
            for (const propertyName of unprocessedProperties.slice(0)) {
              if (regex.test(propertyName)) {
                propertyProcessed(propertyName);
                const child = seenKeys[propertyName];
                if (child) {
                  const propertySchema = schema2.patternProperties[propertyPattern];
                  if ((0, objects_1.isBoolean)(propertySchema)) {
                    if (!propertySchema) {
                      const propertyNode2 = child.parent;
                      validationResult2.problems.push({
                        location: {
                          offset: propertyNode2.keyNode.offset,
                          length: propertyNode2.keyNode.length
                        },
                        severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                        message: schema2.errorMessage || localize("DisallowedExtraPropWarning", MSG_PROPERTY_NOT_ALLOWED, propertyName),
                        source: getSchemaSource(schema2, originalSchema.schema),
                        schemaUri: getSchemaUri(schema2, originalSchema.schema)
                      });
                    } else {
                      validationResult2.propertiesMatches++;
                      validationResult2.propertiesValueMatches++;
                    }
                  } else {
                    const propertyValidationResult = new ValidationResult();
                    validate(child, propertySchema, { schema: schema2, node: node2 }, propertyValidationResult, matchingSchemas2, options);
                    validationResult2.mergePropertyMatch(propertyValidationResult);
                    validationResult2.mergeEnumValues(propertyValidationResult);
                  }
                }
              }
            }
          }
        }
        if (typeof schema2.additionalProperties === "object") {
          for (const propertyName of unprocessedProperties) {
            const child = seenKeys[propertyName];
            if (child) {
              const propertyValidationResult = new ValidationResult();
              validate(child, schema2.additionalProperties, { schema: schema2, node: node2 }, propertyValidationResult, matchingSchemas2, options);
              validationResult2.mergePropertyMatch(propertyValidationResult);
              validationResult2.mergeEnumValues(propertyValidationResult);
            }
          }
        } else if (schema2.additionalProperties === false || schema2.type === "object" && schema2.additionalProperties === void 0 && options.disableAdditionalProperties === true) {
          if (unprocessedProperties.length > 0) {
            const possibleProperties = schema2.properties && Object.keys(schema2.properties).filter((prop) => !seenKeys[prop]);
            for (const propertyName of unprocessedProperties) {
              const child = seenKeys[propertyName];
              if (child) {
                let propertyNode2 = null;
                if (child.type !== "property") {
                  propertyNode2 = child.parent?.type === "object" ? child.parent.properties[0] : child.parent;
                } else {
                  propertyNode2 = child;
                }
                const problem = {
                  location: {
                    offset: propertyNode2.keyNode.offset,
                    length: propertyNode2.keyNode.length
                  },
                  severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                  message: schema2.errorMessage || localize("DisallowedExtraPropWarning", MSG_PROPERTY_NOT_ALLOWED, propertyName),
                  source: getSchemaSource(schema2, originalSchema.schema),
                  schemaUri: getSchemaUri(schema2, originalSchema.schema)
                };
                if (possibleProperties?.length) {
                  problem.data = { properties: possibleProperties };
                }
                validationResult2.problems.push(problem);
              }
            }
          }
        }
        if ((0, objects_1.isNumber)(schema2.maxProperties)) {
          if (node2.properties.length > schema2.maxProperties) {
            validationResult2.problems.push({
              location: { offset: node2.offset, length: node2.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: localize("MaxPropWarning", "Object has more properties than limit of {0}.", schema2.maxProperties),
              source: getSchemaSource(schema2, originalSchema.schema),
              schemaUri: getSchemaUri(schema2, originalSchema.schema)
            });
          }
        }
        if ((0, objects_1.isNumber)(schema2.minProperties)) {
          if (node2.properties.length < schema2.minProperties) {
            validationResult2.problems.push({
              location: { offset: node2.offset, length: node2.length },
              severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
              message: localize("MinPropWarning", "Object has fewer properties than the required number of {0}", schema2.minProperties),
              source: getSchemaSource(schema2, originalSchema.schema),
              schemaUri: getSchemaUri(schema2, originalSchema.schema)
            });
          }
        }
        if (schema2.dependencies) {
          for (const key of Object.keys(schema2.dependencies)) {
            const prop = seenKeys[key];
            if (prop) {
              const propertyDep = schema2.dependencies[key];
              if (Array.isArray(propertyDep)) {
                for (const requiredProp of propertyDep) {
                  if (!seenKeys[requiredProp]) {
                    validationResult2.problems.push({
                      location: { offset: node2.offset, length: node2.length },
                      severity: vscode_languageserver_types_1.DiagnosticSeverity.Warning,
                      message: localize("RequiredDependentPropWarning", "Object is missing property {0} required by property {1}.", requiredProp, key),
                      source: getSchemaSource(schema2, originalSchema.schema),
                      schemaUri: getSchemaUri(schema2, originalSchema.schema)
                    });
                  } else {
                    validationResult2.propertiesValueMatches++;
                  }
                }
              } else {
                const propertySchema = asSchema(propertyDep);
                if (propertySchema) {
                  const propertyValidationResult = new ValidationResult();
                  validate(node2, propertySchema, { schema: schema2, node: node2 }, propertyValidationResult, matchingSchemas2, options);
                  validationResult2.mergePropertyMatch(propertyValidationResult);
                  validationResult2.mergeEnumValues(propertyValidationResult);
                }
              }
            }
          }
        }
        if (schema2.propertyNames) {
          const propertyNames = asSchema(schema2.propertyNames);
          for (const f of node2.properties) {
            const key = f.keyNode;
            if (key) {
              validate(key, propertyNames, { schema: schema2, node: node2 }, validationResult2, NoOpSchemaCollector.instance, options);
            }
          }
        }
      }
      function genericComparison(node2, maxOneMatch, subValidationResult, bestMatch, subSchema, subMatchingSchemas) {
        if (!maxOneMatch && !subValidationResult.hasProblems() && (!bestMatch.validationResult.hasProblems() || callFromAutoComplete)) {
          bestMatch.matchingSchemas.merge(subMatchingSchemas);
          bestMatch.validationResult.propertiesMatches += subValidationResult.propertiesMatches;
          bestMatch.validationResult.propertiesValueMatches += subValidationResult.propertiesValueMatches;
        } else {
          const compareResult = subValidationResult.compareGeneric(bestMatch.validationResult);
          if (compareResult > 0 || compareResult === 0 && maxOneMatch && bestMatch.schema.type === "object" && node2.type !== "null" && node2.type !== bestMatch.schema.type) {
            bestMatch = {
              schema: subSchema,
              validationResult: subValidationResult,
              matchingSchemas: subMatchingSchemas
            };
          } else if (compareResult === 0) {
            bestMatch.matchingSchemas.merge(subMatchingSchemas);
            bestMatch.validationResult.mergeEnumValues(subValidationResult);
            bestMatch.validationResult.mergeWarningGeneric(subValidationResult, [
              ProblemType.missingRequiredPropWarning,
              ProblemType.typeMismatchWarning,
              ProblemType.constWarning
            ]);
          }
        }
        return bestMatch;
      }
    }
    function getSchemaSource(schema, originalSchema) {
      if (schema) {
        let label;
        if (schema.title) {
          label = schema.title;
        } else if (schema.closestTitle) {
          label = schema.closestTitle;
        } else if (originalSchema.closestTitle) {
          label = originalSchema.closestTitle;
        } else {
          const uriString = schema.url ?? originalSchema.url;
          if (uriString) {
            const url = vscode_uri_1.URI.parse(uriString);
            if (url.scheme === "file") {
              label = url.fsPath;
            }
            label = url.toString();
          }
        }
        if (label) {
          return `${YAML_SCHEMA_PREFIX}${label}`;
        }
      }
      return exports2.YAML_SOURCE;
    }
    function getSchemaUri(schema, originalSchema) {
      const uriString = schema.url ?? originalSchema.url;
      return uriString ? [uriString] : [];
    }
    function getWarningMessage(problemType, args) {
      return localize(problemType, exports2.ProblemTypeMessages[problemType], args?.join(" | "));
    }
  }
});

// ../../packages/seml-parser/out/src/languageservice/schema/index.js
var require_schema = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/schema/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.YamlAstViewWithSchema = exports2.asSchema = exports2.createSchemaQueryService = exports2.modelineService = void 0;
    __exportStar2(require_json_schema(), exports2);
    __exportStar2(require_modeline_service(), exports2);
    var modeline_service_impl_1 = require_modeline_service_impl();
    Object.defineProperty(exports2, "modelineService", { enumerable: true, get: function() {
      return modeline_service_impl_1.modelineService;
    } });
    __exportStar2(require_schema_priority(), exports2);
    __exportStar2(require_schema_query_service(), exports2);
    var schema_query_service_impl_1 = require_schema_query_service_impl();
    Object.defineProperty(exports2, "createSchemaQueryService", { enumerable: true, get: function() {
      return schema_query_service_impl_1.createSchemaQueryService;
    } });
    __exportStar2(require_schema_request_service(), exports2);
    __exportStar2(require_schema_services_provider(), exports2);
    __exportStar2(require_schema_store_actions(), exports2);
    __exportStar2(require_schema_store_service(), exports2);
    __exportStar2(require_schema_validation_service(), exports2);
    var yaml_ast_with_schema_impl_1 = require_yaml_ast_with_schema_impl();
    Object.defineProperty(exports2, "asSchema", { enumerable: true, get: function() {
      return yaml_ast_with_schema_impl_1.asSchema;
    } });
    Object.defineProperty(exports2, "YamlAstViewWithSchema", { enumerable: true, get: function() {
      return yaml_ast_with_schema_impl_1.YamlAstViewWithSchema;
    } });
  }
});

// ../../packages/seml-parser/out/src/languageservice/index.js
var require_languageservice = __commonJS({
  "../../packages/seml-parser/out/src/languageservice/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar2(require_editor(), exports2);
    __exportStar2(require_parser(), exports2);
    __exportStar2(require_utils(), exports2);
    __exportStar2(require_ast(), exports2);
    __exportStar2(require_schema(), exports2);
  }
});

// ../../packages/seml-parser/out/src/path/api.js
var require_api = __commonJS({
  "../../packages/seml-parser/out/src/path/api.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-parser/out/src/path/node-impl.js
var require_node_impl = __commonJS({
  "../../packages/seml-parser/out/src/path/node-impl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createNodePath = createNodePath;
    var NodePath = class {
      delegate;
      sep;
      constructor(delegate) {
        this.delegate = delegate;
        this.sep = this.delegate.sep;
      }
      dirname(path4) {
        return this.delegate.dirname(path4);
      }
      basename(path4, suffix) {
        return this.delegate.basename(path4, suffix);
      }
      extname(path4) {
        return this.delegate.extname(path4);
      }
      join(...paths) {
        return this.delegate.join(...paths);
      }
      normalize(path4) {
        return this.delegate.normalize(path4);
      }
      parse(path4) {
        return this.delegate.parse(path4);
      }
      relative(from, to) {
        return this.delegate.relative(from, to);
      }
    };
    function createNodePath(delegate) {
      return new NodePath(delegate);
    }
  }
});

// ../../packages/seml-parser/out/src/path/web-impl.js
var require_web_impl = __commonJS({
  "../../packages/seml-parser/out/src/path/web-impl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createWebPath = createWebPath;
    var WebPath = class {
      parser;
      sep = "/";
      multipleSep = new RegExp(`${this.sep}+`);
      // TODO need to check what is the root for Windows URL in web mode...
      root = "/";
      constructor(parser) {
        this.parser = parser;
      }
      dirname(path4) {
        const pathname = this.doParseAndNormalize(path4);
        return this.computeDirname(pathname);
      }
      basename(path4, suffix) {
        const pathname = this.doParseAndNormalize(path4);
        const basename = this.computeBasename(pathname);
        if (suffix === void 0 || suffix.length === 0) {
          return basename;
        }
        if (basename.endsWith(suffix)) {
          return basename.substring(0, basename.length - suffix.length);
        }
        return basename;
      }
      extname(path4) {
        const basename = this.basename(path4);
        const indexOfDot = basename.lastIndexOf(".");
        if (indexOfDot <= 0) {
          return "";
        }
        return basename.substring(indexOfDot);
      }
      join(...paths) {
        return this.doHeavyNormalize(paths.join(this.sep));
      }
      normalize(path4) {
        return this.doParseAndNormalize(path4);
      }
      parse(path4) {
        const pathname = this.doParseAndNormalize(path4);
        const dir = this.computeDirname(pathname);
        const name = pathname.substring(dir.length + 1);
        return {
          dir,
          name
        };
      }
      relative(from, to) {
        const fmPath = this.doParseAndNormalize(from);
        const toPath = this.doParseAndNormalize(to);
        if (fmPath.length === toPath.length && fmPath === toPath) {
          return "";
        }
        if (fmPath.length === toPath.length - 1 && fmPath === `${toPath}/`) {
          return "";
        }
        if (toPath.length === fmPath.length - 1 && `${fmPath}/` === toPath) {
          return "";
        }
        if (fmPath.charAt(0) === "/" && toPath.charAt(0) === "/") {
          return this.doRelative(fmPath, toPath);
        } else if (fmPath.charAt(0) !== "/" && toPath.charAt(0) !== "/") {
          return this.doRelative(fmPath, toPath);
        } else {
          console.error(`unsupported operation: WebPath.relative(${from}, ${to})`);
          return toPath;
        }
      }
      doRelative(from, to) {
        const fmSeg = from.split(this.sep).filter((s) => s.length > 0);
        const toSeg = to.split(this.sep).filter((s) => s.length > 0);
        const segments = [];
        for (let i = 0; i < fmSeg.length; ++i) {
          if (fmSeg[i] !== toSeg[i]) {
            for (let j = i; j < fmSeg.length; ++j) {
              segments.push("..");
            }
            for (let j = i; j < toSeg.length; ++j) {
              const segment = toSeg[j];
              if (segment) {
                segments.push(segment);
              }
            }
            return segments.join("/");
          }
        }
        return toSeg.slice(fmSeg.length).join("/");
      }
      findLastSep(path4) {
        if (!path4.length) {
          return -1;
        }
        const lastIndex = path4.length - 1;
        const from = path4.at(lastIndex) === this.sep ? lastIndex - 1 : lastIndex;
        return path4.lastIndexOf(this.sep, from);
      }
      computeDirname(path4) {
        const lastSep = this.findLastSep(path4);
        if (lastSep < 1) {
          return this.root;
        }
        return path4.substring(0, lastSep);
      }
      computeBasename(path4) {
        if (path4 === this.root) {
          return "";
        }
        const lastSep = this.findLastSep(path4);
        const end = path4.at(-1) === this.sep ? path4.length - 1 : path4.length;
        return path4.substring(lastSep + 1, end);
      }
      doNormalize(raw) {
        const segments = raw.split(this.sep).filter((s) => s.length > 0);
        if (segments.length > 0) {
          const joined = this.root + segments.join(this.sep);
          return joined + this.sep;
        }
        return this.root;
      }
      doHeavyNormalize(raw) {
        if (raw.length === 0) {
          return ".";
        }
        const initialSegments = raw.split(this.sep).filter((s) => s.length > 0);
        const segments = [];
        let ditchParent = 0;
        for (let i = initialSegments.length - 1; i >= 0; --i) {
          const currentSegment = initialSegments[i];
          if (currentSegment === void 0) {
            continue;
          }
          if (currentSegment === this.sep || currentSegment === ".") {
            continue;
          }
          if (currentSegment === "..") {
            ++ditchParent;
            continue;
          }
          if (ditchParent > 0) {
            --ditchParent;
            continue;
          }
          segments.push(currentSegment);
        }
        const head = raw.length > 0 && raw.at(0) === this.sep ? this.sep : "";
        if (head !== this.sep) {
          for (let i = 0; i < ditchParent; ++i) {
            segments.push("..");
          }
        }
        const tail = raw.length > 1 && raw.at(-1) === this.sep ? this.sep : "";
        return head + segments.reverse().join(this.sep) + tail;
      }
      doParse(path4) {
        const parts = this.parser(path4);
        return {
          ...parts,
          pathname: decodeURI(parts.pathname)
        };
      }
      doParseAndNormalize(path4) {
        return this.doNormalize(this.doParse(path4).pathname);
      }
    };
    function createWebPath(parser) {
      return new WebPath(parser);
    }
  }
});

// ../../packages/seml-parser/out/src/path/index.js
var require_path = __commonJS({
  "../../packages/seml-parser/out/src/path/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createWebPath = exports2.createNodePath = void 0;
    __exportStar2(require_api(), exports2);
    var node_impl_1 = require_node_impl();
    Object.defineProperty(exports2, "createNodePath", { enumerable: true, get: function() {
      return node_impl_1.createNodePath;
    } });
    var web_impl_1 = require_web_impl();
    Object.defineProperty(exports2, "createWebPath", { enumerable: true, get: function() {
      return web_impl_1.createWebPath;
    } });
  }
});

// ../../packages/seml-parser/out/src/index.js
var require_src = __commonJS({
  "../../packages/seml-parser/out/src/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar2(require_languageservice(), exports2);
    __exportStar2(require_path(), exports2);
  }
});

// ../../packages/seml-workspace/out/file-system/api.js
var require_api2 = __commonJS({
  "../../packages/seml-workspace/out/file-system/api.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createWebPath = exports2.createNodePath = void 0;
    var seml_parser_1 = require_src();
    Object.defineProperty(exports2, "createNodePath", { enumerable: true, get: function() {
      return seml_parser_1.createNodePath;
    } });
    Object.defineProperty(exports2, "createWebPath", { enumerable: true, get: function() {
      return seml_parser_1.createWebPath;
    } });
  }
});

// ../../packages/seml-workspace/out/file-system/node-impl.js
var require_node_impl2 = __commonJS({
  "../../packages/seml-workspace/out/file-system/node-impl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createNodeFileSystem = createNodeFileSystem;
    var node_fs_1 = require("fs");
    function createNodeFileSystem() {
      return {
        readFile: async (fsPath, encoding) => {
          const b = await node_fs_1.promises.readFile(fsPath, encoding);
          return b.toString();
        },
        readdir: async (fsPath, recursive = false, encoding = "utf8") => {
          const entries = await node_fs_1.promises.readdir(fsPath, { encoding, recursive });
          return entries;
        },
        isDirectory: async function(fsPath) {
          return node_fs_1.promises.stat(fsPath).then((stat) => stat.isDirectory()).catch(() => false);
        }
      };
    }
  }
});

// ../../packages/seml-workspace/out/file-system/index.js
var require_file_system = __commonJS({
  "../../packages/seml-workspace/out/file-system/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createNodeFileSystem = void 0;
    __exportStar2(require_api2(), exports2);
    var node_impl_1 = require_node_impl2();
    Object.defineProperty(exports2, "createNodeFileSystem", { enumerable: true, get: function() {
      return node_impl_1.createNodeFileSystem;
    } });
  }
});

// ../../packages/seml-workspace/out/seml-workspace/active-document-container.js
var require_active_document_container = __commonJS({
  "../../packages/seml-workspace/out/seml-workspace/active-document-container.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FileChangeType = void 0;
    exports2.createUnsynchronizedContainer = createUnsynchronizedContainer;
    var FileChangeType;
    (function(FileChangeType2) {
      FileChangeType2[FileChangeType2["Created"] = 1] = "Created";
      FileChangeType2[FileChangeType2["Changed"] = 2] = "Changed";
      FileChangeType2[FileChangeType2["Deleted"] = 3] = "Deleted";
    })(FileChangeType || (exports2.FileChangeType = FileChangeType = {}));
    var NoOpSyncContainer = class {
      container = /* @__PURE__ */ new Map();
      onDidChangeContent() {
      }
      onDidClose() {
      }
      onDidOpen() {
      }
      onDidSave() {
      }
      onWillSave() {
      }
      all() {
        return [...this.container.values()];
      }
      get(uri) {
        return this.container.get(uri);
      }
      set(uri, textDocument) {
        this.container.set(uri, textDocument);
      }
    };
    function createUnsynchronizedContainer() {
      return new NoOpSyncContainer();
    }
  }
});

// ../../packages/seml-workspace/out/seml-workspace/workspace.js
var require_workspace = __commonJS({
  "../../packages/seml-workspace/out/seml-workspace/workspace.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/seml-workspace/out/seml-workspace/workspace-configuration.js
var require_workspace_configuration = __commonJS({
  "../../packages/seml-workspace/out/seml-workspace/workspace-configuration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.semlWorkspaceConfiguration = exports2.DEFAULT_FILE_CHANGE_DELAY = void 0;
    exports2.DEFAULT_FILE_CHANGE_DELAY = 200;
    exports2.semlWorkspaceConfiguration = {
      fileChange: {
        delay: exports2.DEFAULT_FILE_CHANGE_DELAY,
        updateAllWorkspace: true,
        updateMaxDegree: -1
      }
    };
  }
});

// ../../packages/xdm-schema/out/memory/top_level.js
var require_top_level = __commonJS({
  "../../packages/xdm-schema/out/memory/top_level.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.rootTypes = exports2.allTypes = exports2.TOP_LEVEL_ENUM = void 0;
    var TOP_LEVEL_ENUM;
    (function(TOP_LEVEL_ENUM2) {
      TOP_LEVEL_ENUM2["MODEL"] = "Model";
      TOP_LEVEL_ENUM2["MODEL_APPLICATION"] = "Application";
      TOP_LEVEL_ENUM2["MODEL_COMPLEX_TYPE"] = "ComplexType";
      TOP_LEVEL_ENUM2["MODEL_DATABASE_VIEW"] = "DatabaseView";
      TOP_LEVEL_ENUM2["MODEL_ENRICHER_CACHE"] = "EnricherCache";
      TOP_LEVEL_ENUM2["MODEL_LOV_TYPE"] = "LOVType";
      TOP_LEVEL_ENUM2["MODEL_DIAGRAM"] = "ModelDiagram";
      TOP_LEVEL_ENUM2["MODEL_VARIABLE"] = "ModelVariable";
      TOP_LEVEL_ENUM2["MODEL_JOB"] = "ModelJob";
      TOP_LEVEL_ENUM2["MODEL_PRIV_GRANT"] = "ModelPrivGrant";
      TOP_LEVEL_ENUM2["MODEL_NAMED_QUERY"] = "NamedQuery";
      TOP_LEVEL_ENUM2["MODEL_PUBLISHER"] = "Publisher";
      TOP_LEVEL_ENUM2["MODEL_REFERENCE"] = "Reference";
      TOP_LEVEL_ENUM2["MODEL_SQL_FUNCTION"] = "SqlFunction";
      TOP_LEVEL_ENUM2["MODEL_USER_DEFINED_TYPE"] = "UserDefinedType";
      TOP_LEVEL_ENUM2["MODEL_WORKFLOW"] = "Workflow";
      TOP_LEVEL_ENUM2["MODEL_RETENTION_POLICY"] = "DataRetentionPolicy";
      TOP_LEVEL_ENUM2["MODEL_ENTITY"] = "Entity";
      TOP_LEVEL_ENUM2["ENTITY_SEMQL_VALIDATION"] = "SemQLValidation";
      TOP_LEVEL_ENUM2["ENTITY_PLUGIN_VALIDATION"] = "PluginValidation";
      TOP_LEVEL_ENUM2["ENTITY_ACTION_SET"] = "ActionSet";
      TOP_LEVEL_ENUM2["ENTITY_BUSINESS_VIEW"] = "BusinessView";
      TOP_LEVEL_ENUM2["ENTITY_COLLECTION_VIEW"] = "CollectionView";
      TOP_LEVEL_ENUM2["ENTITY_DISPLAY_CARD"] = "DisplayCard";
      TOP_LEVEL_ENUM2["ENTITY_DUPS_MANAGER"] = "DupsManager";
      TOP_LEVEL_ENUM2["ENTITY_JAVA_PLUGIN_ENRICHER"] = "JavaPluginEnricher";
      TOP_LEVEL_ENUM2["ENTITY_REST_CLIENT_ENRICHER"] = "RestClientEnricher";
      TOP_LEVEL_ENUM2["ENTITY_SEMQL_ENRICHER"] = "SemQLEnricher";
      TOP_LEVEL_ENUM2["ENTITY_FORM"] = "Form";
      TOP_LEVEL_ENUM2["ENTITY_SEARCH_FORM"] = "SearchForm";
      TOP_LEVEL_ENUM2["ENTITY_STEPPER"] = "Stepper";
      TOP_LEVEL_ENUM2["ENTITY_STANDARD_SURVIVORSHIP_RULE"] = "StandardSurvivorshipRule";
      TOP_LEVEL_ENUM2["ENTITY_ID_SURVIVORSHIP_RULE"] = "IDSurvivorshipRule";
      TOP_LEVEL_ENUM2["ENTITY_UNIQUE_KEY"] = "UniqueKey";
      TOP_LEVEL_ENUM2["ENTITY_FUZZY_LOOKUP_RULE"] = "FuzzyLookupRule";
    })(TOP_LEVEL_ENUM || (exports2.TOP_LEVEL_ENUM = TOP_LEVEL_ENUM = {}));
    exports2.allTypes = Object.values(TOP_LEVEL_ENUM).map((e) => e.toString());
    exports2.rootTypes = [
      TOP_LEVEL_ENUM.MODEL,
      TOP_LEVEL_ENUM.MODEL_APPLICATION,
      TOP_LEVEL_ENUM.MODEL_COMPLEX_TYPE,
      TOP_LEVEL_ENUM.MODEL_DATABASE_VIEW,
      TOP_LEVEL_ENUM.MODEL_DIAGRAM,
      TOP_LEVEL_ENUM.MODEL_ENRICHER_CACHE,
      TOP_LEVEL_ENUM.MODEL_ENTITY,
      TOP_LEVEL_ENUM.MODEL_JOB,
      TOP_LEVEL_ENUM.MODEL_LOV_TYPE,
      TOP_LEVEL_ENUM.MODEL_NAMED_QUERY,
      TOP_LEVEL_ENUM.MODEL_PRIV_GRANT,
      TOP_LEVEL_ENUM.MODEL_PUBLISHER,
      TOP_LEVEL_ENUM.MODEL_REFERENCE,
      TOP_LEVEL_ENUM.MODEL_RETENTION_POLICY,
      TOP_LEVEL_ENUM.MODEL_SQL_FUNCTION,
      TOP_LEVEL_ENUM.MODEL_USER_DEFINED_TYPE,
      TOP_LEVEL_ENUM.MODEL_VARIABLE,
      TOP_LEVEL_ENUM.MODEL_WORKFLOW
    ].map((e) => e.toString());
  }
});

// ../../packages/xdm-schema/out/memory/dm/form-queries.js
var require_form_queries = __commonJS({
  "../../packages/xdm-schema/out/memory/dm/form-queries.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.formQueries = void 0;
    var top_level_1 = require_top_level();
    var FormQueriesImpl = class {
      findFormEntity(source, modelElementQueries) {
        const form = source._type === top_level_1.TOP_LEVEL_ENUM.ENTITY_FORM ? source : modelElementQueries.findParentOf(source, top_level_1.TOP_LEVEL_ENUM.ENTITY_FORM);
        if (!form) {
          return;
        }
        return modelElementQueries.findByQualifiedName(form.entity, top_level_1.TOP_LEVEL_ENUM.MODEL_ENTITY).match;
      }
    };
    exports2.formQueries = new FormQueriesImpl();
  }
});

// ../../packages/xdm-schema/out/memory/dm/stepper-queries.js
var require_stepper_queries = __commonJS({
  "../../packages/xdm-schema/out/memory/dm/stepper-queries.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.stepperQueries = void 0;
    var top_level_1 = require_top_level();
    var StepperQueriesImpl = class {
      findStepEntity(step, modelElementQueries) {
        const parent = this.findParentCollectionStep(step, modelElementQueries);
        if (!parent) {
          return;
        }
        return this.findCollectionStepEntity(parent, modelElementQueries);
      }
      findCollectionStepEntity(step, modelElementQueries) {
        const parent = this.findParentCollectionStep(step, modelElementQueries);
        if (!parent) {
          return this.findStepperEntity(step, modelElementQueries);
        }
        if ("oneToManyReference" in step && typeof step.oneToManyReference === "string") {
          const reference = modelElementQueries.findByQualifiedName(step.oneToManyReference, top_level_1.TOP_LEVEL_ENUM.MODEL_REFERENCE).match;
          if (!reference) {
            return;
          }
          return modelElementQueries.findByQualifiedName(reference.fromEntity, top_level_1.TOP_LEVEL_ENUM.MODEL_ENTITY).match;
        }
        return;
      }
      findStepperEntity(source, modelElementQueries) {
        if (!source.__meta.parentQualifiedName) {
          console.error(`Expected to have a parentQualifiedName registered for step ${JSON.stringify(source.__meta)}`);
          return;
        }
        const parent = modelElementQueries.findAnyByQualifiedName(source.__meta.parentQualifiedName, [
          "CollectionStep",
          top_level_1.TOP_LEVEL_ENUM.ENTITY_STEPPER
        ]).match;
        if (!parent) {
          return;
        }
        if (parent._type === top_level_1.TOP_LEVEL_ENUM.ENTITY_STEPPER) {
          return modelElementQueries.findByQualifiedName(parent.entity, top_level_1.TOP_LEVEL_ENUM.MODEL_ENTITY).match;
        }
        return this.findStepperEntity(parent, modelElementQueries);
      }
      findStepForm(source, modelElementQueries) {
        if ("_type" in source && source._type === "FormStep") {
          const formElementName = source.formSection ?? source.formTab;
          if (!formElementName) {
            return;
          }
          const formElement = modelElementQueries.findAnyByQualifiedName(formElementName, ["FormSection", "FormTab"]).match;
          if (!formElement) {
            return;
          }
          return modelElementQueries.findParentOf(formElement, top_level_1.TOP_LEVEL_ENUM.ENTITY_FORM);
        }
        const parentName = source.__meta.parentQualifiedName;
        if (!parentName) {
          console.error(`Expected to have a parentQualifiedName registered for reference field design ${JSON.stringify(source.__meta)}`);
          return;
        }
        const parent = modelElementQueries.findByQualifiedName(parentName, "FormStep").match;
        if (!parent) {
          return;
        }
        return this.findStepForm(parent, modelElementQueries);
      }
      findParentCollectionStep(step, modelElementQueries) {
        if (!step.__meta.parentQualifiedName) {
          console.error(`Expected to have a parentQualifiedName registered for step ${JSON.stringify(step.__meta)}`);
          return;
        }
        return modelElementQueries.findParentOf(step, "CollectionStep");
      }
    };
    exports2.stepperQueries = new StepperQueriesImpl();
  }
});

// ../../packages/xdm-schema/out/memory/dm/index.js
var require_dm = __commonJS({
  "../../packages/xdm-schema/out/memory/dm/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.stepperQueries = exports2.formQueries = void 0;
    var form_queries_1 = require_form_queries();
    Object.defineProperty(exports2, "formQueries", { enumerable: true, get: function() {
      return form_queries_1.formQueries;
    } });
    var stepper_queries_1 = require_stepper_queries();
    Object.defineProperty(exports2, "stepperQueries", { enumerable: true, get: function() {
      return stepper_queries_1.stepperQueries;
    } });
  }
});

// ../../packages/xdm-schema/out/memory/file-lifecycle-aware.js
var require_file_lifecycle_aware = __commonJS({
  "../../packages/xdm-schema/out/memory/file-lifecycle-aware.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/xdm-schema/out/design/model_element_design.js
var require_model_element_design = __commonJS({
  "../../packages/xdm-schema/out/design/model_element_design.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isModelElementBaseDesign = isModelElementBaseDesign;
    exports2.isModelElementTopLevel = isModelElementTopLevel;
    function isModelElementBaseDesign(x) {
      if (typeof x === "object" && x) {
        if ("_name" in x && "_type" in x) {
          return typeof x._name === "string" && typeof x._type === "string";
        }
      }
      return false;
    }
    function isModelElementTopLevel(x) {
      if (!isModelElementBaseDesign(x)) {
        return false;
      }
      return "_package" in x && typeof x._package === "string";
    }
  }
});

// ../../packages/xdm-schema/out/design/index.js
var require_design = __commonJS({
  "../../packages/xdm-schema/out/design/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isModelElementTopLevel = exports2.isModelElementBaseDesign = void 0;
    var model_element_design_1 = require_model_element_design();
    Object.defineProperty(exports2, "isModelElementBaseDesign", { enumerable: true, get: function() {
      return model_element_design_1.isModelElementBaseDesign;
    } });
    Object.defineProperty(exports2, "isModelElementTopLevel", { enumerable: true, get: function() {
      return model_element_design_1.isModelElementTopLevel;
    } });
  }
});

// ../../packages/xdm-schema/out/indexer/application/application_indexer.js
var require_application_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/application/application_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexApplication = indexApplication;
    function indexApplication(application, metadataService, indexer) {
      const applicationMetadata = metadataService.createForTopLevel(application);
      const rootFolder = application.rootFolder ? indexRootFolder(application.rootFolder, metadataService, applicationMetadata, indexer) : void 0;
      const navDrawer = application.navDrawer?.map((navigation, i) => metadataService.indexInner(navigation, applicationMetadata, `navDrawer[${i}]`));
      const documentationConfig = application.documentationConfig ? {
        ...application.documentationConfig,
        documentationConfigDiagrams: application.documentationConfig.documentationConfigDiagrams?.map((diagram, i) => metadataService.indexInner(diagram, applicationMetadata, `documentationConfig.documentationConfigDiagrams[${i}]`))
      } : void 0;
      const globalSearchConfig = application.globalSearchConfig ? {
        ...application.globalSearchConfig,
        globalSearchBusinessViews: application.globalSearchConfig.globalSearchBusinessViews?.map((search, i) => metadataService.indexInner(search, applicationMetadata, `globalSearchConfig.globalSearchBusinessViews[${i}]`))
      } : void 0;
      const toIndex = {
        ...application,
        rootFolder,
        navDrawer,
        documentationConfig,
        globalSearchConfig,
        ...applicationMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexAppAction(action, metadataService, parentMetadata, indexer, query) {
      const appActionMetadata = metadataService.createForInner(action, parentMetadata, query);
      if (action._type === "FolderAction") {
        return indexFolderAction(action, metadataService, appActionMetadata, indexer);
      }
      if (action._type === "OpenDashboardAction") {
        const parameters = action.parameters?.map((parameter, i) => metadataService.indexInner(parameter, appActionMetadata, `parameters[${i}]`));
        const toIndex2 = {
          ...action,
          parameters,
          ...appActionMetadata
        };
        indexer.indexModelElement(toIndex2);
        return toIndex2;
      }
      const toIndex = {
        ...action,
        ...appActionMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexRootFolder(action, metadataService, applicationMetadata, indexer) {
      const folderMetadata = metadataService.createForInner(action, applicationMetadata, "rootFolder");
      return indexFolderAction(action, metadataService, folderMetadata, indexer);
    }
    function indexFolderAction(action, metadataService, folderMetadata, indexer) {
      const appActions = action.appActions?.map((action2, i) => indexAppAction(action2, metadataService, folderMetadata, indexer, `appActions[${i}]`));
      const toIndex = {
        ...action,
        appActions,
        ...folderMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/indexer/complex_type/complex_type_indexer.js
var require_complex_type_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/complex_type/complex_type_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexComplexType = indexComplexType;
    function indexComplexType(complexTypeDesign, metadataService, indexer) {
      const complexTypeMetadata = metadataService.createForTopLevel(complexTypeDesign);
      const attributes = complexTypeDesign.attributes?.map((attr, i) => metadataService.indexInner(attr, complexTypeMetadata, `attributes[${i}]`));
      const displayName = complexTypeDesign.displayName ? metadataService.indexInner(complexTypeDesign.displayName, complexTypeMetadata, "displayName") : void 0;
      const toIndex = {
        ...complexTypeDesign,
        attributes,
        displayName,
        ...complexTypeMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/db_function/db_function_indexer.js
var require_db_function_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/db_function/db_function_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexDbFunction = indexDbFunction;
    function indexDbFunction(sqlFunctionDesign, metadataService, indexer) {
      const sqlFunctionMetadata = metadataService.createForTopLevel(sqlFunctionDesign);
      const functionArguments = sqlFunctionDesign.functionArguments?.map((arg, i) => metadataService.indexInner(arg, sqlFunctionMetadata, `functionArguments[${i}]`));
      const toIndex = {
        ...sqlFunctionDesign,
        functionArguments,
        ...sqlFunctionMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/db_view/db_view_indexer.js
var require_db_view_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/db_view/db_view_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexDatabaseView = indexDatabaseView;
    function indexDatabaseView(databaseViewDesign, metadataService) {
      metadataService.indexTopLevel(databaseViewDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/enricher_cache/enricher_cache_indexer.js
var require_enricher_cache_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/enricher_cache/enricher_cache_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexEnricherCache = indexEnricherCache;
    function indexEnricherCache(enricherCacheDesign, metadataService) {
      metadataService.indexTopLevel(enricherCacheDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/action_set/action_set_indexer.js
var require_action_set_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/action_set/action_set_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexActionSet = indexActionSet;
    function indexActionSet(actionSetDesign, indexer, metadataService) {
      const actionSetMetadata = metadataService.createForExternalChild(actionSetDesign, actionSetDesign.entity);
      const actions = actionSetDesign.actions?.map((action, i) => metadataService.indexInner(action, actionSetMetadata, `actions[${i}]`));
      const toIndex = {
        ...actionSetDesign,
        actions,
        ...actionSetMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/business_view/business_view_indexer.js
var require_business_view_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/business_view/business_view_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexBusinessObjectView = indexBusinessObjectView;
    function indexBusinessObjectView(businessView, metadataService, indexer) {
      const businessViewMetadata = metadataService.createForExternalChild(businessView, businessView.entity);
      const businessViewEntityRoot = indexBusinessViewEntity(businessView.rootBusinessViewEntity, metadataService, businessViewMetadata, indexer, "rootBusinessViewEntity");
      const toIndex = {
        ...businessView,
        rootBusinessViewEntity: businessViewEntityRoot,
        ...businessViewMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexBusinessViewTransition(businessViewTransition, metadataService, parentMetadata, indexer, query) {
      const businessViewTransitionMetadata = metadataService.createForInner(businessViewTransition, parentMetadata, query);
      let businessViewEntity = void 0;
      if (businessViewTransition.businessViewEntity._type === "BusinessViewEntity") {
        businessViewEntity = indexBusinessViewEntity(businessViewTransition.businessViewEntity, metadataService, businessViewTransitionMetadata, indexer, "businessViewEntity");
      } else {
        businessViewEntity = businessViewTransition.businessViewEntity;
      }
      const toIndex = {
        ...businessViewTransition,
        businessViewEntity,
        ...businessViewTransitionMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexBusinessViewEntity(businessViewEntity, metadataService, parentMetadata, indexer, query) {
      const businessViewEntityMetadata = metadataService.createForInner(businessViewEntity, parentMetadata, query);
      const transitions = businessViewEntity.transitions?.map((businessViewTransition, i) => {
        return indexBusinessViewTransition(businessViewTransition, metadataService, businessViewEntityMetadata, indexer, `transitions[${i}]`);
      });
      const businessEntitySearchConfigs = businessViewEntity.businessEntitySearchConfigs?.map((searchConfig, i) => metadataService.indexInner(searchConfig, businessViewEntityMetadata, `businessEntitySearchConfigs[${i}]`));
      const businessEntityBuiltInFilters = businessViewEntity.businessEntityBuiltInFilters?.map((filter, i) => metadataService.indexInner(filter, businessViewEntityMetadata, `businessEntityBuiltInFilters[${i}]`));
      const toIndex = {
        ...businessViewEntity,
        transitions,
        businessEntitySearchConfigs,
        businessEntityBuiltInFilters,
        ...businessViewEntityMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/collection_view/collection_view_indexer.js
var require_collection_view_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/collection_view/collection_view_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexCollectionView = indexCollectionView;
    function indexCollectionView(collectionView, metadataService, indexer) {
      const collectionViewMetadata = metadataService.createForExternalChild(collectionView, collectionView.entity);
      const tableColumns = collectionView.tableColumns?.map((tableColumn, i) => indexTableColumn(tableColumn, metadataService, collectionViewMetadata, indexer, `tableColumns[${i}]`));
      const toIndex = {
        ...collectionView,
        tableColumns,
        ...collectionViewMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexTableColumn(column, metadataService, parentMetadata, indexer, query) {
      const columnMetadata = metadataService.createForInner(column, parentMetadata, query);
      const toIndex = {
        ...column,
        ...columnMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/display_card/display_card_indexer.js
var require_display_card_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/display_card/display_card_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexDisplayCard = indexDisplayCard;
    function indexDisplayCard(displayCardDesign, metadataService) {
      metadataService.indexExternalChild(displayCardDesign, displayCardDesign.entity);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/dups_manager/dups_manager_indexer.js
var require_dups_manager_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/dups_manager/dups_manager_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexDupsManager = indexDupsManager;
    function indexDupsManager(dupsManagerDesign, metadataService) {
      metadataService.indexExternalChild(dupsManagerDesign, dupsManagerDesign.entity);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/enricher/enricher_indexer.js
var require_enricher_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/enricher/enricher_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexEnricher = indexEnricher;
    function indexEnricher(enricherDesign, metadataService) {
      metadataService.indexExternalChild(enricherDesign, enricherDesign.entity);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/entity_indexer.js
var require_entity_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/entity_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexEntity = indexEntity;
    function indexEntity(entityDesign, metadataService, indexer) {
      const entityMetadata = metadataService.createForTopLevel(entityDesign);
      const attributes = entityDesign.attributes.map((attr, i) => metadataService.indexInner(attr, entityMetadata, `attributes[${i}]`));
      const matcher = entityDesign.matcher ? indexMatcher(entityDesign.matcher, metadataService, indexer, entityMetadata, "matcher") : void 0;
      const toIndex = {
        ...entityDesign,
        attributes,
        matcher,
        ...entityMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexMatcher(matcher, metadataService, indexer, entityMetadata, query) {
      const matcherMetadata = metadataService.createForInner(matcher, entityMetadata, query);
      const matchRules = matcher.matchRules.map((rule, i) => metadataService.indexInner(rule, matcherMetadata, `matchRules[${i}]`));
      const toIndex = {
        ...matcher,
        matchRules,
        ...matcherMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/form/form_indexer.js
var require_form_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/form/form_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexForm = indexForm;
    function exploreFormElements(parentMetadata, formElement, metadataService, indexer, query) {
      switch (formElement._type) {
        case "FormContainer": {
          const formContainerMetadata = metadataService.createForInner(formElement, parentMetadata, query);
          const indexedContent = formElement.content.map((formElementChild, i) => exploreFormElements(formContainerMetadata, formElementChild, metadataService, indexer, `content[${i}]`));
          const indexedFormContainer = {
            ...formContainerMetadata,
            ...formElement,
            content: indexedContent
          };
          indexer.indexModelElement(indexedFormContainer);
          return indexedFormContainer;
        }
        case "FormSection": {
          const formSectionMetadata = metadataService.createForInner(formElement, parentMetadata, query);
          const indexedContent = formElement.content.map((formSectionChild, i) => exploreFormElements(formSectionMetadata, formSectionChild, metadataService, indexer, `content[${i}]`)).filter((formChildElement) => formChildElement._type !== "FormSection");
          const indexedFormSection = {
            ...formSectionMetadata,
            ...formElement,
            content: indexedContent
          };
          indexer.indexModelElement(indexedFormSection);
          return indexedFormSection;
        }
        case "FormCollection":
          return indexCollection(parentMetadata, formElement, metadataService, indexer, query);
        case "CheckboxField":
        case "DateField":
        case "HyperlinkField":
        case "IdField":
        case "ImageField":
        case "MarkdownField":
        case "MenuField":
        case "ObjectField":
        case "ReferenceField":
        case "TextField":
        case "ChipsField":
          return indexField(parentMetadata, formElement, metadataService, indexer, query);
        case "FormDashboard":
          return indexDashboard(parentMetadata, formElement, metadataService, indexer, query);
        case "FormChart":
          return indexChart(parentMetadata, formElement, metadataService, indexer, query);
      }
    }
    function indexForm(form, metadataService, indexer) {
      const formMetadata = metadataService.createForExternalChild(form, form.entity);
      const indexedFormTabs = form.formTabs.map((formTab, i) => {
        const formTabMetadata = metadataService.createForInner(formTab, formMetadata, `formTabs[${i}]`);
        const indexedContent = formTab.content.map((formElement, j) => {
          return exploreFormElements(formTabMetadata, formElement, metadataService, indexer, `content[${j}]`);
        });
        const indexedFormTab = {
          ...formTabMetadata,
          ...formTab,
          content: indexedContent
        };
        indexer.indexModelElement(indexedFormTab);
        return indexedFormTab;
      });
      const toIndex = {
        ...form,
        formTabs: indexedFormTabs,
        ...formMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexField(parentMetadata, field, metadataService, indexer, query) {
      const fieldMetadata = metadataService.createForInner(field, parentMetadata, query);
      const toIndex = {
        ...field,
        ...fieldMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexChart(parentMetadata, chart, metadataService, indexer, query) {
      const chartMetadata = metadataService.createForInner(chart, parentMetadata, query);
      const queryAttributes = chart.queryAttributes?.map((parameter, i) => metadataService.indexInner(parameter, chartMetadata, `queryAttributes[${i}]`));
      const toIndex = {
        ...chart,
        queryAttributes,
        ...chartMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexCollection(parentMetadata, collection, metadataService, indexer, query) {
      const collectionMetadata = metadataService.createForInner(collection, parentMetadata, query);
      const formCollectionBuiltInFilters = collection.formCollectionBuiltInFilters?.map((filter, i) => metadataService.indexInner(filter, collectionMetadata, `formCollectionBuiltInFilters[${i}]`));
      const toIndex = {
        ...collection,
        formCollectionBuiltInFilters,
        ...collectionMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexDashboard(parentMetadata, dashboard, metadataService, indexer, query) {
      const dashboardMetadata = metadataService.createForInner(dashboard, parentMetadata, query);
      const parameters = dashboard.parameters?.map((parameter, i) => metadataService.indexInner(parameter, dashboardMetadata, `parameters[${i}]`));
      const toIndex = {
        ...dashboard,
        parameters,
        ...dashboardMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/fuzzy_lookup_rule/fuzzy_lookup_rule_indexer.js
var require_fuzzy_lookup_rule_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/fuzzy_lookup_rule/fuzzy_lookup_rule_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexFuzzyLookupRule = indexFuzzyLookupRule;
    function indexFuzzyLookupRule(fuzzyLookupRuleDesign, metadataService) {
      metadataService.indexExternalChild(fuzzyLookupRuleDesign, fuzzyLookupRuleDesign.entity);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/search_form/search_form_indexer.js
var require_search_form_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/search_form/search_form_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexSearchForm = indexSearchForm;
    function indexSearchForm(searchFormDesign, metadataService, indexer) {
      const searchFormMetadata = metadataService.createForExternalChild(searchFormDesign, searchFormDesign.entity);
      const searchParameters = searchFormDesign.searchParameters.map((searchParameter, i) => metadataService.indexInner(searchParameter, searchFormMetadata, `searchParameters[${i}]`));
      const toIndex = {
        ...searchFormDesign,
        searchParameters,
        ...searchFormMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/stepper/stepper_indexer.js
var require_stepper_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/stepper/stepper_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexStepper = indexStepper;
    function indexStepper(stepper, metadataService, indexer) {
      const stepperMetadata = metadataService.createForExternalChild(stepper, stepper.entity);
      const rootStep = indexCollectionStep(stepper.rootStep, metadataService, stepperMetadata, indexer, `rootStep`);
      const triggers = stepper.triggers?.map((trigger, i) => metadataService.indexInner(trigger, stepperMetadata, `triggers[${i}]`));
      const toIndex = {
        ...stepper,
        rootStep,
        triggers,
        ...stepperMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexStep(step, metadataService, parentMetadata, indexer, query) {
      if (step._type === "FormStep") {
        return indexFormStep(step, metadataService, parentMetadata, indexer, query);
      }
      return indexCollectionStep(step, metadataService, parentMetadata, indexer, query);
    }
    function indexCollectionStep(step, metadataService, parentMetadata, indexer, query) {
      const stepMetadata = metadataService.createForInner(step, parentMetadata, query);
      const childSteps = step.childSteps?.map((childStep, i) => indexStep(childStep, metadataService, stepMetadata, indexer, `childSteps[${i}]`));
      const stepTriggers = step.stepTriggers?.map((trigger, i) => metadataService.indexInner(trigger, stepMetadata, `stepTriggers[${i}]`));
      const toIndex = {
        ...step,
        childSteps,
        stepTriggers,
        ...stepMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexFormStep(step, metadataService, parentMetadata, indexer, query) {
      const stepMetadata = metadataService.createForInner(step, parentMetadata, query);
      const stepTriggers = step.stepTriggers?.map((trigger, i) => metadataService.indexInner(trigger, stepMetadata, `stepTriggers[${i}]`));
      const toIndex = {
        ...step,
        stepTriggers,
        ...stepMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/survivorship_rule/survivorship_rule_indexer.js
var require_survivorship_rule_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/survivorship_rule/survivorship_rule_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexSurvivorshipRule = indexSurvivorshipRule;
    function indexSurvivorshipRule(survivorshipRuleDesign, metadataService) {
      metadataService.indexExternalChild(survivorshipRuleDesign, survivorshipRuleDesign.entity);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/unique_key/unique_key_indexer.js
var require_unique_key_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/unique_key/unique_key_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexUniqueKey = indexUniqueKey;
    function indexUniqueKey(uniqueKeyDesign, metadataService) {
      metadataService.indexExternalChild(uniqueKeyDesign, uniqueKeyDesign.entity);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/entity/validation/validation_indexer.js
var require_validation_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/entity/validation/validation_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexConstraint = indexConstraint;
    function indexConstraint(validationDesign, metadataService) {
      metadataService.indexExternalChild(validationDesign, validationDesign.entity);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/job/job_indexer.js
var require_job_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/job/job_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexModelJob = indexModelJob;
    function indexModelJob(modelJobDesign, metadataService, indexer) {
      const modelJobMetadata = metadataService.createForTopLevel(modelJobDesign);
      const jobParams = modelJobDesign.jobParams?.map((param, i) => metadataService.indexInner(param, modelJobMetadata, `jobParams[${i}]`));
      const modelTasks = modelJobDesign.modelTasks?.map((task, i) => metadataService.indexInner(task, modelJobMetadata, `modelTasks[${i}]`));
      const toIndex = {
        ...modelJobDesign,
        jobParams,
        modelTasks,
        ...modelJobMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/list_of_value/list_of_value_indexer.js
var require_list_of_value_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/list_of_value/list_of_value_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexLovType = indexLovType;
    function indexLovType(lovTypeDesign, metadataService) {
      metadataService.indexTopLevel(lovTypeDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/model_diagram/model_diagram_indexer.js
var require_model_diagram_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/model_diagram/model_diagram_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexModelDiagram = indexModelDiagram;
    function indexModelDiagram(modelDiagramDesign, metadataService, indexer) {
      const modelDiagramMetadata = metadataService.createForTopLevel(modelDiagramDesign);
      const entityShapes = modelDiagramDesign.entityShapes.map((entityShape, i) => metadataService.indexInner(entityShape, modelDiagramMetadata, `entityShapes[${i}]`));
      const toIndex = {
        ...modelDiagramDesign,
        entityShapes,
        ...modelDiagramMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/model_indexer.js
var require_model_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/model_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexModel = indexModel;
    function indexModel(modelDesign, metadataService) {
      metadataService.indexTopLevel(modelDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/model_priv_grant/model_priv_grant_indexer.js
var require_model_priv_grant_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/model_priv_grant/model_priv_grant_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexModelPrivGrant = indexModelPrivGrant;
    function indexModelPrivGrant(modelPrivGrantDesign, metadataService, indexer) {
      const modelPrivGrantDesignMetadata = metadataService.createForTopLevel(modelPrivGrantDesign);
      const entityPrivGrants = modelPrivGrantDesign.entityPrivGrants?.map((grant, i) => metadataService.indexInner(grant, modelPrivGrantDesignMetadata, `entityPrivGrants[${i}]`));
      const toIndex = {
        ...modelPrivGrantDesign,
        entityPrivGrants,
        ...modelPrivGrantDesignMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/model_variable/model_variable_indexer.js
var require_model_variable_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/model_variable/model_variable_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexModelEditionVariable = indexModelEditionVariable;
    function indexModelEditionVariable(modelVariableDesign, metadataService) {
      metadataService.indexTopLevel(modelVariableDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/named_query/named_query_indexer.js
var require_named_query_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/named_query/named_query_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexNamedQuery = indexNamedQuery;
    function indexNamedQuery(namedQueryDesign, metadataService, indexer) {
      const namedQueryDesignMetadata = metadataService.createForTopLevel(namedQueryDesign);
      const queryParameters = namedQueryDesign.queryParameters?.map((param, i) => metadataService.indexInner(param, namedQueryDesignMetadata, `queryParameters[${i}]`));
      const queryObjects = namedQueryDesign.queryObjects?.map((obj, i) => indexQueryObject(obj, metadataService, namedQueryDesignMetadata, indexer, `queryObjects[${i}]`));
      const toIndex = {
        ...namedQueryDesign,
        queryParameters,
        queryObjects,
        ...namedQueryDesignMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexQueryObject(obj, metadataService, namedQueryMetadata, indexer, query) {
      const objMetadata = metadataService.createForInner(obj, namedQueryMetadata, query);
      const objectProperties = obj.objectProperties?.map((properties, i) => metadataService.indexInner(properties, objMetadata, `objectProperties[${i}]`));
      const toIndex = {
        ...obj,
        objectProperties,
        ...objMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/indexer/publisher/publisher_indexer.js
var require_publisher_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/publisher/publisher_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexPublisher = indexPublisher;
    function indexPublisher(publisherDesign, metadataService) {
      metadataService.indexTopLevel(publisherDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/reference/reference_indexer.js
var require_reference_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/reference/reference_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexReference = indexReference;
    function indexReference(referenceDesign, metadataService, indexer) {
      const referenceMetadata = metadataService.createForTopLevel(referenceDesign);
      const foreignAttribute = referenceDesign.foreignAttribute ? metadataService.indexInner(referenceDesign.foreignAttribute, referenceMetadata, "foreignAttribute") : void 0;
      const toIndex = {
        ...referenceDesign,
        foreignAttribute,
        ...referenceMetadata
      };
      indexer.indexModelElement(toIndex);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/retention_policy/retention_policy_indexer.js
var require_retention_policy_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/retention_policy/retention_policy_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexRetentionPolicyDataHub = indexRetentionPolicyDataHub;
    function indexRetentionPolicyDataHub(dataRetentionPolicyDesign, metadataService) {
      metadataService.indexTopLevel(dataRetentionPolicyDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/user_defined_type/user_defined_type_indexer.js
var require_user_defined_type_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/user_defined_type/user_defined_type_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexUserDefinedType = indexUserDefinedType;
    function indexUserDefinedType(userDefinedTypeDesign, metadataService) {
      metadataService.indexTopLevel(userDefinedTypeDesign);
    }
  }
});

// ../../packages/xdm-schema/out/indexer/workflow/workflow_indexer.js
var require_workflow_indexer = __commonJS({
  "../../packages/xdm-schema/out/indexer/workflow/workflow_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexWorkflow = indexWorkflow;
    function indexWorkflow(workflow, metadataService, indexer) {
      const wfMetadata = metadataService.createForTopLevel(workflow);
      const dataScope = workflow.dataScope.map((rootEntity, i) => metadataService.indexInner(rootEntity, wfMetadata, `dataScope[${i}]`));
      const steps = workflow.steps.map((step, i) => indexStep(step, metadataService, wfMetadata, indexer, `steps[${i}]`));
      const toIndex = {
        ...workflow,
        dataScope,
        steps,
        ...wfMetadata
      };
      indexer.indexModelElement(toIndex);
    }
    function indexStep(step, metadataService, parentMetadata, indexer, query) {
      switch (step._type) {
        case "SetWorkflowMetadataAutomation":
        case "SendEmailAutomation":
        case "DeleteDataAutomation":
        case "CallProcedureAutomation":
        case "SubmitAutomation": {
          return indexAutomation(step, metadataService, parentMetadata, indexer, query);
        }
        case "EndEvent": {
          return metadataService.indexInner(step, parentMetadata, query);
        }
        case "ParallelBlock": {
          return indexParallelBlock(step, metadataService, parentMetadata, indexer, query);
        }
        case "Router": {
          return indexRouter(step, metadataService, parentMetadata, indexer, query);
        }
        case "StartFromCompleteBatchEvent":
        case "StartFromEmptySelectionEvent":
        case "StartFromSelectedParentEvent":
        case "StartFromSelectionEvent": {
          return indexStartEvent(step, metadataService, parentMetadata, indexer, query);
        }
        case "UserTask": {
          return indexUserTask(step, metadataService, parentMetadata, indexer, query);
        }
      }
    }
    function toIndexSendEmailAutomation(step, metadataService, stepMetadata, transition) {
      return {
        ...step,
        to: step.to?.map((to, i) => metadataService.indexInner(to, stepMetadata, `to[${i}]`)),
        customParameters: step.customParameters?.map((param, i) => metadataService.indexInner(param, stepMetadata, `customParameters[${i}]`)),
        transition,
        ...stepMetadata
      };
    }
    function indexAutomation(step, metadataService, parentMetadata, indexer, query) {
      const stepMetadata = metadataService.createForInner(step, parentMetadata, query);
      const transition = metadataService.indexInner(step.transition, stepMetadata, "transition");
      let toIndex;
      if (step._type === "SendEmailAutomation") {
        toIndex = toIndexSendEmailAutomation(step, metadataService, stepMetadata, transition);
      } else {
        toIndex = {
          ...step,
          transition,
          ...stepMetadata
        };
      }
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexParallelBlock(step, metadataService, parentMetadata, indexer, query) {
      const stepMetadata = metadataService.createForInner(step, parentMetadata, query);
      const branches = step.branches.map((branch, i) => indexBranch(branch, metadataService, stepMetadata, indexer, `branches[${i}]`));
      const transition = metadataService.indexInner(step.transition, stepMetadata, "transition");
      const toIndex = {
        ...step,
        branches,
        transition,
        ...stepMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexBranch(branch, metadataService, parentMetadata, indexer, query) {
      const branchMetadata = metadataService.createForInner(branch, parentMetadata, query);
      const steps = branch.steps.map((branchStep, i) => indexBranchStep(branchStep, metadataService, branchMetadata, indexer, `steps[${i}]`));
      const toIndex = {
        ...branch,
        steps,
        ...branchMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexBranchStep(branchStep, metadataService, parentMetadata, indexer, query) {
      if (branchStep._type === "SubmitAutomation" || branchStep._type === "SendEmailAutomation" || branchStep._type === "SetWorkflowMetadataAutomation" || branchStep._type === "DeleteDataAutomation" || branchStep._type === "CallProcedureAutomation") {
        return indexAutomation(branchStep, metadataService, parentMetadata, indexer, query);
      }
      if (branchStep._type === "Router") {
        return indexRouter(branchStep, metadataService, parentMetadata, indexer, query);
      }
      if (branchStep._type === "UserTask") {
        return indexUserTask(branchStep, metadataService, parentMetadata, indexer, query);
      }
      const branchStepMetadata = metadataService.createForInner(branchStep, parentMetadata, query);
      if (branchStep._type === "BranchStartEvent") {
        const transition = metadataService.indexInner(branchStep.transition, branchStepMetadata, "transition");
        const toIndex2 = {
          ...branchStep,
          transition,
          ...branchStepMetadata
        };
        indexer.indexModelElement(toIndex2);
        return toIndex2;
      }
      const toIndex = {
        ...branchStep,
        ...branchStepMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexUserTask(step, metadataService, parentMetadata, indexer, query) {
      const stepMetadata = metadataService.createForInner(step, parentMetadata, query);
      const transitions = step.transitions?.map((transition, i) => metadataService.indexInner(transition, stepMetadata, `transitions[${i}]`));
      const toIndex = {
        ...step,
        transitions,
        ...stepMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function indexRouter(step, metadataService, parentMetadata, indexer, query) {
      const stepMetadata = metadataService.createForInner(step, parentMetadata, query);
      const routes = step.routes.map((route, i) => metadataService.indexInner(route, stepMetadata, `routes[${i}]`));
      const toIndex = {
        ...step,
        routes,
        ...stepMetadata
      };
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
    function toIndexStartFromCompletedBatchEvent(step, metadataService, stepMetadata, transition) {
      const dataRecordOutputs = step.dataRecordOutputs?.map((output, i) => metadataService.indexInner(output, stepMetadata, `dataRecordOutputs[${i}]`));
      return {
        ...step,
        dataRecordOutputs,
        transition,
        ...stepMetadata
      };
    }
    function indexStartEvent(step, metadataService, parentMetadata, indexer, query) {
      const stepMetadata = metadataService.createForInner(step, parentMetadata, query);
      const transition = metadataService.indexInner(step.transition, stepMetadata, "transition");
      let toIndex;
      if (step._type === "StartFromCompleteBatchEvent") {
        toIndex = toIndexStartFromCompletedBatchEvent(step, metadataService, stepMetadata, transition);
      } else {
        toIndex = {
          ...step,
          transition,
          ...stepMetadata
        };
      }
      indexer.indexModelElement(toIndex);
      return toIndex;
    }
  }
});

// ../../packages/xdm-schema/out/memory/qualified_name.js
var require_qualified_name = __commonJS({
  "../../packages/xdm-schema/out/memory/qualified_name.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createInnerQualifiedName = createInnerQualifiedName;
    exports2.createInnerQualifiedNameFrom = createInnerQualifiedNameFrom;
    exports2.joinNames = joinNames;
    exports2.createTopLevelQualifiedName = createTopLevelQualifiedName;
    function createInnerQualifiedName(parentQualifiedName, designElement) {
      return {
        payloadFullyQualifiedName: `${designElement._type}.${parentQualifiedName.payloadQualifiedName}.${designElement._name}`,
        designFullyQualifiedName: `${parentQualifiedName.designQualifiedName}.${designElement._name}`,
        qualifiedName: {
          payloadQualifiedName: `${parentQualifiedName.payloadQualifiedName}.${designElement._name}`,
          designQualifiedName: `${parentQualifiedName.designQualifiedName}.${designElement._name}`
        }
      };
    }
    function createInnerQualifiedNameFrom(metadata) {
      if (!metadata.__meta.runtimeData || metadata.__meta.runtimeData.qualifiedName === void 0 || metadata.__meta.runtimeData.partialQualifiedName === void 0) {
        return;
      }
      return {
        payloadFullyQualifiedName: metadata.__meta.runtimeData.qualifiedName,
        designFullyQualifiedName: metadata.__meta.qualifiedName,
        qualifiedName: {
          payloadQualifiedName: metadata.__meta.runtimeData.partialQualifiedName,
          designQualifiedName: metadata.__meta.qualifiedName
        }
      };
    }
    function joinNames(...names) {
      return names.filter((name) => !!name).join(".");
    }
    function createTopLevelQualifiedName(designElement, parentQualifiedName) {
      const designQualifiedName = joinNames(designElement._package, designElement._name);
      const payloadQualifiedName = joinNames(parentQualifiedName?.payloadQualifiedName, designElement._name);
      return {
        payloadFullyQualifiedName: `${designElement._type}.${payloadQualifiedName}`,
        designFullyQualifiedName: designQualifiedName,
        qualifiedName: {
          payloadQualifiedName,
          designQualifiedName
        }
      };
    }
  }
});

// ../../packages/xdm-schema/out/memory/model-element-metadata.js
var require_model_element_metadata = __commonJS({
  "../../packages/xdm-schema/out/memory/model-element-metadata.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createModelElementMetadataService = createModelElementMetadataService;
    var qualified_name_1 = require_qualified_name();
    var ModelElementMetadataServiceImpl = class {
      indexer;
      filePath;
      constructor(indexer, filePath) {
        this.indexer = indexer;
        this.filePath = filePath;
      }
      createForTopLevel(e) {
        return {
          __meta: {
            astLocation: "",
            filePath: this.filePath,
            modelName: e._package?.split(".", 1)[0],
            package: e._package,
            qualifiedName: (0, qualified_name_1.joinNames)(e._package, e._name),
            runtimeData: {
              qualifiedName: (0, qualified_name_1.joinNames)(e._type, e._name),
              partialQualifiedName: e._name
            }
          }
        };
      }
      createForInner(e, parent, query) {
        const qualifiedName = (0, qualified_name_1.joinNames)(parent.__meta.qualifiedName, e._name);
        const partialQualifiedName = (0, qualified_name_1.joinNames)(parent.__meta.runtimeData?.partialQualifiedName, e._name);
        return {
          __meta: {
            astLocation: `${parent.__meta.astLocation}.${query}`,
            filePath: this.filePath,
            modelName: parent.__meta.modelName,
            package: parent.__meta.package,
            qualifiedName,
            parentQualifiedName: parent.__meta.qualifiedName,
            runtimeData: {
              qualifiedName: (0, qualified_name_1.joinNames)(e._type, partialQualifiedName),
              partialQualifiedName
            }
          }
        };
      }
      createForExternalChild(e, parentQualifiedName) {
        const qualifiedName = (0, qualified_name_1.joinNames)(e._package, e._name);
        const parentSimpleName = parentQualifiedName?.split(".").pop();
        const modelName = e._package?.split(".", 1)[0];
        if (parentSimpleName === void 0) {
          return {
            __meta: {
              astLocation: "",
              filePath: this.filePath,
              modelName,
              package: e._package,
              qualifiedName,
              parentQualifiedName
            }
          };
        }
        const runtimePartialQualifiedName = (0, qualified_name_1.joinNames)(parentSimpleName, e._name);
        return {
          __meta: {
            astLocation: "",
            filePath: this.filePath,
            modelName,
            package: e._package,
            qualifiedName,
            parentQualifiedName,
            runtimeData: {
              qualifiedName: (0, qualified_name_1.joinNames)(e._type, runtimePartialQualifiedName),
              partialQualifiedName: runtimePartialQualifiedName,
              parentSimpleName
            }
          }
        };
      }
      indexTopLevel(element) {
        const metadata = this.createForTopLevel(element);
        const toIndex = {
          ...element,
          ...metadata
        };
        this.indexer.indexModelElement(toIndex);
        return toIndex;
      }
      indexInner(element, parent, query) {
        const metadata = this.createForInner(element, parent, query);
        const toIndex = {
          ...element,
          ...metadata
        };
        this.indexer.indexModelElement(toIndex);
        return toIndex;
      }
      indexExternalChild(element, parentQualifiedName) {
        const metadata = this.createForExternalChild(element, parentQualifiedName);
        const toIndex = {
          ...element,
          ...metadata
        };
        this.indexer.indexModelElement(toIndex);
        return toIndex;
      }
    };
    function createModelElementMetadataService(indexer, filePath) {
      return new ModelElementMetadataServiceImpl(indexer, filePath);
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/entity/entity_semql.js
var require_entity_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/entity/entity_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/entity/attribute_semql.js
var require_attribute_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/entity/attribute_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/entity/reference_semql.js
var require_reference_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/entity/reference_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/complex_type/complex_type_semql.js
var require_complex_type_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/complex_type/complex_type_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/view/view_semql.js
var require_view_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/view/view_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ViewType = void 0;
    var ViewType;
    (function(ViewType2) {
      ViewType2["GD"] = "GD";
      ViewType2["MD"] = "MD";
      ViewType2["SD"] = "SD";
      ViewType2["SA"] = "SA";
      ViewType2["SA4L"] = "SA4L";
      ViewType2["SA4LK"] = "SA4LK";
      ViewType2["SDWE"] = "SDWE";
      ViewType2["SE"] = "SE";
      ViewType2["SAWE"] = "SAWE";
      ViewType2["AE"] = "AE";
      ViewType2["GDWE"] = "GDWE";
      ViewType2["GE"] = "GE";
      ViewType2["MI"] = "MI";
      ViewType2["GI"] = "GI";
      ViewType2["DU"] = "DU";
      ViewType2["SD4L"] = "SD4L";
      ViewType2["SD4LK"] = "SD4LK";
      ViewType2["UM"] = "UM";
      ViewType2["UG"] = "UG";
      ViewType2["GX"] = "GX";
      ViewType2["MX"] = "MX";
      ViewType2["GH"] = "GH";
      ViewType2["MH"] = "MH";
      ViewType2["GH4B"] = "GH4B";
      ViewType2["MH4B"] = "MH4B";
      ViewType2["MS"] = "MS";
      ViewType2["JOB_MATCHING"] = "JOB_MATCHING";
      ViewType2["CONSOLIDATOR_INPUT"] = "CONSOLIDATOR_INPUT";
      ViewType2["CUSTOM"] = "CUSTOM";
    })(ViewType || (exports2.ViewType = ViewType = {}));
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/bind_variable/bind_variable_semql.js
var require_bind_variable_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/bind_variable/bind_variable_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CONTEXTUAL_VARIABLES = exports2.PLATFORM_VARIABLES = void 0;
    exports2.PLATFORM_VARIABLES = {
      V_USERNAME: {
        bindVariableName: "V_USERNAME"
      },
      V_USER_ROLES: {
        bindVariableName: "V_USER_ROLES"
      },
      V_DATAEDITION: {
        bindVariableName: "V_DATAEDITION"
      },
      V_DATABRANCH: {
        bindVariableName: "V_DATABRANCH"
      },
      V_USER_FIRSTNAME: {
        bindVariableName: "V_USER_FIRSTNAME"
      },
      V_USER_LASTNAME: {
        bindVariableName: "V_USER_LASTNAME"
      },
      V_USER_EMAIL: {
        bindVariableName: "V_USER_EMAIL"
      },
      V_USER_PRIMARY_PHONE: {
        bindVariableName: "V_USER_PRIMARY_PHONE"
      },
      V_USER_SECONDARY_PHONE: {
        bindVariableName: "V_USER_SECONDARY_PHONE"
      },
      V_USER_JOB_TITLE: {
        bindVariableName: "V_USER_JOB_TITLE"
      },
      V_USER_DEPARTMENT: {
        bindVariableName: "V_USER_DEPARTMENT"
      },
      V_USER_DEPARTEMENT: {
        bindVariableName: "V_USER_DEPARTEMENT"
      },
      V_USER_COMPANY_NAME: {
        bindVariableName: "V_USER_COMPANY_NAME"
      },
      V_USER_ADDRESS: {
        bindVariableName: "V_USER_ADDRESS"
      },
      V_USER_CITY: {
        bindVariableName: "V_USER_CITY"
      },
      V_USER_COUNTRY: {
        bindVariableName: "V_USER_COUNTRY"
      },
      V_USER_POSTAL_CODE: {
        bindVariableName: "V_USER_POSTAL_CODE"
      },
      V_USER_LANGUAGE: {
        bindVariableName: "V_USER_LANGUAGE"
      },
      V_USER_TIMEZONE: {
        bindVariableName: "V_USER_TIMEZONE"
      },
      V_USER_DECIMAL_SEPARATOR: {
        bindVariableName: "V_USER_DECIMAL_SEPARATOR"
      },
      V_USER_THOUSAND_SEPARATOR: {
        bindVariableName: "V_USER_THOUSAND_SEPARATOR"
      },
      V_SERVER_BASE_URL: {
        bindVariableName: "V_SERVER_BASE_URL"
      },
      V_DATALOCATION: {
        bindVariableName: "V_DATALOCATION"
      }
    };
    var V_LOADID = {
      V_LOADID: {
        bindVariableName: "V_LOADID"
      }
    };
    var V_BATCHID = {
      V_BATCHID: {
        bindVariableName: "V_BATCHID"
      }
    };
    var V_BATCHSUBMITDATE = {
      V_BATCHSUBMITDATE: {
        bindVariableName: "V_BATCHSUBMITDATE"
      }
    };
    exports2.CONTEXTUAL_VARIABLES = {
      V_LOADID,
      V_BATCHID,
      V_BATCHSUBMITDATE
    };
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/function/oracle_functions.js
var require_oracle_functions = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/function/oracle_functions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.oracleFunctions = void 0;
    exports2.oracleFunctions = {
      ABS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ABS"
      },
      ACOS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ACOS"
      },
      ADD_MONTHS: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "ADD_MONTHS"
      },
      ASCII: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASCII"
      },
      ASCIISTR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASCIISTR"
      },
      ASIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASIN"
      },
      ATAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ATAN"
      },
      ATAN2: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "ATAN2"
      },
      BIN_TO_NUM: {
        minParameters: 0,
        maxParameters: Infinity,
        functionName: "BIN_TO_NUM"
      },
      BITAND: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "BITAND"
      },
      CEIL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CEIL"
      },
      CHR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CHR"
      },
      COALESCE: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "COALESCE"
      },
      COMPOSE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COMPOSE"
      },
      CONCAT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "CONCAT"
      },
      CONVERT: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "CONVERT"
      },
      COS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COS"
      },
      COSH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COSH"
      },
      CURRENT_DATE: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "CURRENT_DATE"
      },
      CURRENT_TIMESTAMP: {
        minParameters: 0,
        maxParameters: 1,
        functionName: "CURRENT_TIMESTAMP"
      },
      DBTIMEZONE: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "DBTIMEZONE"
      },
      DECODE: {
        minParameters: 2,
        maxParameters: Infinity,
        functionName: "DECODE"
      },
      DECOMPOSE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DECOMPOSE"
      },
      EXP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXP"
      },
      EXTRACT_YEAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_YEAR"
      },
      EXTRACT_MONTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_MONTH"
      },
      EXTRACT_DAY: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_DAY"
      },
      EXTRACT_HOUR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_HOUR"
      },
      EXTRACT_MINUTE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_MINUTE"
      },
      EXTRACT_SECOND: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_SECOND"
      },
      EXTRACT_TIMEZONE_HOUR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_TIMEZONE_HOUR"
      },
      EXTRACT_TIMEZONE_MINUTE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_TIMEZONE_MINUTE"
      },
      EXTRACT_TIMEZONE_REGION: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_TIMEZONE_REGION"
      },
      EXTRACT_TIMEZONE_ABBR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXTRACT_TIMEZONE_ABBR"
      },
      FLOOR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "FLOOR"
      },
      FROM_TZ: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "FROM_TZ"
      },
      GREATEST: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "GREATEST"
      },
      HEXTORAW: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "HEXTORAW"
      },
      INITCAP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "INITCAP"
      },
      INSTR: {
        minParameters: 2,
        maxParameters: 4,
        functionName: "INSTR"
      },
      INSTR2: {
        minParameters: 2,
        maxParameters: 4,
        functionName: "INSTR2"
      },
      INSTR4: {
        minParameters: 2,
        maxParameters: 4,
        functionName: "INSTR4"
      },
      INSTRB: {
        minParameters: 2,
        maxParameters: 4,
        functionName: "INSTRB"
      },
      INSTRC: {
        minParameters: 2,
        maxParameters: 4,
        functionName: "INSTRC"
      },
      LAST_DAY: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LAST_DAY"
      },
      LEAST: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "LEAST"
      },
      LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LENGTH"
      },
      LENGTH2: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LENGTH2"
      },
      LENGTH4: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LENGTH4"
      },
      LENGTHB: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LENGTHB"
      },
      LENGTHC: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LENGTHC"
      },
      LN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LN"
      },
      LOCALTIMESTAMP: {
        minParameters: 0,
        maxParameters: 1,
        functionName: "LOCALTIMESTAMP"
      },
      LOG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "LOG"
      },
      LOWER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOWER"
      },
      LPAD: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "LPAD"
      },
      LTRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "LTRIM"
      },
      MOD: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "MOD"
      },
      MONTHS_BETWEEN: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "MONTHS_BETWEEN"
      },
      NCHR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "NCHR"
      },
      NEW_TIME: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "NEW_TIME"
      },
      NEXT_DAY: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NEXT_DAY"
      },
      NANVL: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NANVL"
      },
      NLS_INITCAP: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "NLS_INITCAP"
      },
      NLS_LOWER: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "NLS_LOWER"
      },
      NLS_UPPER: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "NLS_UPPER"
      },
      NLSSORT: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "NLSSORT"
      },
      NULLIF: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NULLIF"
      },
      NUMTODSINTERVAL: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NUMTODSINTERVAL"
      },
      NUMTOYMINTERVAL: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NUMTOYMINTERVAL"
      },
      NVL: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NVL"
      },
      NVL2: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "NVL2"
      },
      ORA_HASH: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "ORA_HASH"
      },
      POWER: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "POWER"
      },
      RAWTOHEX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "RAWTOHEX"
      },
      REGEXP_COUNT: {
        minParameters: 2,
        maxParameters: 4,
        functionName: "REGEXP_COUNT"
      },
      REGEXP_INSTR: {
        minParameters: 2,
        maxParameters: 7,
        functionName: "REGEXP_INSTR"
      },
      REGEXP_REPLACE: {
        minParameters: 2,
        maxParameters: 6,
        functionName: "REGEXP_REPLACE"
      },
      REGEXP_SUBSTR: {
        minParameters: 2,
        maxParameters: 6,
        functionName: "REGEXP_SUBSTR"
      },
      REMAINDER: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "REMAINDER"
      },
      REPLACE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "REPLACE"
      },
      ROUND: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "ROUND"
      },
      RPAD: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "RPAD"
      },
      RTRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "RTRIM"
      },
      TRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TRIM"
      },
      SIGN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIGN"
      },
      SIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIN"
      },
      SINH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SINH"
      },
      SOUNDEX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SOUNDEX"
      },
      SQRT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SQRT"
      },
      STANDARD_HASH: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "STANDARD_HASH"
      },
      SUBSTR: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SUBSTR"
      },
      SEM_SUBSTRING: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SEM_SUBSTRING"
      },
      SUBSTR2: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SUBSTR2"
      },
      SUBSTR4: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SUBSTR4"
      },
      SUBSTRB: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SUBSTRB"
      },
      SUBSTRC: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SUBSTRC"
      },
      SYSDATE: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "SYSDATE"
      },
      SYSTIMESTAMP: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "SYSTIMESTAMP"
      },
      SYS_CONTEXT: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SYS_CONTEXT"
      },
      SYS_EXTRACT_UTC: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SYS_EXTRACT_UTC"
      },
      SYS_GUID: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "SYS_GUID"
      },
      TAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TAN"
      },
      TANH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TANH"
      },
      TO_BINARY_DOUBLE: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "TO_BINARY_DOUBLE"
      },
      TO_BINARY_FLOAT: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "TO_BINARY_FLOAT"
      },
      TO_CHAR: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "TO_CHAR"
      },
      TO_CLOB: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TO_CLOB"
      },
      TO_DATE: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "TO_DATE"
      },
      TO_DSINTERVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TO_DSINTERVAL"
      },
      TO_MULTI_BYTE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TO_MULTI_BYTE"
      },
      TO_NUMBER: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "TO_NUMBER"
      },
      TO_SINGLE_BYTE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TO_SINGLE_BYTE"
      },
      TO_TIMESTAMP: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "TO_TIMESTAMP"
      },
      TO_TIMESTAMP_TZ: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "TO_TIMESTAMP_TZ"
      },
      TO_YMINTERVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TO_YMINTERVAL"
      },
      TRANSLATE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "TRANSLATE"
      },
      TRUNC: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TRUNC"
      },
      UNISTR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UNISTR"
      },
      UPPER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UPPER"
      },
      WIDTH_BUCKET: {
        minParameters: 4,
        maxParameters: 4,
        functionName: "WIDTH_BUCKET"
      },
      SEM_UUID_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_UUID_TO_CHAR"
      },
      SEM_DATE_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_DATE_TO_CHAR"
      },
      SEM_TIMESTAMP_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TIMESTAMP_TO_CHAR"
      },
      SEM_NUMBER_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NUMBER_TO_CHAR"
      },
      SEM_BOOLEAN_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_BOOLEAN_TO_CHAR"
      },
      SEM_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR"
      },
      SEM_TO_CHAR2: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR2"
      },
      SEM_INSTR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_INSTR"
      },
      SEM_EDIT_DISTANCE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE"
      },
      SEM_NGRAMS_SIMILARITY: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SEM_NGRAMS_SIMILARITY"
      },
      SEM_EDIT_DISTANCE_SIMILARITY: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE_SIMILARITY"
      },
      SEM_JARO_WINKLER: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_JARO_WINKLER"
      },
      SEM_JARO_WINKLER_SIMILARITY: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_JARO_WINKLER_SIMILARITY"
      },
      SEM_NORMALIZE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NORMALIZE"
      },
      SEQ_NEXTVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEQ_NEXTVAL"
      },
      SEM_CONCAT: {
        minParameters: 3,
        maxParameters: Infinity,
        functionName: "SEM_CONCAT"
      },
      AVG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "AVG"
      },
      COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COUNT"
      },
      DISTINCT_COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DISTINCT_COUNT"
      },
      CORR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "CORR"
      },
      MAX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MAX"
      },
      MEDIAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MEDIAN"
      },
      MIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MIN"
      },
      SUM: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SUM"
      }
    };
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/function/postgres_functions.js
var require_postgres_functions = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/function/postgres_functions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.postgresFunctions = void 0;
    exports2.postgresFunctions = {
      ARRAY_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ARRAY_AGG"
      },
      AVG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "AVG"
      },
      COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COUNT"
      },
      DISTINCT_COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DISTINCT_COUNT"
      },
      MAX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MAX"
      },
      MIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MIN"
      },
      SUM: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SUM"
      },
      STRING_AGG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "STRING_AGG"
      },
      BIT_LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BIT_LENGTH"
      },
      CHAR_LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CHAR_LENGTH"
      },
      LOWER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOWER"
      },
      OCTET_LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "OCTET_LENGTH"
      },
      OVERLAY: {
        minParameters: 3,
        maxParameters: 4,
        functionName: "OVERLAY"
      },
      SUBSTRING_REGEX_PATTERN: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SUBSTRING_REGEX_PATTERN"
      },
      SUBSTRING_SQL_PATTERN: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "SUBSTRING_SQL_PATTERN"
      },
      UPPER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UPPER"
      },
      ASCII: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASCII"
      },
      BTRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "BTRIM"
      },
      CHR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CHR"
      },
      CONCAT: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "CONCAT"
      },
      CONCAT_WS: {
        minParameters: 2,
        maxParameters: Infinity,
        functionName: "CONCAT_WS"
      },
      CONVERT: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "CONVERT"
      },
      CONVERT_FROM: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "CONVERT_FROM"
      },
      CONVERT_TO: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "CONVERT_TO"
      },
      DECODE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DECODE"
      },
      ENCODE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "ENCODE"
      },
      FORMAT: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "FORMAT"
      },
      INITCAP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "INITCAP"
      },
      LEFT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "LEFT"
      },
      LENGTH: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "LENGTH"
      },
      LPAD: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "LPAD"
      },
      LTRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "LTRIM"
      },
      MD5: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MD5"
      },
      QUOTE_IDENT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "QUOTE_IDENT"
      },
      QUOTE_LITERAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "QUOTE_LITERAL"
      },
      QUOTE_NULLABLE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "QUOTE_NULLABLE"
      },
      SOUNDEX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SOUNDEX"
      },
      DIFFERENCE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DIFFERENCE"
      },
      METAPHONE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "METAPHONE"
      },
      DMETAPHONE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DMETAPHONE"
      },
      REGEXP_MATCH: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "REGEXP_MATCH"
      },
      REGEXP_REPLACE: {
        minParameters: 3,
        maxParameters: 4,
        functionName: "REGEXP_REPLACE"
      },
      REGEXP_SPLIT_TO_ARRAY: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "REGEXP_SPLIT_TO_ARRAY"
      },
      REPEAT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "REPEAT"
      },
      REPLACE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "REPLACE"
      },
      REVERSE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "REVERSE"
      },
      RIGHT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "RIGHT"
      },
      RPAD: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "RPAD"
      },
      RTRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "RTRIM"
      },
      SPLIT_PART: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "SPLIT_PART"
      },
      STRPOS: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "STRPOS"
      },
      SUBSTR: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SUBSTR"
      },
      TRANSLATE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "TRANSLATE"
      },
      NUM_NONNULLS: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "NUM_NONNULLS"
      },
      NUM_NULLS: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "NUM_NULLS"
      },
      GREATEST: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "GREATEST"
      },
      LEAST: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "LEAST"
      },
      TO_ASCII: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TO_ASCII"
      },
      TO_HEX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TO_HEX"
      },
      TO_CHAR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "TO_CHAR"
      },
      TO_DATE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "TO_DATE"
      },
      TO_NUMBER: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "TO_NUMBER"
      },
      TO_TIMESTAMP: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "TO_TIMESTAMP"
      },
      AGE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "AGE"
      },
      CLOCK_TIMESTAMP: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "CLOCK_TIMESTAMP"
      },
      CURRENT_DATE: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "CURRENT_DATE"
      },
      CURRENT_TIME: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "CURRENT_TIME"
      },
      CURRENT_TIMESTAMP: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "CURRENT_TIMESTAMP"
      },
      DATE_PART: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DATE_PART"
      },
      DATE_TRUNC: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DATE_TRUNC"
      },
      ISFINITE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ISFINITE"
      },
      JUSTIFY_DAYS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "JUSTIFY_DAYS"
      },
      JUSTIFY_HOURS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "JUSTIFY_HOURS"
      },
      JUSTIFY_INTERVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "JUSTIFY_INTERVAL"
      },
      LOCALTIME: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "LOCALTIME"
      },
      LOCALTIMESTAMP: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "LOCALTIMESTAMP"
      },
      MAKE_DATE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "MAKE_DATE"
      },
      MAKE_INTERVAL: {
        minParameters: 7,
        maxParameters: 7,
        functionName: "MAKE_INTERVAL"
      },
      MAKE_TIME: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "MAKE_TIME"
      },
      MAKE_TIMESTAMP: {
        minParameters: 6,
        maxParameters: 6,
        functionName: "MAKE_TIMESTAMP"
      },
      MAKE_TIMESTAMPTZ: {
        minParameters: 6,
        maxParameters: 7,
        functionName: "MAKE_TIMESTAMPTZ"
      },
      NOW: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "NOW"
      },
      STATEMENT_TIMESTAMP: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "STATEMENT_TIMESTAMP"
      },
      TIMEOFDAY: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "TIMEOFDAY"
      },
      TRANSACTION_TIMESTAMP: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "TRANSACTION_TIMESTAMP"
      },
      BIT_AND: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BIT_AND"
      },
      BIT_OR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BIT_OR"
      },
      BOOL_AND: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BOOL_AND"
      },
      BOOL_OR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BOOL_OR"
      },
      EVERY: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EVERY"
      },
      JSON_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "JSON_AGG"
      },
      JSONB_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "JSONB_AGG"
      },
      JSON_OBJECT_AGG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "JSON_OBJECT_AGG"
      },
      JSONB_OBJECT_AGG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "JSONB_OBJECT_AGG"
      },
      XMLAGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "XMLAGG"
      },
      GET_BIT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "GET_BIT"
      },
      GET_BYTE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "GET_BYTE"
      },
      SET_BIT: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "SET_BIT"
      },
      SET_BYTE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "SET_BYTE"
      },
      CURRVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CURRVAL"
      },
      LASTVAL: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "LASTVAL"
      },
      NEXTVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "NEXTVAL"
      },
      SETVAL: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SETVAL"
      },
      INT4RANGE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "INT4RANGE"
      },
      INT8RANGE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "INT8RANGE"
      },
      NUMRANGE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "NUMRANGE"
      },
      TSRANGE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "TSRANGE"
      },
      TSTZRANGE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "TSTZRANGE"
      },
      DATERANGE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "DATERANGE"
      },
      RANGE_LOWER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "RANGE_LOWER"
      },
      RANGE_UPPER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "RANGE_UPPER"
      },
      ISEMPTY: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ISEMPTY"
      },
      LOWER_INC: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOWER_INC"
      },
      UPPER_INC: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UPPER_INC"
      },
      LOWER_INF: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOWER_INF"
      },
      UPPER_INF: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UPPER_INF"
      },
      RANGE_MERGE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "RANGE_MERGE"
      },
      COALESCE: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "COALESCE"
      },
      NULLIF: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NULLIF"
      },
      ABS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ABS"
      },
      CBRT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CBRT"
      },
      CEIL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CEIL"
      },
      CEILING: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CEILING"
      },
      DEGREES: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DEGREES"
      },
      DIV: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DIV"
      },
      EXP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXP"
      },
      FLOOR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "FLOOR"
      },
      LN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LN"
      },
      LOG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOG"
      },
      MOD: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "MOD"
      },
      PI: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "PI"
      },
      POWER: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "POWER"
      },
      RADIANS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "RADIANS"
      },
      ROUND: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "ROUND"
      },
      SCALE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SCALE"
      },
      SIGN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIGN"
      },
      SQRT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SQRT"
      },
      TRUNC: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TRUNC"
      },
      WIDTH_BUCKET: {
        minParameters: 4,
        maxParameters: 4,
        functionName: "WIDTH_BUCKET"
      },
      WIDTH_BUCKET_THRESHOLDS: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "WIDTH_BUCKET_THRESHOLDS"
      },
      RANDOM: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "RANDOM"
      },
      SETSEED: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SETSEED"
      },
      ACOS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ACOS"
      },
      ASIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASIN"
      },
      ATAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ATAN"
      },
      ATAN2: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "ATAN2"
      },
      COS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COS"
      },
      COT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COT"
      },
      SIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIN"
      },
      TAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TAN"
      },
      SEM_SUBSTRING: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SEM_SUBSTRING"
      },
      SEM_CAST_STRING: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_STRING"
      },
      SEM_CAST_NUMERIC: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_NUMERIC"
      },
      SEM_CAST_INTEGER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_INTEGER"
      },
      SEM_CAST_BOOLEAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_BOOLEAN"
      },
      SEM_CAST_TIMESTAMP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_TIMESTAMP"
      },
      SEM_CAST_DATE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_DATE"
      },
      SEM_CAST_UUID: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_UUID"
      },
      SEM_UUID_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_UUID_TO_CHAR"
      },
      SEM_DATE_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_DATE_TO_CHAR"
      },
      SEM_TIMESTAMP_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TIMESTAMP_TO_CHAR"
      },
      SEM_NUMBER_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NUMBER_TO_CHAR"
      },
      SEM_BOOLEAN_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_BOOLEAN_TO_CHAR"
      },
      SEM_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR"
      },
      SEM_TO_CHAR2: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR2"
      },
      SEM_INSTR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_INSTR"
      },
      SEM_EDIT_DISTANCE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE"
      },
      SEM_NGRAMS_SIMILARITY: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SEM_NGRAMS_SIMILARITY"
      },
      SEM_EDIT_DISTANCE_SIMILARITY: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE_SIMILARITY"
      },
      LEVENSHTEIN: {
        minParameters: 5,
        maxParameters: 5,
        functionName: "LEVENSHTEIN"
      },
      LEVENSHTEIN_LESS_EQUAL: {
        minParameters: 6,
        maxParameters: 6,
        functionName: "LEVENSHTEIN_LESS_EQUAL"
      },
      DMETAPHONE_ALT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DMETAPHONE_ALT"
      },
      SEM_NORMALIZE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NORMALIZE"
      },
      SEQ_NEXTVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEQ_NEXTVAL"
      },
      SEM_CONCAT: {
        minParameters: 3,
        maxParameters: Infinity,
        functionName: "SEM_CONCAT"
      }
    };
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/function/snowflake_functions.js
var require_snowflake_functions = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/function/snowflake_functions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.snowflakeFunctions = void 0;
    exports2.snowflakeFunctions = {
      ARRAY_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ARRAY_AGG"
      },
      AVG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "AVG"
      },
      COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COUNT"
      },
      DISTINCT_COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DISTINCT_COUNT"
      },
      MAX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MAX"
      },
      MIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MIN"
      },
      SUM: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SUM"
      },
      LISTAGG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "LISTAGG"
      },
      BIT_LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BIT_LENGTH"
      },
      LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LENGTH"
      },
      LOWER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOWER"
      },
      OCTET_LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "OCTET_LENGTH"
      },
      REGEXP_SUBSTR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "REGEXP_SUBSTR"
      },
      UPPER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UPPER"
      },
      ASCII: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASCII"
      },
      TRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TRIM"
      },
      CHR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CHR"
      },
      CONCAT: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "CONCAT"
      },
      CONCAT_WS: {
        minParameters: 2,
        maxParameters: Infinity,
        functionName: "CONCAT_WS"
      },
      BASE64_DECODE_STRING: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BASE64_DECODE_STRING"
      },
      BASE64_ENCODE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BASE64_ENCODE"
      },
      HEX_DECODE_STRING: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "HEX_DECODE_STRING"
      },
      HEX_ENCODE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "HEX_ENCODE"
      },
      INITCAP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "INITCAP"
      },
      LEFT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "LEFT"
      },
      LPAD: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "LPAD"
      },
      LTRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "LTRIM"
      },
      MD5: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MD5"
      },
      SOUNDEX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SOUNDEX"
      },
      REGEXP_REPLACE: {
        minParameters: 2,
        maxParameters: 6,
        functionName: "REGEXP_REPLACE"
      },
      REPEAT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "REPEAT"
      },
      REPLACE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "REPLACE"
      },
      REVERSE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "REVERSE"
      },
      RIGHT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "RIGHT"
      },
      RPAD: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "RPAD"
      },
      RTRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "RTRIM"
      },
      SPLIT_PART: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "SPLIT_PART"
      },
      POSITION: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "POSITION"
      },
      SUBSTR: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SUBSTR"
      },
      TRANSLATE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "TRANSLATE"
      },
      GREATEST: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "GREATEST"
      },
      LEAST: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "LEAST"
      },
      TO_DATE: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TO_DATE"
      },
      TO_NUMBER: {
        minParameters: 1,
        maxParameters: 4,
        functionName: "TO_NUMBER"
      },
      TO_TIMESTAMP: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TO_TIMESTAMP"
      },
      DATEDIFF: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "DATEDIFF"
      },
      CURRENT_DATE: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "CURRENT_DATE"
      },
      CURRENT_TIME: {
        minParameters: 0,
        maxParameters: 1,
        functionName: "CURRENT_TIME"
      },
      CURRENT_TIMESTAMP: {
        minParameters: 0,
        maxParameters: 1,
        functionName: "CURRENT_TIMESTAMP"
      },
      DATE_PART: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DATE_PART"
      },
      DATE_TRUNC: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DATE_TRUNC"
      },
      LOCALTIME: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "LOCALTIME"
      },
      LOCALTIMESTAMP: {
        minParameters: 0,
        maxParameters: 1,
        functionName: "LOCALTIMESTAMP"
      },
      BITAND: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "BITAND"
      },
      BITOR: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "BITOR"
      },
      BOOLAND: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "BOOLAND"
      },
      BOOLOR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "BOOLOR"
      },
      BITAND_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BITAND_AGG"
      },
      BITOR_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BITOR_AGG"
      },
      BOOLAND_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BOOLAND_AGG"
      },
      BOOLOR_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "BOOLOR_AGG"
      },
      OBJECT_AGG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "OBJECT_AGG"
      },
      GETBIT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "GETBIT"
      },
      COALESCE: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "COALESCE"
      },
      NULLIF: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NULLIF"
      },
      ABS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ABS"
      },
      CBRT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CBRT"
      },
      CEIL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CEIL"
      },
      DEGREES: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DEGREES"
      },
      DIV0: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DIV0"
      },
      EXP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXP"
      },
      FLOOR: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "FLOOR"
      },
      LN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LN"
      },
      LOG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "LOG"
      },
      MOD: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "MOD"
      },
      PI: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "PI"
      },
      POWER: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "POWER"
      },
      RADIANS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "RADIANS"
      },
      ROUND: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "ROUND"
      },
      SIGN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIGN"
      },
      SQRT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SQRT"
      },
      TRUNC: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "TRUNC"
      },
      WIDTH_BUCKET: {
        minParameters: 4,
        maxParameters: 4,
        functionName: "WIDTH_BUCKET"
      },
      RANDOM: {
        minParameters: 0,
        maxParameters: 1,
        functionName: "RANDOM"
      },
      ACOS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ACOS"
      },
      ASIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASIN"
      },
      ATAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ATAN"
      },
      ATAN2: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "ATAN2"
      },
      COS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COS"
      },
      COT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COT"
      },
      SIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIN"
      },
      TAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TAN"
      },
      SEM_SUBSTRING: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SEM_SUBSTRING"
      },
      SEM_CAST_STRING: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_STRING"
      },
      SEM_CAST_NUMERIC: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_NUMERIC"
      },
      SEM_CAST_INTEGER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_INTEGER"
      },
      SEM_CAST_BOOLEAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_BOOLEAN"
      },
      SEM_CAST_TIMESTAMP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_TIMESTAMP"
      },
      SEM_CAST_DATE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_DATE"
      },
      SEM_DATE_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_DATE_TO_CHAR"
      },
      SEM_TIMESTAMP_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TIMESTAMP_TO_CHAR"
      },
      SEM_NUMBER_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NUMBER_TO_CHAR"
      },
      SEM_BOOLEAN_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_BOOLEAN_TO_CHAR"
      },
      SEM_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR"
      },
      SEM_TO_CHAR2: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR2"
      },
      SEM_INSTR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_INSTR"
      },
      SEM_EDIT_DISTANCE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE"
      },
      SEM_JARO_WINKLER_SIMILARITY: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_JARO_WINKLER_SIMILARITY"
      },
      SEM_EDIT_DISTANCE_SIMILARITY: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE_SIMILARITY"
      },
      EDITDISTANCE: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "EDITDISTANCE"
      },
      SEM_NORMALIZE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NORMALIZE"
      },
      SEQ_NEXTVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEQ_NEXTVAL"
      },
      SEM_CONCAT: {
        minParameters: 3,
        maxParameters: Infinity,
        functionName: "SEM_CONCAT"
      }
    };
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/function/sqlserver_functions.js
var require_sqlserver_functions = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/function/sqlserver_functions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sqlServerFunctions = void 0;
    exports2.sqlServerFunctions = {
      SEQ_NEXTVAL: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEQ_NEXTVAL"
      },
      LPAD: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "LPAD"
      },
      SEM_NORMALIZE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NORMALIZE"
      },
      SEM_SUBSTRING: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SEM_SUBSTRING"
      },
      SEM_INSTR: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_INSTR"
      },
      SEM_EDIT_DISTANCE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE"
      },
      SEM_EDIT_DISTANCE_SIMILARITY: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "SEM_EDIT_DISTANCE_SIMILARITY"
      },
      LENGTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LENGTH"
      },
      SEM_UUID_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_UUID_TO_CHAR"
      },
      SEM_DATE_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_DATE_TO_CHAR"
      },
      SEM_TIMESTAMP_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TIMESTAMP_TO_CHAR"
      },
      SEM_BOOLEAN_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_BOOLEAN_TO_CHAR"
      },
      SEM_NUMBER_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_NUMBER_TO_CHAR"
      },
      SEM_TO_CHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR"
      },
      SEM_TO_CHAR2: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_TO_CHAR2"
      },
      SEM_NGRAMS_SIMILARITY: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "SEM_NGRAMS_SIMILARITY"
      },
      SEM_CONCAT: {
        minParameters: 3,
        maxParameters: Infinity,
        functionName: "SEM_CONCAT"
      },
      SEM_CAST_NUMERIC: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SEM_CAST_NUMERIC"
      },
      COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COUNT"
      },
      DISTINCT_COUNT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DISTINCT_COUNT"
      },
      AVG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "AVG"
      },
      APPROX_COUNT_DISTINCT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "APPROX_COUNT_DISTINCT"
      },
      CHECKSUM_AGG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CHECKSUM_AGG"
      },
      MAX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MAX"
      },
      MIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MIN"
      },
      STDEV: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "STDEV"
      },
      STDEVP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "STDEVP"
      },
      SUM: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SUM"
      },
      VAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "VAR"
      },
      VARP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "VARP"
      },
      ABS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ABS"
      },
      ACOS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ACOS"
      },
      ASIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASIN"
      },
      ATAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ATAN"
      },
      ATN2: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "ATN2"
      },
      CEILING: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "CEILING"
      },
      COS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COS"
      },
      COT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "COT"
      },
      DEGREES: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DEGREES"
      },
      EXP: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "EXP"
      },
      FLOOR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "FLOOR"
      },
      LOG: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOG"
      },
      LOG10: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOG10"
      },
      PI: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "PI"
      },
      POWER: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "POWER"
      },
      RADIANS: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "RADIANS"
      },
      RAND: {
        minParameters: 0,
        maxParameters: 1,
        functionName: "RAND"
      },
      ROUND: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "ROUND"
      },
      SIGN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIGN"
      },
      SIN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SIN"
      },
      SQRT: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SQRT"
      },
      SQUARE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SQUARE"
      },
      TAN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "TAN"
      },
      DATEADD: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "DATEADD"
      },
      DATEDIFF: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "DATEDIFF"
      },
      DATEFROMPARTS: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "DATEFROMPARTS"
      },
      DATENAME: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DATENAME"
      },
      DATEPART: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DATEPART"
      },
      DATETIME2FROMPARTS: {
        minParameters: 8,
        maxParameters: 8,
        functionName: "DATETIME2FROMPARTS"
      },
      DAY: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "DAY"
      },
      EOMONTH: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "EOMONTH"
      },
      GETDATE: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "GETDATE"
      },
      ISDATE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ISDATE"
      },
      MONTH: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "MONTH"
      },
      SYSDATETIME: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "SYSDATETIME"
      },
      YEAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "YEAR"
      },
      ASCII: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "ASCII"
      },
      NCHAR: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "NCHAR"
      },
      CHARINDEX: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "CHARINDEX"
      },
      CONCAT: {
        minParameters: 2,
        maxParameters: Infinity,
        functionName: "CONCAT"
      },
      DIFFERENCE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "DIFFERENCE"
      },
      FORMAT: {
        minParameters: 2,
        maxParameters: 3,
        functionName: "FORMAT"
      },
      LEFT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "LEFT"
      },
      LEN: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LEN"
      },
      LOWER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LOWER"
      },
      LTRIM: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "LTRIM"
      },
      PATINDEX: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "PATINDEX"
      },
      QUOTENAME: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "QUOTENAME"
      },
      REPLACE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "REPLACE"
      },
      REPLICATE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "REPLICATE"
      },
      REVERSE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "REVERSE"
      },
      RIGHT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "RIGHT"
      },
      RTRIM: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "RTRIM"
      },
      SOUNDEX: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SOUNDEX"
      },
      SPACE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "SPACE"
      },
      STR: {
        minParameters: 1,
        maxParameters: 3,
        functionName: "STR"
      },
      STRING_AGG: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "STRING_AGG"
      },
      STRING_ESCAPE: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "STRING_ESCAPE"
      },
      STRING_SPLIT: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "STRING_SPLIT"
      },
      STUFF: {
        minParameters: 4,
        maxParameters: 4,
        functionName: "STUFF"
      },
      SUBSTRING: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "SUBSTRING"
      },
      TRANSLATE: {
        minParameters: 3,
        maxParameters: 3,
        functionName: "TRANSLATE"
      },
      TRIM: {
        minParameters: 1,
        maxParameters: 2,
        functionName: "TRIM"
      },
      UNICODE: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UNICODE"
      },
      UPPER: {
        minParameters: 1,
        maxParameters: 1,
        functionName: "UPPER"
      },
      COALESCE: {
        minParameters: 1,
        maxParameters: Infinity,
        functionName: "COALESCE"
      },
      NULLIF: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "NULLIF"
      },
      ISNULL: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "ISNULL"
      },
      HASHBYTES: {
        minParameters: 2,
        maxParameters: 2,
        functionName: "HASHBYTES"
      },
      NEWID: {
        minParameters: 0,
        maxParameters: 0,
        functionName: "NEWID"
      },
      CHOOSE: {
        minParameters: 3,
        maxParameters: Infinity,
        functionName: "CHOOSE"
      }
    };
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/function/function_semql.js
var require_function_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/function/function_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.BUILTIN_FUNCTIONS = void 0;
    var oracle_functions_1 = require_oracle_functions();
    var postgres_functions_1 = require_postgres_functions();
    var snowflake_functions_1 = require_snowflake_functions();
    var sqlserver_functions_1 = require_sqlserver_functions();
    exports2.BUILTIN_FUNCTIONS = {
      ORACLE: oracle_functions_1.oracleFunctions,
      POSTGRES: postgres_functions_1.postgresFunctions,
      SNOWFLAKE: snowflake_functions_1.snowflakeFunctions,
      SQL_SERVER: sqlserver_functions_1.sqlServerFunctions
    };
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/database_type_semql.js
var require_database_type_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/database_type_semql.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromDatabaseTypeDesign = fromDatabaseTypeDesign;
    function fromDatabaseTypeDesign(databaseTypeDesign) {
      switch (databaseTypeDesign) {
        case "ORACLE": {
          return "ORACLE";
        }
        case "POSTGRESQL": {
          return "POSTGRES";
        }
        case "SQLSERVER": {
          return "SQL_SERVER";
        }
        case "SNOWFLAKE": {
          return "SNOWFLAKE";
        }
      }
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/model/index.js
var require_model = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/model/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar2(require_entity_semql(), exports2);
    __exportStar2(require_attribute_semql(), exports2);
    __exportStar2(require_reference_semql(), exports2);
    __exportStar2(require_complex_type_semql(), exports2);
    __exportStar2(require_view_semql(), exports2);
    __exportStar2(require_bind_variable_semql(), exports2);
    __exportStar2(require_function_semql(), exports2);
    __exportStar2(require_database_type_semql(), exports2);
  }
});

// ../../packages/xdm-schema/out/memory/semql/index.js
var require_semql = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar2(require_model(), exports2);
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/bind_variable/bind_variable_semql_mapper.js
var require_bind_variable_semql_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/bind_variable/bind_variable_semql_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapBindVariableSemql = mapBindVariableSemql;
    function mapBindVariableSemql(modelVariable) {
      return {
        bindVariableName: modelVariable.modelElement._name
      };
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/indexer/bind_variable/bind_variable_semql_indexer.js
var require_bind_variable_semql_indexer = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/indexer/bind_variable/bind_variable_semql_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexBindVariableSemql = indexBindVariableSemql;
    var bind_variable_semql_mapper_1 = require_bind_variable_semql_mapper();
    function indexBindVariableSemql(modelVariable, semqlIndexer) {
      semqlIndexer.indexBindVariable((0, bind_variable_semql_mapper_1.mapBindVariableSemql)(modelVariable));
    }
  }
});

// ../../packages/xdm-schema/out/design/entity-attribute-design.js
var require_entity_attribute_design = __commonJS({
  "../../packages/xdm-schema/out/design/entity-attribute-design.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.builtInTypes = void 0;
    var allBuiltInTypes = [
      "Binary",
      "Boolean",
      "ByteInteger",
      "Date",
      "Decimal",
      "Integer",
      "LongInteger",
      "LongText",
      "ShortInteger",
      "String",
      "Timestamp",
      "UUID"
    ];
    exports2.builtInTypes = new Set(allBuiltInTypes);
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/entity/attribute_semql_mapper.js
var require_attribute_semql_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/entity/attribute_semql_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapEntityAttributes = mapEntityAttributes;
    var entity_attribute_design_1 = require_entity_attribute_design();
    var top_level_1 = require_top_level();
    function mapEntityAttributes(entity, memoryModel) {
      const result = {
        pk: null,
        atomic: [],
        complex: []
      };
      const { qualifiedName } = memoryModel.findTopLevelQualifiedName(entity);
      for (const attr of entity.attributes) {
        const { designFullyQualifiedName } = memoryModel.findInnerQualifiedName(qualifiedName, attr);
        if (entity.primaryKey === designFullyQualifiedName) {
          result.pk = {
            attributeName: attr._name
          };
        } else if (entity_attribute_design_1.builtInTypes.has(attr.dataType)) {
          result.atomic.push({ attributeName: attr._name });
        } else {
          const dataTypeElement = memoryModel.findIndexedModelElementByQualifiedName(attr.dataType);
          if (dataTypeElement) {
            if (dataTypeElement.modelElement._type === top_level_1.TOP_LEVEL_ENUM.MODEL_COMPLEX_TYPE) {
              result.complex.push({
                attributeName: attr._name,
                complexName: dataTypeElement.modelElement._name
              });
            } else {
              result.atomic.push({ attributeName: attr._name });
            }
          }
        }
      }
      return result;
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/entity/reference_semql_mapper.js
var require_reference_semql_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/entity/reference_semql_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapReferenceToAttributesSemql = mapReferenceToAttributesSemql;
    exports2.mapReferenceFromAttributesSemql = mapReferenceFromAttributesSemql;
    function mapReferenceToAttributesSemql(entity, entitySemqlProxies, memoryModel) {
      const references = memoryModel.findModelElementsByTypes([
        "Reference"
      ]);
      const referenceAttributes = references.filter((reference) => reference.modelElement.fromEntity === entity.designQualifiedName).map((referenceFromCurrent) => {
        const entitySemql = entitySemqlProxies.get(referenceFromCurrent.modelElement.toEntity);
        if (!entitySemql) {
          return;
        }
        return {
          attributeName: referenceFromCurrent.modelElement.toRoleName,
          entitySemql
        };
      }).filter((reference) => !!reference);
      return referenceAttributes;
    }
    function mapReferenceFromAttributesSemql(entity, entitySemqlProxies, memoryModel) {
      const references = memoryModel.findModelElementsByTypes([
        "Reference"
      ]);
      const referenceAttributes = references.filter((reference) => reference.modelElement.toEntity === entity.designQualifiedName).map((referenceFromCurrent) => {
        const entitySemql = entitySemqlProxies.get(referenceFromCurrent.modelElement.fromEntity);
        if (!entitySemql) {
          return;
        }
        return {
          attributeName: referenceFromCurrent.modelElement.fromRoleName,
          entitySemql
        };
      }).filter((reference) => !!reference);
      return referenceAttributes;
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/entity/entity_semql_mapper.js
var require_entity_semql_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/entity/entity_semql_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EntitySemqlImpl = void 0;
    exports2.mapEntitySemql = mapEntitySemql;
    var attribute_semql_mapper_1 = require_attribute_semql_mapper();
    var reference_semql_mapper_1 = require_reference_semql_mapper();
    var EntitySemqlImpl = class {
      entitySemqlDataOptional;
      get entitySemqlData() {
        if (!this.entitySemqlDataOptional) {
          throw Error("EntitySemqlImpl: Data is not initialized");
        }
        return this.entitySemqlDataOptional;
      }
      get entityTypeSemql() {
        return this.entitySemqlData.entityTypeSemql;
      }
      get name() {
        return this.entitySemqlData.name;
      }
      get pkAttribute() {
        return this.entitySemqlData.pkAttribute;
      }
      get atomicAttributes() {
        return this.entitySemqlData.atomicAttributes;
      }
      get complexAttributes() {
        return this.entitySemqlData.complexAttributes;
      }
      get referenceToAttributes() {
        return this.entitySemqlData.referenceToAttributes;
      }
      get referenceFromAttributes() {
        return this.entitySemqlData.referenceFromAttributes;
      }
      isDeleteEnabled() {
        return this.entitySemqlData.enableDelete;
      }
      isHistorizeGoldenEnabled() {
        return this.entitySemqlData.historizeGolden;
      }
      isHistorizeMasterEnabled() {
        return this.entitySemqlData.historizeMaster;
      }
      isMultipub() {
        return this.entitySemqlData.entityTypeSemql === "FUZZY_MATCHED" || this.entitySemqlData.entityTypeSemql === "ID_MATCHED";
      }
      isFuzzy() {
        return this.entitySemqlData.entityTypeSemql === "FUZZY_MATCHED";
      }
      isBasic() {
        return this.entitySemqlData.entityTypeSemql === "BASIC";
      }
      isId() {
        return this.entitySemqlData.entityTypeSemql === "ID_MATCHED";
      }
      fillEntitySemqlData(entitySemqlData) {
        this.entitySemqlDataOptional = entitySemqlData;
      }
    };
    exports2.EntitySemqlImpl = EntitySemqlImpl;
    function mapEntitySemql(entity, entitySemqlProxies, memoryModel) {
      const entitySemqlImpl = entitySemqlProxies.get(entity.designQualifiedName);
      if (!entity.modelElement.primaryKey) {
        return;
      }
      const semqlAttributes = (0, attribute_semql_mapper_1.mapEntityAttributes)(entity.modelElement, memoryModel);
      if (!semqlAttributes.pk) {
        return;
      }
      entitySemqlImpl?.fillEntitySemqlData({
        entityTypeSemql: entity.modelElement.entityType,
        enableDelete: entity.modelElement.enableDelete ?? true,
        historizeGolden: entity.modelElement.historizeGolden,
        historizeMaster: entity.modelElement.historizeMaster,
        name: entity.modelElement._name,
        pkAttribute: semqlAttributes.pk,
        atomicAttributes: semqlAttributes.atomic,
        complexAttributes: semqlAttributes.complex,
        referenceToAttributes: (0, reference_semql_mapper_1.mapReferenceToAttributesSemql)(entity, entitySemqlProxies, memoryModel),
        referenceFromAttributes: (0, reference_semql_mapper_1.mapReferenceFromAttributesSemql)(entity, entitySemqlProxies, memoryModel)
      });
      return entitySemqlImpl;
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/complex_type/complex_type_semql_mapper.js
var require_complex_type_semql_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/complex_type/complex_type_semql_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapComplexTypeSemql = mapComplexTypeSemql;
    function mapComplexTypeSemql(complexType) {
      return {
        complexName: complexType.modelElement._name,
        definitions: complexType.modelElement.attributes?.map((attribute) => ({
          definitionName: attribute._name
        })) ?? []
      };
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/index.js
var require_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapComplexTypeSemql = exports2.mapEntitySemql = void 0;
    var entity_semql_mapper_1 = require_entity_semql_mapper();
    Object.defineProperty(exports2, "mapEntitySemql", { enumerable: true, get: function() {
      return entity_semql_mapper_1.mapEntitySemql;
    } });
    var complex_type_semql_mapper_1 = require_complex_type_semql_mapper();
    Object.defineProperty(exports2, "mapComplexTypeSemql", { enumerable: true, get: function() {
      return complex_type_semql_mapper_1.mapComplexTypeSemql;
    } });
  }
});

// ../../packages/xdm-schema/out/memory/semql/indexer/complex_type/complex_type_indexer.js
var require_complex_type_indexer2 = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/indexer/complex_type/complex_type_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexComplexTypeSemql = indexComplexTypeSemql;
    var mapper_1 = require_mapper();
    function indexComplexTypeSemql(complexType, semqlIndexer) {
      semqlIndexer.indexComplexType(complexType.designQualifiedName, (0, mapper_1.mapComplexTypeSemql)(complexType));
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/function/function_type_semql_mapper.js
var require_function_type_semql_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/function/function_type_semql_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFunctionSemql = mapFunctionSemql;
    function createFunctionRange(functionArguments) {
      const minParameters = functionArguments.filter((functionArgument) => functionArgument.mandatory === true).length;
      const containsVarArray = functionArguments.find((functionArgument) => functionArgument.array === true) !== void 0;
      const maxParameters = containsVarArray ? Infinity : functionArguments.length;
      return {
        minParameters,
        maxParameters
      };
    }
    function mapFunctionSemql(sqlFunction) {
      const functionRange = createFunctionRange(sqlFunction.functionArguments ?? []);
      const functionName = sqlFunction.schema ? `${sqlFunction.schema.toUpperCase()}.${sqlFunction._name.toUpperCase()}` : sqlFunction._name.toUpperCase();
      return {
        functionName,
        ...functionRange
      };
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/indexer/function/function_semql_indexer.js
var require_function_semql_indexer = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/indexer/function/function_semql_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexFunctionSemql = indexFunctionSemql;
    var function_type_semql_mapper_1 = require_function_type_semql_mapper();
    function indexFunctionSemql(sqlFunction, semqlIndexer) {
      semqlIndexer.indexFunction((0, function_type_semql_mapper_1.mapFunctionSemql)(sqlFunction.modelElement));
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/semql_attributes_builder.js
var require_semql_attributes_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/semql_attributes_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SemqlAttributesBuilder = void 0;
    var model_1 = require_model();
    var SemqlAttributesBuilder = class {
      semqlAttributes = {};
      addClassName() {
        this.semqlAttributes["ClassName"] = {};
        return this;
      }
      addBatchId() {
        this.semqlAttributes["BatchID"] = {};
        return this;
      }
      addBatchDate() {
        this.semqlAttributes["BatchDate"] = {};
        return this;
      }
      addBatchSubmitter() {
        this.semqlAttributes["BatchSubmitter"] = {};
        return this;
      }
      addLoadStatus() {
        this.semqlAttributes["LoadStatus"] = {};
        return this;
      }
      addErrorStatus() {
        this.semqlAttributes["ErrorStatus"] = {};
        return this;
      }
      addLoadId() {
        this.semqlAttributes["LoadID"] = {};
        return this;
      }
      addGoldenType() {
        this.semqlAttributes["GoldenType"] = {};
        return this;
      }
      addAuditings() {
        this.semqlAttributes["CreationDate"] = {};
        this.semqlAttributes["UpdateDate"] = {};
        this.semqlAttributes["Creator"] = {};
        this.semqlAttributes["Updator"] = {};
        return this;
      }
      addMastersCount() {
        this.semqlAttributes["MastersCount"] = {};
        return this;
      }
      addOriginalMastersCount() {
        this.semqlAttributes["OriginalMastersCount"] = {};
        return this;
      }
      addIsConfirmed() {
        this.semqlAttributes["IsConfirmed"] = {};
        return this;
      }
      addConfidenceScore() {
        this.semqlAttributes["ConfidenceScore"] = {};
        return this;
      }
      addOriginalConfidenceScore() {
        this.semqlAttributes["OriginalConfidenceScore"] = {};
        return this;
      }
      addBranchId() {
        this.semqlAttributes["BranchID"] = {};
        return this;
      }
      addFromEdition() {
        this.semqlAttributes["FromEdition"] = {};
        return this;
      }
      addMatchGroupId() {
        this.semqlAttributes["MatchGroupID"] = {};
        return this;
      }
      addOldMatchGroupId() {
        this.semqlAttributes["OldMatchGroupID"] = {};
        return this;
      }
      addExclusionGroupId() {
        this.semqlAttributes["ExclusionGroupID"] = {};
        return this;
      }
      addOriginalExclusionGroupId() {
        this.semqlAttributes["OriginalExclusionGroupID"] = {};
        return this;
      }
      addToEdition() {
        this.semqlAttributes["ToEdition"] = {};
        return this;
      }
      addConfidenceScoreType() {
        this.semqlAttributes["ConfidenceScoreType"] = {};
        return this;
      }
      addOriginalConfidenceScoreType() {
        this.semqlAttributes["OriginalConfidenceScoreType"] = {};
        return this;
      }
      addConfirmationStatus() {
        this.semqlAttributes["ConfirmationStatus"] = {};
        return this;
      }
      addOriginalConfirmationStatus() {
        this.semqlAttributes["OriginalConfirmationStatus"] = {};
        return this;
      }
      addHasSuggestedMerge() {
        this.semqlAttributes["HasSuggestedMerge"] = {};
        return this;
      }
      addSuggestedMergeId() {
        this.semqlAttributes["SuggestedMergeID"] = {};
        return this;
      }
      addOriginalBatchId() {
        this.semqlAttributes["OriginalBatchID"] = {};
        return this;
      }
      addOperationId() {
        this.semqlAttributes["OperationID"] = {};
        return this;
      }
      addSuggestedMergeConfidenceScore() {
        this.semqlAttributes["SuggestedMergeConfidenceScore"] = {};
        return this;
      }
      addSuggestedMergeConfidenceScoreType() {
        this.semqlAttributes["SuggestedMergeConfidenceScoreType"] = {};
        return this;
      }
      addSuggestedMergeMastersCount() {
        this.semqlAttributes["SuggestedMergeMastersCount"] = {};
        return this;
      }
      addDupsOperationId() {
        this.semqlAttributes["DupsOperationID"] = {};
        return this;
      }
      addDupsCheckoutCauseAttribute() {
        this.semqlAttributes["DupsCheckoutCause"] = {};
        return this;
      }
      addAuthoringType() {
        this.semqlAttributes["AuthoringType"] = {};
        return this;
      }
      addFromBatchId() {
        this.semqlAttributes["FromBatchID"] = {};
        return this;
      }
      addToBatchId() {
        this.semqlAttributes["ToBatchID"] = {};
        return this;
      }
      addCopiedFrom() {
        this.semqlAttributes["CopiedFrom"] = {};
        return this;
      }
      addHasOverride() {
        this.semqlAttributes["HasOverride"] = {};
        return this;
      }
      addDeletes() {
        this.semqlAttributes["DeleteDate"] = {};
        this.semqlAttributes["DeleteAuthor"] = {};
        this.semqlAttributes["DeleteOperation"] = {};
        this.semqlAttributes["DeletePath"] = {};
        return this;
      }
      addDeleteType() {
        this.semqlAttributes["DeleteType"] = {};
        return this;
      }
      addViewType() {
        this.semqlAttributes["ViewType"] = {};
        return this;
      }
      addSimpleId(entity) {
        const pkName = entity.pkAttribute.attributeName;
        this.semqlAttributes[pkName] = {};
        return this;
      }
      addGoldId(entity) {
        const pkName = entity.pkAttribute.attributeName;
        if (entity.isMultipub()) {
          this.semqlAttributes[`Gold_${pkName}`] = {};
        }
        return this;
      }
      addOriginalGoldId(entity) {
        const pkName = entity.pkAttribute.attributeName;
        if (entity.isMultipub()) {
          this.semqlAttributes[`OriginalGold_${pkName}`] = {};
        }
        return this;
      }
      addConfirmedGold(entity) {
        const pkName = entity.pkAttribute.attributeName;
        if (entity.isFuzzy()) {
          this.semqlAttributes[`ConfirmedGold_${pkName}`] = {};
        }
        return this;
      }
      addOriginalConfirmedGold(entity) {
        const pkName = entity.pkAttribute.attributeName;
        if (entity.isFuzzy()) {
          this.semqlAttributes[`OriginalConfirmedGold_${pkName}`] = {};
        }
        return this;
      }
      addOldGoldId(entity) {
        const pkName = entity.pkAttribute.attributeName;
        if (entity.isFuzzy()) {
          this.semqlAttributes[`OldGold_${pkName}`] = {};
        }
        return this;
      }
      addPublisherId() {
        this.semqlAttributes["PublisherID"] = {};
        return this;
      }
      addSourceId() {
        this.semqlAttributes["SourceID"] = {};
        return this;
      }
      addPublisherId2() {
        this.semqlAttributes["PublisherID2"] = {};
        return this;
      }
      addSourceId2() {
        this.semqlAttributes["SourceID2"] = {};
        return this;
      }
      addAtomicAttributes(entity) {
        entity.atomicAttributes.forEach((atomicAttribute) => {
          this.semqlAttributes[atomicAttribute.attributeName] = {};
        });
        return this;
      }
      addConstraintName() {
        this.semqlAttributes["ConstraintName"] = {};
        return this;
      }
      addConstraintType() {
        this.semqlAttributes["ConstraintType"] = {};
        return this;
      }
      addMatchRule() {
        this.semqlAttributes["MatchRule"] = {};
        return this;
      }
      addMatchScore() {
        this.semqlAttributes["MatchScore"] = {};
        return this;
      }
      addComplexAttributes(entity) {
        entity.complexAttributes.forEach((complexAttribute) => {
          this.semqlAttributes[complexAttribute.attributeName] = {
            ref: complexAttribute.complexName,
            _type: "RefComplex"
          };
        });
        return this;
      }
      addManyToOneProperties(entity) {
        entity.referenceToAttributes.forEach((referenceAttribute) => {
          const toEntitySemql = referenceAttribute.entitySemql;
          this.semqlAttributes[`FID_${referenceAttribute.attributeName}`] = {};
          if (toEntitySemql.isFuzzy()) {
            this.semqlAttributes[`PublisherID_${referenceAttribute.attributeName}`] = {};
            this.semqlAttributes[`SourceID_${referenceAttribute.attributeName}`] = {};
          }
        });
        return this;
      }
      addManyToOneNavigations(entity, viewTypeByEntityType) {
        entity.referenceToAttributes.forEach((referenceAttribute) => {
          const toEntitySemql = referenceAttribute.entitySemql;
          this.semqlAttributes[`FDN_${referenceAttribute.attributeName}`] = {};
          this.semqlAttributes[referenceAttribute.attributeName] = {
            ref: `${viewTypeByEntityType[toEntitySemql.entityTypeSemql]}_${toEntitySemql.name}`,
            _type: "RefSimple"
          };
        });
        return this;
      }
      addOneToManyNavigations(entity, viewTypeByEntityType) {
        entity.referenceFromAttributes.forEach((referenceAttribute) => {
          const fromEntitySemql = referenceAttribute.entitySemql;
          this.semqlAttributes[referenceAttribute.attributeName] = {
            arrayRef: `${viewTypeByEntityType[fromEntitySemql.entityTypeSemql]}_${fromEntitySemql.name}`
          };
        });
        return this;
      }
      addGoldenLineage(entity, viewType = model_1.ViewType.GD) {
        this.semqlAttributes["GoldenRecord"] = {
          ref: `${viewType}_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addCurrentGoldenLineage(entity) {
        this.semqlAttributes["CurrentGoldenRecord"] = {
          ref: `GD_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addCurrentMasterLineage(entity) {
        this.semqlAttributes["CurrentMasterRecord"] = {
          ref: `MD_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addDupsConsolidatedGoldenLineage(entity) {
        this.semqlAttributes["DupsConsolidatedGolden"] = {
          ref: `UG_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addRecord1Lineage(entity) {
        this.semqlAttributes["Record1"] = {
          ref: `MI_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addRecord2Lineage(entity) {
        this.semqlAttributes["Record2"] = {
          ref: `MI_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addMasterLineage(entity) {
        this.semqlAttributes["MasterRecord"] = {
          ref: `MD_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addSourceLineage(entity) {
        this.semqlAttributes["SourceRecord"] = {
          ref: `SD_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addSourcesLineage(entity) {
        this.semqlAttributes["SourceRecords"] = {
          arrayRef: `SD_${entity.name}`
        };
        return this;
      }
      addRecordWithErrorLineage(entity) {
        this.semqlAttributes["RecordWithError"] = {
          ref: `SAWE_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addSourceAuthoringLineage(entity) {
        this.semqlAttributes["SourceAuthoringRecord"] = {
          ref: `SA_${entity.name}`,
          _type: "RefSimple"
        };
        return this;
      }
      addSourcesAuthoringLineage(entity) {
        this.semqlAttributes["SourceAuthoringRecords"] = {
          arrayRef: `SA_${entity.name}`
        };
        if (entity.isBasic()) {
          this.semqlAttributes["SourceRecords"] = {
            arrayRef: `SA_${entity.name}`
          };
        }
        return this;
      }
      addErrorsLineage(entity, viewType = model_1.ViewType.GE) {
        this.semqlAttributes["Errors"] = {
          arrayRef: `${viewType}_${entity.name}`
        };
        return this;
      }
      addMastersLineage(entity, viewType = model_1.ViewType.MD) {
        if (!entity.isMultipub()) {
          return this;
        }
        this.semqlAttributes["MasterRecords"] = {
          arrayRef: `${viewType}_${entity.name}`
        };
        return this;
      }
      addGoldensHistoryLineage(entity) {
        if (!entity.isHistorizeGoldenEnabled()) {
          return this;
        }
        this.semqlAttributes["GoldenHistoryRecords"] = {
          arrayRef: `GH_${entity.name}`
        };
        return this;
      }
      addMastersHistoryLineage(entity) {
        if (!entity.isHistorizeGoldenEnabled()) {
          return this;
        }
        this.semqlAttributes["MasterHistoryRecords"] = {
          arrayRef: `MH_${entity.name}`
        };
        return this;
      }
      addMastersIntegrationLineage(entity) {
        this.semqlAttributes["IntegrationMasterRecords"] = {
          arrayRef: `MI_${entity.name}`
        };
        return this;
      }
      build() {
        return this.semqlAttributes;
      }
    };
    exports2.SemqlAttributesBuilder = SemqlAttributesBuilder;
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/gi/gi_view_builder.js
var require_gi_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/gi/gi_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildGiView = buildGiView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildGiView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addClassName().addBatchId().addAuditings().addErrorStatus().addMastersCount();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addIsConfirmed().addConfidenceScore().addConfidenceScoreType().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GI,
        ID_MATCHED: model_1.ViewType.GI
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GI,
        ID_MATCHED: model_1.ViewType.GI
      }).addGoldenLineage(entity).addMastersIntegrationLineage(entity).addBranchId();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/sa4l/sa4l_view_builder.js
var require_sa4l_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/sa4l/sa4l_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSa4lView = buildSa4lView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSa4lView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addLoadId().addClassName().addAuditings().addOriginalBatchId();
      if (entity.isDeleteEnabled()) {
        semqlAttributesBuilder.addDeletes();
      }
      semqlAttributesBuilder.addAuthoringType().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addCopiedFrom().addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SA4LK,
        ID_MATCHED: model_1.ViewType.SA4LK
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SA4LK,
        ID_MATCHED: model_1.ViewType.SA4LK
      }).addGoldenLineage(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/sd4l/sd4l_view_builder.js
var require_sd4l_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/sd4l/sd4l_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSd4lView = buildSd4lView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSd4lView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isBasic()) {
        semqlAttributesBuilder.addSimpleId(entity);
      } else if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId().addSimpleId(entity).addGoldId(entity);
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSimpleId(entity).addPublisherId().addSourceId();
      }
      semqlAttributesBuilder.addLoadId().addClassName().addAuditings().addOriginalBatchId();
      if (entity.isDeleteEnabled()) {
        semqlAttributesBuilder.addDeletes();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SD4LK,
        ID_MATCHED: model_1.ViewType.SD4LK
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SD4LK,
        ID_MATCHED: model_1.ViewType.SD4LK
      });
      if (entity.isBasic() || entity.isId()) {
        semqlAttributesBuilder.addGoldenLineage(entity);
      }
      if (entity.isFuzzy() || entity.isId()) {
        semqlAttributesBuilder.addMasterLineage(entity);
      }
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addBranchId();
      }
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/view_type.js
var require_view_type = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/view_type.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isSupportedForEntity = isSupportedForEntity;
    var model_1 = require_model();
    function isSupportedForEntity(viewType, entitySemql) {
      switch (viewType) {
        case model_1.ViewType.GD:
          return true;
        case model_1.ViewType.MD:
          return entitySemql.isMultipub();
        case model_1.ViewType.SD:
          return entitySemql.isMultipub();
        case model_1.ViewType.SA:
          return true;
        case model_1.ViewType.SA4L:
          return true;
        case model_1.ViewType.SA4LK:
          return true;
        case model_1.ViewType.SDWE:
          return entitySemql.isMultipub();
        case model_1.ViewType.SE:
          return entitySemql.isMultipub();
        case model_1.ViewType.SAWE:
          return true;
        case model_1.ViewType.AE:
          return true;
        case model_1.ViewType.GDWE:
          return entitySemql.isMultipub();
        case model_1.ViewType.GE:
          return entitySemql.isMultipub();
        case model_1.ViewType.MI:
          return entitySemql.isMultipub();
        case model_1.ViewType.GI:
          return entitySemql.isMultipub();
        case model_1.ViewType.DU:
          return entitySemql.isFuzzy();
        case model_1.ViewType.SD4L:
          return entitySemql.isMultipub();
        case model_1.ViewType.SD4LK:
          return entitySemql.isMultipub();
        case model_1.ViewType.UM:
          return entitySemql.isFuzzy();
        case model_1.ViewType.UG:
          return entitySemql.isFuzzy();
        case model_1.ViewType.GX:
          return true;
        case model_1.ViewType.MX:
          return entitySemql.isMultipub();
        case model_1.ViewType.GH:
          return true;
        case model_1.ViewType.MH:
          return entitySemql.isMultipub();
        case model_1.ViewType.GH4B:
          return true;
        case model_1.ViewType.MH4B:
          return entitySemql.isMultipub();
        case model_1.ViewType.MS:
          return entitySemql.isFuzzy();
        case model_1.ViewType.JOB_MATCHING:
          return true;
        case model_1.ViewType.CONSOLIDATOR_INPUT:
          return true;
        case model_1.ViewType.CUSTOM:
          return false;
      }
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/gd/gd_view_builder.js
var require_gd_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/gd/gd_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildGdView = buildGdView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildGdView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addClassName().addBatchId().addAuditings();
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addMastersCount().addErrorStatus().addHasOverride().addErrorsLineage(entity);
      }
      semqlAttributesBuilder.addGoldenType();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addIsConfirmed().addConfidenceScore().addConfidenceScoreType().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addMastersLineage(entity).addGoldensHistoryLineage(entity).addSourcesAuthoringLineage(entity);
      if (entity.isId()) {
        semqlAttributesBuilder.addSourcesLineage(entity);
      }
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addBranchId().addFromEdition().addToEdition();
      }
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/md/md_view_builder.js
var require_md_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/md/md_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildMdView = buildMdView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildMdView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId();
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId().addPublisherId();
      }
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addOldGoldId(entity).addConfirmedGold(entity).addClassName().addBatchId().addAuditings();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addMatchGroupId().addExclusionGroupId().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.MD
      }).addGoldenLineage(entity).addMastersHistoryLineage(entity).addSourcesLineage(entity).addBranchId().addFromEdition().addToEdition();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/mi/mi_view_builder.js
var require_mi_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/mi/mi_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildMiView = buildMiView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildMiView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId();
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId().addPublisherId();
      }
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addOldGoldId(entity).addConfirmedGold(entity).addClassName().addBatchId().addAuditings();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addMatchGroupId().addOldMatchGroupId().addExclusionGroupId().addConfidenceScore().addConfidenceScoreType().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MI,
        ID_MATCHED: model_1.ViewType.GI
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MI,
        ID_MATCHED: model_1.ViewType.MI
      }).addMasterLineage(entity).addBranchId();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/sa4lk/sa4lk_view_builder.js
var require_sa4lk_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/sa4lk/sa4lk_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSa4lkView = buildSa4lkView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSa4lkView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addClassName().addAuditings();
      if (entity.isDeleteEnabled()) {
        semqlAttributesBuilder.addDeletes();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SA4LK,
        ID_MATCHED: model_1.ViewType.SA4LK
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SA4LK,
        ID_MATCHED: model_1.ViewType.SA4LK
      });
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/sd4lk/sd4lk_view_builder.js
var require_sd4lk_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/sd4lk/sd4lk_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSd4lkView = buildSd4lkView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSd4lkView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isBasic()) {
        semqlAttributesBuilder.addSimpleId(entity);
      } else if (entity.isId()) {
        semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity);
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSimpleId(entity).addPublisherId().addSourceId();
      }
      semqlAttributesBuilder.addClassName().addAuditings();
      if (entity.isDeleteEnabled()) {
        semqlAttributesBuilder.addDeletes();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SD4LK,
        ID_MATCHED: model_1.ViewType.SD4LK
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SD4LK,
        ID_MATCHED: model_1.ViewType.SD4LK
      });
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addMasterLineage(entity);
      }
      semqlAttributesBuilder.addBranchId();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/sd/sd_view_builder.js
var require_sd_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/sd/sd_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSdView = buildSdView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSdView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isBasic()) {
        semqlAttributesBuilder.addSimpleId(entity);
      } else if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId().addSimpleId(entity).addGoldId(entity);
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSimpleId(entity).addPublisherId().addSourceId();
      }
      semqlAttributesBuilder.addLoadId().addClassName().addBatchId().addBatchDate().addBatchSubmitter().addLoadStatus().addAuditings().addErrorStatus().addOriginalBatchId();
      if (entity.isDeleteEnabled()) {
        semqlAttributesBuilder.addDeletes();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA,
        FUZZY_MATCHED: model_1.ViewType.SD,
        ID_MATCHED: model_1.ViewType.SD
      });
      if (entity.isBasic() || entity.isId()) {
        semqlAttributesBuilder.addGoldenLineage(entity);
      }
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addMasterLineage(entity);
      }
      semqlAttributesBuilder.addErrorsLineage(entity, model_1.ViewType.SE).addBranchId();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/sa/sa_view_builder.js
var require_sa_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/sa/sa_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSaView = buildSaView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSaView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addLoadId().addClassName().addBatchId().addBatchDate().addBatchSubmitter().addLoadStatus().addAuditings().addErrorStatus().addOriginalBatchId();
      if (entity.isDeleteEnabled()) {
        semqlAttributesBuilder.addDeletes();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity);
      semqlAttributesBuilder.addAuthoringType().addCopiedFrom().addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA,
        FUZZY_MATCHED: model_1.ViewType.SA,
        ID_MATCHED: model_1.ViewType.SA
      }).addGoldenLineage(entity).addErrorsLineage(entity, model_1.ViewType.AE);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/se/se_view_builder.js
var require_se_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/se/se_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSeView = buildSeView;
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSeView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addPublisherId().addConstraintName().addConstraintType();
      if (entity.isId()) {
        semqlAttributesBuilder.addGoldId(entity);
      }
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId();
      }
      semqlAttributesBuilder.addBranchId().addBatchId().addLoadId().addClassName().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addSourceLineage(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/sawe/sawe_view_builder.js
var require_sawe_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/sawe/sawe_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildSaweView = buildSaweView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildSaweView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addLoadId().addClassName().addBatchId().addBatchDate().addBatchSubmitter().addLoadStatus().addAuditings().addErrorStatus().addOriginalBatchId();
      if (entity.isDeleteEnabled()) {
        semqlAttributesBuilder.addDeletes();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addAuthoringType().addCopiedFrom().addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA,
        FUZZY_MATCHED: model_1.ViewType.SA,
        ID_MATCHED: model_1.ViewType.SA
      }).addGoldenLineage(entity).addErrorsLineage(entity, model_1.ViewType.AE);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/ae/ae_view_builder.js
var require_ae_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/ae/ae_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildAeView = buildAeView;
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildAeView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addConstraintName().addConstraintType();
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addBranchId();
      }
      semqlAttributesBuilder.addBatchId().addLoadId().addClassName().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addSourceAuthoringLineage(entity).addRecordWithErrorLineage(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/gdwe/gdwe_view_builder.js
var require_gdwe_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/gdwe/gdwe_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildGdweView = buildGdweView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildGdweView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addClassName().addBatchId().addAuditings();
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addMastersCount().addErrorStatus();
      }
      semqlAttributesBuilder.addGoldenType();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addIsConfirmed().addConfidenceScore().addConfidenceScoreType().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addMastersLineage(entity).addGoldensHistoryLineage(entity).addSourcesAuthoringLineage(entity).addErrorsLineage(entity);
      if (entity.isId()) {
        semqlAttributesBuilder.addSourcesLineage(entity);
      }
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addBranchId().addFromEdition().addToEdition();
      }
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/ge/ge_view_builder.js
var require_ge_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/ge/ge_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildGeView = buildGeView;
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildGeView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addConstraintName().addConstraintType().addBatchId().addClassName().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addBranchId();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/du/du_view_builder.js
var require_du_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/du/du_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildDuView = buildDuView;
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildDuView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addPublisherId().addPublisherId2().addSourceId().addSourceId2().addClassName().addMatchRule().addMatchScore().addViewType().addRecord1Lineage(entity).addRecord2Lineage(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/um/um_view_builder.js
var require_um_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/um/um_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildUmView = buildUmView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildUmView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addLoadId().addPublisherId().addSourceId().addSimpleId(entity).addGoldId(entity).addOriginalGoldId(entity).addConfirmedGold(entity).addOriginalConfirmedGold(entity).addClassName().addOriginalBatchId().addDupsCheckoutCauseAttribute().addDupsOperationId().addConfirmationStatus().addConfidenceScore().addConfidenceScoreType().addMastersCount().addExclusionGroupId().addOriginalConfirmationStatus().addOriginalConfidenceScore().addOriginalConfidenceScoreType().addOriginalMastersCount().addOriginalExclusionGroupId().addSuggestedMergeId().addHasSuggestedMerge().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount().addAuditings().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.GI
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.SA4LK,
        FUZZY_MATCHED: model_1.ViewType.SD4LK,
        ID_MATCHED: model_1.ViewType.SD4LK
      }).addGoldenLineage(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/ug/ug_view_builder.js
var require_ug_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/ug/ug_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildUgView = buildUgView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildUgView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addClassName().addMastersCount().addConfidenceScore().addConfidenceScoreType().addConfirmationStatus().addSuggestedMergeId().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      });
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/gx/gx_view_builder.js
var require_gx_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/gx/gx_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildGxView = buildGxView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildGxView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addBatchId().addDeletes().addDeleteType().addClassName().addAuditings().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      });
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/mx/mx_view_builder.js
var require_mx_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/mx/mx_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildMxView = buildMxView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildMxView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId();
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId().addPublisherId();
      }
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addOldGoldId(entity).addConfirmedGold(entity).addDeletes().addDeleteType().addClassName().addBatchId().addAuditings();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addMatchGroupId().addExclusionGroupId().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.MD
      });
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/gh/gh_view_builder.js
var require_gh_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/gh/gh_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildGhView = buildGhView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildGhView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addFromBatchId().addToBatchId().addClassName().addAuditings().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      }).addCurrentGoldenLineage(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/mh/mh_view_builder.js
var require_mh_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/mh/mh_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildMhView = buildMhView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildMhView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId();
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId().addPublisherId();
      }
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addOldGoldId(entity).addConfirmedGold(entity).addFromBatchId().addToBatchId().addClassName().addAuditings();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addMatchGroupId().addExclusionGroupId().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.GD
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.MD,
        ID_MATCHED: model_1.ViewType.MD
      }).addCurrentMasterLineage(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/gh4b/gh4b_view_builder.js
var require_gh4b_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/gh4b/gh4b_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildGh4bView = buildGh4bView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildGh4bView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addClassName();
      if (entity.isHistorizeGoldenEnabled()) {
        semqlAttributesBuilder.addFromBatchId().addToBatchId();
      } else {
        semqlAttributesBuilder.addBatchId();
      }
      semqlAttributesBuilder.addAuditings();
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addMastersCount().addErrorStatus().addHasOverride();
      }
      semqlAttributesBuilder.addGoldenType();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addIsConfirmed().addConfidenceScore().addConfidenceScoreType().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GH4B,
        FUZZY_MATCHED: model_1.ViewType.GH4B,
        ID_MATCHED: model_1.ViewType.GH4B
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GH4B,
        FUZZY_MATCHED: model_1.ViewType.GH4B,
        ID_MATCHED: model_1.ViewType.GH4B
      }).addMastersLineage(entity, model_1.ViewType.MH4B);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/mh4b/mh4b_view_builder.js
var require_mh4b_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/mh4b/mh4b_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildMh4bView = buildMh4bView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildMh4bView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId();
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId().addPublisherId();
      }
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addOldGoldId(entity).addConfirmedGold(entity).addClassName();
      if (entity.isHistorizeMasterEnabled()) {
        semqlAttributesBuilder.addFromBatchId().addToBatchId();
      } else {
        semqlAttributesBuilder.addBatchId();
      }
      semqlAttributesBuilder.addAuditings();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addMatchGroupId().addExclusionGroupId().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GH4B,
        FUZZY_MATCHED: model_1.ViewType.MH4B,
        ID_MATCHED: model_1.ViewType.GH4B
      }).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.GH4B,
        FUZZY_MATCHED: model_1.ViewType.MH4B,
        ID_MATCHED: model_1.ViewType.MH4B
      }).addGoldenLineage(entity, model_1.ViewType.GH4B).addBranchId().addFromEdition().addToEdition();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/ms/ms_view_builder.js
var require_ms_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/ms/ms_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildMsView = buildMsView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildMsView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addSuggestedMergeId().addClassName().addSuggestedMergeMastersCount().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addManyToOneNavigations(entity, {
        BASIC: model_1.ViewType.GD,
        FUZZY_MATCHED: model_1.ViewType.GD,
        ID_MATCHED: model_1.ViewType.GD
      });
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/job_matching/Job_matching_view_builder.js
var require_Job_matching_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/job_matching/Job_matching_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildJobMatchingView = buildJobMatchingView;
    var model_1 = require_model();
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildJobMatchingView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      if (entity.isId()) {
        semqlAttributesBuilder.addPublisherId();
      } else if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId().addPublisherId();
      }
      semqlAttributesBuilder.addSimpleId(entity).addGoldId(entity).addOldGoldId(entity).addConfirmedGold(entity).addClassName().addAuditings().addBatchId();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addMatchGroupId().addOldMatchGroupId().addExclusionGroupId().addConfirmationStatus().addHasSuggestedMerge().addSuggestedMergeId().addSuggestedMergeConfidenceScore().addSuggestedMergeConfidenceScoreType().addSuggestedMergeMastersCount();
      }
      semqlAttributesBuilder.addViewType().addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity).addOneToManyNavigations(entity, {
        BASIC: model_1.ViewType.JOB_MATCHING,
        FUZZY_MATCHED: model_1.ViewType.JOB_MATCHING,
        ID_MATCHED: model_1.ViewType.JOB_MATCHING
      });
      if (entity.isMultipub()) {
        semqlAttributesBuilder.addManyToOneNavigations(entity, {
          BASIC: model_1.ViewType.JOB_MATCHING,
          FUZZY_MATCHED: model_1.ViewType.JOB_MATCHING,
          ID_MATCHED: model_1.ViewType.JOB_MATCHING
        }).addMasterLineage(entity);
      } else {
        semqlAttributesBuilder.addManyToOneNavigations(entity, {
          BASIC: model_1.ViewType.JOB_MATCHING,
          FUZZY_MATCHED: model_1.ViewType.JOB_MATCHING,
          ID_MATCHED: model_1.ViewType.GI
        });
      }
      semqlAttributesBuilder.addBranchId();
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/consolidator_input/consolidator_input_view_builder.js
var require_consolidator_input_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/consolidator_input/consolidator_input_view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildConsolidatorInputView = buildConsolidatorInputView;
    var semql_attributes_builder_1 = require_semql_attributes_builder();
    function buildConsolidatorInputView(entity) {
      const semqlAttributesBuilder = new semql_attributes_builder_1.SemqlAttributesBuilder();
      semqlAttributesBuilder.addPublisherId().addAuditings();
      if (entity.isFuzzy()) {
        semqlAttributesBuilder.addSourceId();
      }
      semqlAttributesBuilder.addAtomicAttributes(entity).addComplexAttributes(entity).addManyToOneProperties(entity);
      return semqlAttributesBuilder.build();
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/view_builder.js
var require_view_builder = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/view_builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createViewAttributes = createViewAttributes;
    var gi_view_builder_1 = require_gi_view_builder();
    var sa4l_view_builder_1 = require_sa4l_view_builder();
    var sd4l_view_builder_1 = require_sd4l_view_builder();
    var view_type_1 = require_view_type();
    var gd_view_builder_1 = require_gd_view_builder();
    var md_view_builder_1 = require_md_view_builder();
    var mi_view_builder_1 = require_mi_view_builder();
    var model_1 = require_model();
    var sa4lk_view_builder_1 = require_sa4lk_view_builder();
    var sd4lk_view_builder_1 = require_sd4lk_view_builder();
    var sd_view_builder_1 = require_sd_view_builder();
    var sa_view_builder_1 = require_sa_view_builder();
    var se_view_builder_1 = require_se_view_builder();
    var sawe_view_builder_1 = require_sawe_view_builder();
    var ae_view_builder_1 = require_ae_view_builder();
    var gdwe_view_builder_1 = require_gdwe_view_builder();
    var ge_view_builder_1 = require_ge_view_builder();
    var du_view_builder_1 = require_du_view_builder();
    var um_view_builder_1 = require_um_view_builder();
    var ug_view_builder_1 = require_ug_view_builder();
    var gx_view_builder_1 = require_gx_view_builder();
    var mx_view_builder_1 = require_mx_view_builder();
    var gh_view_builder_1 = require_gh_view_builder();
    var mh_view_builder_1 = require_mh_view_builder();
    var gh4b_view_builder_1 = require_gh4b_view_builder();
    var mh4b_view_builder_1 = require_mh4b_view_builder();
    var ms_view_builder_1 = require_ms_view_builder();
    var Job_matching_view_builder_1 = require_Job_matching_view_builder();
    var consolidator_input_view_builder_1 = require_consolidator_input_view_builder();
    function createViewAttributes(entity, viewType) {
      if (!(0, view_type_1.isSupportedForEntity)(viewType, entity)) {
        return {};
      }
      switch (viewType) {
        case model_1.ViewType.GD:
          return (0, gd_view_builder_1.buildGdView)(entity);
        case model_1.ViewType.GI:
          return (0, gi_view_builder_1.buildGiView)(entity);
        case model_1.ViewType.MD:
          return (0, md_view_builder_1.buildMdView)(entity);
        case model_1.ViewType.MI:
          return (0, mi_view_builder_1.buildMiView)(entity);
        case model_1.ViewType.SA4L:
          return (0, sa4l_view_builder_1.buildSa4lView)(entity);
        case model_1.ViewType.SA4LK:
          return (0, sa4lk_view_builder_1.buildSa4lkView)(entity);
        case model_1.ViewType.SD4L:
          return (0, sd4l_view_builder_1.buildSd4lView)(entity);
        case model_1.ViewType.SD4LK:
          return (0, sd4lk_view_builder_1.buildSd4lkView)(entity);
        case model_1.ViewType.SD:
          return (0, sd_view_builder_1.buildSdView)(entity);
        case model_1.ViewType.SA:
          return (0, sa_view_builder_1.buildSaView)(entity);
        case model_1.ViewType.SDWE:
          return (0, se_view_builder_1.buildSeView)(entity);
        case model_1.ViewType.SE:
          return (0, se_view_builder_1.buildSeView)(entity);
        case model_1.ViewType.SAWE:
          return (0, sawe_view_builder_1.buildSaweView)(entity);
        case model_1.ViewType.AE:
          return (0, ae_view_builder_1.buildAeView)(entity);
        case model_1.ViewType.GDWE:
          return (0, gdwe_view_builder_1.buildGdweView)(entity);
        case model_1.ViewType.GE:
          return (0, ge_view_builder_1.buildGeView)(entity);
        case model_1.ViewType.DU:
          return (0, du_view_builder_1.buildDuView)(entity);
        case model_1.ViewType.UM:
          return (0, um_view_builder_1.buildUmView)(entity);
        case model_1.ViewType.UG:
          return (0, ug_view_builder_1.buildUgView)(entity);
        case model_1.ViewType.GX:
          return (0, gx_view_builder_1.buildGxView)(entity);
        case model_1.ViewType.MX:
          return (0, mx_view_builder_1.buildMxView)(entity);
        case model_1.ViewType.GH:
          return (0, gh_view_builder_1.buildGhView)(entity);
        case model_1.ViewType.MH:
          return (0, mh_view_builder_1.buildMhView)(entity);
        case model_1.ViewType.GH4B:
          return (0, gh4b_view_builder_1.buildGh4bView)(entity);
        case model_1.ViewType.MH4B:
          return (0, mh4b_view_builder_1.buildMh4bView)(entity);
        case model_1.ViewType.MS:
          return (0, ms_view_builder_1.buildMsView)(entity);
        case model_1.ViewType.JOB_MATCHING:
          return (0, Job_matching_view_builder_1.buildJobMatchingView)(entity);
        case model_1.ViewType.CONSOLIDATOR_INPUT:
          return (0, consolidator_input_view_builder_1.buildConsolidatorInputView)(entity);
        case model_1.ViewType.CUSTOM:
          return {};
      }
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/mapper/view/view_semql_mapper.js
var require_view_semql_mapper = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/mapper/view/view_semql_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapViews = mapViews;
    var view_builder_1 = require_view_builder();
    var view_type_1 = require_view_type();
    var view_semql_1 = require_view_semql();
    function mapViews(entity) {
      const availableViewTypes = Object.values(view_semql_1.ViewType).filter((viewType) => (0, view_type_1.isSupportedForEntity)(viewType, entity));
      return availableViewTypes.map((viewType) => ({
        viewName: entity.name,
        viewType,
        viewAttributes: (0, view_builder_1.createViewAttributes)(entity, viewType)
      }));
    }
  }
});

// ../../packages/xdm-schema/out/memory/semql/indexer/view/view_semql_indexer.js
var require_view_semql_indexer = __commonJS({
  "../../packages/xdm-schema/out/memory/semql/indexer/view/view_semql_indexer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.indexViews = indexViews;
    var entity_semql_mapper_1 = require_entity_semql_mapper();
    var view_semql_mapper_1 = require_view_semql_mapper();
    function indexViews(entities, memoryModel) {
      const entitySemqlProxies = new Map(entities.map((entity) => {
        return [entity.designQualifiedName, new entity_semql_mapper_1.EntitySemqlImpl()];
      }));
      const entitiesSemql = entities.map((entity) => {
        const entitySemql = (0, entity_semql_mapper_1.mapEntitySemql)(entity, entitySemqlProxies, memoryModel);
        if (!entitySemql) {
          return void 0;
        }
        return {
          qualifiedName: entity.designQualifiedName,
          entitySemql
        };
      }).filter((entitySemqlWithQualifiedName) => !!entitySemqlWithQualifiedName);
      if (entitiesSemql.length !== entities.length) {
        return;
      }
      entitiesSemql.flatMap(({ qualifiedName, entitySemql }) => (0, view_semql_mapper_1.mapViews)(entitySemql).map((view) => ({
        qualifiedName,
        view
      }))).forEach(({ qualifiedName, view }) => memoryModel.indexEntityView(qualifiedName, view));
    }
  }
});

// ../../packages/xdm-schema/out/memory/memory_model.js
var require_memory_model = __commonJS({
  "../../packages/xdm-schema/out/memory/memory_model.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MemoryModel = void 0;
    exports2.createMemoryModel = createMemoryModel;
    exports2.createMutableModelElementQueries = createMutableModelElementQueries;
    exports2.createModelElementQueries = createModelElementQueries;
    exports2.indexTopLevelElements = indexTopLevelElements;
    var design_1 = require_design();
    var application_indexer_1 = require_application_indexer();
    var complex_type_indexer_1 = require_complex_type_indexer();
    var db_function_indexer_1 = require_db_function_indexer();
    var db_view_indexer_1 = require_db_view_indexer();
    var enricher_cache_indexer_1 = require_enricher_cache_indexer();
    var action_set_indexer_1 = require_action_set_indexer();
    var business_view_indexer_1 = require_business_view_indexer();
    var collection_view_indexer_1 = require_collection_view_indexer();
    var display_card_indexer_1 = require_display_card_indexer();
    var dups_manager_indexer_1 = require_dups_manager_indexer();
    var enricher_indexer_1 = require_enricher_indexer();
    var entity_indexer_1 = require_entity_indexer();
    var form_indexer_1 = require_form_indexer();
    var fuzzy_lookup_rule_indexer_1 = require_fuzzy_lookup_rule_indexer();
    var search_form_indexer_1 = require_search_form_indexer();
    var stepper_indexer_1 = require_stepper_indexer();
    var survivorship_rule_indexer_1 = require_survivorship_rule_indexer();
    var unique_key_indexer_1 = require_unique_key_indexer();
    var validation_indexer_1 = require_validation_indexer();
    var job_indexer_1 = require_job_indexer();
    var list_of_value_indexer_1 = require_list_of_value_indexer();
    var model_diagram_indexer_1 = require_model_diagram_indexer();
    var model_indexer_1 = require_model_indexer();
    var model_priv_grant_indexer_1 = require_model_priv_grant_indexer();
    var model_variable_indexer_1 = require_model_variable_indexer();
    var named_query_indexer_1 = require_named_query_indexer();
    var publisher_indexer_1 = require_publisher_indexer();
    var reference_indexer_1 = require_reference_indexer();
    var retention_policy_indexer_1 = require_retention_policy_indexer();
    var user_defined_type_indexer_1 = require_user_defined_type_indexer();
    var workflow_indexer_1 = require_workflow_indexer();
    var model_element_metadata_1 = require_model_element_metadata();
    var qualified_name_1 = require_qualified_name();
    var semql_1 = require_semql();
    var bind_variable_semql_indexer_1 = require_bind_variable_semql_indexer();
    var complex_type_indexer_2 = require_complex_type_indexer2();
    var function_semql_indexer_1 = require_function_semql_indexer();
    var view_semql_indexer_1 = require_view_semql_indexer();
    var top_level_1 = require_top_level();
    var MemoryModel = class {
      allTypes = new Set(top_level_1.allTypes);
      rootTypes = new Set(top_level_1.rootTypes);
      qualifiedNameToModelElement = /* @__PURE__ */ new Map();
      typeToModelElements = /* @__PURE__ */ new Map();
      qualifiedNameToViews = /* @__PURE__ */ new Map();
      qualifiedNameToComplexTypeSemql = /* @__PURE__ */ new Map();
      functionsSemql = /* @__PURE__ */ new Map();
      bindVariablesSemql = /* @__PURE__ */ new Map();
      indexInnerQualifiedName(parentQualifiedName, filePath, modelElementDesign, qualifiedName) {
        const fullyQualifiedName = qualifiedName ?? (0, qualified_name_1.createInnerQualifiedName)(parentQualifiedName, modelElementDesign);
        const indexedModelElement = {
          modelElement: modelElementDesign,
          filePath,
          designQualifiedName: fullyQualifiedName.designFullyQualifiedName,
          payloadQualifiedName: fullyQualifiedName.payloadFullyQualifiedName
        };
        this.qualifiedNameToModelElement.set(fullyQualifiedName.designFullyQualifiedName, indexedModelElement);
        if (this.typeToModelElements.has(modelElementDesign._type)) {
          this.typeToModelElements.get(modelElementDesign._type)?.push(indexedModelElement);
        } else {
          this.typeToModelElements.set(modelElementDesign._type, [
            indexedModelElement
          ]);
        }
        return fullyQualifiedName;
      }
      indexTopLevelQualifiedName(modelElementDesign, filePath, parentQualifiedName) {
        const fullyQualifiedName = (0, qualified_name_1.createTopLevelQualifiedName)(modelElementDesign, parentQualifiedName);
        const indexedModelElement = {
          modelElement: modelElementDesign,
          filePath,
          designQualifiedName: fullyQualifiedName.designFullyQualifiedName,
          payloadQualifiedName: fullyQualifiedName.payloadFullyQualifiedName
        };
        this.qualifiedNameToModelElement.set(fullyQualifiedName.designFullyQualifiedName, indexedModelElement);
        if (this.typeToModelElements.has(modelElementDesign._type)) {
          this.typeToModelElements.get(modelElementDesign._type)?.push(indexedModelElement);
        } else {
          this.typeToModelElements.set(modelElementDesign._type, [
            indexedModelElement
          ]);
        }
        return fullyQualifiedName;
      }
      findInnerQualifiedName(parentQualifiedName, modelElementDesign) {
        const fullyQualifiedName = (0, qualified_name_1.createInnerQualifiedName)(parentQualifiedName, modelElementDesign);
        const qualifiedNameExist = this.qualifiedNameToModelElement.has(fullyQualifiedName.designFullyQualifiedName);
        if (!qualifiedNameExist) {
          throw Error(`Couldn't find inner qualified name ${fullyQualifiedName.designFullyQualifiedName}`);
        }
        return fullyQualifiedName;
      }
      findTopLevelQualifiedName(modelElementDesign) {
        const fullyQualifiedName = (0, qualified_name_1.createTopLevelQualifiedName)(modelElementDesign);
        const qualifiedNameExist = this.qualifiedNameToModelElement.has(fullyQualifiedName.designFullyQualifiedName);
        if (!qualifiedNameExist) {
          throw Error(`Couldn't find top qualified name ${fullyQualifiedName.designFullyQualifiedName}`);
        }
        return fullyQualifiedName;
      }
      findQualifiedNamesByTypes(types) {
        return types.reduce((acc, type) => {
          const indexedModelElements = this.typeToModelElements.get(type) ?? [];
          const a = [
            ...acc,
            ...indexedModelElements.map((indexedModelElement) => indexedModelElement.designQualifiedName)
          ];
          return a;
        }, []);
      }
      findModelElementsByTypes(types) {
        return types.reduce((acc, type) => {
          const indexedModelElements = this.typeToModelElements.get(type) ?? [];
          const a = [
            ...acc,
            ...indexedModelElements.map((indexedModelElement) => indexedModelElement)
          ];
          return a;
        }, []);
      }
      getIndexedElements() {
        return [...this.typeToModelElements.values()].flatMap((indexedModelElements) => indexedModelElements.map((indexedModelElement) => indexedModelElement));
      }
      findIndexedModelElementByQualifiedName(qualifiedName) {
        const element = this.findByQualifiedName(qualifiedName);
        if (element.match) {
          const match = element.match;
          return {
            modelElement: match,
            filePath: match.__meta.filePath,
            designQualifiedName: match.__meta.qualifiedName,
            payloadQualifiedName: match.__meta.runtimeData?.qualifiedName ?? match.__meta.qualifiedName
          };
        }
      }
      hasQualifiedName(qualifiedName) {
        return this.qualifiedNameToModelElement.has(qualifiedName);
      }
      getQualifiedNameType(qualifiedName) {
        return this.qualifiedNameToModelElement.get(qualifiedName)?.modelElement._type;
      }
      indexEntityView(entityQualifiedName, view) {
        if (this.qualifiedNameToViews.has(entityQualifiedName)) {
          this.qualifiedNameToViews.get(entityQualifiedName)?.push(view);
        } else {
          this.qualifiedNameToViews.set(entityQualifiedName, [view]);
        }
      }
      indexComplexType(complexTypeQualifiedName, complexTypeSemql) {
        this.qualifiedNameToComplexTypeSemql.set(complexTypeQualifiedName, complexTypeSemql);
      }
      indexFunction(functionSemql) {
        this.functionsSemql.set(functionSemql.functionName, functionSemql);
      }
      indexBindVariable(bindVariableSemql) {
        this.bindVariablesSemql.set(bindVariableSemql.bindVariableName, bindVariableSemql);
      }
      getViewsSemql() {
        return [...this.qualifiedNameToViews.values()].flatMap((views) => views);
      }
      getComplexTypesSemql() {
        return [...this.qualifiedNameToComplexTypeSemql.values()];
      }
      getFunctionsSemql() {
        return Object.fromEntries(this.functionsSemql.entries());
      }
      getBindVariablesSemql() {
        return Object.fromEntries(this.bindVariablesSemql.entries());
      }
      getAllViews() {
        return [...this.qualifiedNameToViews.values()].flatMap((views) => views);
      }
      getAllComplexTypes() {
        return [...this.qualifiedNameToComplexTypeSemql.values()].map((complexTypeSemql) => this.createComplexTypeNodes(complexTypeSemql));
      }
      getAllFunctions() {
        return Object.fromEntries(this.functionsSemql.entries());
      }
      getAllBindVariables() {
        return Object.fromEntries(this.bindVariablesSemql.entries());
      }
      createComplexTypeNodes(complexTypeSemql) {
        return [
          complexTypeSemql.complexName,
          Object.fromEntries(complexTypeSemql.definitions.map((definition) => [
            definition.definitionName,
            {}
          ]))
        ];
      }
      findViewsByEntityQualifiedName(entityQualifiedName) {
        return this.qualifiedNameToViews.get(entityQualifiedName);
      }
      getDatabaseType() {
        const databaseTypeDesign = this.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL)?.[0]?.modelConfiguration?.type;
        return (0, semql_1.fromDatabaseTypeDesign)(databaseTypeDesign);
      }
      isModelElementType(type) {
        return this.allTypes.has(type);
      }
      isRootModelElementType(type) {
        return this.rootTypes.has(type);
      }
      findElementByTypes(...types) {
        return types.flatMap((type) => {
          return this.typeToModelElements.get(type) ?? [];
        });
      }
      indexByQualifiedName = /* @__PURE__ */ new Map();
      indexByFilePath = /* @__PURE__ */ new Map();
      indexByType = /* @__PURE__ */ new Map();
      findAnyByQualifiedName(name, types) {
        const matches = this.indexByQualifiedName.get(name);
        if (!matches || matches.length === 0) {
          return { state: "NO_MATCH" };
        }
        if (matches.length > 1) {
          return { state: "AMBIGUOUS", matches };
        }
        const match = matches[0];
        if (types.includes(match._type)) {
          return { state: "FOUND", match };
        } else {
          return {
            state: "TYPE_ERROR",
            expected: types.join(", "),
            actual: match
          };
        }
      }
      findByQualifiedName(name, type) {
        const matches = this.indexByQualifiedName.get(name);
        if (!matches || matches.length === 0) {
          return { state: "NO_MATCH" };
        }
        if (matches.length > 1) {
          return { state: "AMBIGUOUS", matches };
        }
        const match = matches[0];
        if (type === void 0) {
          return { state: "FOUND", match };
        }
        return match._type === type ? { state: "FOUND", match } : { state: "TYPE_ERROR", expected: type, actual: match };
      }
      findByFilePath(filePath, type) {
        const fileElements = this.indexByFilePath.get(filePath);
        if (!fileElements || !fileElements.topLevel) {
          return { state: "NO_MATCH" };
        }
        const element = fileElements.topLevel;
        if (type === void 0) {
          return { state: "FOUND", match: element };
        }
        return element._type === type ? { state: "FOUND", match: element } : { state: "TYPE_ERROR", expected: type, actual: element };
      }
      findModelByFilePath(filePath, type) {
        const fileElements = this.indexByFilePath.get(filePath);
        if (!fileElements || !fileElements.topLevel) {
          return { state: "NO_MATCH" };
        }
        const element = fileElements.topLevel;
        return element._type === type ? { state: "FOUND", match: element } : { state: "TYPE_ERROR", expected: type, actual: element };
      }
      findParentOf(child, type) {
        let parentName = child.__meta.parentQualifiedName;
        while (parentName) {
          const queryResult = this.findByQualifiedName(parentName, type);
          if (queryResult.state === "FOUND") {
            return queryResult.match;
          }
          if (queryResult.state === "NO_MATCH" || queryResult.state === "AMBIGUOUS") {
            return;
          }
          parentName = queryResult.actual.__meta.parentQualifiedName;
        }
      }
      findAnyParentOf(child, types) {
        let parentName = child.__meta.parentQualifiedName;
        while (parentName) {
          const queryResult = this.findAnyByQualifiedName(parentName, types);
          if (queryResult.state === "FOUND") {
            return queryResult.match;
          }
          if (queryResult.state === "NO_MATCH" || queryResult.state === "AMBIGUOUS") {
            return;
          }
          parentName = queryResult.actual.__meta.parentQualifiedName;
        }
      }
      findAllByType(type) {
        const results = this.indexByType.get(type);
        if (!results) {
          return [];
        }
        return [...results];
      }
      findAllByTypes(types) {
        if (!Array.isArray(types)) {
          return this.findAllByType(types);
        }
        const results = types.flatMap((type) => this.indexByType.get(type)).filter((e) => !!e);
        return [...results];
      }
      findAll(includeConflicts = false) {
        const values = [...this.indexByQualifiedName.values()];
        if (includeConflicts) {
          return values.flat();
        }
        return values.filter((elements) => elements.length === 1).flat();
      }
      findAllTopLevels() {
        return [...this.indexByFilePath.values()].map((e) => e.topLevel).filter((e) => !!e);
      }
      findAllTopLevelElements() {
        return [...this.indexByFilePath.values()].map((perFile) => perFile.topLevel).filter((e) => !!e);
      }
      findInnerNameConflictsByPath(filePath) {
        const elementsToScan = this.indexByFilePath.get(filePath);
        if (!elementsToScan) {
          return [];
        }
        const results = [];
        for (const potentialConflicts of elementsToScan.innerElements.values()) {
          if (potentialConflicts.length > 1) {
            results.push(...potentialConflicts);
          }
        }
        return results;
      }
      getDependencyManager() {
        return this;
      }
      getSemqlFinder() {
        return this;
      }
      // implements ModelElementIndexer part
      indexModelElement(element) {
        this.addToMap(element, this.indexByQualifiedName, (e) => e.__meta.qualifiedName);
        this.addToMap(element, this.indexByType, (e) => e._type);
        const fileElements = this.indexByFilePath.get(element.__meta.filePath);
        if ("_package" in element && typeof element._package === "string") {
          if (fileElements !== void 0) {
            if (fileElements.topLevel) {
              this.removeElementsByQualifiedName(fileElements.topLevel.__meta.qualifiedName, { printIntegrityErrorMessages: false });
            }
            fileElements.topLevel = element;
          } else {
            this.indexByFilePath.set(element.__meta.filePath, {
              topLevel: element,
              innerElements: /* @__PURE__ */ new Map()
            });
          }
        } else {
          const innerElements = fileElements ? fileElements.innerElements : /* @__PURE__ */ new Map();
          this.addToMap(element, innerElements, (e) => e.__meta.qualifiedName);
          if (fileElements === void 0) {
            this.indexByFilePath.set(element.__meta.filePath, {
              innerElements
            });
          }
        }
        if (!element.__meta.parentQualifiedName) {
          if ("_package" in element && typeof element._package === "string") {
            if (element.__meta.runtimeData?.parentSimpleName) {
              this.indexTopLevelQualifiedName(element, element.__meta.filePath, {
                designQualifiedName: "",
                payloadQualifiedName: element.__meta.runtimeData.parentSimpleName
              });
            } else {
              this.indexTopLevelQualifiedName(element, element.__meta.filePath);
            }
          } else {
            this.indexTopLevelQualifiedName({ _package: "", ...element }, element.__meta.filePath);
          }
        } else {
          const parentQualifiedName = {
            designQualifiedName: element.__meta.parentQualifiedName,
            payloadQualifiedName: element.__meta.runtimeData?.partialQualifiedName ?? element.__meta.parentQualifiedName
          };
          this.indexInnerQualifiedName(parentQualifiedName, element.__meta.filePath, element, (0, qualified_name_1.createInnerQualifiedNameFrom)(element));
        }
      }
      addToMap(element, map, keyExtractor) {
        const key = keyExtractor(element);
        const matches = map.get(key);
        if (matches === void 0) {
          map.set(key, [element]);
        } else {
          matches.push(element);
          map.set(key, matches);
        }
      }
      // implements FileLifecycle part
      commit() {
        this.indexSemql();
      }
      fileAdded(filePath, content) {
        if ((0, design_1.isModelElementBaseDesign)(content)) {
          try {
            this.indexTopLevelElement({ filePath, modelElement: content });
            return { didAdd: true };
          } catch (err) {
            if (err instanceof Error) {
              console.error(`could not index file '${filePath}': ${err.message}${err.stack ? `, ${err.stack}` : ""}`);
              return { didAdd: false, reason: err.message };
            }
            return { didAdd: false, reason: `${err}` };
          }
        }
        return { didAdd: false, reason: "Not a valid model element" };
      }
      indexTopLevelElement(modelElementToIndex) {
        const { modelElement, filePath } = modelElementToIndex;
        const metadataService = (0, model_element_metadata_1.createModelElementMetadataService)(this, filePath);
        switch (modelElement._type) {
          case top_level_1.TOP_LEVEL_ENUM.MODEL: {
            (0, model_indexer_1.indexModel)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_RETENTION_POLICY: {
            (0, retention_policy_indexer_1.indexRetentionPolicyDataHub)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_APPLICATION: {
            (0, application_indexer_1.indexApplication)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_COMPLEX_TYPE: {
            (0, complex_type_indexer_1.indexComplexType)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_DATABASE_VIEW: {
            (0, db_view_indexer_1.indexDatabaseView)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_ENRICHER_CACHE: {
            (0, enricher_cache_indexer_1.indexEnricherCache)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_LOV_TYPE: {
            (0, list_of_value_indexer_1.indexLovType)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_DIAGRAM: {
            (0, model_diagram_indexer_1.indexModelDiagram)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_VARIABLE: {
            (0, model_variable_indexer_1.indexModelEditionVariable)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_JOB: {
            (0, job_indexer_1.indexModelJob)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_PRIV_GRANT: {
            (0, model_priv_grant_indexer_1.indexModelPrivGrant)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_NAMED_QUERY: {
            (0, named_query_indexer_1.indexNamedQuery)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_PUBLISHER: {
            (0, publisher_indexer_1.indexPublisher)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_REFERENCE: {
            (0, reference_indexer_1.indexReference)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_SQL_FUNCTION: {
            (0, db_function_indexer_1.indexDbFunction)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_USER_DEFINED_TYPE: {
            (0, user_defined_type_indexer_1.indexUserDefinedType)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_WORKFLOW: {
            (0, workflow_indexer_1.indexWorkflow)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.MODEL_ENTITY: {
            (0, entity_indexer_1.indexEntity)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_PLUGIN_VALIDATION:
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_SEMQL_VALIDATION: {
            (0, validation_indexer_1.indexConstraint)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_ACTION_SET: {
            (0, action_set_indexer_1.indexActionSet)(modelElement, this, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_BUSINESS_VIEW: {
            (0, business_view_indexer_1.indexBusinessObjectView)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_COLLECTION_VIEW: {
            (0, collection_view_indexer_1.indexCollectionView)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_DISPLAY_CARD: {
            (0, display_card_indexer_1.indexDisplayCard)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_DUPS_MANAGER: {
            (0, dups_manager_indexer_1.indexDupsManager)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_SEMQL_ENRICHER:
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_REST_CLIENT_ENRICHER:
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_JAVA_PLUGIN_ENRICHER: {
            (0, enricher_indexer_1.indexEnricher)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_FORM: {
            (0, form_indexer_1.indexForm)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_SEARCH_FORM: {
            (0, search_form_indexer_1.indexSearchForm)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_STEPPER: {
            (0, stepper_indexer_1.indexStepper)(modelElement, metadataService, this);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_ID_SURVIVORSHIP_RULE:
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_STANDARD_SURVIVORSHIP_RULE: {
            (0, survivorship_rule_indexer_1.indexSurvivorshipRule)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_UNIQUE_KEY: {
            (0, unique_key_indexer_1.indexUniqueKey)(modelElement, metadataService);
            break;
          }
          case top_level_1.TOP_LEVEL_ENUM.ENTITY_FUZZY_LOOKUP_RULE: {
            (0, fuzzy_lookup_rule_indexer_1.indexFuzzyLookupRule)(modelElement, metadataService);
            break;
          }
        }
      }
      indexSemql() {
        this.nukeSemql();
        const entities = this.findModelElementsByTypes(["Entity"]);
        const complexTypes = this.findModelElementsByTypes([
          "ComplexType"
        ]);
        const modelVariables = this.findModelElementsByTypes([
          "ModelVariable"
        ]);
        const sqlFunctions = this.findModelElementsByTypes([
          "SqlFunction"
        ]);
        modelVariables.forEach((modelVariable) => {
          (0, bind_variable_semql_indexer_1.indexBindVariableSemql)(modelVariable, this);
        });
        sqlFunctions.forEach((sqlFunction) => {
          (0, function_semql_indexer_1.indexFunctionSemql)(sqlFunction, this);
        });
        (0, view_semql_indexer_1.indexViews)(entities, this);
        complexTypes.forEach((complexType) => (0, complex_type_indexer_2.indexComplexTypeSemql)(complexType, this));
      }
      nukeSemql() {
        this.bindVariablesSemql.clear();
        this.functionsSemql.clear();
        this.qualifiedNameToComplexTypeSemql.clear();
        this.qualifiedNameToViews.clear();
      }
      fileRemoved(filePath, options = { printIntegrityErrorMessages: false }) {
        return this.removeElementsByFilePath(filePath, options);
      }
      removeElementsByFilePath(filePath, options) {
        const outcome = {
          didRemove: false,
          isConsistent: true,
          removedModel: false
        };
        const fileElements = this.indexByFilePath.get(filePath);
        if (!fileElements) {
          return outcome;
        }
        outcome.didRemove = this.indexByFilePath.delete(filePath);
        if (fileElements.topLevel) {
          const res = this.removeElementsByQualifiedName(fileElements.topLevel.__meta.qualifiedName, options);
          outcome.didRemove = outcome.didRemove || res.didRemove;
          outcome.isConsistent = outcome.isConsistent && res.isConsistent;
          outcome.removedModel = fileElements.topLevel._type === top_level_1.TOP_LEVEL_ENUM.MODEL;
        }
        for (const innerQualifiedName of fileElements.innerElements.keys()) {
          const res = this.removeElementsByQualifiedName(innerQualifiedName, options);
          outcome.didRemove = outcome.didRemove || res.didRemove;
          outcome.isConsistent = outcome.isConsistent && res.isConsistent;
        }
        return outcome;
      }
      /**
       * Caution, this method will not clean indexByFilePath!
       */
      removeElementsByQualifiedName(qualifiedName, options) {
        const outcome = {
          didRemove: false,
          isConsistent: true,
          removedModel: false
        };
        const elements = this.indexByQualifiedName.get(qualifiedName);
        if (!elements) {
          if (options.printIntegrityErrorMessages) {
            console.debug(`detected integrity issue with memory model maps: expected indexByQualifiedName to reference ${qualifiedName}`);
          }
          outcome.isConsistent = false;
          return outcome;
        }
        outcome.didRemove = this.indexByQualifiedName.delete(qualifiedName);
        if (!this.qualifiedNameToModelElement.delete(qualifiedName) && options.printIntegrityErrorMessages) {
          console.debug(`detected integrity issue with memory model maps: expected qualifiedNameToModelElement to reference ${qualifiedName} (legacy structure)`);
          outcome.isConsistent = false;
        }
        for (const element of elements) {
          const typeRemoval = this.removeFromMap(element, (e) => e._type, this.indexByType, (e) => e === element, "indexByType", options);
          outcome.isConsistent = outcome.isConsistent && typeRemoval.isConsistent;
          this.removeFromMap(element, (e) => e._type, this.typeToModelElements, (e) => e.designQualifiedName === element.__meta.qualifiedName, "typeToModelElements", options);
        }
        return outcome;
      }
      // This is based on object identity, it can only work if adding to map preserve object identity accross the different maps!
      removeFromMap(elementToRemove, keyExtractor, map, comparator, mapName, options) {
        const key = keyExtractor(elementToRemove);
        const elements = map.get(key);
        let isConsistent = true;
        if (!elements) {
          if (options.printIntegrityErrorMessages) {
            console.debug(`detected integrity issue with memory model maps: expected ${mapName} to reference ${key}`);
          }
          return { isConsistent: false };
        }
        const indexOf = elements.findIndex(comparator);
        if (indexOf === -1) {
          if (options.printIntegrityErrorMessages) {
            const str = JSON.stringify(elementToRemove, void 0, 2);
            console.debug(`detected integrity issue with memory model maps: expected ${mapName} values for ${key} to contains ${str}`);
            isConsistent = false;
          }
        }
        elements.splice(indexOf, 1);
        if (elements.length === 0) {
          map.delete(key);
        }
        return { isConsistent };
      }
      // DependencyManager
      fileDependencies = /* @__PURE__ */ new Map();
      reverseFileDependencies = /* @__PURE__ */ new Map();
      addDependency(from, to) {
        let deps = this.fileDependencies.get(to);
        if (deps) {
          deps[from] = true;
        } else {
          deps = {};
          deps[from] = true;
          this.fileDependencies.set(to, deps);
        }
        let rev = this.reverseFileDependencies.get(from);
        if (rev) {
          rev[to] = true;
        } else {
          rev = {};
          rev[to] = true;
          this.reverseFileDependencies.set(from, rev);
        }
      }
      removeDependency(from, to) {
        const deps = this.fileDependencies.get(to);
        if (deps) {
          delete deps[from];
        }
        const rev = this.reverseFileDependencies.get(from);
        if (rev) {
          delete rev[to];
        }
      }
      getDependencies(filePath, degrees = -1) {
        if (degrees === 0) {
          return [];
        }
        const topologicalSort = [];
        const seen = /* @__PURE__ */ new Set([filePath]);
        const queue = Object.keys(this.fileDependencies.get(filePath) ?? {}).map((e) => ({
          value: e,
          degree: 1
        })) ?? [];
        let node = queue.shift();
        while (node !== void 0) {
          if (seen.has(node.value)) {
            node = queue.shift();
            continue;
          }
          seen.add(node.value);
          topologicalSort.push(node.value);
          if (degrees < 0 || node.degree < degrees) {
            const degree = node.degree + 1;
            const dependencies = Object.keys(this.fileDependencies.get(node.value) ?? {}).filter((e) => !seen.has(e));
            queue.push(...dependencies.map((d) => ({ value: d, degree })));
          }
          node = queue.shift();
        }
        return topologicalSort;
      }
      clearDependencies(filePath) {
        const deps = this.fileDependencies.get(filePath);
        if (deps) {
          for (const from in deps) {
            this.removeDependency(from, filePath);
          }
        }
        const revs = this.reverseFileDependencies.get(filePath);
        if (revs) {
          for (const to in revs) {
            this.removeDependency(filePath, to);
          }
        }
        this.fileDependencies.delete(filePath);
        this.reverseFileDependencies.delete(filePath);
      }
    };
    exports2.MemoryModel = MemoryModel;
    function createMemoryModel() {
      return new MemoryModel();
    }
    function createMutableModelElementQueries() {
      return createMemoryModel();
    }
    function createModelElementQueries() {
      return createMutableModelElementQueries();
    }
    function indexTopLevelElements(topLevelElements) {
      const memoryModel = new MemoryModel();
      for (const topLevelElement of topLevelElements) {
        memoryModel.fileAdded(topLevelElement.filePath, topLevelElement.modelElement);
      }
      memoryModel.commit();
      return memoryModel;
    }
  }
});

// ../../packages/xdm-schema/out/memory/index.js
var require_memory = __commonJS({
  "../../packages/xdm-schema/out/memory/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TOP_LEVEL_ENUM = exports2.joinNames = exports2.indexTopLevelElements = exports2.createMutableModelElementQueries = exports2.createModelElementQueries = exports2.createMemoryModel = void 0;
    __exportStar2(require_dm(), exports2);
    __exportStar2(require_file_lifecycle_aware(), exports2);
    var memory_model_1 = require_memory_model();
    Object.defineProperty(exports2, "createMemoryModel", { enumerable: true, get: function() {
      return memory_model_1.createMemoryModel;
    } });
    Object.defineProperty(exports2, "createModelElementQueries", { enumerable: true, get: function() {
      return memory_model_1.createModelElementQueries;
    } });
    Object.defineProperty(exports2, "createMutableModelElementQueries", { enumerable: true, get: function() {
      return memory_model_1.createMutableModelElementQueries;
    } });
    Object.defineProperty(exports2, "indexTopLevelElements", { enumerable: true, get: function() {
      return memory_model_1.indexTopLevelElements;
    } });
    var qualified_name_1 = require_qualified_name();
    Object.defineProperty(exports2, "joinNames", { enumerable: true, get: function() {
      return qualified_name_1.joinNames;
    } });
    __exportStar2(require_semql(), exports2);
    var top_level_1 = require_top_level();
    Object.defineProperty(exports2, "TOP_LEVEL_ENUM", { enumerable: true, get: function() {
      return top_level_1.TOP_LEVEL_ENUM;
    } });
  }
});

// ../../packages/xdm-schema/out/mapper/application/app_action/abstract_app_action_mapper.js
var require_abstract_app_action_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/application/app_action/abstract_app_action_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapRootFolder = mapRootFolder;
    exports2.mapAbstractAppAction = mapAbstractAppAction;
    var memory_1 = require_memory();
    function mapRootFolder(rootFolder, modelElementQueries) {
      const results = [];
      if (!rootFolder) {
        return results;
      }
      const queue = [
        { action: rootFolder, isRoot: true }
      ];
      let current = queue.shift();
      while (current) {
        const action = current.action;
        if (action._type === "FolderAction") {
          queue.push(...action.appActions.map((e, i) => ({
            action: e,
            position: i,
            parentFolder: e.__meta.parentQualifiedName
          })));
        }
        results.push(mapAbstractAppAction(current, modelElementQueries));
        current = queue.shift();
      }
      return results;
    }
    function mapAbstractAppAction(toMap, modelElementQueries) {
      const action = toMap.action;
      if (action._type === "OpenDashboardAction") {
        return mapOpenDashboardAction(action, toMap.position);
      }
      const base = {
        qualifiedName: action.__meta.qualifiedName,
        posInFolder: toMap.position,
        parentFolder: toMap.isRoot ? void 0 : action.__meta.parentQualifiedName
      };
      switch (action._type) {
        case "BrowseBusinessViewAction": {
          return { ...base, ...mapBrowseBusinessViewAction(action) };
        }
        case "BrowseEntitiesFolderAction": {
          return { ...base, ...mapBrowseEntitiesFolderAction(action) };
        }
        case "CreateDataAppAction": {
          return { ...base, ...mapCreateDataAppAction(action) };
        }
        case "FolderAction": {
          return { ...base, ...mapFolderAction(action) };
        }
        case "GlobalSearchAction": {
          return { ...base, ...mapGlobalSearchAction(action) };
        }
        case "ImportDataAppAction": {
          return { ...base, ...mapImportDataAppAction(action) };
        }
        case "MyTasksAction": {
          return { ...base, ...mapMyTasksAction(action) };
        }
        case "OpenDocumentationAction": {
          return { ...base, ...mapOpenDocumentationAction(action) };
        }
        case "StartWorkflowAction": {
          return {
            ...base,
            ...mapStartWorkflowAction(action, modelElementQueries)
          };
        }
        case "UrlAction": {
          return { ...base, ...mapUrlAction(action) };
        }
        case "ViewProfileAction": {
          return { ...base, ...mapViewProfileAction(action) };
        }
      }
    }
    function mapViewProfileAction(viewProfileActionDesign) {
      return {
        _type: viewProfileActionDesign._type,
        useCustomLabel: !!viewProfileActionDesign.label,
        description: viewProfileActionDesign.description,
        icon: viewProfileActionDesign.icon,
        iconColor: viewProfileActionDesign.iconColor,
        image: viewProfileActionDesign.image,
        imageAlign: viewProfileActionDesign.imageAlign,
        imageMode: viewProfileActionDesign.imageMode,
        label: viewProfileActionDesign.label,
        labelColor: viewProfileActionDesign.labelColor,
        requiredRole: viewProfileActionDesign.requiredRole
      };
    }
    function mapUrlAction(urlActionDesign) {
      return {
        _type: urlActionDesign._type,
        useCustomLabel: !!urlActionDesign.label,
        description: urlActionDesign.description,
        icon: urlActionDesign.icon,
        iconColor: urlActionDesign.iconColor,
        image: urlActionDesign.image,
        imageAlign: urlActionDesign.imageAlign,
        imageMode: urlActionDesign.imageMode,
        label: urlActionDesign.label,
        labelColor: urlActionDesign.labelColor,
        requiredRole: urlActionDesign.requiredRole,
        target: urlActionDesign.target,
        url: urlActionDesign.url
      };
    }
    function mapStartWorkflowAction(startWorkflowActionDesign, modelElementQueries) {
      const startEvent = modelElementQueries.findByQualifiedName(startWorkflowActionDesign.startEvent).match;
      const workflow = startEvent ? modelElementQueries.findParentOf(startEvent, memory_1.TOP_LEVEL_ENUM.MODEL_WORKFLOW)?.__meta.qualifiedName ?? "" : "";
      return {
        _type: startWorkflowActionDesign._type,
        useCustomLabel: !!startWorkflowActionDesign.label,
        description: startWorkflowActionDesign.description,
        icon: startWorkflowActionDesign.icon,
        iconColor: startWorkflowActionDesign.iconColor,
        image: startWorkflowActionDesign.image,
        imageAlign: startWorkflowActionDesign.imageAlign,
        imageMode: startWorkflowActionDesign.imageMode,
        label: startWorkflowActionDesign.label,
        labelColor: startWorkflowActionDesign.labelColor,
        requiredRole: startWorkflowActionDesign.requiredRole,
        startEvent: startWorkflowActionDesign.startEvent,
        workflow
      };
    }
    function mapOpenDocumentationAction(openDocumentationActionDesign) {
      return {
        _type: openDocumentationActionDesign._type,
        useCustomLabel: !!openDocumentationActionDesign.label,
        description: openDocumentationActionDesign.description,
        icon: openDocumentationActionDesign.icon,
        iconColor: openDocumentationActionDesign.iconColor,
        image: openDocumentationActionDesign.image,
        imageAlign: openDocumentationActionDesign.imageAlign,
        imageMode: openDocumentationActionDesign.imageMode,
        label: openDocumentationActionDesign.label,
        labelColor: openDocumentationActionDesign.labelColor,
        requiredRole: openDocumentationActionDesign.requiredRole
      };
    }
    function mapOpenDashboardAction(action, posInFolder) {
      return {
        _type: action._type,
        qualifiedName: action.__meta.qualifiedName,
        useCustomLabel: !!action.label,
        description: action.description,
        icon: action.icon,
        iconColor: action.iconColor,
        image: action.image,
        imageAlign: action.imageAlign,
        imageMode: action.imageMode,
        label: action.label,
        labelColor: action.labelColor,
        requiredRole: action.requiredRole,
        dashboard: action.dashboard,
        dashboardApplication: action.dashboardApplication,
        parentFolder: action.__meta.parentQualifiedName,
        posInFolder,
        parameters: action.parameters ? action.parameters.map((actionDashboardParameterDesign) => mapActionDashboardParameter(actionDashboardParameterDesign)) : void 0
      };
    }
    function mapActionDashboardParameter(actionDashboardParameterDesign) {
      return {
        qualifiedName: actionDashboardParameterDesign.__meta.qualifiedName,
        _type: actionDashboardParameterDesign._type,
        value: actionDashboardParameterDesign.value,
        valueInterpreter: actionDashboardParameterDesign.valueInterpreter
      };
    }
    function mapMyTasksAction(myTasksActionDesign) {
      return {
        _type: myTasksActionDesign._type,
        useCustomLabel: !!myTasksActionDesign.label,
        description: myTasksActionDesign.description,
        icon: myTasksActionDesign.icon,
        iconColor: myTasksActionDesign.iconColor,
        image: myTasksActionDesign.image,
        imageAlign: myTasksActionDesign.imageAlign,
        imageMode: myTasksActionDesign.imageMode,
        label: myTasksActionDesign.label,
        labelColor: myTasksActionDesign.labelColor,
        requiredRole: myTasksActionDesign.requiredRole,
        badgeVisible: myTasksActionDesign.badgeVisible,
        badgeBackgroundColor: myTasksActionDesign.badgeBackgroundColor
      };
    }
    function mapImportDataAppAction(importDataAppActionDesign) {
      return {
        _type: importDataAppActionDesign._type,
        useCustomLabel: !!importDataAppActionDesign.label,
        description: importDataAppActionDesign.description,
        icon: importDataAppActionDesign.icon,
        iconColor: importDataAppActionDesign.iconColor,
        image: importDataAppActionDesign.image,
        imageAlign: importDataAppActionDesign.imageAlign,
        imageMode: importDataAppActionDesign.imageMode,
        label: importDataAppActionDesign.label,
        labelColor: importDataAppActionDesign.labelColor,
        requiredRole: importDataAppActionDesign.requiredRole,
        importAction: importDataAppActionDesign.importAction
      };
    }
    function mapGlobalSearchAction(globalSearchActionDesign) {
      return {
        _type: globalSearchActionDesign._type,
        useCustomLabel: !!globalSearchActionDesign.label,
        description: globalSearchActionDesign.description,
        icon: globalSearchActionDesign.icon,
        iconColor: globalSearchActionDesign.iconColor,
        image: globalSearchActionDesign.image,
        imageAlign: globalSearchActionDesign.imageAlign,
        imageMode: globalSearchActionDesign.imageMode,
        label: globalSearchActionDesign.label,
        labelColor: globalSearchActionDesign.labelColor,
        requiredRole: globalSearchActionDesign.requiredRole
      };
    }
    function mapFolderAction(folderActionDesign) {
      return {
        _type: folderActionDesign._type,
        useCustomLabel: !!folderActionDesign.label,
        description: folderActionDesign.description,
        icon: folderActionDesign.icon,
        iconColor: folderActionDesign.iconColor,
        image: folderActionDesign.image,
        imageAlign: folderActionDesign.imageAlign,
        imageMode: folderActionDesign.imageMode,
        label: folderActionDesign.label,
        labelColor: folderActionDesign.labelColor,
        requiredRole: folderActionDesign.requiredRole
      };
    }
    function mapCreateDataAppAction(createDataAppActionDesign) {
      return {
        _type: createDataAppActionDesign._type,
        useCustomLabel: !!createDataAppActionDesign.label,
        description: createDataAppActionDesign.description,
        icon: createDataAppActionDesign.icon,
        iconColor: createDataAppActionDesign.iconColor,
        image: createDataAppActionDesign.image,
        imageAlign: createDataAppActionDesign.imageAlign,
        imageMode: createDataAppActionDesign.imageMode,
        label: createDataAppActionDesign.label,
        labelColor: createDataAppActionDesign.labelColor,
        requiredRole: createDataAppActionDesign.requiredRole,
        createAction: createDataAppActionDesign.createAction
      };
    }
    function mapBrowseEntitiesFolderAction(browseEntitiesFolderActionDesign) {
      return {
        _type: browseEntitiesFolderActionDesign._type,
        useCustomLabel: !!browseEntitiesFolderActionDesign.label,
        description: browseEntitiesFolderActionDesign.description,
        icon: browseEntitiesFolderActionDesign.icon,
        iconColor: browseEntitiesFolderActionDesign.iconColor,
        image: browseEntitiesFolderActionDesign.image,
        imageAlign: browseEntitiesFolderActionDesign.imageAlign,
        imageMode: browseEntitiesFolderActionDesign.imageMode,
        label: browseEntitiesFolderActionDesign.label,
        labelColor: browseEntitiesFolderActionDesign.labelColor,
        requiredRole: browseEntitiesFolderActionDesign.requiredRole,
        lineageEnabled: browseEntitiesFolderActionDesign.lineageEnabled
      };
    }
    function mapBrowseBusinessViewAction(browseBusinessViewActionDesign) {
      return {
        _type: browseBusinessViewActionDesign._type,
        businessObjectView: browseBusinessViewActionDesign.businessView,
        nbRecordsBadgeVisible: browseBusinessViewActionDesign.nbRecordsBadgeVisible,
        useCustomLabel: !!browseBusinessViewActionDesign.label,
        appliedFilter: browseBusinessViewActionDesign.appliedFilter,
        businessViewIconOverride: browseBusinessViewActionDesign.businessViewIconOverride,
        businessViewLabelOverride: browseBusinessViewActionDesign.businessViewLabelOverride,
        businessViewRootLabelOverride: browseBusinessViewActionDesign.businessViewRootLabelOverride,
        businessViewRootPluralLabelOverride: browseBusinessViewActionDesign.businessViewRootPluralLabelOverride,
        description: browseBusinessViewActionDesign.description,
        icon: browseBusinessViewActionDesign.icon,
        iconColor: browseBusinessViewActionDesign.iconColor,
        image: browseBusinessViewActionDesign.image,
        imageAlign: browseBusinessViewActionDesign.imageAlign,
        imageMode: browseBusinessViewActionDesign.imageMode,
        label: browseBusinessViewActionDesign.label,
        labelColor: browseBusinessViewActionDesign.labelColor,
        nbRecordsBadgeBackgroundColor: browseBusinessViewActionDesign.nbRecordsBadgeBackgroundColor,
        requiredRole: browseBusinessViewActionDesign.requiredRole,
        useSearchOnOpen: browseBusinessViewActionDesign.useSearchOnOpen,
        viewType: browseBusinessViewActionDesign.viewType
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/application/documentation_config_mapper.js
var require_documentation_config_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/application/documentation_config_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapDocumentationConfig = mapDocumentationConfig;
    function mapDocumentationConfig(documentationConfigDesign) {
      return {
        documentation: documentationConfigDesign.documentation,
        documentationConfigDiagrams: documentationConfigDesign.documentationConfigDiagrams ? documentationConfigDesign.documentationConfigDiagrams.map((documentationConfigDiagramDesign, i) => mapDocumentationConfigDiagram(documentationConfigDiagramDesign, i)) : void 0
      };
    }
    function mapDocumentationConfigDiagram(documentationConfigDiagramDesign, position) {
      return {
        label: documentationConfigDiagramDesign.label,
        modelDiagram: documentationConfigDiagramDesign.modelDiagram,
        position,
        qualifiedName: documentationConfigDiagramDesign.__meta.qualifiedName
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/application/navigation_config_mapper.js
var require_navigation_config_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/application/navigation_config_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapNavigationConfig = mapNavigationConfig;
    function mapNavigationConfig(navigationConfigDesign) {
      return {
        navigationGroups: navigationConfigDesign.map((navigation, i) => mapAbstractNavigationGroup(navigation, i))
      };
    }
    function mapAbstractNavigationGroup(navigationGroupDesign, position) {
      switch (navigationGroupDesign._type) {
        case "FolderNavGroup": {
          return mapFolderNavigationGroup(navigationGroupDesign, position);
        }
        case "NavigationGroup": {
          return mapNavigationGroup(navigationGroupDesign, position);
        }
      }
    }
    function mapFolderNavigationGroup(folderNavigationGroupDesign, position) {
      return {
        qualifiedName: folderNavigationGroupDesign.__meta.qualifiedName,
        _type: "FolderNavigationGroup",
        dividerVisible: folderNavigationGroupDesign.dividerVisible,
        labelVisible: folderNavigationGroupDesign.dividerVisible,
        position,
        underlyingFolder: folderNavigationGroupDesign.linkedFolder
      };
    }
    function mapNavigationGroup(navigationGroupDesign, position) {
      return {
        qualifiedName: navigationGroupDesign.__meta.qualifiedName,
        _type: navigationGroupDesign._type,
        dividerVisible: navigationGroupDesign.dividerVisible,
        labelVisible: navigationGroupDesign.dividerVisible,
        position,
        label: navigationGroupDesign.label,
        navigationItems: navigationGroupDesign.actions?.map((e, i) => ({
          appAction: e.appAction,
          position: i
        }))
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/application/search_config_mapper.js
var require_search_config_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/application/search_config_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapGlobalSearchConfig = mapGlobalSearchConfig;
    function mapGlobalSearchConfig(globalSearchConfigDesign) {
      return {
        displaySearchForDropdown: globalSearchConfigDesign.displaySearchForDropdown,
        sortBoViewsAlphabetically: globalSearchConfigDesign.sortBusinessViewsAlphabetically,
        globalSearchBoViews: globalSearchConfigDesign.globalSearchBusinessViews ? globalSearchConfigDesign.globalSearchBusinessViews.map((globalSearchBusinessViewDesign, i) => mapGlobalSearchBoView(globalSearchBusinessViewDesign, i)) : void 0
      };
    }
    function mapGlobalSearchBoView(globalSearchBoViewDesign, position) {
      return {
        qualifiedName: globalSearchBoViewDesign.__meta.qualifiedName,
        viewType: globalSearchBoViewDesign.viewType,
        businessObjectView: globalSearchBoViewDesign.businessView,
        label: globalSearchBoViewDesign.label,
        maxResults: globalSearchBoViewDesign.maxResults,
        position,
        searchParameter: globalSearchBoViewDesign.searchParameter,
        searchTypeConfig: globalSearchBoViewDesign.searchTypeConfig
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/application/application_mapper.js
var require_application_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/application/application_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapApplication = mapApplication;
    var abstract_app_action_mapper_1 = require_abstract_app_action_mapper();
    var documentation_config_mapper_1 = require_documentation_config_mapper();
    var navigation_config_mapper_1 = require_navigation_config_mapper();
    var search_config_mapper_1 = require_search_config_mapper();
    function mapApplication(applicationDesign, modelElementQueries) {
      const abstractAppActions = (0, abstract_app_action_mapper_1.mapRootFolder)(applicationDesign.rootFolder, modelElementQueries);
      const navigationConfig = applicationDesign.navDrawer ? (0, navigation_config_mapper_1.mapNavigationConfig)(applicationDesign.navDrawer) : void 0;
      return {
        qualifiedName: applicationDesign.__meta.qualifiedName,
        activitiesSectionEnabled: true,
        applicationTitle: applicationDesign.applicationTitle,
        avatarImageUrl: applicationDesign.avatarImageUrl,
        certificationQueueEnabled: true,
        coverImageUrl: applicationDesign.coverImageUrl,
        dashboardEnabled: true,
        dashboardScope: "MODEL",
        defaultAction: applicationDesign.defaultAction,
        entitiesListEnabled: true,
        errorsNavigationEnabled: true,
        favIcon: applicationDesign.favIcon,
        historyBrowsingEnabled: applicationDesign.historyBrowsingEnabled,
        historyBrowsingRequiredRole: applicationDesign.historyBrowsingRequiredRole,
        homeSectionEnabled: true,
        lineageEnabled: true,
        logoUrl: applicationDesign.logoUrl,
        visibility: applicationDesign.visibility,
        description: applicationDesign.description,
        errorColor: applicationDesign.errorColor,
        label: applicationDesign.label,
        primaryColor: applicationDesign.primaryColor,
        requiredRoleName: applicationDesign.requiredRoleName,
        secondaryColor: applicationDesign.secondaryColor,
        titleBarAuthoringColor: applicationDesign.titleBarAuthoringColor,
        titleBarAuthoringContrastColor: applicationDesign.titleBarAuthoringContrastColor,
        titleBarDefaultColor: applicationDesign.titleBarDefaultColor,
        titleColor: applicationDesign.titleColor,
        titleBarDefaultContrastColor: applicationDesign.titleBarDefaultContrastColor,
        titleBarErrorColor: applicationDesign.titleBarErrorColor,
        titleBarErrorContrastColor: applicationDesign.titleBarErrorContrastColor,
        titleNavBarAuthoringColor: applicationDesign.titleNavBarAuthoringColor,
        titleNavBarAuthoringContrastColor: applicationDesign.titleNavBarAuthoringContrastColor,
        titleNavBarDefaultColor: applicationDesign.titleNavBarDefaultColor,
        titleNavBarDefaultContrastColor: applicationDesign.titleNavBarDefaultContrastColor,
        titleNavBarErrorColor: applicationDesign.titleNavBarErrorColor,
        titleNavBarErrorContrastColor: applicationDesign.titleNavBarErrorContrastColor,
        sortStrategy: applicationDesign.sortStrategy,
        documentationConfig: applicationDesign.documentationConfig ? (0, documentation_config_mapper_1.mapDocumentationConfig)(applicationDesign.documentationConfig) : void 0,
        globalSearchConfig: applicationDesign.globalSearchConfig ? (0, search_config_mapper_1.mapGlobalSearchConfig)(applicationDesign.globalSearchConfig) : void 0,
        navigationConfig,
        abstractAppActions
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/complex_type/complex_type_mapper.js
var require_complex_type_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/complex_type/complex_type_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapComplexType = mapComplexType;
    function mapComplexType(complexTypeDesign) {
      const definitionAttributes = complexTypeDesign.attributes ? complexTypeDesign.attributes.map((attribute) => mapDefinitionAttribute(attribute)) : void 0;
      const subjectName = complexTypeDesign.displayName ? mapComplexTypeSubjectName(complexTypeDesign.displayName) : void 0;
      return {
        qualifiedName: complexTypeDesign.__meta.qualifiedName,
        description: complexTypeDesign.description,
        label: complexTypeDesign.label,
        subjectName,
        definitionAttributes
      };
    }
    function mapComplexTypeSubjectName(complexTypeDisplayNameDesign) {
      return {
        qualifiedName: complexTypeDisplayNameDesign.__meta.qualifiedName,
        _type: "ComplexTypeSubjectName",
        separator: complexTypeDisplayNameDesign.separator,
        subjectNameAttributes: complexTypeDisplayNameDesign.displayNameAttributes ? complexTypeDisplayNameDesign.displayNameAttributes.map((displayNameAttributeDesign) => mapSubjectNameAttribute(displayNameAttributeDesign)) : void 0
      };
    }
    function mapSubjectNameAttribute(displayNameAttributeDesign) {
      return {
        abstractAttribute: displayNameAttributeDesign.attribute
      };
    }
    function mapDefinitionAttribute(definitionAttributeDesign) {
      return {
        qualifiedName: definitionAttributeDesign.__meta.qualifiedName,
        _type: "DefinitionAttribute",
        abstractAtomicType: definitionAttributeDesign.dataType,
        goldenAttribute: definitionAttributeDesign.goldenAttribute ?? true,
        i18ned: definitionAttributeDesign.i18ned ?? false,
        mandatory: definitionAttributeDesign.mandatory ?? false,
        mandatoryValidationLabel: definitionAttributeDesign.mandatoryValidationLabel ?? "",
        multiValued: definitionAttributeDesign.multiValued ?? false,
        physicalColName: definitionAttributeDesign.physicalName,
        valueSeparator: definitionAttributeDesign.valueSeparator ?? "",
        description: definitionAttributeDesign.description,
        documentation: definitionAttributeDesign.documentation,
        label: definitionAttributeDesign.label,
        length: definitionAttributeDesign.length,
        precision: definitionAttributeDesign.precision,
        scale: definitionAttributeDesign.scale,
        searchable: definitionAttributeDesign.searchable
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/db_function/db_function_mapper.js
var require_db_function_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/db_function/db_function_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapSqlFunction = mapSqlFunction;
    function mapSqlFunction(sqlFunctionDesign) {
      return {
        qualifiedName: sqlFunctionDesign.__meta.qualifiedName,
        aggregateFunction: sqlFunctionDesign.aggregateFunction,
        categories: sqlFunctionDesign.categories,
        description: sqlFunctionDesign.description,
        procedure: sqlFunctionDesign.procedure,
        schema: sqlFunctionDesign.schema,
        functionArguments: sqlFunctionDesign.functionArguments ? sqlFunctionDesign.functionArguments.map((functionArgumentDesign, i) => mapFunctionArgument(functionArgumentDesign, i)) : void 0
      };
    }
    function mapFunctionArgument(functionArgumentDesign, position) {
      return {
        qualifiedName: functionArgumentDesign.__meta.qualifiedName,
        position,
        array: functionArgumentDesign.array,
        mandatory: functionArgumentDesign.mandatory
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/db_view/db_view_mapper.js
var require_db_view_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/db_view/db_view_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapDatabaseView = mapDatabaseView;
    function mapDatabaseView(databaseViewDesign) {
      return {
        qualifiedName: databaseViewDesign.__meta.qualifiedName,
        entity: databaseViewDesign.entity,
        physicalName: databaseViewDesign.physicalName,
        viewType: databaseViewDesign.viewType,
        databaseViewColumns: databaseViewDesign.databaseViewColumns,
        description: databaseViewDesign.description,
        filter: databaseViewDesign.filter,
        label: databaseViewDesign.label
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/enricher_cache/enricher_cache_mapper.js
var require_enricher_cache_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/enricher_cache/enricher_cache_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapEnricherCache = mapEnricherCache;
    function mapEnricherCache(enricherCacheDesign) {
      return {
        qualifiedName: enricherCacheDesign.__meta.qualifiedName,
        cacheTableName: enricherCacheDesign.cacheTableName,
        cacheValidity: enricherCacheDesign.cacheValidity,
        pluginIdOrRestClientName: enricherCacheDesign.pluginIdOrRestClientName,
        batchUpdateSize: enricherCacheDesign.batchUpdateSize,
        enricherCacheParams: enricherCacheDesign.enricherCacheParams,
        outputList: enricherCacheDesign.outputList
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/action_set/ation_set_mapper.js
var require_ation_set_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/action_set/ation_set_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapActionSet = mapActionSet;
    exports2.mapStartWorkflowEntityAction = mapStartWorkflowEntityAction;
    exports2.mapReviewSuggestions = mapReviewSuggestions;
    exports2.mapReviewAndConfirm = mapReviewAndConfirm;
    exports2.mapMergeOrSplit = mapMergeOrSplit;
    exports2.mapMassUpdateAction = mapMassUpdateAction;
    exports2.mapImportAction = mapImportAction;
    exports2.mapExportAction = mapExportAction;
    exports2.mapExplainRecordAction = mapExplainRecordAction;
    exports2.mapEditAction = mapEditAction;
    exports2.mapDirectConfirmDupsAction = mapDirectConfirmDupsAction;
    exports2.mapDeleteAction = mapDeleteAction;
    exports2.mapCreateAction = mapCreateAction;
    exports2.mapCopyAction = mapCopyAction;
    exports2.mapBrowseGraphAction = mapBrowseGraphAction;
    var memory_1 = require_memory();
    function mapActionSet(actionSetDesign, modelElementQueries) {
      return {
        qualifiedName: actionSetDesign.__meta.qualifiedName,
        defaultActionSet: actionSetDesign.defaultActionSet ?? false,
        description: actionSetDesign.description ?? "",
        label: actionSetDesign.label,
        actions: actionSetDesign.actions ? actionSetDesign.actions.map((actionDesign) => mapAction(actionDesign, modelElementQueries)) : void 0
      };
    }
    function mapAction(actionDesign, modelElementQueries) {
      switch (actionDesign._type) {
        case "BrowseGraphAction": {
          return mapBrowseGraphAction(actionDesign);
        }
        case "CopyAction": {
          return mapCopyAction(actionDesign);
        }
        case "CreateAction": {
          return mapCreateAction(actionDesign);
        }
        case "DeleteAction": {
          return mapDeleteAction(actionDesign);
        }
        case "DirectConfirmDupsAction": {
          return mapDirectConfirmDupsAction(actionDesign);
        }
        case "EditAction": {
          return mapEditAction(actionDesign);
        }
        case "ExplainRecordAction": {
          return mapExplainRecordAction(actionDesign);
        }
        case "ExportAction": {
          return mapExportAction(actionDesign);
        }
        case "ImportAction": {
          return mapImportAction(actionDesign);
        }
        case "MassUpdateAction": {
          return mapMassUpdateAction(actionDesign);
        }
        case "MergeOrSplit": {
          return mapMergeOrSplit(actionDesign);
        }
        case "ReviewAndConfirm": {
          return mapReviewAndConfirm(actionDesign);
        }
        case "ReviewSuggestions": {
          return mapReviewSuggestions(actionDesign);
        }
        case "StartWorkflowEntityAction": {
          return mapStartWorkflowEntityAction(actionDesign, modelElementQueries);
        }
      }
    }
    function mapStartWorkflowEntityAction(startWorkflowEntityActionDesign, modelElementQueries) {
      const startEvent = modelElementQueries.findByQualifiedName(startWorkflowEntityActionDesign.startEvent).match;
      const workflowName = startEvent ? modelElementQueries.findParentOf(startEvent, memory_1.TOP_LEVEL_ENUM.MODEL_WORKFLOW)?.__meta.qualifiedName ?? "" : "";
      return {
        qualifiedName: startWorkflowEntityActionDesign.__meta.qualifiedName,
        _type: startWorkflowEntityActionDesign._type,
        description: startWorkflowEntityActionDesign.description ?? "",
        label: startWorkflowEntityActionDesign.label,
        useCustomLabel: startWorkflowEntityActionDesign.useCustomLabel,
        waitDialogEnabled: startWorkflowEntityActionDesign.waitDialogEnabled ?? false,
        iconUrl: startWorkflowEntityActionDesign.iconUrl,
        requiredRole: startWorkflowEntityActionDesign.requiredRole,
        itemsLimit: startWorkflowEntityActionDesign.itemsLimit,
        startEventName: startWorkflowEntityActionDesign.startEvent,
        workflowName
      };
    }
    function mapReviewSuggestions(reviewSuggestionsDesign) {
      return {
        qualifiedName: reviewSuggestionsDesign.__meta.qualifiedName,
        _type: reviewSuggestionsDesign._type,
        description: reviewSuggestionsDesign.description ?? "",
        label: reviewSuggestionsDesign.label,
        useCustomLabel: reviewSuggestionsDesign.useCustomLabel,
        waitDialogEnabled: reviewSuggestionsDesign.waitDialogEnabled ?? false,
        iconUrl: reviewSuggestionsDesign.iconUrl,
        requiredRole: reviewSuggestionsDesign.requiredRole,
        condition: reviewSuggestionsDesign.condition,
        itemsLimit: reviewSuggestionsDesign.itemsLimit,
        dupsManager: reviewSuggestionsDesign.dupsManager,
        enableEdit: reviewSuggestionsDesign.enableEdit ?? true,
        mandateResolveAllSuggestions: reviewSuggestionsDesign.mandateResolveAllSuggestions ?? false,
        onAcceptPromptGoldenId: reviewSuggestionsDesign.onAcceptPromptGoldenId ?? false
      };
    }
    function mapReviewAndConfirm(reviewAndConfirmDesign) {
      return {
        qualifiedName: reviewAndConfirmDesign.__meta.qualifiedName,
        _type: reviewAndConfirmDesign._type,
        description: reviewAndConfirmDesign.description ?? "",
        label: reviewAndConfirmDesign.label,
        useCustomLabel: reviewAndConfirmDesign.useCustomLabel,
        waitDialogEnabled: reviewAndConfirmDesign.waitDialogEnabled ?? false,
        iconUrl: reviewAndConfirmDesign.iconUrl,
        requiredRole: reviewAndConfirmDesign.requiredRole,
        condition: reviewAndConfirmDesign.condition,
        itemsLimit: reviewAndConfirmDesign.itemsLimit,
        dupsManager: reviewAndConfirmDesign.dupsManager,
        enableEdit: reviewAndConfirmDesign.enableEdit ?? true,
        mandateConfirmAll: reviewAndConfirmDesign.mandateConfirmAll ?? false
      };
    }
    function mapMergeOrSplit(mergeOrSplitDesign) {
      return {
        qualifiedName: mergeOrSplitDesign.__meta.qualifiedName,
        _type: mergeOrSplitDesign._type,
        description: mergeOrSplitDesign.description ?? "",
        label: mergeOrSplitDesign.label,
        useCustomLabel: mergeOrSplitDesign.useCustomLabel,
        waitDialogEnabled: mergeOrSplitDesign.waitDialogEnabled ?? false,
        iconUrl: mergeOrSplitDesign.iconUrl,
        requiredRole: mergeOrSplitDesign.requiredRole,
        condition: mergeOrSplitDesign.condition,
        itemsLimit: mergeOrSplitDesign.itemsLimit,
        dupsManager: mergeOrSplitDesign.dupsManager,
        enableEdit: mergeOrSplitDesign.enableEdit ?? true
      };
    }
    function mapMassUpdateAction(massUpdateActionDesign) {
      return {
        qualifiedName: massUpdateActionDesign.__meta.qualifiedName,
        _type: massUpdateActionDesign._type,
        description: massUpdateActionDesign.description ?? "",
        label: massUpdateActionDesign.label,
        useCustomLabel: massUpdateActionDesign.useCustomLabel,
        waitDialogEnabled: massUpdateActionDesign.waitDialogEnabled ?? false,
        iconUrl: massUpdateActionDesign.iconUrl,
        requiredRole: massUpdateActionDesign.requiredRole,
        stepper: massUpdateActionDesign.stepper,
        availableForErrorData: massUpdateActionDesign.availableForErrorData,
        availableForGoldenData: massUpdateActionDesign.availableForGoldenData,
        availableForMasterData: massUpdateActionDesign.availableForMasterData,
        condition: massUpdateActionDesign.condition,
        itemsLimit: massUpdateActionDesign.itemsLimit
      };
    }
    function mapImportAction(importActionDesign) {
      return {
        qualifiedName: importActionDesign.__meta.qualifiedName,
        _type: importActionDesign._type,
        description: importActionDesign.description ?? "",
        label: importActionDesign.label,
        useCustomLabel: importActionDesign.useCustomLabel,
        waitDialogEnabled: importActionDesign.waitDialogEnabled ?? false,
        iconUrl: importActionDesign.iconUrl,
        requiredRole: importActionDesign.requiredRole,
        allowOtherPublishers: importActionDesign.allowOtherPublishers ?? true,
        importedRecordType: importActionDesign.importedRecordType,
        importMode: importActionDesign.importMode,
        defaultPublisher: importActionDesign.defaultPublisher,
        stepper: importActionDesign.stepper
      };
    }
    function mapExportAction(exportActionDesign) {
      return {
        qualifiedName: exportActionDesign.__meta.qualifiedName,
        _type: exportActionDesign._type,
        description: exportActionDesign.description ?? "",
        label: exportActionDesign.label,
        useCustomLabel: exportActionDesign.useCustomLabel,
        waitDialogEnabled: exportActionDesign.waitDialogEnabled ?? false,
        iconUrl: exportActionDesign.iconUrl,
        requiredRole: exportActionDesign.requiredRole,
        itemsLimit: exportActionDesign.itemsLimit
      };
    }
    function mapExplainRecordAction(explainRecordActionDesign) {
      return {
        qualifiedName: explainRecordActionDesign.__meta.qualifiedName,
        _type: explainRecordActionDesign._type,
        description: explainRecordActionDesign.description ?? "",
        label: explainRecordActionDesign.label,
        useCustomLabel: explainRecordActionDesign.useCustomLabel,
        waitDialogEnabled: explainRecordActionDesign.waitDialogEnabled ?? false,
        condition: explainRecordActionDesign.condition,
        iconUrl: explainRecordActionDesign.iconUrl,
        requiredRole: explainRecordActionDesign.requiredRole,
        displayCard: explainRecordActionDesign.displayCard,
        formTab: explainRecordActionDesign.formTab
      };
    }
    function mapEditAction(editActionDesign) {
      return {
        qualifiedName: editActionDesign.__meta.qualifiedName,
        _type: editActionDesign._type,
        description: editActionDesign.description ?? "",
        label: editActionDesign.label,
        useCustomLabel: editActionDesign.useCustomLabel,
        waitDialogEnabled: editActionDesign.waitDialogEnabled ?? false,
        multipleSelectionAllowed: editActionDesign.multipleSelectionAllowed ?? true,
        availableForErrorData: editActionDesign.availableForErrorData,
        availableForGoldenData: editActionDesign.availableForGoldenData,
        availableForMasterData: editActionDesign.availableForMasterData,
        condition: editActionDesign.condition,
        iconUrl: editActionDesign.iconUrl,
        itemsLimit: editActionDesign.itemsLimit,
        requiredRole: editActionDesign.requiredRole,
        stepper: editActionDesign.stepper
      };
    }
    function mapDirectConfirmDupsAction(directConfirmDupsActionDesign) {
      return {
        qualifiedName: directConfirmDupsActionDesign.__meta.qualifiedName,
        _type: directConfirmDupsActionDesign._type,
        description: directConfirmDupsActionDesign.description ?? "",
        label: directConfirmDupsActionDesign.label,
        useCustomLabel: directConfirmDupsActionDesign.useCustomLabel,
        waitDialogEnabled: directConfirmDupsActionDesign.waitDialogEnabled ?? false,
        iconUrl: directConfirmDupsActionDesign.iconUrl,
        requiredRole: directConfirmDupsActionDesign.requiredRole,
        condition: directConfirmDupsActionDesign.condition,
        itemsLimit: directConfirmDupsActionDesign.itemsLimit,
        modelJob: directConfirmDupsActionDesign.modelJob
      };
    }
    function mapDeleteAction(deleteActionDesign) {
      return {
        qualifiedName: deleteActionDesign.__meta.qualifiedName,
        _type: deleteActionDesign._type,
        description: deleteActionDesign.description ?? "",
        label: deleteActionDesign.label,
        useCustomLabel: deleteActionDesign.useCustomLabel,
        waitDialogEnabled: deleteActionDesign.waitDialogEnabled ?? false,
        iconUrl: deleteActionDesign.iconUrl,
        requiredRole: deleteActionDesign.requiredRole,
        deleteType: deleteActionDesign.deleteType,
        multipleSelectionAllowed: deleteActionDesign.multipleSelectionAllowed ?? true,
        availableForGoldenData: deleteActionDesign.availableForGoldenData,
        availableForMasterData: deleteActionDesign.availableForMasterData,
        condition: deleteActionDesign.condition,
        itemsLimit: deleteActionDesign.itemsLimit,
        modelJob: deleteActionDesign.modelJob
      };
    }
    function mapCreateAction(createActionDesign) {
      return {
        qualifiedName: createActionDesign.__meta.qualifiedName,
        _type: createActionDesign._type,
        description: createActionDesign.description ?? "",
        label: createActionDesign.label,
        useCustomLabel: createActionDesign.useCustomLabel,
        waitDialogEnabled: createActionDesign.waitDialogEnabled ?? false,
        iconUrl: createActionDesign.iconUrl,
        requiredRole: createActionDesign.requiredRole,
        allowOtherPublishers: createActionDesign.allowOtherPublishers ?? true,
        createdRecordType: createActionDesign.createdRecordType,
        createMultiple: createActionDesign.createMultiple,
        defaultPublisher: createActionDesign.defaultPublisher,
        stepper: createActionDesign.stepper
      };
    }
    function mapCopyAction(copyActionDesign) {
      return {
        qualifiedName: copyActionDesign.__meta.qualifiedName,
        _type: copyActionDesign._type,
        description: copyActionDesign.description ?? "",
        label: copyActionDesign.label,
        useCustomLabel: copyActionDesign.useCustomLabel,
        waitDialogEnabled: copyActionDesign.waitDialogEnabled ?? false,
        iconUrl: copyActionDesign.iconUrl,
        requiredRole: copyActionDesign.requiredRole,
        multipleSelectionAllowed: copyActionDesign.multipleSelectionAllowed ?? true,
        condition: copyActionDesign.condition,
        itemsLimit: copyActionDesign.itemsLimit,
        stepper: copyActionDesign.stepper
      };
    }
    function mapBrowseGraphAction(browseGraphActionDesign) {
      return {
        qualifiedName: browseGraphActionDesign.__meta.qualifiedName,
        _type: browseGraphActionDesign._type,
        description: browseGraphActionDesign.description ?? "",
        label: browseGraphActionDesign.label,
        useCustomLabel: browseGraphActionDesign.useCustomLabel,
        waitDialogEnabled: browseGraphActionDesign.waitDialogEnabled ?? false,
        iconUrl: browseGraphActionDesign.iconUrl,
        requiredRole: browseGraphActionDesign.requiredRole
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/attribute_mapper.js
var require_attribute_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/attribute_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapEntityAttributes = mapEntityAttributes;
    var memory_1 = require_memory();
    function mapEntityAttributes(entity, modelElementQueries) {
      const result = {
        pk: null,
        atomic: [],
        complex: []
      };
      for (const attr of entity.attributes) {
        const qualifiedName = attr.__meta.qualifiedName;
        if (entity.primaryKey === qualifiedName) {
          result.pk = mapPkAttribute(entity, attr);
        } else {
          const complexType = modelElementQueries.findByQualifiedName(attr.dataType, memory_1.TOP_LEVEL_ENUM.MODEL_COMPLEX_TYPE);
          if (complexType.match) {
            result.complex.push(mapComplexAttribute(attr));
          } else {
            result.atomic.push(mapAtomicAttribute(attr));
          }
        }
      }
      return result;
    }
    function mapPkAttribute(entity, pkAttributeDesign) {
      return {
        qualifiedName: pkAttributeDesign.__meta.qualifiedName,
        _type: "PKAttribute",
        abstractAtomicType: pkAttributeDesign.dataType,
        goldenAttribute: pkAttributeDesign.goldenAttribute ?? true,
        i18ned: pkAttributeDesign.i18ned ?? false,
        mandatory: pkAttributeDesign.mandatory ?? false,
        multiValued: pkAttributeDesign.multiValued ?? false,
        physicalColName: pkAttributeDesign.physicalName,
        valueSeparator: pkAttributeDesign.valueSeparator ?? "",
        description: pkAttributeDesign.description,
        documentation: pkAttributeDesign.documentation,
        fuzzyMatchedEntityGoldenIdGenerationType: entity.goldenIdGeneration?.mode,
        fuzzyMatchedEntityGoldenIdSequenceStartsWith: entity.goldenIdGeneration?.startWith,
        idExpression: entity.sourceIdGeneration?.idExpression,
        idGenerationType: entity.sourceIdGeneration?.mode,
        idSequenceStartsWith: entity.sourceIdGeneration?.startWith,
        label: pkAttributeDesign.label,
        length: pkAttributeDesign.length,
        precision: pkAttributeDesign.precision,
        scale: pkAttributeDesign.scale,
        searchable: pkAttributeDesign.searchable
      };
    }
    function mapAtomicAttribute(atomicAttributeDesign) {
      return {
        qualifiedName: atomicAttributeDesign.__meta.qualifiedName,
        _type: "AtomicAttribute",
        abstractAtomicType: atomicAttributeDesign.dataType,
        goldenAttribute: atomicAttributeDesign.goldenAttribute ?? true,
        i18ned: atomicAttributeDesign.i18ned ?? false,
        lovValidationScope: atomicAttributeDesign.lovValidationScope ?? "NONE",
        mandatory: atomicAttributeDesign.mandatory ?? false,
        mandatoryValidationLabel: atomicAttributeDesign.mandatoryValidationLabel ?? "",
        mandatoryValidationScope: atomicAttributeDesign.mandatoryValidationScope ?? "NONE",
        multiValued: atomicAttributeDesign.multiValued ?? false,
        physicalColName: atomicAttributeDesign.physicalName,
        valueSeparator: atomicAttributeDesign.valueSeparator ?? "",
        description: atomicAttributeDesign.description,
        documentation: atomicAttributeDesign.documentation,
        label: atomicAttributeDesign.label,
        length: atomicAttributeDesign.length,
        precision: atomicAttributeDesign.precision,
        scale: atomicAttributeDesign.scale,
        searchable: atomicAttributeDesign.searchable
      };
    }
    function mapComplexAttribute(complexAttributeDesign) {
      return {
        qualifiedName: complexAttributeDesign.__meta.qualifiedName,
        _type: "ComplexAttribute",
        complexType: complexAttributeDesign.dataType,
        lovValidationScope: complexAttributeDesign.lovValidationScope ?? "NONE",
        mandatoryValidationScope: complexAttributeDesign.mandatoryValidationScope ?? "NONE",
        physicalPrefix: complexAttributeDesign.physicalName,
        description: complexAttributeDesign.description,
        documentation: complexAttributeDesign.documentation,
        label: complexAttributeDesign.label
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/business_view/business_view_mapper.js
var require_business_view_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/business_view/business_view_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapBusinessObjectView = mapBusinessObjectView;
    exports2.mapBoViewEntity = mapBoViewEntity;
    exports2.mapBoViewTransition = mapBoViewTransition;
    function mapBusinessObjectView(businessViewDesign) {
      const businessViewEntities = [];
      const rootBoViewEntity = mapBoViewEntity(businessViewDesign.rootBusinessViewEntity);
      businessViewEntities.push(rootBoViewEntity);
      exploreTransitions(businessViewDesign.rootBusinessViewEntity.transitions ?? [], businessViewEntities);
      return {
        qualifiedName: businessViewDesign.__meta.qualifiedName,
        displayRootNodeAs: businessViewDesign.displayRootNodeAs,
        enableHierarchyView: businessViewDesign.enableHierarchyView,
        filter: businessViewDesign.rootFilter ?? "1 = 1",
        rootBoViewEntity: businessViewDesign.rootBusinessViewEntity.__meta.qualifiedName,
        rootDescription: businessViewDesign.rootDescription ?? "",
        rootLabel: businessViewDesign.rootLabel,
        rootPluralLabel: businessViewDesign.rootPluralLabel,
        useHierarchyOnOpen: businessViewDesign.useHierarchyOnOpen,
        visible: true,
        description: businessViewDesign.description,
        iconUrl: businessViewDesign.rootIconUrl,
        label: businessViewDesign.label,
        requiredRoleName: businessViewDesign.requiredRoleName,
        boViewEntities: businessViewEntities
      };
    }
    function exploreTransitions(transitions, businessViewEntities) {
      transitions.forEach((transition) => {
        if (transition.businessViewEntity._type === "BusinessViewEntity") {
          const businessView = mapBoViewEntity(transition.businessViewEntity);
          businessViewEntities.push(businessView);
          exploreTransitions(transition.businessViewEntity.transitions ?? [], businessViewEntities);
        }
      });
    }
    function mapBoViewEntity(boViewEntityDesign) {
      return {
        qualifiedName: boViewEntityDesign.__meta.qualifiedName,
        collection: boViewEntityDesign.collection,
        displayRecordCount: boViewEntityDesign.displayRecordCount,
        enableUserDefinedSort: boViewEntityDesign.enableUserDefinedSort,
        entity: boViewEntityDesign.entity,
        form: boViewEntityDesign.form,
        gridAllowed: boViewEntityDesign.gridAllowed,
        listAllowed: boViewEntityDesign.listAllowed,
        outlineVisible: boViewEntityDesign.outlineVisible,
        overrideDefaultSort: boViewEntityDesign.overrideDefaultSort,
        sortExpression: boViewEntityDesign.sortExpression ?? "",
        tableAllowed: boViewEntityDesign.tableAllowed,
        actionSet: boViewEntityDesign.actionSet,
        businessEntitySearchConfigs: boViewEntityDesign.businessEntitySearchConfigs ? boViewEntityDesign.businessEntitySearchConfigs.map((businessEntitySearchTypeConfigDesign) => mapBusinessEntitySearchTypeConfig(businessEntitySearchTypeConfigDesign)) : void 0,
        displayCard: boViewEntityDesign.displayCard,
        embeddedCollectionNavigations: boViewEntityDesign.embeddedCollectionNavigations ? boViewEntityDesign.embeddedCollectionNavigations.map((embeddedCollectionNavigationDesign) => mapEmbeddedCollectionNavigation(embeddedCollectionNavigationDesign)) : void 0,
        recordNodeDisplayCard: boViewEntityDesign.recordNodeDisplayCard,
        referenceAttributeNavigationConfigs: boViewEntityDesign.referenceAttributeNavigationConfigs ? boViewEntityDesign.referenceAttributeNavigationConfigs.map((referenceAttributeNavigationConfigDesign) => mapReferenceAttributeNavigationConfig(referenceAttributeNavigationConfigDesign)) : void 0,
        businessEntityBuiltInFilters: boViewEntityDesign.businessEntityBuiltInFilters ? boViewEntityDesign.businessEntityBuiltInFilters.map((businessEntityBuiltInFilterDesign) => mapBusinessEntityBuiltinFilter(businessEntityBuiltInFilterDesign)) : void 0,
        transitions: boViewEntityDesign.transitions ? boViewEntityDesign.transitions.map((boViewTransitionDesign) => mapBoViewTransition(boViewTransitionDesign)) : void 0
      };
    }
    function mapBusinessEntitySearchTypeConfig(businessEntitySearchTypeConfigDesign) {
      return {
        qualifiedName: businessEntitySearchTypeConfigDesign.__meta.qualifiedName,
        searchTypeConfig: {
          searchType: businessEntitySearchTypeConfigDesign.searchType,
          customForm: businessEntitySearchTypeConfigDesign.customForm,
          enabled: businessEntitySearchTypeConfigDesign.enabled
        }
      };
    }
    function mapReferenceAttributeNavigationConfig(referenceAttributeNavigationConfigDesign) {
      return {
        formField: referenceAttributeNavigationConfigDesign.formField,
        navigationMode: referenceAttributeNavigationConfigDesign.navigationMode,
        businessObjectView: referenceAttributeNavigationConfigDesign.businessView,
        form: referenceAttributeNavigationConfigDesign.form
      };
    }
    function mapEmbeddedCollectionNavigation(embeddedCollectionNavigationDesign) {
      return {
        browsingTarget: embeddedCollectionNavigationDesign.browsingTarget,
        formCollection: embeddedCollectionNavigationDesign.formCollection,
        businessObjectView: embeddedCollectionNavigationDesign.businessView,
        form: embeddedCollectionNavigationDesign.form
      };
    }
    function mapBusinessEntityBuiltinFilter(businessEntityBuiltInFilterDesign) {
      return {
        qualifiedName: businessEntityBuiltInFilterDesign.__meta.qualifiedName,
        _type: businessEntityBuiltInFilterDesign._type,
        semQlCondition: businessEntityBuiltInFilterDesign.semQlCondition,
        visible: businessEntityBuiltInFilterDesign.visible,
        description: businessEntityBuiltInFilterDesign.description,
        label: businessEntityBuiltInFilterDesign.label
      };
    }
    function mapBoViewTransition(boViewTransitionDesign) {
      let targetBoViewEntity;
      if (boViewTransitionDesign.businessViewEntity._type === "BusinessViewEntity") {
        targetBoViewEntity = boViewTransitionDesign.businessViewEntity.__meta.qualifiedName;
      } else {
        targetBoViewEntity = boViewTransitionDesign.businessViewEntity.ref;
      }
      return {
        qualifiedName: boViewTransitionDesign.__meta.qualifiedName,
        enableHierarchyInterpreter: boViewTransitionDesign.enableHierarchyInterpreter ?? "LITERAL",
        expandHierarchyByDefault: boViewTransitionDesign.expandHierarchyByDefault ?? false,
        filter: boViewTransitionDesign.filter ?? "1 = 1",
        targetBoViewEntity,
        transitionPath: boViewTransitionDesign.transitionPath ?? "",
        useCustomLabel: boViewTransitionDesign.useCustomLabel,
        description: boViewTransitionDesign.description,
        displayFormTabAs: boViewTransitionDesign.displayFormTabAs,
        displayTransitionNodeAs: boViewTransitionDesign.displayTransitionNodeAs,
        enableHierarchy: boViewTransitionDesign.enableHierarchy,
        formCollection: boViewTransitionDesign.formCollection,
        iconUrl: boViewTransitionDesign.iconUrl,
        label: boViewTransitionDesign.label,
        pluralLabel: boViewTransitionDesign.pluralLabel,
        transitionType: boViewTransitionDesign.transitionType,
        transitionVisible: boViewTransitionDesign.transitionVisible,
        transitionVisibleInterpreter: boViewTransitionDesign.transitionVisibleInterpreter,
        visibleInFormTabCondition: boViewTransitionDesign.visibleInFormTabCondition
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/checkbox_field_mapper.js
var require_checkbox_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/checkbox_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapCheckboxFieldComponentProperties = mapCheckboxFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapCheckboxFieldComponentProperties(checkboxFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(checkboxFieldDesign.__meta.qualifiedName, checkboxFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(checkboxFieldDesign.__meta.qualifiedName, checkboxFieldDesign),
        (0, component_properties_mapper_1.mapUseSwitchComponentProperty)(checkboxFieldDesign.__meta.qualifiedName, checkboxFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(checkboxFieldDesign.__meta.qualifiedName, checkboxFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapAuthoringLabelPositionComponentProperty)(checkboxFieldDesign.__meta.qualifiedName, checkboxFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/date_field_mapper.js
var require_date_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/date_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapDateFieldComponentProperties = mapDateFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapDateFieldComponentProperties(dateFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapEditingFormatComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapMaxDateComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapMinDateComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseTimePickerComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(dateFieldDesign.__meta.qualifiedName, dateFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/hyperlink_field_mapper.js
var require_hyperlink_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/hyperlink_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapHyperlinkFieldComponentProperties = mapHyperlinkFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapHyperlinkFieldComponentProperties(hyperlinkFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapLinkDisplayTextComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapLinkSourceTypeComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapLinkTargetComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(hyperlinkFieldDesign.__meta.qualifiedName, hyperlinkFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/id_field_mapper.js
var require_id_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/id_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapIdFieldComponentProperties = mapIdFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapIdFieldComponentProperties(idFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(idFieldDesign.__meta.qualifiedName, idFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(idFieldDesign.__meta.qualifiedName, idFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/image_field_mapper.js
var require_image_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/image_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapImageFieldComponentProperties = mapImageFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapImageFieldComponentProperties(imageFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapImageHeightComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapImageSourceTypeComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapFallbackImageComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapFallbackImageTypeComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapShowFullSizeOnClickComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapImageAlignComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapImageModeComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(imageFieldDesign.__meta.qualifiedName, imageFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/markdown_field_mapper.js
var require_markdown_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/markdown_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapMarkdownFieldComponentProperties = mapMarkdownFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapMarkdownFieldComponentProperties(markdownFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentWidthComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentHeightComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapIsCharCounterVisibleComponentProperty)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(markdownFieldDesign.__meta.qualifiedName, markdownFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/menu_field_mapper.js
var require_menu_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/menu_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapMenuFieldComponentProperties = mapMenuFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapMenuFieldComponentProperties(menuFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseAvatarInMenuComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapListSourceItemsComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapListSortComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapListSourceTypeComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(menuFieldDesign.__meta.qualifiedName, menuFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/object_field_mapper.js
var require_object_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/object_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapObjectFieldComponentProperties = mapObjectFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapObjectFieldComponentProperties(objectFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapObjectMaxWidthComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapObjectHeightComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapSourceTypeComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(objectFieldDesign.__meta.qualifiedName, objectFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/reference_field_mapper.js
var require_reference_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/reference_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapReferenceFieldComponentProperties = mapReferenceFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapReferenceFieldComponentProperties(referenceFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapChipMaxWidthComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayTypeComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseAvatarInChipComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseSecondaryTextInChipComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(referenceFieldDesign.__meta.qualifiedName, referenceFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/text_field_mapper.js
var require_text_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/text_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapTextFieldComponentProperties = mapTextFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapTextFieldComponentProperties(textFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapEditingFormatComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapIsMultilineComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapMultilineMaxLinesComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapMultilineMinLinesComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapIsCharCounterVisibleComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(textFieldDesign.__meta.qualifiedName, textFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(textFieldDesign.__meta.qualifiedName, textFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/chips_field_mapper.js
var require_chips_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/chips_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapChipsFieldComponentProperties = mapChipsFieldComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapChipsFieldComponentProperties(chipsFieldDesign) {
      return [
        (0, component_properties_mapper_1.mapHelperTextComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign),
        (0, component_properties_mapper_1.mapAuthoringModeComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign),
        (0, component_properties_mapper_1.mapTextAlignComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapTextTypographyComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapChipMaxWidthComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentBackgroundColorComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseAvatarInChipComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseSecondaryTextInChipComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.componentProperties),
        ...(0, component_properties_mapper_1.mapLabelComponentProperties)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.labelProperties),
        (0, component_properties_mapper_1.mapUseFloatingLabelComponentProperty)(chipsFieldDesign.__meta.qualifiedName, chipsFieldDesign.labelProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field_mapper.js
var require_form_field_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.uiComponentRegistryTypeToRuntimeDataType = void 0;
    exports2.mapFormField = mapFormField;
    var checkbox_field_mapper_1 = require_checkbox_field_mapper();
    var date_field_mapper_1 = require_date_field_mapper();
    var hyperlink_field_mapper_1 = require_hyperlink_field_mapper();
    var id_field_mapper_1 = require_id_field_mapper();
    var image_field_mapper_1 = require_image_field_mapper();
    var markdown_field_mapper_1 = require_markdown_field_mapper();
    var menu_field_mapper_1 = require_menu_field_mapper();
    var object_field_mapper_1 = require_object_field_mapper();
    var reference_field_mapper_1 = require_reference_field_mapper();
    var text_field_mapper_1 = require_text_field_mapper();
    var chips_field_mapper_1 = require_chips_field_mapper();
    var formFieldTypeToComponentName = {
      CheckboxField: "semCheckboxField",
      DateField: "semDateField",
      HyperlinkField: "semHyperlinkField",
      IdField: "semIdField",
      ImageField: "semImageField",
      MarkdownField: "semMarkdownField",
      MenuField: "semMenuField",
      ObjectField: "semObjectField",
      ReferenceField: "semReferenceField",
      TextField: "semTextField",
      ChipsField: "semChipsField"
    };
    exports2.uiComponentRegistryTypeToRuntimeDataType = {
      BINARY: "BINARY",
      BOOLEAN: "BOOLEAN",
      COLOR: "STRING",
      COMPONENT_ENUM: "STRING",
      DATE: "DATE",
      DISPLAY_CARD: "STRING",
      IMAGE_URL: "STRING",
      LONG_TEXT: "LONG_TEXT",
      LOV: "STRING",
      LOV_MULTI: "STRING",
      MARKDOWN: "LONG_TEXT",
      NUMBER: "DECIMAL",
      REFERENCE: "STRING",
      STRING: "STRING",
      TIMESTAMP: "TIMESTAMP",
      UUID: "UUID"
    };
    function mapFormField(parentFormElement, posInParent, formFieldDesign) {
      const formFieldPayload = {
        qualifiedName: formFieldDesign.__meta.qualifiedName,
        _type: "FormField",
        componentName: formFieldTypeToComponentName[formFieldDesign._type],
        documentationInterpreter: formFieldDesign.documentationInterpreter ?? "LITERAL",
        posInParent,
        useCustomLabel: formFieldDesign.useCustomLabel ?? false,
        value: formFieldDesign.value,
        description: formFieldDesign.description,
        displayCard: formFieldDesign.displayCard,
        documentation: formFieldDesign.documentation,
        label: formFieldDesign.label,
        parentFormContainer: parentFormElement.__meta.qualifiedName,
        referencedEntity: formFieldDesign.referencedEntity,
        relativeWidth: formFieldDesign.relativeWidth,
        valueDataType: formFieldDesign.dataType,
        visibleValue: formFieldDesign.visibleValue ?? "1",
        visibleValueInterpreter: formFieldDesign.visibleValueInterpreter ?? "LITERAL"
      };
      return {
        ...formFieldPayload,
        componentProperties: mapComponentProperties(formFieldDesign)
      };
    }
    function mapComponentProperties(formFieldDesign) {
      switch (formFieldDesign._type) {
        case "CheckboxField":
          return (0, checkbox_field_mapper_1.mapCheckboxFieldComponentProperties)(formFieldDesign);
        case "DateField":
          return (0, date_field_mapper_1.mapDateFieldComponentProperties)(formFieldDesign);
        case "HyperlinkField":
          return (0, hyperlink_field_mapper_1.mapHyperlinkFieldComponentProperties)(formFieldDesign);
        case "IdField":
          return (0, id_field_mapper_1.mapIdFieldComponentProperties)(formFieldDesign);
        case "ImageField":
          return (0, image_field_mapper_1.mapImageFieldComponentProperties)(formFieldDesign);
        case "MarkdownField":
          return (0, markdown_field_mapper_1.mapMarkdownFieldComponentProperties)(formFieldDesign);
        case "MenuField":
          return (0, menu_field_mapper_1.mapMenuFieldComponentProperties)(formFieldDesign);
        case "ObjectField":
          return (0, object_field_mapper_1.mapObjectFieldComponentProperties)(formFieldDesign);
        case "ReferenceField":
          return (0, reference_field_mapper_1.mapReferenceFieldComponentProperties)(formFieldDesign);
        case "TextField":
          return (0, text_field_mapper_1.mapTextFieldComponentProperties)(formFieldDesign);
        case "ChipsField":
          return (0, chips_field_mapper_1.mapChipsFieldComponentProperties)(formFieldDesign);
      }
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_field/component_properties_mapper.js
var require_component_properties_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_field/component_properties_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapHelperTextComponentProperty = mapHelperTextComponentProperty;
    exports2.mapAuthoringModeComponentProperty = mapAuthoringModeComponentProperty;
    exports2.mapUseSwitchComponentProperty = mapUseSwitchComponentProperty;
    exports2.mapTextAlignComponentProperty = mapTextAlignComponentProperty;
    exports2.mapAuthoringLabelPositionComponentProperty = mapAuthoringLabelPositionComponentProperty;
    exports2.mapTextColorComponentProperty = mapTextColorComponentProperty;
    exports2.mapTextTypographyComponentProperty = mapTextTypographyComponentProperty;
    exports2.mapContentBackgroundColorComponentProperty = mapContentBackgroundColorComponentProperty;
    exports2.mapDisplayFormatComponentProperty = mapDisplayFormatComponentProperty;
    exports2.mapEditingFormatComponentProperty = mapEditingFormatComponentProperty;
    exports2.mapMaxDateComponentProperty = mapMaxDateComponentProperty;
    exports2.mapMinDateComponentProperty = mapMinDateComponentProperty;
    exports2.mapUseTimePickerComponentProperty = mapUseTimePickerComponentProperty;
    exports2.mapLinkDisplayTextComponentProperty = mapLinkDisplayTextComponentProperty;
    exports2.mapLinkSourceTypeComponentProperty = mapLinkSourceTypeComponentProperty;
    exports2.mapLinkTargetComponentProperty = mapLinkTargetComponentProperty;
    exports2.mapUseFloatingLabelComponentProperty = mapUseFloatingLabelComponentProperty;
    exports2.mapImageHeightComponentProperty = mapImageHeightComponentProperty;
    exports2.mapFallbackImageComponentProperty = mapFallbackImageComponentProperty;
    exports2.mapFallbackImageTypeComponentProperty = mapFallbackImageTypeComponentProperty;
    exports2.mapShowFullSizeOnClickComponentProperty = mapShowFullSizeOnClickComponentProperty;
    exports2.mapImageSourceTypeComponentProperty = mapImageSourceTypeComponentProperty;
    exports2.mapImageAlignComponentProperty = mapImageAlignComponentProperty;
    exports2.mapImageModeComponentProperty = mapImageModeComponentProperty;
    exports2.mapContentWidthComponentProperty = mapContentWidthComponentProperty;
    exports2.mapContentHeightComponentProperty = mapContentHeightComponentProperty;
    exports2.mapIsCharCounterVisibleComponentProperty = mapIsCharCounterVisibleComponentProperty;
    exports2.mapUseAvatarInMenuComponentProperty = mapUseAvatarInMenuComponentProperty;
    exports2.mapListSourceItemsComponentProperty = mapListSourceItemsComponentProperty;
    exports2.mapListSortComponentProperty = mapListSortComponentProperty;
    exports2.mapListSourceTypeComponentProperty = mapListSourceTypeComponentProperty;
    exports2.mapObjectMaxWidthComponentProperty = mapObjectMaxWidthComponentProperty;
    exports2.mapObjectHeightComponentProperty = mapObjectHeightComponentProperty;
    exports2.mapSourceTypeComponentProperty = mapSourceTypeComponentProperty;
    exports2.mapChipMaxWidthComponentProperty = mapChipMaxWidthComponentProperty;
    exports2.mapDisplayTypeComponentProperty = mapDisplayTypeComponentProperty;
    exports2.mapUseAvatarInChipComponentProperty = mapUseAvatarInChipComponentProperty;
    exports2.mapUseSecondaryTextInChipComponentProperty = mapUseSecondaryTextInChipComponentProperty;
    exports2.mapIsMultilineComponentProperty = mapIsMultilineComponentProperty;
    exports2.mapMultilineMaxLinesComponentProperty = mapMultilineMaxLinesComponentProperty;
    exports2.mapMultilineMinLinesComponentProperty = mapMultilineMinLinesComponentProperty;
    exports2.mapCellBackgroundColorComponentProperty = mapCellBackgroundColorComponentProperty;
    exports2.mapHideIfReferenceToParentComponentProperty = mapHideIfReferenceToParentComponentProperty;
    exports2.mapLabelComponentProperties = mapLabelComponentProperties;
    var memory_1 = require_memory();
    var form_field_mapper_1 = require_form_field_mapper();
    function mapHelperTextComponentProperty(formFieldQualifiedName, helperTextComponentProperty) {
      if (helperTextComponentProperty.helperText === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "helperText"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: helperTextComponentProperty.helperText,
        valueInterpreter: helperTextComponentProperty.helperTextValueInterpreter ?? "LITERAL"
      };
    }
    function mapAuthoringModeComponentProperty(formFieldQualifiedName, authoringModeComponentProperty) {
      if (authoringModeComponentProperty.authoringMode === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "authoringMode"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: authoringModeComponentProperty.authoringMode,
        valueInterpreter: authoringModeComponentProperty.authoringModeValueInterpreter ?? "LITERAL"
      };
    }
    function mapUseSwitchComponentProperty(formFieldQualifiedName, useSwitchComponentProperty) {
      if (useSwitchComponentProperty?.useSwitch === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "useSwitch"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: useSwitchComponentProperty.useSwitch,
        valueInterpreter: useSwitchComponentProperty.useSwitchValueInterpreter ?? "LITERAL"
      };
    }
    function mapIsLabelVisibleComponentProperty(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties?.isVisible === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "isLabelVisible"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: labelComponentProperties.isVisible,
        valueInterpreter: labelComponentProperties.isVisibleValueInterpreter ?? "LITERAL"
      };
    }
    function mapLabelTextAlignComponentProperty(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties?.alignment === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "labelTextAlign"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: labelComponentProperties.alignment,
        valueInterpreter: labelComponentProperties.alignmentValueInterpreter ?? "LITERAL"
      };
    }
    function mapTextAlignComponentProperty(formFieldQualifiedName, textAlignComponentProperty) {
      if (textAlignComponentProperty?.textAlign === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "textAlign"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: textAlignComponentProperty.textAlign,
        valueInterpreter: textAlignComponentProperty.textAlignValueInterpreter ?? "LITERAL"
      };
    }
    function mapLabelPositionComponentProperty(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties?.position === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "labelPosition"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: labelComponentProperties.position,
        valueInterpreter: labelComponentProperties.positionValueInterpreter ?? "LITERAL"
      };
    }
    function mapLabelTypographyComponentProperty(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties?.typography === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "labelTypography"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: labelComponentProperties.typography,
        valueInterpreter: labelComponentProperties.typographyValueInterpreter ?? "LITERAL"
      };
    }
    function mapLabelColorComponentProperty(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties?.color === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "labelColor"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COLOR"],
        value: labelComponentProperties.color,
        valueInterpreter: labelComponentProperties.colorValueInterpreter ?? "LITERAL"
      };
    }
    function mapIconComponentProperty(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties?.icon === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "icon"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["IMAGE_URL"],
        value: labelComponentProperties.icon,
        valueInterpreter: labelComponentProperties.iconValueInterpreter ?? "LITERAL"
      };
    }
    function mapAuthoringLabelPositionComponentProperty(formFieldQualifiedName, authoringLabelPositionComponentProperty) {
      if (authoringLabelPositionComponentProperty?.authoringLabelPosition === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "authoringLabelPosition"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: authoringLabelPositionComponentProperty.authoringLabelPosition,
        valueInterpreter: authoringLabelPositionComponentProperty.authoringLabelPositionValueInterpreter ?? "LITERAL"
      };
    }
    function mapTextColorComponentProperty(formFieldQualifiedName, textColorComponentProperty) {
      if (textColorComponentProperty?.textColor === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "textColor"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COLOR"],
        value: textColorComponentProperty.textColor,
        valueInterpreter: textColorComponentProperty.textColorValueInterpreter ?? "LITERAL"
      };
    }
    function mapTextTypographyComponentProperty(formFieldQualifiedName, textTypographyComponentProperty) {
      if (textTypographyComponentProperty?.textTypography === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "textTypography"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: textTypographyComponentProperty.textTypography,
        valueInterpreter: textTypographyComponentProperty.textTypographyValueInterpreter ?? "LITERAL"
      };
    }
    function mapContentBackgroundColorComponentProperty(formFieldQualifiedName, contentBackgroundColorComponentProperty) {
      if (contentBackgroundColorComponentProperty?.contentBackgroundColor === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "contentBackgroundColor"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COLOR"],
        value: contentBackgroundColorComponentProperty.contentBackgroundColor,
        valueInterpreter: contentBackgroundColorComponentProperty.contentBackgroundColorValueInterpreter ?? "LITERAL"
      };
    }
    function mapDisplayFormatComponentProperty(formFieldQualifiedName, displayFormatComponentProperty) {
      if (displayFormatComponentProperty?.displayFormat === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "displayFormat"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: displayFormatComponentProperty.displayFormat,
        valueInterpreter: displayFormatComponentProperty.displayFormatValueInterpreter ?? "LITERAL"
      };
    }
    function mapEditingFormatComponentProperty(formFieldQualifiedName, editingFormatComponentProperty) {
      if (editingFormatComponentProperty?.editingFormat === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "editingFormat"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: editingFormatComponentProperty.editingFormat,
        valueInterpreter: editingFormatComponentProperty.editingFormatValueInterpreter ?? "LITERAL"
      };
    }
    function mapMaxDateComponentProperty(formFieldQualifiedName, maxDateComponentProperty) {
      if (maxDateComponentProperty?.maxDate === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "maxDate"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: maxDateComponentProperty.maxDate,
        valueInterpreter: maxDateComponentProperty.maxDateValueInterpreter ?? "LITERAL"
      };
    }
    function mapMinDateComponentProperty(formFieldQualifiedName, minDateComponentProperty) {
      if (minDateComponentProperty?.minDate === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "minDate"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: minDateComponentProperty.minDate,
        valueInterpreter: minDateComponentProperty.minDateValueInterpreter ?? "LITERAL"
      };
    }
    function mapUseTimePickerComponentProperty(formFieldQualifiedName, useTimePickerComponentProperty) {
      if (useTimePickerComponentProperty?.useTimePicker === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "useTimePicker"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: useTimePickerComponentProperty.useTimePicker,
        valueInterpreter: useTimePickerComponentProperty.useTimePickerValueInterpreter ?? "LITERAL"
      };
    }
    function mapIconColorComponentProperty(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties?.iconColor === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "iconColor"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COLOR"],
        value: labelComponentProperties.iconColor,
        valueInterpreter: labelComponentProperties.iconColorValueInterpreter ?? "LITERAL"
      };
    }
    function mapLinkDisplayTextComponentProperty(formFieldQualifiedName, linkDisplayTextComponentProperty) {
      if (linkDisplayTextComponentProperty?.linkDisplayText === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "linkDisplayText"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: linkDisplayTextComponentProperty.linkDisplayText,
        valueInterpreter: linkDisplayTextComponentProperty.linkDisplayTextValueInterpreter ?? "LITERAL"
      };
    }
    function mapLinkSourceTypeComponentProperty(formFieldQualifiedName, linkSourceTypeComponentProperty) {
      if (linkSourceTypeComponentProperty?.linkSourceType === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "linkSourceType"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: linkSourceTypeComponentProperty.linkSourceType,
        valueInterpreter: linkSourceTypeComponentProperty.linkSourceTypeValueInterpreter ?? "LITERAL"
      };
    }
    function mapLinkTargetComponentProperty(formFieldQualifiedName, linkTargetComponentProperty) {
      if (linkTargetComponentProperty?.linkTarget === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "linkTarget"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: linkTargetComponentProperty.linkTarget,
        valueInterpreter: linkTargetComponentProperty.linkTargetValueInterpreter ?? "LITERAL"
      };
    }
    function mapUseFloatingLabelComponentProperty(formFieldQualifiedName, isFloatingComponentProperties) {
      if (isFloatingComponentProperties?.isFloating === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "useFloatingLabel"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: isFloatingComponentProperties.isFloating,
        valueInterpreter: isFloatingComponentProperties.isFloatingValueInterpreter ?? "LITERAL"
      };
    }
    function mapImageHeightComponentProperty(formFieldQualifiedName, imageHeightComponentProperty) {
      if (imageHeightComponentProperty?.imageHeight === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "imageHeight"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: imageHeightComponentProperty.imageHeight,
        valueInterpreter: imageHeightComponentProperty.imageHeightValueInterpreter ?? "LITERAL"
      };
    }
    function mapFallbackImageComponentProperty(formFieldQualifiedName, fallbackImageComponentProperty) {
      if (fallbackImageComponentProperty?.fallbackImage === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "fallbackImage"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: fallbackImageComponentProperty.fallbackImage,
        valueInterpreter: fallbackImageComponentProperty.fallbackImageValueInterpreter ?? "LITERAL"
      };
    }
    function mapFallbackImageTypeComponentProperty(formFieldQualifiedName, fallbackImageTypeComponentProperty) {
      if (fallbackImageTypeComponentProperty?.fallbackImageType === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "fallbackImageType"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: fallbackImageTypeComponentProperty.fallbackImageType,
        valueInterpreter: fallbackImageTypeComponentProperty.fallbackImageTypeValueInterpreter ?? "LITERAL"
      };
    }
    function mapShowFullSizeOnClickComponentProperty(formFieldQualifiedName, showFullSizeOnClickComponentProperty) {
      if (showFullSizeOnClickComponentProperty?.showFullSizeOnClick === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "showFullSizeOnClick"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: showFullSizeOnClickComponentProperty.showFullSizeOnClick,
        valueInterpreter: showFullSizeOnClickComponentProperty.showFullSizeOnClickValueInterpreter ?? "LITERAL"
      };
    }
    function mapImageSourceTypeComponentProperty(formFieldQualifiedName, imageSourceTypeComponentProperty) {
      if (imageSourceTypeComponentProperty?.imageSourceType === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "imageSourceType"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: imageSourceTypeComponentProperty.imageSourceType,
        valueInterpreter: imageSourceTypeComponentProperty.imageSourceTypeValueInterpreter ?? "LITERAL"
      };
    }
    function mapImageAlignComponentProperty(formFieldQualifiedName, imageAlignComponentProperty) {
      if (imageAlignComponentProperty?.imageAlign === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "imageAlign"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: imageAlignComponentProperty.imageAlign,
        valueInterpreter: imageAlignComponentProperty.imageAlignValueInterpreter ?? "LITERAL"
      };
    }
    function mapImageModeComponentProperty(formFieldQualifiedName, imageModeComponentProperty) {
      if (imageModeComponentProperty?.imageMode === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "imageMode"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: imageModeComponentProperty.imageMode,
        valueInterpreter: imageModeComponentProperty.imageModeValueInterpreter ?? "LITERAL"
      };
    }
    function mapContentWidthComponentProperty(formFieldQualifiedName, contentWidthComponentProperty) {
      if (contentWidthComponentProperty?.contentWidth === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "contentWidth"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: contentWidthComponentProperty.contentWidth,
        valueInterpreter: contentWidthComponentProperty.contentWidthValueInterpreter ?? "LITERAL"
      };
    }
    function mapContentHeightComponentProperty(formFieldQualifiedName, contentHeightComponentProperty) {
      if (contentHeightComponentProperty?.contentHeight === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "contentHeight"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: contentHeightComponentProperty.contentHeight,
        valueInterpreter: contentHeightComponentProperty.contentHeightValueInterpreter ?? "LITERAL"
      };
    }
    function mapIsCharCounterVisibleComponentProperty(formFieldQualifiedName, isCharCounterVisibleComponentProperty) {
      if (isCharCounterVisibleComponentProperty?.isCharCounterVisible === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "isCharCounterVisible"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: isCharCounterVisibleComponentProperty.isCharCounterVisible,
        valueInterpreter: isCharCounterVisibleComponentProperty.isCharCounterVisibleValueInterpreter ?? "LITERAL"
      };
    }
    function mapUseAvatarInMenuComponentProperty(formFieldQualifiedName, useAvatarInMenuComponentProperty) {
      if (useAvatarInMenuComponentProperty?.useAvatarInMenu === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "useAvatarInMenu"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: useAvatarInMenuComponentProperty.useAvatarInMenu,
        valueInterpreter: useAvatarInMenuComponentProperty.useAvatarInMenuValueInterpreter ?? "LITERAL"
      };
    }
    function mapListSourceItemsComponentProperty(formFieldQualifiedName, listSourceItemsComponentProperty) {
      if (listSourceItemsComponentProperty?.listSourceItems === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "listSourceItems"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: listSourceItemsComponentProperty.listSourceItems,
        valueInterpreter: listSourceItemsComponentProperty.listSourceItemsValueInterpreter ?? "LITERAL"
      };
    }
    function mapListSortComponentProperty(formFieldQualifiedName, listSortComponentProperty) {
      if (listSortComponentProperty?.listSort === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "listSort"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: listSortComponentProperty.listSort,
        valueInterpreter: listSortComponentProperty.listSortValueInterpreter ?? "LITERAL"
      };
    }
    function mapListSourceTypeComponentProperty(formFieldQualifiedName, listSourceTypeComponentProperty) {
      if (listSourceTypeComponentProperty?.listSourceType === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "listSourceType"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: listSourceTypeComponentProperty.listSourceType,
        valueInterpreter: listSourceTypeComponentProperty.listSourceTypeValueInterpreter ?? "LITERAL"
      };
    }
    function mapObjectMaxWidthComponentProperty(formFieldQualifiedName, objectMaxWidthComponentProperty) {
      if (objectMaxWidthComponentProperty?.objectMaxWidth === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "objectMaxWidth"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: objectMaxWidthComponentProperty.objectMaxWidth,
        valueInterpreter: objectMaxWidthComponentProperty.objectMaxWidthValueInterpreter ?? "LITERAL"
      };
    }
    function mapObjectHeightComponentProperty(formFieldQualifiedName, objectHeightComponentProperty) {
      if (objectHeightComponentProperty?.objectHeight === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "objectHeight"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: objectHeightComponentProperty.objectHeight,
        valueInterpreter: objectHeightComponentProperty.objectHeightValueInterpreter ?? "LITERAL"
      };
    }
    function mapSourceTypeComponentProperty(formFieldQualifiedName, sourceTypeComponentProperty) {
      if (sourceTypeComponentProperty?.sourceType === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "sourceType"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: sourceTypeComponentProperty.sourceType,
        valueInterpreter: sourceTypeComponentProperty.sourceTypeValueInterpreter ?? "LITERAL"
      };
    }
    function mapChipMaxWidthComponentProperty(formFieldQualifiedName, chipMaxWidthComponentProperty) {
      if (chipMaxWidthComponentProperty?.chipMaxWidth === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "chipMaxWidth"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["STRING"],
        value: chipMaxWidthComponentProperty.chipMaxWidth,
        valueInterpreter: chipMaxWidthComponentProperty.chipMaxWidthValueInterpreter ?? "LITERAL"
      };
    }
    function mapDisplayTypeComponentProperty(formFieldQualifiedName, displayTypeComponentProperty) {
      if (displayTypeComponentProperty?.displayType === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "displayType"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COMPONENT_ENUM"],
        value: displayTypeComponentProperty.displayType,
        valueInterpreter: displayTypeComponentProperty.displayTypeValueInterpreter ?? "LITERAL"
      };
    }
    function mapUseAvatarInChipComponentProperty(formFieldQualifiedName, useAvatarInChipComponentProperty) {
      if (useAvatarInChipComponentProperty?.useAvatarInChip === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "useAvatarInChip"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: useAvatarInChipComponentProperty.useAvatarInChip,
        valueInterpreter: useAvatarInChipComponentProperty.useAvatarInChipValueInterpreter ?? "LITERAL"
      };
    }
    function mapUseSecondaryTextInChipComponentProperty(formFieldQualifiedName, useSecondaryTextInChipComponentProperty) {
      if (useSecondaryTextInChipComponentProperty?.useSecondaryTextInChip === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "useSecondaryTextInChip"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: useSecondaryTextInChipComponentProperty.useSecondaryTextInChip,
        valueInterpreter: useSecondaryTextInChipComponentProperty.useSecondaryTextInChipValueInterpreter ?? "LITERAL"
      };
    }
    function mapIsMultilineComponentProperty(formFieldQualifiedName, isMultilineComponentProperty) {
      if (isMultilineComponentProperty?.isMultiline === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "isMultiline"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: isMultilineComponentProperty.isMultiline,
        valueInterpreter: isMultilineComponentProperty.isMultilineValueInterpreter ?? "LITERAL"
      };
    }
    function mapMultilineMaxLinesComponentProperty(formFieldQualifiedName, multilineMaxLinesComponentProperty) {
      if (multilineMaxLinesComponentProperty?.multilineMaxLines === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "multilineMaxLines"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["NUMBER"],
        value: multilineMaxLinesComponentProperty.multilineMaxLines,
        valueInterpreter: multilineMaxLinesComponentProperty.multilineMaxLinesValueInterpreter ?? "LITERAL"
      };
    }
    function mapMultilineMinLinesComponentProperty(formFieldQualifiedName, multilineMinLinesComponentProperty) {
      if (multilineMinLinesComponentProperty?.multilineMinLines === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "multilineMinLines"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["NUMBER"],
        value: multilineMinLinesComponentProperty.multilineMinLines,
        valueInterpreter: multilineMinLinesComponentProperty.multilineMinLinesValueInterpreter ?? "LITERAL"
      };
    }
    function mapCellBackgroundColorComponentProperty(formFieldQualifiedName, cellBackgroundColorComponentProperty) {
      if (cellBackgroundColorComponentProperty?.cellBackgroundColor === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "cellBackgroundColor"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["COLOR"],
        value: cellBackgroundColorComponentProperty.cellBackgroundColor,
        valueInterpreter: cellBackgroundColorComponentProperty.cellBackgroundColorValueInterpreter ?? "LITERAL"
      };
    }
    function mapHideIfReferenceToParentComponentProperty(formFieldQualifiedName, hideIfReferenceToParentComponentProperty) {
      if (hideIfReferenceToParentComponentProperty?.hideIfReferenceToParent === void 0) {
        return;
      }
      return {
        qualifiedName: (0, memory_1.joinNames)(formFieldQualifiedName, "hideIfReferenceToParent"),
        dataType: form_field_mapper_1.uiComponentRegistryTypeToRuntimeDataType["BOOLEAN"],
        value: hideIfReferenceToParentComponentProperty.hideIfReferenceToParent,
        valueInterpreter: hideIfReferenceToParentComponentProperty.hideIfReferenceToParentValueInterpreter ?? "LITERAL"
      };
    }
    function mapLabelComponentProperties(formFieldQualifiedName, labelComponentProperties) {
      if (labelComponentProperties === void 0) {
        return [];
      }
      return [
        mapLabelColorComponentProperty(formFieldQualifiedName, labelComponentProperties),
        mapLabelPositionComponentProperty(formFieldQualifiedName, labelComponentProperties),
        mapLabelTextAlignComponentProperty(formFieldQualifiedName, labelComponentProperties),
        mapLabelTypographyComponentProperty(formFieldQualifiedName, labelComponentProperties),
        mapIsLabelVisibleComponentProperty(formFieldQualifiedName, labelComponentProperties),
        mapIconComponentProperty(formFieldQualifiedName, labelComponentProperties),
        mapIconColorComponentProperty(formFieldQualifiedName, labelComponentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/checkbox_column_mapper.js
var require_checkbox_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/checkbox_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapCheckboxColumnComponentProperties = mapCheckboxColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapCheckboxColumnComponentProperties(checkboxColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(checkboxColumnDesign.__meta.qualifiedName, checkboxColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseSwitchComponentProperty)(checkboxColumnDesign.__meta.qualifiedName, checkboxColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/date_column_mapper.js
var require_date_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/date_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapDateColumnComponentProperties = mapDateColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapDateColumnComponentProperties(dateColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(dateColumnDesign.__meta.qualifiedName, dateColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(dateColumnDesign.__meta.qualifiedName, dateColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(dateColumnDesign.__meta.qualifiedName, dateColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/hyperlink_column_mapper.js
var require_hyperlink_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/hyperlink_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapHyperlinkColumnComponentProperties = mapHyperlinkColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapHyperlinkColumnComponentProperties(hyperlinkColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(hyperlinkColumnDesign.__meta.qualifiedName, hyperlinkColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(hyperlinkColumnDesign.__meta.qualifiedName, hyperlinkColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapLinkDisplayTextComponentProperty)(hyperlinkColumnDesign.__meta.qualifiedName, hyperlinkColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapLinkSourceTypeComponentProperty)(hyperlinkColumnDesign.__meta.qualifiedName, hyperlinkColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapLinkTargetComponentProperty)(hyperlinkColumnDesign.__meta.qualifiedName, hyperlinkColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/id_column_mapper.js
var require_id_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/id_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapIdColumnComponentProperties = mapIdColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapIdColumnComponentProperties(idColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(idColumnDesign.__meta.qualifiedName, idColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(idColumnDesign.__meta.qualifiedName, idColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(idColumnDesign.__meta.qualifiedName, idColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/image_column_mapper.js
var require_image_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/image_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapImageColumnComponentProperties = mapImageColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapImageColumnComponentProperties(imageColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapImageSourceTypeComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapFallbackImageComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapFallbackImageTypeComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapShowFullSizeOnClickComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapImageAlignComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapImageModeComponentProperty)(imageColumnDesign.__meta.qualifiedName, imageColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/markdown_column_mapper.js
var require_markdown_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/markdown_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapMarkdownColumnComponentProperties = mapMarkdownColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapMarkdownColumnComponentProperties(markdownColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(markdownColumnDesign.__meta.qualifiedName, markdownColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(markdownColumnDesign.__meta.qualifiedName, markdownColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapContentWidthComponentProperty)(markdownColumnDesign.__meta.qualifiedName, markdownColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/menu_column_mapper.js
var require_menu_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/menu_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapMenuColumnComponentProperties = mapMenuColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapMenuColumnComponentProperties(menuColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(menuColumnDesign.__meta.qualifiedName, menuColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(menuColumnDesign.__meta.qualifiedName, menuColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(menuColumnDesign.__meta.qualifiedName, menuColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseAvatarInMenuComponentProperty)(menuColumnDesign.__meta.qualifiedName, menuColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapListSourceItemsComponentProperty)(menuColumnDesign.__meta.qualifiedName, menuColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapListSourceTypeComponentProperty)(menuColumnDesign.__meta.qualifiedName, menuColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/object_column_mapper.js
var require_object_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/object_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapObjectColumnComponentProperties = mapObjectColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapObjectColumnComponentProperties(objectColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(objectColumnDesign.__meta.qualifiedName, objectColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapObjectMaxWidthComponentProperty)(objectColumnDesign.__meta.qualifiedName, objectColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapSourceTypeComponentProperty)(objectColumnDesign.__meta.qualifiedName, objectColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/reference_column_mapper.js
var require_reference_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/reference_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapReferenceColumnComponentProperties = mapReferenceColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapReferenceColumnComponentProperties(referenceColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(referenceColumnDesign.__meta.qualifiedName, referenceColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapChipMaxWidthComponentProperty)(referenceColumnDesign.__meta.qualifiedName, referenceColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(referenceColumnDesign.__meta.qualifiedName, referenceColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayTypeComponentProperty)(referenceColumnDesign.__meta.qualifiedName, referenceColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseAvatarInChipComponentProperty)(referenceColumnDesign.__meta.qualifiedName, referenceColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseSecondaryTextInChipComponentProperty)(referenceColumnDesign.__meta.qualifiedName, referenceColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapHideIfReferenceToParentComponentProperty)(referenceColumnDesign.__meta.qualifiedName, referenceColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/text_column_mapper.js
var require_text_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/text_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapTextColumnComponentProperties = mapTextColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapTextColumnComponentProperties(textColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(textColumnDesign.__meta.qualifiedName, textColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(textColumnDesign.__meta.qualifiedName, textColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapDisplayFormatComponentProperty)(textColumnDesign.__meta.qualifiedName, textColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/chips_column_mapper.js
var require_chips_column_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/table_column/chips_column_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapChipsColumnComponentProperties = mapChipsColumnComponentProperties;
    var component_properties_mapper_1 = require_component_properties_mapper();
    function mapChipsColumnComponentProperties(chipsColumnDesign) {
      return [
        (0, component_properties_mapper_1.mapTextColorComponentProperty)(chipsColumnDesign.__meta.qualifiedName, chipsColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapChipMaxWidthComponentProperty)(chipsColumnDesign.__meta.qualifiedName, chipsColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapCellBackgroundColorComponentProperty)(chipsColumnDesign.__meta.qualifiedName, chipsColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseAvatarInChipComponentProperty)(chipsColumnDesign.__meta.qualifiedName, chipsColumnDesign.componentProperties),
        (0, component_properties_mapper_1.mapUseSecondaryTextInChipComponentProperty)(chipsColumnDesign.__meta.qualifiedName, chipsColumnDesign.componentProperties)
      ].filter((componentPropertyPayload) => !!componentPropertyPayload);
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/collection_view/collection_view_mapper.js
var require_collection_view_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/collection_view/collection_view_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tableColumnTypeToComponentName = void 0;
    exports2.mapCollectionView = mapCollectionView;
    exports2.mapTableColumn = mapTableColumn;
    var checkbox_column_mapper_1 = require_checkbox_column_mapper();
    var date_column_mapper_1 = require_date_column_mapper();
    var hyperlink_column_mapper_1 = require_hyperlink_column_mapper();
    var id_column_mapper_1 = require_id_column_mapper();
    var image_column_mapper_1 = require_image_column_mapper();
    var markdown_column_mapper_1 = require_markdown_column_mapper();
    var menu_column_mapper_1 = require_menu_column_mapper();
    var object_column_mapper_1 = require_object_column_mapper();
    var reference_column_mapper_1 = require_reference_column_mapper();
    var text_column_mapper_1 = require_text_column_mapper();
    var chips_column_mapper_1 = require_chips_column_mapper();
    exports2.tableColumnTypeToComponentName = {
      CheckboxColumn: "semCheckboxField",
      DateColumn: "semDateField",
      HyperlinkColumn: "semHyperlinkField",
      IdColumn: "semIdField",
      ImageColumn: "semImageField",
      MarkdownColumn: "semMarkdownField",
      MenuColumn: "semMenuField",
      ObjectColumn: "semObjectField",
      ReferenceColumn: "semReferenceField",
      TextColumn: "semTextField",
      ChipsColumn: "semChipsField"
    };
    function mapCollectionView(collectionViewDesign) {
      return {
        qualifiedName: collectionViewDesign.__meta.qualifiedName,
        default: collectionViewDesign.default,
        gridAllowed: collectionViewDesign.gridAllowed,
        gridColumns: collectionViewDesign.gridColumns ?? 4,
        gridTextPosition: collectionViewDesign.gridTextPosition ?? "BOTTOM",
        gridTileHeight: collectionViewDesign.gridTileHeight ?? "1:1",
        gridTileLines: collectionViewDesign.gridTileLines ?? 1,
        listAllowed: collectionViewDesign.listAllowed,
        listItemLines: collectionViewDesign.listItemLines ?? 2,
        listShowDisplayCardAvatar: collectionViewDesign.listShowDisplayCardAvatar ?? false,
        listShowDivider: collectionViewDesign.listShowDivider ?? false,
        tableAllowed: collectionViewDesign.tableAllowed,
        tableDisplayCardColumnLabel: collectionViewDesign.tableDisplayCardColumnLabel ?? "",
        tableRowLines: collectionViewDesign.tableRowLines ?? 1,
        tableShowDisplayCard: collectionViewDesign.tableShowDisplayCard ?? false,
        description: collectionViewDesign.description,
        displayCard: collectionViewDesign.displayCard,
        tableDisplayCardColumnWidth: collectionViewDesign.tableDisplayCardColumnWidth,
        tableColumns: collectionViewDesign.tableColumns ? collectionViewDesign.tableColumns.map((tableColumnDesign, index) => mapTableColumn(index, tableColumnDesign)) : void 0
      };
    }
    function mapTableColumn(posInParent, tableColumnDesign) {
      const tableColumnPayload = {
        qualifiedName: tableColumnDesign.__meta.qualifiedName,
        _type: "TableColumn",
        columnAlign: tableColumnDesign.columnAlign,
        componentName: exports2.tableColumnTypeToComponentName[tableColumnDesign._type],
        documentationInterpreter: tableColumnDesign.documentationInterpreter ?? "LITERAL",
        posInParent,
        useCustomLabel: tableColumnDesign.useCustomLabel,
        value: tableColumnDesign.value,
        visibleByDefault: tableColumnDesign.visibleByDefault,
        defaultWidth: tableColumnDesign.defaultWidth,
        description: tableColumnDesign.description,
        displayCard: tableColumnDesign.displayCard,
        documentation: tableColumnDesign.documentation,
        label: tableColumnDesign.label,
        labelColor: tableColumnDesign.labelColor,
        referencedEntity: tableColumnDesign.referencedEntity,
        valueDataType: tableColumnDesign.dataType
      };
      return {
        ...tableColumnPayload,
        componentProperties: mapComponentProperties(tableColumnDesign)
      };
    }
    function mapComponentProperties(tableColumnDesign) {
      switch (tableColumnDesign._type) {
        case "CheckboxColumn":
          return (0, checkbox_column_mapper_1.mapCheckboxColumnComponentProperties)(tableColumnDesign);
        case "DateColumn":
          return (0, date_column_mapper_1.mapDateColumnComponentProperties)(tableColumnDesign);
        case "HyperlinkColumn":
          return (0, hyperlink_column_mapper_1.mapHyperlinkColumnComponentProperties)(tableColumnDesign);
        case "IdColumn":
          return (0, id_column_mapper_1.mapIdColumnComponentProperties)(tableColumnDesign);
        case "ImageColumn":
          return (0, image_column_mapper_1.mapImageColumnComponentProperties)(tableColumnDesign);
        case "MarkdownColumn":
          return (0, markdown_column_mapper_1.mapMarkdownColumnComponentProperties)(tableColumnDesign);
        case "MenuColumn":
          return (0, menu_column_mapper_1.mapMenuColumnComponentProperties)(tableColumnDesign);
        case "ObjectColumn":
          return (0, object_column_mapper_1.mapObjectColumnComponentProperties)(tableColumnDesign);
        case "ReferenceColumn":
          return (0, reference_column_mapper_1.mapReferenceColumnComponentProperties)(tableColumnDesign);
        case "TextColumn":
          return (0, text_column_mapper_1.mapTextColumnComponentProperties)(tableColumnDesign);
        case "ChipsColumn":
          return (0, chips_column_mapper_1.mapChipsColumnComponentProperties)(tableColumnDesign);
      }
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/display_card/display_card_mapper.js
var require_display_card_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/display_card/display_card_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapDisplayCard = mapDisplayCard;
    function mapDisplayCard(displayCardDesign) {
      return {
        qualifiedName: displayCardDesign.__meta.qualifiedName,
        avatarImageValueInterpreter: displayCardDesign.avatarImageValueInterpreter,
        default: displayCardDesign.default ?? false,
        primaryImageFallbackValueInterpreter: displayCardDesign.primaryImageFallbackValueInterpreter,
        primaryImageValueInterpreter: displayCardDesign.primaryImageValueInterpreter,
        avatarImageAlign: displayCardDesign.avatarImageAlign,
        avatarImageMode: displayCardDesign.avatarImageMode,
        avatarImageSourceType: displayCardDesign.avatarImageSourceType,
        avatarImageValue: displayCardDesign.avatarImageValue,
        description: displayCardDesign.description,
        primaryImageAlign: displayCardDesign.primaryImageAlign,
        primaryImageFallbackSourceType: displayCardDesign.primaryImageFallbackSourceType,
        primaryImageFallbackValue: displayCardDesign.primaryImageFallbackValue,
        primaryImageMode: displayCardDesign.primaryImageMode,
        primaryImageSourceType: displayCardDesign.primaryImageSourceType,
        primaryImageValue: displayCardDesign.primaryImageValue,
        primaryTextExpression: displayCardDesign.primaryTextExpression,
        secondaryTextExpression: displayCardDesign.secondaryTextExpression,
        supportingTextExpression: displayCardDesign.supportingTextExpression
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/dups_manager/dups_manager_mapper.js
var require_dups_manager_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/dups_manager/dups_manager_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapDupsManager = mapDupsManager;
    function mapDupsManager(dupsManagerDesign) {
      return {
        qualifiedName: dupsManagerDesign.__meta.qualifiedName,
        checkoutCustomSortEnabled: dupsManagerDesign.checkoutCustomSortEnabled,
        checkoutDefaultDisplayType: dupsManagerDesign.checkoutDefaultDisplayType,
        checkoutDisplayGridAllowed: dupsManagerDesign.checkoutDisplayGridAllowed,
        checkoutDisplayListAllowed: dupsManagerDesign.checkoutDisplayListAllowed,
        checkoutDisplayTableAllowed: dupsManagerDesign.checkoutDisplayTableAllowed,
        checkoutUserDefinedSortEnabled: dupsManagerDesign.checkoutUserDefinedSortEnabled,
        collectionView: dupsManagerDesign.collectionView,
        displayCard: dupsManagerDesign.displayCard,
        enableMasterValuePicking: dupsManagerDesign.enableMasterValuePicking,
        formTab: dupsManagerDesign.formTab,
        checkoutSearchConfigs: dupsManagerDesign.checkoutSearchConfigs,
        checkoutSortExpression: dupsManagerDesign.checkoutSortExpression,
        description: dupsManagerDesign.description,
        label: dupsManagerDesign.label,
        modelJob: dupsManagerDesign.modelJob,
        tableViewCollection: dupsManagerDesign.tableViewCollection
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/enricher/enricher_mapper.js
var require_enricher_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/enricher/enricher_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapEnrichers = mapEnrichers;
    exports2.mapEnricher = mapEnricher;
    var memory_1 = require_memory();
    function mapEnrichers(enrichers) {
      const sorted = [];
      const toSort = [];
      const sortedQualifiedNames = /* @__PURE__ */ new Set();
      const allQualifiedNames = /* @__PURE__ */ new Set();
      const isDependencyCleared = (dependency) => !dependency || sortedQualifiedNames.has(dependency) || !allQualifiedNames.has(dependency);
      for (const enricher of enrichers) {
        allQualifiedNames.add(enricher.__meta.qualifiedName);
        if (enricher.afterEnrichers === void 0 || enricher.afterEnrichers.length === 0) {
          sorted.push(enricher);
          sortedQualifiedNames.add(enricher.__meta.qualifiedName);
        } else {
          toSort.push(enricher);
        }
      }
      let maxLoop = toSort.length;
      while (toSort.length > 0) {
        --maxLoop;
        if (maxLoop < 0) {
          return [];
        }
        const enricher = toSort.shift();
        if (!enricher) {
          continue;
        }
        const canBeSorted = Array.isArray(enricher.afterEnrichers) ? enricher.afterEnrichers.every(isDependencyCleared) : isDependencyCleared(enricher.afterEnrichers);
        if (canBeSorted) {
          sorted.push(enricher);
          sortedQualifiedNames.add(enricher.__meta.qualifiedName);
          maxLoop = toSort.length;
        } else {
          toSort.push(enricher);
        }
      }
      return sorted.map(mapEnricher);
    }
    function mapEnricher(enricherDesign) {
      switch (enricherDesign._type) {
        case memory_1.TOP_LEVEL_ENUM.ENTITY_JAVA_PLUGIN_ENRICHER: {
          return mapPluginEnricher(enricherDesign, "P");
        }
        case memory_1.TOP_LEVEL_ENUM.ENTITY_REST_CLIENT_ENRICHER: {
          return mapPluginEnricher(enricherDesign, "C");
        }
        case memory_1.TOP_LEVEL_ENUM.ENTITY_SEMQL_ENRICHER: {
          return mapSemqlEnricher(enricherDesign);
        }
      }
    }
    function mapPluginEnricher(pluginEnricherDesign, prefix) {
      return {
        qualifiedName: pluginEnricherDesign.__meta.qualifiedName,
        _type: "PluginEnricher",
        condition: pluginEnricherDesign.condition ?? "",
        enricherExecutionScope: pluginEnricherDesign.enricherExecutionScope,
        numberOfRetry: pluginEnricherDesign.numberOfRetry,
        onErrorBehavior: pluginEnricherDesign.onErrorBehavior,
        pluginId: `${prefix}${pluginEnricherDesign.pluginId}`,
        processingBatchSize: pluginEnricherDesign.processingBatchSize,
        threadPoolSize: pluginEnricherDesign.threadPoolSize,
        batchUpdateSize: pluginEnricherDesign.batchUpdateSize,
        description: pluginEnricherDesign.description,
        enricherCache: pluginEnricherDesign.enricherCache,
        label: pluginEnricherDesign.label,
        pluginInputs: pluginEnricherDesign.pluginInputs?.map(mapPluginEnricherInput),
        pluginOutputs: pluginEnricherDesign.pluginOutputs,
        pluginParams: pluginEnricherDesign.pluginParams?.map(mapPluginEnricherParam)
      };
    }
    function mapSemqlEnricher(semqlEnricherDesign) {
      return {
        qualifiedName: semqlEnricherDesign.__meta.qualifiedName,
        _type: semqlEnricherDesign._type,
        condition: semqlEnricherDesign.condition ?? "",
        enricherExecutionScope: semqlEnricherDesign.enricherExecutionScope,
        description: semqlEnricherDesign.description,
        label: semqlEnricherDesign.label,
        semQlEnricherExpressions: semqlEnricherDesign.semQlEnricherExpressions
      };
    }
    function mapPluginEnricherInput(pluginValidationInputDesign) {
      return {
        _type: "PluginEnricherInput",
        expression: pluginValidationInputDesign.expression,
        inputName: pluginValidationInputDesign.inputName
      };
    }
    function mapPluginEnricherParam(pluginValidationParamDesign) {
      return {
        _type: "PluginEnricherParam",
        paramName: pluginValidationParamDesign.paramName,
        value: pluginValidationParamDesign.value
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_chart_mapper.js
var require_form_chart_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_chart_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFormChart = mapFormChart;
    function mapFormChart(parentFormElement, posInParent, formChartDesign) {
      return {
        qualifiedName: formChartDesign.__meta.qualifiedName,
        chart: formChartDesign.chart,
        dashboardApplication: formChartDesign.dashboardApplication,
        documentationInterpreter: formChartDesign.documentationInterpreter ?? "LITERAL",
        embeddedMode: formChartDesign.embeddedMode,
        posInParent,
        showDivider: formChartDesign.showDivider,
        titlePlacement: formChartDesign.titlePlacement,
        useCustomLabel: formChartDesign.useCustomLabel,
        visibleValueInterpreter: formChartDesign.visibleValueInterpreter ?? "LITERAL",
        description: formChartDesign.description,
        documentation: formChartDesign.documentation,
        height: formChartDesign.height,
        label: formChartDesign.label,
        parentFormContainer: parentFormElement.__meta.qualifiedName,
        relativeWidth: formChartDesign.relativeWidth,
        visibleValue: formChartDesign.visibleValue,
        queryAttributes: formChartDesign.queryAttributes ? formChartDesign.queryAttributes.map((formChartParameterDesign) => mapFormChartParameter(formChartParameterDesign)) : void 0
      };
    }
    function mapFormChartParameter(formChartParameterDesign) {
      return {
        qualifiedName: formChartParameterDesign.__meta.qualifiedName,
        _type: formChartParameterDesign._type,
        value: formChartParameterDesign.value,
        valueInterpreter: formChartParameterDesign.valueInterpreter
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_collection_mapper.js
var require_form_collection_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_collection_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFormCollection = mapFormCollection;
    function mapFormCollection(parentFormElement, posInParent, formCollectionDesign) {
      return {
        qualifiedName: formCollectionDesign.__meta.qualifiedName,
        displayRecordCount: formCollectionDesign.displayRecordCount,
        documentationInterpreter: formCollectionDesign.documentationInterpreter ?? "LITERAL",
        enableUserDefinedSort: formCollectionDesign.enableUserDefinedSort,
        filter: formCollectionDesign.filter,
        gridAllowed: formCollectionDesign.gridAllowed,
        listAllowed: formCollectionDesign.listAllowed,
        posInParent,
        sortExpression: formCollectionDesign.sortExpression,
        tableAllowed: formCollectionDesign.tableAllowed,
        transitionPath: formCollectionDesign.transitionPath,
        useCustomLabel: formCollectionDesign.useCustomLabel,
        visibleValueInterpreter: formCollectionDesign.visibleValueInterpreter ?? "LITERAL",
        actionSet: formCollectionDesign.actionSet,
        collection: formCollectionDesign.collection,
        description: formCollectionDesign.description,
        documentation: formCollectionDesign.documentation,
        formCollectionSearchConfigs: formCollectionDesign.formCollectionSearchConfigs,
        height: formCollectionDesign.height,
        label: formCollectionDesign.label,
        limit: formCollectionDesign.limit,
        parentFormContainer: parentFormElement.__meta.qualifiedName,
        pluralLabel: formCollectionDesign.pluralLabel,
        relativeWidth: formCollectionDesign.relativeWidth,
        targetEntity: formCollectionDesign.targetEntity,
        visibleValue: formCollectionDesign.visibleValue,
        formCollectionBuiltInFilters: formCollectionDesign.formCollectionBuiltInFilters ? formCollectionDesign.formCollectionBuiltInFilters.map((formCollectionBuiltInFilterDesign) => mapFormCollectionBuiltInFilter(formCollectionBuiltInFilterDesign)) : void 0
      };
    }
    function mapFormCollectionBuiltInFilter(formCollectionBuiltInFilter) {
      return {
        qualifiedName: formCollectionBuiltInFilter.__meta.qualifiedName,
        _type: formCollectionBuiltInFilter._type,
        semQlCondition: formCollectionBuiltInFilter.semQlCondition,
        visible: formCollectionBuiltInFilter.visible,
        description: formCollectionBuiltInFilter.description,
        label: formCollectionBuiltInFilter.label
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_container_mapper.js
var require_form_container_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_container_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFormContainer = mapFormContainer;
    function mapFormContainer(parentFormElement, posInParent, formContainerDesign) {
      return {
        qualifiedName: formContainerDesign.__meta.qualifiedName,
        _type: formContainerDesign._type,
        layoutDirection: formContainerDesign.layoutDirection,
        posInParent,
        labelWidth: formContainerDesign.labelWidth,
        parentFormContainer: parentFormElement.__meta.qualifiedName,
        relativeWidth: formContainerDesign.relativeWidth
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_dashboard_mapper.js
var require_form_dashboard_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_dashboard_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFormDashboard = mapFormDashboard;
    function mapFormDashboard(parentFormElement, posInParent, formDashboardDesign) {
      return {
        qualifiedName: formDashboardDesign.__meta.qualifiedName,
        dashboard: formDashboardDesign.dashboard,
        dashboardApplication: formDashboardDesign.dashboardApplication,
        posInParent,
        tab: formDashboardDesign.tab,
        visibleValueInterpreter: formDashboardDesign.visibleValueInterpreter ?? "LITERAL",
        description: formDashboardDesign.description,
        height: formDashboardDesign.height,
        parentFormContainer: parentFormElement.__meta.qualifiedName,
        relativeWidth: formDashboardDesign.relativeWidth,
        visibleValue: formDashboardDesign.visibleValue,
        parameters: formDashboardDesign.parameters ? formDashboardDesign.parameters.map((formDashboardParameterDesign) => mapFormDashboardParameter(formDashboardParameterDesign)) : void 0
      };
    }
    function mapFormDashboardParameter(formDashboardParameterDesign) {
      return {
        qualifiedName: formDashboardParameterDesign.__meta.qualifiedName,
        _type: formDashboardParameterDesign._type,
        value: formDashboardParameterDesign.value,
        valueInterpreter: formDashboardParameterDesign.valueInterpreter
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_section_mapper.js
var require_form_section_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_section_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFormSection = mapFormSection;
    function mapFormSection(parentFormElement, posInParent, formSectionDesign) {
      return {
        qualifiedName: formSectionDesign.__meta.qualifiedName,
        _type: "FormSection2",
        documentationInterpreter: formSectionDesign.documentationInterpreter ?? "LITERAL",
        layoutDirection: formSectionDesign.layoutDirection,
        posInParent,
        visibleValueInterpreter: formSectionDesign.visibleValueInterpreter ?? "LITERAL",
        description: formSectionDesign.description,
        documentation: formSectionDesign.documentation,
        label: formSectionDesign.label,
        labelWidth: formSectionDesign.labelWidth,
        parentFormContainer: parentFormElement.__meta.qualifiedName,
        relativeWidth: formSectionDesign.relativeWidth,
        visibleValue: formSectionDesign.visibleValue
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_tab_mapper.js
var require_form_tab_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_tab_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFormTab = mapFormTab;
    function mapFormTab(posInParent, formTabDesign) {
      return {
        qualifiedName: formTabDesign.__meta.qualifiedName,
        _type: formTabDesign._type,
        documentationInterpreter: formTabDesign.documentationInterpreter ?? "LITERAL",
        posInParent,
        visibleValueInterpreter: formTabDesign.visibleValueInterpreter ?? "LITERAL",
        description: formTabDesign.description,
        displayFormTabAs: formTabDesign.displayFormTabAs,
        documentation: formTabDesign.documentation,
        iconUrl: formTabDesign.iconUrl,
        label: formTabDesign.label,
        labelWidth: formTabDesign.labelWidth,
        parentFormContainer: void 0,
        visibleValue: formTabDesign.visibleValue
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/form/form_mapper.js
var require_form_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/form/form_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapForm = mapForm;
    var form_chart_mapper_1 = require_form_chart_mapper();
    var form_collection_mapper_1 = require_form_collection_mapper();
    var form_container_mapper_1 = require_form_container_mapper();
    var form_dashboard_mapper_1 = require_form_dashboard_mapper();
    var form_field_mapper_1 = require_form_field_mapper();
    var form_section_mapper_1 = require_form_section_mapper();
    var form_tab_mapper_1 = require_form_tab_mapper();
    function exploreFormElements(parentFormElement, posInParent, formElement, formElementsByType) {
      switch (formElement._type) {
        case "FormContainer":
          formElementsByType.formContainers.push((0, form_container_mapper_1.mapFormContainer)(parentFormElement, posInParent, formElement));
          formElement.content.forEach((formElementChild, index) => exploreFormElements(formElement, index, formElementChild, formElementsByType));
          break;
        case "FormSection":
          formElementsByType.formContainers.push((0, form_section_mapper_1.mapFormSection)(parentFormElement, posInParent, formElement));
          formElement.content.forEach((formSectionChild, index) => exploreFormElements(formElement, index, formSectionChild, formElementsByType));
          break;
        case "FormCollection":
          formElementsByType.formCollections.push((0, form_collection_mapper_1.mapFormCollection)(parentFormElement, posInParent, formElement));
          break;
        case "CheckboxField":
        case "DateField":
        case "HyperlinkField":
        case "IdField":
        case "ImageField":
        case "MarkdownField":
        case "MenuField":
        case "ObjectField":
        case "ReferenceField":
        case "TextField":
          formElementsByType.formFields.push((0, form_field_mapper_1.mapFormField)(parentFormElement, posInParent, formElement));
          break;
        case "FormDashboard":
          formElementsByType.formDashboards.push((0, form_dashboard_mapper_1.mapFormDashboard)(parentFormElement, posInParent, formElement));
          break;
        case "FormChart":
          formElementsByType.formCharts.push((0, form_chart_mapper_1.mapFormChart)(parentFormElement, posInParent, formElement));
          break;
      }
    }
    function mapForm(formDesign) {
      const formElementsByType = {
        formCharts: [],
        formCollections: [],
        formContainers: [],
        formDashboards: [],
        formFields: []
      };
      formDesign.formTabs.forEach((formTab, formTabIndex) => {
        formElementsByType.formContainers.push((0, form_tab_mapper_1.mapFormTab)(formTabIndex, formTab));
        formTab.content.forEach((formElement, index) => {
          exploreFormElements(formTab, index, formElement, formElementsByType);
        });
      });
      return {
        default: formDesign.default,
        qualifiedName: formDesign.__meta.qualifiedName,
        description: formDesign.description,
        documentation: formDesign.documentation,
        formCharts: formElementsByType.formCharts,
        formCollections: formElementsByType.formCollections,
        formContainers: formElementsByType.formContainers,
        formDashboards: formElementsByType.formDashboards,
        formFields: formElementsByType.formFields
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/fuzzy_lookup_rule/fuzzy_lookup_rule_mapper.js
var require_fuzzy_lookup_rule_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/fuzzy_lookup_rule/fuzzy_lookup_rule_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFuzzyLookupRule = mapFuzzyLookupRule;
    function mapFuzzyLookupRule(fuzzyLookupRuleDesign) {
      return {
        qualifiedName: fuzzyLookupRuleDesign.__meta.qualifiedName,
        label: fuzzyLookupRuleDesign.label,
        description: fuzzyLookupRuleDesign.description,
        binningCondition: fuzzyLookupRuleDesign.binningCondition,
        lookupScoreExpression: fuzzyLookupRuleDesign.lookupScoreExpression,
        sortExpression: fuzzyLookupRuleDesign.sortExpression,
        reference: fuzzyLookupRuleDesign.reference
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/matcher_mapper.js
var require_matcher_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/matcher_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapMatcher = mapMatcher;
    function mapMatcher(matcherDesign) {
      switch (matcherDesign._type) {
        case "SemQLMatcher": {
          return mapSemqlMatcher(matcherDesign);
        }
      }
    }
    function mapSemqlMatcher(semQLMatcherDesign) {
      return {
        _type: semQLMatcherDesign._type,
        qualifiedName: semQLMatcherDesign.__meta.qualifiedName,
        autoConfirmGoldenThreshold: semQLMatcherDesign.autoConfirmGoldenThreshold,
        autoConfirmSingletons: semQLMatcherDesign.autoConfirmSingletons,
        mergeThresholdMergingConfirmed: semQLMatcherDesign.mergeThresholdMergingConfirmed,
        mergeThresholdMergingConfirmedWithNewMasters: semQLMatcherDesign.mergeThresholdMergingConfirmedWithNewMasters,
        mergeThresholdMergingConfirmedWithUnconfirmed: semQLMatcherDesign.mergeThresholdMergingConfirmedWithUnconfirmed,
        mergeThresholdMergingUnconfirmed: semQLMatcherDesign.mergeThresholdMergingUnconfirmed,
        mergeThresholdMergingUnconfirmedWithNewMasters: semQLMatcherDesign.mergeThresholdMergingUnconfirmedWithNewMasters,
        mergeThresholdNewGroup: semQLMatcherDesign.mergeThresholdNewGroup,
        mergeThresholdRemergingPreviouslySplit: semQLMatcherDesign.mergeThresholdRemergingPreviouslySplit,
        useMultiIterationGrouping: semQLMatcherDesign.useMultiIterationGrouping,
        useTransitiveMatchScore: semQLMatcherDesign.useTransitiveMatchScore,
        description: semQLMatcherDesign.description,
        matchRules: semQLMatcherDesign.matchRules ? semQLMatcherDesign.matchRules.map((semqlMatchRuleDesign) => mapSemQLMatchRule(semqlMatchRuleDesign)) : void 0
      };
    }
    function mapSemQLMatchRule(matchRuleDesign) {
      return {
        qualifiedName: matchRuleDesign.__meta.qualifiedName,
        condition: matchRuleDesign.condition,
        matchScore: matchRuleDesign.matchScore,
        binningExpressions: matchRuleDesign.binningExpressions,
        color: matchRuleDesign.color,
        description: matchRuleDesign.description,
        documentation: matchRuleDesign.documentation,
        label: matchRuleDesign.label,
        matchOnExpression: matchRuleDesign.matchOnExpression,
        usingMatchOn: matchRuleDesign.usingMatchOn
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/search_form/search_form_mapper.js
var require_search_form_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/search_form/search_form_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapSearchForm = mapSearchForm;
    exports2.mapSearchParameter = mapSearchParameter;
    function mapSearchForm(searchFormDesign) {
      return {
        qualifiedName: searchFormDesign.__meta.qualifiedName,
        semQlCondition: searchFormDesign.semQlCondition,
        description: searchFormDesign.description,
        label: searchFormDesign.label,
        searchParameters: searchFormDesign.searchParameters ? searchFormDesign.searchParameters.map((searchParameterDesign) => mapSearchParameter(searchParameterDesign)) : void 0,
        searchTip: searchFormDesign.searchTip
      };
    }
    function mapSearchParameter(searchParameterDesign) {
      return {
        qualifiedName: searchParameterDesign.__meta.qualifiedName,
        abstractAtomicType: searchParameterDesign.dataType,
        bindVariableName: searchParameterDesign.bindVariableName,
        displayCount: searchParameterDesign.displayCount,
        displayType: searchParameterDesign.displayType,
        primaryTextExpression: searchParameterDesign.primaryTextExpression,
        useDistinct: searchParameterDesign.useDistinct,
        boundSelectExpression: searchParameterDesign.boundSelectExpression,
        description: searchParameterDesign.description,
        filterExpression: searchParameterDesign.filterExpression,
        label: searchParameterDesign.label,
        length: searchParameterDesign.length,
        lookupEntity: searchParameterDesign.lookupEntity,
        lovDisplayMode: searchParameterDesign.lovDisplayMode,
        lovSortMode: searchParameterDesign.lovSortMode,
        precision: searchParameterDesign.precision,
        scale: searchParameterDesign.scale,
        secondaryTextExpression: searchParameterDesign.secondaryTextExpression,
        sortByCount: searchParameterDesign.sortByCount,
        sortExpression: searchParameterDesign.sortExpression
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/stepper/step_trigger_mapper.js
var require_step_trigger_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/stepper/step_trigger_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapStepTrigger = mapStepTrigger;
    function mapStepTrigger(stepTriggerDesign) {
      switch (stepTriggerDesign._type) {
        case "StepEnricherTrigger": {
          return mapStepEnricherTrigger(stepTriggerDesign);
        }
        case "StepProcedureTrigger": {
          return mapStepProcedureTrigger(stepTriggerDesign);
        }
      }
    }
    function mapStepEnricherTrigger(stepEnricherTriggerDesign) {
      return {
        qualifiedName: stepEnricherTriggerDesign.__meta.qualifiedName,
        _type: stepEnricherTriggerDesign._type,
        description: stepEnricherTriggerDesign.description ?? "",
        enricher: stepEnricherTriggerDesign.enricher,
        event: stepEnricherTriggerDesign.event
      };
    }
    function mapStepProcedureTrigger(stepProcedureTriggerDesign) {
      return {
        qualifiedName: stepProcedureTriggerDesign.__meta.qualifiedName,
        _type: stepProcedureTriggerDesign._type,
        description: stepProcedureTriggerDesign.description ?? "",
        event: stepProcedureTriggerDesign.event,
        sqlFunction: stepProcedureTriggerDesign.sqlFunction,
        stepProcedureArgBindings: stepProcedureTriggerDesign.stepProcedureArgBindings
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/stepper/step/step-transition-validation-mapper.js
var require_step_transition_validation_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/stepper/step/step-transition-validation-mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapStepTransitionValidation = mapStepTransitionValidation;
    function mapStepTransitionValidation(stepTransitionValidationDesign) {
      return {
        _type: "StepTransitionValidation",
        onStepExit: stepTransitionValidationDesign.onStepExit,
        type: stepTransitionValidationDesign.validationType,
        attribute: stepTransitionValidationDesign.attribute,
        definitionAttribute: stepTransitionValidationDesign.definitionAttribute,
        matcher: stepTransitionValidationDesign.matcher,
        uniqueKey: stepTransitionValidationDesign.uniqueKey,
        validator: stepTransitionValidationDesign.validator
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/stepper/step/collection_step_mapper.js
var require_collection_step_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/stepper/step/collection_step_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapCollectionStep = mapCollectionStep;
    exports2.mapChildCollectionStep = mapChildCollectionStep;
    var step_trigger_mapper_1 = require_step_trigger_mapper();
    var step_transition_validation_mapper_1 = require_step_transition_validation_mapper();
    function mapCollectionStep(collectionStepDesign, entity) {
      return {
        qualifiedName: collectionStepDesign.__meta.qualifiedName,
        _type: collectionStepDesign._type,
        canFinishSubLevel: collectionStepDesign.canFinishSubLevel,
        childDeleteType: collectionStepDesign.childDeleteType,
        childImportModeOnParentEdit: "CREATE_AND_UPDATE",
        collectionView: collectionStepDesign.collectionView,
        createChildUsingManyToManyPicker: false,
        customSortEnabled: collectionStepDesign.customSortEnabled,
        defaultDisplayType: collectionStepDesign.defaultDisplayType,
        displayGridAllowed: collectionStepDesign.displayGridAllowed,
        displayListAllowed: collectionStepDesign.displayListAllowed,
        displayTableAllowed: collectionStepDesign.displayTableAllowed,
        enableChildCopyOnParentCreate: false,
        // This property value is ignored on root collection step by MDA, instead it checks the entity source id generation directly
        // See DXP-613 for more insights
        enableChildCopyOnParentEdit: entity?.sourceIdGeneration?.mode === "SEQUENCE" || entity?.sourceIdGeneration?.mode === "UUID",
        enableChildCreationOnParentCreate: false,
        enableChildCreationOnParentEdit: false,
        enableChildDeleteOnParentEdit: false,
        enableChildEditOnParentCreate: false,
        enableChildEditOnParentEdit: false,
        enableChildExport: false,
        // This property is assumed to always be true on root collection step by MDA, so forcing it to that value
        // See DXP-613 for more insights
        enableChildImportOnParentCreate: true,
        enableChildImportOnParentEdit: false,
        enableChildRemoveOnParentCreate: false,
        enableChildRemoveOnParentEdit: false,
        enabledOnParentCreate: collectionStepDesign.enabledOnParentCreate,
        enabledOnParentEdit: collectionStepDesign.enabledOnParentEdit,
        formFieldsMode: collectionStepDesign.formFieldsMode,
        linear: collectionStepDesign.linear,
        manyToManyCustomSortEnabled: false,
        manyToManyDefaultDisplayType: "GRID",
        manyToManyDisplayGridAllowed: false,
        manyToManyDisplayListAllowed: false,
        manyToManyDisplayTableAllowed: false,
        manyToManyUserDefinedSortEnabled: false,
        skipToChildCreationOnParentCreate: false,
        skipToChildEditingOnParentEdit: false,
        useCustomCollectionLabel: collectionStepDesign.useCustomCollectionLabel,
        userDefinedSortEnabled: collectionStepDesign.userDefinedSortEnabled,
        customCollectionLabel: collectionStepDesign.customCollectionLabel,
        description: collectionStepDesign.description,
        displayCard: collectionStepDesign.displayCard,
        filter: void 0,
        label: collectionStepDesign.label,
        manyToManyFdnAttribute: void 0,
        manyToManyPickerCollectionView: void 0,
        manyToManyPickerFilter: void 0,
        manyToManyPickerSearchTypeConfigs: void 0,
        manyToManySortExpression: void 0,
        oneToManyReference: void 0,
        parentCollectionStep: void 0,
        sortExpression: collectionStepDesign.sortExpression,
        stepTransitionValidations: collectionStepDesign.stepTransitionValidations ? collectionStepDesign.stepTransitionValidations.map((stepTransitionValidationDesign) => (0, step_transition_validation_mapper_1.mapStepTransitionValidation)(stepTransitionValidationDesign)) : void 0,
        abstractStepTriggers: collectionStepDesign.stepTriggers ? collectionStepDesign.stepTriggers.map((stepTriggerDesign) => (0, step_trigger_mapper_1.mapStepTrigger)(stepTriggerDesign)) : void 0
      };
    }
    function mapChildCollectionStep(collectionStepDesign) {
      return {
        qualifiedName: collectionStepDesign.__meta.qualifiedName,
        _type: collectionStepDesign._type,
        canFinishSubLevel: collectionStepDesign.canFinishSubLevel,
        childDeleteType: collectionStepDesign.childDeleteType,
        childImportModeOnParentEdit: collectionStepDesign.childImportModeOnParentEdit,
        collectionView: collectionStepDesign.collectionView,
        createChildUsingManyToManyPicker: collectionStepDesign.createChildUsingManyToManyPicker ?? false,
        customSortEnabled: collectionStepDesign.customSortEnabled,
        defaultDisplayType: collectionStepDesign.defaultDisplayType,
        displayGridAllowed: collectionStepDesign.displayGridAllowed,
        displayListAllowed: collectionStepDesign.displayListAllowed,
        displayTableAllowed: collectionStepDesign.displayTableAllowed,
        enableChildCopyOnParentCreate: collectionStepDesign.enableChildCopyOnParentCreate,
        enableChildCopyOnParentEdit: collectionStepDesign.enableChildCopyOnParentEdit,
        enableChildCreationOnParentCreate: collectionStepDesign.enableChildCreationOnParentCreate,
        enableChildCreationOnParentEdit: collectionStepDesign.enableChildCreationOnParentEdit,
        enableChildDeleteOnParentEdit: collectionStepDesign.enableChildDeleteOnParentEdit,
        enableChildEditOnParentCreate: collectionStepDesign.enableChildEditOnParentCreate,
        enableChildEditOnParentEdit: collectionStepDesign.enableChildEditOnParentEdit,
        enableChildExport: collectionStepDesign.enableChildExport,
        enableChildImportOnParentCreate: collectionStepDesign.enableChildImportOnParentCreate,
        enableChildImportOnParentEdit: collectionStepDesign.enableChildImportOnParentEdit,
        enableChildRemoveOnParentCreate: collectionStepDesign.enableChildRemoveOnParentCreate,
        enableChildRemoveOnParentEdit: collectionStepDesign.enableChildRemoveOnParentEdit,
        enabledOnParentCreate: collectionStepDesign.enabledOnParentCreate,
        enabledOnParentEdit: collectionStepDesign.enabledOnParentEdit,
        formFieldsMode: collectionStepDesign.formFieldsMode,
        linear: collectionStepDesign.linear,
        manyToManyCustomSortEnabled: collectionStepDesign.manyToManyCustomSortEnabled ?? false,
        manyToManyDefaultDisplayType: collectionStepDesign.manyToManyDefaultDisplayType ?? "TABLE",
        manyToManyDisplayGridAllowed: collectionStepDesign.manyToManyDisplayGridAllowed ?? false,
        manyToManyDisplayListAllowed: collectionStepDesign.manyToManyDisplayListAllowed ?? false,
        manyToManyDisplayTableAllowed: collectionStepDesign.manyToManyDisplayTableAllowed ?? false,
        manyToManyUserDefinedSortEnabled: collectionStepDesign.manyToManyUserDefinedSortEnabled ?? false,
        skipToChildCreationOnParentCreate: collectionStepDesign.skipToChildCreationOnParentCreate,
        skipToChildEditingOnParentEdit: collectionStepDesign.skipToChildEditingOnParentEdit,
        useCustomCollectionLabel: collectionStepDesign.useCustomCollectionLabel,
        userDefinedSortEnabled: collectionStepDesign.userDefinedSortEnabled,
        customCollectionLabel: collectionStepDesign.customCollectionLabel,
        description: collectionStepDesign.description,
        displayCard: collectionStepDesign.displayCard,
        filter: collectionStepDesign.filter,
        label: collectionStepDesign.label,
        manyToManyFdnAttribute: collectionStepDesign.manyToManyFdnAttribute,
        manyToManyPickerCollectionView: collectionStepDesign.manyToManyPickerCollectionView,
        manyToManyPickerFilter: collectionStepDesign.manyToManyPickerFilter,
        manyToManyPickerSearchTypeConfigs: collectionStepDesign.manyToManyPickerSearchTypeConfigs,
        manyToManySortExpression: collectionStepDesign.manyToManySortExpression,
        oneToManyReference: collectionStepDesign.oneToManyReference,
        parentCollectionStep: collectionStepDesign.__meta.parentQualifiedName,
        sortExpression: collectionStepDesign.sortExpression,
        stepTransitionValidations: collectionStepDesign.stepTransitionValidations ? collectionStepDesign.stepTransitionValidations.map((stepTransitionValidationDesign) => (0, step_transition_validation_mapper_1.mapStepTransitionValidation)(stepTransitionValidationDesign)) : void 0,
        abstractStepTriggers: collectionStepDesign.stepTriggers ? collectionStepDesign.stepTriggers.map((stepTriggerDesign) => (0, step_trigger_mapper_1.mapStepTrigger)(stepTriggerDesign)) : void 0
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/stepper/step/form_step_mapper.js
var require_form_step_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/stepper/step/form_step_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapFormStep = mapFormStep;
    exports2.mapFormStepValidation = mapFormStepValidation;
    var step_trigger_mapper_1 = require_step_trigger_mapper();
    var step_transition_validation_mapper_1 = require_step_transition_validation_mapper();
    function mapFormStep(formStepDesign) {
      return {
        qualifiedName: formStepDesign.__meta.qualifiedName,
        _type: formStepDesign._type,
        canFinishSubLevel: formStepDesign.canFinishSubLevel,
        enabledOnParentCreate: formStepDesign.enabledOnParentCreate,
        enabledOnParentEdit: formStepDesign.enabledOnParentEdit,
        enableMasterValuePicking: formStepDesign.enableMasterValuePicking,
        formFieldsMode: formStepDesign.formFieldsMode,
        description: formStepDesign.description,
        formSection: formStepDesign.formSection,
        formStepEnrichers: formStepDesign.formStepEnrichers,
        formStepValidations: formStepDesign.formStepValidations ? formStepDesign.formStepValidations.map((formStepValidationDesign) => mapFormStepValidation(formStepValidationDesign)) : void 0,
        formTab: formStepDesign.formTab,
        label: formStepDesign.label,
        parentCollectionStep: formStepDesign.__meta.parentQualifiedName,
        referenceFormFieldConfigs: formStepDesign.referenceFormFieldConfigs,
        stepTransitionValidations: formStepDesign.stepTransitionValidations ? formStepDesign.stepTransitionValidations.map((stepTransitionValidationDesign) => (0, step_transition_validation_mapper_1.mapStepTransitionValidation)(stepTransitionValidationDesign)) : void 0,
        abstractStepTriggers: formStepDesign.stepTriggers ? formStepDesign.stepTriggers.map((stepTriggerDesign) => (0, step_trigger_mapper_1.mapStepTrigger)(stepTriggerDesign)) : void 0
      };
    }
    function mapFormStepValidation(formStepValidationDesign) {
      return {
        _type: "FormStepValidation",
        type: formStepValidationDesign.validationType,
        attribute: formStepValidationDesign.attribute,
        definitionAttribute: formStepValidationDesign.definitionAttribute,
        executedOnDataChange: formStepValidationDesign.executedOnDataChange,
        executedOnFormOpen: formStepValidationDesign.executedOnFormOpen,
        matcher: formStepValidationDesign.matcher,
        uniqueKey: formStepValidationDesign.uniqueKey,
        validator: formStepValidationDesign.validator
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/stepper/step/step_mapper.js
var require_step_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/stepper/step/step_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapSteps = mapSteps;
    exports2.mapStep = mapStep;
    var collection_step_mapper_1 = require_collection_step_mapper();
    var form_step_mapper_1 = require_form_step_mapper();
    function mapSteps(rootStep, entity) {
      if (!rootStep.childSteps) {
        return [(0, collection_step_mapper_1.mapCollectionStep)(rootStep, entity)];
      }
      const mappedRoot = (0, collection_step_mapper_1.mapCollectionStep)(rootStep, entity);
      const steps = [mappedRoot];
      const queue = [];
      queue.push(...rootStep.childSteps);
      let current = queue.shift();
      while (current) {
        steps.push(mapStep(current));
        if (current._type === "CollectionStep") {
          queue.push(...current.childSteps ?? []);
        }
        current = queue.shift();
      }
      return steps;
    }
    function mapStep(stepDesign) {
      switch (stepDesign._type) {
        case "CollectionStep": {
          return (0, collection_step_mapper_1.mapChildCollectionStep)(stepDesign);
        }
        case "FormStep": {
          return (0, form_step_mapper_1.mapFormStep)(stepDesign);
        }
      }
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/stepper/stepper_mapper.js
var require_stepper_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/stepper/stepper_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapStepper = mapStepper;
    exports2.mapStepperFinishValidation = mapStepperFinishValidation;
    var memory_1 = require_memory();
    var step_mapper_1 = require_step_mapper();
    function mapStepper(stepperDesign, modelElementQueries) {
      const entity = modelElementQueries.findByQualifiedName(stepperDesign.entity, memory_1.TOP_LEVEL_ENUM.MODEL_ENTITY).match;
      const steps = (0, step_mapper_1.mapSteps)(stepperDesign.rootStep, entity);
      return {
        qualifiedName: stepperDesign.__meta.qualifiedName,
        description: stepperDesign.description,
        iconUrl: stepperDesign.iconUrl,
        label: stepperDesign.label,
        modelJob: stepperDesign.modelJob,
        rootCollectionStep: stepperDesign.rootStep.__meta.qualifiedName,
        stepperFinishValidations: stepperDesign.stepperFinishValidations ? stepperDesign.stepperFinishValidations.map((stepperFinishValidation) => mapStepperFinishValidation(stepperFinishValidation, entity)) : void 0,
        steps,
        triggers: stepperDesign.triggers ? stepperDesign.triggers.map((stepperProcedureTriggerDesign) => mapStepperProcedureTrigger(stepperProcedureTriggerDesign)) : void 0
      };
    }
    function mapStepperFinishValidation(stepperFinishValidation, entity) {
      let matcher;
      if (stepperFinishValidation.validationType === "DETECT_DUPS") {
        matcher = entity?.matcher?.__meta.qualifiedName;
      }
      return {
        _type: "StepperFinishValidation",
        onStepperFinish: stepperFinishValidation.onStepperFinish,
        type: stepperFinishValidation.validationType,
        attribute: stepperFinishValidation.attribute,
        definitionAttribute: stepperFinishValidation.definitionAttribute,
        matcher,
        uniqueKey: stepperFinishValidation.uniqueKey,
        validator: stepperFinishValidation.validator
      };
    }
    function mapStepperProcedureTrigger(stepperProcedureTriggerDesign) {
      return {
        qualifiedName: stepperProcedureTriggerDesign.__meta.qualifiedName,
        _type: stepperProcedureTriggerDesign._type,
        description: stepperProcedureTriggerDesign.description,
        event: stepperProcedureTriggerDesign.event,
        sqlFunction: stepperProcedureTriggerDesign.sqlFunction,
        stepperProcedureArgBindings: stepperProcedureTriggerDesign.stepperProcedureArgBindings
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/survivorship_rule/survivorship_rule_mapper.js
var require_survivorship_rule_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/survivorship_rule/survivorship_rule_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapSurvivorshipRule = mapSurvivorshipRule;
    exports2.mapIdSurvivorshipRule = mapIdSurvivorshipRule;
    exports2.mapStandardSurvivorshipRule = mapStandardSurvivorshipRule;
    var memory_1 = require_memory();
    function mapSurvivorshipRule(survivorshipRuleDesign) {
      switch (survivorshipRuleDesign._type) {
        case memory_1.TOP_LEVEL_ENUM.ENTITY_ID_SURVIVORSHIP_RULE: {
          return mapIdSurvivorshipRule(survivorshipRuleDesign);
        }
        case memory_1.TOP_LEVEL_ENUM.ENTITY_STANDARD_SURVIVORSHIP_RULE: {
          return mapStandardSurvivorshipRule(survivorshipRuleDesign);
        }
      }
    }
    function mapIdSurvivorshipRule(idSurvivorshipRuleDesign) {
      return {
        qualifiedName: idSurvivorshipRuleDesign.__meta.qualifiedName,
        _type: "IdSurvivorshipRule",
        consolidationSkipNulls: idSurvivorshipRuleDesign.consolidationSkipNulls,
        label: idSurvivorshipRuleDesign.label,
        consolidationOrderByExpression: idSurvivorshipRuleDesign.consolidationOrderByExpression,
        consolidationStrategy: idSurvivorshipRuleDesign.consolidationStrategy,
        description: idSurvivorshipRuleDesign.description,
        documentation: idSurvivorshipRuleDesign.documentation,
        publisherRankings: idSurvivorshipRuleDesign.publisherRankings ? idSurvivorshipRuleDesign.publisherRankings.map((consoPublisherRankingDesign, index) => mapConsoPublisherRanking(index, consoPublisherRankingDesign)) : void 0
      };
    }
    function mapStandardSurvivorshipRule(standardSurvivorshipRuleDesign) {
      return {
        qualifiedName: standardSurvivorshipRuleDesign.__meta.qualifiedName,
        _type: standardSurvivorshipRuleDesign._type,
        consolidationSkipNulls: standardSurvivorshipRuleDesign.consolidationSkipNulls,
        label: standardSurvivorshipRuleDesign.label,
        consolidationOrderByExpression: standardSurvivorshipRuleDesign.consolidationOrderByExpression,
        consolidationStrategy: standardSurvivorshipRuleDesign.consolidationStrategy,
        description: standardSurvivorshipRuleDesign.description,
        documentation: standardSurvivorshipRuleDesign.documentation,
        publisherRankings: standardSurvivorshipRuleDesign.publisherRankings ? standardSurvivorshipRuleDesign.publisherRankings.map((consoPublisherRankingDesign, index) => mapConsoPublisherRanking(index, consoPublisherRankingDesign)) : void 0,
        defaultRule: standardSurvivorshipRuleDesign.defaultRule,
        attributes: standardSurvivorshipRuleDesign.attributes,
        overrideDecayTimeDuration: standardSurvivorshipRuleDesign.overrideDecayTimeDuration,
        overrideDecayTimeUnit: standardSurvivorshipRuleDesign.overrideDecayTimeUnit,
        overrideStrategy: standardSurvivorshipRuleDesign.overrideStrategy
      };
    }
    function mapConsoPublisherRanking(rank, consoPublisherRankingDesign) {
      return {
        _type: consoPublisherRankingDesign._type,
        publisher: consoPublisherRankingDesign.publisher,
        rank
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/unique_key/unique_key_mapper.js
var require_unique_key_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/unique_key/unique_key_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapUniqueKey = mapUniqueKey;
    exports2.mapKeyAttribute = mapKeyAttribute;
    function mapUniqueKey(uniqueKeyDesign) {
      return {
        qualifiedName: uniqueKeyDesign.__meta.qualifiedName,
        validationLabel: uniqueKeyDesign.validationLabel,
        validationScope: uniqueKeyDesign.validationScope,
        description: uniqueKeyDesign.description,
        keyAttributes: uniqueKeyDesign.keyAttributes ? uniqueKeyDesign.keyAttributes.map((keyAttributeDesign) => mapKeyAttribute(keyAttributeDesign)) : void 0,
        label: uniqueKeyDesign.label
      };
    }
    function mapKeyAttribute(keyAttributeDesign) {
      return {
        abstractAttribute: keyAttributeDesign.attribute
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/validation/validation_mapper.js
var require_validation_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/validation/validation_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapConstraint = mapConstraint;
    var memory_1 = require_memory();
    function mapConstraint(validationDesign) {
      switch (validationDesign._type) {
        case memory_1.TOP_LEVEL_ENUM.ENTITY_SEMQL_VALIDATION: {
          return mapCheckConstraint(validationDesign);
        }
        case memory_1.TOP_LEVEL_ENUM.ENTITY_PLUGIN_VALIDATION: {
          return mapPluginValidator(validationDesign);
        }
      }
    }
    function mapCheckConstraint(semqlValidationDesign) {
      return {
        qualifiedName: semqlValidationDesign.__meta.qualifiedName,
        _type: "CheckConstraint",
        condition: semqlValidationDesign.condition,
        validationLabel: semqlValidationDesign.validationLabel ?? "",
        validationScope: semqlValidationDesign.validationScope,
        description: semqlValidationDesign.description,
        label: semqlValidationDesign.label
      };
    }
    function mapPluginValidator(pluginValidationDesign) {
      return {
        qualifiedName: pluginValidationDesign.__meta.qualifiedName,
        _type: "PluginValidator",
        numberOfRetry: pluginValidationDesign.numberOfRetry,
        onErrorBehavior: pluginValidationDesign.onErrorBehavior,
        pluginId: pluginValidationDesign.pluginId,
        threadPoolSize: pluginValidationDesign.threadPoolSize,
        validationLabel: pluginValidationDesign.validationLabel ?? "",
        validationScope: pluginValidationDesign.validationScope,
        description: pluginValidationDesign.description,
        label: pluginValidationDesign.label,
        pluginInputs: pluginValidationDesign.pluginInputs ? pluginValidationDesign.pluginInputs.map((pluginValidationInputDesign) => mapPluginValidatorInput(pluginValidationInputDesign)) : void 0,
        pluginParams: pluginValidationDesign.pluginParams ? pluginValidationDesign.pluginParams.map((pluginValidationParamDesign) => mapPluginValidatorParam(pluginValidationParamDesign)) : void 0
      };
    }
    function mapPluginValidatorInput(pluginValidationInputDesign) {
      return {
        _type: "PluginValidatorInput",
        expression: pluginValidationInputDesign.expression,
        inputName: pluginValidationInputDesign.inputName
      };
    }
    function mapPluginValidatorParam(pluginValidationParamDesign) {
      return {
        _type: "PluginValidatorParam",
        paramName: pluginValidationParamDesign.paramName,
        value: pluginValidationParamDesign.value
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/entity/entity_mapper.js
var require_entity_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/entity/entity_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapEntity = mapEntity;
    var top_level_1 = require_top_level();
    var ation_set_mapper_1 = require_ation_set_mapper();
    var attribute_mapper_1 = require_attribute_mapper();
    var business_view_mapper_1 = require_business_view_mapper();
    var collection_view_mapper_1 = require_collection_view_mapper();
    var display_card_mapper_1 = require_display_card_mapper();
    var dups_manager_mapper_1 = require_dups_manager_mapper();
    var enricher_mapper_1 = require_enricher_mapper();
    var form_mapper_1 = require_form_mapper();
    var fuzzy_lookup_rule_mapper_1 = require_fuzzy_lookup_rule_mapper();
    var matcher_mapper_1 = require_matcher_mapper();
    var search_form_mapper_1 = require_search_form_mapper();
    var stepper_mapper_1 = require_stepper_mapper();
    var survivorship_rule_mapper_1 = require_survivorship_rule_mapper();
    var unique_key_mapper_1 = require_unique_key_mapper();
    var validation_mapper_1 = require_validation_mapper();
    function mapEntity(entityDesign, modelElementQueries) {
      const entityQualifiedName = entityDesign.__meta.qualifiedName;
      const attributes = (0, attribute_mapper_1.mapEntityAttributes)(entityDesign, modelElementQueries);
      const pkAttributes = attributes.pk ? [attributes.pk] : [];
      const displayCards = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_DISPLAY_CARD).filter((displayCardDesign) => displayCardDesign.entity === entityQualifiedName).map((displayCardDesign) => (0, display_card_mapper_1.mapDisplayCard)(displayCardDesign));
      const abstractRowCheckConstraints = modelElementQueries.findAllByTypes([
        top_level_1.TOP_LEVEL_ENUM.ENTITY_PLUGIN_VALIDATION,
        top_level_1.TOP_LEVEL_ENUM.ENTITY_SEMQL_VALIDATION
      ]).filter((validationDesign) => validationDesign.entity === entityQualifiedName).map((validationDesign) => (0, validation_mapper_1.mapConstraint)(validationDesign));
      const uniqueKeys = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_UNIQUE_KEY).filter((uniqueKeyDesign) => uniqueKeyDesign.entity === entityQualifiedName).map((uniqueKeyDesign) => (0, unique_key_mapper_1.mapUniqueKey)(uniqueKeyDesign));
      const enrichers = (0, enricher_mapper_1.mapEnrichers)(modelElementQueries.findAllByTypes([
        top_level_1.TOP_LEVEL_ENUM.ENTITY_SEMQL_ENRICHER,
        top_level_1.TOP_LEVEL_ENUM.ENTITY_JAVA_PLUGIN_ENRICHER,
        top_level_1.TOP_LEVEL_ENUM.ENTITY_REST_CLIENT_ENRICHER
      ]).filter((enricherDesign) => enricherDesign.entity === entityQualifiedName));
      const matcher = entityDesign.matcher ? (0, matcher_mapper_1.mapMatcher)(entityDesign.matcher) : void 0;
      const survivorshipRules = modelElementQueries.findAllByTypes([
        top_level_1.TOP_LEVEL_ENUM.ENTITY_STANDARD_SURVIVORSHIP_RULE,
        top_level_1.TOP_LEVEL_ENUM.ENTITY_ID_SURVIVORSHIP_RULE
      ]).filter((survivorshipRuleDesign) => survivorshipRuleDesign.entity === entityQualifiedName).map((survivorshipRuleDesign) => (0, survivorship_rule_mapper_1.mapSurvivorshipRule)(survivorshipRuleDesign));
      const fuzzyLookupRules = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_FUZZY_LOOKUP_RULE).filter((fuzzyLookupRuleDesign) => fuzzyLookupRuleDesign.entity === entityQualifiedName).map((fuzzyLookupRuleDesign) => (0, fuzzy_lookup_rule_mapper_1.mapFuzzyLookupRule)(fuzzyLookupRuleDesign));
      const searchForms = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_SEARCH_FORM).filter((searchFormDesign) => searchFormDesign.entity === entityQualifiedName).map((searchFormDesign) => (0, search_form_mapper_1.mapSearchForm)(searchFormDesign));
      const collections = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_COLLECTION_VIEW).filter((collectionViewDesign) => collectionViewDesign.entity === entityQualifiedName).map((collectionViewDesign) => (0, collection_view_mapper_1.mapCollectionView)(collectionViewDesign));
      const forms = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_FORM).filter((formDesign) => formDesign.entity === entityQualifiedName).map((formDesign) => (0, form_mapper_1.mapForm)(formDesign));
      const steppers = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_STEPPER).filter((stepperDesign) => stepperDesign.entity === entityQualifiedName).map((stepperDesign) => (0, stepper_mapper_1.mapStepper)(stepperDesign, modelElementQueries));
      const dupsManagers = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_DUPS_MANAGER).filter((dupsManagerDesign) => dupsManagerDesign.entity === entityQualifiedName).map((dupsManagerDesign) => (0, dups_manager_mapper_1.mapDupsManager)(dupsManagerDesign));
      const actionSets = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_ACTION_SET).filter((actionSetDesign) => actionSetDesign.entity === entityQualifiedName).map((actionSetDesign) => (0, ation_set_mapper_1.mapActionSet)(actionSetDesign, modelElementQueries));
      const businessObjectViews = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.ENTITY_BUSINESS_VIEW).filter((businessViewDesign) => businessViewDesign.entity === entityQualifiedName).map((businessViewDesign) => (0, business_view_mapper_1.mapBusinessObjectView)(businessViewDesign));
      return {
        qualifiedName: entityQualifiedName,
        dataEntryAllowed: entityDesign.dataEntryAllowed ?? true,
        historizeGolden: entityDesign.historizeGolden,
        historizeMaster: entityDesign.historizeMaster,
        description: entityDesign.description,
        documentation: entityDesign.documentation,
        enableDelete: entityDesign.enableDelete,
        entityType: entityDesign.entityType,
        iconUrl: entityDesign.iconUrl,
        label: entityDesign.label,
        parentEntity: entityDesign.parentEntity,
        physicalTableName: entityDesign.physicalTableName,
        pluralLabel: entityDesign.pluralLabel,
        pkAttributes,
        atomicAttributes: attributes.atomic,
        complexAttributes: attributes.complex,
        attributeGroups: void 0,
        matcher,
        abstractRowCheckConstraints,
        actionSets,
        businessObjectViews,
        collections,
        displayCards,
        dupsManagers,
        enrichers,
        forms,
        searchForms,
        steppers,
        survivorshipRules,
        uniqueKeys,
        fuzzyLookupRules
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/job/job_mapper.js
var require_job_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/job/job_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapModelJob = mapModelJob;
    function mapModelJob(modelJobDesign) {
      return {
        qualifiedName: modelJobDesign.__meta.qualifiedName,
        description: modelJobDesign.description,
        jobType: modelJobDesign.jobType,
        queueName: modelJobDesign.queueName,
        jobParams: modelJobDesign.jobParams ? modelJobDesign.jobParams.map((modelJobParamDesign) => mapModelJobParam(modelJobParamDesign)) : void 0,
        modelTasks: modelJobDesign.modelTasks ? modelJobDesign.modelTasks.map((modelJobTaskDesign) => mapModelJobTask(modelJobTaskDesign)) : void 0
      };
    }
    function mapModelJobParam(modelJobParamDesign) {
      return {
        qualifiedName: modelJobParamDesign.__meta.qualifiedName,
        value: modelJobParamDesign.value
      };
    }
    function mapModelJobTask(modelJobTaskDesign) {
      return {
        qualifiedName: modelJobTaskDesign.__meta.qualifiedName,
        entity: modelJobTaskDesign.entity,
        consolidatedDataEnrichmentEnabled: modelJobTaskDesign.consolidatedDataEnrichmentEnabled,
        consolidationEnabled: modelJobTaskDesign.consolidationEnabled,
        matchEnabled: modelJobTaskDesign.matchEnabled,
        postConsoValidationEnabled: modelJobTaskDesign.postConsoValidationEnabled,
        sourceDataEnrichmentEnabled: modelJobTaskDesign.sourceDataEnrichmentEnabled,
        sourceValidationEnabled: modelJobTaskDesign.sourceValidationEnabled
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/list_of_value/list_of_value_mapper.js
var require_list_of_value_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/list_of_value/list_of_value_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapLovType = mapLovType;
    exports2.mapLovValue = mapLovValue;
    function mapLovType(lovTypeDesign) {
      return {
        qualifiedName: lovTypeDesign.__meta.qualifiedName,
        _type: lovTypeDesign._type,
        description: lovTypeDesign.description ?? "",
        label: lovTypeDesign.label,
        validationLabel: lovTypeDesign.validationLabel ?? "",
        length: lovTypeDesign.length,
        lengthModifiable: void 0,
        lovValues: lovTypeDesign.lovValues ? lovTypeDesign.lovValues.map((lovValueDesign) => mapLovValue(lovValueDesign)) : void 0,
        nullImageUrl: lovTypeDesign.nullImageUrl,
        nullLabel: lovTypeDesign.nullLabel,
        precision: void 0,
        precisionModifiable: void 0,
        scale: void 0,
        scaleModifiable: void 0
      };
    }
    function mapLovValue(lovValueDesign) {
      return {
        description: lovValueDesign.description ?? "",
        label: lovValueDesign.label,
        code: lovValueDesign.code,
        imageUrl: lovValueDesign.imageUrl
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/model_diagram/color_format.js
var require_color_format = __commonJS({
  "../../packages/xdm-schema/out/mapper/model_diagram/color_format.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseCssColor = parseCssColor;
    var namedColors = {
      aliceblue: "#f0f8ff",
      antiquewhite: "#faebd7",
      aqua: "#00ffff",
      aquamarine: "#7fffd4",
      azure: "#f0ffff",
      beige: "#f5f5dc",
      bisque: "#ffe4c4",
      black: "#000000",
      blanchedalmond: "#ffebcd",
      blue: "#0000ff",
      blueviolet: "#8a2be2",
      brown: "#a52a2a",
      burlywood: "#deb887",
      cadetblue: "#5f9ea0",
      chartreuse: "#7fff00",
      chocolate: "#d2691e",
      coral: "#ff7f50",
      cornflowerblue: "#6495ed",
      cornsilk: "#fff8dc",
      crimson: "#dc143c",
      cyan: "#00ffff",
      darkblue: "#00008b",
      darkcyan: "#008b8b",
      darkgoldenrod: "#b8860b",
      darkgray: "#a9a9a9",
      darkgreen: "#006400",
      darkkhaki: "#bdb76b",
      darkmagenta: "#8b008b",
      darkolivegreen: "#556b2f",
      darkorange: "#ff8c00",
      darkorchid: "#9932cc",
      darkred: "#8b0000",
      darksalmon: "#e9967a",
      darkseagreen: "#8fbc8f",
      darkslateblue: "#483d8b",
      darkslategray: "#2f4f4f",
      darkturquoise: "#00ced1",
      darkviolet: "#9400d3",
      deeppink: "#ff1493",
      deepskyblue: "#00bfff",
      dimgray: "#696969",
      dodgerblue: "#1e90ff",
      firebrick: "#b22222",
      floralwhite: "#fffaf0",
      forestgreen: "#228b22",
      fuchsia: "#ff00ff",
      gainsboro: "#dcdcdc",
      ghostwhite: "#f8f8ff",
      gold: "#ffd700",
      goldenrod: "#daa520",
      gray: "#808080",
      green: "#008000",
      greenyellow: "#adff2f",
      honeydew: "#f0fff0",
      hotpink: "#ff69b4",
      indianred: "#cd5c5c",
      indigo: "#4b0082",
      ivory: "#fffff0",
      khaki: "#f0e68c",
      lavender: "#e6e6fa",
      lavenderblush: "#fff0f5",
      lawngreen: "#7cfc00",
      lemonchiffon: "#fffacd",
      lightblue: "#add8e6",
      lightcoral: "#f08080",
      lightcyan: "#e0ffff",
      lightgoldenrodyellow: "#fafad2",
      lightgray: "#d3d3d3",
      lightgreen: "#90ee90",
      lightpink: "#ffb6c1",
      lightsalmon: "#ffa07a",
      lightseagreen: "#20b2aa",
      lightskyblue: "#87cefa",
      lightslategray: "#778899",
      lightsteelblue: "#b0c4de",
      lightyellow: "#ffffe0",
      lime: "#00ff00",
      limegreen: "#32cd32",
      linen: "#faf0e6",
      magenta: "#ff00ff",
      maroon: "#800000",
      mediumaquamarine: "#66cdaa",
      mediumblue: "#0000cd",
      mediumorchid: "#ba55d3",
      mediumpurple: "#9370db",
      mediumseagreen: "#3cb371",
      mediumslateblue: "#7b68ee",
      mediumspringgreen: "#00fa9a",
      mediumturquoise: "#48d1cc",
      mediumvioletred: "#c71585",
      midnightblue: "#191970",
      mintcream: "#f5fffa",
      mistyrose: "#ffe4e1",
      moccasin: "#ffe4b5",
      navajowhite: "#ffdead",
      navy: "#000080",
      oldlace: "#fdf5e6",
      olive: "#808000",
      olivedrab: "#6b8e23",
      orange: "#ffa500",
      orangered: "#ff4500",
      orchid: "#da70d6",
      palegoldenrod: "#eee8aa",
      palegreen: "#98fb98",
      paleturquoise: "#afeeee",
      palevioletred: "#db7093",
      papayawhip: "#ffefd5",
      peachpuff: "#ffdab9",
      peru: "#cd853f",
      pink: "#ffc0cb",
      plum: "#dda0dd",
      powderblue: "#b0e0e6",
      purple: "#800080",
      rebeccapurple: "#663399",
      red: "#ff0000",
      rosybrown: "#bc8f8f",
      royalblue: "#4169e1",
      saddlebrown: "#8b4513",
      salmon: "#fa8072",
      sandybrown: "#f4a460",
      seagreen: "#2e8b57",
      seashell: "#fff5ee",
      sienna: "#a0522d",
      silver: "#c0c0c0",
      skyblue: "#87ceeb",
      slateblue: "#6a5acd",
      slategray: "#708090",
      snow: "#fffafa",
      springgreen: "#00ff7f",
      steelblue: "#4682b4",
      tan: "#d2b48c",
      teal: "#008080",
      thistle: "#d8bfd8",
      tomato: "#ff6347",
      turquoise: "#40e0d0",
      violet: "#ee82ee",
      wheat: "#f5deb3",
      white: "#ffffff",
      whitesmoke: "#f5f5f5",
      yellow: "#ffff00",
      yellowgreen: "#9acd32"
    };
    function hexToRgb(hex) {
      const match = hex.match(/^#([a-fA-F0-9]{3}|[a-fA-F0-9]{6})$/);
      if (!match) {
        return "";
      }
      let r, g, b;
      if (hex.startsWith("#")) {
        hex = hex.slice(1);
      }
      if (hex.length === 3) {
        hex = hex.split("").map((c) => c + c).join("");
      }
      if (hex.length === 6) {
        r = parseInt(hex.substring(0, 2), 16);
        g = parseInt(hex.substring(2, 4), 16);
        b = parseInt(hex.substring(4, 6), 16);
        return `${r},${g},${b}`;
      }
      return "";
    }
    function rgbStringToTuple(rgb) {
      const match = rgb.match(/^rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)$/);
      if (!match) {
        return "";
      }
      return `${match[1]},${match[2]},${match[3]}`;
    }
    function hslToRgb(hsl) {
      const match = hsl.match(/^hsl\s*\(\s*(\d+)\s*,\s*(\d+)%\s*,\s*(\d+)%\s*\)$/);
      if (!match) {
        return "";
      }
      const h = parseInt(match[1], 10) / 360;
      const s = parseInt(match[2], 10) / 100;
      const l = parseInt(match[3], 10) / 100;
      let r, g, b;
      if (s === 0) {
        r = g = b = l;
      } else {
        const hue2rgb = (p2, q2, t) => {
          if (t < 0)
            t += 1;
          if (t > 1)
            t -= 1;
          if (t < 1 / 6)
            return p2 + (q2 - p2) * 6 * t;
          if (t < 1 / 2)
            return q2;
          if (t < 2 / 3)
            return p2 + (q2 - p2) * (2 / 3 - t) * 6;
          return p2;
        };
        const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        const p = 2 * l - q;
        r = hue2rgb(p, q, h + 1 / 3);
        g = hue2rgb(p, q, h);
        b = hue2rgb(p, q, h - 1 / 3);
      }
      return `${Math.round(r * 255)},${Math.round(g * 255)},${Math.round(b * 255)}`;
    }
    function parseCssColor(color) {
      color = color.trim();
      if (color.startsWith("#")) {
        return hexToRgb(color);
      }
      if (color.startsWith("rgb")) {
        return rgbStringToTuple(color);
      }
      if (color.startsWith("hsl")) {
        return hslToRgb(color);
      }
      if (color.toLowerCase() in namedColors) {
        return hexToRgb(namedColors[color.toLowerCase()]);
      }
      return "";
    }
  }
});

// ../../packages/xdm-schema/out/mapper/model_diagram/model_diagram_mapper.js
var require_model_diagram_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/model_diagram/model_diagram_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapModelDiagram = mapModelDiagram;
    var color_format_1 = require_color_format();
    function mapEntityShapeParam(entityShapeParamDesign) {
      return {
        qualifiedName: entityShapeParamDesign.__meta.qualifiedName,
        entity: entityShapeParamDesign.entity,
        position: entityShapeParamDesign.position,
        width: entityShapeParamDesign.width,
        height: entityShapeParamDesign.height,
        borderColor: (0, color_format_1.parseCssColor)(entityShapeParamDesign.borderColor),
        fontTitleColor: (0, color_format_1.parseCssColor)(entityShapeParamDesign.fontTitleColor)
      };
    }
    function mapModelDiagram(modelDiagramDesign) {
      return {
        qualifiedName: modelDiagramDesign.__meta.qualifiedName,
        attributeNameFormat: modelDiagramDesign.attributeNameFormat,
        description: modelDiagramDesign.description,
        entityNameFormat: modelDiagramDesign.entityNameFormat,
        entityShapes: modelDiagramDesign.entityShapes ? modelDiagramDesign.entityShapes.map((entityShape) => mapEntityShapeParam(entityShape)) : [],
        iconUrl: modelDiagramDesign.iconUrl,
        inheritLinks: modelDiagramDesign.inheritLinks,
        referenceLinks: modelDiagramDesign.referenceLinks,
        label: modelDiagramDesign.label,
        referenceNameFormat: modelDiagramDesign.referenceNameFormat,
        referenceRoleNameFormat: modelDiagramDesign.referenceRoleNameFormat,
        showAttributeDataType: modelDiagramDesign.showAttributeDataType,
        showInheritedAttributes: modelDiagramDesign.showInheritedAttributes,
        showInheritLinkName: modelDiagramDesign.showInheritLinkName,
        showReferenceCardinality: modelDiagramDesign.showReferenceCardinality,
        showReferenceName: modelDiagramDesign.showReferenceName,
        showReferenceRoles: modelDiagramDesign.showReferenceRoles
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/model_priv_grant/model_priv_grant_mapper.js
var require_model_priv_grant_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/model_priv_grant/model_priv_grant_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapModelPrivGrant = mapModelPrivGrant;
    function mapModelPrivGrant(modelPrivGrantDesign) {
      return {
        qualifiedName: modelPrivGrantDesign.__meta.qualifiedName,
        allowApiPublishingAsUser: modelPrivGrantDesign.allowApiPublishingAsUser,
        allowDataQualityDocumentation: modelPrivGrantDesign.allowDataQualityDocumentation,
        allowEnrichmentDocumentation: modelPrivGrantDesign.allowEnrichmentDocumentation,
        dataAdminRole: modelPrivGrantDesign.dataAdminRole,
        description: modelPrivGrantDesign.description,
        integrationWsRole: modelPrivGrantDesign.integrationWsRole,
        label: modelPrivGrantDesign.label,
        roleName: modelPrivGrantDesign.roleName,
        entityPrivGrants: modelPrivGrantDesign.entityPrivGrants ? modelPrivGrantDesign.entityPrivGrants.map((entityPrivGrantDesign) => mapEntityPrivGrant(entityPrivGrantDesign)) : void 0
      };
    }
    function mapEntityPrivGrant(entityPrivGrantDesign) {
      return {
        qualifiedName: entityPrivGrantDesign.__meta.qualifiedName,
        entity: entityPrivGrantDesign.entity,
        attributePrivGrants: entityPrivGrantDesign.attributePrivGrants,
        checkoutAllowed: entityPrivGrantDesign.checkoutAllowed,
        createAllowed: entityPrivGrantDesign.createAllowed,
        defaultAccessType: entityPrivGrantDesign.defaultAccessType,
        deleteAllowed: entityPrivGrantDesign.deleteAllowed,
        description: entityPrivGrantDesign.description,
        exportAllowed: entityPrivGrantDesign.exportAllowed,
        filter: entityPrivGrantDesign.filter,
        removeAllowed: entityPrivGrantDesign.removeAllowed
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/model_variable/model_variable_mapper.js
var require_model_variable_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/model_variable/model_variable_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapModelEditionVariable = mapModelEditionVariable;
    function mapModelEditionVariable(modelVariableDesign) {
      return {
        qualifiedName: modelVariableDesign.__meta.qualifiedName,
        onErrorValue: modelVariableDesign.onErrorValue,
        providerName: modelVariableDesign.providerName,
        queryString: modelVariableDesign.queryString,
        type: modelVariableDesign.dataType,
        description: modelVariableDesign.description
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/named_query/named_query_mapper.js
var require_named_query_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/named_query/named_query_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapNamedQuery = mapNamedQuery;
    exports2.mapQueryParameter = mapQueryParameter;
    function mapNamedQuery(namedQueryDesign) {
      const queryObjects = namedQueryDesign.queryObjects ? namedQueryDesign.queryObjects.map((queryObjectDesign) => mapQueryObject(queryObjectDesign)) : void 0;
      const queryParameters = namedQueryDesign.queryParameters ? namedQueryDesign.queryParameters.map((queryParameterDesign) => mapQueryParameter(queryParameterDesign)) : void 0;
      return {
        qualifiedName: namedQueryDesign.__meta.qualifiedName,
        active: namedQueryDesign.active,
        rootQueryObject: namedQueryDesign.rootQueryObject,
        defaultLimit: namedQueryDesign.defaultLimit,
        description: namedQueryDesign.description,
        filter: namedQueryDesign.filter,
        sort: namedQueryDesign.sort,
        queryObjects,
        queryParameters
      };
    }
    function mapQueryObject(queryObjectDesign) {
      return {
        qualifiedName: queryObjectDesign.__meta.qualifiedName,
        entity: queryObjectDesign.entity,
        description: queryObjectDesign.description,
        objectProperties: queryObjectDesign.objectProperties ? queryObjectDesign.objectProperties.map((objectPropertyDesign) => mapObjectProperty(objectPropertyDesign)) : void 0
      };
    }
    function mapObjectProperty(objectPropertyDesign) {
      return {
        qualifiedName: objectPropertyDesign.__meta.qualifiedName,
        type: objectPropertyDesign.type,
        filter: objectPropertyDesign.filter,
        semQlExpression: objectPropertyDesign.semQlExpression,
        sort: objectPropertyDesign.sort,
        targetObject: objectPropertyDesign.targetObject
      };
    }
    function mapQueryParameter(queryParameterDesign) {
      return {
        qualifiedName: queryParameterDesign.__meta.qualifiedName,
        bindingName: queryParameterDesign.bindingName,
        mandatory: queryParameterDesign.mandatory,
        type: queryParameterDesign.dataType,
        defaultValue: queryParameterDesign.defaultValue
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/publisher/publisher_mapper.js
var require_publisher_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/publisher/publisher_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapPublisher = mapPublisher;
    function mapPublisher(publisherDesign) {
      return {
        qualifiedName: publisherDesign.__meta.qualifiedName,
        active: publisherDesign.active,
        code: publisherDesign.code,
        color: publisherDesign.color,
        description: publisherDesign.description,
        label: publisherDesign.label
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/reference/reference_mapper.js
var require_reference_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/reference/reference_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapReference = mapReference;
    function mapReference(referenceDesign) {
      return {
        qualifiedName: referenceDesign.__meta.qualifiedName,
        brokenValidationLabel: referenceDesign.brokenValidationLabel ?? "",
        deletePropagation: referenceDesign.deletePropagation,
        fromEntity: referenceDesign.fromEntity,
        fromRoleName: referenceDesign.fromRoleName,
        mandatoryValidationLabel: referenceDesign.mandatoryValidationLabel ?? "",
        oneToMany: referenceDesign.oneToMany ?? false,
        physicalName: referenceDesign.physicalName,
        splitDuplicatePropagation: referenceDesign.splitDuplicatePropagation ?? "NONE",
        toEntity: referenceDesign.toEntity,
        toRoleName: referenceDesign.toRoleName,
        toRolePhysicalName: referenceDesign.toRolePhysicalName,
        validationScope: referenceDesign.validationScope,
        description: referenceDesign.description,
        documentation: referenceDesign.documentation,
        fromNavigable: referenceDesign.fromNavigable,
        fromRoleDocumentation: referenceDesign.fromRoleDocumentation,
        fromRoleLabel: referenceDesign.fromRoleLabel,
        fromRolePluralLabel: referenceDesign.fromRolePluralLabel,
        label: referenceDesign.label,
        toNavigable: referenceDesign.toNavigable,
        toRoleDocumentation: referenceDesign.toRoleDocumentation,
        toRoleLabel: referenceDesign.toRoleLabel,
        foreignAttribute: referenceDesign.foreignAttribute ? mapForeignAttribute(referenceDesign.foreignAttribute) : void 0
      };
    }
    function mapForeignAttribute(foreignAttributeDesign) {
      return {
        qualifiedName: foreignAttributeDesign.__meta.qualifiedName,
        _type: foreignAttributeDesign._type,
        physicalName: foreignAttributeDesign.physicalName,
        description: foreignAttributeDesign.description,
        documentation: foreignAttributeDesign.documentation,
        entity: foreignAttributeDesign.entity,
        label: foreignAttributeDesign.label,
        searchable: foreignAttributeDesign.searchable
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/retention_policy/retention_policy_mapper.js
var require_retention_policy_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/retention_policy/retention_policy_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapRetentionPolicyDataHub = mapRetentionPolicyDataHub;
    exports2.mapEntityRetention = mapEntityRetention;
    function mapRetentionPolicyDataHub(dataRetentionPolicyDesign) {
      return {
        deletionsDuration: dataRetentionPolicyDesign.deletionsDuration,
        deletionsType: dataRetentionPolicyDesign.deletionsType,
        deletionsUnit: dataRetentionPolicyDesign.deletionsUnit,
        historyDuration: dataRetentionPolicyDesign.historyDuration,
        historyType: dataRetentionPolicyDesign.historyType,
        historyUnit: dataRetentionPolicyDesign.historyUnit,
        sourceDataDuration: dataRetentionPolicyDesign.sourceDataDuration,
        sourceDataType: dataRetentionPolicyDesign.sourceDataType,
        sourceDataUnit: dataRetentionPolicyDesign.sourceDataUnit,
        sourceErrorsDuration: dataRetentionPolicyDesign.sourceErrorsDuration,
        sourceErrorsType: dataRetentionPolicyDesign.sourceErrorsType,
        sourceErrorsUnit: dataRetentionPolicyDesign.sourceErrorsUnit,
        description: dataRetentionPolicyDesign.description,
        entityRetentions: dataRetentionPolicyDesign.entityRetentions ? dataRetentionPolicyDesign.entityRetentions.map((entityRetentionDesign) => mapEntityRetention(entityRetentionDesign)) : void 0
      };
    }
    function mapEntityRetention(entityRetentionDesign) {
      return {
        entity: entityRetentionDesign.entity,
        deletionsType: entityRetentionDesign.deletionsType,
        deletionsDuration: entityRetentionDesign.deletionsDuration,
        deletionsUnit: entityRetentionDesign.deletionsUnit,
        historyType: entityRetentionDesign.historyType,
        historyDuration: entityRetentionDesign.historyDuration,
        historyUnit: entityRetentionDesign.historyUnit,
        sourceDataType: entityRetentionDesign.sourceDataType,
        sourceDataDuration: entityRetentionDesign.sourceDataDuration,
        sourceDataUnit: entityRetentionDesign.sourceDataUnit,
        sourceErrorsType: entityRetentionDesign.sourceErrorsType,
        sourceErrorsDuration: entityRetentionDesign.sourceErrorsDuration,
        sourceErrorsUnit: entityRetentionDesign.sourceErrorsUnit,
        description: entityRetentionDesign.description,
        pluralLabel: entityRetentionDesign.pluralLabel
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/user_defined_type/user_defined_type_mapper.js
var require_user_defined_type_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/user_defined_type/user_defined_type_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapUserDefinedType = mapUserDefinedType;
    function mapUserDefinedType(userDefinedTypeDesign) {
      return {
        qualifiedName: userDefinedTypeDesign.__meta.qualifiedName,
        _type: userDefinedTypeDesign._type,
        builtInType: userDefinedTypeDesign.dataType,
        description: userDefinedTypeDesign.description,
        label: userDefinedTypeDesign.label,
        length: userDefinedTypeDesign.length,
        lengthModifiable: void 0,
        precision: userDefinedTypeDesign.precision,
        precisionModifiable: void 0,
        scale: userDefinedTypeDesign.scale,
        scaleModifiable: void 0
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/automation_mapper.js
var require_automation_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/automation_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapSendEmailAutomation = mapSendEmailAutomation;
    exports2.mapSetWorkflowMetadataAutomation = mapSetWorkflowMetadataAutomation;
    exports2.mapDeleteDataAutomation = mapDeleteDataAutomation;
    exports2.mapSubmitAutomation = mapSubmitAutomation;
    exports2.mapCallProcedureAutomation = mapCallProcedureAutomation;
    function mapGeneralsAutomationProperties(automationDesign) {
      return {
        qualifiedName: automationDesign.__meta.qualifiedName,
        _type: "Automation",
        label: automationDesign.label,
        position: automationDesign.position,
        transition: mapAutomationTransition(automationDesign.transition)
      };
    }
    function mapSendEmailAutomation(automationDesign) {
      const baseAutomationProps = mapGeneralsAutomationProperties(automationDesign);
      return {
        ...baseAutomationProps,
        contentType: automationDesign.contentType,
        failOnError: automationDesign.failOnError,
        recipientMaxCount: automationDesign.recipientMaxCount,
        application: automationDesign.application,
        body: automationDesign.body,
        icon: automationDesign.icon,
        replyTo: automationDesign.replyTo,
        senderName: automationDesign.senderName,
        subject: automationDesign.subject,
        type: "EMAIL",
        to: automationDesign.to ? automationDesign.to.map((emailRecipientSource) => mapEmailRecipientSource(emailRecipientSource)) : void 0,
        customParameters: automationDesign.customParameters ? automationDesign.customParameters.map((emailCustomParameter) => mapEmailCustomerParameter(emailCustomParameter)) : void 0
      };
    }
    function mapSetWorkflowMetadataAutomation(automationDesign) {
      const baseAutomationProps = mapGeneralsAutomationProperties(automationDesign);
      return {
        ...baseAutomationProps,
        workflowMetadataChanges: automationDesign.workflowMetadataChanges,
        type: "SET_WORKFLOW_METADATA"
      };
    }
    function mapDeleteDataAutomation(automationDesign) {
      const baseAutomationProps = mapGeneralsAutomationProperties(automationDesign);
      return {
        ...baseAutomationProps,
        deleteType: automationDesign.deleteType,
        conditionForDeletion: automationDesign.conditionForDeletion,
        deleteAuthorExpression: automationDesign.deleteAuthorExpression,
        rootEntity: automationDesign.rootEntity,
        type: "DELETE"
      };
    }
    function mapSubmitAutomation(automationDesign) {
      const baseAutomationProps = mapGeneralsAutomationProperties(automationDesign);
      return {
        ...baseAutomationProps,
        integrationJob: automationDesign.integrationJob,
        submitUserExpression: automationDesign.submitUserExpression,
        type: "SUBMIT"
      };
    }
    function mapCallProcedureAutomation(automationDesign) {
      const baseAutomationProps = mapGeneralsAutomationProperties(automationDesign);
      return {
        ...baseAutomationProps,
        procedureArguments: automationDesign.functionArguments.map((functionArguments) => mapProcedureArguments(functionArguments)),
        type: "CALL_DATABASE_PROCEDURE",
        procedureName: automationDesign._name
      };
    }
    function mapProcedureArguments(functionArguments) {
      return {
        name: functionArguments.argument,
        expression: functionArguments.expression
      };
    }
    function mapAutomationTransition(automationTransitionDesign) {
      return {
        qualifiedName: automationTransitionDesign.__meta.qualifiedName,
        _type: automationTransitionDesign._type,
        bendPoints: automationTransitionDesign.bendPoints,
        label: automationTransitionDesign.label,
        toStep: automationTransitionDesign.toStep
      };
    }
    function mapEmailCustomerParameter(emailCustomParameterDesign) {
      return {
        qualifiedName: emailCustomParameterDesign.__meta.qualifiedName,
        parameterType: emailCustomParameterDesign.parameterType,
        expression: emailCustomParameterDesign.expression,
        maxChipsPerRow: emailCustomParameterDesign.maxChipsPerRow,
        maxRecordCount: emailCustomParameterDesign.maxRecordCount,
        rootEntity: emailCustomParameterDesign.rootEntity
      };
    }
    function mapEmailRecipientSource(emailRecipientSourceDesign) {
      return {
        qualifiedName: emailRecipientSourceDesign.__meta.qualifiedName,
        sourceType: emailRecipientSourceDesign.sourceType,
        roleValue: emailRecipientSourceDesign.roleValue,
        semqlValue: emailRecipientSourceDesign.semqlValue
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/router_mapper.js
var require_router_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/router_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapRouter = mapRouter;
    function mapRouter(routerDesign) {
      return {
        qualifiedName: routerDesign.__meta.qualifiedName,
        _type: routerDesign._type,
        label: routerDesign.label,
        position: routerDesign.position,
        routes: routerDesign.routes.map((routeDesign) => mapRoute(routeDesign))
      };
    }
    function mapRoute(routeDesign) {
      return {
        qualifiedName: routeDesign.__meta.qualifiedName,
        _type: routeDesign._type,
        index: routeDesign.index,
        label: routeDesign.label,
        bendPoints: routeDesign.bendPoints,
        condition: routeDesign.condition,
        toStep: routeDesign.toStep
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/start_event_mapper.js
var require_start_event_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/start_event_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapStartFromCompleteBatchEvent = mapStartFromCompleteBatchEvent;
    exports2.mapStartFromEmptySelectionEvent = mapStartFromEmptySelectionEvent;
    exports2.mapStartFromSelectedParentEvent = mapStartFromSelectedParentEvent;
    exports2.mapStartFromSelectionEvent = mapStartFromSelectionEvent;
    exports2.mapStartEventTransition = mapStartEventTransition;
    function mapGeneralStartEventProperties(startEventDesign) {
      return {
        qualifiedName: startEventDesign.__meta.qualifiedName,
        _type: "StartEvent",
        defaultPriority: startEventDesign.defaultPriority,
        position: startEventDesign.position,
        label: startEventDesign.label,
        transition: mapStartEventTransition(startEventDesign.transition)
      };
    }
    function mapStartFromCompleteBatchEvent(startEventDesign) {
      const generalProperties = mapGeneralStartEventProperties(startEventDesign);
      return {
        ...generalProperties,
        startupContext: {
          contextType: "START_ON_JOB_COMPLETION",
          initiatedAs: startEventDesign.initiatedAs,
          integrationJob: startEventDesign.integrationJob,
          dataRecordOutputs: startEventDesign.dataRecordOutputs ? startEventDesign.dataRecordOutputs.map((dataRecordOutputDesign) => mapDataRecordOutput(dataRecordOutputDesign)) : void 0
        }
      };
    }
    function mapStartFromEmptySelectionEvent(startEventDesign) {
      const generalProperties = mapGeneralStartEventProperties(startEventDesign);
      return {
        ...generalProperties,
        initiatorRequiredRole: startEventDesign.initiatorRequiredRole,
        startupParameters: startEventDesign.startupParameters,
        startupContext: {
          contextType: "START_FROM_NOTHING"
        }
      };
    }
    function mapStartFromSelectedParentEvent(startEventDesign) {
      const generalProperties = mapGeneralStartEventProperties(startEventDesign);
      return {
        ...generalProperties,
        initiatorRequiredRole: startEventDesign.initiatorRequiredRole,
        startupParameters: startEventDesign.startupParameters,
        startupContext: {
          contextType: "START_FROM_PARENT",
          selectionSourceType: startEventDesign.selectionSourceType,
          authoredEntity: startEventDesign.authoredEntity,
          referenceToParent: startEventDesign.referenceToParent
        }
      };
    }
    function mapStartFromSelectionEvent(startEventDesign) {
      const generalProperties = mapGeneralStartEventProperties(startEventDesign);
      return {
        ...generalProperties,
        startupContext: {
          contextType: "START_FROM_SELECTION",
          selectionSourceType: startEventDesign.selectionSourceType,
          authoredEntity: startEventDesign.authoredEntity,
          conditionOnSelection: startEventDesign.conditionOnSelection
        },
        initiatorRequiredRole: startEventDesign.initiatorRequiredRole,
        startupParameters: startEventDesign.startupParameters
      };
    }
    function mapStartEventTransition(startEventTransitionDesign) {
      return {
        qualifiedName: startEventTransitionDesign.__meta.qualifiedName,
        _type: startEventTransitionDesign._type,
        bendPoints: startEventTransitionDesign.bendPoints,
        toStep: startEventTransitionDesign.toStep
      };
    }
    function mapDataRecordOutput(dataRecordOutputDesign) {
      return {
        qualifiedName: dataRecordOutputDesign.__meta.qualifiedName,
        dataRecordSourceType: dataRecordOutputDesign.dataRecordSourceType,
        rootEntity: dataRecordOutputDesign.rootEntity,
        conditionOnDataRecord: dataRecordOutputDesign.conditionOnDataRecord
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/user_task_mapper.js
var require_user_task_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/user_task_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapUserTask = mapUserTask;
    var memory_1 = require_memory();
    function mapUserTask(userTaskDesign, modelElementQueries) {
      return {
        qualifiedName: userTaskDesign.__meta.qualifiedName,
        _type: userTaskDesign._type,
        assigneeCanRelease: userTaskDesign.assigneeCanRelease,
        notificationsOnTaskAssignment: userTaskDesign.notificationsOnTaskAssignment,
        notificationsOnTaskExpiration: userTaskDesign.notificationsOnTaskExpiration,
        notificationsOnWorkflowDueDate: userTaskDesign.notificationsOnWorkflowDueDate,
        label: userTaskDesign.label,
        myTasksConfiguration: userTaskDesign.myTasksConfiguration,
        position: userTaskDesign.position,
        taskType: userTaskDesign.taskType,
        application: userTaskDesign.application,
        assigneeCondition: userTaskDesign.assigneeCondition,
        assigneeRequiredRole: userTaskDesign.assigneeRequiredRole,
        entity: userTaskDesign.entity,
        icon: userTaskDesign.icon,
        stepper: userTaskDesign.stepper,
        transitions: userTaskDesign.transitions ? userTaskDesign.transitions.map((userTaskTransitionDesign) => mapUserTaskTransition(userTaskTransitionDesign, modelElementQueries, userTaskDesign.entity)) : void 0
      };
    }
    function mapUserTaskTransition(userTaskTransitionDesign, modelElementQueries, userTaskEntity) {
      const baseTransition = {
        qualifiedName: userTaskTransitionDesign.__meta.qualifiedName,
        _type: userTaskTransitionDesign._type,
        behaviorOnTransition: userTaskTransitionDesign.behaviorOnTransition,
        label: userTaskTransitionDesign.label,
        showWaitDialog: userTaskTransitionDesign.showWaitDialog,
        transitionParameters: userTaskTransitionDesign.transitionParameters,
        userTaskCompletionRequired: userTaskTransitionDesign.userTaskCompletionRequired,
        bendPoints: userTaskTransitionDesign.bendPoints,
        icon: userTaskTransitionDesign.icon,
        requiredRole: userTaskTransitionDesign.requiredRole,
        toStep: userTaskTransitionDesign.toStep
      };
      return {
        ...baseTransition,
        validations: userTaskTransitionDesign.transitionValidations ? userTaskTransitionDesign.transitionValidations.map((transitionValidation) => mapUserTaskTransitionValidations(transitionValidation, modelElementQueries, userTaskEntity)) : []
      };
    }
    function mapUserTaskTransitionValidations(transitionValidations, modelElementQueries, userTaskEntity) {
      switch (transitionValidations.validationType) {
        case "PLUGIN": {
          return {
            _type: "UserTaskTransitionValidation",
            type: transitionValidations.validationType,
            validationBehavior: transitionValidations.onTransitionFinish,
            validator: transitionValidations.validator
          };
        }
        case "CHECK": {
          return {
            _type: "UserTaskTransitionValidation",
            validationBehavior: transitionValidations.onTransitionFinish,
            validator: transitionValidations.validator,
            type: transitionValidations.validationType
          };
        }
        case "DETECT_DUPS": {
          const getDetectDupsInfo = () => {
            if (!userTaskEntity) {
              return { constraintName: "" };
            }
            const entity = modelElementQueries.findByQualifiedName(userTaskEntity, memory_1.TOP_LEVEL_ENUM.MODEL_ENTITY).match;
            return {
              constraintName: entity?.matcher?.__meta.qualifiedName || ""
            };
          };
          const { constraintName } = getDetectDupsInfo();
          return {
            _type: "UserTaskTransitionValidation",
            validationBehavior: transitionValidations.onTransitionFinish,
            type: transitionValidations.validationType,
            matcher: constraintName
          };
        }
        case "UNIQUE": {
          return {
            _type: "UserTaskTransitionValidation",
            validationBehavior: transitionValidations.onTransitionFinish,
            uniqueKey: transitionValidations.uniqueKey,
            type: transitionValidations.validationType
          };
        }
        case "MANDATORY":
        case "LOV":
        case "FOREIGN": {
          return {
            _type: "UserTaskTransitionValidation",
            validationBehavior: transitionValidations.onTransitionFinish,
            type: transitionValidations.validationType,
            attribute: transitionValidations.attribute
          };
        }
      }
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/parallel_block_mapper.js
var require_parallel_block_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/parallel_block_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapParallelBlock = mapParallelBlock;
    var router_mapper_1 = require_router_mapper();
    var start_event_mapper_1 = require_start_event_mapper();
    var user_task_mapper_1 = require_user_task_mapper();
    var automation_mapper_1 = require_automation_mapper();
    function mapParallelBlock(parallelBlockDesign, modelElementQueries) {
      return {
        qualifiedName: parallelBlockDesign.__meta.qualifiedName,
        _type: parallelBlockDesign._type,
        label: parallelBlockDesign.label,
        position: parallelBlockDesign.position,
        branches: parallelBlockDesign.branches.filter((branch) => branch.steps.every((step) => step._type !== "CallProcedureAutomation")).map((branchDesign) => mapBranch(branchDesign, modelElementQueries)),
        transition: mapParallelBlockTransition(parallelBlockDesign.transition)
      };
    }
    function mapBranch(branchDesign, modelElementQueries) {
      return {
        qualifiedName: branchDesign.__meta.qualifiedName,
        index: branchDesign.index,
        label: branchDesign.label,
        icon: branchDesign.icon,
        steps: branchDesign.steps.map((stepDesign) => mapBranchStep(stepDesign, modelElementQueries))
      };
    }
    function mapBranchStep(branchStep, modelElementQueries) {
      switch (branchStep._type) {
        case "SubmitAutomation": {
          return (0, automation_mapper_1.mapSubmitAutomation)(branchStep);
        }
        case "SendEmailAutomation": {
          return (0, automation_mapper_1.mapSendEmailAutomation)(branchStep);
        }
        case "SetWorkflowMetadataAutomation": {
          return (0, automation_mapper_1.mapSetWorkflowMetadataAutomation)(branchStep);
        }
        case "DeleteDataAutomation": {
          return (0, automation_mapper_1.mapDeleteDataAutomation)(branchStep);
        }
        case "CallProcedureAutomation": {
          return (0, automation_mapper_1.mapCallProcedureAutomation)(branchStep);
        }
        case "BranchEndEvent": {
          return mapBranchEndEvent(branchStep);
        }
        case "BranchStartEvent": {
          return mapBranchStartEvent(branchStep);
        }
        case "Router": {
          return (0, router_mapper_1.mapRouter)(branchStep);
        }
        case "UserTask": {
          return (0, user_task_mapper_1.mapUserTask)(branchStep, modelElementQueries);
        }
      }
    }
    function mapBranchEndEvent(branchEndEventDesign) {
      return {
        qualifiedName: branchEndEventDesign.__meta.qualifiedName,
        _type: branchEndEventDesign._type,
        position: branchEndEventDesign.position
      };
    }
    function mapBranchStartEvent(branchStartEventDesign) {
      return {
        qualifiedName: branchStartEventDesign.__meta.qualifiedName,
        _type: branchStartEventDesign._type,
        position: branchStartEventDesign.position,
        transition: (0, start_event_mapper_1.mapStartEventTransition)(branchStartEventDesign.transition)
      };
    }
    function mapParallelBlockTransition(parallelBlockTransitionDesign) {
      return {
        qualifiedName: parallelBlockTransitionDesign.__meta.qualifiedName,
        _type: parallelBlockTransitionDesign._type,
        bendPoints: parallelBlockTransitionDesign.bendPoints,
        toStep: parallelBlockTransitionDesign.toStep
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/end_event_mapper.js
var require_end_event_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/end_event_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapEndEvent = mapEndEvent;
    function mapEndEvent(endEventDesign) {
      return {
        qualifiedName: endEventDesign.__meta.qualifiedName,
        _type: endEventDesign._type,
        position: endEventDesign.position
      };
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/step_mapper.js
var require_step_mapper2 = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/step_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapWorkflowStep = mapWorkflowStep;
    var automation_mapper_1 = require_automation_mapper();
    var parallel_block_mapper_1 = require_parallel_block_mapper();
    var end_event_mapper_1 = require_end_event_mapper();
    var router_mapper_1 = require_router_mapper();
    var start_event_mapper_1 = require_start_event_mapper();
    var user_task_mapper_1 = require_user_task_mapper();
    function mapWorkflowStep(stepDesign, modelElementQueries) {
      switch (stepDesign._type) {
        case "SubmitAutomation": {
          return (0, automation_mapper_1.mapSubmitAutomation)(stepDesign);
        }
        case "SendEmailAutomation": {
          return (0, automation_mapper_1.mapSendEmailAutomation)(stepDesign);
        }
        case "SetWorkflowMetadataAutomation": {
          return (0, automation_mapper_1.mapSetWorkflowMetadataAutomation)(stepDesign);
        }
        case "DeleteDataAutomation": {
          return (0, automation_mapper_1.mapDeleteDataAutomation)(stepDesign);
        }
        case "CallProcedureAutomation": {
          return (0, automation_mapper_1.mapCallProcedureAutomation)(stepDesign);
        }
        case "EndEvent": {
          return (0, end_event_mapper_1.mapEndEvent)(stepDesign);
        }
        case "ParallelBlock": {
          return (0, parallel_block_mapper_1.mapParallelBlock)(stepDesign, modelElementQueries);
        }
        case "Router": {
          return (0, router_mapper_1.mapRouter)(stepDesign);
        }
        case "StartFromCompleteBatchEvent": {
          return (0, start_event_mapper_1.mapStartFromCompleteBatchEvent)(stepDesign);
        }
        case "StartFromEmptySelectionEvent": {
          return (0, start_event_mapper_1.mapStartFromEmptySelectionEvent)(stepDesign);
        }
        case "StartFromSelectedParentEvent": {
          return (0, start_event_mapper_1.mapStartFromSelectedParentEvent)(stepDesign);
        }
        case "StartFromSelectionEvent": {
          return (0, start_event_mapper_1.mapStartFromSelectionEvent)(stepDesign);
        }
        case "UserTask": {
          return (0, user_task_mapper_1.mapUserTask)(stepDesign, modelElementQueries);
        }
      }
    }
  }
});

// ../../packages/xdm-schema/out/mapper/workflow/workflow_mapper.js
var require_workflow_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/workflow/workflow_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapWorkflow = mapWorkflow;
    exports2.mapRootEntity = mapRootEntity;
    var step_mapper_1 = require_step_mapper2();
    var memory_1 = require_memory();
    function mapWorkflow(workflowDesign, modelElementQueries) {
      return {
        qualifiedName: workflowDesign.__meta.qualifiedName,
        generalProperties: workflowDesign.generalProperties,
        label: workflowDesign.label,
        retentionPolicy: workflowDesign.retentionPolicy,
        workflowAdminRole: workflowDesign.workflowAdminRole,
        rootEntities: workflowDesign.dataScope.map((rootEntityDesign) => mapRootEntity(rootEntityDesign, modelElementQueries)),
        notifications: workflowDesign.notifications,
        steps: workflowDesign.steps.map((stepDesign) => {
          return (0, step_mapper_1.mapWorkflowStep)(stepDesign, modelElementQueries);
        })
      };
    }
    function mapRootEntity(rootEntityDesign, modelElementQueries) {
      return {
        qualifiedName: rootEntityDesign.__meta.qualifiedName,
        cardinality: rootEntityDesign.cardinality,
        entity: rootEntityDesign.entity,
        semQLAlias: rootEntityDesign._name,
        childEntities: rootEntityDesign.childEntities ? rootEntityDesign.childEntities.map((childEntity) => mapChildEntity(childEntity, modelElementQueries)) : [],
        displayCard: rootEntityDesign.displayCard
      };
      function mapChildEntity(childEntity, modelElementQueries2) {
        const reference = modelElementQueries2.findByQualifiedName(childEntity.ref, memory_1.TOP_LEVEL_ENUM.MODEL_REFERENCE).match;
        const mapped = {
          roleName: reference?.fromRoleName ?? ""
        };
        let mappedChildren = [];
        if (childEntity.childEntities) {
          mappedChildren = childEntity.childEntities.map((child) => mapChildEntity(child, modelElementQueries2)).filter(Boolean);
        }
        mapped.childEntities = mappedChildren;
        return mapped;
      }
    }
  }
});

// ../../packages/xdm-schema/out/metamodel-version.js
var require_metamodel_version = __commonJS({
  "../../packages/xdm-schema/out/metamodel-version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PAYLOAD_VERSION = exports2.DESIGN_VERSION = void 0;
    exports2.DESIGN_VERSION = "1.0.0";
    exports2.PAYLOAD_VERSION = "1.1.0";
  }
});

// ../../packages/xdm-schema/out/mapper/datahub_model_mapper.js
var require_datahub_model_mapper = __commonJS({
  "../../packages/xdm-schema/out/mapper/datahub_model_mapper.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mapDataHubModel = mapDataHubModel;
    var application_mapper_1 = require_application_mapper();
    var complex_type_mapper_1 = require_complex_type_mapper();
    var db_function_mapper_1 = require_db_function_mapper();
    var db_view_mapper_1 = require_db_view_mapper();
    var enricher_cache_mapper_1 = require_enricher_cache_mapper();
    var entity_mapper_1 = require_entity_mapper();
    var top_level_1 = require_top_level();
    var job_mapper_1 = require_job_mapper();
    var list_of_value_mapper_1 = require_list_of_value_mapper();
    var model_diagram_mapper_1 = require_model_diagram_mapper();
    var model_priv_grant_mapper_1 = require_model_priv_grant_mapper();
    var model_variable_mapper_1 = require_model_variable_mapper();
    var named_query_mapper_1 = require_named_query_mapper();
    var publisher_mapper_1 = require_publisher_mapper();
    var reference_mapper_1 = require_reference_mapper();
    var retention_policy_mapper_1 = require_retention_policy_mapper();
    var user_defined_type_mapper_1 = require_user_defined_type_mapper();
    var workflow_mapper_1 = require_workflow_mapper();
    var metamodel_version_1 = require_metamodel_version();
    function mapDataHubModel(modelDesign, modelElementQueries) {
      const userDefinedTypes = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_USER_DEFINED_TYPE).map((userDefinedTypeDesign) => (0, user_defined_type_mapper_1.mapUserDefinedType)(userDefinedTypeDesign));
      const publishers = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_PUBLISHER).map((publisherDesign) => (0, publisher_mapper_1.mapPublisher)(publisherDesign));
      const sqlFunctions = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_SQL_FUNCTION).map((sqlFunctionDesign) => (0, db_function_mapper_1.mapSqlFunction)(sqlFunctionDesign));
      const lovTypes = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_LOV_TYPE).map((lovTypeDesign) => (0, list_of_value_mapper_1.mapLovType)(lovTypeDesign));
      const complexTypes = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_COMPLEX_TYPE).map((complexTypeDesign) => (0, complex_type_mapper_1.mapComplexType)(complexTypeDesign));
      const entities = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_ENTITY).map((entityDesign) => (0, entity_mapper_1.mapEntity)(entityDesign, modelElementQueries));
      const enricherCaches = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_ENRICHER_CACHE).map((enricherCacheDesign) => (0, enricher_cache_mapper_1.mapEnricherCache)(enricherCacheDesign));
      const referenceRels = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_REFERENCE).map((referenceDesign) => (0, reference_mapper_1.mapReference)(referenceDesign));
      const databaseViews = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_DATABASE_VIEW).map((databaseViewDesign) => (0, db_view_mapper_1.mapDatabaseView)(databaseViewDesign));
      const optionalDesignRetentionPolicy = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_RETENTION_POLICY).map((retentionPolicyDesign) => retentionPolicyDesign).find(() => true);
      const retentionPolicy = optionalDesignRetentionPolicy ? (0, retention_policy_mapper_1.mapRetentionPolicyDataHub)(optionalDesignRetentionPolicy) : void 0;
      const modelJobs = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_JOB).map((modelJobDesign) => (0, job_mapper_1.mapModelJob)(modelJobDesign));
      const modelDiagrams = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_DIAGRAM).map((modelDiagramDesign) => (0, model_diagram_mapper_1.mapModelDiagram)(modelDiagramDesign));
      const workflows = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_WORKFLOW).map((workflowDesign) => (0, workflow_mapper_1.mapWorkflow)(workflowDesign, modelElementQueries));
      const applications = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_APPLICATION).map((application) => (0, application_mapper_1.mapApplication)(application, modelElementQueries));
      const modelEditionVariables = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_VARIABLE).map((modelVariableDesign) => (0, model_variable_mapper_1.mapModelEditionVariable)(modelVariableDesign));
      const modelPrivGrants = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_PRIV_GRANT).map((modelPrivGrantDesign) => (0, model_priv_grant_mapper_1.mapModelPrivGrant)(modelPrivGrantDesign));
      const namedQueries = modelElementQueries.findAllByType(top_level_1.TOP_LEVEL_ENUM.MODEL_NAMED_QUERY).map((namedQueryDesign) => (0, named_query_mapper_1.mapNamedQuery)(namedQueryDesign));
      return {
        dataHubModelSchemaVersion: metamodel_version_1.PAYLOAD_VERSION,
        dataHubModel: {
          qualifiedName: `${modelDesign._name}`,
          description: modelDesign.description,
          label: modelDesign.label,
          modelConfiguration: modelDesign.modelConfiguration,
          retentionPolicy,
          applications,
          complexTypes,
          sqlFunctions,
          databaseViews,
          enricherCaches,
          lovTypes,
          modelDiagrams,
          modelEditionVariables,
          modelJobs,
          modelPrivGrants,
          namedQueries,
          publishers,
          referenceRels,
          userDefinedTypes,
          workflows,
          entities
        }
      };
    }
  }
});

// ../../packages/xdm-schema/out/schema/Model.json
var require_Model = __commonJS({
  "../../packages/xdm-schema/out/schema/Model.json"(exports2, module2) {
    module2.exports = {
      description: "Top level class that represents a model",
      $schema: "http://json-schema.org/draft-07/schema#",
      additionalProperties: false,
      definitions: {
        DatabaseType: {
          anyOf: [
            {
              description: "Oracle Database",
              const: "ORACLE",
              type: "string"
            },
            {
              description: "Postgres Database",
              const: "POSTGRESQL",
              type: "string"
            },
            {
              description: "Microsoft SQL Server Database",
              const: "SQLSERVER",
              type: "string"
            },
            {
              description: "Snowflake Database",
              const: "SNOWFLAKE",
              type: "string"
            },
            {
              description: "Unknown Database",
              const: "UNKNOWN",
              type: "string"
            }
          ]
        },
        ModelConfiguration: {
          description: "Defines model configuration",
          additionalProperties: false,
          properties: {
            type: {
              description: "Indicates target database type",
              $ref: "#/definitions/DatabaseType"
            }
          },
          required: [
            "type"
          ],
          type: "object"
        }
      },
      properties: {
        _package: {
          type: "string"
        },
        _type: {
          const: "Model",
          type: "string"
        },
        _name: {
          maxLength: 128,
          pattern: "^[a-zA-Z][a-zA-Z_0-9]*$",
          type: "string"
        },
        label: {
          description: "Label of the object. Used as business-friendly name",
          type: "string"
        },
        description: {
          description: "Description of the object",
          type: "string"
        },
        modelConfiguration: {
          $ref: "#/definitions/ModelConfiguration"
        }
      },
      required: [
        "_name",
        "_package",
        "_type"
      ],
      type: "object"
    };
  }
});

// ../../packages/xdm-schema/out/schema/Application.json
var require_Application = __commonJS({
  "../../packages/xdm-schema/out/schema/Application.json"(exports2, module2) {
    module2.exports = {
      description: "A Master Data Application Definition",
      $schema: "http://json-schema.org/draft-07/schema#",
      additionalProperties: false,
      definitions: {
        ActionDashboardParameter: {
          description: "Define a dasboard parameter override.",
          additionalProperties: false,
          properties: {
            _type: {
              const: "ActionDashboardParameter",
              type: "string"
            },
            _name: {
              maxLength: 128,
              pattern: "^[a-zA-Z][a-zA-Z_0-9]*$",
              type: "string"
            },
            value: {
              description: "Display property value",
              type: "string"
            },
            valueInterpreter: {
              description: "How to interpret Value",
              $ref: "#/definitions/PropertyValueInterpreter"
            }
          },
          required: [
            "_name",
            "_type",
            "value",
            "valueInterpreter"
          ],
          type: "object"
        },
        ApplicationSortStrategy: {
          anyOf: [
            {
              description: "Sort by label",
              const: "LABEL",
              type: "string"
            },
            {
              description: "Sort by position",
              const: "POSITION",
              type: "string"
            }
          ]
        },
        BrowseBusinessViewAction: {
          description: "Open a business view.",
          additionalProperties: false,
          properties: {
            _type: {
              const: "BrowseBusinessViewAction",
              type: "string"
            },
            _name: {
              maxLength: 128,
              pattern: "^[a-zA-Z][a-zA-Z_0-9]*$",
              type: "string"
            },
            label: {
              description: "Label of the object. Used as business-friendly name",
              type: "string"
            },
            description: {
              description: "Description of the object",
              type: "string"
            },
            appliedFilter: {
              type: "string"
            },
            businessView: {
              type: "string"
            },
            businessViewIconOverride: {
              description: "Icon overriding the business view root plural Icon",
              type: "string"
            },
            businessViewLabelOverride: {
              description: "Label overriding the business view label",
              type: "string"
            },
            businessViewRootLabelOverride: {
              description: "Label overriding the business view root label",
              type: "string"
            },
            businessViewRootPluralLabelOverride: {
              description: "Label overriding the business view root plural label",
              type: "string"
            },
            icon: {
              description: "Icon used when displayed in the navigation drawer.",
              type: "string"
            },
            iconColor: {
              description: "Color of the icon when displayed in the navigation drawer.",
              type: "string"
            },
            image: {
              description: "Image used when displayed in a folder.",
              type: "string"
            },
            imageAlign: {
              description: "Defines how the image is aligned.",
              $ref: "#/definitions/ImageAlign"
            },
            imageMode: {
              description: "Defines how the image is resized.",
              $ref: "#/definitions/ImageMode"
            },
            labelColor: {
              description: "Color of the label when displayed in the navigation drawer.",
              type: "string"
            },
            nbRecordsBadgeBackgroundColor: {
              description: "Background color of the record count badge",
              type: "string"
            },
            nbRecordsBadgeVisible: {
              description: "Select this option to show the number of records as a badge in the navigation drawer and on folder items.",
              default: false,
              type: "boolean"
            },
            requiredRole: {
              description: "Role required to access this folder or action. Leave empty for unrestricted access. The required role defined on a folder does not apply recursively to folders and actions contained in this folder.",
              type: "string"
            },
            useSearchOnOpen: {
              description: "Select to open the business view with a search panel.",
              default: false,
              type: "boolean"
            },
            viewType: {
              description: "Data accessed when browsing the Business View.",
              $ref: "#/definitions/ViewType"
            }
          },
          required: [
            "_name",
            "_type",
            "businessView",
            "nbRecordsBadgeVisible"
          ],
          title: "Browse Business View",
          type: "object"
        },
        BrowseEntitiesFolderAction: {
          description: "browse all entities and references with all fields visible",
          additionalProperties: false,
          properties: {
            _type: {
              const: "BrowseEntitiesFolderAction",
              type: "string"
            },
            _name: {
              maxLength: 128,
              pattern: "^[a-zA-Z][a-zA-Z_0-9]*$",
              type: "string"
            },
            label: {
              description: "Label of the object. Used as business-friendly name",
              type: "string"
            },
            description: {
              description: "Description of the object",
              type: "string"
            },
            icon: {
              description: "Icon used when displayed in the navigation drawer.",
              type: "string"
            },
            iconColor: {
              description: "Color of the icon when displayed in the navigation drawer.",
              type: "string"
            },
            image: {
              description: "Image used when displayed in a folder.",
              type: "string"
            },
            imageAlign: {
              description: "Defines how the image is aligned.",
              $ref: "#/definitions/ImageAlign"
            },
            imageMode: {
              description: "Defines how the image is resized.",
              $ref: "#/definitions/ImageMode"
            },
            labelColor: {
              description: "Color of the label when displayed in the navigation drawer.",
              type: "string"
            },
            lineageEnabled: {
              description: "Enables the Lineage for this action",
              default: true,
              type: "boolean"
            },
            requiredRole: {
              description: "Role required to access this folder or action. Leave empty for unrestricted access. The required role defined on a folder does not apply recursively to folders and actions contained in this folder.",
              type: "string"
            }
          },
          required: [
            "_name",
            "_type",
            "lineageEnabled"
          ],
          title: "Browse Entities Folder",
          type: "object"
        },
        CreateDataAppAction: {
          description: "Create Data",
          additionalProperties: false,
          properties: {
            _type: {
              const: "CreateDataAppAction",
              type: "string"
            },
            _name: {
              maxLength: 128,
              pattern: "^[a-zA-Z][a-zA-Z_0-9]*$",
              type: "string"
            },
            label: {
              description: "Label of the object. Used as business-friendly name",
              type: "string"
            },
            description: {
              description: "Description of the object",
              type: "string"
            },
            createAction: {
              type: "string"
            },
            icon: {
              description: "Icon used when displayed in the navigation drawer.",
              type: "string"
            },
            iconColor: {
              description: "Color of the icon when displayed in the navigation drawer.",
              type: "string"
            },
            image: {
              description: "Image used when displayed in a folder.",
              type: "string"
            },
            imageAlign: {
              description: "Defines how the image is aligned.",
              $ref: "#/definitions/ImageAlign"
            },
            imageMode: {
              description: "Defines how the image is resized.",
              $ref: "#/definitions/ImageMode"
            },
            labelColor: {
              description: "Color of the label when displayed in the navigation drawer.",
              type: "string"
            },
            requiredRole: {
              description: "Role required to access this folder or action. Leave empty for unrestricted access. The required role defined on a folder does not apply recursively to folders and actions contained in this folder.",
              type: "string"
            }
          },
          required: [
            "_name",
            "_type",
            "createAction"
          ],
          title: "Create Data",
          type: "object"
        },
        DocumentationConfig: {
          description: "Configuration of the application model documentation",
          additionalProperties: false,
          properties: {
            documentation: {
              description: "Documentation page contents. Markdown syntax is supported.",
              type: "string"
            },
            documentationConfigDiagrams: {
              items: {
                $ref: "#/definitions/DocumentationConfigDiagram"
              },
              type: "array"
            }
          },
          type: "object"
        },
        DocumentationConfigDiagram: {
          description: "A model diagram that appears in the application documentation.",
          additionalProperties: false,
          properties: {
            _type: {
              const: "DocumentationConfigDiagram",
              type: "string"
            },
            _name: {
              maxLength: 128,
              pattern: "^[a-zA-Z][a-zA-Z_0-9]*$",
              type: "string"
            },
            label: {
              description: "Label of the object. Used as business-friendly name",
              type: "string"
            },
            modelDiagram: {
              type: "string"
            }
          },
          required: [
            "_name",
            "_type",
            "modelDiagram"
          ],
          type: "object"
        },
        FolderAction: {
          description: "Application folders organize actions in the application.",
          additionalProperties: false,
          properties: {
            _type: {
              const: "FolderAction",
              type: "string"
            },
            _name: {
              maxLength: 128,
              pattern: "^[a-zA-Z][a-zA-Z_0-9]*$",
              type: "string"
            },
            label: {
              description: "Label of the object. Used as business-friendly name",
              type: "string"
            },
            description: {
              description: "Description of the object",
              type: "string"
            },
            appActions: {
              items: {
                anyOf: [
                  {
                    $ref: "#/definitions/BrowseBusinessViewAction"
                  },
                  {
                    $ref: "#/definitions/BrowseEntitiesFolderAction"
                  },
                  {
                    $ref: "#/definitions/CreateDataAppAction"
                  },
                  {
                    $ref: "#/definitions/FolderAction"
                  },
                  {
                    $ref: "#/definitions/GlobalSearchAction"
                  },
                  {
                    $ref: "#/definitions/ImportDataAppAction"
                  },
                  {
                    $ref: "#/definitions/MyTasksAction"
                  },
                  