# Help

```
Command Line Interface to operate the Semarchy Data Platform.

Usage:
  sem [flags]
  sem [command]

Available Commands:
  auth        Authenticate to the Semarchy Data Platform
  completion  Generate the autocompletion script for the specified shell
  dg          DG commands
  dm          DM commands
  help        Help about any command
  help-full   Print the full help
  logs        Get the logs
  profiles    List all profiles
  version     Print the CLI version

Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem [command] --help" for more information about a command.

========================================================

Authenticate to the Semarchy Data Platform

Usage:
  sem auth [flags]
  sem auth [command]

Available Commands:
  login       Log in to the Semarchy Data Platform
  logout      Log out from the Semarchy Data Platform
  token       Provide an access token

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem auth [command] --help" for more information about a command.

========================================================

Log in to the Semarchy Data Platform

Usage:
  sem auth login [url] [flags]

Flags:
      --api-key string    API Key (default: $SEM_API_KEY)
      --password string   Password (default: $SEM_PASSWORD)
      --username string   Username (default: $SEM_USERNAME)

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Log out from the Semarchy Data Platform

Usage:
  sem auth logout [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Provide an access token that can be used to directly query the SDP REST API

Usage:
  sem auth token [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Commands associated with the Data Governance module.

Usage:
  sem dg [flags]
  sem dg [command]

Available Commands:
  harvest     Harvesting commands

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dg [command] --help" for more information about a command.

========================================================

Harvesting commands.

Usage:
  sem dg harvest [flags]
  sem dg harvest [command]

Available Commands:
  dm          Harvest a DM Data Location
  status      Get status of DG module harvesting

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dg harvest [command] --help" for more information about a command.

========================================================

Harvest a Data Management Data Location.

Usage:
  sem dg harvest dm [flags]

Flags:
      --data-location-name string   The name of the DM Data Location to harvest
      --dm-source-id string         The DM Source ID (UUID) to use for this command
      --include-tables              Include tables in harvesting
      --include-views               Include views in harvesting
      --profiling                   Perform profiling
      --profiling-table-only        Profile tables only
      --stateful-ingestion          Stateful ingestion required

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the status of harvesting performed by the Data Governance module.

Usage:
  sem dg harvest status [flags]

Flags:
      --urn string   Specify the URN of the harvest to check its status

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Commands associated with the Data Management module.

Usage:
  sem dm [flags]
  sem dm [command]

Available Commands:
  admin          DM Admin commands
  dashboards     DM Dashboard commands
  data-locations List all DM data locations
  probes         DM Probes commands
  workflows      DM Workflow commands

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm [command] --help" for more information about a command.

========================================================

Commands related to the Data Management module administration.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin [flags]
  sem dm admin [command]

Available Commands:
  api-keys                 Get all DM API key information
  datasources              Get all DM data source configurations
  execution-engine         Get DM execution engine status
  image-libraries          Get DM image libraries
  info                     Get DM information
  integration-batch-poller Get DM integration batch poller status
  job-definitions          Get all DM job definitions
  job-executions           Search for DM job executions
  license                  Get DM license information
  logging                  Get DM loggers configuration
  notification-servers     Get all DM notification server configurations
  plugin-bundles           Get all DM plugin information
  properties               Get all DM configuration properties
  repository               Get DM repository information
  rest-clients             Get all DM REST client configurations
  role-mapping             Get DM role mapping configuration
  roles                    Get all DM roles
  status                   Get DM status
  translations             Get all DM translations
  users                    Get all DM users
  variable-providers       Get all DM variable providers

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin [command] --help" for more information about a command.

========================================================

Retrieve information for all Data Management API keys.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin api-keys [flags]
  sem dm admin api-keys [command]

Aliases:
  api-keys, api-key

Available Commands:
  create      Create a DM API key
  delete      Delete a DM API key
  get         Get DM API key information
  set         Create or update a DM API key
  set-all     Replace all DM API keys

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin api-keys [command] --help" for more information about a command.

========================================================

Create a new Data Management API key.
The response will contain the generated API key, which should be saved.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin api-keys create [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Delete a specified Data Management API key.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin api-keys delete <key-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information for a specified Data Management API key.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin api-keys get <key-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management API key or update an existing one.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin api-keys set <key-name> [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all existing Data Management API keys with those provided in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin api-keys set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration of all Data Management data sources.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin datasources [flags]
  sem dm admin datasources [command]

Aliases:
  datasources, datasource

Available Commands:
  delete      Delete a DM data source
  get         Get DM data source configuration
  set         Create or update a DM data source
  set-all     Replace all DM data sources
  test        Test a DM data source
  update      Update a DM data source

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin datasources [command] --help" for more information about a command.

========================================================

Delete a specified Data Management data source (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin datasources delete <datasource-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration of a specified Data Management data source.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin datasources get <datasource-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management data source or update an existing one (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin datasources set <datasource-name> [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all existing Data Management data sources with those provided in the request (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin datasources set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Test a Data Management data source.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin datasources test <datasource-name> [flags]

Flags:
      --environment-id string   The environment ID to select the replica to test

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Update a Data Management data source with the provided configuration.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin datasources update <datasource-name> [flags]

Aliases:
  update, patch

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the Data Management execution engine status.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine [flags]
  sem dm admin execution-engine [command]

Available Commands:
  clusters    Get all DM execution engine clusters
  start       Start the DM execution engine
  stop        Stop the DM execution engine.

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin execution-engine [command] --help" for more information about a command.

========================================================

List all Data Management execution engine clusters.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters [flags]
  sem dm admin execution-engine clusters [command]

Aliases:
  clusters, cluster

Available Commands:
  get         Get a DM execution engine cluster
  queues      Get all DM execution engine cluster queues

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin execution-engine clusters [command] --help" for more information about a command.

========================================================

Get a Data Management execution engine cluster.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters get <cluster-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information on all Data Management execution engine cluster queues.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters queues [flags]
  sem dm admin execution-engine clusters queues [command]

Aliases:
  queues, queue

Available Commands:
  cancel                   Cancel a DM execution engine cluster queue
  disable-suspend-on-error Disable suspend on error for a DM execution engine cluster queue
  enable-suspend-on-error  Enable suspend on error for a DM execution engine cluster queue
  get                      Get a DM execution engine cluster queue
  resume                   Restart a DM execution engine cluster queue
  suspend                  Suspend a DM execution engine cluster queue

Flags:
      --cluster-name string   The cluster name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin execution-engine clusters queues [command] --help" for more information about a command.

========================================================

Cancel a Data Management execution engine cluster queue.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters queues cancel <queue-name> [flags]

Global Flags:
      --cluster-name string   The cluster name to use for this command
  -d, --debug                 Show debug information
      --force                 Ignore prompt and delete the specified resource
  -i, --input string          Use specified file instead of stdin
      --json                  Output as JSON
      --jsonr                 Output as raw JSON strings
  -o, --output string         Use specified file instead of stdout
      --path string           JSONPath used to extract a subset of the response
  -p, --profile string        Profile to use for this execution
      --read-only             Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Disable suspend on error for a Data Management execution engine cluster queue.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters queues disable-suspend-on-error <queue-name> [flags]

Global Flags:
      --cluster-name string   The cluster name to use for this command
  -d, --debug                 Show debug information
      --force                 Ignore prompt and delete the specified resource
  -i, --input string          Use specified file instead of stdin
      --json                  Output as JSON
      --jsonr                 Output as raw JSON strings
  -o, --output string         Use specified file instead of stdout
      --path string           JSONPath used to extract a subset of the response
  -p, --profile string        Profile to use for this execution
      --read-only             Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Enable suspend on error for a Data Management execution engine cluster queue.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters queues enable-suspend-on-error <queue-name> [flags]

Global Flags:
      --cluster-name string   The cluster name to use for this command
  -d, --debug                 Show debug information
      --force                 Ignore prompt and delete the specified resource
  -i, --input string          Use specified file instead of stdin
      --json                  Output as JSON
      --jsonr                 Output as raw JSON strings
  -o, --output string         Use specified file instead of stdout
      --path string           JSONPath used to extract a subset of the response
  -p, --profile string        Profile to use for this execution
      --read-only             Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information on a Data Management execution engine cluster queue.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters queues get <queue-name> [flags]

Global Flags:
      --cluster-name string   The cluster name to use for this command
  -d, --debug                 Show debug information
      --force                 Ignore prompt and delete the specified resource
  -i, --input string          Use specified file instead of stdin
      --json                  Output as JSON
      --jsonr                 Output as raw JSON strings
  -o, --output string         Use specified file instead of stdout
      --path string           JSONPath used to extract a subset of the response
  -p, --profile string        Profile to use for this execution
      --read-only             Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Restart a Data Management execution engine cluster queue.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters queues resume <queue-name> [flags]

Global Flags:
      --cluster-name string   The cluster name to use for this command
  -d, --debug                 Show debug information
      --force                 Ignore prompt and delete the specified resource
  -i, --input string          Use specified file instead of stdin
      --json                  Output as JSON
      --jsonr                 Output as raw JSON strings
  -o, --output string         Use specified file instead of stdout
      --path string           JSONPath used to extract a subset of the response
  -p, --profile string        Profile to use for this execution
      --read-only             Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Suspend a Data Management execution engine cluster queue.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine clusters queues suspend <queue-name> [flags]

Global Flags:
      --cluster-name string   The cluster name to use for this command
  -d, --debug                 Show debug information
      --force                 Ignore prompt and delete the specified resource
  -i, --input string          Use specified file instead of stdin
      --json                  Output as JSON
      --jsonr                 Output as raw JSON strings
  -o, --output string         Use specified file instead of stdout
      --path string           JSONPath used to extract a subset of the response
  -p, --profile string        Profile to use for this execution
      --read-only             Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Start the Data Management execution engine.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine start [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Stop the Data Management execution engine.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin execution-engine stop [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List Data Management image libraries


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin image-libraries [flags]
  sem dm admin image-libraries [command]

Aliases:
  image-libraries, image-library

Available Commands:
  export      Export a DM image library
  import      Import a DM image library

Flags:
      --include string   Include USER libraries (default), BUILTIN libraries, or ALL libraries

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin image-libraries [command] --help" for more information about a command.

========================================================

Export a specified Data Management image library as a ZIP archive.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin image-libraries export <library-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Import a specified Data Management image library from a ZIP archive, containing a folder named after the library.
Only this folder will be imported.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin image-libraries import <library-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information about the Data Management module


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin info [flags]

Aliases:
  info, information

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the Data Management integration batch poller status.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin integration-batch-poller [flags]
  sem dm admin integration-batch-poller [command]

Available Commands:
  configuration Get DM integration batch poller configuration
  start         Start the DM integration batch poller
  stop          Stop the DM integration batch poller

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin integration-batch-poller [command] --help" for more information about a command.

========================================================

Retrieve the Data Management integration batch poller configuration.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin integration-batch-poller configuration [flags]
  sem dm admin integration-batch-poller configuration [command]

Aliases:
  configuration, config

Available Commands:
  set         Set DM integration batch poller configuration

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin integration-batch-poller configuration [command] --help" for more information about a command.

========================================================

Set the Data Management integration batch poller configuration.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin integration-batch-poller configuration set [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Start the Data Management integration batch poller.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin integration-batch-poller start [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Stop the Data Management integration batch poller.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin integration-batch-poller stop [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information for all Data Management job definitions.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin job-definitions [flags]
  sem dm admin job-definitions [command]

Aliases:
  job-definitions, job-definition

Available Commands:
  get         Get a job definition

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin job-definitions [command] --help" for more information about a command.

========================================================

Retrieve information for a specified Data Management job definition.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin job-definitions get <uuid> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Search for Data Management job executions.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin job-executions [flags]
  sem dm admin job-executions [command]

Aliases:
  job-executions, job-execution

Available Commands:
  get         Get a job execution
  purge       Purge DM job executions

Flags:
      --batch-id stringArray     Filter by batch ID. This option can be used multiple times.
      --job-name stringArray     Filter by job name (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-owner stringArray    Filter by job owner (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-status stringArray   Filter by job status. This option can be used multiple times.
      --job-type stringArray     Filter by job type. This option can be used multiple times.
      --limit int                Maximum number of returned results
      --offset int               Offset of the first result
      --period string            Period to consider for the search. It is expressed with 'after | before <number> <time_unit>', where <time_unit> is one of execution, executions, second, seconds, minute, minutes, day, days, week, weeks, month, months.
      --sort string              Sort the results by the given fields. The syntax is a comma-separated list of fields, optionally followed by a column and 'asc' or 'desc' (default is 'asc'). Example: 'field1,field2:desc'.

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin job-executions [command] --help" for more information about a command.

========================================================

Retrieve information for a specified job execution.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin job-executions get <uuid> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Purge Data Management job executions.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin job-executions purge [flags]

Flags:
      --batch-id stringArray     Filter by batch ID. This option can be used multiple times.
      --job-name stringArray     Filter by job name (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-owner stringArray    Filter by job owner (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-status stringArray   Filter by job status. This option can be used multiple times.
      --job-type stringArray     Filter by job type. This option can be used multiple times.
      --period string            Period to consider for the purge. It is expressed with 'after | before <number> <time_unit>', where <time_unit> is one of execution, executions, second, seconds, minute, minutes, day, days, week, weeks, month, months.

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the Data Management license information (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin license [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the Data Management loggers configuration (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin logging [flags]
  sem dm admin logging [command]

Available Commands:
  reset       Replace DM loggers configuration
  set         Replace DM loggers configuration

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin logging [command] --help" for more information about a command.

========================================================

Replace the Data Management loggers configuration with its default value (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin logging reset [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace the Data Management loggers configuration (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin logging set [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve all Data Management notification server configurations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin notification-servers [flags]
  sem dm admin notification-servers [command]

Aliases:
  notification-servers, notification-server

Available Commands:
  delete      Delete a DM notification server
  get         Get a DM notification server configuration
  set         Create or update a DM notification server
  set-all     Replace all DM notification servers
  test        Test a DM notification server

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin notification-servers [command] --help" for more information about a command.

========================================================

Delete a specified Data Management notification server.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin notification-servers delete <notification-server-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration of a specified Data Management notification server.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin notification-servers get <notification-server-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management notification server or update an existing one.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin notification-servers set <notification-server-name> [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all Data Management notification servers with those provided in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin notification-servers set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Test a Data Management notification server.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin notification-servers test <notification-server-name> [flags]

Flags:
      --recipient stringArray   The recipient to use for the test

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information for all the Data Management plugins (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin plugin-bundles [flags]
  sem dm admin plugin-bundles [command]

Aliases:
  plugin-bundles, plugins, plugin, plugin-bundle

Available Commands:
  delete      Delete a DM plugin
  export      Export a DM plugin
  get         Get DM plugin information
  import      Import a DM plugin

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin plugin-bundles [command] --help" for more information about a command.

========================================================

Delete a specified Data Management plugin (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin plugin-bundles delete <plugin-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Export a Data Management plugin as a JAR file (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin plugin-bundles export <plugin-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information for a specified Data Management plugin (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin plugin-bundles get <plugin-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Import a provided JAR file as a Data Management plugin bundle (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin plugin-bundles import [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve all the Data Management configuration properties.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin properties [flags]
  sem dm admin properties [command]

Available Commands:
  set         Replace all DM configuration properties

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin properties [command] --help" for more information about a command.

========================================================

Replace all Data Management configuration properties with the ones provided in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin properties set [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve Data Management repository information (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin repository [flags]
  sem dm admin repository [command]

Available Commands:
  upgrade     Upgrade the DM repository

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin repository [command] --help" for more information about a command.

========================================================

Upgrade the Data Management repository (requires SYSTEM_ADMIN role).


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin repository upgrade [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all Data Management REST clients along their configurations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin rest-clients [flags]
  sem dm admin rest-clients [command]

Aliases:
  rest-clients, rest-client

Available Commands:
  delete      Delete a DM REST client
  get         Get a DM REST client
  set         Create or update a DM REST client
  set-all     Replace all DM REST clients
  test        Test a DM REST client

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin rest-clients [command] --help" for more information about a command.

========================================================

Delete a specified Data Management REST client.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin rest-clients delete <rest-client-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration of a specified Data Management REST client.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin rest-clients get <rest-client-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management REST client or update an existing client.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin rest-clients set <rest-client-name> [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all Data Management REST clients with the ones provided in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin rest-clients set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Test a Data Management REST client.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin rest-clients test <rest-client-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the Data Management role mapping configuration.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin role-mapping [flags]
  sem dm admin role-mapping [command]

Available Commands:
  set         Set DM role mapping configuration

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin role-mapping [command] --help" for more information about a command.

========================================================

Replace the Data Management role mapping configuration with the one provided in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin role-mapping set [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all defined roles in Data Management.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin roles [flags]
  sem dm admin roles [command]

Aliases:
  roles, role

Available Commands:
  delete      Delete a DM role
  get         Get a DM role
  set         Create or update a DM role
  set-all     Replace all DM roles

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin roles [command] --help" for more information about a command.

========================================================

Delete a specified Data Management role.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin roles delete <role-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information of a specified Data Management role.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin roles get <role-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a Data Management role or update an existing role.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin roles set <role-name> [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all defined roles in Data Management.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin roles set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the status of the Data Management module.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin status [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Export all Data Management translations to a ZIP file.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin translations [flags]
  sem dm admin translations [command]

Available Commands:
  set         Update DM translations

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin translations [command] --help" for more information about a command.

========================================================

Update Data Management translations using the provided ZIP file.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin translations set [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all Data Management user profiles and their preferences.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin users [flags]
  sem dm admin users [command]

Aliases:
  users, user

Available Commands:
  assign      Assign roles to user
  get         Get a DM user
  unassign    Unassign roles from user

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin users [command] --help" for more information about a command.

========================================================

Assign the specified Data Management roles to an existing user.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin users assign <user-name> <role-name> [<role-name>] [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the profile of a specified Data Management user.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin users get <user-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Unassign specified Data Management roles from an existing user.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin users unassign <user-name> <role-name> [<role-name>] [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all Data Management variable providers with their configurations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin variable-providers [flags]
  sem dm admin variable-providers [command]

Aliases:
  variable-providers, variable-provider

Available Commands:
  delete      Delete a DM variable provider
  get         Get a DM variable provider configuration
  set         Create or update a DM variable provider
  set-all     Replace all DM variable providers
  test        Test a DM variable provider

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm admin variable-providers [command] --help" for more information about a command.

========================================================

Delete a specified Data Management variable provider.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin variable-providers delete <provider-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration of a specified Data Management variable provider.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin variable-providers get <provider-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management variable provider or update an existing one.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin variable-providers set <provider-name> [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all Data Management variable providers with the ones provided in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin variable-providers set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Test a Data Management variable provider.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=admin

Usage:
  sem dm admin variable-providers test <provider-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Commands related to the Data Management dashboards.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=dashboard_builder

Usage:
  sem dm dashboards [flags]
  sem dm dashboards [command]

Aliases:
  dashboards, dashboard

Available Commands:
  applications Get all DM dashboard applications

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm dashboards [command] --help" for more information about a command.

========================================================

List all Data Management dashboard applications.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=dashboard_builder

Usage:
  sem dm dashboards applications [flags]
  sem dm dashboards applications [command]

Aliases:
  applications, application

Available Commands:
  delete      Delete a DM dashboard application
  export      Export a DM dashboard application
  get         Get a DM dashboard application
  import      Import a DM dashboard application
  set         Create or update a DM dashboard application

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm dashboards applications [command] --help" for more information about a command.

========================================================

Delete a specified Data Management dashboard application.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=dashboard_builder

Usage:
  sem dm dashboards applications delete <dashboard-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Export a Data Management dashboard application as a ZIP file.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=dashboard_builder

Usage:
  sem dm dashboards applications export <dashboard-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information for a specified Data Management dashboard application.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=dashboard_builder

Usage:
  sem dm dashboards applications get <dashboard-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Import and overwrite a Data Management dashboard application.
The application will be created if it does not already exist.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=dashboard_builder

Usage:
  sem dm dashboards applications import <dashboard-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management dashboard application or update an existing application.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=dashboard_builder

Usage:
  sem dm dashboards applications set <dashboard-name> [flags]

Aliases:
  set, replace

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all the Data Management data locations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations [flags]
  sem dm data-locations [command]

Aliases:
  data-locations, data-location

Available Commands:
  continuous-loads         Get all DM continuous loads at a data location
  data-notifications       Get all DM data notifications at a data location
  delete                   Delete a data location
  deployments              Get the deployment history of a Data Location
  get                      Get a data location
  integration-batches      Get all integration batches
  job-executions           Retrieve the job executions of a specific Data Location
  jobs                     Retrieve the jobs of a specific Data Location
  loads                    List all loads of a data location
  notification-policies    Get all DM notification policies at a data location
  purge-deployment-history Purge data location deployment history
  purge-jobs               Purge data location jobs
  purge-schedule           Get a data location purge schedule configuration
  set-status               Set the status of a data location
  upgrade                  Upgrade a DM data location (requires SYSTEM_ADMIN role)

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations [command] --help" for more information about a command.

========================================================

List all Data Management continuous loads at a data location, including their configurations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations continuous-loads [flags]
  sem dm data-locations continuous-loads [command]

Aliases:
  continuous-loads, continuous-load

Available Commands:
  delete      Delete a DM continuous load at a data location
  get         Get a DM continuous load at a data location
  set         Create or update a DM continuous load at a data location
  set-all     Replace all DM continuous loads at a data location

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations continuous-loads [command] --help" for more information about a command.

========================================================

Delete a specified Data Management continuous load at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations continuous-loads delete <load-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration for a specified Data Management continuous load at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations continuous-loads get <load-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management continuous load at a data location, or update an existing one.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations continuous-loads set <load-name> [flags]

Aliases:
  set, replace

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all Data Management continuous loads at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations continuous-loads set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all Data Management data notifications at a data location, including their configurations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications [flags]
  sem dm data-locations data-notifications [command]

Aliases:
  data-notifications, data-notification

Available Commands:
  delete      Delete a DM data notification at a data location
  get         Get a DM data notification at a data location
  kill        Kill a DM data notification at a data location
  logs        Get the logs of a data notification
  resume      Resume a DM data notification at a data location
  send        Send a data notification
  set         Create or update a DM data notification at a data location
  set-all     Replace all DM data notifications at a data location
  status      Get the status of a DM data notification at a data location

Flags:
      --data-location-name string   The Data Location name to use for this command
      --processing-status string    Filter by processing status

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations data-notifications [command] --help" for more information about a command.

========================================================

Delete a specified Data Management data notification at a data location


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications delete <data-notification-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration for a specified Data Management data notification at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications get <data-notification-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Terminate a specified running Data Management data notification at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications kill <data-notification-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Get the logs of a data notification


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications logs <data-notification-name> [flags]

Aliases:
  logs, log

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Resume a specified suspended Data Management data notification at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications resume <data-notification-name> [flags]

Flags:
      --pending-notifications-behavior string   The behavior to apply to pending notifications (SKIP or PROCESS_IN_ONE_BATCH). This flag is required.

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Send a data notification.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications send <data-notification-name> [flags]

Flags:
      --data-location-name string   The Data Location name to use for this command
      --high-batch-id int           The high batch ID to use for the notification
      --low-batch-id int            The low batch ID to use for the notification
      --timestamp string            The timestamp to use for the notification

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management data notification at a data location, or update an existing one.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications set <data-notification-name> [flags]

Aliases:
  set, replace

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all Data Management data notifications at a data location with those specified in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the status and runtime information for a specified Data Management data notification at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations data-notifications status <data-notification-name> [flags]

Aliases:
  status, get-status

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Delete a specified data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations delete <data-location-name> [flags]

Flags:
      --drop-schema string   Set to 'DROP' to remove the schema as well

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the deployment history of a specified Data Location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations deployments [flags]
  sem dm data-locations deployments [command]

Aliases:
  deployments, deployment

Available Commands:
  get         Get the deployment history of a Data Location by its identifier

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations deployments [command] --help" for more information about a command.

========================================================

Retrieve the deployment history of a specified Data Location by its identifier.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations deployments get <uuid> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve information about a specified data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations get <data-location-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve all integration batches for a Data Location


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations integration-batches [flags]
  sem dm data-locations integration-batches [command]

Aliases:
  integration-batches, integration-batch

Available Commands:
  get         Get an integration batch

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations integration-batches [command] --help" for more information about a command.

========================================================

Retrieve an integration batch by its identifier


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations integration-batches get <batch-id> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the job executions of a specific Data Location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations job-executions [flags]

Aliases:
  job-executions, job-execution

Flags:
      --batch-id stringArray        Filter by batch ID. This option can be used multiple times.
      --data-location-name string   The Data Location name to use for this command
      --job-name stringArray        Filter by job name (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-owner stringArray       Filter by job owner (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-status stringArray      Filter by job status. This option can be used multiple times.
      --job-type stringArray        Filter by job type. This option can be used multiple times.
      --limit int                   Maximum number of returned results
      --offset int                  Offset of the first result
      --period string               Period to consider for the search. It is expressed with 'after | before <number> <time_unit>', where <time_unit> is one of execution, executions, second, seconds, minute, minutes, day, days, week, weeks, month, months.
      --sort string                 Sort the results by the given fields. The syntax is a comma-separated list of fields, optionally followed by a column and 'asc' or 'desc' (default is 'asc'). Example: 'field1,field2:desc'.

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the jobs of a specific Data Location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations jobs [flags]

Aliases:
  jobs, job-definition

Flags:
      --data-location-name string   The Data Location name to use for this command
      --job-type stringArray        Filter by job type. This option can be used multiple times.

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all loads of a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations loads [flags]
  sem dm data-locations loads [command]

Aliases:
  loads, load

Available Commands:
  get         Get a load of a data location

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations loads [command] --help" for more information about a command.

========================================================

Get a load of a data location


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations loads get <load-id> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all Data Management notification policies at a data location, with their configurations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations notification-policies [flags]
  sem dm data-locations notification-policies [command]

Aliases:
  notification-policies, notification-policy

Available Commands:
  delete      Delete a DM notification policy at a data location
  get         Get a DM notification policy at a data location
  set         Create or update a DM notification policy at a data location
  set-all     Replace all DM notification policies at a data location
  test        Test a DM notification policy at a data location

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations notification-policies [command] --help" for more information about a command.

========================================================

Delete a specified Data Management notification policy at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations notification-policies delete <policy-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the configuration for a specified Data Management notification policy at a data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations notification-policies get <policy-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Create a new Data Management notification policy at a data location, or update an existing one.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations notification-policies set <policy-name> [flags]

Aliases:
  set, replace

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Replace all Data Management notification policies at a data location with those specified in the request.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations notification-policies set-all [flags]

Aliases:
  set-all, replace-all

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Test a Data Management notification policy at a data location.

Usage:
  sem dm data-locations notification-policies test <policy-name> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Purge data location deployment history.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations purge-deployment-history <data-location-name> [flags]

Flags:
      --max-deployment-date string   Maximum date of deployment history to delete
      --min-deployment-date string   Minimum date of deployment history to delete

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Purge data location jobs.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations purge-jobs <data-location-name> [flags]

Flags:
      --job-name stringArray     Filter by job name (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-owner stringArray    Filter by job owner (SQL-like syntax, using the _ and % wildcards). This option can be used multiple times.
      --job-status stringArray   Filter by job status. This option can be used multiple times.
      --job-type stringArray     Filter by job type. This option can be used multiple times.
      --period string            Period to consider for the purge. It is expressed with 'after | before <number> <time_unit>', where <time_unit> is one of execution, executions, second, seconds, minute, minutes, day, days, week, weeks, month, months

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve the purge schedule configuration for a specified data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations purge-schedule [flags]
  sem dm data-locations purge-schedule [command]

Available Commands:
  set         Configure a data location purge schedule

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm data-locations purge-schedule [command] --help" for more information about a command.

========================================================

Configure the purge schedule for a specified data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations purge-schedule set [flags]

Aliases:
  set, replace

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Change the status of a specified data location.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations set-status <data-location-name> <status> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Upgrade a specified Data Management data location (requires SYSTEM_ADMIN role)


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=data_locations

Usage:
  sem dm data-locations upgrade <data-location-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Commands related to the Data Management probes.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=probes

Usage:
  sem dm probes [flags]
  sem dm probes [command]

Aliases:
  probes, probe

Available Commands:
  data-locations DM probes for data locations
  started        Check if DM is started

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm probes [command] --help" for more information about a command.

========================================================

Data Management probes for data locations.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=probes

Usage:
  sem dm probes data-locations [flags]
  sem dm probes data-locations [command]

Aliases:
  data-locations, data-location

Available Commands:
  api          Check Data Location readiness
  applications Check Application readiness

Flags:
      --data-location-name string   The name of the Data Location to use for executing this command.

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm probes data-locations [command] --help" for more information about a command.

========================================================

Check if the Data Location is ready.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=probes

Usage:
  sem dm probes data-locations api [flags]

Global Flags:
      --data-location-name string   The name of the Data Location to use for executing this command.
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Check if the Application is ready.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=probes

Usage:
  sem dm probes data-locations applications <application-name> [flags]

Aliases:
  applications, application

Global Flags:
      --data-location-name string   The name of the Data Location to use for executing this command.
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Check if Data Management (DM) is started.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=probes

Usage:
  sem dm probes started [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Commands related to Data Management workflows.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows [flags]
  sem dm workflows [command]

Aliases:
  workflows, workflow

Available Commands:
  user-task-instances  Get DM user task instances
  workflow-definitions DM Workflow definitions commands
  workflow-instances   Get DM workflow instances

Flags:
      --data-location-name string   The Data Location name to use for this command

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm workflows [command] --help" for more information about a command.

========================================================

List all Data Management user task instances along with their details.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows user-task-instances [flags]
  sem dm workflows user-task-instances [command]

Aliases:
  user-task-instances, user-task-instance

Available Commands:
  assign             Assign a DM user task instance
  get                Get a DM user task instance
  refresh-candidates Recalculate the candidates of a DM user task instance
  release            Release a DM user task instance

Flags:
      --assignee string                   Limit results to user task instances assigned to this user
      --candidate string                  Limit results to user task instances having this candidate
      --limit int                         Maximum number of returned results
      --offset int                        Offset of the first result
      --order-by string                   SemQL order by clause defining the order of the records in the response
      --step-name string                  Limit results to user task instances having this step name
      --user-task-status string           Limit results to user task instances having this status
      --workflow-definition-name string   Limit results to user task instances of this workflow definition name
      --workflow-instance-id int          Limit results to user task instances of this workflow instance ID (default -1)

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm workflows user-task-instances [command] --help" for more information about a command.

========================================================

Assign a Data Management user task instance to a user.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows user-task-instances assign <instance-id> [flags]

Flags:
      --username string   The username to assign the task to

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retrieve details for a Data Management user task instance.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows user-task-instances get <instance-id> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Recalculate the candidates of a Data Management user task instance.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows user-task-instances refresh-candidates <instance-id> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Remove the assignee from a Data Management user task instance.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows user-task-instances release <instance-id> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Commands related to the Data Management workflow definitions.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows workflow-definitions [flags]
  sem dm workflows workflow-definitions [command]

Aliases:
  workflow-definitions, workflow-definition

Available Commands:
  start       Start a workflow

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm workflows workflow-definitions [command] --help" for more information about a command.

========================================================

Start a workflow.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows workflow-definitions start <workflow-definition-name> [flags]

Flags:
      --attachment stringArray                  A file whose content will be attached to the workflow instance
      --comment string                          The comment
      --description string                      The description
      --due-date string                         The due date
      --next-task-assignee string               The next task assignee to use
      --parent-record-selection-filter string   The parent record selection filter to use
      --priority string                         The priority
      --selection-filter string                 The selection filter to use
      --start-event-name string                 The start event to use
      --startup-application-name string         The startup application to use

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List the Data Management workflow instances along with their details.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows workflow-instances [flags]
  sem dm workflows workflow-instances [command]

Aliases:
  workflow-instances, workflow-instance

Available Commands:
  get         Get a DM workflow instance
  kill        Terminate a DM workflow instance
  retry       Retry a DM workflow instance

Flags:
      --initiator-name string             Limit results to workflow instances having this initiator name
      --limit int                         Maximum number of returned results
      --offset int                        Offset of the first result
      --order-by string                   SemQL order by clause defining the order of the records in the response
      --startup-application-name string   Limit results to workflow instances having this startup application name
      --status string                     Limit results to workflow instances having this status
      --workflow-definition-name string   Limit results to workflow instances having this workflow definition name

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem dm workflows workflow-instances [command] --help" for more information about a command.

========================================================

Retrieve details for a Data Management workflow instance.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows workflow-instances get <workflow-instance-id> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Terminate a running Data Management workflow instance.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows workflow-instances kill <workflow-instance-id> [flags]

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Retry the execution of a failed Data Management workflow instance.


REST API documentation:
  <base-url>/dm/api/rest/api-ui/index.html?domain=workflow

Usage:
  sem dm workflows workflow-instances retry <workflow-instance-id> [flags]

Flags:
      --step-instance-id int   The step instance ID to retry

Global Flags:
      --data-location-name string   The Data Location name to use for this command
  -d, --debug                       Show debug information
      --force                       Ignore prompt and delete the specified resource
  -i, --input string                Use specified file instead of stdin
      --json                        Output as JSON
      --jsonr                       Output as raw JSON strings
  -o, --output string               Use specified file instead of stdout
      --path string                 JSONPath used to extract a subset of the response
  -p, --profile string              Profile to use for this execution
      --read-only                   Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Get the logs of the Semarchy Data Platform

Usage:
  sem logs [flags]

Aliases:
  logs, log

Flags:
      --after string         Display logs issued after this date (e.g. 2025-04-01 12:00:00)
      --before string        Filter logs issued before this date (e.g. 2025-04-01 12:00:00)
  -f, --follow               Continue streaming the new output from the platform
      --format string        Use the specified format to display the logs (SHORT, LONG) (default "SHORT")
      --last string          Display logs issued for the provided period (e.g. 1h, 15 minutes...) before the last log
      --level string         Display only logs with this level or higher (INFO, WARN, ERROR)
      --message string       Display only logs whose message contains the provided string
      --module stringArray   Filter the logs by module (DM, DG...). This option can be repeated.

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

List all profiles.

Usage:
  sem profiles [flags]
  sem profiles [command]

Aliases:
  profiles, profile

Available Commands:
  delete      Delete a profile
  read-only   Switch profile to read-only mode
  read-write  Switch profile to read-write mode
  rename      Rename a profile
  use         Show or set default profile

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

Use "sem profiles [command] --help" for more information about a command.

========================================================

Delete a profile.

Usage:
  sem profiles delete <profile-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Enable read-only mode for a profile.

Usage:
  sem profiles read-only [<profile-name>] [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Enable read-write mode for a profile.

Usage:
  sem profiles read-write [<profile-name>] [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Rename a profile.

Usage:
  sem profiles rename <profile-name> [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Show or set default profile.

Usage:
  sem profiles use [<profile-name>] [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.

========================================================

Print the version number of Semarchy Data Platform CLI.

Usage:
  sem version [flags]

Global Flags:
  -d, --debug            Show debug information
      --force            Ignore prompt and delete the specified resource
  -i, --input string     Use specified file instead of stdin
      --json             Output as JSON
      --jsonr            Output as raw JSON strings
  -o, --output string    Use specified file instead of stdout
      --path string      JSONPath used to extract a subset of the response
  -p, --profile string   Profile to use for this execution
      --read-only        Do not modify the Semarchy Data Platform. All modification requests will be rejected.
```
